const long long font[]= {
    0x000000000000,
	0x3E5B4F5B3E00,
	0x3E6B4F6B3E00,
	0x1C3E7C3E1C00,
	0x183C7E3C1800,
	0x1C577D571C00,
	0x1C5E7F5E1C00,
	0x00183C180000,
	0xFFE7C3E7FF00,
	0x001824180000,
	0xFFE7DBE7FF00,
	0x30483A060E00,
	0x262979292600,
	0x407F05050700,
	0x407F05253F00,
	0x5A3CE73C5A00,
	0x7F3E1C1C0800,
	0x081C1C3E7F00,
	0x14227F221400,
	0x5F5F005F5F00,
	0x06097F017F00,
	0x006689956A00,
	0x606060606000,
	0x94A2FFA29400,
	0x08047E040800,
	0x10207E201000,
	0x08082A1C0800,
	0x081C2A080800,
	0x1E1010101000,
	0x0C1E0C1E0C00,
	0x30383E383000,
	0x060E3E0E0600,
	0x000000000000,
	0x00005F000000,
	0x000700070000,
	0x147F147F1400,
	0x242A7F2A1200,
	0x231308646200,
	0x364956205000,
	0x000807030000,
	0x001C22410000,
	0x0041221C0000,
	0x2A1C7F1C2A00,
	0x08083E080800,
	0x008070300000,
	0x080808080800,
	0x000060600000,
	0x201008040200,
	0x3E5149453E00,
	0x00427F400000,
	0x724949494600,
	0x2141494D3300,
	0x1814127F1000,
	0x274545453900,
	0x3C4A49493100,
	0x412111090700,
	0x364949493600,
	0x464949291E00,
	0x000014000000,
	0x004034000000,
	0x000814224100,
	0x141414141400,
	0x004122140800,
	0x020159090600,
	0x3E415D594E00,
	0x7C1211127C00,
	0x7F4949493600,
	0x3E4141412200,
	0x7F4141413E00,
	0x7F4949494100,
	0x7F0909090100,
	0x3E4141517300,
	0x7F0808087F00,
	0x00417F410000,
	0x2040413F0100,
	0x7F0814224100,
	0x7F4040404000,
	0x7F021C027F00,
	0x7F0408107F00,
	0x3E4141413E00,
	0x7F0909090600,
	0x3E4151215E00,
	0x7F0919294600,
	0x264949493200,
	0x03017F010300,
	0x3F4040403F00,
	0x1F2040201F00,
	0x3F4038403F00,
	0x631408146300,
	0x030478040300,
	0x6159494D4300,
	0x007F41414100,
	0x020408102000,
	0x004141417F00,
	0x040201020400,
	0x404040404000,
	0x000307080000,
	0x205454784000,
	0x7F2844443800,
	0x384444442800,
	0x384444287F00,
	0x385454541800,
	0x00087E090200,
	0x18A4A49C7800,
	0x7F0804047800,
	0x00447D400000,
	0x2040403D0000,
	0x7F1028440000,
	0x00417F400000,
	0x7C0478047800,
	0x7C0804047800,
	0x384444443800,
	0xFC1824241800,
	0x18242418FC00,
	0x7C0804040800,
	0x485454542400,
	0x04043F442400,
	0x3C4040207C00,
	0x1C2040201C00,
	0x3C4030403C00,
	0x442810284400,
	0x4C9090907C00,
	0x4464544C4400,
	0x000836410000,
	0x000077000000,
	0x004136080000,
	0x020102040200,
	0x3C2623263C00,
	0x1EA1A1611200,
	0x3A4040207A00,
	0x385454555900,
	0x215555794100,
	0x225454784200, // a-umlaut
	0x215554784000,
	0x205455794000,
	0x0C1E52721200,
	0x395555555900,
	0x395454545900,
	0x395554545800,
	0x0000457C4100,
	0x0002457D4200,
	0x0001457C4000,
	0x7D1211127D00, // A-umlaut
	0xF0282528F000,
	0x7C5455450000,
	0x2054547C5400,
	0x7C0A097F4900,
	0x324949493200,
	0x3A4444443A00, // o-umlaut
	0x324A48483000,
	0x3A4141217A00,
	0x3A4240207800,
	0x009DA0A07D00,
	0x3D4242423D00, // O-umlaut
	0x3D4040403D00,
	0x3C24FF242400,
	0x487E49436600,
	0x2B2FFC2F2B00,
	0xFF0929F62000,
	0xC0887E090300,
	0x205454794100,
	0x0000447D4100,
	0x3048484A3200,
	0x384040227A00,
	0x007A0A0A7200,
	0x7D0D19317D00,
	0x2629292F2800,
	0x262929292600,
	0x30484D402000,
	0x380808080800,
	0x080808083800,
	0x2F10C8ACBA00,
	0x2F102834FA00,
	0x00007B000000,
	0x08142A142200,
	0x22142A140800,
	0xAA005500AA00,
	0xAA55AA55AA00,
	0x000000FF0000,
	0x101010FF0000,
	0x141414FF0000,
	0x1010FF00FF00,
	0x1010F010F000,
	0x141414FC0000,
	0x1414F700FF00,
	0x0000FF00FF00,
	0x1414F404FC00,
	0x141417101F00,
	0x10101F101F00,
	0x1414141F0000,
	0x101010F00000,
	0x0000001F1000,
	0x1010101F1000,
	0x101010F01000,
	0x000000FF1000,
	0x101010101000,
	0x101010FF1000,
	0x000000FF1400,
	0x0000FF00FF00,
	0x00001F101700,
	0x0000FC04F400,
	0x141417101700,
	0x1414F404F400,
	0x0000FF00F700,
	0x141414141400,
	0x1414F700F700,
	0x141414171400,
	0x10101F101F00,
	0x141414F41400,
	0x1010F010F000,
	0x00001F101F00,
	0x0000001F1400,
	0x000000FC1400,
	0x0000F010F000,
	0x1010FF10FF00,
	0x141414FF1400,
	0x1010101F0000,
	0x000000F01000,
	0xFFFFFFFFFF00,
	0xF0F0F0F0F000,
	0xFFFFFF000000,
	0x000000FFFF00,
	0x0F0F0F0F0F00,
	0x384444384400,
	0xFC4A4A4A3400, // sharp-s or beta
	0x7E0202060600,
	0x027E027E0200,
	0x635549416300,
	0x3844443C0400,
	0x407E201E2000,
	0x06027E020200,
	0x99A5E7A59900,
	0x1C2A492A1C00,
	0x4C7201724C00,
	0x304A4D4D3000,
	0x304878483000,
	0xBC625A463D00,
	0x3E4949490000,
	0x7E0101017E00,
	0x2A2A2A2A2A00,
	0x44445F444400,
	0x40514A444000,
	0x40444A514000,
	0x0000FF010300,
	0xE080FF000000,
	0x08086B6B0800,
	0x361236243600,
	0x060F090F0600,
	0x000018180000,
	0x000010100000,
	0x3040FF010100,
	0x001F01011E00,
	0x00191D171200,
	0x003C3C3C3C00,
	0x0000000000
};
long long Sgetnextupdate(unsigned char outchar[],unsigned int *startcol, unsigned int *startrow,unsigned int *maxcols,unsigned int *maxrows, unsigned long long screen[], unsigned long long displayed[]){
     union utype{
        unsigned long long b;
        unsigned char a[8];
    }in,out;
    signed long i,j,first[8],last[8],count,myreturn;
    count=1;
    outchar[1]=0x40;
    for(i=0;i<*maxrows;i++){
        first[i]=-1;
        last[i]=-1;
    }
    for (i=0;i<*maxcols;i++){
        in.b=screen[i];
        out.b=displayed[i];
        for(j=0;j<*maxrows;j++){
            if(in.a[j]!=out.a[j]){
                if(first[j]==-1){
                    first[j]=i;
                    last[j]=i;
                }
                else last[j]=i;
            }
        }
    }
    myreturn=-1;
    for(i=*maxrows-1;i>=0;i--){
        if(first[i]!=-1)myreturn=i; //find the first row with data
    }
    if(myreturn==-1)return 0;
    *startcol=first[myreturn];
    for (i=first[myreturn];i<=last[myreturn];i++){
        in.b=screen[i];
        out.b=displayed[i];
        count++;
        out.a[myreturn]=in.a[myreturn];
        outchar[count]=out.a[myreturn];
        displayed[i]=out.b;
    }
    *startrow=myreturn;
    outchar[0]=count;
    return count;
}
long long localfastfillrect(unsigned long long screen[],long long sense,long long x,
        long long y, long long width,long long height, long long rotation,
        long long screenwidth, unsigned char screenheight){
    long long xstart,xend,ystart,yend;
    long long i,j,k,top_row,bottom_row,top_start,bottom_end;
    union utype{
        unsigned long long b;
        unsigned char a[8];
    }work,ret;
         unsigned char tmaskarray[8],bmaskarray[9];
         unsigned char mask,topmask,bottommask;
         tmaskarray[0]=0b11111111;
         tmaskarray[1]=0b11111110;
         tmaskarray[2]=0b11111100;
         tmaskarray[3]=0b11111000;
         tmaskarray[4]=0b11110000;
         tmaskarray[5]=0b11100000;
         tmaskarray[6]=0b11000000;
         tmaskarray[7]=0b10000000;
         bmaskarray[0]=0x01;
         bmaskarray[1]=0x03;
         bmaskarray[2]=0x07;
         bmaskarray[3]=0x0F;
         bmaskarray[4]=0x1F;
         bmaskarray[5]=0x3F;
         bmaskarray[6]=0x7F;
         bmaskarray[7]=0xFF;
     if(rotation==0){
       xstart=x;
       if (xstart>=screenwidth)return 0; //nothing can be written
       xend=xstart+width-1;
       if (xend>=screenwidth)xend=screenwidth-1; //limit to screen dimensions
       ystart=y;
       if (ystart>=screenheight)return 0;
       yend=ystart+height-1;
       if (yend>=screenheight)xend=screenheight-1;
     }
     if(rotation==1){
      xend=screenwidth-x-1;
       if (xend<0) return 0; //nothing can be written
       xstart=xend-width+1;
       if(xstart<0) xstart=0;//limit to screen dimensions
       yend=screenheight-y-1;
       if (yend<0) return 0;
       ystart=yend-height+1;
       if(ystart<0)ystart=0;
     }
     if(rotation==2){
      xend=screenwidth-y-1;
       if (xend>=screenwidth)xend=screenwidth-1;
       xstart=xend-height+1;
       if(xstart<0) xstart=0;//limit to screen dimensions
       ystart=x;
       if (ystart>=screenheight)return 0; //nothing can be written
       yend=ystart+width-1;
       if (yend>=screenheight)yend=screenheight-1;
     }
      if(rotation==3){
     xstart=y;
       if (xstart>=screenwidth)return 0; //nothing can be written
       xend=xstart+height-1;
       if (xend>=screenwidth)xend=screenwidth-1; //limit to screen dimensions
       yend=screenheight-x-1;
       if (yend<0) return 0;
       ystart=yend-width+1;
       if(ystart<0)ystart=0;
      }

        top_row=ystart/8;
        bottom_row=yend/8;
        top_start=ystart-(top_row*8);
        bottom_end=yend-(bottom_row*8);
        if(top_row==bottom_row){
            for (i=xstart;i<=xend;i++){
             work.b=screen[i];
             if (sense) {
                 mask=tmaskarray[top_start] & bmaskarray[bottom_end];
                 work.a[top_row]=work.a[top_row] | mask;
             }
             else {
                 mask=~(tmaskarray[top_start]& bmaskarray[bottom_end]);
                 work.a[top_row]=work.a[top_row] & mask;
             }
             screen[i]=work.b;
            }
        }
        if((top_row+1)<=bottom_row){
            for (i=xstart;i<=xend;i++){
             work.b=screen[i];
             if (sense) {
                 topmask=tmaskarray[top_start];
                 work.a[top_row]=work.a[top_row] | topmask;
             }
             else {
                 topmask=~tmaskarray[top_start];
                 work.a[top_row]=work.a[top_row] & topmask;
             }
             if (sense) {
                 bottommask=bmaskarray[bottom_end];
                 work.a[bottom_row]=work.a[bottom_row] | bottommask;
             }
             else {
                 bottommask=~bmaskarray[bottom_end];
                 work.a[bottom_row]=work.a[bottom_row] & bottommask;
             }
            screen[i]=work.b;
            }
        }
        if (top_row+1<bottom_row){
            for(j=top_row+1;j<bottom_row;j++){
             for (i=xstart;i<=xend;i++){
               work.b=screen[i];
               if(sense) work.a[j]=0xFF;
               else work.a[j]=0;
               screen[i]=work.b;
             }
           }
        }

}
long long localdrawPixel( unsigned long long p_array[],long long onoff, long long x,
                    long long y, long long rotation, long long width, long long height){
    unsigned long long xp,yp;
     union utype{
        unsigned long long b;
        unsigned long a[2];
    }u;
    if(rotation==0){
       xp=x;
       yp=y;
    }
   if(rotation==1){
       xp=width-x-1;
       yp=height-y-1;
   }
   if(rotation==2){
       yp=x;
       xp=width-y-1;
    }
   if(rotation==3){
       yp=height-x-1;
       xp=y;
    }

    if ((xp<width) & (yp< height) & (xp>=0) & (yp>=0) ){
       if(onoff)  {
          u.b=0;
          if (yp<32)
             u.a[0]=1 << yp;
           else
              u.a[1]=1<<(yp-32);
          p_array[xp]=p_array[xp] | u.b;
       }
       else{
         if (yp<32){
           u.a[0]=~( 1 << yp);
           u.a[1]=~0;
         }
         else{
           u.a[1]=~(1<<(yp-32));
           u.a[0]=~0;
         }
         p_array[xp]=p_array[xp] & u.b;
        }

     }
    else return 0;
    u.a[0]=xp;
    u.a[1]=yp;
    return u.b;
}
long long drawline(unsigned long long sc[],long long onoff,long long xx0,long long yy0,
        long long xx1, long long yy1,long long rot,
        long long wi, long long ht){
 int dx,dy,x0=xx0,y0=yy0,x1=xx1,y1=yy1,err,ystep,xstep,dp,temp,steep;
// int steep=(abs(y1-y0))>(abs(x1-x0));
  if(y1>y0) ystep=y1-y0;
  else ystep=y0-y1;
  if(x1>x0) xstep=x1-x0;
  else xstep=x0-x1;
  steep=ystep>xstep;
  if (steep) {
//    swap(x0,y0)
      temp=x0;
      x0=y0;
      y0=temp;
//    swap(x1,y1)
      temp=x1;
      x1=y1;
      y1=temp;
  }
  if (x0>x1){
//    swap(x0,x1)
      temp=x0;
      x0=x1;
      x1=temp;
//    swap(y0,y1)
      temp=y0;
      y0=y1;
      y1=temp;
  }
  dx=x1-x0;
//  dy=abs(y1-y0);
  if(y1>y0) dy=y1-y0;
  else dy=y0-y1;
  err=dx / 2;
  if (y0<y1) {
    ystep=1;
  }
  else {
    ystep=-1;
  }
  while (x0<=x1){
    if (steep) {
      dp=localdrawPixel(sc,onoff,y0,x0,rot,wi,ht);
    }
    else {
      dp=localdrawPixel(sc,onoff,x0,y0,rot,wi,ht);
    }
    err=err-dy;
    if (err<0) {
      y0=y0+ystep;
      err=err+dx;
    }
    x0=x0+1;
  }
}
long long drawchar(unsigned long long sc[],long long thechar,long long x,
        long long y, long long sz,long long orientation,long long rot,
        long long wi, long long ht){
    unsigned int i,j,dp;
    union utype{
    unsigned long long b;
    unsigned long c[2];
    unsigned char a[8];
    }ch;
    ch.b=thechar; //get the character to be output
    if (orientation==0){ //normal
        for(i=0;i<=5;i++){
            for(j=0;j<=7;j++){
              if((ch.a[i]>>j)&1){
                  if(sz==1){
                     localdrawPixel(sc,1,x+5-i,y+j,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,1,x+(5-i)*sz,y+(j*sz),sz,sz,rot,wi,ht);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(sc,0,x+5-i,y+j,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,0,x+(5-i)*sz,y+(j*sz),sz,sz,rot,wi,ht);
                   }
              }
            }
        }

    }
    if (orientation==1){  //invert
       for(i=0;i<=5;i++){
            for(j=0;j<=7;j++){
              if(((ch.a[5-i])>>(7-j))&1){
                  if(sz==1){
                     localdrawPixel(sc,1,x-i,y+j-7,rot,wi,ht);
                   }
                   else{
                    dp=localfastfillrect(sc,1,x-sz+1-(i*sz),y-sz+1-(7-j)*sz,sz,sz,rot,wi,ht);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(sc,0,x-i,y+j-7,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,0,x-sz+1-(i*sz),y-sz+1-(7-j)*sz,sz,sz,rot,wi,ht);
                   }
              }
            }
        }

    }   if (orientation==2){  //rotate right
       for(i=0;i<=7;i++){
            for(j=0;j<=5;j++){
              if((ch.a[5-j]>>i)&1){
                  if(sz==1){
                     localdrawPixel(sc,1,x-i,y+j,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,1,x-sz+1-i*sz,y+(j)*sz,sz,sz,rot,wi,ht);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(sc,0,x-i,y+j,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,0,x-sz+1-i*sz,y+(j)*sz,sz,sz,rot,wi,ht);
                   }
              }
            }
        }

    }
    if (orientation==3){  //rotate left
       for(i=0;i<=7;i++){
            for(j=0;j<=5;j++){
              if((ch.a[j]>>(7-i))&1){
                  if(sz==1){
                     localdrawPixel(sc,1,x-i+7,y+j-5,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,1,x-i*sz+7*sz,y+j*sz-6*sz+1,sz,sz,rot,wi,ht);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(sc,0,x-i+7,y+j-5,rot,wi,ht);
                   }
                   else{
                     dp=localfastfillrect(sc,0,x-i*sz+7*sz,y+j*sz-6*sz+1,sz,sz,rot,wi,ht);
                   }
              }
            }
        }

    }
    return ch.b;
}
long long pstring(long long addroffont,long long x, long long y,long long sz,
        long long orientation, long long rotation, long long screen,
        long long sc[],unsigned char text[]){
    long *fonth,*fontl, width, height;
    long i,j;
        union utype{
    unsigned long long b;
    unsigned long a[2];
    }mychr;
    mychr.b=screen;
    width=mychr.a[0];
    height=mychr.a[1];
    for(i=1;i<=(long)text[0];i++)
    {
      fontl=addroffont+((long)text[i]*8);
      fonth=fontl+1;
      mychr.a[0]=*fontl;
      mychr.a[1]=*fonth;
//long long drawchar(unsigned long long sc[],long long thechar,long long x,
//        long long y, long long sz,long long orientation,long long rot,
//        long long wi, long long ht){
      j=drawchar(sc,mychr.b, x, y, sz, orientation,rotation,width,height);
      if(orientation==0) x=x+(6*sz);
      if(orientation==1) x=x-(6*sz);
      if(orientation==2) y=y+(6*sz);
      if(orientation==3) y=y-(6*sz);
    }
    return height;
}
long long main(long long *fn, long long *Arg1, long long *Arg2, long long *Arg3,
long long *Arg4, long long *Arg5,long long *Arg6, long long *Arg7,long long *Arg8, unsigned char *Arg9) {
    long long i;

    //Note 'if' statements are used rather than 'switch, case' because
    //'switch case' can generate 'peculiar' code resulting in JLR instructions
    //

    if (*fn==0x0){
//void localdrawPixel( unsigned long long p_array[],long long onoff, long long x,
//                   long long y, long long rotation, long long width, long long height){
        i=localdrawPixel(Arg1,(int)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,(int)*Arg6,(int)*Arg7);
        return(i);
    }
    if (*fn==0x1){
//long long localfastfillrect(unsigned long long screen[],long long sense,long long x,
//        long long y, long long width,long long height, long long rotation,
//        long long screenwidth, long long screenheight){
        i=localfastfillrect(Arg1,(int)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,(int)*Arg6,(int)*Arg7,(int)*Arg8,(int)*Arg9);
        return(i);
    }
    if (*fn==0x2){
//long long drawchar(unsigned long long sc[],long long thechar,long long x,
//        long long y, long long sz,long long orientation,long long rot,
//        long long wi, long long ht){
        i=drawchar(Arg1,(long long)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,(int)*Arg6,(int)*Arg7,(int)*Arg8,(int)*Arg9);
        return(i);
    }
    if (*fn==0x3){
        i=drawline(Arg1,(long long)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,(int)*Arg6,(int)*Arg7,(int)*Arg8,(int)*Arg9);
        return(i);
    }
    if (*fn==0x4){
        i=pstring((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,
                (long long)*Arg5,(long long)*Arg6,(long long)*Arg7,Arg8,Arg9);
        return(i);
    }
}
