' V1.0
' Graphics library with drivers for ST7753 T24 display
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub T24.setrot(x) ;T24_normal=normal, T24_inverse=invert, T24_rt_right=rotate right, T24_rt_left=rotate left
' draw circle: sub T24.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub T24.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub T24.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub T24.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub T24.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' draw line: sub T24.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub T24.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub T24.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub T24.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub T24.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option explicit
option default NONE
cpu 48
' 
  T24.initdisplay
do
  T24_test
loop
end
'
' ST7783 specific routines
'
sub T24.initdisplay
'Global "Constants"
  dim integer T24_CS=4 'b0
  dim integer T24_CD=5 'b1
  dim integer T24_WR=6 'b2
  dim integer T24_RD=7 'b3
  dim integer T24_RESET= 14 'b5
  dim integer T24_D0=17
  dim integer T24_D1=18
  dim integer T24_D2=21
  dim integer T24_D3=22
  dim integer T24_D4=23
  dim integer T24_D5=24
  dim integer T24_D6=25
  dim integer T24_D7=26
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer T24.pix=0
  dim integer T24.ffr=1
  dim integer T24.drawchar=2
  dim integer T24.drawline=3
  dim integer T24.writecommand=4
  dim integer T24.writedata=5
  dim integer T24.fastfillscreen=6
  dim integer T24.fpstring=7
  dim integer T24.fcirch=8
  dim integer T24_width=0 'location of width parameter in params array
  dim integer T24_height=1 'location of height parameter in params array
  dim integer T24_rotation=2 'location of rotation parameter in params array
  dim integer T24_normal=0
  dim integer T24_inverse=1
  dim integer T24_rt_right=2
  dim integer T24_rt_left=3
  ' Global variables
  dim integer T24_AddrOfFont,   T24_params(3) ' Global variables
  T24_AddrOfFont=PEEK(CFunAddr FONT)  
  local integer i
  T24_params(T24_width)=240
  T24_params(T24_height)=320
  pin(T24_CS)=1
  setpin T24_CS, DOUT
  pin(T24_CD)=1
  setpin T24_CD, DOUT
  pin(T24_WR)=1
  setpin T24_WR, DOUT
  pin(T24_RD)=1
  setpin T24_RD, DOUT
  pin(T24_RESET)=1
  setpin T24_RESET, DOUT'  Reset the display
  T24.setwrite
  pin(T24_RESET)=0
  pause 100
  pin(T24_RESET)=1
  pause 100
  T24.wreg(&HFF, 1)
  T24.wreg(&HF3, 8)
  i=T24draw(T24.writecommand, &HF3)
  T24.wreg(1, &H100)
  T24.wreg(2, &H700)
  T24.wreg(3, &H1030)
  T24.wreg(8, &H302)
  T24.wreg(9, 0)
  T24.wreg(&H10, 0)
  T24.wreg(&H11, 7)
  T24.wreg(&H12, 0)
  T24.wreg(&H13, 0)
  pause 20
  T24.wreg(&H10, &H14B0)
  pause 10
  T24.wreg(&H11, 7)
  pause 10
  T24.wreg(&H12, &H8E)
  T24.wreg(&H13, &HC00)
  T24.wreg(&H29, &H15)
  pause 10
  T24.wreg(&H30, 0)
  T24.wreg(&H31, &H107)
  T24.wreg(&H32, 0)
  T24.wreg(&H35, &H203)
  T24.wreg(&H36, &H402)
  T24.wreg(&H37, 0)
  T24.wreg(&H38, &H207)
  T24.wreg(&H39, 0)
  T24.wreg(&H3C, &H203)
  T24.wreg(&H3D, &H403)
  T24.wreg(&H50, 0)
  T24.wreg(&H51, &HEF)
  T24.wreg(&H52, 0)
  T24.wreg(&H53, &H13F)
  T24.wreg(&H60, &HA700)
  T24.wreg(&H61, 1)
  T24.wreg(&H90, &H29)
  T24.wreg(7, &H133)
  pause 50
  i=T24draw(T24.writecommand, &H22)
end sub
'
sub T24.wreg(register as integer, databyte as integer)
  local integer i
  i=T24draw(T24.writecommand, register)
  i=T24draw(T24.writedata, databyte)
end sub
'
function T24.rreg(register as integer) as integer
  local integer i
  i=T24draw(T24.writecommand, register)
  T24.setread
  T24.rreg= T24.readdata()
  T24.setwrite
end function
'
sub T24_fillscreen(scol as integer)
  local integer i=T24draw(T24.fastfillscreen, scol,  T24_params())
end sub
'
end sub
'
function  T24.readdata() as integer
  local integer i 
  pin(T24_CS)=0
  PIN(T24_CD)=1
  pin(T24_WR)=1
  pin(T24_RD)=0
  pause 1
  i=(port(17, 2, 21, 6))<<8
  pin(T24_RD)=1
  pin(T24_RD)=0
  pause 1
  i=i+port(17, 2, 21, 6)
  pin(T24_RD)=1
  pin(T24_CS)=1
  T24.readdata=i
end function
'
sub T24.setwrite
  setpin T24_CS, DOUT
  setpin T24_CD, DOUT
  setpin T24_WR, DOUT
  setpin T24_RD, DOUT
  setpin T24_RESET, DOUT'  Reset the display
  setpin T24_D0, dout
  setpin T24_D1, dout
  setpin T24_D2, dout
  setpin T24_D3, dout
  setpin T24_D4, dout
  setpin T24_D5, dout
  setpin T24_D6, dout
  setpin T24_D7, dout
end sub
'
sub T24.setread
  setpin T24_D0, din
  setpin T24_D1, din
  setpin T24_D2, din
  setpin T24_D3, din
  setpin T24_D4, din
  setpin T24_D5, din
  setpin T24_D6, din
  setpin T24_D7, din
end sub
'
' Generic drawing routines
'
sub T24.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp
  dp=T24draw(T24.pix, colour, x0, y0+r,  T24_params())
  dp=T24draw(T24.pix, colour, x0, y0-r,  T24_params())
  dp=T24draw(T24.pix, colour, x0+r, y0,  T24_params())
  dp=T24draw(T24.pix, colour, x0-r, y0,  T24_params())
  do while (x<y)
    if f>=0 then
  y=y-1
  ddF_y=ddF_y+2
  f=f+ddF_y
    endif
    x=x+1
    ddF_x=ddF_x+2
    f=f+ddF_x
    dp=T24draw(T24.pix, colour, x0+x, y0+y,  T24_params())
    dp=T24draw(T24.pix, colour, x0-x, y0+y,  T24_params())
    dp=T24draw(T24.pix, colour, x0+x, y0-y,  T24_params())
    dp=T24draw(T24.pix, colour, x0-x, y0-y,  T24_params())
    dp=T24draw(T24.pix, colour, x0+y, y0+x,  T24_params())
    dp=T24draw(T24.pix, colour, x0-y, y0+x,  T24_params())
    dp=T24draw(T24.pix, colour, x0+y, y0-x,  T24_params())
    dp=T24draw(T24.pix, colour, x0-y, y0-x,  T24_params())
  loop
end sub
 '
sub T24.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  T24.dline(x0, y0, x1, y1, colour)
  T24.dline(x1, y1, x2, y2, colour)
  T24.dline(x2, y2, x0, y0, colour)
end sub
 '
sub T24.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer a, b, y, dp, last
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if (y1>y2) then
    swap(y2, y1)
    swap(x2, x1)
  endif
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if(y0=y2) then ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    if(x1<a) then
  a=x1
    else
  if(x1>b) then b=x1
    endif
    if(x2<a) then
  a=x2
    else
  if(x2>b) then b=x2
    endif
    dp=T24draw(T24.ffr, colour, a, y0, 1, b-a+1,  T24_params()) 
    exit sub
  endif
    local integer  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  if(y1=y2) then
    last=y1 'Include y1 scanline
  else
     last=y1-1 ' Skip it
  endif
  for y=y0 to last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T24draw(T24.ffr, colour, a, y, b-a+1, 1,  T24_params()) 
  next y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  do while y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T24draw(T24.ffr, colour, a, y, b-a+1, 1,  T24_params()) 
    y=y+1
  loop
end sub
'
sub T24.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T24draw(T24.fpstring,T24_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T24_params(),text$)
end sub
'
sub T24.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=T24draw(T24.drawline, colour, xx0, yy0, xx1, yy1,  T24_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub T24.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=T24draw(T24.ffr, rcolour, x, y, w, 1,  T24_params()) 
  a=y+h-1
  dp=T24draw(T24.ffr, rcolour, x, a, w, 1,  T24_params()) 
  dp=T24draw(T24.ffr, rcolour, x, y, 1, h,  T24_params()) 
  a=x+w-1
  dp=T24draw(T24.ffr, rcolour, a, y, 1, h,  T24_params()) 
end sub
'
sub T24.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=T24draw(T24.ffr, rcolour, x, y, w, h,  T24_params()) 
end sub
'
FUNCTION T24.Getchar(char as integer) as integer
  local integer i=char<<3
  T24.Getchar=PEEK(WORD T24_AddrOfFont+i)+(PEEK(WORD T24_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub T24.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=T24draw(T24.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T24_params())
  dp=T24draw(T24.fcircH,x0, y0, r, 3, 0, ccolour, T24_params())
end sub
 '
sub T24.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T24draw(T24.ffr, rcolour, x+r, y, w-2*r, 1,  T24_params()) 
  dp=T24draw(T24.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T24_params()) 
  dp=T24draw(T24.ffr, rcolour, x, y+r, 1, h-2*r,  T24_params()) 
  dp=T24draw(T24.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T24_params()) 
  T24.dcircH(x+r, y+r, r, 1, rcolour)
  T24.dcircH(x+w-r-1, y+r, r, 2, rcolour)
  T24.dcircH(x+w-r-1, y+h-r-1, r, 4, rcolour)
  T24.dcircH(x+r, y+h-r-1, r, 8, rcolour)
end sub
 '
sub T24.dcircH( x0 as integer , y0 as integer , r as integer , cn as integer, colour as integer )
  local integer f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp
  do while (x<y)
    if (f>=0) then
  y=y-1
  ddF_y=ddF_y+2
  f=f+ddF_y
    endif
    x=x+1
    ddF_x=ddF_x+2
    f=f+ddF_x
    if (cn and 4) then
  dp=T24draw(T24.pix, colour, x0+x, y0+y,  T24_params())
  dp=T24draw(T24.pix, colour, x0+y, y0+x,  T24_params())
    endif
    if (cn and 2) then
  dp=T24draw(T24.pix, colour, x0+x, y0-y,  T24_params())
  dp=T24draw(T24.pix, colour, x0+y, y0-x,  T24_params())
    endif
    if (cn and 8) then
  dp=T24draw(T24.pix, colour, x0-y, y0+x,  T24_params())
  dp=T24draw(T24.pix, colour, x0-x, y0+y,  T24_params())
    endif
    if (cn and 1) then
  dp=T24draw(T24.pix, colour, x0-y, y0-x,  T24_params())
  dp=T24draw(T24.pix, colour, x0-x, y0-y,  T24_params())
    endif
  loop
end sub
 '
'sub T24.fcircH(x0 as integer, y0 as integer, r as integer, cn as integer, delta as integer, colour as integer)
'  local integer dp, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r
'  do while x<y
'    if f>=0 then
'  y=y-1
'  ddF_y=ddF_y+2
'  f=f+ddF_y
'    endif
'    x=x+1
'    ddF_x=ddF_x+2
'    f=f+ddF_x
'    if (cn and 1) then
'  dp=T24draw(T24.ffr, colour, x0+x, y0-y, 1, 2*y+1+delta,  T24_params()) 
'  dp=T24draw(T24.ffr, colour, x0+y, y0-x, 1, 2*x+1+delta,  T24_params()) 
'    endif
'    if (cn and 2) then
'  dp=T24draw(T24.ffr, colour, x0-x, y0-y, 1, 2*y+1+delta,  T24_params()) 
'  dp=T24draw(T24.ffr, colour, x0-y, y0-x, 1, 2*x+1+delta,  T24_params()) 
'    endif
'  loop
'end sub
'
sub T24.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T24draw(T24.ffr, colour, x+r, y, w-2*r, h,  T24_params()) 
  dp=T24draw(T24.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, T24_params());
  dp=T24draw(T24.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, T24_params());
end sub
 '
sub T24.setrot(x%) 'sets screen rotation: 0=T24_normal, 1=invert, 2=rotate right, 3-rotate left
   T24_params(T24_rotation)=(x% and 3)
end sub
'
'D:\Peter\MPLABXProjects\TFT24\dist\default\production\T24draw.bas

'
'T24draw  2014-12-17 10:09:01 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction T24draw
'writeCommand
	000006D6
	3c02bf88 24060001 ac466134 24030002 ac436134 24030004 ac436138 24050008 
	ac456138 ac436134 8c456130 30a500ff ac456130 8c456130 3087ff00 00e52825 
	ac456130 3c05bf81 8ca7f220 ac436138 8ca7f220 ac436134 8c476130 30e700ff 
	ac476130 8c476130 00042200 3084ffff 00872025 ac446130 8ca4f220 ac436138 
	ac466138 03e00008 00000000 

'writeData
3c02bf88 24060001 ac466134 24030002 ac436138 
	24030004 ac436138 24050008 ac456138 ac436134 8c456130 30a500ff ac456130 
	8c456130 3087ff00 00e52825 ac456130 3c05bf81 8ca7f220 ac436138 8ca7f220 
	ac436134 8c476130 30e700ff ac476130 8c476130 00042200 3084ffff 00872025 
	ac446130 8ca4f220 ac436138 ac466138 03e00008 00000000 

'fastfillscreen
27bdffe0 afbf001c 
	afb20018 afb10014 afb00010 3091ff00 00048200 3210ffff 8cb20000 8ca20008 
	72429002 24040020 0411FFAD 00000000 00002021 0411FFCD 00000000 24040021 
	0411FFA7 00000000 00002021 0411FFC7 00000000 24040022 0411FFA1 00000000 
	3c02bf88 24030001 ac436134 24030002 ac436138 24030004 ac436138 24030008 
	ac436138 1240001a 2652ffff 24030004 3c04bf81 2406ffff ac436134 8c456130 
	30a500ff ac456130 8c456130 02252825 ac456130 8c85f220 ac436138 8c85f220 
	ac436134 8c456130 30a500ff ac456130 8c456130 02052825 ac456130 8c85f220 
	ac436138 2652ffff 1646ffeb 00000000 24030001 3c02bf88 ac436138 8fbf001c 
	8fb20018 8fb10014 8fb00010 03e00008 27bd0020 

'localfastfillrect
27bdffa8 afbf0054 afbe0050 
	afb7004c afb60048 afb50044 afb40040 afb3003c afb20038 afb10034 afb00030 
	8faa0068 8fa9006c 8fac0070 8faf0074 8fad0078 8fae007c 8fa30080 8c6b0000 
	8c780008 8c680010 3096ff00 00042200 15000033 3095ffff 04e00005 00002021 
	1487012e 00cb102b 1040012d 00001021 24c2ffff 0046282b 24e3ffff 00a32821 
	004c1821 0062102b 00af2821 00451021 afa30018 04400008 0040a021 14820004 
	2562ffff 006b182b 14600003 00000000 afa20018 0000a021 05200005 00002021 
	1489011b 0158102b 1040011a 00001021 2542ffff 004a282b 2523ffff 00a32821 
	004d1821 0062102b 00ae2821 00451021 afa30028 0440012d afa20010 54820005 
	2703ffff 0078182b 54600129 01401021 2703ffff afa30018 10000124 0000a021 
	24030001 15030030 24030002 00063027 00073827 00cb5821 0166302b 00c73021 
	afab0018 00c0a021 00001021 00001821 afa20020 04c00107 afa30024 000a5027 
	00094827 0158c021 030a502b 01495021 afb80028 054000f3 afaa0010 24020001 
	004c6023 004c102b 00c23023 018b5821 016c602b 00cf7823 018f2021 00041fc3 
	00033827 000747c3 01681024 00402821 24020001 004d6823 004d102b 01425023 
	01b8c021 030d682b 014e7023 01ae1821 00033fc3 00074827 000957c3 030a3024 
	10000073 00c01021 1503003b 000a2027 00091827 008b1021 0044202b 00831821 
	afa20018 04600009 0060a021 14600005 2563ffff 004b102b 14400005 24020001 
	2563ffff afa30018 0000a021 24020001 004d2023 0044102b 02821023 8fa50018 
	00851821 0064c82b 004e1023 00602821 03222021 00041fc3 00038827 001197c3 
	00b21024 00402821 04e00005 00002021 148700b8 00d8102b 104000b7 00001021 
	24c2ffff 0046c82b 24e3ffff 0323c821 004c1821 0062102b 032fc821 00591021 
	afa30028 0440000b afa20010 54820005 2702ffff 0078182b 54600007 00c01021 
	2702ffff afa20028 afa00010 10000002 00c01021 00c01021 24030003 55030035 
	8fa30010 05200005 00001021 1449009e 014b182b 1060009d 00001821 2543ffff 
	006a282b 2524ffff 00a42021 006d6821 01a3182b 008e7021 006e1821 afad0018 
	04600009 0060a021 54430005 256bffff 01ab682b 55a00005 00063027 256bffff 
	afab0018 0000a021 00063027 00073827 00d8c021 0306302b 00c73821 afb80028 
	afa70010 00001021 00001821 afa20020 04e00080 afa30024 24020001 004c6023 
	004c102b 00e23823 0198c021 030c602b 00ef7823 03001021 018f1821 04610004 
	01402821 01402821 1000000a 0000f021 8fa30010 04600055 0040f021 54600006 
	afa50014 8fa30028 0062102b 54400050 afb70020 afa50014 00009821 0293902a 
	24100004 8fa20018 0045282b afa5002c 24040020 0411FE72 00000000 8fb10014 
	02202021 0411FE91 00000000 24040021 0411FE6B 00000000 03c02021 0411FE8B 
	00000000 24040022 0411FE65 00000000 3c02bf88 24030001 ac436134 24030002 
	ac436138 24030004 ac436138 24030008 ac436138 56400022 24030001 16740004 
	3c02bf88 8fa5002c 14a0001e 24030001 3c03bf81 ac506134 8c446130 308400ff 
	ac446130 8c446130 02c42025 ac446130 8c64f220 ac506138 8c64f220 ac506134 
	8c446130 308400ff ac446130 8c446130 02a42025 ac446130 8c77f220 ac506138 
	16400006 26310001 1674ffea 8fa50018 00b1202b 1080ffe7 00000000 24030001 
	3c02bf88 ac436138 8fa30010 04600007 27de0001 1663ffbf 24040020 8fa50028 
	00be102b 1040ffbb 00000000 afb70020 00001821 10000017 afa30024 00001021 
	00001821 afa20020 10000012 afa30024 00001021 00001821 afa20020 1000000d 
	afa30024 00001821 afa20020 10000009 afa30024 00001021 00001821 afa20020 
	10000004 afa30024 00001821 afa20020 afa30024 8fa20020 8fa30024 8fbf0054 
	8fbe0050 8fb7004c 8fb60048 8fb50044 8fb40040 8fb3003c 8fb20038 8fb10034 
	8fb00030 03e00008 27bd0058 01401021 1000ff49 00c02821 

'localdrawPixel
27bdffe0 afbf001c 
	afb20018 afb10014 afb00010 00808021 8fa80030 8fa40038 8c890000 8c8a0008 
	8c840010 14800006 8fa50034 00c08821 00e01021 01009021 10000019 00a01821 
	240b0001 148b000c 240b0002 00063027 00073827 00c98821 0226302b 00c71021 
	00084027 00052827 010a9021 0248402b 10000014 01051821 148b000a 240b0003 
	00c09021 00e01821 00084027 00052827 01098821 0228402b 1000000a 01051021 
	240b0003 148b0007 00063027 00073827 00ca9021 0246302b 00c71821 01008821 
	00a01021 14400004 24040001 0229482b 15200003 308400ff 00002021 308400ff 
	5080001f 00002021 14600004 24020001 024a502b 15400003 304200ff 00001021 
	304200ff 50400016 00002021 24040020 0411FDBB 00000000 02202021 0411FDDB 
	00000000 24040021 0411FDB5 00000000 02402021 0411FDD5 00000000 24040022 
	0411FDAF 00000000 02002021 0411FDCF 00000000 02202021 10000002 02402821 
	00002821 00801021 00a01821 8fbf001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0020 

'drawline
27bdffb8 afbf0044 afbe0040 afb7003c afb60038 afb50034 afb40030 
	afb3002c afb20028 afb10024 afb00020 afa40048 afa5004c 8fa20058 8fa30060 
	8fa40068 8fb60070 00c08021 00409021 00609821 0044a02a 00822823 00443823 
	00f4280a 00a0a021 00c3402a 00663823 00c32823 00e8280b 00b4a02a 12800005 
	0080a821 00809821 0060a821 00408021 00c09021 0270102a 10400008 0255102a 
	02401021 02a09021 0040a821 02001021 02608021 00409821 0255102a 10400007 
	0270b823 02b2a823 00178fc2 02378821 00118843 10000006 241e0001 0255a823 
	00178fc2 02378821 00118843 241effff 0270102a 14400020 8fbf0044 5280000d 
	afb20010 afb00010 001017c3 afa20014 afb60018 8fa40048 8fa5004c 02403021 
	00123fc3 0411FF54 00000000 1000000b 02358823 001217c3 afa20014 afb60018 
	8fa40048 8fa5004c 02003021 00103fc3 0411FF49 00000000 02358823 06210003 
	26100001 025e9021 02378821 0270102a 1040ffe2 8fbf0044 8fbe0040 8fb7003c 
	8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028 8fb10024 8fb00020 03e00008 
	27bd0048 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 
	afb30054 afb20050 afb1004c afb00048 0080b021 afa50038 00c0a021 afa7003c 
	8fb50080 8fa20088 8fbe0090 8fb70094 1aa0009f 02a08021 24130001 02759823 
	0015a823 0015a840 24120003 00008821 30430001 afa30040 30420002 afa20044 
	06600004 8fa40040 2610ffff 26b50002 02759821 10800043 26310001 00112fc3 
	afa50030 001047c3 afa80034 02363021 00d1382b 8fa90038 00a91021 02901823 
	0283202b 8fa9003c 01282823 00a42023 afa30010 afa40014 24040001 00002821 
	afa40018 afa5001c 00101840 24630001 00032fc3 007e2021 0083182b 00b72821 
	00651821 afa40020 afa30024 8fa500a0 afa50028 8fa40098 8fa5009c 00e23821 
	0411FD7C 00000000 02163021 00d0102b 8fa80034 8fa90038 01093821 02911823 
	0283202b 8fa8003c 8fa90030 01092823 00a42023 afa30010 afa40014 24040001 
	00002821 afa40018 afa5001c 001227c3 025e1821 0072282b 00972021 00a42021 
	afa30020 afa40024 8fa500a0 afa50028 8fa40098 8fa5009c 00473821 0411FD5D 
	00000000 8fa80044 11000045 0230102a 00114fc3 afa90030 001017c3 afa20034 
	02d13023 02c6102b 8fa30038 00693823 02901823 0283202b 8fa8003c 8fa90034 
	01092823 00a42023 afa30010 afa40014 24040001 00002821 afa40018 afa5001c 
	00101840 24630001 00032fc3 007e2021 0083182b 00b72821 00651821 afa40020 
	afa30024 8fa500a0 afa50028 8fa40098 8fa5009c 00e23823 0411FD36 00000000 
	02d03023 02c6102b 8fa80038 8fa90034 01093823 02911823 0283202b 8fa8003c 
	8fa90030 01092823 00a42023 afa30010 afa40014 24040001 00002821 afa40018 
	afa5001c 001227c3 025e1821 0072282b 00972021 00a42021 afa30020 afa40024 
	8fa500a0 afa50028 8fa40098 8fa5009c 00e23823 0411FD17 00000000 0230102a 
	10400003 02729821 1000ff6d 26520002 8fbf006c 8fbe0068 8fb70064 8fb60060 
	8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'drawchar
	27bdff58 afbf00a4 afbe00a0 afb7009c afb60098 afb50094 afb40090 afb3008c 
	afb20088 afb10084 afb00080 afa600b0 afa700b4 8fa200c0 afa20050 8fa300c4 
	afa30058 8fa600c8 afa6005c 8fa200cc afa20060 8fb000d0 8fb400d4 8fa300d8 
	afa30068 8fa600dc afa60070 afa40030 00661025 14400084 afa50034 8fa30050 
	24620005 0043182b afa20044 8fa40058 00641821 afa3004c 27b50030 24050005 
	afa50048 0200b021 0280b821 0200f021 10000060 afb40054 92a20000 02021007 
	30420001 10400022 24050001 24060001 57c60010 afb10010 8fa20054 5440000d 
	afb10010 afb20010 afb40014 8fa300e0 afa30018 8fa400b0 8fa500b4 8fa60044 
	8fa7004c 0411FE34 00000000 1000002f 26100001 afb30014 afb60018 afb7001c 
	afb60020 afb70024 8fa400e0 afa40028 8fa400b0 8fa500b4 8fa6003c 8fa70040 
	0411FCB4 00000000 10000020 26100001 57c50010 afb10010 8fa60054 54c0000d 
	afb10010 afb20010 afb40014 8fa200e0 afa20018 8fa400b8 8fa500bc 8fa60044 
	8fa7004c 0411FE14 00000000 1000000f 26100001 afb30014 afb60018 afb7001c 
	afb60020 afb70024 8fa300e0 afa30028 8fa400b8 8fa500bc 8fa6003c 8fa70040 
	0411FC94 00000000 26100001 02361021 0051182b 02779821 00408821 00739821 
	26420001 0052182b 00409021 24040008 1604ffb1 0074a021 8fa50048 24a5ffff 
	afa50048 8fa60044 24c2ffff 0046202b 8fa5004c 24a3ffff afa20044 00831821 
	afa3004c 8fa60048 2402ffff 10c200be 26b50001 8fa40048 009e0019 00001012 
	00001810 8fa50054 70a43002 00c31821 8fa50050 00452021 0082282b 8fa60058 
	00661021 afa4003c 00a21021 afa20040 8fb2005c 8fb40060 02408821 02809821 
	1000ff8d 00008021 24020001 8fa30068 146200a9 24020002 8fa40070 148000a6 
	00142023 00101023 0002182b afa20074 00832023 afa40078 8fa50050 24a20001 
	0045202b 8fa60058 00862021 00501823 0043102b 00942023 afa30054 00822023 
	afa40064 afa50048 afa6004c 27b60035 27a2002f afa20038 8fa3005c 2463fff9 
	afa3006c 8fa4005c 24820001 0044182b 8fa50060 00651821 0050a823 0055102b 
	00741823 00621823 afa30044 8fbe00e0 1000006f 02009021 92c20000 02021007 
	30420001 10400028 00000000 1657000e 02120019 1680000d 00001012 afb10010 
	afb30014 afbe0018 8fa400b0 8fa500b4 8fa60048 8fa7004c 0411FD97 00000000 
	1000003f 2610ffff 00001012 00001810 72902002 00831821 02a22023 02a4282b 
	8fa60044 00c31023 00452823 afa40010 afa50014 afb20018 afb4001c afb20020 
	afb40024 afbe0028 8fa400b0 8fa500b4 8fa6003c 8fa70040 0411FC0E 00000000 
	10000027 2610ffff 1657000e 02120019 1680000d 00001012 afb10010 afb30014 
	afbe0018 8fa400b8 8fa500bc 8fa60048 8fa7004c 0411FD70 00000000 10000018 
	2610ffff 00001012 00001810 72902002 00831821 02a22023 02a4282b 8fa60044 
	00c31023 00452823 afa40010 afa50014 afb20018 afb4001c afb20020 afb40024 
	afbe0028 8fa400b8 8fa500bc 8fa6003c 8fa70040 0411FBE7 00000000 2610ffff 
	26220001 0051182b 00408821 2402ffff 1602ffa9 00739821 8fa30054 8fa40074 
	00641021 0043182b 8fa50064 8fa60078 00a62021 afa20054 00642021 afa40064 
	8fa30048 2462ffff 0043182b 8fa5004c 24a4ffff afa20048 00642021 afa4004c 
	26d6ffff 8fa60038 52c600a6 02408021 8fa20054 afa2003c 8fa30064 afa30040 
	8fa4006c 8fa5005c 0085982b 8fa60060 24c2ffff 00808821 02629821 24100007 
	1000ff85 24170001 03c08021 8fb40054 24020002 8fa30068 14620093 24020003 
	8fa40070 14800091 8fa30068 00101023 0002182b 00142023 afa20064 00832023 
	afa40068 8fa50050 24a20001 0045202b 8fa60058 00862021 00501823 0043102b 
	00942023 afa30048 00822023 afa4004c afa00044 0200b021 0280b821 27a2002f 
	afa20038 0200f021 10000069 afb40054 92020000 02a21024 50400022 24020001 
	24030001 57c30010 afb10010 8fa40054 5480000d afb10010 afb20010 afb40014 
	8fa500e0 afa50018 8fa400b0 8fa500b4 8fa60050 8fa70058 0411FCF7 00000000 
	1000002f 2610ffff afb30014 afb60018 afb7001c afb60020 afb70024 8fa600e0 
	afa60028 8fa400b0 8fa500b4 8fa6003c 8fa70040 0411FB77 00000000 10000020 
	2610ffff 57c20010 afb10010 8fa30054 5460000d afb10010 afb20010 afb40014 
	8fa400e0 afa40018 8fa400b8 8fa500bc 8fa60050 8fa70058 0411FCD7 00000000 
	1000000f 2610ffff afb30014 afb60018 afb7001c afb60020 afb70024 8fa500e0 
	afa50028 8fa400b8 8fa500bc 8fa6003c 8fa70040 0411FB57 00000000 2610ffff 
	02361021 0051182b 02779821 00408821 00739821 26420001 0052182b 00409021 
	8fa60038 1606ffb2 0074a021 8fa20044 24420001 afa20044 8fa30048 8fa40064 
	00641021 0043202b 8fa5004c 8fa60068 00a61821 afa20048 00831821 afa3004c 
	8fa30050 2462ffff 0043202b 8fa50058 24a3ffff afa20050 00831821 afa30058 
	8fa60044 24020008 10c200d0 8fbf00a4 24030001 8fa40044 0083a804 8fa50048 
	afa5003c 8fa6004c afa60040 27b00035 8fb1005c 8fb30060 02209021 1000ff8c 
	0260a021 24020003 8fa30068 146200be 8fa40070 148000bc 00101023 0002182b 
	00142023 afa2006c 00832023 afa40070 00101742 001418c0 00431825 001020c0 
	00901023 0082202b 00741823 00641823 8fa50050 00452021 0082102b 8fa60058 
	00661821 afa4004c 00431821 afa30054 24a20007 0045182b afa20044 00661821 
	afa30058 24020007 afa20048 8fa3005c 24620001 0043282b 8fa40060 00a42821 
	00101823 0003202b 00143023 00c42023 00033782 00042080 00c43025 00032080 
	00901821 0064202b 00d43021 00862021 000337c2 00042040 00c42025 00031840 
	00431821 afa30064 0062102b 00a41821 00431821 afa30074 8fa5005c 24a5fffb 
	afa50068 8fa6005c 00a6182b 8fa40060 2482ffff 00621021 afa2005c 0280b021 
	10000068 0200a021 92020000 02e21024 10400021 24030001 24050001 5685000f 
	afb10010 56c0000d afb10010 afb20010 afb50014 8fa600e0 afa60018 8fa400b0 
	8fa500b4 8fa60044 8fa70058 0411FC3A 00000000 1000002e 26100001 afb30014 
	afb40018 afb6001c afb40020 afb60024 8fa200e0 afa20028 8fa400b0 8fa500b4 
	8fa60040 8fa70050 0411FABA 00000000 1000001f 26100001 5683000f afb10010 
	56c0000d afb10010 afb20010 afb50014 8fa400e0 afa40018 8fa400b8 8fa500bc 
	8fa60044 8fa70058 0411FC1B 00000000 1000000f 26100001 afb30014 afb40018 
	afb6001c afb40020 afb60024 8fa500e0 afa50028 8fa400b8 8fa500bc 8fa60040 
	8fa70050 0411FA9B 00000000 26100001 023e1021 0051182b 8fa6003c 02669821 
	00408821 00739821 26420001 0052182b 00409021 8fa20038 1602ffb3 0075a821 
	8fa30048 2463ffff afa30048 8fa4004c 8fa5006c 00851021 0044202b 8fa60054 
	8fa50070 00c51821 afa2004c 00831821 afa30054 8fa60044 24c2ffff 0046202b 
	8fa50058 24a3ffff afa20044 00831821 afa30058 2402ffff 8fa60048 10c20013 
	8fbf00a4 24170001 8fa20048 0057b804 8fa3004c afa30040 8fa40054 afa40050 
	27b00030 0280f021 afb6003c 8fb10064 8fb30074 8fb20068 8fb5005c 27a50036 
	1000ff89 afa50038 8fbf00a4 8fbe00a0 8fb7009c 8fb60098 8fb50094 8fb40090 
	8fb3008c 8fb20088 8fb10084 8fb00080 03e00008 27bd00a8 

'pstring
27bdff70 afbf008c 
	afbe0088 afb70084 afb60080 afb5007c afb40078 afb30074 afb20070 afb1006c 
	afb00068 afa4004c 00c08821 8fb200a0 8fb500a4 8fa200a8 afa20044 8fa300ac 
	afa30048 8fb400b0 8fa400b4 afa40040 8fb600cc 92c20000 18400079 00e09821 
	8fa50044 00051fc2 8fa60048 00061040 00621025 00052040 00042f82 00021880 
	00a31825 8fa60044 000628c0 00a42023 00a4282b 00621023 afa40054 00451023 
	afa20058 00061023 0002182b 8fa50048 00052023 00831823 00022782 00031880 
	00831825 00022080 00861021 0044202b 00651821 00831821 00022fc2 00031840 
	00021040 afa2005c 00a31825 afa30060 24100001 8fa60040 02863025 afa60050 
	02d01021 90420000 000210c0 8fa3004c 00431021 8c570000 8c5e0004 8fa400c0 
	8fa500c4 afa40010 afa50014 afb10018 afb3001c afb20020 afb50024 8fa50044 
	afa50028 8fa60048 afa6002c afb40030 8fa20040 afa20034 8fa300c8 afa30038 
	02e02021 03c02821 8fa600b8 8fa700bc 0411FCF3 00000000 8fa40050 14800009 
	24020001 8fa50054 02251021 0051182b 8fa60058 02669821 00408821 10000018 
	00739821 1682000a 8fa30040 14600008 8fa4005c 02241021 0051182b 8fa50060 
	02659821 00408821 10000018 00739821 24060002 1686000a 8fa20040 14400008 
	8fa30054 02431021 0052182b 8fa40058 02a4a821 00409021 1000000c 0075a821 
	24050003 16850009 8fa60040 14c00007 8fa3005c 02431021 0052182b 8fa40060 
	02a4a821 00409021 0075a821 26100001 92c20000 0050102a 1040ffb2 02d01021 
	02e01021 03c01821 8fbf008c 8fbe0088 8fb70084 8fb60080 8fb5007c 8fb40078 
	8fb30074 8fb20070 8fb1006c 8fb00068 03e00008 27bd0090 

'main
27bdffb8 afbf0044 
	afb00040 00808021 00e01021 8faa0058 8fa9005c 8fa80060 8fab0064 8c830000 
	8c840004 00643825 14e00010 8fac0068 8ca50000 8cc70000 8c420000 afa20010 
	000217c3 afa20014 afaa0018 00a02021 00052fc3 00e03021 00073fc3 0411FB0E 
	00000000 100000b7 8fbf0044 24070001 14670018 24070002 14800016 00000000 
	8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 
	8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 
	afa80028 0411F983 00000000 1000009d 8fbf0044 14670021 24070003 1480001f 
	00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c420000 afa20010 000217c3 
	afa20014 8d420000 afa20018 000217c3 afa2001c 8d220000 afa20020 000217c3 
	afa20024 8d020000 afa20028 000217c3 afa2002c 8d620000 afa20030 000217c3 
	afa20034 afac0038 0411FC5D 00000000 8e020000 1000007a 8e030004 14670019 
	24070004 14800017 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c420000 
	afa20010 000217c3 afa20014 8d420000 afa20018 000217c3 afa2001c 8d220000 
	afa20020 000217c3 afa20024 afa80028 0411FB1C 00000000 8e020000 10000060 
	8e030004 14670009 24070005 14800007 00000000 8ca40000 0411F8B1 00000000 
	8e020000 10000056 8e030004 14670009 24070006 14800007 00000000 8ca40000 
	0411F8CA 00000000 8e020000 1000004c 8e030004 1467000a 24070007 14800008 
	00000000 8ca40000 00c02821 0411F8E2 00000000 8e020000 10000041 8e030004 
	14670022 24070008 14800020 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 
	8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 
	8d620000 8d630004 afa20030 afa30034 afac0038 8fa2006c afa2003c 0411FEAE 
	00000000 1000001f 8fbf0044 1467001d 8fbf0044 5480001c 8fb00040 8ca40000 
	8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 
	8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 
	8d030004 afa20028 afa3002c afab0030 0411FB24 00000000 8e020000 8e030004 
	8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
	7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
	c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
	79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
	1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
	7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
	7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
	10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
	a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
	54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
	55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
	457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
	55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
	44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
	a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
	49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
	54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
	0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
	4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
	2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
	5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
	14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
	f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
	1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
	101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
	10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
	fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
	14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
	14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
	00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
	101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
	ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
	4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
	443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
	492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
	5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
	5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
	ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
	18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
	1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
End CFunction
'
sub T24_test
  dim integer XP=2
  dim integer XM=9
  dim integer YP=3
  dim integer YM=10
  local integer xint,yint,colour=red
  T24.setrot(0)
  preparescreen
do
  setpin XP,ain
  setpin XM,DOUT
  pin(XM)=0
  SETPIN YM,DIN,pullup
  setpin YP,AIN
  do while pin(YM)=1
  loop
  readtouch(xint,yint)
  poke word &HBF886114,3 'Overcome firmware bug  
  poke word &HBF886104,3  
  if xint>=0 and yint>30 and xint<=239 and yint<=319 then 
    T24.fcirc(xint,yint,3,colour)
  else
    if yint>319 and xint<30 then 
      preparescreen
    else
      if yint<=30 then
        if xint<30 then colour=red
        if xint >=30 and xint<60 then colour=blue
        if xint >=60 and xint<90 then colour=green
        if xint >=90 and xint<120 then colour=magenta
        if xint >=120 and xint<150 then colour=cyan
        if xint >=150 and xint<180 then colour=yellow
        if xint >=180 and xint<210 then colour=white
        if xint >=210 then colour=black
      endif
    endif
  endif
loop
end sub
'
sub preparescreen
  T24_fillscreen(black)
  T24.FRECT(0,0,30,30,red)
  T24.FRECT(30,0,30,30,blue)
  T24.FRECT(60,0,30,30,green)
  T24.FRECT(90,0,30,30,magenta)
  T24.FRECT(120,0,30,30,cyan)
  T24.FRECT(150,0,30,30,yellow)
  T24.FRECT(180,0,30,30,white)
  T24.FRECT(210,0,30,30,black)
  t24.frect(0,30,240,1,white)
  T24.drect(0, 0, T24_params(T24_width), T24_params(T24_height), white)
end sub
'
sub readtouch(xpos as integer,ypos as integer)
  const xstart=0.346774
  const xend=2.82473
  const ystart=.21828
  const yend=2.82258
  local integer xvalues(3),yvalues(3)
  local integer i=2
  do while i>=0
    setpin XP,DOUT
    pin(XP)=1
    SETPIN XM,DOUT
    PIN(XM)=0
    SETPIN YM,off
    SETPIN YP,AIN
    xvalues(i)=(pin(YP)-xstart)/(xend-xstart)*240
    setpin YP,dout
    pin(YP)=1
    setpin YM,DOUT
    pin(YM)=0
    setpin XM,off
    SETPIN XP,AIN
    yvalues(i)=(pin(XP)-ystart)/(yend-ystart)*320
    i=i-1
  loop
  xpos=filter(xvalues())
  ypos=filter(yvalues())
end sub
'
function filter(values() as integer) as integer
  local integer AB,BC,AC
  AB=abs(values(0)-values(1))
  BC=ABS(values(1)-values(2))
  AC=ABS(values(0)-values(2))
  if AB<=BC and AB<=AC then filter=(values(0)+values(1))\2
  if BC<=AB and BC<=AC then filter=(values(1)+values(2))\2
  IF AC<=AB and AC<=BC then filter=(values(0)+values(2))\2
end function
