' V1.0
' Graphics library with drivers for ST7755R T18 display
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub T18.setrot(x) ;T18_normal=normal, T18_inverse=invert, T18_rt_right=rotate right, T18_rt_left=rotate left
' draw circle: sub T18.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub T18.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub T18.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub T18.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub T18.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' draw line: sub T18.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub T18.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub T18.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub T18.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub T18.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option default none
option explicit
cpu 48

T18.init
T18_test
end
'
sub T18.init
'Global "Constants"
  const T18_CS=6
  const T18_CD=4
  const T18_RESET=5
  const ST7735_NOP =&H0
  const ST7735_SWRESET =&H01
  const ST7735_RDDID =&H04
  const ST7735_RDDST =&H09
  const ST7735_SLPIN  =&H10
  const ST7735_SLPOUT  =&H11
  const ST7735_PTLON  =&H12
  const ST7735_NORON  =&H13
  const ST7735_INVOFF =&H20
  const ST7735_INVON =&H21
  const ST7735_DISPOFF =&H28
  const ST7735_DISPON =&H29
  const ST7735_CASET =&H2A
  const ST7735_RASET =&H2B
  const ST7735_RAMWR =&H2C
  const ST7735_RAMRD =&H2E
  const ST7735_COLMOD =&H3A
  DIM integer ST7735_MADCTL =&H36
  const ST7735_FRMCTR1 =&HB1
  const ST7735_FRMCTR2 =&HB2
  const ST7735_FRMCTR3 =&HB3
  const ST7735_INVCTR =&HB4
  const ST7735_DISSET5 =&HB6
  const ST7735_PWCTR1 =&HC0
  const ST7735_PWCTR2 =&HC1
  const ST7735_PWCTR3 =&HC2
  const ST7735_PWCTR4 =&HC3
  const ST7735_PWCTR5 =&HC4
  const ST7735_VMCTR1 =&HC5
  const ST7735_RDID1 =&HDA
  const ST7735_RDID2 =&HDB
  const ST7735_RDID3 =&HDC
  const ST7735_RDID4 =&HDD
  const ST7735_PWCTR6 =&HFC
  const ST7735_GMCTRP1 =&HE0
  const ST7735_GMCTRN1 =&HE1
'  
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer T18.pix=0
  dim integer T18.ffr=1
  dim integer T18.drawchar=2
  dim integer T18.drawline=3
  dim integer T18.wcom=4
  dim integer T18.wdata=5
  dim integer T18.fastfillscreen=6
  dim integer T18.fpstring=7
  dim integer T18.fcirch=8
  dim integer T18.dcirch=9
  dim integer T18_normal=0
  dim integer T18_inverse=1
  dim integer T18_rt_right=2
  dim integer T18_rt_left=3
  dim integer T18_AddrOfFont, T18_params(6) ' Global variables
  DIM integer T18_wi=0,T18_ht=1,T18_rot=2,T18_nr=3,T18_X=4,T18_Y=5,T18_seed=6  
  local integer i
  spi open 10000000,3,8
  T18_Params(T18_wi)=128
  T18_params(T18_ht)=160
  T18_AddrOfFont=PEEK(CFunAddr FONT)  
  pin(T18_CS)=1
  setpin T18_CS, DOUT
  pin(T18_CD)=1
  setpin T18_CD, DOUT
  pin(T18_RESET)=1
  setpin T18_RESET, DOUT'  Reset the display
  pin(T18_RESET)=0
  pause 100
  pin(T18_RESET)=1
  pause 100
  i=T18draw(T18.wcom,ST7735_SWRESET)'software reset
  pause 150
  i=T18draw(T18.wcom,ST7735_SLPOUT)'out of sleep mode
  pause 500
  i=T18draw(T18.wcom,ST7735_FRMCTR1)'frame rate control - normal mode
  i=T18draw(T18.wdata,&H01)'frame rate = fosc / (1 x 2 + 40) * (LINE + 2C + 2D)
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_FRMCTR2)'frame rate control - idle mode
  i=T18draw(T18.wdata,&H01)'frame rate = fosc / (1 x 2 + 40) * (LINE + 2C + 2D)
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_FRMCTR3)'frame rate control - partial mode
  i=T18draw(T18.wdata,&H01)'dot inversion mode
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wdata,&H01)'line inversion mode
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_INVCTR)'display inversion control
  i=T18draw(T18.wdata,&H07)'no inversion
  i=T18draw(T18.wcom,ST7735_PWCTR1)'power control
  i=T18draw(T18.wdata,&HA2)'
  i=T18draw(T18.wdata,&H02)'-4.6V
  i=T18draw(T18.wdata,&H84)' Auto
  i=T18draw(T18.wcom,ST7735_PWCTR2)'power control
  i=T18draw(T18.wdata,&HC5)'VGH25 = 2.4C VGSEL = -10 VGH = 3 * AVDD
  i=T18draw(T18.wcom,ST7735_PWCTR3)'power control
  i=T18draw(T18.wdata,&H0A)'Opamp current small 
  i=T18draw(T18.wdata,&H00)'Boost frequency
  i=T18draw(T18.wcom,ST7735_PWCTR4)'power control
  i=T18draw(T18.wdata,&H8A)'BCLK/2, Opamp current small & Medium low
  i=T18draw(T18.wdata,&H2A)     
  i=T18draw(T18.wcom,ST7735_PWCTR5)'power control
  i=T18draw(T18.wdata,&H8A)'    
  i=T18draw(T18.wdata,&H2A)'     
  i=T18draw(T18.wcom,ST7735_VMCTR1)'power control
  i=T18draw(T18.wdata,&H0E)'  
  i=T18draw(T18.wcom,ST7735_INVOFF)'don't invert display
  i=T18draw(T18.wcom,ST7735_MADCTL)'memory access control (directions)
  i=T18draw(T18.wdata,&HC0)'row address/col address, bottom to top refresh
  i=T18draw(T18.wcom,ST7735_COLMOD)'set color mode
  i=T18draw(T18.wdata,&H05)'16-bit color
  i=T18draw(T18.wcom,ST7735_CASET)'column addr set
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H00)'XSTART = 0
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H7F)'XEND = 127
  i=T18draw(T18.wcom,ST7735_RASET)'row addr set
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H00)'XSTART = 0
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H9F)'XEND = 159
  i=T18draw(T18.wcom,ST7735_GMCTRP1)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H1a)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H18)
  i=T18draw(T18.wdata,&H2f)
  i=T18draw(T18.wdata,&H28)
  i=T18draw(T18.wdata,&H20)
  i=T18draw(T18.wdata,&H22)
  i=T18draw(T18.wdata,&H1f)
  i=T18draw(T18.wdata,&H1b)
  i=T18draw(T18.wdata,&H23)
  i=T18draw(T18.wdata,&H37)
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H07)
  i=T18draw(T18.wdata,&H02)
  i=T18draw(T18.wdata,&H10)
  i=T18draw(T18.wcom,ST7735_GMCTRN1)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H1b) 
  i=T18draw(T18.wdata,&H0f) 
  i=T18draw(T18.wdata,&H17) 
  i=T18draw(T18.wdata,&H33) 
  i=T18draw(T18.wdata,&H2c) 
  i=T18draw(T18.wdata,&H29) 
  i=T18draw(T18.wdata,&H2e) 
  i=T18draw(T18.wdata,&H30) 
  i=T18draw(T18.wdata,&H30) 
  i=T18draw(T18.wdata,&H39) 
  i=T18draw(T18.wdata,&H3f) 
  i=T18draw(T18.wdata,&H00) 
  i=T18draw(T18.wdata,&H07) 
  i=T18draw(T18.wdata,&H03) 
  i=T18draw(T18.wdata,&H10) 
  i=T18draw(T18.wcom,ST7735_DISPON)
  Pause 100
  i=T18draw(T18.wcom,ST7735_NORON)'normal display on
  pause 10
  T18.setrot(0)
  T18.fillscreen(black)
end sub
'
sub T18.setrot(x%) 'sets screen rotation: 0=T18_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer R(3)=(&HC0,&H00,&HA0,&H60)
   x%=x% and 3
   local integer i=x% \ 2 '0 for portrait, 1 for landscape
   local integer j=T18_params(T18_rot)\2 
   if i<>j then 'swap height and width if landscape
     local integer k=T18_params(T18_wi)
     T18_params(T18_wi)=T18_params(T18_ht)
     T18_params(T18_ht)=k
   endif  
   T18_params(T18_rot)=x%
   i=T18draw(T18.wcom,ST7735_MADCTL)'memory access control (directions)
   i=T18draw(T18.wdata,R(x%))
end sub
'
' Generic drawing routines
'
sub T18.fillscreen(scol as integer)
  local integer i=T18_params(T18_rot)
  T18_params(T18_rot)=T18_normal
  local integer j=T18draw(T18.ffr,scol, 0,0,T18_params(T18_wi),T18_params(T18_ht), T18_params())
  T18_params(T18_rot)=i
end sub
'
sub T18.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=T18draw(T18.dcirch, colour,x0,y0,r,31,T18_params())

end sub
 '
sub T18.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  T18.dline(x0, y0, x1, y1, colour)
  T18.dline(x1, y1, x2, y2, colour)
  T18.dline(x2, y2, x0, y0, colour)
end sub
 '
sub T18.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer a, b, y, dp, last
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if (y1>y2) then
    swap(y2, y1)
    swap(x2, x1)
  endif
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if(y0=y2) then ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    if(x1<a) then
  a=x1
    else
  if(x1>b) then b=x1
    endif
    if(x2<a) then
  a=x2
    else
  if(x2>b) then b=x2
    endif
    dp=T18draw(T18.ffr, colour, a, y0, 1, b-a+1,  T18_params()) 
    exit sub
  endif
    local integer  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  if(y1=y2) then
    last=y1 'Include y1 scanline
  else
     last=y1-1 ' Skip it
  endif
  for y=y0 to last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T18draw(T18.ffr, colour, a, y, b-a+1, 1,  T18_params()) 
  next y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  do while y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T18draw(T18.ffr, colour, a, y, b-a+1, 1,  T18_params()) 
    y=y+1
  loop
end sub
'
sub T18.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T18draw(T18.fpstring,T18_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T18_params(),text$)
end sub
'
sub T18.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=T18draw(T18.drawline, colour, xx0, yy0, xx1, yy1,  T18_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub T18.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=T18draw(T18.ffr, rcolour, x, y, w, 1,  T18_params()) 
  a=y+h-1
  dp=T18draw(T18.ffr, rcolour, x, a, w, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x, y, 1, h,  T18_params()) 
  a=x+w-1
  dp=T18draw(T18.ffr, rcolour, a, y, 1, h,  T18_params()) 
end sub
'
sub T18.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=T18draw(T18.ffr, rcolour, x, y, w, h,  T18_params()) 
end sub
'
FUNCTION T18.Getchar(char as integer) as integer
  local integer i=char<<3
  T18.Getchar=PEEK(WORD T18_AddrOfFont+i)+(PEEK(WORD T18_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub T18.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=T18draw(T18.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T18_params())
  dp=T18draw(T18.fcircH,x0, y0, r, 3, 0, ccolour, T18_params())
end sub
 '
sub T18.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T18draw(T18.ffr, rcolour, x+r, y, w-2*r, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x, y+r, 1, h-2*r,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T18_params()) 
  dp=T18draw(T18.dcirch, rcolour, x+r, y+r, r, 1,T18_params())
  dp=T18draw(T18.dcirch,  rcolour, x+w-r-1, y+r, r, 2,T18_params())
  dp=T18draw(T18.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,T18_params())
  dp=T18draw(T18.dcirch,  rcolour, x+r, y+h-r-1, r, 8,T18_params())
end sub
'
sub T18.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T18draw(T18.ffr, colour, x+r, y, w-2*r, h,  T18_params()) 
  dp=T18draw(T18.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, T18_params())
  dp=T18draw(T18.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, T18_params())
end sub
'
'D:\Peter\MPLABXProjects\TFT18\dist\default\production\T18draw.bas

'
'T18draw  2014-12-18 18:30:40 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction T18draw
'writeCommand
	00000804
	3c02bf88 24030004 ac436134 24030001 ac436134 3c03bf80 8c625810 30420008 
	1040fffd 3c02bf80 ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 
	24030004 ac436138 3c02bf80 8c425820 03e00008 00000000 

'writeData
3c02bf88 24030004 
	ac436134 24030001 ac436138 3c03bf80 8c625810 30420008 1040fffd 3c02bf80 
	ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24030004 ac436138 
	3c02bf80 8c425820 03e00008 00000000 

'localfastfillrect
27bdffc8 afbf0034 afbe0030 afb7002c 
	afb60028 afb50024 afb40020 afb3001c afb20018 afb10014 afb00010 8fa30048 
	8fa5004c 8faf0058 8fae005c 8fa20060 8c4a0000 8c490004 8c4b0008 8c4c000c 
	7c913a00 309000ff 24c8ffff 0106202b 24e2ffff 00821021 8fad0050 010d6821 
	01a8402b 8fa40054 00441021 01024021 01a09021 04e00004 01001021 00c0a021 
	1000000a 00e0a821 24d20002 0246302b 00c73821 01b29021 024d682b 01074021 
	01a81021 0000a021 0000a821 0049202a 1480000b 2466ffff 55220005 2552ffff 
	024a202b 14800007 00c3382b 2552ffff 024a202b 2522ffff 00821021 2466ffff 
	00c3382b 24a4ffff 00e42021 00cf3821 00e6302b 008e7021 00ce3021 00e09821 
	04a00004 00c02021 0060b021 1000000a 00a0b821 24730002 0263182b 00652821 
	00f39821 0267382b 00c53021 00e62021 0000b021 0000b821 008c182a 1460000a 
	00000000 55840005 2573ffff 026b182b 14600005 00000000 2573ffff 026b202b 
	2583ffff 00832021 1c400005 00000000 54400067 00002021 52400065 00002021 
	1c800005 02a9102a 14800063 00002021 12600067 00002821 54400005 02ec102a 
	1535005f 028a502b 1140005d 02ec102a 54400007 24020001 1597005c 00002021 
	02cb582b 1160005a 00002821 24020001 0054f023 03d2f021 02761023 24420001 
	73c2f002 2404002a 00002821 0411FF54 00000000 00002021 00002821 0411FF66 
	00000000 328400ff 00002821 0411FF62 00000000 00002021 00002821 0411FF5E 
	00000000 324400ff 00002821 0411FF5A 00000000 2404002b 00002821 0411FF40 
	00000000 00002021 00002821 0411FF52 00000000 32c400ff 00002821 0411FF4E 
	00000000 00002021 00002821 0411FF4A 00000000 326400ff 00002821 0411FF46 
	00000000 2404002c 00002821 0411FF2C 00000000 3c02bf88 24030001 ac436138 
	13c00018 3c02bf80 27c6ffff 3c05bf88 24040004 aca46134 ac515820 8c435810 
	30630080 1060fffd 00000000 aca46138 8c435820 aca46134 ac505820 8c435810 
	30630080 1060fffd 00000000 aca46138 8c435820 50c00004 03c02021 1000ffed 
	24c6ffff 03c02021 10000009 00002821 10000007 00002821 10000005 00002821 
	00002021 10000002 00002821 00002821 00801021 00a01821 8fbf0034 8fbe0030 
	8fb7002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 8fb00010 
	03e00008 27bd0038 

'colourrect
27bdffc8 afbf0034 afbe0030 afb7002c afb60028 afb50024 
	afb40020 afb3001c afb20018 afb10014 afb00010 00808021 8fa30048 8fa5004c 
	8faf0058 8fae005c 8fa20060 8c4b0000 8c490004 8c4c0008 8c4a000c 24c8ffff 
	0106202b 24e2ffff 00821021 8fad0050 010d6821 01a8402b 8fa40054 00441021 
	01024021 01a08821 04e00004 01001021 00c0a021 1000000a 00e0a821 24d10002 
	0226302b 00c73821 01b18821 022d682b 01074021 01a81021 0000a021 0000a821 
	0049202a 1480000b 2466ffff 55220005 2571ffff 022b202b 14800007 00c3382b 
	2571ffff 022b202b 2522ffff 00821021 2466ffff 00c3382b 24a4ffff 00e42021 
	00cf3821 00e6302b 008e2021 00c43021 00e09021 04a00004 00c02021 0060b021 
	1000000a 00a0b821 24720002 0243182b 00652821 00f29021 0247382b 00c53021 
	00e62021 0000b021 0000b821 008a182a 1460000a 00000000 55440005 2592ffff 
	024c182b 14600005 00000000 2592ffff 024c202b 2543ffff 00832021 1c400005 
	00000000 54400068 00002021 52200066 00002021 1c800005 02a9102a 14800064 
	00002021 12400068 00002821 54400005 02ea102a 15350060 028b582b 1160005e 
	02ea102a 14400007 241e0001 1557005d 00002021 02cc602b 1180005b 00002821 
	241e0001 03d49823 02719821 02561023 24420001 72629802 2404002a 00002821 
	0411FE77 00000000 00002021 00002821 0411FE89 00000000 328400ff 00002821 
	0411FE85 00000000 00002021 00002821 0411FE81 00000000 322400ff 00002821 
	0411FE7D 00000000 2404002b 00002821 0411FE63 00000000 00002021 00002821 
	0411FE75 00000000 32c400ff 00002821 0411FE71 00000000 00002021 00002821 
	0411FE6D 00000000 324400ff 00002821 0411FE69 00000000 2404002c 00002821 
	0411FE4F 00000000 3c02bf88 ac5e6138 1260001a 3c02bf80 00003021 3c05bf88 
	24040004 8e030000 7c683a00 306700ff aca46134 ac485820 8c435810 30630080 
	1060fffd 00000000 aca46138 8c435820 aca46134 ac475820 8c435810 30630080 
	1060fffd 00000000 aca46138 8c435820 24c60001 14d3ffeb 26100008 02602021 
	10000009 00002821 10000007 00002821 10000005 00002821 00002021 10000002 
	00002821 00002821 00801021 00a01821 8fbf0034 8fbe0030 8fb7002c 8fb60028 
	8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 8fb00010 03e00008 27bd0038 

'localdrawPixel
	27bdffd8 afbf0024 afb40020 afb3001c afb20018 afb10014 afb00010 00809821 
	00c09021 00e08021 8fb40038 8fb1003c 8fa20040 00f12827 00052fc2 8c430004 
	00e3182a 14600009 24040001 8c430004 54670006 00002021 8c430000 00c3182b 
	54600003 8c46000c 00002021 8c46000c 0226302a 14c00009 24030001 8c46000c 
	54d10006 00001821 8c420008 0282102b 14400003 00831824 00001821 00831824 
	00651824 00002021 10600039 00002821 2404002a 00002821 0411FDE9 00000000 
	00002021 00002821 0411FDFB 00000000 02402021 02002821 0411FDF7 00000000 
	00002021 00002821 0411FDF3 00000000 26440001 0092282b 00b02821 0411FDEE 
	00000000 2404002b 00002821 0411FDD4 00000000 00002021 00002821 0411FDE6 
	00000000 02802021 02202821 0411FDE2 00000000 00002021 00002821 0411FDDE 
	00000000 26840001 0094282b 00b12821 0411FDD9 00000000 2404002c 00002821 
	0411FDBF 00000000 7e643a00 00002821 0411FDD1 00000000 326400ff 00002821 
	0411FDCD 00000000 24040001 00002821 00801021 00a01821 8fbf0024 8fb40020 
	8fb3001c 8fb20018 8fb10014 8fb00010 03e00008 27bd0028 

'drawline
27bdffb8 afbf0044 
	afbe0040 afb7003c afb60038 afb50034 afb40030 afb3002c afb20028 afb10024 
	afb00020 afa40048 afa5004c 8fa20058 8fa30060 8fa40068 8fb60070 00c08021 
	00409021 00609821 0044a02a 00822823 00443823 00f4280a 00a0a021 00c3402a 
	00663823 00c32823 00e8280b 00b4a02a 12800005 0080a821 00809821 0060a821 
	00408021 00c09021 0270102a 10400008 0255102a 02401021 02a09021 0040a821 
	02001021 02608021 00409821 0255102a 10400007 0270b823 02b2a823 00178fc2 
	02378821 00118843 10000006 241e0001 0255a823 00178fc2 02378821 00118843 
	241effff 0270102a 14400020 8fbf0044 5280000d afb20010 afb00010 001017c3 
	afa20014 afb60018 8fa40048 8fa5004c 02403021 00123fc3 0411FF49 00000000 
	1000000b 02358823 001217c3 afa20014 afb60018 8fa40048 8fa5004c 02003021 
	00103fc3 0411FF3E 00000000 02358823 06210003 26100001 025e9021 02378821 
	0270102a 1040ffe2 8fbf0044 8fbe0040 8fb7003c 8fb60038 8fb50034 8fb40030 
	8fb3002c 8fb20028 8fb10024 8fb00020 03e00008 27bd0048 

'drawchar
27bdfdd0 afbf022c 
	afbe0228 afb70224 afb60220 afb5021c afb40218 afb30214 afb20210 afb1020c 
	afb00208 afa60238 afa7023c 8fa60248 afa601e0 8fa7024c afa701e4 8fa60250 
	afa601e8 8fa70254 afa701f0 8fb00258 8fb1025c 8fa60260 afa601ec 8fa70264 
	afa701f4 afa401b8 00c72025 14800075 afa501bc 0200f021 afb101c4 8fa201e8 
	afa201d0 8fa301f0 afa301dc afa001d4 afa001d8 24160001 27a401b7 afa401c0 
	0200a021 10000054 0220a821 92020000 02e21024 1040001b 00000000 16960008 
	8fa701c8 56a00007 afa70010 8fa60238 8fa7023c ae660000 1000002a ae670004 
	afa70010 8fa201cc afa20014 afb40018 afb5001c afb40020 afb50024 8fa30268 
	afa30028 8fa40238 8fa5023c 02203021 02403821 0411FD26 00000000 1000001a 
	2610ffff 16960008 8fa501c8 56a00007 afa50010 8fa40240 8fa50244 ae640000 
	10000010 ae650004 afa50010 8fa601cc afa60014 afb40018 afb5001c afb40020 
	afb50024 8fa70268 afa70028 8fa40240 8fa50244 02203021 02403821 0411FD0C 
	00000000 2610ffff 023e1021 0051182b 8fa401c4 02449021 00408821 00729021 
	8fa501c0 1605ffc1 26730008 8fa601d8 24c60006 afa601d8 8fa701d4 24e70001 
	afa701d4 8fa301d0 007e1021 0043202b 8fa501dc 8fa601c4 00a61821 afa201d0 
	00831821 afa301dc 8fa701d8 24020030 50e2000f 02808021 8fa301d4 0076b804 
	8fa401d0 afa401c8 8fa501dc afa501cc 27b001bd 8fb101e0 8fb201e4 8fa601d8 
	000698c0 27a70030 1000ffa0 00f39821 02a08821 00141040 001418c0 100000e1 
	00621023 24040001 8fa501ec 14a400dc 8fa601f4 14c000da 0200f021 afb101c4 
	8fa701e8 24e70001 afa70200 8fa301e8 00e3102b 8fa401f0 00441021 afa20204 
	00101023 0002182b 00112023 00831823 00022742 000318c0 00831825 000210c0 
	00502021 0082102b 00711821 00431821 00e41021 0047202b 8fa50204 00a31821 
	00832021 00501823 0043102b 00912023 afa301d0 00822023 afa401dc 24060007 
	afa601d4 afa001d8 8fa701e0 24e70001 afa701e8 8fa301e0 00e3102b 8fa401e4 
	00441021 afa201e4 00101023 0002182b 00112023 00831823 00022f82 00031880 
	00a32825 00021080 00501823 0043102b 00b12823 00a22823 00e31021 0047202b 
	8fa601e4 00c51821 00831821 00503823 afa701f0 0047102b 00711823 00621823 
	afa301fc 0200a021 10000051 0220a821 92020000 02c21024 1040001b 00000000 
	16970008 8fa301c8 56a00007 afa30010 8fa20238 8fa3023c ae620000 1000002a 
	ae630004 afa30010 8fa401cc afa40014 afb40018 afb5001c afb40020 afb50024 
	8fa50268 afa50028 8fa40238 8fa5023c 02203021 02403821 0411FC75 00000000 
	1000001a 26100001 16970008 8fa701c8 56a00007 afa70010 8fa60240 8fa70244 
	ae660000 10000010 ae670004 afa70010 8fa201cc afa20014 afb40018 afb5001c 
	afb40020 afb50024 8fa30268 afa30028 8fa40240 8fa50244 02203021 02403821 
	0411FC5B 00000000 26100001 023e1021 0051182b 8fa401c4 02449021 00408821 
	00729021 8fa501c0 1605ffc1 26730008 8fa601d8 24c60006 afa601d8 8fa701d4 
	24e7ffff afa701d4 8fa301d0 007e1021 0043182b 8fa501dc 00a42021 afa201d0 
	00642021 24020030 10c20017 afa401dc 24160001 8fa601d4 00d6b004 8fa701d0 
	afa701c8 8fa201dc afa201cc 27b001b8 8fa301e8 afa301e0 8fa401e4 afa401f8 
	8fb101f0 8fb201fc 8fa501d8 000598c0 27a60030 00d39821 27a701be afa701c0 
	1000ff9b 24170001 02808021 02a08821 00141823 0003102b 00152023 00821023 
	00032742 000210c0 00821025 000318c0 8fa40200 00831821 0064202b 8fa50204 
	00a21021 afa301e8 00821021 afa201f0 00141023 0002182b 00152023 00832023 
	00021f82 00042080 00642025 00021080 00541821 0062102b 00952021 00441021 
	00032fc2 00021040 00a21025 00031840 8fa601e0 00c31821 0066202b 8fa701f8 
	00e21021 afa301e0 00821021 afa201e4 00141040 001418c0 100000ae 00621023 
	afa001d8 24040002 8fa501ec 14a400aa 24040003 8fa601f4 14c000a8 8fa601ec 
	0200b821 0220f021 8fa701e8 afa701cc 8fa201f0 afa201d4 27b601bd 27a301b7 
	afa301c0 8fa401d8 afa401d0 8fa501e0 24a50001 afa501dc 8fa601e0 00a6102b 
	8fa701e4 00471021 afa201e4 00101023 0002182b 00112023 00831823 00022742 
	000318c0 00832025 000210c0 00501821 0062102b 00912021 00442821 8fa401dc 
	00831021 0044202b 8fa601e4 00c51821 00831821 00503823 afa701ec 0047102b 
	00711823 00621823 afa301f8 0200a021 10000050 0220a821 92c20000 02021007 
	30420001 1040001b 24020001 16820008 8fa501c4 56a00007 afa50010 8fa40238 
	8fa5023c ae640000 1000002a ae650004 afa50010 8fa601c8 afa60014 afb40018 
	afb5001c afb40020 afb50024 8fa70268 afa70028 8fa40238 8fa5023c 02203021 
	02403821 0411FBAA 00000000 1000001a 2610ffff 16820008 8fa501c4 56a00007 
	afa50010 8fa40240 8fa50244 ae640000 10000010 ae650004 afa50010 8fa601c8 
	afa60014 afb40018 afb5001c afb40020 afb50024 8fa70268 afa70028 8fa40240 
	8fa50244 02203021 02403821 0411FB90 00000000 2610ffff 02371021 0051182b 
	025e9021 00408821 00729021 2402ffff 1602ffc1 26730008 8fa301d0 24630008 
	afa301d0 8fa401cc 00971021 0044202b 8fa501d4 00be1821 afa201cc 00831821 
	afa301d4 26d6ffff 8fa601c0 52c60011 02808021 8fa701cc afa701c4 8fa201d4 
	afa201c8 8fa301dc afa301e0 8fa401e4 afa401f4 8fb101ec 8fb201f8 8fa501d0 
	000598c0 27a60030 00d39821 1000ffa2 24100007 02a08821 8fa701d8 24e70030 
	afa701d8 00141823 0003102b 00152023 00821023 00032742 000210c0 00821025 
	000318c0 8fa401e0 00831821 0064202b 8fa501f4 00a21021 afa301e0 00821021 
	afa201e4 001410c0 00141840 10000091 00431823 24040003 8fa601ec 14c4008e 
	24040001 8fa701f4 14e0008b 0200b821 0220f021 00101023 0002182b 00112023 
	00832023 00021f82 00042080 00642025 00021880 00701021 0043182b 00912021 
	00641821 00022fc2 00031840 00a31825 00021040 24440001 0082102b 00431821 
	8fa501e8 00a41021 0045202b 8fa601f0 00c31821 00831821 afa201e8 afa301f0 
	afa201cc afa301d4 27b601b8 27a701be afa701c0 8fa201d8 afa201d0 0200a021 
	10000051 0220a821 92c20000 02021007 30420001 5040001c 24020001 24030001 
	16830008 8fa501c4 56a00007 afa50010 8fa40238 8fa5023c ae640000 1000002a 
	ae650004 afa50010 8fa601c8 afa60014 afb40018 afb5001c afb40020 afb50024 
	8fa70268 afa70028 8fa40238 8fa5023c 02203021 02403821 0411FB05 00000000 
	1000001a 26100001 16820008 8fa501c4 56a00007 afa50010 8fa40240 8fa50244 
	ae640000 10000010 ae650004 afa50010 8fa601c8 afa60014 afb40018 afb5001c 
	afb40020 afb50024 8fa70268 afa70028 8fa40240 8fa50244 02203021 02403821 
	0411FAEB 00000000 26100001 02371021 0051182b 025e9021 00408821 00729021 
	24020008 1602ffc0 26730008 8fa301d0 24630008 afa301d0 8fa401cc 00971021 
	0044202b 8fa501d4 00be1821 afa201cc 00831821 afa301d4 26d60001 8fa601c0 
	52c6000d 02808021 8fa701cc afa701c4 8fa201d4 afa201c8 8fb101e0 8fb201e4 
	8fa301d0 000398c0 27a40030 00939821 1000ffa5 00008021 02a08821 8fa501d8 
	24a50030 afa501d8 001410c0 00141840 00431823 24040001 16040016 8fa401d8 
	56200015 00041fc3 8fa601e8 afa60010 8fa701f0 afa70014 afa20018 000217c3 
	afa2001c afa30020 00031fc3 afa30024 8fa20268 afa20028 27a40030 8fa601e0 
	8fa701e4 0411FB88 00000000 afa201d8 8fa401d8 00041fc3 00801021 8fbf022c 
	8fbe0228 8fb70224 8fb60220 8fb5021c 8fb40218 8fb30214 8fb20210 8fb1020c 
	8fb00208 03e00008 27bd0230 

'pstring
27bdff70 afbf008c afbe0088 afb70084 afb60080 
	afb5007c afb40078 afb30074 afb20070 afb1006c afb00068 afa4004c 00c08821 
	8fb200a0 8fb500a4 8fa200a8 afa20044 8fa300ac afa30048 8fb400b0 8fa400b4 
	afa40040 8fb600cc 92c20000 18400079 00e09821 8fa50044 00051fc2 8fa60048 
	00061040 00621025 00052040 00042f82 00021880 00a31825 8fa60044 000628c0 
	00a42023 00a4282b 00621023 afa40054 00451023 afa20058 00061023 0002182b 
	8fa50048 00052023 00831823 00022782 00031880 00831825 00022080 00861021 
	0044202b 00651821 00831821 00022fc2 00031840 00021040 afa2005c 00a31825 
	afa30060 24100001 8fa60040 02863025 afa60050 02d01021 90420000 000210c0 
	8fa3004c 00431021 8c570000 8c5e0004 8fa400c0 8fa500c4 afa40010 afa50014 
	afb10018 afb3001c afb20020 afb50024 8fa50044 afa50028 8fa60048 afa6002c 
	afb40030 8fa20040 afa20034 8fa300c8 afa30038 02e02021 03c02821 8fa600b8 
	8fa700bc 0411FCCC 00000000 8fa40050 14800009 24020001 8fa50054 02251021 
	0051182b 8fa60058 02669821 00408821 10000018 00739821 1682000a 8fa30040 
	14600008 8fa4005c 02241021 0051182b 8fa50060 02659821 00408821 10000018 
	00739821 24060002 1686000a 8fa20040 14400008 8fa30054 02431021 0052182b 
	8fa40058 02a4a821 00409021 1000000c 0075a821 24050003 16850009 8fa60040 
	14c00007 8fa3005c 02431021 0052182b 8fa40060 02a4a821 00409021 0075a821 
	26100001 92c20000 0050102a 1040ffb2 02d01021 8fa500c8 acb10020 acb30024 
	acb20028 acb5002c 02e01021 03c01821 8fbf008c 8fbe0088 8fb70084 8fb60080 
	8fb5007c 8fb40078 8fb30074 8fb20070 8fb1006c 8fb00068 03e00008 27bd0090 

'dcirch
	27bdffa0 afbf005c afbe0058 afb70054 afb60050 afb5004c afb40048 afb30044 
	afb20040 afb1003c afb00038 afa40060 afa50064 00c0a021 00e0b021 8fb30070 
	8fb50074 8fbe0078 8fb0007c 8fa20080 afa20028 8fb70088 30420010 1040002f 
	03c08821 03d31021 005e202b 02151821 00831821 afa20010 afa30014 afb70018 
	8fa40060 8fa50064 0411FB8D 00000000 027e1023 0262182b 02b02023 00831823 
	afa20010 afa30014 afb70018 8fa40060 8fa50064 02803021 02c03821 0411FB80 
	00000000 03d43021 00de382b 02161021 afb30010 afb50014 afb70018 8fa40060 
	8fa50064 00e23821 0411FB75 00000000 029e3023 0286102b 02d03823 afb30010 
	afb50014 afb70018 8fa40060 8fa50064 00e23823 0411FB6A 00000000 1a2000b9 
	24120001 025e9023 001ef023 001ef040 00008021 8fa30028 30630004 afa3002c 
	8fa80028 31080002 afa80030 8fa20028 30420008 afa20034 8fa30028 30630001 
	afa30028 06400004 8fa8002c 2631ffff 27de0002 025e9021 11000026 26100001 
	001017c3 afa20020 00111fc3 afa30024 02143021 00d0382b 00561021 02331821 
	0071282b 8fa80024 01152021 00a42021 afa30010 afa40014 afb70018 8fa40060 
	8fa50064 00e23821 0411FB3D 00000000 02343021 00d1382b 8fa30024 00761021 
	02131821 0070282b 8fa80020 01152021 00a42021 afa30010 afa40014 afb70018 
	8fa40060 8fa50064 00e23821 0411FB2C 00000000 8fa20030 10400026 8fa20034 
	00101fc3 afa30020 001147c3 afa80024 02143021 00d0382b 00761021 02711823 
	0263202b 02a82823 00a42023 afa30010 afa40014 afb70018 8fa40060 8fa50064 
	00e23821 0411FB16 00000000 02343021 00d1382b 8fa30024 00761021 02701823 
	0263202b 8fa80020 02a82823 00a42023 afa30010 afa40014 afb70018 8fa40060 
	8fa50064 00e23821 0411FB05 00000000 8fa20034 10400026 8fa20028 00111fc3 
	afa30020 001047c3 afa80024 02913023 0286102b 02c33823 02131821 0070282b 
	01152021 00a42021 afa30010 afa40014 afb70018 8fa40060 8fa50064 00e23823 
	0411FAEF 00000000 02903023 0286102b 8fa30024 02c33823 02331821 0071282b 
	8fa80020 01152021 00a42021 afa30010 afa40014 afb70018 8fa40060 8fa50064 
	00e23823 0411FADE 00000000 8fa20028 10400026 0211102a 00111fc3 afa30020 
	001047c3 afa80024 02913023 0286102b 02c33823 02701823 0263202b 02a82823 
	00a42023 afa30010 afa40014 afb70018 8fa40060 8fa50064 00e23823 0411FAC8 
	00000000 02903023 0286102b 8fa30024 02c33823 02711823 0263202b 8fa80020 
	02a82823 00a42023 afa30010 afa40014 afb70018 8fa40060 8fa50064 00e23823 
	0411FAB7 00000000 0211102a 10400006 8fbf005c 00101040 24420001 1000ff59 
	02429021 8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 
	8fb20040 8fb1003c 8fb00038 03e00008 27bd0060 

'fcirch
27bdff90 afbf006c afbe0068 
	afb70064 afb60060 afb5005c afb40058 afb30054 afb20050 afb1004c afb00048 
	0080b021 afa50038 00c0a021 afa7003c 8fb50080 8fa20088 8fbe0090 8fb70094 
	1aa0009f 02a08021 24130001 02759823 0015a823 0015a840 24120003 00008821 
	30430001 afa30040 30420002 afa20044 06600004 8fa40040 2610ffff 26b50002 
	02759821 10800043 26310001 00112fc3 afa50030 001047c3 afa80034 02363021 
	00d1382b 8fa90038 00a91021 02901823 0283202b 8fa9003c 01282823 00a42023 
	afa30010 afa40014 24040001 00002821 afa40018 afa5001c 00101840 24630001 
	00032fc3 007e2021 0083182b 00b72821 00651821 afa40020 afa30024 8fa500a0 
	afa50028 8fa40098 8fa5009c 00e23821 0411F89F 00000000 02163021 00d0102b 
	8fa80034 8fa90038 01093821 02911823 0283202b 8fa8003c 8fa90030 01092823 
	00a42023 afa30010 afa40014 24040001 00002821 afa40018 afa5001c 001227c3 
	025e1821 0072282b 00972021 00a42021 afa30020 afa40024 8fa500a0 afa50028 
	8fa40098 8fa5009c 00473821 0411F880 00000000 8fa80044 11000045 0230102a 
	00114fc3 afa90030 001017c3 afa20034 02d13023 02c6102b 8fa30038 00693823 
	02901823 0283202b 8fa8003c 8fa90034 01092823 00a42023 afa30010 afa40014 
	24040001 00002821 afa40018 afa5001c 00101840 24630001 00032fc3 007e2021 
	0083182b 00b72821 00651821 afa40020 afa30024 8fa500a0 afa50028 8fa40098 
	8fa5009c 00e23823 0411F859 00000000 02d03023 02c6102b 8fa80038 8fa90034 
	01093823 02911823 0283202b 8fa8003c 8fa90030 01092823 00a42023 afa30010 
	afa40014 24040001 00002821 afa40018 afa5001c 001227c3 025e1821 0072282b 
	00972021 00a42021 afa30020 afa40024 8fa500a0 afa50028 8fa40098 8fa5009c 
	00e23823 0411F83A 00000000 0230102a 10400003 02729821 1000ff6d 26520002 
	8fbf006c 8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 
	8fb1004c 8fb00048 03e00008 27bd0070 

'main
27bdffb8 afbf0044 afb00040 00808021 
	00e01021 8faa0058 8fa9005c 8fa80060 8fab0064 8c830000 8c840004 00643825 
	14e00010 8fac0068 8ca50000 8cc70000 8c420000 afa20010 000217c3 afa20014 
	afaa0018 00a02021 00052fc3 00e03021 00073fc3 0411F9CA 00000000 100000c8 
	8fbf0044 24070001 14670018 24070002 14800016 00000000 8ca40000 8ca50004 
	8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 
	afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 afa80028 0411F7F4 
	00000000 100000ae 8fbf0044 14670021 24070003 1480001f 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c420000 afa20010 000217c3 afa20014 8d420000 
	afa20018 000217c3 afa2001c 8d220000 afa20020 000217c3 afa20024 8d020000 
	afa20028 000217c3 afa2002c 8d620000 afa20030 000217c3 afa20034 afac0038 
	0411FA65 00000000 8e020000 1000008b 8e030004 14670019 24070004 14800017 
	00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c420000 afa20010 000217c3 
	afa20014 8d420000 afa20018 000217c3 afa2001c 8d220000 afa20020 000217c3 
	afa20024 afa80028 0411F9E3 00000000 8e020000 10000071 8e030004 1467000a 
	24070005 14800008 00000000 8ca40000 8ca50004 0411F782 00000000 8e020000 
	10000066 8e030004 1467000a 24070007 14800008 00000000 8ca40000 8ca50004 
	0411F78D 00000000 8e020000 1000005b 8e030004 14670022 24070008 14800020 
	00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 
	afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 
	afa30024 8d020000 8d030004 afa20028 afa3002c 8d620000 8d630004 afa20030 
	afa30034 afac0038 8fa2006c afa2003c 0411FCE6 00000000 10000039 8fbf0044 
	1467001d 24070009 1480001b 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 
	8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 
	afab0030 0411FE7B 00000000 8e020000 1000001a 8e030004 14670019 8fbf0044 
	54800018 8fb00040 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 
	afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 
	afa20020 afa30024 afa80028 0411FD54 00000000 8e020000 8e030004 8fbf0044 
	8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
	7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
	c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
	79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
	1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
	7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
	7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
	10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
	a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
	54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
	55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
	457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
	55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
	44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
	a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
	49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
	54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
	0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
	4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
	2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
	5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
	14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
	f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
	1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
	101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
	10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
	fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
	14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
	14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
	00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
	101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
	ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
	4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
	443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
	492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
	5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
	5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
	ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
	18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
	1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
End CFunction
'
sub T18_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  do
  T18.fillscreen(black)
  T18.setrot(T18_normal)
  T18.pstring(24, 10, "Welcome to the", 1, 0, green, black)
  T18.pstring(8, 30, "Micromite", 2, 0, red, black)
  T18.pstring(44,50,"MK2",2,0,red,black)
  T18.pstring(8, 80, "in colour", 2, 0, yellow, black)
  T18.pstring(10, 100, "1.8in SPI display", 1, 0, cyan, black)
  T18.pstring(18, 115,  "7735R contoller", 1, 0, cyan, black)

  pause 4000
' demo fast line draw
  T18.fillscreen(white)
  x0=0:y0=0:y1=T18_params(T18_ht)-1
  for i=0 to 45 step 5
    tn=tan(rad(i))
    x1=T18_params(T18_wi)*tn
    T18.dline(x0, y0, x1, y1, red)
  next i
  x1=T18_params(T18_wi)-1
  for i=0 to 40 step 5
    tn=tan(rad(i))
    y1=T18_params(T18_ht)*tn
    T18.dline(x0, y0, x1, y1, red)
  next i
  T18.drect(0, 0, T18_params(T18_wi), T18_params(T18_ht), blue)
  pause 2000
  T18.fillscreen(white)
'demo fast text write
  T18.setrot(T18_rt_right)
  for i=0 to T18_params(T18_wi)-8 step 8
    T18.pstring(0, i, "Hello world:Bye world:Hello world", 1, T18_normal, green, black)
  next i
  pause 2000
  T18.setrot(T18_normal)
  T18.fillscreen(white)

  for i=T18_params(T18_ht)-1 to 15 step -16
    T18.pstring(T18_params(T18_wi)-1, i, "Micromite MK2:Micromite MK2", 2, T18_inverse, red, yellow)
  next i

  pause 2000
  T18.fillscreen(white)
  for i=23 to T18_params(T18_wi) + 24 step 24
    T18.pstring(i, 0, "Rotate right", 3, T18_rt_right, yellow, black)
  next i
  pause 2000
  T18.fillscreen(black)
  for i=T18_params(T18_wi)-32 to 0 step -32
    T18.pstring(i, T18_params(T18_ht)-1, "Left", 4, T18_rt_left, blue, black)
  next i
  pause 2000
  T18.fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     T18.setrot(i)
     T18.frect(4, 4, 12, 17, blue)
     T18.drect(2, 2, 16, 21, red)
  next i
  pause 2000
' test drawing rounded rectangles
  T18.fillscreen(black)
  for i=0 to 3
     T18.setrot(i)
     T18.frndrect(4, 4, 12, 17, 4, blue)
     T18.drndrect(2, 2, 16, 21, 6, red)
  next i
  pause 2000
  T18.fillscreen(black)
' test drawing circles
  for i=0 to 3
     T18.setrot(i)
     T18.fcirc(10, 10, 7, blue)
     T18.dcirc(10, 10, 9, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  T18.fillscreen(black)
  for i=0 to 3
     T18.setrot(i)
     T18.ftri(4, 4, 20, 6, 12, 14, blue)
     T18.dtri(1, 2, 24, 4, 12, 17, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  T18.fillscreen(black)
  T18.setrot(T18_normal)
  T18.pstring(T18_params(T18_wi)/2, T18_params(T18_ht)/2, "N", 3, T18_normal, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_wi)-1, T18_params(T18_ht)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_wi)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_ht)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18.fillscreen(black)
  T18.setrot(T18_inverse)
  T18.pstring(T18_params(T18_wi)/2, T18_params(T18_ht)/2, "I", 3, T18_inverse, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_wi)-1, T18_params(T18_ht)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_wi)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_ht)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18.fillscreen(black)
  T18.setrot(T18_rt_right)
  T18.pstring(T18_params(T18_wi)/2, T18_params(T18_ht)/2, "R", 3, T18_rt_left, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_wi)-1, T18_params(T18_ht)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_wi)-1, 0, "Rotated Right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_ht)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18.fillscreen(black)
  T18.setrot(T18_rt_left)
  T18.pstring(T18_params(T18_wi)/2, T18_params(T18_ht)/2, "L", 3, T18_rt_right, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_wi)-1, T18_params(T18_ht)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_wi)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_ht)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  next sz
  loop
end sub
