                                                                                  ' V1.0
' Graphics library with drivers for ILI9341 T28 and T24 displays
' NB this display controller reports an ID of 9341
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub I9341.setrot(x) ;I9341_normal=normal, I9341_inverse=invert, I9341_rt_right=rotate right, I9341_rt_left=rotate left
' draw circle: sub I9341.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub I9341.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub I9341.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub I9341.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub I9341.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' draw line: sub I9341.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub I9341.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub I9341.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub I9341.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub I9341.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option explicit
option default NONE
cpu 48
  I9341_initialise
do
  I9341_test
loop
end
'
' ILI9341 specific routines
'
sub I9341.initdisplay
'Global "Constants"
  dim integer I9341_CS=2 'a0
  dim integer I9341_RS=3 'a1
  dim integer I9341_WR=9 'a2
  dim integer I9341_RD=10 'a3
  dim integer I9341_RESET= 14 'b5
  dim integer I9341_D0=4' b0
  dim integer I9341_D1=5' b1
  dim integer I9341_D2=6' b2
  dim integer I9341_D3=7' b3
  dim integer I9341_D4=23' b12
  dim integer I9341_D5=24' b13
  dim integer I9341_D6=25' b14
  dim integer I9341_D7=26' b15
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer I9341.pix=0
  dim integer I9341.ffr=1
  dim integer I9341.drawchar=2
  dim integer I9341.drawline=3
  dim integer I9341.writecommand=4
  dim integer I9341.writedata=5
  dim integer I9341.fpstring=7
  dim integer I9341.fcirch=8
  dim integer I9341.dcirch=9
  dim integer I9341.writebyte=10
  dim integer I9341.writedata32=11
  dim integer I9341_normal=0
  dim integer I9341_inverse=1
  dim integer I9341_rt_right=2
  dim integer I9341_rt_left=3
  Const ILI9341_SOFTRESET          =&H01
  Const ILI9341_SLEEPIN            =&H10
  Const ILI9341_SLEEPOUT           =&H11
  Const ILI9341_NORMALDISP         =&H13
  Const ILI9341_INVERTOFF          =&H20
  Const ILI9341_INVERTON           =&H21
  Const ILI9341_GAMMASET           =&H26
  Const ILI9341_DISPLAYOFF         =&H28
  Const ILI9341_DISPLAYON          =&H29
  Const ILI9341_COLADDRSET         =&H2A
  Const ILI9341_PAGEADDRSET        =&H2B
  Const ILI9341_MEMORYWRITE        =&H2C
  Const ILI9341_PIXELFORMAT        =&H3A
  Const ILI9341_FRAMECONTROL       =&HB1
  Const ILI9341_DISPLAYFUNC        =&HB6
  Const ILI9341_ENTRYMODE          =&HB7
  Const ILI9341_POWERCONTROL1      =&HC0
  Const ILI9341_POWERCONTROL2      =&HC1
  Const ILI9341_VCOMCONTROL1      =&HC5
  Const ILI9341_VCOMCONTROL2      =&HC7
  DIM integer ILI9341_MEMCONTROL      =&H36
  Const ILI9341_MADCTL  =&H36
  DIM integer  ILI9341_MADCTL_MY  =&H80
  DIM integer  ILI9341_MADCTL_MX  =&H40
  DIM integer  ILI9341_MADCTL_MV  =&H20
  DIM integer  ILI9341_MADCTL_ML  =&H10
  DIM integer  ILI9341_MADCTL_RGB =&H00
  DIM integer  ILI9341_MADCTL_BGR =&H08
  DIM integer  ILI9341_MADCTL_MH  =&H04
  ' Global variables
  dim integer I9341_AddrOfFont,   I9341_params(6) ' Global variables
  DIM integer I9341_wi=0,I9341_ht=1,I9341_rot=2,I9341_nr=3,I9341_X=4,I9341_Y=5,I9341_seed=6
  I9341_AddrOfFont=PEEK(CFunAddr FONT)  
  local integer i
  I9341_params(I9341_wi)=240
  I9341_params(I9341_ht)=320
  pin(I9341_CS)=1
  setpin I9341_CS, DOUT
  pin(I9341_RS)=1
  setpin I9341_RS, DOUT
  pin(I9341_WR)=1
  setpin I9341_WR, DOUT
  pin(I9341_RD)=1
  setpin I9341_RD, DOUT
  pin(I9341_RESET)=1
  setpin I9341_RESET, DOUT'  Reset the display
  I9341.setwrite
  pin(I9341_RESET)=0
  pause 100
  pin(I9341_RESET)=1
  pause 100
  PIN(I9341_CS)=0
  pin(I9341_RS)=0
  port(4, 4, 23, 4)=ILI9341_SOFTRESET
  pulse I9341_WR ,0.01
  pulse I9341_WR ,0.01
  pulse I9341_WR ,0.01
  PIN(I9341_CS)=1
  pause 500
  I9341.wreg(ILI9341_DISPLAYOFF, 0,0)
  I9341.wreg(ILI9341_POWERCONTROL1, &H23,8)
  I9341.wreg(ILI9341_POWERCONTROL2, &H10,8)
  I9341.wreg(ILI9341_VCOMCONTROL1, &H2B2B,16)
  I9341.wreg(ILI9341_VCOMCONTROL2, &HC0,8)
  I9341.wreg(ILI9341_MEMCONTROL, ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR,8)
  I9341.wreg(ILI9341_PIXELFORMAT, &H55,8)
  I9341.wreg(ILI9341_FRAMECONTROL, &H001B,16)
  I9341.wreg(ILI9341_ENTRYMODE, &H07,8)
  I9341.wreg(ILI9341_SLEEPOUT, 0,8)
  pause 150
  I9341.wreg(ILI9341_DISPLAYON, 0,0)
  pause 500
  I9341.setrot(I9341_normal)
  I9341.wreg(ILI9341_COLADDRSET,239,32)
  I9341.wreg(ILI9341_PAGEADDRSET,319,32)
  I9341.wreg(ILI9341_MEMORYWRITE , 0,8)
end sub
'
sub I9341.wreg(register as integer, databyte as integer, numbits as integer)
  local integer i
  i=I9341draw(I9341.writecommand, register)
  if numbits=16 then i=I9341draw(I9341.writedata, databyte)
  if numbits=32 then i=I9341draw(I9341.writedata32,databyte)
  if numbits=8 then i=I9341draw(I9341.writebyte, databyte)
end sub
'
function I9341.rreg(register as integer) as integer
  local integer i
  i=I9341draw(I9341.writecommand, register)
  pin(I9341_RS)=1
  I9341.rreg= I9341.readdata()
end function
'
sub I9341.fillscreen(scol as integer)
  local integer i=I9341_params(I9341_rot)
  I9341_params(I9341_rot)=0
  local integer j=I9341draw(I9341.ffr,scol, 0,0,I9341_params(I9341_wi),I9341_params(I9341_ht), I9341_params())
  I9341_params(I9341_rot)=i
end sub
'
end sub
'
function  I9341.readdata() as integer
  local integer i 
  I9341.setread
  pin(I9341_cs)=0
  pin(I9341_RD)=0
  i=port(4, 4, 23, 4)
  pin(I9341_RD)=1
  pin(I9341_RD)=0
  i=port(4, 4, 23, 4)
  pin(I9341_RD)=1
  pin(I9341_RD)=0
  i=port(4, 4, 23, 4)<<8
  pin(I9341_RD)=1
  pin(I9341_RD)=0
  i=i+port(4, 4, 23, 4)
  pin(I9341_RD)=1
  I9341.readdata=i
  pin(I9341_CS)=1
  I9341.setwrite
end function
'
sub I9341.setwrite
  setpin I9341_CS, DOUT
  setpin I9341_RS, DOUT
  setpin I9341_WR, DOUT
  setpin I9341_RD, DOUT
  setpin I9341_RESET, DOUT'  Reset the display
  setpin I9341_D0, dout
  setpin I9341_D1, dout
  setpin I9341_D2, dout
  setpin I9341_D3, dout
  setpin I9341_D4, dout
  setpin I9341_D5, dout
  setpin I9341_D6, dout
  setpin I9341_D7, dout
end sub
'
sub I9341.setread
  setpin I9341_D0, din
  setpin I9341_D1, din
  setpin I9341_D2, din
  setpin I9341_D3, din
  setpin I9341_D4, din
  setpin I9341_D5, din
  setpin I9341_D6, din
  setpin I9341_D7, din
end sub
'
' Generic drawing routines
'
sub I9341.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=I9341draw(I9341.dcirch, colour,x0,y0,r,31,I9341_params())

end sub
 '
sub I9341.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  I9341.dline(x0, y0, x1, y1, colour)
  I9341.dline(x1, y1, x2, y2, colour)
  I9341.dline(x2, y2, x0, y0, colour)
end sub
 '
sub I9341.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer a, b, y, dp, last
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if (y1>y2) then
    swap(y2, y1)
    swap(x2, x1)
  endif
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if(y0=y2) then ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    if(x1<a) then
  a=x1
    else
  if(x1>b) then b=x1
    endif
    if(x2<a) then
  a=x2
    else
  if(x2>b) then b=x2
    endif
    dp=I9341draw(I9341.ffr, colour, a, y0, 1, b-a+1,  I9341_params()) 
    exit sub
  endif
    local integer  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  if(y1=y2) then
    last=y1 'Include y1 scanline
  else
     last=y1-1 ' Skip it
  endif
  for y=y0 to last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params()) 
  next y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  do while y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params()) 
    y=y+1
  loop
end sub
'
sub I9341.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=I9341draw(I9341.fpstring,I9341_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,I9341_params(),text$)
end sub
'
sub I9341.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=I9341draw(I9341.drawline, colour, xx0, yy0, xx1, yy1,  I9341_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub I9341.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, 1,  I9341_params()) 
  a=y+h-1
  dp=I9341draw(I9341.ffr, rcolour, x, a, w, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y, 1, h,  I9341_params()) 
  a=x+w-1
  dp=I9341draw(I9341.ffr, rcolour, a, y, 1, h,  I9341_params()) 
end sub
'
sub I9341.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, h,  I9341_params()) 
end sub
'
FUNCTION I9341.Getchar(char as integer) as integer
  local integer i=char<<3
  I9341.Getchar=PEEK(WORD I9341_AddrOfFont+i)+(PEEK(WORD I9341_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub I9341.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=I9341draw(I9341.ffr, ccolour, x0, y0-r, 1, 2*r+1,  I9341_params())
  dp=I9341draw(I9341.fcircH,x0, y0, r, 3, 0, ccolour, I9341_params())
end sub
 '
sub I9341.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x+r, y, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.dcirch, rcolour, x+r, y+r, r, 1,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+r, r, 2,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+r, y+h-r-1, r, 8,I9341_params())
end sub
'
sub I9341.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, colour, x+r, y, w-2*r, h,  I9341_params()) 
  dp=I9341draw(I9341.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, I9341_params())
  dp=I9341draw(I9341.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, I9341_params())
end sub
 '
sub I9341.setrot(x%) 'sets screen rotation: 0=I9341_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer i=x% \ 2 '0 for portrait, 1 for landscape
   local integer j=I9341_params(I9341_rot)\2 
   I9341_params(I9341_rot)=(x% and 3)
   if i<>j then 'swap height and width if landscape
     local integer k=I9341_params(I9341_wi)
     I9341_params(I9341_wi)=I9341_params(I9341_ht)
     I9341_params(I9341_ht)=k
   endif  
   on I9341_params(I9341_rot)+1 goto rnor,rinv,rrr,rrl
   rnor:
     I9341.wreg(ILI9341_MEMCONTROL, ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR,8)
     exit sub
   rinv:
     I9341.wreg(ILI9341_MEMCONTROL, ILI9341_MADCTL_MY OR ILI9341_MADCTL_BGR,8)
     exit sub
   rrr:
     I9341.wreg(ILI9341_MEMCONTROL, ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR,8)
     exit sub
   rrl:
     I9341.wreg(ILI9341_MEMCONTROL, ILI9341_MADCTL_MY OR ILI9341_MADCTL_MX OR ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR,8)
end sub
'
'D:\Peter\MPLABXProjects\TFI9341\dist\default\production\I9341draw.bas

'
'I9341draw  2015-01-01 19:08:10 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction I9341draw
'writeCommand
	00000700
	308400ff 3c02bf88 24050001 ac456034 24030002 ac436034 24030004 ac436038 
	24060008 ac466038 ac436034 8c466130 30c60ff0 ac466130 8c466130 00863025 
	00042200 3084f00f 00c42025 ac446130 3c04bf81 8c84f220 ac436038 ac456038 
	03e00008 00000000 

'writeData
3085ff00 308400ff 3c02bf88 24060001 ac466034 24030002 
	ac436038 24030004 ac436038 24070008 ac476038 ac436034 8c476130 30e70ff0 
	ac476130 8c476130 00a73825 7ca51a00 00e52825 ac456130 3c05bf81 8ca7f220 
	ac436038 8ca7f220 ac436034 8c476130 30e70ff0 ac476130 8c476130 00873825 
	00042200 3084f00f 00e42025 ac446130 8ca4f220 ac436038 ac466038 03e00008 
	00000000 

'writeData32
00042e02 7c883c00 7c873a00 308400ff 3c02bf88 24060001 ac466034 
	24030002 ac436038 24030004 ac436038 24090008 ac496038 ac436034 8c496130 
	31290ff0 ac496130 8c496130 00a94825 00052a00 30a5f00f 01252825 ac456130 
	3c05bf81 8ca9f220 ac436038 8ca9f220 ac436034 8c496130 31290ff0 ac496130 
	8c496130 01094825 00084200 3108f00f 01284025 ac486130 8ca8f220 ac436038 
	8ca8f220 ac436034 8c486130 31080ff0 ac486130 8c486130 00e84025 00073a00 
	30e7f00f 01073825 ac476130 8ca7f220 ac436038 8ca7f220 ac436034 8c476130 
	30e70ff0 ac476130 8c476130 00873825 00042200 3084f00f 00e42025 ac446130 
	8ca4f220 ac436038 ac466038 03e00008 00000000 

'writebyte
308400ff 3c02bf88 24050001 
	ac456034 24030002 ac436038 24030004 ac436038 24060008 ac466038 ac436034 
	8c466130 30c60ff0 ac466130 8c466130 00863025 00042200 3084f00f 00c42025 
	ac446130 3c04bf81 8c84f220 ac436038 ac456038 03e00008 00000000 

'localfastfillrect
27bdffc8 
	afbf0034 afbe0030 afb7002c afb60028 afb50024 afb40020 afb3001c afb20018 
	afb10014 afb00010 00c08021 8fb40048 8fa3004c 8fa90050 8fa80054 8fb60058 
	8fab005c 8fa20060 8c460000 8c4a0008 3082ff00 308400ff 7c521a00 02429025 
	00048a00 3231f00f 02248825 04e00005 00002821 14a7006a 0206102b 1040006d 
	00002021 2602ffff 0050202b 24e7ffff 00873821 00492021 0082102b 00e84021 
	00481021 04400006 0080a821 54a20004 24d5ffff 0086202b 50800001 24d5ffff 
	04600005 00001021 14430058 028a202b 10800057 00002021 2684ffff 0094282b 
	2463ffff 00a31821 0096b021 02c4202b 006b5821 008b2021 00801821 0082202a 
	14800008 24170001 54430006 2555ffff 02ca102b 14400004 02f0f023 2555ffff 
	24170001 02f0f023 03d5f021 02d41023 24420001 73c2f002 2404002a 0411FF10 
	00000000 00102400 02a42021 0411FF4D 00000000 2404002b 0411FF09 00000000 
	00142400 00962021 0411FF46 00000000 2404002c 0411FF02 00000000 3c02bf88 
	ac576034 24030002 ac436038 24030004 ac436038 24030008 ac436038 13c0001a 
	27deffff 24030004 3c04bf81 2406ffff ac436034 8c456130 30a50ff0 ac456130 
	8c456130 02452825 ac456130 8c85f220 ac436038 8c85f220 ac436034 8c456130 
	30a50ff0 ac456130 8c456130 02252825 ac456130 8c93f220 ac436038 27deffff 
	17c6ffeb 00000000 24030001 3c02bf88 ac436038 02602021 10000006 00002821 
	00002021 10000003 00002821 00002021 00002821 00801021 00a01821 8fbf0034 
	8fbe0030 8fb7002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0038 

'localdrawPixel
27bdffe0 afbf001c afb20018 afb10014 afb00010 
	00808021 00c08821 8fb20030 8fa30038 8fa40034 8c650000 14e00004 24020001 
	00c5282b 14a00003 304200ff 00001021 304200ff 50400022 00002021 8c630008 
	14800004 24020001 0243182b 14600003 304200ff 00001021 304200ff 50400018 
	00002021 2404002a 0411FEA5 00000000 00112400 00912021 0411FEE2 00000000 
	2404002b 0411FE9E 00000000 00122400 00922021 0411FEDB 00000000 2404002c 
	0411FE97 00000000 02002021 0411FEAE 00000000 02202021 10000002 02402821 
	00002821 00801021 00a01821 8fbf001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0020 

'drawline
27bdffb8 afbf0044 afbe0040 afb7003c afb60038 afb50034 afb40030 
	afb3002c afb20028 afb10024 afb00020 afa40048 afa5004c 8fa20058 8fa30060 
	8fa40068 8fb60070 00c08021 00409021 00609821 0044a02a 00822823 00443823 
	00f4280a 00a0a021 00c3402a 00663823 00c32823 00e8280b 00b4a02a 12800005 
	0080a821 00809821 0060a821 00408021 00c09021 0270102a 10400008 0255102a 
	02401021 02a09021 0040a821 02001021 02608021 00409821 0255102a 10400007 
	0270b823 02b2a823 00178fc2 02378821 00118843 10000006 241e0001 0255a823 
	00178fc2 02378821 00118843 241effff 0270102a 14400020 8fbf0044 5280000d 
	afb20010 afb00010 001017c3 afa20014 afb60018 8fa40048 8fa5004c 02403021 
	00123fc3 0411FF79 00000000 1000000b 02358823 001217c3 afa20014 afb60018 
	8fa40048 8fa5004c 02003021 00103fc3 0411FF6E 00000000 02358823 06210003 
	26100001 025e9021 02378821 0270102a 1040ffe2 8fbf0044 8fbe0040 8fb7003c 
	8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028 8fb10024 8fb00020 03e00008 
	27bd0048 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 
	afb30054 afb20050 afb1004c afb00048 0080b021 afa50038 00c0a021 afa7003c 
	8fb50080 8fa20088 8fbe0090 8fb70094 1aa0009f 02a08021 24130001 02759823 
	0015a823 0015a840 24120003 00008821 30430001 afa30040 30420002 afa20044 
	06600004 8fa40040 2610ffff 26b50002 02759821 10800043 26310001 00112fc3 
	afa50030 001047c3 afa80034 02363021 00d1382b 8fa90038 00a91021 02901823 
	0283202b 8fa9003c 01282823 00a42023 afa30010 afa40014 24040001 00002821 
	afa40018 afa5001c 00101840 24630001 00032fc3 007e2021 0083182b 00b72821 
	00651821 afa40020 afa30024 8fa500a0 afa50028 8fa40098 8fa5009c 00e23821 
	0411FE76 00000000 02163021 00d0102b 8fa80034 8fa90038 01093821 02911823 
	0283202b 8fa8003c 8fa90030 01092823 00a42023 afa30010 afa40014 24040001 
	00002821 afa40018 afa5001c 001227c3 025e1821 0072282b 00972021 00a42021 
	afa30020 afa40024 8fa500a0 afa50028 8fa40098 8fa5009c 00473821 0411FE57 
	00000000 8fa80044 11000045 0230102a 00114fc3 afa90030 001017c3 afa20034 
	02d13023 02c6102b 8fa30038 00693823 02901823 0283202b 8fa8003c 8fa90034 
	01092823 00a42023 afa30010 afa40014 24040001 00002821 afa40018 afa5001c 
	00101840 24630001 00032fc3 007e2021 0083182b 00b72821 00651821 afa40020 
	afa30024 8fa500a0 afa50028 8fa40098 8fa5009c 00e23823 0411FE30 00000000 
	02d03023 02c6102b 8fa80038 8fa90034 01093823 02911823 0283202b 8fa8003c 
	8fa90030 01092823 00a42023 afa30010 afa40014 24040001 00002821 afa40018 
	afa5001c 001227c3 025e1821 0072282b 00972021 00a42021 afa30020 afa40024 
	8fa500a0 afa50028 8fa40098 8fa5009c 00e23823 0411FE11 00000000 0230102a 
	10400003 02729821 1000ff6d 26520002 8fbf006c 8fbe0068 8fb70064 8fb60060 
	8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'drawchar
	27bdff58 afbf00a4 afbe00a0 afb7009c afb60098 afb50094 afb40090 afb3008c 
	afb20088 afb10084 afb00080 afa600b0 afa700b4 8fa200c0 afa20050 8fa300c4 
	afa30058 8fa600c8 afa6005c 8fa200cc afa20060 8fb000d0 8fb400d4 8fa300d8 
	afa30068 8fa600dc afa60070 afa40030 00661025 14400084 afa50034 8fa30050 
	24620005 0043182b afa20044 8fa40058 00641821 afa3004c 27b50030 24050005 
	afa50048 0200b021 0280b821 0200f021 10000060 afb40054 92a20000 02021007 
	30420001 10400022 24050001 24060001 57c60010 afb10010 8fa20054 5440000d 
	afb10010 afb20010 afb40014 8fa300e0 afa30018 8fa400b0 8fa500b4 8fa60044 
	8fa7004c 0411FE59 00000000 1000002f 26100001 afb30014 afb60018 afb7001c 
	afb60020 afb70024 8fa400e0 afa40028 8fa400b0 8fa500b4 8fa6003c 8fa70040 
	0411FDAE 00000000 10000020 26100001 57c50010 afb10010 8fa60054 54c0000d 
	afb10010 afb20010 afb40014 8fa200e0 afa20018 8fa400b8 8fa500bc 8fa60044 
	8fa7004c 0411FE39 00000000 1000000f 26100001 afb30014 afb60018 afb7001c 
	afb60020 afb70024 8fa300e0 afa30028 8fa400b8 8fa500bc 8fa6003c 8fa70040 
	0411FD8E 00000000 26100001 02361021 0051182b 02779821 00408821 00739821 
	26420001 0052182b 00409021 24040008 1604ffb1 0074a021 8fa50048 24a5ffff 
	afa50048 8fa60044 24c2ffff 0046202b 8fa5004c 24a3ffff afa20044 00831821 
	afa3004c 8fa60048 2402ffff 10c200be 26b50001 8fa40048 009e0019 00001012 
	00001810 8fa50054 70a43002 00c31821 8fa50050 00452021 0082282b 8fa60058 
	00661021 afa4003c 00a21021 afa20040 8fb2005c 8fb40060 02408821 02809821 
	1000ff8d 00008021 24020001 8fa30068 146200a9 24020002 8fa40070 148000a6 
	00142023 00101023 0002182b afa20074 00832023 afa40078 8fa50050 24a20001 
	0045202b 8fa60058 00862021 00501823 0043102b 00942023 afa30054 00822023 
	afa40064 afa50048 afa6004c 27b60035 27a2002f afa20038 8fa3005c 2463fff9 
	afa3006c 8fa4005c 24820001 0044182b 8fa50060 00651821 0050a823 0055102b 
	00741823 00621823 afa30044 8fbe00e0 1000006f 02009021 92c20000 02021007 
	30420001 10400028 00000000 1657000e 02120019 1680000d 00001012 afb10010 
	afb30014 afbe0018 8fa400b0 8fa500b4 8fa60048 8fa7004c 0411FDBC 00000000 
	1000003f 2610ffff 00001012 00001810 72902002 00831821 02a22023 02a4282b 
	8fa60044 00c31023 00452823 afa40010 afa50014 afb20018 afb4001c afb20020 
	afb40024 afbe0028 8fa400b0 8fa500b4 8fa6003c 8fa70040 0411FD08 00000000 
	10000027 2610ffff 1657000e 02120019 1680000d 00001012 afb10010 afb30014 
	afbe0018 8fa400b8 8fa500bc 8fa60048 8fa7004c 0411FD95 00000000 10000018 
	2610ffff 00001012 00001810 72902002 00831821 02a22023 02a4282b 8fa60044 
	00c31023 00452823 afa40010 afa50014 afb20018 afb4001c afb20020 afb40024 
	afbe0028 8fa400b8 8fa500bc 8fa6003c 8fa70040 0411FCE1 00000000 2610ffff 
	26220001 0051182b 00408821 2402ffff 1602ffa9 00739821 8fa30054 8fa40074 
	00641021 0043182b 8fa50064 8fa60078 00a62021 afa20054 00642021 afa40064 
	8fa30048 2462ffff 0043182b 8fa5004c 24a4ffff afa20048 00642021 afa4004c 
	26d6ffff 8fa60038 52c600a6 02408021 8fa20054 afa2003c 8fa30064 afa30040 
	8fa4006c 8fa5005c 0085982b 8fa60060 24c2ffff 00808821 02629821 24100007 
	1000ff85 24170001 03c08021 8fb40054 24020002 8fa30068 14620093 24020003 
	8fa40070 14800091 8fa30068 00101023 0002182b 00142023 afa20064 00832023 
	afa40068 8fa50050 24a20001 0045202b 8fa60058 00862021 00501823 0043102b 
	00942023 afa30048 00822023 afa4004c afa00044 0200b021 0280b821 27a2002f 
	afa20038 0200f021 10000069 afb40054 92020000 02a21024 50400022 24020001 
	24030001 57c30010 afb10010 8fa40054 5480000d afb10010 afb20010 afb40014 
	8fa500e0 afa50018 8fa400b0 8fa500b4 8fa60050 8fa70058 0411FD1C 00000000 
	1000002f 2610ffff afb30014 afb60018 afb7001c afb60020 afb70024 8fa600e0 
	afa60028 8fa400b0 8fa500b4 8fa6003c 8fa70040 0411FC71 00000000 10000020 
	2610ffff 57c20010 afb10010 8fa30054 5460000d afb10010 afb20010 afb40014 
	8fa400e0 afa40018 8fa400b8 8fa500bc 8fa60050 8fa70058 0411FCFC 00000000 
	1000000f 2610ffff afb30014 afb60018 afb7001c afb60020 afb70024 8fa500e0 
	afa50028 8fa400b8 8fa500bc 8fa6003c 8fa70040 0411FC51 00000000 2610ffff 
	02361021 0051182b 02779821 00408821 00739821 26420001 0052182b 00409021 
	8fa60038 1606ffb2 0074a021 8fa20044 24420001 afa20044 8fa30048 8fa40064 
	00641021 0043202b 8fa5004c 8fa60068 00a61821 afa20048 00831821 afa3004c 
	8fa30050 2462ffff 0043202b 8fa50058 24a3ffff afa20050 00831821 afa30058 
	8fa60044 24020008 10c200d0 8fbf00a4 24030001 8fa40044 0083a804 8fa50048 
	afa5003c 8fa6004c afa60040 27b00035 8fb1005c 8fb30060 02209021 1000ff8c 
	0260a021 24020003 8fa30068 146200be 8fa40070 148000bc 00101023 0002182b 
	00142023 afa2006c 00832023 afa40070 00101742 001418c0 00431825 001020c0 
	00901023 0082202b 00741823 00641823 8fa50050 00452021 0082102b 8fa60058 
	00661821 afa4004c 00431821 afa30054 24a20007 0045182b afa20044 00661821 
	afa30058 24020007 afa20048 8fa3005c 24620001 0043282b 8fa40060 00a42821 
	00101823 0003202b 00143023 00c42023 00033782 00042080 00c43025 00032080 
	00901821 0064202b 00d43021 00862021 000337c2 00042040 00c42025 00031840 
	00431821 afa30064 0062102b 00a41821 00431821 afa30074 8fa5005c 24a5fffb 
	afa50068 8fa6005c 00a6182b 8fa40060 2482ffff 00621021 afa2005c 0280b021 
	10000068 0200a021 92020000 02e21024 10400021 24030001 24050001 5685000f 
	afb10010 56c0000d afb10010 afb20010 afb50014 8fa600e0 afa60018 8fa400b0 
	8fa500b4 8fa60044 8fa70058 0411FC5F 00000000 1000002e 26100001 afb30014 
	afb40018 afb6001c afb40020 afb60024 8fa200e0 afa20028 8fa400b0 8fa500b4 
	8fa60040 8fa70050 0411FBB4 00000000 1000001f 26100001 5683000f afb10010 
	56c0000d afb10010 afb20010 afb50014 8fa400e0 afa40018 8fa400b8 8fa500bc 
	8fa60044 8fa70058 0411FC40 00000000 1000000f 26100001 afb30014 afb40018 
	afb6001c afb40020 afb60024 8fa500e0 afa50028 8fa400b8 8fa500bc 8fa60040 
	8fa70050 0411FB95 00000000 26100001 023e1021 0051182b 8fa6003c 02669821 
	00408821 00739821 26420001 0052182b 00409021 8fa20038 1602ffb3 0075a821 
	8fa30048 2463ffff afa30048 8fa4004c 8fa5006c 00851021 0044202b 8fa60054 
	8fa50070 00c51821 afa2004c 00831821 afa30054 8fa60044 24c2ffff 0046202b 
	8fa50058 24a3ffff afa20044 00831821 afa30058 2402ffff 8fa60048 10c20013 
	8fbf00a4 24170001 8fa20048 0057b804 8fa3004c afa30040 8fa40054 afa40050 
	27b00030 0280f021 afb6003c 8fb10064 8fb30074 8fb20068 8fb5005c 27a50036 
	1000ff89 afa50038 8fbf00a4 8fbe00a0 8fb7009c 8fb60098 8fb50094 8fb40090 
	8fb3008c 8fb20088 8fb10084 8fb00080 03e00008 27bd00a8 

'pstring
27bdff70 afbf008c 
	afbe0088 afb70084 afb60080 afb5007c afb40078 afb30074 afb20070 afb1006c 
	afb00068 afa4004c 00c08821 8fb200a0 8fb500a4 8fa200a8 afa20044 8fa300ac 
	afa30048 8fb400b0 8fa400b4 afa40040 8fb600cc 92c20000 18400079 00e09821 
	8fa50044 00051fc2 8fa60048 00061040 00621025 00052040 00042f82 00021880 
	00a31825 8fa60044 000628c0 00a42023 00a4282b 00621023 afa40054 00451023 
	afa20058 00061023 0002182b 8fa50048 00052023 00831823 00022782 00031880 
	00831825 00022080 00861021 0044202b 00651821 00831821 00022fc2 00031840 
	00021040 afa2005c 00a31825 afa30060 24100001 8fa60040 02863025 afa60050 
	02d01021 90420000 000210c0 8fa3004c 00431021 8c570000 8c5e0004 8fa400c0 
	8fa500c4 afa40010 afa50014 afb10018 afb3001c afb20020 afb50024 8fa50044 
	afa50028 8fa60048 afa6002c afb40030 8fa20040 afa20034 8fa300c8 afa30038 
	02e02021 03c02821 8fa600b8 8fa700bc 0411FCF3 00000000 8fa40050 14800009 
	24020001 8fa50054 02251021 0051182b 8fa60058 02669821 00408821 10000018 
	00739821 1682000a 8fa30040 14600008 8fa4005c 02241021 0051182b 8fa50060 
	02659821 00408821 10000018 00739821 24060002 1686000a 8fa20040 14400008 
	8fa30054 02431021 0052182b 8fa40058 02a4a821 00409021 1000000c 0075a821 
	24050003 16850009 8fa60040 14c00007 8fa3005c 02431021 0052182b 8fa40060 
	02a4a821 00409021 0075a821 26100001 92c20000 0050102a 1040ffb2 02d01021 
	8fa500c8 acb10020 acb30024 acb20028 acb5002c 02e01021 03c01821 8fbf008c 
	8fbe0088 8fb70084 8fb60080 8fb5007c 8fb40078 8fb30074 8fb20070 8fb1006c 
	8fb00068 03e00008 27bd0090 

'dcirch
27bdffa0 afbf005c afbe0058 afb70054 afb60050 
	afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 afa40060 afa50064 
	00c0a021 00e0b021 8fb30070 8fb50074 8fbe0078 8fb0007c 8fa20080 afa20028 
	8fb70088 30420010 1040002f 03c08821 03d31021 005e202b 02151821 00831821 
	afa20010 afa30014 afb70018 8fa40060 8fa50064 0411FB25 00000000 027e1023 
	0262182b 02b02023 00831823 afa20010 afa30014 afb70018 8fa40060 8fa50064 
	02803021 02c03821 0411FB18 00000000 03d43021 00de382b 02161021 afb30010 
	afb50014 afb70018 8fa40060 8fa50064 00e23821 0411FB0D 00000000 029e3023 
	0286102b 02d03823 afb30010 afb50014 afb70018 8fa40060 8fa50064 00e23823 
	0411FB02 00000000 1a2000b9 24120001 025e9023 001ef023 001ef040 00008021 
	8fa30028 30630004 afa3002c 8fa80028 31080002 afa80030 8fa20028 30420008 
	afa20034 8fa30028 30630001 afa30028 06400004 8fa8002c 2631ffff 27de0002 
	025e9021 11000026 26100001 001017c3 afa20020 00111fc3 afa30024 02143021 
	00d0382b 00561021 02331821 0071282b 8fa80024 01152021 00a42021 afa30010 
	afa40014 afb70018 8fa40060 8fa50064 00e23821 0411FAD5 00000000 02343021 
	00d1382b 8fa30024 00761021 02131821 0070282b 8fa80020 01152021 00a42021 
	afa30010 afa40014 afb70018 8fa40060 8fa50064 00e23821 0411FAC4 00000000 
	8fa20030 10400026 8fa20034 00101fc3 afa30020 001147c3 afa80024 02143021 
	00d0382b 00761021 02711823 0263202b 02a82823 00a42023 afa30010 afa40014 
	afb70018 8fa40060 8fa50064 00e23821 0411FAAE 00000000 02343021 00d1382b 
	8fa30024 00761021 02701823 0263202b 8fa80020 02a82823 00a42023 afa30010 
	afa40014 afb70018 8fa40060 8fa50064 00e23821 0411FA9D 00000000 8fa20034 
	10400026 8fa20028 00111fc3 afa30020 001047c3 afa80024 02913023 0286102b 
	02c33823 02131821 0070282b 01152021 00a42021 afa30010 afa40014 afb70018 
	8fa40060 8fa50064 00e23823 0411FA87 00000000 02903023 0286102b 8fa30024 
	02c33823 02331821 0071282b 8fa80020 01152021 00a42021 afa30010 afa40014 
	afb70018 8fa40060 8fa50064 00e23823 0411FA76 00000000 8fa20028 10400026 
	0211102a 00111fc3 afa30020 001047c3 afa80024 02913023 0286102b 02c33823 
	02701823 0263202b 02a82823 00a42023 afa30010 afa40014 afb70018 8fa40060 
	8fa50064 00e23823 0411FA60 00000000 02903023 0286102b 8fa30024 02c33823 
	02711823 0263202b 8fa80020 02a82823 00a42023 afa30010 afa40014 afb70018 
	8fa40060 8fa50064 00e23823 0411FA4F 00000000 0211102a 10400006 8fbf005c 
	00101040 24420001 1000ff59 02429021 8fbf005c 8fbe0058 8fb70054 8fb60050 
	8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 03e00008 27bd0060 

'main
	27bdffb8 afbf0044 afb00040 00808021 00e01021 8faa0058 8fa9005c 8fa80060 
	8fab0064 8c830000 8c840004 00643825 14e00010 8fac0068 8ca50000 8cc70000 
	8c420000 afa20010 000217c3 afa20014 afaa0018 00a02021 00052fc3 00e03021 
	00073fc3 0411FA21 00000000 100000da 8fbf0044 24070001 14670018 24070002 
	14800016 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 
	afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 
	afa20020 afa30024 afa80028 0411F96B 00000000 100000c0 8fbf0044 14670021 
	24070003 1480001f 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c420000 
	afa20010 000217c3 afa20014 8d420000 afa20018 000217c3 afa2001c 8d220000 
	afa20020 000217c3 afa20024 8d020000 afa20028 000217c3 afa2002c 8d620000 
	afa20030 000217c3 afa20034 afac0038 0411FB4B 00000000 8e020000 1000009d 
	8e030004 14670019 24070004 14800017 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c420000 afa20010 000217c3 afa20014 8d420000 afa20018 000217c3 
	afa2001c 8d220000 afa20020 000217c3 afa20024 afa80028 0411FA0A 00000000 
	8e020000 10000083 8e030004 14670009 24070005 14800007 00000000 8ca40000 
	0411F887 00000000 8e020000 10000079 8e030004 14670009 24070007 14800007 
	00000000 8ca40000 0411F897 00000000 8e020000 1000006f 8e030004 14670022 
	24070008 14800020 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 
	8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 
	8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 8d620000 
	8d630004 afa20030 afa30034 afac0038 8fa2006c afa2003c 0411FDA7 00000000 
	1000004d 8fbf0044 1467001d 24070009 1480001b 00000000 8ca40000 8ca50004 
	8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 
	afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 
	afa20028 afa3002c afab0030 0411FA1D 00000000 8e020000 1000002e 8e030004 
	54670019 2402000a 54800017 2402000a 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 
	8d220000 8d230004 afa20020 afa30024 afa80028 0411FE15 00000000 8e020000 
	10000014 8e030004 14620009 2402000b 14800007 00000000 8ca40000 0411F89D 
	00000000 8e020000 1000000a 8e030004 14620009 8fbf0044 54800008 8fb00040 
	8ca40000 0411F84F 00000000 8e020000 8e030004 8fbf0044 8fb00040 03e00008 
	27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
	7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
	c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
	79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
	1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
	7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
	7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
	10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
	a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
	54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
	55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
	457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
	55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
	44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
	a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
	49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
	54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
	0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
	4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
	2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
	5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
	14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
	f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
	1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
	101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
	10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
	fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
	14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
	14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
	00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
	101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
	ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
	4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
	443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
	492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
	5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
	5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
	ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
	18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
	1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
End CFunction
'
'
sub I9341_initialise
  I9341.initdisplay
  print "Controller type :", hex$(I9341.rreg(&HD3), 4)
end sub
'
sub I9341_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  I9341.setrot(0)
  wi= I9341_params(0)
  ht= I9341_params(1)
  I9341.fillscreen(black)
  I9341.drect(0, 0, wi, ht, red)
  I9341.pstring(40, 40, "Welcome to the", 2, 0, green, black)
  I9341.pstring(5, 70, "Micromite MK2", 3, 0, red, black)
  I9341.pstring(60, 120, "in colour", 2, 0, yellow, black)
  I9341.pstring(58, 170,  "ILI9341 controller", 1, 0, cyan, black)
  pause 2000
' demo fast line draw
  I9341.setrot(I9341_normal)
  I9341.fillscreen(black)
  x0=0:y0=0:y1=ht-1
  for i=0 to 45 step 5
    tn=tan(rad(i))
    x1=wi*tn
    I9341.dline(x0, y0, x1, y1, red)
  next i
  x1=wi-1
  for i=0 to 40 step 5
    tn=tan(rad(i))
    y1=ht*tn
    I9341.dline(x0, y0, x1, y1, red)
  next i
  I9341.drect(0, 00, wi, ht, blue)
  pause 2000
  I9341.fillscreen(black)
'demo fast text write
  I9341.setrot(I9341_rt_right)
  for i=0 to wi-8 step 8
    I9341.pstring(0, i, "Hello world:Bye world:Hello world:Bye world:Hello world:Bye world", 1, I9341_normal, green, black)
  next i
  I9341.setrot(I9341_normal)
  pause 2000
  I9341.fillscreen(black)
  for i=ht-1 to 15 step -16
    I9341.pstring(wi-1, i, "Micromite MK2:Micromite MK2", 2, I9341_inverse, red, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  for i=24 to wi step 24
    I9341.pstring(i, 0, "Rotate right:Rotate right", 3, I9341_rt_right, yellow, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  for i=wi-32 to 0 step -32
    I9341.pstring(i, ht-1, "Rotate Left:Rotate Left", 4, I9341_rt_left, blue, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     I9341.setrot(i)
     I9341.frect(5, 5, 10, 15, blue)
     I9341.drect(2, 2, 16, 21, red)
  next i
  pause 2000
' test drawing rounded rectangles
  I9341.fillscreen(black)
  for i=0 to 3
     I9341.setrot(i)
     I9341.frndrect(5, 5, 10, 15, 4, blue)
     I9341.drndrect(2, 2, 16, 21, 6, red)
  next i
  pause 2000
  I9341.fillscreen(black)
' test drawing circles
  for i=0 to 3
     I9341.setrot(i)
     I9341.fcirc(10, 10, 7, blue)
     I9341.dcirc(10, 10, 9, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  I9341.fillscreen(black)
  for i=0 to 3
     I9341.setrot(i)
     I9341.ftri(4, 4, 20, 6, 12, 14, blue)
     I9341.dtri(1, 2, 24, 4, 12, 17, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  I9341.fillscreen(black)
  I9341.setrot(I9341_normal)
  I9341.pstring(wi/2, ht/2, "N", 3, I9341_normal, white, black)
  I9341.pstring(0, 0, "I9341_normal", sz, I9341_normal, red, black)
  I9341.pstring(wi-1, ht-1, "Inverted", sz, I9341_inverse, blue, black)
  I9341.pstring(wi-1, 0, "Rotated right", sz, I9341_rt_right, green, black)
  I9341.pstring(0, ht-1, "Rotated left", sz, I9341_rt_left, yellow, black)
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_inverse)
  I9341.pstring(wi/2, ht/2, "I", 3, I9341_inverse, white, black)
  I9341.pstring(0, 0, "I9341_normal", sz, I9341_normal, red, black)
  I9341.pstring(wi-1, ht-1, "Inverted", sz, I9341_inverse, blue, black)
  I9341.pstring(wi-1, 0, "Rotated right", sz, I9341_rt_right, green, black)
  I9341.pstring(0, ht-1, "Rotated left", sz, I9341_rt_left, yellow, black)
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_rt_right)
  I9341.pstring(ht/2, wi/2, "R", 3, I9341_rt_left, white, black)
  I9341.pstring(0, 0, "I9341_normal", sz, I9341_normal, red, black)
  I9341.pstring(ht-1, wi-1, "Inverted", sz, I9341_inverse, blue, black)
  I9341.pstring(ht-1, 0, "Rotated right", sz, I9341_rt_right, green, black)
  I9341.pstring(0, wi-1, "Rotated left", sz, I9341_rt_left, yellow, black)
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_rt_left)
  I9341.pstring(ht/2, wi/2, "L", 3, I9341_rt_right, white, black)
  I9341.pstring(0, 0, "I9341_normal", sz, I9341_normal, red, black)
  I9341.pstring(ht-1, wi-1, "Inverted", sz, I9341_inverse, blue, black)
  I9341.pstring(ht-1, 0, "Rotated right", sz, I9341_rt_right, green, black)
  I9341.pstring(0, wi-1, "Rotated left", sz, I9341_rt_left, yellow, black)
  pause 2000
  next sz
end SUB
