OPTION EXPLICIT
option default integer
   
  'Go run the TestSuite 
  TestSuite() 
   
END 
   
   '*********************************************************** ************************** 
  ' 
  ' Peter Mather (edited by Peter Carnegie) 
  ' 
  ' V1.1 
  ' 2014-12-11 
  ' 
  ' Monochrome Port of Adafruit graphics library with drivers for SPI SSD1306 display 
  ' 
  ' Initialise Display Library 
  ' You MUST call LCD.Init BEFORE any other call to this library 
  ' SUB LCD.Init(rs,cd,of,wi,ht,nr)              
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
'              ' 
  ' LCD.Init declares the following externally usable constants 
  '   LCD_ON=1 
  '   LCD_OFF=0 
  '   LCD_RT_RIGHT=2  Rotate Right 
  '   LCD_RT_LEFT=3   Rotate Left 
  '   LCD_NORMAL=0    Normal Aspect 
  '   LCD_INVERSE=1   Upside Down Aspect 
   
  ' The Drawing Primitives assume a graphics display where top left is point 0,0 
  ' The Drawing Primitives just update the memory image of the display 
  ' To actually update the physical display call SUB S_Refresh 
   
  ' Set screen orientation 
  ' SUB LCD.SetRot(x) 
  '     In : X  0=normal,1=invert,2=rotate right,3-rotate left 
   
  ' Draw circle 
  ' SUB LCD.DCirc(x0,y0,r) 
  '     In : x,y coordinates of centre,radius 
   
  ' Draw filled circle, ie a disc 
  ' SUB LCD.FCirc(x0,y0,r) 
  '     In: x,y coordinates of centre,r=radius 
   
  '     Draw triangle 
  ' SUB LCD.DTri(x0,y0, x1,y1, x2,y2)      
  '     In: three coordinate pairs representing each vertex 
   
  '     Draw filled triangle 
  ' SUB LCD.FTri (x0,y0, x1,y1, x2,y2) 
  '     In: three coordinate pairs representing each vertex 
   
  ' Print string 
  ' SUB LCD.PString(xx0,yy0,text$,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          text$,           String to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed text 
   
  ' Draw line 
  ' SUB LCD.DLine(xx0,yy0,xx1,yy1) 
  '     In:     x0,y0           start of line 
  '          x1,y1           end of line 
   
  '     Draw rectangle 
  ' SUB LCD.DRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  ' Draw filled rectangle 
  ' SUB LCD.FRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Clear rectangluar area 
  ' SUB LCD.CRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Draw rounded rectangle 
  ' SUB LCD.DRndRect(x,y,w,h,r) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
  '          radius                Radius of corners 
   
  ' Draw filled rounded rectangle 
  ' SUB LCD.FRndRect(x,y,w,h,r) 
  '       In:     x,y                Coordinate of top left corner 
  '            width               Width 
  '            height               Height 
  '            radius                Radius of corners 
   
  ' Update the physical display 
  ' SUB LCD.Refresh 
  '       In:     N/A 
   
  '     Clear the physical display and internal memory map 
  ' SUB LCD.Cls 
  '       In:     N/A 
   
  ' 
  ' Initialise Display Library 
  ' You MUST call LCD.Init BEFORE any other call to this library 
  ' SUB LCD.Init(rs,cd,cs,wi,ht,nr)               
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
' 
  ' LCD.Init declares the following externally usable constants 
  '   LCD_ON=1 
  '   LCD_OFF=0 
  '   LCD_RT_RIGHT=2  Rotate Right 
  '   LCD_RT_LEFT=3   Rotate Left 
  '   LCD_NORMAL=0    Normal Aspect 
  '   LCD_INVERSE=1   Upside Down Aspect 
  ' 

end
'
sub LCD.CMD(databyte as integer)
  local integer i,J
  i=SPI(LCD_CMD)
  i=spi(DATABYTE AND &HF0)
  i=spi((DATABYTE and &H0F)<<4)
  pause 2
end sub
'
sub LCD.xy(x as integer, y as integer)
  local integer i,xx=x,yy=y
  if yy>31 then
    xx=xx+8
    yy=yy-32
  endif
  i=SPI(LCD_CMD)
  i=spi((yy and &H10) or &H80)
  i=spi((yy and &H0F)<<4)
  i=spi(&H80)
  i=spi(xx<<4)
  pause 0.05
end sub

SUB LCD.Init(rs,cd,wi,ht,nr)
  IF wi=0 THEN wi=128 
  IF ht=0 THEN ht=64 
  IF nr=0 THEN nr=ht
 ' Global variables 
  dim LCD_RESET=rs
  dim LCD_CD=cd
  dim LCD_CMD=&B11111000
  dim LCD_DATA=&B11111010
  DIM INTEGER LCD_FontPtr,LCD_of,LCD_rot_wi,LCD_rot_ht
  DIM INTEGER LCD_params(6)
  
  'set up arrays for screen map to mimic display 
  DIM INTEGER LCD_sc(wi),LCD_dd(wi)  
   
  'Global Constants 
  'CFunction DRAW function Indexes [sic] 
  DIM Integer LCD_PIX=0,LCD_FFR=1,LCD_DRAWCHAR=2,LCD_DRAWLINE=3, LCD_PSTRING=4, LCD_FCIRCH=5, LCD_DCIRCH=6  
  DIM integer LCD_wi=0,LCD_ht=1,LCD_rot=2,LCD_nr=3,LCD_X=4,LCD_Y=5,LCD_seed=6  
    
  'Used by User program in calls to drawing primitives 
  DIM Integer LCD_ON=1,LCD_OFF=0 
  DIM Integer LCD_NORMAL=0,LCD_INVERSE=1,LCD_RT_RIGHT=2,LCD_RT_LEFT=3 
  LCD_params(LCD_wi)=wi
  LCD_params(LCD_ht)=ht
  LCD_params(LCD_rot)=LCD_NORMAL
  LCD_params(LCD_nr)=nr  
  LCD_params(LCD_seed)=LCD_DATA  
  LCD_FontPtr=PEEK(CFunAddr LCD_FONT) 
  local integer i
  spi open 1000000,3,8
  pin(LCD_RESET)=1
  pin(LCD_CD)=1
  setpin LCD_RESET,dout
  setpin LCD_CD,dout
  pin(LCD_RESET)=0
  pause 200
  PIN(LCD_RESET)=1
  pause 200
  PIN(LCD_CD)=1 ' continuous enable for the moment
  LCD.CMD(1) 'DISPLAY CLEAR
  LCD.CMD(&B00001100) 'display on
  LCD.CMD(1) 'DISPLAY CLEAR
  LCD.CMD(&B00100110) 'graphic mode
END SUB 
'
SUB LCD.Refresh() 
  LOCAL StartRow%,StartCol%,R%,i% 
  LOCAL OutChar$ length 150 
  do 
    R%=LCDUpdate(OutChar$,StartCol%,StartRow%,LCD_params(),LCD_sc(),LCD_dd()) 
    if r%<>0 then
      LCD.xy(0,startrow%)
      spi write R%,outchar$
    endif
  loop while R%<>0
END SUB 
   
  'Clear Screen 
SUB LCD.Cls 
  LOCAL i 
  FOR i=0 TO LCD_params(LCD_wi)-1 
    LCD_sc(i)=0 
    LCD_dd(i)=-1 
  NEXT i 
  LCD.Refresh
END SUB 
   
  ' 
  ' Generic drawing routines 
  ' 
sub LCD.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON,x0,y0,r,31,LCD_params())
end sub

   
SUB LCD.DTri(x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LCD.DLine(x0,y0,x1,y1) 
  LCD.DLine(x1,y1,x2,y2) 
  LCD.DLine(x2,y2,x0,y0) 
END SUB 

  
SUB LCD.FTri (x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LOCAL Integer a,b,y,dp,last 
  IF (y0>y1) THEN 
    LCD.Swap(y0,y1) 
    LCD.Swap(x0,x1) 
  ENDIF 
  IF (y1>y2) THEN 
    LCD.Swap(y2,y1) 
    LCD.Swap(x2,x1) 
  ENDIF 
  IF (y0>y1) THEN 
    LCD.Swap(y0,y1) 
    LCD.Swap(x0,x1) 
  ENDIF 
  IF(y0=y2) THEN ' Handle awkward all-on-same-line case as its own thing 
    a=x0 
    b=x0 
    IF(x1<a) THEN 
      a=x1 
    ELSE 
      IF(x1>b) THEN b=x1 
    ENDIF 
    IF(x2<a) THEN 
      a=x2 
    ELSE 
      IF(x2>b) THEN b=x2 
    ENDIF 
     dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,a,y0,1,b-a+1,LCD_params()) 
    EXIT SUB 
  ENDIF 
   
  LOCAL Integer dx01=x1-x0, dy01=y1-y0, dx02=x2-x0, dy02=y2-y0,dx12=x2-x1, dy12=y2-y1, sa=0,sb=0 
   
  IF(y1=y2) THEN 
    last=y1 'Include y1 scanline 
  ELSE 
    last=y1-1 ' Skip it 
  ENDIF 
   
  FOR y=y0 TO last 
    a=x0+sa \ dy01 
    b=x0+sb \ dy02 
    sa=sa+dx01 
    sb=sb+dx02 
    a=x0+(x1-x0) * (y-y0) \ (y1-y0) 
    b=x0+(x2-x0) * (y-y0) \ (y2-y0) 
    IF(a>b) THEN LCD.Swap(a,b) 
     dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,a,y,b-a+1,1,LCD_params()) 
  NEXT y 
   
  sa=dx12 * (y-y1) 
  sb=dx02 * (y-y0) 
   
  DO WHILE y<=y2 
    a=x1+sa \ dy12 
    b=x0+sb \ dy02 
    sa=sa+dx12 
    sb=sb+dx02 
    a=x1+(x2-x1) * (y-y1) \ (y2-y1) 
    b=x0+(x2-x0) * (y-y0) \ (y2-y0) 
    IF(a>b) THEN LCD.Swap(a,b) 
     dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,a,y,b-a+1,1,LCD_params()) 
    y=y+1 
  LOOP 
END SUB 

   

sub LCD.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer screen,i
  screen=LCD_params(LCD_wi)+(LCD_ht<<32)
  i=LCDdraw(LCD_pstring,LCD_FontPtr,LCD_ON,xx0,yy0,sz,orientation,LCD_params(),LCD_sc(),text$)
  xx0=LCD_params(LCD_X)
  yy0=LCD_params(LCD_Y)
end sub

SUB LCD.DLine(xx0%,yy0%,xx1%,yy1%) ' x,y of start line,x,y of end line 
  LOCAL  dp%=LCDdraw(LCD_DRAWLINE,LCD_sc(),LCD_ON,xx0%,yy0%,xx1%,yy1%,LCD_params()) 
END SUB 


SUB LCD.Swap(a%,b%) 
  LOCAL t% 
  t%=b% 
  b%=a% 
  a%=t% 
END SUB 


SUB LCD.DRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,LCD_params(LCD_wi),LCD_ht 
  LOCAL  Integer a,dp 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,w,1,LCD_params()) 
  a=y+h-1 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,a,w,1,LCD_params()) 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,1,h,LCD_params()) 
  a=x+w-1 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,a,y,1,h,LCD_params()) 
END SUB 


SUB LCD.FRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,w,h,LCD_params()) 
END SUB 


SUB LCD.CRect(x AS integer,y AS integer,w AS integer,h AS integer) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_OFF,x,y,w,h,LCD_params()) 
END SUB 


SUB LCD.FCirc(x0%,y0%,r%)  'x,y coordinates of centre,radius 
  LOCAL  dp%=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x0%,y0%-r%,1,2*r%+1,LCD_params()) 
  dp%=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x0%, y0%, r%, 3, 0,  LCD_params())
END SUB 
   
   
SUB LCD.DRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer ) 'x,y coordinates of top left,width,height,radius of corner
  LOCAL Integer dp 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y,w-2*r,1,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y+h-1,w-2*r,1,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y+r,1,h-2*r,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+w-1,y+r,1,h-2*r,LCD_params()) 
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+r, y+r, r, 1,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+w-r-1, y+r, r, 2,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+w-r-1, y+h-r-1, r, 4,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+r, y+h-r-1, r, 8,LCD_params())
END SUB 


SUB LCD.FRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer) 'x,y coordinates of top left,width,height,radius of corner 
  LOCAL Integer dp 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y,w-2*r,h,LCD_params()) 
   dp=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x+w-r-1, y+r, r, 1, h-2*r-1, LCD_params())
   dp=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x+r, y+r, r, 2, h-2*r-1, LCD_params())
END SUB 


SUB LCD.SetRot(x%) 'sets screen rotation: 0=normal,1=invert,2=rotate right,3-rotate left 
  LCD_params(2)=(x% AND 3) 
  LCD_rot_wi=LCD_params(LCD_wi) 
  LCD_rot_ht=LCD_params(LCD_ht)
  IF x%>=2 THEN 
    LCD_rot_wi=LCD_params(LCD_ht) 
    LCD_rot_ht=LCD_params(LCD_wi) 
  ENDIF 
END SUB 
'
CFunction LCDupdate
	00000000
	27bdfff0 afb2000c afb10008 afb00004 8fa90020 8faa0024 8ce80000 aca00000 
	8ce20030 8ce30034 00431825 10600003 00006821 a0820001 240d0002 0008c02b 
	1300001e 01406021 8d230000 8d420000 00621826 8d250004 8d420004 00a21026 
	00621025 14400015 25230008 25420008 00002821 24a50001 00605821 00406021 
	00a8702b 8c6f0000 8c470000 01e77826 8c790004 8c470004 03273826 01e73825 
	2ce70001 01c73824 24630008 14e0fff1 24420008 10000004 00001021 01205821 
	00002821 00001021 50a8004f a0820000 acc00000 8d850000 8d620000 00a22826 
	30a50001 24020001 14a00015 00001821 00027fc2 00037040 00023840 01ee2825 
	00e01021 00a01821 8cce0000 25ce0001 acce0000 8d8f0000 8d6e0000 01ee7826 
	8d990004 8d6e0004 032e7026 01e73824 01c52824 00e52825 10a0ffee 00027fc2 
	1300002f 00029027 00007021 00002821 0000c021 00038827 24100007 24190001 
	240f0003 000530c0 01263821 8cec0000 01826024 8ce70004 00e33824 01873825 
	10e0000d 30ab0003 01463021 8cc70000 00e23825 acc70000 8cc70004 00e33825 
	acc70004 020b3023 00d93004 01c67025 10000008 31ce00ff 01463021 8cc70000 
	00f23824 acc70000 8cc70004 00f13824 acc70004 156f0007 24a50001 17000005 
	00000000 008d3021 a0ce0000 25ad0001 03007021 00a8302b 14c0ffdb 000530c0 
	25a2ffff a0820000 00001821 8fb2000c 8fb10008 8fb00004 03e00008 27bd0010 
End CFunction

'
CFunction LCDdraw
'localfastfillrect
	000008A7
	27bdffa0 afbe005c afb70058 afb60054 afb50050 afb4004c afb30048 afb20044 
	afb10040 afb0003c 8fb80070 8fae0074 8fb10078 8fb9007c 8fb40080 8fb50084 
	8fa90088 afa90028 8fb6008c 8fb00090 8e0d0010 8e0f0014 8e120000 8e090004 
	8e130008 8e10000c 2417ffff a3b70008 241efffe a3be0009 241efffc a3be000a 
	241efff8 a3be000b 241efff0 a3be000c 241effe0 a3be000d 241effc0 a3be000e 
	241eff80 a3be000f 241e0001 a3be0010 241e0003 a3be0011 241e0007 a3be0012 
	241e000f a3be0013 241e001f a3be0014 241e003f a3be0015 241e007f a3be0016 
	a3b70017 01afb825 56e0003d 24170001 01c9102a 14400007 2702ffff 152e01d3 
	00001021 0312102b 104001d0 00001021 2702ffff 0058282b 25c3ffff 00a32821 
	00541821 0062102b 00b52821 00451021 00402821 0049102a 1440000a 00606021 
	55250005 264cffff 0072182b 14600006 0330102a 264cffff 0192282b 2522ffff 
	00a22821 0330102a 14400007 2622ffff 161901b6 00001021 0233102b 104001b3 
	00001021 2622ffff 0051402b 2723ffff 01034021 8faa0028 004a1821 0062102b 
	01164021 00481021 00404021 0050102a 144001a8 afa30020 56080005 266cffff 
	0073182b 546001a4 02201021 266cffff 0193282b 2602ffff 1000019e 00a22821 
	55b70035 24170002 55e00033 24170002 0018c027 000e7027 03129021 0258c02b 
	01c94821 03094821 02406021 0520018e 01202821 00118827 0019c827 02339821 
	0271882b 03308021 02308021 afb30020 06000185 02004021 24020001 0054a023 
	0054102b 01224823 02929021 0254a02b 0135a823 02955021 000a1fc3 00037827 
	000fc7c3 02581024 01581824 00405821 00605021 24020001 8fad0028 004d4823 
	0049102b 02028023 01339821 0269482b 0216b023 01366821 000d7fc3 000fc827 
	001987c3 02707024 01b07824 01c01021 1000008e 01e01821 55b7004f 24170003 
	55e0004d 24170003 00111827 00192827 00721021 0043182b 00a92821 00651821 
	00602821 0069182a 1460000a 00406021 55250005 264cffff 0052102b 14400006 
	24020001 264cffff 0192282b 2522ffff 00a22821 24020001 8faa0028 004a4023 
	0048102b 00a21023 010c1821 0068402b 00561023 00605821 01025021 000a47c3 
	000a1827 afa30030 00084027 afa80034 00081fc3 afa30020 afa30024 01631024 
	01431824 00405821 01d0102a 14400006 00605021 160e0135 00001021 0313102b 
	10400132 00001021 2702ffff 0058402b 25c3ffff 01034021 00541821 0062102b 
	01154021 00481021 00404021 0050102a 1440000e afa30020 16080005 2662ffff 
	0073182b 5460000a 03001021 2662ffff 0053402b 2603ffff afa20020 01034021 
	03001021 10000003 01c01821 03001021 01c01821 24170003 55b7003d 0003c7c3 
	55e0003b 0003c7c3 0329102a 14400007 2622ffff 1539010d 00001021 0232102b 
	1040010a 00001021 2622ffff 0051282b 2723ffff 00a32821 8faa0028 004a1821 
	0062102b 00b6b021 00561021 00402821 0049102a 1440000a 00606021 55250005 
	264cffff 0072182b 54600006 0018c027 264cffff 0192282b 2529ffff 00a92821 
	0018c027 000e7027 03139821 0278c02b 01d08021 03108021 afb30020 060000ea 
	02004021 24020001 0054a023 0054102b 02028023 02939821 0274a02b 0215a823 
	02954821 02601021 05200004 01201821 02205821 10000005 03205021 02205821 
	03205021 00001021 00001821 0003c7c3 33180007 0302a021 0298c02b 0303c021 
	00184f40 0014a0c2 0134a025 0018c0c3 0280c821 00086fc3 31ad0007 8faf0020 
	01af4821 012d682b 01a84021 00086f40 000948c2 01a94825 0008b0c3 01208821 
	02c0f021 0014a0c0 0054a023 000948c0 01e94823 17310038 afa90020 17160037 
	27350001 00aa102a 14400035 02b9b82b 15450004 000b68c0 018b102b 14400031 
	02f8b821 008d6821 01607021 01407821 00c7b825 03b98021 8fa20020 03a2a821 
	03b49821 01a09021 8da20000 8da30004 afa20000 12e00008 afa30004 92a30010 
	92620008 00621024 92030000 00431025 10000008 a2020000 92a30010 92620008 
	00621024 00021027 92030000 00431024 a2020000 8fa80000 8fa90004 ae480000 
	ae490004 25c20001 004e702b 01cf1821 00407021 00607821 00a3182a 14600006 
	25ad0008 15e5ffe0 01a09021 0182102b 5040ffde 8da20000 27350001 02b9b82b 
	02f8b821 02a06821 02d7102a 14400041 02e0c021 16fe0005 00aa102a 0235102b 
	5440003d 02f6b02a 00aa102a 5440003a 02f6b02a 15450004 000b18c0 018b102b 
	54400035 02f6b02a 00831821 01607021 01407821 00c79025 03b91021 03b4a021 
	03b1c821 8fa80020 03a89821 00608021 8c680000 8c690004 afa80000 1240000a 
	afa90004 92890008 90480000 01284025 a0480000 92690010 93280000 01284025 
	1000000b a3280000 92880008 00084027 90490000 01094024 a0480000 92680010 
	00084027 93290000 01094024 a3280000 8fa80000 8fa90004 ae080000 ae090004 
	25c80001 010e702b 01cf4821 01007021 01207821 00a9482a 15200006 24630008 
	15e5ffdb 00608021 0188402b 5100ffd9 8c680000 02f6b02a 56c00006 03b5a821 
	57d80042 8fbe005c 02b1102b 10400034 03b5a821 00aa782a 000b10c0 00822021 
	00c73025 2407ffff 10000023 018bc82b 01008021 8d020000 8d030004 afa20000 
	10c00003 afa30004 10000002 a2a70000 a2a00000 8fa20000 8fa30004 ae020000 
	ae030004 25220001 0049482b 012e1821 00404821 00607021 00a3182a 14600006 
	25080008 15c5ffeb 01008021 0182102b 5040ffe9 8d020000 25a20001 004d182b 
	00406821 0078c021 14510003 26b50001 531e0016 8fbe005c 15e0fff8 25a20001 
	55450004 00804021 1720fff5 004d182b 00804021 01604821 1000ffd5 01407021 
	1000000a 8fbe005c 00001021 10000006 00001821 02201021 03201821 03005821 
	1000fee4 01c05021 8fbe005c 8fb70058 8fb60054 8fb50050 8fb4004c 8fb30048 
	8fb20044 8fb10040 8fb0003c 03e00008 27bd0060 

'localdrawPixel
27bdfff8 afb10004 afb00000 
	8fb80018 8faf001c 8fae0020 8fad0024 8fa30028 8c6a0010 8c6c0014 8c700000 
	8c6b0004 8c710008 014cc825 17200006 8c63000c 03004821 01e01021 01c04021 
	10000020 01a02821 24190001 15590010 24190002 1580000e 00000000 0018c027 
	000f7827 03104821 0138c02b 01eb7821 030f1021 000e7027 000d6827 01d14021 
	010e702b 01a36821 1000001a 01cd2821 1559000d 24190003 1580000b 00000000 
	03004021 01e02821 000e7027 000d6827 01d04821 012e702b 01ab6821 1000000d 
	01cd1021 24190003 5559000b 004b602b 15800008 0018c027 000f7827 03114021 
	0118c02b 01e37821 030f2821 01c04821 01a01021 004b602b 15800007 240a0001 
	55620005 00005021 0130802b 16000003 314a00ff 00005021 314a00ff 1140003a 
	00a3502b 15400007 24020001 54650005 00001021 0111882b 16200003 304200ff 
	00001021 304200ff 1040002f 00c73025 10c00015 00001021 14a00008 00001821 
	14a00004 24050001 2d050020 10a00004 24050001 10000003 01051004 24050001 
	01051804 000928c0 00852021 8c850000 00a22825 ac850000 8c850004 00a32825 
	10000016 ac850004 54a00009 24050001 14a00003 24050001 2d020020 10400005 
	01052804 00051027 10000004 2403ffff 01052804 00051827 2402ffff 000928c0 
	00852021 8c850000 00a22824 ac850000 8c850004 00a32824 ac850004 01202021 
	10000003 01002821 00002021 00002821 00801021 00a01821 8fb10004 8fb00000 
	03e00008 27bd0008 

'drawline
27bdffa8 afbf0054 afbe0050 afb7004c afb60048 afb50044 
	afb40040 afb3003c afb20038 afb10034 afb00030 0080a821 afa60060 afa70064 
	8fa20068 8fa30070 8fa40078 8fa50080 8fb70088 00408021 00609021 00809821 
	0065a02a 00a33023 00653823 00f4300a 00c0a021 0044402a 00823823 00443023 
	00e8300b 00d4a02a 12800005 00a0b021 00a09821 0080b021 00608021 00409021 
	0270102a 10400008 0256102a 02401021 02c09021 0040b021 02001021 02608021 
	00409821 0256102a 10400008 0270f023 02d2b023 001e8fc2 023e8821 00118843 
	24020001 10000007 afa20028 0256b023 001e8fc2 023e8821 00118843 2402ffff 
	afa20028 0270102a 14400025 8fbf0054 5280000f afb00010 afb20010 001217c3 
	afa20014 afb00018 001017c3 afa2001c afb70020 02a02021 8fa60060 8fa70064 
	0411FF24 00000000 1000000d 02368823 001017c3 afa20014 afb20018 001217c3 
	afa2001c afb70020 02a02021 8fa60060 8fa70064 0411FF17 00000000 02368823 
	06210004 26100001 8fa20028 02429021 023e8821 0270102a 1040ffdd 8fbf0054 
	8fbe0050 8fb7004c 8fb60048 8fb50044 8fb40040 8fb3003c 8fb20038 8fb10034 
	8fb00030 03e00008 27bd0058 

'drawchar
27bdff50 afbf00ac afbe00a8 afb700a4 afb600a0 
	afb5009c afb40098 afb30094 afb20090 afb1008c afb00088 afa400b0 8fa200c8 
	afa20058 8fa300cc afa30060 8fa400d0 afa40064 8fa500d4 afa50068 8fb000d8 
	8fb400dc 8fa200e0 afa20070 8fa300e4 afa30078 afa60038 00431025 14400090 
	afa7003c 8fa50058 24a20005 0045182b afa2004c 8fa60060 00661821 afa30054 
	27b50038 24020005 afa20050 0200b021 0280b821 0200f021 1000006c afb4005c 
	92a20000 02021007 30420001 10400028 24060001 24030001 17c30013 8fa30044 
	8fa4005c 54800011 afa30010 8fa5004c afa50010 8fa60054 afa60014 afb20018 
	afb4001c 8fa200e8 afa20020 8fa400b0 8fa600c0 8fa700c4 0411FEBE 00000000 
	10000038 26100001 afa30010 8fa40048 afa40014 afb10018 afb3001c afb60020 
	afb70024 afb60028 afb7002c 8fa500e8 afa50030 8fa400b0 8fa600c0 8fa700c4 
	0411FC87 00000000 10000026 26100001 17c60013 8fa60044 8fa2005c 54400011 
	afa60010 8fa3004c afa30010 8fa40054 afa40014 afb20018 afb4001c 8fa500e8 
	afa50020 8fa400b0 00003021 00003821 0411FE98 00000000 10000012 26100001 
	afa60010 8fa20048 afa20014 afb10018 afb3001c afb60020 afb70024 afb60028 
	afb7002c 8fa300e8 afa30030 8fa400b0 00003021 00003821 0411FC61 00000000 
	26100001 02361021 0051182b 02779821 00408821 00739821 26420001 0052182b 
	00409021 24040008 1604ffa5 0074a021 8fa50050 24a5ffff afa50050 8fa6004c 
	24c2ffff 0046202b 8fa50054 24a3ffff afa2004c 00831821 afa30054 8fa60050 
	2402ffff 10c200ca 26b50001 8fa40050 009e0019 00001012 00001810 8fa5005c 
	70a43002 00c31821 8fa50058 00452021 0082282b 8fa60060 00661021 afa40044 
	00a21021 afa20048 8fb20064 8fb40068 02408821 02809821 1000ff81 00008021 
	24020001 8fa30070 146200b5 24020002 8fa40078 148000b2 00142023 00101023 
	0002182b afa2007c 00832023 afa40080 8fa50058 24a20001 0045202b 8fa60060 
	00862021 00501823 0043102b 00942023 afa3005c 00822023 afa4006c afa50050 
	afa60054 27b6003d 27a20037 afa20040 8fa30064 2463fff9 afa30074 8fa40064 
	24820001 0044182b 8fa50068 00651821 0050a823 0055102b 00741823 00621823 
	afa3004c 8fbe00e8 1000007b 02009021 92c20000 02021007 30420001 1040002e 
	00000000 16570011 8fa30044 56800010 afa30010 8fa60050 afa60010 8fa20054 
	afa20014 afb10018 afb3001c afbe0020 8fa400b0 8fa600c0 8fa700c4 0411FE15 
	00000000 10000048 2610ffff afa30010 8fa40048 afa40014 02120019 00001012 
	00001810 72902002 00831821 02a22023 02a4282b 8fa6004c 00c31023 00452823 
	afa40018 afa5001c afb20020 afb40024 afb20028 afb4002c afbe0030 8fa400b0 
	8fa600c0 8fa700c4 0411FBD5 00000000 1000002d 2610ffff 16570011 8fa40044 
	56800010 afa40010 8fa20050 afa20010 8fa30054 afa30014 afb10018 afb3001c 
	afbe0020 8fa400b0 00003021 00003821 0411FDE8 00000000 1000001b 2610ffff 
	afa40010 8fa50048 afa50014 02120019 00001012 00001810 72902002 00831821 
	02a22023 02a4282b 8fa6004c 00c31023 00452823 afa40018 afa5001c afb20020 
	afb40024 afb20028 afb4002c afbe0030 8fa400b0 00003021 00003821 0411FBA8 
	00000000 2610ffff 26220001 0051182b 00408821 2402ffff 1602ff9d 00739821 
	8fa3005c 8fa4007c 00641021 0043202b 8fa5006c 8fa60080 00a61821 afa2005c 
	00831821 afa3006c 8fa30050 2462ffff 0043202b 8fa50054 24a3ffff afa20050 
	00831821 afa30054 26d6ffff 8fa60040 52c600b2 02408021 8fa2005c afa20044 
	8fa3006c afa30048 8fa40074 8fa50064 0085982b 8fa60068 24c2ffff 00808821 
	02629821 24100007 1000ff79 24170001 03c08021 8fb4005c 24020002 8fa30070 
	1462009f 24020003 8fa40078 1480009d 8fa30070 00101023 0002182b 00142023 
	afa2006c 00832023 afa40070 8fa50058 24a20001 0045202b 8fa60060 00862021 
	00501823 0043102b 00942023 afa30050 00822023 afa40054 afa0004c 0200b021 
	0280b821 27a20037 afa20040 0200f021 10000075 afb4005c 92020000 02a21024 
	10400028 24060001 24030001 17c30013 8fa30044 8fa4005c 54800011 afa30010 
	8fa50058 afa50010 8fa60060 afa60014 afb20018 afb4001c 8fa200e8 afa20020 
	8fa400b0 8fa600c0 8fa700c4 0411FD69 00000000 10000038 2610ffff afa30010 
	8fa40048 afa40014 afb10018 afb3001c afb60020 afb70024 afb60028 afb7002c 
	8fa500e8 afa50030 8fa400b0 8fa600c0 8fa700c4 0411FB32 00000000 10000026 
	2610ffff 17c60013 8fa60044 8fa2005c 54400011 afa60010 8fa30058 afa30010 
	8fa40060 afa40014 afb20018 afb4001c 8fa500e8 afa50020 8fa400b0 00003021 
	00003821 0411FD43 00000000 10000012 2610ffff afa60010 8fa20048 afa20014 
	afb10018 afb3001c afb60020 afb70024 afb60028 afb7002c 8fa300e8 afa30030 
	8fa400b0 00003021 00003821 0411FB0C 00000000 2610ffff 02361021 0051182b 
	02779821 00408821 00739821 26420001 0052182b 00409021 8fa40040 1604ffa6 
	0074a021 8fa5004c 24a50001 afa5004c 8fa60050 8fa3006c 00c31021 0046202b 
	8fa50054 8fa60070 00a61821 afa20050 00831821 afa30054 8fa30058 2462ffff 
	0043202b 8fa50060 24a3ffff afa20058 00831821 afa30060 8fa6004c 24020008 
	10c200dc 8fa20038 24030001 8fa4004c 0083a804 8fa50050 afa50044 8fa60054 
	afa60048 27b0003d 8fb20064 8fb40068 02408821 1000ff80 02809821 24020003 
	8fa30070 146200ca 8fa40078 148000c8 00101023 0002182b 00142023 afa20074 
	00832023 afa40078 00101742 001418c0 00431825 001020c0 00901023 0082202b 
	00741823 00641823 8fa50058 00452021 0082102b 8fa60060 00661821 afa40054 
	00431821 afa3005c 24a20007 0045182b afa2004c 00661821 afa30060 24020007 
	afa20050 8fa30064 24620001 0043282b 8fa40068 00a42821 00101823 0003202b 
	00143023 00c42023 00033782 00042080 00c43025 00032080 00901821 0064202b 
	00d43021 00862021 000337c2 00042040 00c42025 00031840 00431821 afa3006c 
	0062102b 00a41821 00431821 afa3007c 8fa50064 24a5fffb afa50070 8fa60064 
	00a6182b 8fa40068 2482ffff 00621021 afa20064 0280b021 10000074 0200a021 
	92020000 02e21024 50400027 24020001 24050001 16850012 8fa40048 56c00011 
	afa40010 8fa6004c afa60010 8fa20060 afa20014 afb20018 afb5001c 8fa300e8 
	afa30020 8fa400b0 8fa600c0 8fa700c4 0411FCA0 00000000 10000037 26100001 
	afa40010 8fa50058 afa50014 afb10018 afb3001c afb40020 afb60024 afb40028 
	afb6002c 8fa600e8 afa60030 8fa400b0 8fa600c0 8fa700c4 0411FA69 00000000 
	10000025 26100001 16820012 8fa60048 56c00011 afa60010 8fa3004c afa30010 
	8fa40060 afa40014 afb20018 afb5001c 8fa500e8 afa50020 8fa400b0 00003021 
	00003821 0411FC7B 00000000 10000012 26100001 afa60010 8fa20058 afa20014 
	afb10018 afb3001c afb40020 afb60024 afb40028 afb6002c 8fa300e8 afa30030 
	8fa400b0 00003021 00003821 0411FA44 00000000 26100001 023e1021 0051182b 
	8fa40044 02649821 00408821 00739821 26420001 0052182b 00409021 8fa50040 
	1605ffa7 0075a821 8fa60050 24c6ffff afa60050 8fa30054 8fa40074 00641021 
	0043202b 8fa5005c 8fa60078 00a61821 afa20054 00831821 afa3005c 8fa3004c 
	2462ffff 0043202b 8fa50060 24a3ffff afa2004c 00831821 afa30060 2402ffff 
	8fa60050 10c20013 8fa20038 24170001 8fa20050 0057b804 8fa30054 afa30048 
	8fa4005c afa40058 27b00038 0280f021 afb60044 8fb1006c 8fb3007c 8fb20070 
	8fb50064 27a5003e 1000ff7d afa50040 8fa20038 8fa3003c 8fbf00ac 8fbe00a8 
	8fb700a4 8fb600a0 8fb5009c 8fb40098 8fb30094 8fb20090 8fb1008c 8fb00088 
	03e00008 27bd00b0 

'pstring
27bdff78 afbf0084 afbe0080 afb7007c afb60078 afb50074 
	afb40070 afb3006c afb20068 afb10064 afb00060 afa40048 afa60090 afa70094 
	8fb10098 8fb4009c 8fb300a0 8fb500a4 8fa200a8 afa20040 8fa300ac afa30044 
	8fb600b0 8fbe00b4 8fb700c0 92e20000 18400076 8fb000b8 8fa40040 00041fc2 
	8fa50044 00051040 00621025 00042040 00042f82 00021880 00a31825 8fa60040 
	000628c0 00a42023 00a4282b 00621023 afa40050 00451023 afa20054 00061023 
	0002182b 8fa50044 00052023 00831823 00022782 00031880 00831825 00022080 
	00861021 0044202b 00651821 00831821 00022fc2 00031840 00021040 afa20058 
	00a31825 afa3005c 24120001 02de3025 afa6004c 02f21021 90420000 000210c0 
	8fa30048 00431021 8c460000 8c470004 8fa40090 8fa50094 afa40010 afa50014 
	afb10018 afb4001c afb30020 afb50024 8fa50040 afa50028 8fa20044 afa2002c 
	afb60030 afbe0034 afb00038 8fa400bc 0411FCC6 00000000 8fa3004c 14600009 
	24060001 8fa40050 02241021 0051182b 8fa50054 0285a021 00408821 10000017 
	0074a021 16c6000a 24050002 17c00008 8fa30058 02231021 0051182b 8fa4005c 
	0284a021 00408821 10000017 0074a021 56c5000b 24050003 17c00008 8fa60050 
	02661021 0053182b 8fa40054 02a4a821 00409821 1000000c 0075a821 24050003 
	56c5000a ae110020 17c00007 8fa60058 02661021 0053182b 8fa4005c 02a4a821 
	00409821 0075a821 ae110020 ae140024 ae130028 ae15002c 26520001 92e20000 
	0052102a 1040ffb4 02f21021 00001021 00001821 8fbf0084 8fbe0080 8fb7007c 
	8fb60078 8fb50074 8fb40070 8fb3006c 8fb20068 8fb10064 8fb00060 03e00008 
	27bd0088 

'dcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 
	afb30054 afb20050 afb1004c afb00048 0080b821 afa60078 afa7007c 8fb40080 
	8fb60084 8fb30088 8fb5008c 8fb00090 8fb20094 8fa20098 afa20034 8fbe00a0 
	30420010 10400037 02008821 afb40010 afb60014 02131021 0050202b 02551821 
	00831821 afa20018 afa3001c afbe0020 02e02021 0411FB5F 00000000 afb40010 
	afb60014 02701023 0262182b 02b22023 00831823 afa20018 afa3001c afbe0020 
	02e02021 8fa60078 8fa7007c 0411FB51 00000000 02141021 0050202b 02561821 
	00831821 afa20010 afa30014 afb30018 afb5001c afbe0020 02e02021 8fa60078 
	8fa7007c 0411FB43 00000000 02901023 0282182b 02d29023 02439023 afa20010 
	afb20014 afb30018 afb5001c afbe0020 02e02021 8fa60078 8fa7007c 0411FB35 
	00000000 1a2000d7 24120001 02509023 00108023 00108040 afb00030 00008021 
	8fa30034 30630004 afa30038 8fa50034 30a50002 afa5003c 8fa20034 30420008 
	afa20040 8fa30034 30630001 afa30034 06400005 8fa50030 2631ffff 24a50002 
	afa50030 02459021 8fa20038 1040002b 26100001 00101fc3 afa30028 00112fc3 
	afa5002c 02141021 0050202b 00761821 00831821 afa20010 afa30014 02331021 
	0051202b 00b51821 00831821 afa20018 afa3001c afbe0020 02e02021 8fa60078 
	8fa7007c 0411FB03 00000000 02341021 0051202b 8fa5002c 00b61821 00831821 
	afa20010 afa30014 02131021 0050202b 8fa50028 00b51821 00831821 afa20018 
	afa3001c afbe0020 02e02021 8fa60078 8fa7007c 0411FAEF 00000000 8fa2003c 
	1040002c 8fa20040 00101fc3 afa30028 00112fc3 afa5002c 02141021 0050202b 
	00761821 00831821 afa20010 afa30014 02711023 0262182b 02a52023 00831823 
	afa20018 afa3001c afbe0020 02e02021 8fa60078 8fa7007c 0411FAD6 00000000 
	02341021 0051202b 8fa5002c 00b61821 00831821 afa20010 afa30014 02701023 
	0262182b 8fa50028 02a52023 00831823 afa20018 afa3001c afbe0020 02e02021 
	8fa60078 8fa7007c 0411FAC2 00000000 8fa20040 1040002e 8fa20034 00111fc3 
	afa30028 00102fc3 afa5002c 02911023 0282182b 8fa50028 02c52023 00831823 
	afa20010 afa30014 02131021 0050202b 8fa5002c 00b51821 00831821 afa20018 
	afa3001c afbe0020 02e02021 8fa60078 8fa7007c 0411FAA7 00000000 02901023 
	0282182b 8fa5002c 02c52023 00831823 afa20010 afa30014 02331021 0051202b 
	8fa50028 00b51821 00831821 afa20018 afa3001c afbe0020 02e02021 8fa60078 
	8fa7007c 0411FA93 00000000 8fa20034 1040002e 0211102a 00111fc3 afa30028 
	00102fc3 afa5002c 02911023 0282182b 8fa50028 02c52023 00831823 afa20010 
	afa30014 02701023 0262182b 8fa5002c 02a52023 00831823 afa20018 afa3001c 
	afbe0020 02e02021 8fa60078 8fa7007c 0411FA78 00000000 02901023 0282182b 
	8fa5002c 02c52023 00831823 afa20010 afa30014 02711023 0262182b 8fa50028 
	02a52023 00831823 afa20018 afa3001c afbe0020 02e02021 8fa60078 8fa7007c 
	0411FA64 00000000 0211102a 10400006 8fbf006c 00101040 24420001 1000ff3c 
	02429021 8fbf006c 8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 
	8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'fcirch
27bdff88 afbf0074 afbe0070 
	afb7006c afb60068 afb50064 afb40060 afb3005c afb20058 afb10054 afb00050 
	afa40078 afa60080 afa70084 8fb60088 8fa2008c afa20040 8fb40090 8fa30094 
	afa30044 8fb50098 8fa200a0 8fbe00a8 8fb700ac 1aa000ad 02a08021 24130001 
	02759823 0015a823 0015a840 24120003 00008821 30450001 afa50048 30420002 
	afa2004c 06600004 8fa60048 2610ffff 26b50002 02759821 10c0004b 26310001 
	001117c3 afa20038 00101fc3 afa3003c 02361021 0051202b 8fa50038 8fa60040 
	00a61821 00831821 afa20010 afa30014 02901023 0282182b 8fa50044 8fa6003c 
	00a62023 00831823 afa20018 afa3001c 24020001 00001821 afa20020 afa30024 
	00101040 24420001 000227c3 005e1821 0062102b 00972021 00441021 afa30028 
	afa2002c 8fa300b0 afa30030 8fa40078 8fa60080 8fa70084 0411F7D9 00000000 
	02161021 0050202b 8fa5003c 8fa60040 00a61821 00831821 afa20010 afa30014 
	02911023 0282182b 8fa50044 8fa60038 00a62023 00831823 afa20018 afa3001c 
	24020001 00001821 afa20020 afa30024 00121fc3 025e1021 0052202b 00771821 
	00831821 afa20028 afa3002c 8fa300b0 afa30030 8fa40078 8fa60080 8fa70084 
	0411F7B7 00000000 8fa5004c 10a0004b 0230102a 001137c3 afa60038 001017c3 
	afa2003c 02d11023 02c2182b 8fa50040 00a62023 00831823 afa20010 afa30014 
	02901023 0282182b 8fa60044 8fa5003c 00c52023 00831823 afa20018 afa3001c 
	24020001 00001821 afa20020 afa30024 00101040 24420001 000227c3 005e1821 
	0062102b 00972021 00441021 afa30028 afa2002c 8fa300b0 afa30030 8fa40078 
	8fa60080 8fa70084 0411F78D 00000000 02d01023 02c2182b 8fa50040 8fa6003c 
	00a62023 00831823 afa20010 afa30014 02911023 0282182b 8fa50044 8fa60038 
	00a62023 00831823 afa20018 afa3001c 24020001 00001821 afa20020 afa30024 
	00121fc3 025e1021 0052202b 00771821 00831821 afa20028 afa3002c 8fa300b0 
	afa30030 8fa40078 8fa60080 8fa70084 0411F76B 00000000 0230102a 10400003 
	02729821 1000ff5f 26520002 8fbf0074 8fbe0070 8fb7006c 8fb60068 8fb50064 
	8fb40060 8fb3005c 8fb20058 8fb10054 8fb00050 03e00008 27bd0078 

'main
27bdffb8 
	afbf0044 afb00040 00808021 00e01821 8fab0058 8faa005c 8fa90060 8fa80064 
	8c820000 8c840004 00443825 14e00012 8fac0068 8cc20000 8c630000 afa30010 
	00031fc3 afa30014 8d630000 afa30018 00031fc3 afa3001c afaa0020 00a02021 
	00403021 00023fc3 0411F962 00000000 100000ba 8fbf0044 24070001 1447001b 
	24070002 14800019 00000000 8cc70004 8cc60000 8c620000 8c630004 afa20010 
	afa30014 8d620000 8d630004 afa20018 afa3001c 8d420000 8d430004 afa20020 
	afa30024 8d220000 8d230004 afa20028 afa3002c afa80030 00a02021 0411F720 
	00000000 1000009d 8fbf0044 14470020 24070003 1480001e 00000000 8cc70004 
	8cc60000 8c620000 afa20010 000217c3 afa20014 8d620000 afa20018 000217c3 
	afa2001c 8d420000 afa20020 000217c3 afa20024 8d220000 afa20028 000217c3 
	afa2002c 8d020000 afa20030 000217c3 afa20034 afac0038 00a02021 0411FA23 
	00000000 8e020000 1000007b 8e030004 1447001c 24070004 1480001a 00000000 
	8cc70004 8cc60000 8c620000 afa20010 000217c3 afa20014 8d620000 afa20018 
	000217c3 afa2001c 8d420000 afa20020 000217c3 afa20024 8d220000 afa20028 
	000217c3 afa2002c afa80030 00a02021 0411F995 00000000 8e020000 1000005e 
	8e030004 1447001f 24070005 1480001d 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c620000 8c630004 afa20010 afa30014 8d620000 8d630004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 8d220000 8d230004 afa20028 
	afa3002c afa80030 afac0034 8fa2006c afa20038 0411FCC4 00000000 1000003f 
	8fbf0044 14470020 24070006 1480001e 00000000 8cc70004 8cc60000 8c620000 
	8c630004 afa20010 afa30014 8d620000 8d630004 afa20018 afa3001c 8d420000 
	8d430004 afa20020 afa30024 8d220000 8d230004 afa20028 afa3002c 8d020000 
	8d030004 afa20030 afa30034 afac0038 00a02021 0411FE77 00000000 8e020000 
	1000001d 8e030004 1447001c 8fbf0044 5480001b 8fb00040 8cc70004 8cc60000 
	8c620000 8c630004 afa20010 afa30014 8d620000 8d630004 afa20018 afa3001c 
	8d420000 8d430004 afa20020 afa30024 8d220000 8d230004 afa20028 afa3002c 
	afa80030 00a02021 0411FD26 00000000 8e020000 8e030004 8fbf0044 8fb00040 
	03e00008 27bd0048 
End CFunction
'
CFUNCTION LCD_Font 
  00000000 
  00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
  7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
  c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
  79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
  1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
  7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
  7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
  10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
  00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
  7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
  22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
  70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
  49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
  127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
  49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
  14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
  5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
  41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
  08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
  40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
  09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
  7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
  08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
  08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
  07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
  44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
  04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
  7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
  24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
  3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
  10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
  77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
  a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
  54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
  55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
  457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
  55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
  44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
  a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
  49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
  54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
  0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
  4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
  2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
  5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
  14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
  f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
  1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
  101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
  10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
  fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
  14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
  14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
  00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
  101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
  ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
  4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
  443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
  492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
  5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
  5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
  ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
  18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
  1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
END CFUNCTION 
  
  '-------------------Delete ALL text below when using Library in your own programs 
   
   
SUB TestSuite 
   
  CPU 48 
   
   
  PRINT "Starting initialisation" 
  PRINT "Using ST7920 LCD" 
   
  'initialise the display 
  LCD.Init 16,15
   
PRINT "starting main" 
  'Variables for use in main 
  LOCAL Integer i,xfs,yfs,x0=0,y0=0,x1,y1 
  LOCAL FLOAT tn 
  LOCAL Integer Sz 
   
  DO 
     
    ' demo fast line draw 
    LCD.SetRot(LCD_NORMAL) 
    LCD.Cls 
    y1=63
    FOR i=0 TO 45 STEP 5
      tn=TAN(RAD(i))
      x1=LCD_params(LCD_wi)*tn
      LCD.DLine(x0,y0,x1,y1)
    NEXT i

    x1=127
    FOR i=0 TO 40 STEP 5
      tn=TAN(RAD(i))
      y1=LCD_params(LCD_ht)*tn
      LCD.DLine(x0,y0,x1,y1)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    'demo fast text write
    FOR i=0 TO 56 STEP 8
      LCD.PString(0,i,"Hello world:Bye world",1,LCD_NORMAL)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=63 TO 15 STEP -16
      LCD.PString(127,i,"Micromite2",2,LCD_INVERSE)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=16 TO 128 STEP 16
      LCD.PString(i,0,"RIGHT",2,LCD_RT_RIGHT)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=104 TO 0 STEP -24
      LCD.PString(i,63,"LEFT",3,LCD_RT_LEFT)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

' test drawing rectangles
    FOR i=0 TO 3 
      LCD.SetRot(i) 
      LCD.FRect(5,5,10,15) 
      LCD.DRect(2,2,16,21)
    NEXT i 
    LCD.Refresh 

    PAUSE 2000 
    LCD.Cls

    ' test drawing rounded rectangles
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FRndrect(5,5,10,15,4)
      LCD.DRndrect(2,2,16,21,6)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    ' test drawing circles
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FCirc(10,10,7)
      LCD.DCirc(10,10,9)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    ' test drawing triangles and line drawing
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FTri(4,4,20,6,12,14)
      LCD.DTri(1,2,24,4,12,17)
    NEXT i
    LCD.Refresh
    PAUSE 2000

    ' test character output and string output at all orientations
    FOR sz=1 TO 3
      LCD.Cls
      LCD.SetRot(LCD_NORMAL)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_INVERSE)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_RT_RIGHT)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_RT_LEFT)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
    NEXT sz
  LOOP
   
END SUB
option explicit
