OPTION EXPLICIT
option default integer
   
  'Go run the TestSuite 
  TestSuite() 
   
END 
   
  '************************************************************************************* 
  ' 
  ' Peter Mather
  ' 
  ' V1.2 
  ' 2015-18-1 
  ' 
  ' Micromite Graphics library with drivers for DOGM128 display - ST7565R controller
  ' 
  ' Initialise Display Library 
  ' You MUST call LCD.Init BEFORE any other call to this library 
  ' SUB LCD.Init(rs,cd,cs,of,wi,ht,nr)              
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         cs : [mandatory] pin used for the displays CS line
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
'              ' 
  ' LCD.Init declares the following externally usable constants 
  '   LCD_ON=1 
  '   LCD_OFF=0 
  '   LCD_RT_RIGHT=2  Rotate Right 
  '   LCD_RT_LEFT=3   Rotate Left 
  '   LCD_NORMAL=0    Normal Aspect 
  '   LCD_INVERSE=1   Upside Down Aspect 
   
  ' The Drawing Primitives assume a graphics display where top left is point 0,0 
  ' The Drawing Primitives just update the memory image of the display 
  ' To actually update the physical display call SUB S_Refresh 
   
  ' Set screen orientation 
  ' SUB LCD.SetRot(x) 
  '     In : X  0=normal,1=invert,2=rotate right,3-rotate left 
   
  ' Draw circle 
  ' SUB LCD.DCirc(x0,y0,r) 
  '     In : x,y coordinates of centre,radius 
   
  ' Draw filled circle, ie a disc 
  ' SUB LCD.FCirc(x0,y0,r) 
  '     In: x,y coordinates of centre,r=radius 
   
  '     Draw triangle 
  ' SUB LCD.DTri(x0,y0, x1,y1, x2,y2)      
  '     In: three coordinate pairs representing each vertex 
   
  '     Draw filled triangle 
  ' SUB LCD.FTri (x0,y0, x1,y1, x2,y2) 
  '     In: three coordinate pairs representing each vertex 
   
  ' Print string 
  ' SUB LCD.PString(xx0,yy0,text$,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          text$,           String to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed text 
   
  ' Print 8x6 bitmap 
  ' SUB LCD.Pbitmap(xx0,yy0,bitmap,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          bitmap,           character to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed character 

  ' Draw line 
  ' SUB LCD.DLine(xx0,yy0,xx1,yy1) 
  '     In:     x0,y0           start of line 
  '          x1,y1           end of line 
   
  '     Draw rectangle 
  ' SUB LCD.DRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  ' Draw filled rectangle 
  ' SUB LCD.FRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Clear rectangluar area 
  ' SUB LCD.CRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Draw rounded rectangle 
  ' SUB LCD.DRndRect(x,y,w,h,r) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
  '          radius                Radius of corners 
   
  ' Draw filled rounded rectangle 
  ' SUB LCD.FRndRect(x,y,w,h,r) 
  '       In:     x,y                Coordinate of top left corner 
  '            width               Width 
  '            height               Height 
  '            radius                Radius of corners 
   
  ' Update the physical display 
  ' SUB LCD.Refresh 
  '       In:     N/A 
   
  '     Clear the physical display and internal memory map 
  ' SUB LCD.Cls 
  '       In:     N/A 
   
  ' 
  ' Initialise Display Library 
  ' You MUST call LCD.Init BEFORE any other call to this library 
  ' SUB LCD.Init(rs,cd,cs,wi,ht,nr)               
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         cs : [mandatory] pin used for the displays CS line
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
' 
  ' LCD.Init declares the following externally usable constants 
  '   LCD_ON=1 
  '   LCD_OFF=0 
  '   LCD_RT_RIGHT=2  Rotate Right 
  '   LCD_RT_LEFT=3   Rotate Left 
  '   LCD_NORMAL=0    Normal Aspect 
  '   LCD_INVERSE=1   Upside Down Aspect 
  ' 
SUB LCD.Init(rs,cd,cs,wi,ht,nr)
  dim integer LCD_rs=rs, LCD_cd=cd,LCD_cs=cs
  IF wi=0 THEN wi=128 
  IF ht=0 THEN ht=64 
  IF nr=0 THEN nr=ht\8 
  setpin LCD_rs, dout
  SETPIN LCD_cd, DOUT
  SETPIN LCD_cs, DOUT
  spi open 10000000,3,8
  pause 500
  pin(LCD_rs)=1 'set RESET high
  PIN(LCD_rs)=0
  PIN(LCD_rs)=1 'reset the display
   
  ' Global variables 
  DIM INTEGER LCD_FontPtr,LCD_rot_wi,LCD_rot_ht
  DIM INTEGER LCD_params(6)
  
  'set up arrays for screen map to mimic display 
  DIM INTEGER LCD_sc(wi),LCD_dd(wi)  
   
  'Global Constants 
  'CFunction DRAW function Indexes [sic] 
  DIM Integer LCD_PIX=0,LCD_FFR=1,LCD_FILLtri=2,LCD_DRAWLINE=3, LCD_PSTRING=4, LCD_FCIRCH=5, LCD_DCIRCH=6  
  DIM integer LCD_wi=0,LCD_ht=1,LCD_rot=2,LCD_nr=3,LCD_X=4,LCD_Y=5,LCD_seed=6  
    
  'Used by User program in calls to drawing primitives 
  DIM Integer LCD_ON=1,LCD_OFF=0 
  DIM Integer LCD_NORMAL=0,LCD_INVERSE=1,LCD_RT_RIGHT=2,LCD_RT_LEFT=3 
  LCD_params(LCD_wi)=wi
  LCD_params(LCD_ht)=ht
  LCD_params(LCD_rot)=LCD_NORMAL
  LCD_params(LCD_nr)=nr  
  LCD_params(LCD_seed)=0  
  LCD_FontPtr=PEEK(CFunAddr LCD_FONT) 
   
  LOCAL i% 
  LCD.SCmd(&H40)
  LCD.SCmd(&HA1)
  LCD.SCmd(&HC0)
  LCD.SCmd(&HA6)
  LCD.SCmd(&HA2)
  LCD.SCmd(&H2F)
  LCD.SCmd(&HF8)
  LCD.SCmd(&H00)
  LCD.SCmd(&H27)
  LCD.SCmd(&H81)
  LCD.SCmd(&H16)
  LCD.SCmd(&HAC)
  LCD.SCmd(&H00)
  LCD.SCmd(&HAF)
  LCD.CLS


   
END SUB 

SUB LCD.SCmd(Comnd%) 
  local i
  pin(LCD_cd)=0                   ' Send this byte as a command
  PIN(LCD_cs)=0
  i=spi(Comnd%)
  PIN(LCD_cs)=1
END SUB 


SUB LCD.Refresh() 
  LOCAL StartRow%,StartCol%,R%,i% 
  LOCAL OutChar$ length 150 
  do 
    R%=LCDUpdate(OutChar$,StartCol%,StartRow%,LCD_params(),LCD_sc(),LCD_dd()) 
    if R%>1 then
      LCD.SCz(StartCol%,StartRow%) 
      pin(LCD_cd)=1 'set for sending data
      pin(LCD_cs)=0
      spi write R%,outchar$
      pin(LCD_cs)=1
    else 
      if R%=1 then i%=spi(asc(outchar$))
    endif
  loop while R%<>0
  END SUB 
   
  'Clear Screen 
SUB LCD.Cls 
  LOCAL i 
  FOR i=0 TO LCD_params(LCD_wi)-1 
    LCD_sc(i)=0 
    LCD_dd(i)=-1 
  NEXT i 
  LCD.Refresh 
END SUB 
   
   

sub LCD.SCz(x as integer, y as integer)
  local integer i,j
  j=(y and 7) OR &B10110000
  LCD.SCmd(j)
  j=((x and &HF0) >>4) or &B00010000
  LCD.SCmd(j))
  j=(x and &H0F)
  LCD.SCmd(j)
end sub 
  ' 
  ' Generic drawing routines 
  ' 
sub LCD.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON,x0,y0,r,31,LCD_params())
end sub

   
SUB LCD.DTri(x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LCD.DLine(x0,y0,x1,y1) 
  LCD.DLine(x1,y1,x2,y2) 
  LCD.DLine(x2,y2,x0,y0) 
END SUB 

  
SUB LCD.FTri (x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LOCAL Integer dp
  dp=LCDdraw(LCD_FILLtri,LCD_sc(),x0,y0,x1,y1,x2,y2,LCD_params()) 
END SUB 
'
sub LCD.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=LCDdraw(LCD_pstring,LCD_FontPtr,LCD_ON,xx0,yy0,sz,orientation,LCD_params(),LCD_sc(),text$)
  xx0=LCD_params(LCD_X)
  yy0=LCD_params(LCD_Y)
end sub
'
sub LCD.pbitmap(xx0 as integer, yy0 as integer, bitmap as integer, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=LCDdraw(LCD_pstring,bitmap,LCD_ON,xx0,yy0,sz,orientation,LCD_params(),LCD_sc(),"")
  xx0=LCD_params(LCD_X)
  yy0=LCD_params(LCD_Y)
end sub
'
SUB LCD.DLine(xx0%,yy0%,xx1%,yy1%) ' x,y of start line,x,y of end line 
  LOCAL  dp%=LCDdraw(LCD_DRAWLINE,LCD_sc(),LCD_ON,xx0%,yy0%,xx1%,yy1%,LCD_params()) 
END SUB 
'
SUB LCD.DRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,LCD_params(LCD_wi),LCD_ht 
  LOCAL  Integer a,dp 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,w,1,LCD_params()) 
  a=y+h-1 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,a,w,1,LCD_params()) 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,1,h,LCD_params()) 
  a=x+w-1 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,a,y,1,h,LCD_params()) 
END SUB 


SUB LCD.FRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y,w,h,LCD_params()) 
END SUB 


SUB LCD.CRect(x AS integer,y AS integer,w AS integer,h AS integer) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_OFF,x,y,w,h,LCD_params()) 
END SUB 


SUB LCD.FCirc(x0%,y0%,r%)  'x,y coordinates of centre,radius 
  LOCAL  dp%=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x0%,y0%-r%,1,2*r%+1,LCD_params()) 
  dp%=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x0%, y0%, r%, 3, 0,  LCD_params())
END SUB 
   
   
SUB LCD.DRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer ) 'x,y coordinates of top left,width,height,radius of corner
  LOCAL Integer dp 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y,w-2*r,1,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y+h-1,w-2*r,1,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x,y+r,1,h-2*r,LCD_params()) 
  dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+w-1,y+r,1,h-2*r,LCD_params()) 
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+r, y+r, r, 1,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+w-r-1, y+r, r, 2,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+w-r-1, y+h-r-1, r, 4,LCD_params())
  dp=LCDdraw(LCD_dcirch, LCD_sc(),LCD_ON, x+r, y+h-r-1, r, 8,LCD_params())
END SUB 


SUB LCD.FRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer) 'x,y coordinates of top left,width,height,radius of corner 
  LOCAL Integer dp 
   dp=LCDdraw(LCD_FFR,LCD_sc(),LCD_ON,x+r,y,w-2*r,h,LCD_params()) 
   dp=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x+w-r-1, y+r, r, 1, h-2*r-1, LCD_params())
   dp=LCDdraw(LCD_fcircH,LCD_sc(),LCD_ON,x+r, y+r, r, 2, h-2*r-1, LCD_params())
END SUB 


SUB LCD.SetRot(x%) 'sets screen rotation: 0=normal,1=invert,2=rotate right,3-rotate left 
  LCD_params(2)=(x% AND 3) 
  LCD_rot_wi=LCD_params(LCD_wi) 
  LCD_rot_ht=LCD_params(LCD_ht)
  IF x%>=2 THEN 
    LCD_rot_wi=LCD_params(LCD_ht) 
    LCD_rot_ht=LCD_params(LCD_wi) 
  ENDIF 
END SUB 
'

  ' 
  ' CFunctions 
  ' 
'
CFunction LCDupdate
	00000000
	27bdffa0 afb2005c afb10058 afb00054 8fb90070 8fb80074 8cf10018 02206021 
	8cf00000 8ce20030 8ce30034 00431825 10600003 00005821 a0820001 240b0001 
	1980000b 27a90010 00114080 00001021 2403ffff 01223821 ace30000 27b20030 
	02423821 24420004 1448fffa ace30000 5a000028 2631ffff 03207821 03007021 
	00005021 240dffff 8de20000 8de30004 afa20000 afa30004 8dc20000 8dc30004 
	afa20008 19800015 afa3000c 27a30010 27a70030 00001021 03a24821 27b20008 
	02424021 91290000 91080000 51280007 24420001 8c680000 550d0003 acea0000 
	ac6a0000 acea0000 24420001 24630004 004c402a 1500fff0 24e70004 254a0001 
	25ef0008 0150102a 1440ffdf 25ce0008 2631ffff 00004021 06200035 00004821 
	00111080 27a30010 00621021 240affff 2403ffff 8c470000 00e33826 0227500b 
	2631ffff 1623fffb 2442fffc 00004021 2402ffff 11420026 00004821 000a1080 
	03a21021 8c470010 aca70000 8c4c0030 0187102a 1440001a 000710c0 0322c821 
	0302c021 03aa2821 8f220000 8f230004 afa20000 afa30004 8f020000 8f030004 
	afa20008 afa3000c 256b0001 90a20000 a0a20008 008b1821 a0620000 8fa20008 
	8fa3000c af020000 af030004 24e70001 27390008 0187102a 1040ffeb 27180008 
	acca0000 a08b0000 01604021 000b4fc3 01001021 01201821 8fb2005c 8fb10058 
	8fb00054 03e00008 27bd0060 
End CFunction

'
'D:\Peter\MPLABXProjects\maincfunction.X\dist\default\production\LCDdraw.bas

'
'LCDdraw  2015-01-18 16:38:44 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction LCDdraw
'localfastfillrect
	00000707
	27bdffd8 afb00024 8fac0038 8faf0040 8fb80048 8fa90050 8d2a0010 8d2b0000 
	8d2d0008 2409ffff a3a90008 240efffe a3ae0009 240efffc a3ae000a 240efff8 
	a3ae000b 240efff0 a3ae000c 240effe0 a3ae000d 240effc0 a3ae000e 240eff80 
	a3ae000f 240e0001 a3ae0010 240e0003 a3ae0011 240e0007 a3ae0012 240e000f 
	a3ae0013 240e001f a3ae0014 240e003f a3ae0015 240e007f a3ae0016 15400012 
	a3a90017 00cb102a 104000d0 24c7ffff 00ef3821 00eb182a 2562ffff 0043380a 
	018d102a 104000c9 2582ffff 00581021 004d402a 25a3ffff 0068380a 01801821 
	1000002a 00c04021 24090001 55490013 24090002 00063027 00cb3821 04e000bb 
	000c1027 004d1021 044000b8 24030001 006f7823 01e77821 29e80000 0008780b 
	01e04021 0078c023 0302c021 2b030000 0003c00b 10000028 03001821 15490014 
	24090003 000c3827 00eb3821 00eb182a 2562ffff 0043380a 00f81023 24420001 
	28480000 0008100b 00404021 00cd102a 1040009e 24c2ffff 004f1021 004d482a 
	15200002 00c01821 25a2ffff 24090003 55490012 24660007 018b102a 10400093 
	2587ffff 00f83821 00eb102a 256bffff 0162380a 00061027 004d1021 0440008b 
	004f1823 24630001 04610003 01804021 01804021 00001821 24660007 286c0000 
	006c300a 000660c3 24460007 284e0000 004e300a 000670c3 000cc0c0 0078c023 
	000e80c0 158e0026 00508023 00e8102a 14400024 258b0001 000830c0 00863021 
	01004821 03ac5021 03b0c821 03b86821 00c05821 8cc20000 8cc30004 afa20000 
	10a00008 afa30004 93230010 91a20008 00621024 91430000 00431025 10000008 
	a1420000 932f0010 91a20008 01e27824 000f7827 91420000 01e27824 a14f0000 
	8fa20000 8fa30004 ad620000 ad630004 25290001 00e9582a 1160ffe5 24c60008 
	258b0001 01cb102a 1440002d 016e102a 00e8102a 1440002a 016e102a 000830c0 
	00863021 01004821 03ac6021 03b8c021 03ae5021 03b07821 00c06821 8cc20000 
	8cc30004 afa20000 10a0000a afa30004 93030008 91820000 00621025 a1820000 
	91e30010 91420000 00621025 1000000b a1420000 93020008 00021027 91830000 
	00431024 a1820000 91e20010 00021027 91430000 00431024 a1420000 8fa20000 
	8fa30004 ada20000 ada30004 25290001 00e9682a 11a0ffe0 24c60008 016e102a 
	10400020 03ab5821 03ae7021 00e8682a 000810c0 00822021 10000015 240cffff 
	00c05021 8cc20000 8cc30004 afa20000 10a00003 afa30004 10000002 a16c0000 
	a1600000 8fa20000 8fa30004 ad420000 ad430004 25290001 00e9102a 1040fff0 
	24c60008 256b0001 116e000b 8fb00024 55a0fffd 256b0001 00803021 1000ffe8 
	01004821 10000004 8fb00024 00001021 00001821 8fb00024 03e00008 27bd0028 

'localdrawPixel
	8faa0010 8fa90018 8fa20020 8c430010 8c4b0000 8c420008 01404021 240c0001 
	146c0006 01202821 000a4027 010b4021 00092827 1000000d 00a22821 240c0002 
	146c0005 240c0003 00094027 01402821 10000006 010b4021 546c0005 010b582b 
	000a2827 01204021 00a22821 010b582b 5160002c 00002021 00a2102b 10400028 
	00c73025 10c00013 2ca20020 00001021 2ca60020 10c00004 00001821 24060001 
	10000003 00a61004 24060001 00a61804 000830c0 00862021 8c860000 00c23025 
	ac860000 8c860004 00c33025 10000012 ac860004 10400005 24060001 00a63004 
	00061027 10000004 2403ffff 00a63004 00061827 2402ffff 000830c0 00862021 
	8c860000 00c23024 ac860000 8c860004 00c33024 ac860004 10000003 01002021 
	00002021 00002821 00801021 03e00008 00a01821 

'swap
8c820000 8ca30000 ac830000 
	03e00008 aca20000 

'drawline
27bdffa0 afbf005c afbe0058 afb70054 afb60050 afb5004c 
	afb40048 afb30044 afb20040 afb1003c afb00038 00809021 00c0b021 8fa30070 
	8fa50078 8fa20080 8fa40088 8fb40090 afa30028 afa5002c afa20030 afa40034 
	00a4882a 00853023 00a42023 0091300a 0062282a 00432023 00621023 0085100b 
	0046882a 12200009 00e0b821 27a40028 27a5002c 0411FFD7 00000000 27a40030 
	27a50034 0411FFD3 00000000 8fa20030 8fa30028 0043102a 1040000a 8fa30030 
	27a40028 27a50030 0411FFCA 00000000 27a4002c 27a50034 0411FFC6 00000000 
	8fa30030 8fa20028 8fa40034 8fb3002c 0264282a 10a00007 0062a823 00939823 
	001587c2 02158021 00108043 10000006 241e0001 02649823 001587c2 02158021 
	00108043 241effff 0062182a 1460002c 8fbf005c 52200010 afa20010 8fa3002c 
	afa30010 00031fc3 afa30014 afa20018 000217c3 afa2001c afb40020 02402021 
	02c03021 02e03821 0411FF55 00000000 1000000e 02138023 000217c3 afa20014 
	8fa2002c afa20018 000217c3 afa2001c afb40020 02402021 02c03021 02e03821 
	0411FF47 00000000 02138023 06010006 8fa20028 8fa2002c 005e1021 afa2002c 
	02158021 8fa20028 24420001 afa20028 8fa30030 0062182a 1060ffd6 8fbf005c 
	8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 
	8fb00038 03e00008 27bd0060 

'drawchar
27bdff60 afbf009c afbe0098 afb70094 afb60090 
	afb5008c afb40088 afb30084 afb20080 afb1007c afb00078 00809821 8fa200b0 
	afa20050 8fa300b4 afa3005c 8fa200b8 afa20060 8fb600c0 8fa300c8 afa30054 
	8fb400d8 afb60064 00608821 8fa200d0 afa20058 afa60030 14400072 afa70034 
	00031823 afa30068 00111080 00511021 8fa30060 00621021 afa20048 24620005 
	afa20044 27be0030 27a30036 afa30038 0220a821 0011bfc3 10000058 02209021 
	93c20000 02021007 30420001 10400024 24030001 24020001 16420011 02361021 
	8fa30044 afa30010 8fa2004c afa20014 02161021 afa20018 000217c3 afa2001c 
	afb40020 02602021 8fa60050 8fa7005c 0411FEEB 00000000 10000032 26100001 
	afa20010 000217c3 afa20014 afb50018 afb7001c afb50020 afb70024 afb40028 
	02602021 8fa50050 8fa6003c 8fa70040 0411FDDB 00000000 10000022 26100001 
	16430011 02361021 8fa20044 afa20010 8fa3004c afa30014 02161021 afa20018 
	000217c3 afa2001c afb40020 02602021 00003021 00003821 0411FEC9 00000000 
	10000010 26100001 afa20010 000217c3 afa20014 afb50018 afb7001c afb50020 
	afb70024 afb40028 02602021 00002821 8fa6003c 8fa70040 0411FDB9 00000000 
	26100001 24020008 1602ffb5 02358821 8fa30048 8fa20068 00621821 afa30048 
	8fa30044 2463ffff afa30044 27de0001 8fa20038 53c20086 02408821 8fa30048 
	afa3003c 000317c3 afa20040 00008821 00008021 8fa30044 00031fc3 1000ffa0 
	afa3004c 24020001 8fa30058 1462007a 24020002 8fa20054 00021023 afa20068 
	8fa30060 24620001 8fa30054 00431023 afa20048 27a20030 27a3002a afa30038 
	0040b821 0220b021 8fa30064 24640001 001118c0 00831823 afa3006c 0011f7c3 
	8fa30060 00621023 afa20070 10000052 0220a821 92e20005 02021007 30420001 
	10400022 24030001 24020001 56a20010 afb10010 8fa30044 afa30010 8fa2004c 
	afa20014 afb20018 001217c3 afa2001c afb40020 02602021 8fa60050 8fa7005c 
	0411FE6F 00000000 1000002f 2610ffff 001117c3 afa20014 afb60018 afbe001c 
	afb60020 afbe0024 afb40028 02602021 8fa50050 8fa6003c 8fa70040 0411FD60 
	00000000 10000020 2610ffff 56a30010 afb10010 8fa20044 afa20010 8fa3004c 
	afa30014 afb20018 001217c3 afa2001c afb40020 02602021 00003021 00003821 
	0411FE4F 00000000 1000000f 2610ffff 001117c3 afa20014 afb60018 afbe001c 
	afb60020 afbe0024 afb40028 02602021 00002821 8fa6003c 8fa70040 0411FD40 
	00000000 2610ffff 02368821 2402ffff 1602ffb8 26520001 8fa20048 8fa30068 
	00431021 afa20048 26f7ffff 8fa20038 52e20088 02a08821 8fa30048 afa3003c 
	000317c3 afa20040 8fb1006c 8fa30064 2472fff9 24100007 8fa20070 00571021 
	afa20044 00021fc3 1000ffa2 afa3004c 24020002 8fa30058 14620077 24020003 
	8fa20054 00021023 afa20064 8fa30060 24620001 8fa30054 00431023 afa2004c 
	afa00048 241e0001 0220a821 0011bfc3 10000059 afb1003c 27a30030 00701021 
	90420005 02421024 10400024 8fa3003c 8fa2003c 145e0011 02361021 8fa30054 
	afa30010 8fa20058 afa20014 02d01023 afa20018 000217c3 afa2001c afb40020 
	02602021 8fa60050 8fa7005c 0411FDFC 00000000 10000032 2610ffff afa20010 
	000217c3 afa20014 afb50018 afb7001c afb50020 afb70024 afb40028 02602021 
	8fa50050 8fa60040 8fa70044 0411FCEC 00000000 10000022 2610ffff 147e0011 
	02361021 8fa20054 afa20010 8fa30058 afa30014 02d01023 afa20018 000217c3 
	afa2001c afb40020 02602021 00003021 00003821 0411FDDA 00000000 10000010 
	2610ffff afa20010 000217c3 afa20014 afb50018 afb7001c afb50020 afb70024 
	afb40028 02602021 00002821 8fa60040 8fa70044 0411FCCA 00000000 2610ffff 
	2402fffa 1602ffb4 02358821 8fa30048 24630001 afa30048 8fa2004c 8fa30064 
	00431021 afa2004c 24020008 8fa30048 10620094 8fa20030 8fa20048 005e9004 
	8fa3004c afa30040 000317c3 afa20044 00008821 00008021 8fa30060 8fa20048 
	00621823 afa30054 00031fc3 1000ff9a afa30058 24020003 8fa30058 14620080 
	8fa20054 00021023 afa20068 8fa30054 000310c0 00431023 8fa30060 00621021 
	afa2004c 24620007 afa20048 24030007 afa30054 241e0001 0220b021 8fa20064 
	24430001 00112040 001110c0 00821023 00621021 afa20060 27a30036 afa30038 
	0011bfc3 afb1003c 10000057 0260a821 92020000 02621024 10400022 8fa3003c 
	8fa2003c 545e0010 afb10010 8fa30048 afa30010 8fa20058 afa20014 afb20018 
	001217c3 afa2001c afb40020 02a02021 8fa60050 8fa7005c 0411FD79 00000000 
	1000002f 26100001 001117c3 afa20014 afb60018 afb7001c afb60020 afb70024 
	afb40028 02a02021 8fa50050 8fa60040 8fa70044 0411FC6A 00000000 10000020 
	26100001 547e0010 afb10010 8fa20048 afa20010 8fa30058 afa30014 afb20018 
	001217c3 afa2001c afb40020 02a02021 00003021 00003821 0411FD59 00000000 
	1000000f 26100001 001117c3 afa20014 afb60018 afb7001c afb60020 afb70024 
	afb40028 02a02021 00002821 8fa60040 8fa70044 0411FC4A 00000000 26100001 
	02368821 8fa20038 1602ffb9 26520001 8fa30054 2463ffff afa30054 8fa2004c 
	8fa30068 00431021 afa2004c 8fa20048 2442ffff afa20048 2402ffff 8fa30054 
	10620010 8fa20030 8fa20054 005e9804 8fa3004c afa30040 000317c3 afa20044 
	27b00030 8fb10060 8fa30064 2472fffb 8fa20048 000217c3 1000ff9d afa20058 
	8fa20030 8fa30034 8fbf009c 8fbe0098 8fb70094 8fb60090 8fb5008c 8fb40088 
	8fb30084 8fb20080 8fb1007c 8fb00078 03e00008 27bd00a0 

'nextchar
14e00008 24020001 
	00061040 000618c0 00621023 8c830000 00621021 10000012 ac820000 14e20007 
	00061040 000630c0 00463023 8c820000 00463021 03e00008 ac860000 24020002 
	14e20007 00061040 000630c0 00c23023 8ca20000 00463021 03e00008 aca60000 
	24020003 14e20006 00061040 000630c0 00463023 8ca20000 00463021 aca60000 
	03e00008 00000000 

'pstring
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c 
	afb40058 afb30054 afb20050 afb1004c afb00048 00801021 afa60078 afa7007c 
	8fa60080 8fa40088 8fb00090 8fb50098 8fb400a0 8fb700a4 8fb300a8 afa60040 
	afa40044 02008821 02a09021 92630000 10600034 0040f021 1860004e 24100001 
	0011afc3 0012b7c3 02701021 90420000 2443ffe0 306300ff 2c630060 50600007 
	00003021 2442ffe0 000210c0 005e1021 8c460000 10000002 8c470004 00003821 
	8fa20078 8fa3007c afa20010 afa30014 8fa20040 afa20018 000217c3 afa2001c 
	8fa20044 afa20020 000217c3 afa20024 afb10028 afb5002c afb20030 afb60034 
	afb40038 02e02021 0411FD88 00000000 27a40040 27a50044 02203021 02403821 
	0411FF95 00000000 26100001 92620000 0050102a 5040ffd5 02701021 1000001e 
	8fa20040 8fa80078 8fa9007c afa80010 afa90014 afa60018 000637c3 afa6001c 
	afa40020 000427c3 afa40024 afb00028 00101fc3 afa3002c afb50030 00151fc3 
	afa30034 afb40038 02e02021 00403021 00a03821 0411FD65 00000000 27a40040 
	27a50044 02003021 02a03821 0411FF72 00000000 8fa20040 ae820020 000217c3 
	ae820024 8fa20044 ae820028 000217c3 ae82002c 00001021 00001821 8fbf006c 
	8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 
	8fb00048 03e00008 27bd0070 

'dcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 
	afb5005c afb40058 afb30054 afb20050 afb1004c afb00048 0080b821 afa60078 
	afa7007c 8fb60080 8fb50088 8fb00090 8fa20098 8fbe00a0 afb60030 afb50034 
	afa2002c 30420010 10400030 02008821 001697c3 afb60010 afb20014 02151021 
	afa20018 000217c3 afa2001c afbe0020 0411FC53 00000000 afb60010 afb20014 
	02b01023 afa20018 000217c3 afa2001c afbe0020 02e02021 8fa60078 8fa7007c 
	0411FC47 00000000 001597c3 02161021 afa20010 000217c3 afa20014 afb50018 
	afb2001c afbe0020 02e02021 8fa60078 8fa7007c 0411FC3A 00000000 02d01023 
	afa20010 000217c3 afa20014 afb50018 afb2001c afbe0020 02e02021 8fa60078 
	8fa7007c 0411FC2E 00000000 1a2000a2 24110001 02308823 00101023 00021040 
	afa20028 26b3ffff 26d4ffff 26b50001 26d60001 00009021 8fa2002c 30420004 
	afa20038 8fa3002c 30630002 afa3003c 8fa2002c 30420008 afa20040 8fa3002c 
	30630001 afa3002c 06200005 8fa20028 2610ffff 24420002 afa20028 02228821 
	8fa30038 1060001d 26520001 afb60010 001617c3 afa20014 8fa30034 02031021 
	afa20018 000217c3 afa2001c afbe0020 02e02021 8fa60078 8fa7007c 0411FC00 
	00000000 8fa30030 02031021 afa20010 000217c3 afa20014 afb50018 001517c3 
	afa2001c afbe0020 02e02021 8fa60078 8fa7007c 0411FBF2 00000000 8fa2003c 
	1040001e 8fa20040 afb60010 001617c3 afa20014 8fa30034 00701023 afa20018 
	000217c3 afa2001c afbe0020 02e02021 8fa60078 8fa7007c 0411FBE1 00000000 
	8fa30030 02031021 afa20010 000217c3 afa20014 afb30018 001317c3 afa2001c 
	afbe0020 02e02021 8fa60078 8fa7007c 0411FBD3 00000000 8fa20040 1040001e 
	8fa2002c 8fa30030 00701023 afa20010 000217c3 afa20014 afb50018 001517c3 
	afa2001c afbe0020 02e02021 8fa60078 8fa7007c 0411FBC2 00000000 afb40010 
	001417c3 afa20014 8fa30034 02031021 afa20018 000217c3 afa2001c afbe0020 
	02e02021 8fa60078 8fa7007c 0411FBB4 00000000 8fa2002c 5040001e 2673ffff 
	8fa30030 00701023 afa20010 000217c3 afa20014 afb30018 001317c3 afa2001c 
	afbe0020 02e02021 8fa60078 8fa7007c 0411FBA3 00000000 afb40010 001417c3 
	afa20014 8fa30034 00701023 afa20018 000217c3 afa2001c afbe0020 02e02021 
	8fa60078 8fa7007c 0411FB95 00000000 2673ffff 2694ffff 26b50001 0250102a 
	10400005 26d60001 00121040 24420001 1000ff75 02228821 8fbf006c 8fbe0068 
	8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048 
	03e00008 27bd0070 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c 
	afb40058 afb30054 afb20050 afb1004c afb00048 afa40070 00c0f021 8fb60080 
	8fb30088 8fb10090 8fb400a0 afb60038 afb3003c 8fa20098 1a20007a 02801821 
	24100001 02118023 0011b823 0017b840 26d5ffff 2673ffff 26940003 26d60001 
	00009021 30440001 afa40030 24630001 afa30040 30420002 afa20034 06000004 
	8fa20030 2631ffff 26f70002 02178021 1040002c 26520001 8fa3003c 00711023 
	afa20010 000217c3 afa20014 24020001 00001821 afa20018 afa3001c 00111040 
	8fa30040 00621021 afa20020 000217c3 afa20024 8fa400a8 afa40028 8fa40070 
	03c02821 02c03021 00163fc3 0411FA3C 00000000 8fa20038 02223821 afb30010 
	001317c3 afa20014 24020001 00001821 afa20018 afa3001c afb40020 001417c3 
	afa20024 8fa300a8 afa30028 8fa40070 03c02821 00e03021 00073fc3 0411FA28 
	00000000 8fa40034 5080002d 26b5ffff 8fa3003c 00711023 afa20010 000217c3 
	afa20014 24020001 00001821 afa20018 afa3001c 00111040 8fa30040 00621021 
	afa20020 000217c3 afa20024 8fa400a8 afa40028 8fa40070 03c02821 02a03021 
	00153fc3 0411FA0E 00000000 8fa20038 00513823 afb30010 001317c3 afa20014 
	24020001 00001821 afa20018 afa3001c afb40020 001417c3 afa20024 8fa300a8 
	afa30028 8fa40070 03c02821 00e03021 00073fc3 0411F9FA 00000000 26b5ffff 
	2673ffff 26940002 0251102a 10400005 26d60001 00121040 24420001 1000ff97 
	02028021 8fbf006c 8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 
	8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'ftri
27bdff90 afbf006c afb50068 
	afb40064 afb30060 afb2005c afb10058 afb00054 00808821 8fa30080 8fa20090 
	8fb200a8 afa60038 afa3003c 8fa40088 afa40040 afa20044 8fa40098 afa40048 
	8fa400a0 0043102a 10400009 afa4004c 27a4003c 27a50044 0411FB16 00000000 
	27a40038 27a50040 0411FB12 00000000 8fa2004c 8fa30044 0043102a 1040000a 
	8fa20044 27a4004c 27a50044 0411FB09 00000000 27a40048 27a50040 0411FB05 
	00000000 8fa20044 8fa3003c 0043102a 1040000a 8fb0003c 27a4003c 27a50044 
	0411FAFC 00000000 27a40038 27a50040 0411FAF8 00000000 8fb0003c 8fa2004c 
	1602002e 8fb30044 8fa20038 afa20030 afa20034 8fa30040 0062202a 10800003 
	0043102a 10000003 afa30030 54400001 afa30034 8fa20048 8fa30030 0043182a 
	10600003 8fa30034 10000004 afa20030 0062182a 54600001 afa20034 8fa70030 
	8fa2003c afa20010 000217c3 afa20014 24020001 00001821 afa20018 afa3001c 
	8fa20034 24420001 00471023 afa20020 000217c3 afa20024 afb20028 02202021 
	24050001 00e03021 00073fc3 0411F97C 00000000 10000079 8fbf006c 

'.LBB2
00531026 
	0002102b 02629823 0270102a 14400037 24140001 0000a821 8fa20038 8fa3003c 
	02032823 8fa60040 00c23023 70a63002 8fa40044 00832023 00c4001a 008001f4 
	00002012 00822021 afa40030 8fa60048 00c23023 70a62802 8fa6004c 00c31823 
	00a3001a 006001f4 00001812 00621021 afa20034 0044102a 10400006 8fa70030 
	27a40030 27a50034 0411FAA2 00000000 8fa70030 afb00010 001017c3 afa20014 
	8fa20034 24420001 00471023 afa20018 000217c3 afa2001c afb40020 afb50024 
	afb20028 02202021 24050001 00e03021 00073fc3 0411F942 00000000 26100001 
	0270102a 1040ffcd 8fa20038 8fa2004c 0050182a 14600038 24140001 0000a821 
	8fa60040 8fa40038 8fa50048 8fa80044 02083823 00a61823 70e33802 00484023 
	00e8001a 010001f4 00001812 00661821 afa30030 8fa7003c 02073023 00a42823 
	70c53002 00471023 00c2001a 004001f4 00001012 00442021 afa40034 0083202a 
	10800006 8fa70030 27a40030 27a50034 0411FA68 00000000 8fa70030 afb00010 
	001017c3 afa20014 8fa20034 24420001 00471023 afa20018 000217c3 afa2001c 
	afb40020 afb50024 afb20028 02202021 24050001 00e03021 00073fc3 0411F908 
	00000000 26100001 8fa2004c 0050182a 1060ffcc 8fa60040 

'.LBE2
8fbf006c 8fb50068 
	8fb40064 8fb30060 8fb2005c 8fb10058 8fb00054 03e00008 27bd0070 

'main
27bdffb8 
	afbf0044 afb00040 00808021 00e06821 8fac0058 8faa005c 8fa90060 8fa80064 
	8c820000 8c830004 00432025 14800012 8fab0068 8cc20000 8ce30000 afa30010 
	00031fc3 afa30014 8d830000 afa30018 00031fc3 afa3001c afaa0020 00a02021 
	00403021 00023fc3 0411F9DD 00000000 100000b8 8fbf0044 24040001 14440019 
	24040002 14600017 00000000 8ccb0000 8ce60000 8ce70004 8d820000 8d830004 
	afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 
	afa20020 afa30024 afa80028 00a02021 01602821 0411F8C2 00000000 1000009d 
	8fbf0044 14440020 24040003 1460001e 00000000 8cc70004 8cc60000 8da20000 
	afa20010 000217c3 afa20014 8d820000 afa20018 000217c3 afa2001c 8d420000 
	afa20020 000217c3 afa20024 8d220000 afa20028 000217c3 afa2002c 8d020000 
	afa20030 000217c3 afa20034 afab0038 00a02021 0411FEBF 00000000 8e020000 
	1000007b 8e030004 1444001c 24040004 1460001a 00000000 8cc70004 8cc60000 
	8da20000 afa20010 000217c3 afa20014 8d820000 afa20018 000217c3 afa2001c 
	8d420000 afa20020 000217c3 afa20024 8d220000 afa20028 000217c3 afa2002c 
	afa80030 00a02021 0411F9D7 00000000 8e020000 1000005e 8e030004 1444001f 
	24040005 1460001d 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8da20000 
	8da30004 afa20010 afa30014 8d820000 8d830004 afa20018 afa3001c 8d420000 
	8d430004 afa20020 afa30024 8d220000 8d230004 afa20028 afa3002c afa80030 
	afab0034 8fa2006c afa20038 0411FC6E 00000000 1000003f 8fbf0044 14440020 
	24040006 1460001e 00000000 8cc70004 8cc60000 8da20000 8da30004 afa20010 
	afa30014 8d820000 8d830004 afa20018 afa3001c 8d420000 8d430004 afa20020 
	afa30024 8d220000 8d230004 afa20028 afa3002c 8d020000 8d030004 afa20030 
	afa30034 afab0038 00a02021 0411FDC6 00000000 8e020000 1000001d 8e030004 
	1444001c 8fbf0044 5460001b 8fb00040 8cc70004 8cc60000 8da20000 8da30004 
	afa20010 afa30014 8d820000 8d830004 afa20018 afa3001c 8d420000 8d430004 
	afa20020 afa30024 8d220000 8d230004 afa20028 afa3002c afa80030 00a02021 
	0411FCB2 00000000 8e020000 8e030004 8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction lcd_font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
'
  
'-------------------Delete ALL text below when using Library in your own programs 
   
   
SUB TestSuite 
   
  CPU 48 
   
   
  PRINT "Starting initialisation" 
  PRINT "Using  DOGM128" 
   
  'initialise the display 
  ' SUB LCD.Init(rs,cd,cs,wi,ht,nr)              
  LCD.Init 16,2,26
   
PRINT "starting main" 
  'Variables for use in main 
  LOCAL Integer i,wi,ht,xfs,yfs,x0=0,y0=0,x1,y1
  LOCAL FLOAT tn 
  LOCAL Integer Sz 
  wi= LCD_params(LCD_wi)
  ht= LCD_params(LCD_ht)   
  DO 
    LCD.SetRot(LCD_NORMAL) 
    LCD.Cls 
    LCD.drect(0, 0, wi, ht)
    LCD.pbitmap(58, 2, &HFF818181FF, 2, 0)
    LCD.pstring(20, 24, "Welcome to the", 1, 0)
    LCD.pstring(23, 34, "Micromite MK2", 1, 0)   
    LCD.pstring(41, 44, "DOGM128", 1, 0)   
    LCD.Refresh
    pause 2000   
    ' demo fast line draw 
    LCD.SetRot(LCD_NORMAL) 
    LCD.Cls 
    y1=LCD_params(LCD_ht)-1 
    FOR i=0 TO 45 STEP 5
      tn=TAN(RAD(i))
      x1=LCD_params(LCD_wi)*tn
      LCD.DLine(x0,y0,x1,y1)
    NEXT i

    x1=LCD_params(LCD_wi)-1
    FOR i=0 TO 40 STEP 5
      tn=TAN(RAD(i))
      y1=LCD_params(LCD_ht)*tn
      LCD.DLine(x0,y0,x1,y1)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    'demo fast text write
    FOR i=0 TO LCD_params(LCD_ht)-8 STEP 8
      LCD.PString(0,i,"Hello world:Bye world",1,LCD_NORMAL)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=LCD_params(LCD_ht)-1 TO 15 STEP -16
      LCD.PString(LCD_params(LCD_wi)-1,i,"Micromite2",2,LCD_INVERSE)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=16 TO LCD_params(LCD_wi) STEP 16
      LCD.PString(i,0,"RIGHT",2,LCD_RT_RIGHT)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    FOR i=LCD_params(LCD_wi)-24 TO 0 STEP -24
      LCD.PString(i,LCD_params(LCD_ht)-1,"LEF",3,LCD_RT_LEFT)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

' test drawing rectangles
    FOR i=0 TO 3 
      LCD.SetRot(i) 
      LCD.FRect(5,5,10,15) 
      LCD.DRect(2,2,16,21)
    NEXT i 
    LCD.Refresh 

    PAUSE 2000 
    LCD.Cls

    ' test drawing rounded rectangles
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FRndrect(5,5,10,15,4)
      LCD.DRndrect(2,2,16,21,6)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    ' test drawing circles
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FCirc(10,10,7)
      LCD.DCirc(10,10,9)
    NEXT i
    LCD.Refresh
    PAUSE 2000
    LCD.Cls

    ' test drawing triangles and line drawing
    FOR i=0 TO 3
      LCD.SetRot(i)
      LCD.FTri(4,4,20,6,12,14)
      LCD.DTri(0,3,24,4,12,17)
    NEXT i
    LCD.Refresh
    PAUSE 2000

    ' test character output and string output at all orientations
    FOR sz=1 TO 3
      LCD.Cls
      LCD.SetRot(LCD_NORMAL)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_INVERSE)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_RT_RIGHT)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
      LCD.Cls
      LCD.SetRot(LCD_RT_LEFT)
      xfs=0
      yfs=0
      LCD.PString(xfs,yfs,"nr",sz,LCD_NORMAL)
      LCD.PString(xfs,yfs,"g",sz,LCD_NORMAL)
      LCD.PString(LCD_rot_wi-1,LCD_rot_ht-1,"Iv",sz,LCD_INVERSE)
      LCD.PString(LCD_rot_wi-1,0,"Rr",sz,LCD_RT_RIGHT)
      LCD.PString(0,LCD_rot_ht-1,"Rl",sz,LCD_RT_LEFT)
      LCD.Refresh
      PAUSE 1000
    NEXT sz
  LOOP
   
END SUB
