'************************************************************************************* 
' 
' Peter Mather
' 
' 1.0 
' 2015-31-1 
' 
' Graphics library with drivers for SSD1351 OLED 128x96 display
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub S1351.setrot(x) ;S1351_normal=normal, S1351_inverse=invert, S1351_rt_right=rotate right, S1351_rt_left=rotate left
' draw circle: sub S1351.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub S1351.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub S1351.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub S1351.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub S1351.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' print 8x5 bitmap: sub I9341.pbitmap(xx0, yy0, char, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, bitmap, size, character orientation,  foreground colour,  background colour
' draw line: sub S1351.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub S1351.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub S1351.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub S1351.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub S1351.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option default none
option explicit
cpu 48
S1351.init
do
  S1351_test
loop
end
'
sub S1351.init
'Local "CONSTANTS"
' 44-pin
'  const S1351_CS=11 'b13 fixed pin allocation to match Cfunction
'  const S1351_CD=15 'b15 fixed pin allocation to match Cfunction
'  const S1351_RESET=30 'use any pin as required
' 28-pin
  const S1351_CS=24 'b13 fixed pin allocation to match Cfunction
  const S1351_CD=26 'b15 fixed pin allocation to match Cfunction
  const S1351_RESET=2 'use any pin as required
'
  const SSD1351_CMD_SETCOLUMN 	  	=&H15
  const SSD1351_CMD_SETROW    		  =&H75
  const SSD1351_CMD_WRITERAM   		  =&H5C
  const SSD1351_CMD_READRAM   		  =&H5D
  const SSD1351_CMD_SETREMAP 		    =&HA0
  const SSD1351_CMD_STARTLINE 		  =&HA1
  const SSD1351_CMD_DISPLAYOFFSET 	=&HA2
  const SSD1351_CMD_DISPLAYALLOFF 	=&HA4
  const SSD1351_CMD_DISPLAYALLON  	=&HA5
  const SSD1351_CMD_NORMALDISPLAY 	=&HA6
  const SSD1351_CMD_INVERTDISPLAY 	=&HA7
  const SSD1351_CMD_FUNCTIONSELECT 	=&HAB
  const SSD1351_CMD_DISPLAYOFF 		  =&HAE
  const SSD1351_CMD_DISPLAYON     	=&HAF
  const SSD1351_CMD_PRECHARGE 		  =&HB1
  const SSD1351_CMD_DISPLAYENHANCE	=&HB2
  const SSD1351_CMD_CLOCKDIV 		    =&HB3
  const SSD1351_CMD_SETVSL 		      =&HB4
  const SSD1351_CMD_SETGPIO 		    =&HB5
  const SSD1351_CMD_PRECHARGE2 		  =&HB6
  const SSD1351_CMD_SETGRAY 		    =&HB8
  const SSD1351_CMD_USELUT 		      =&HB9
  const SSD1351_CMD_PRECHARGELEVEL 	=&HBB
  const SSD1351_CMD_VCOMH 		      =&HBE
  const SSD1351_CMD_CONTRASTABC		  =&HC1
  const SSD1351_CMD_CONTRASTMASTER	=&HC7
  const SSD1351_CMD_MUXRATIO        =&HCA
  const SSD1351_CMD_COMMANDLOCK     =&HFD
  const SSD1351_CMD_HORIZSCROLL     =&H96
  const SSD1351_CMD_STOPSCROLL      =&H9E
  const SSD1351_CMD_STARTSCROLL     =&H9F
  const SSD1351HEIGHT = 96 ' change this for 128x128 version
  const SSD1351WIDTH = 128
' Global "CONSTANTS"
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer S1351.pix=0
  dim integer S1351.ffr=1
  dim integer S1351.filltri=2
  dim integer S1351.drawline=3
  dim integer S1351.wcom=4
  dim integer S1351.wdata=5
  dim integer S1351.fastfillscreen=6
  dim integer S1351.fpstring=7
  dim integer S1351.fcirch=8
  dim integer S1351.dcirch=9
  dim integer S1351_normal=0
  dim integer S1351_inverse=1
  dim integer S1351_rt_right=2
  dim integer S1351_rt_left=3
  dim integer S1351_AddrOfFont, S1351_params(6) ' Global variables
  DIM integer S1351_wi=0,S1351_ht=1,S1351_rot=2,S1351_nr=3,S1351_X=4,S1351_Y=5,S1351_seed=6  
'
  local integer i
  spi open 10000000,3,8 'run at maximum speed
  S1351_Params(S1351_wi)=SSD1351WIDTH
  S1351_params(S1351_ht)=SSD1351HEIGHT
  S1351_AddrOfFont=PEEK(CFunAddr FONT)  
  pin(S1351_CS)=1
  setpin S1351_CS, DOUT
  pin(S1351_CD)=1
  setpin S1351_CD, DOUT
  pin(S1351_RESET)=1
  setpin S1351_RESET, DOUT'  Reset the display
  pin(S1351_RESET)=0
  pause 100
  pin(S1351_RESET)=1
  pause 100
' Initialization Sequence
  i=S1351draw(S1351.wcom,SSD1351_CMD_COMMANDLOCK)
  i=S1351draw(S1351.wdata,&H12)  
  i=S1351draw(S1351.wcom,SSD1351_CMD_COMMANDLOCK)
  i=S1351draw(S1351.wdata,&HB1)
  i=S1351draw(S1351.wcom,SSD1351_CMD_DISPLAYOFF)
  i=S1351draw(S1351.wcom,SSD1351_CMD_CLOCKDIV)
  i=S1351draw(S1351.wcom,&HF1)
  i=S1351draw(S1351.wcom,SSD1351_CMD_MUXRATIO)
  i=S1351draw(S1351.wdata,127)
  i=S1351draw(S1351.wcom,SSD1351_CMD_SETREMAP)
  i=S1351draw(S1351.wdata,&H74)
  i=S1351draw(S1351.wcom,SSD1351_CMD_SETCOLUMN)
  i=S1351draw(S1351.wdata,&H00)
  i=S1351draw(S1351.wdata,&H7F)
  i=S1351draw(S1351.wcom,SSD1351_CMD_SETROW)
  i=S1351draw(S1351.wdata,&H00)
  i=S1351draw(S1351.wdata,&H7F)
  i=S1351draw(S1351.wcom,SSD1351_CMD_STARTLINE)
  if (SSD1351HEIGHT = 96) THEN
    i=S1351draw(S1351.wdata,96)
  else 
    i=S1351draw(S1351.wdata,0)
  endif
  i=S1351draw(S1351.wcom,SSD1351_CMD_DISPLAYOFFSET)
  i=S1351draw(S1351.wdata,&H0)
  i=S1351draw(S1351.wcom,SSD1351_CMD_SETGPIO)
  i=S1351draw(S1351.wdata,&H00)
  i=S1351draw(S1351.wcom,SSD1351_CMD_FUNCTIONSELECT)
  i=S1351draw(S1351.wdata,&H01)
  i=S1351draw(S1351.wcom,SSD1351_CMD_PRECHARGE)
  i=S1351draw(S1351.wcom,&H32)
  i=S1351draw(S1351.wcom,SSD1351_CMD_VCOMH)
  i=S1351draw(S1351.wcom,&H05)
  i=S1351draw(S1351.wcom,SSD1351_CMD_NORMALDISPLAY)
  i=S1351draw(S1351.wcom,SSD1351_CMD_CONTRASTABC)
  i=S1351draw(S1351.wdata,&HC8)
  i=S1351draw(S1351.wdata,&H80)
  i=S1351draw(S1351.wdata,&HC8)
  i=S1351draw(S1351.wcom,SSD1351_CMD_CONTRASTMASTER)
  i=S1351draw(S1351.wdata,&H0F)
  i=S1351draw(S1351.wcom,SSD1351_CMD_SETVSL )
  i=S1351draw(S1351.wdata,&HA0)
  i=S1351draw(S1351.wdata,&HB5)
  i=S1351draw(S1351.wdata,&H55)
  i=S1351draw(S1351.wcom,SSD1351_CMD_PRECHARGE2)
  i=S1351draw(S1351.wdata,&H01)
  i=S1351draw(S1351.wcom,SSD1351_CMD_DISPLAYON)
  i=S1351draw(S1351.wcom,SSD1351_CMD_WRITERAM)  
  S1351.setrot(0)
  S1351.fillscreen(black)
end sub
'
sub S1351.setrot(x%) 'sets screen rotation: 0=S1351_normal, 1=invert, 2=rotate right, 3-rotate left
   S1351_params(S1351_rot)=(x% and 3)
end sub
'
' Generic drawing routines
'
sub S1351.fillscreen(scol as integer)
  local integer i=S1351_params(S1351_rot)
  S1351_params(S1351_rot)=S1351_normal
  local integer j=S1351draw(S1351.ffr,scol, 0,0,S1351_params(S1351_wi),S1351_params(S1351_ht), S1351_params())
  S1351_params(S1351_rot)=i
end sub
'
sub S1351.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=S1351draw(S1351.dcirch, colour,x0,y0,r,31,S1351_params())

end sub
 '
sub S1351.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  S1351.dline(x0, y0, x1, y1, colour)
  S1351.dline(x1, y1, x2, y2, colour)
  S1351.dline(x2, y2, x0, y0, colour)
end sub
 '
sub S1351.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer i=S1351draw(S1351.filltri, x0,y0,x1,y1,x2,y2,colour,S1351_params())

end sub
sub S1351.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=S1351draw(S1351.fpstring,S1351_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,S1351_params(),text$)
end sub
'
sub S1351.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=S1351draw(S1351.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,S1351_params(),"")
end sub
'
sub S1351.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=S1351draw(S1351.drawline, colour, xx0, yy0, xx1, yy1,  S1351_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub S1351.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=S1351draw(S1351.ffr, rcolour, x, y, w, 1,  S1351_params()) 
  a=y+h-1
  dp=S1351draw(S1351.ffr, rcolour, x, a, w, 1,  S1351_params()) 
  dp=S1351draw(S1351.ffr, rcolour, x, y, 1, h,  S1351_params()) 
  a=x+w-1
  dp=S1351draw(S1351.ffr, rcolour, a, y, 1, h,  S1351_params()) 
end sub
'
sub S1351.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=S1351draw(S1351.ffr, rcolour, x, y, w, h,  S1351_params()) 
end sub
'
FUNCTION S1351.Getchar(char as integer) as integer
  local integer i=char<<3
  S1351.Getchar=PEEK(WORD S1351_AddrOfFont+i)+(PEEK(WORD S1351_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub S1351.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=S1351draw(S1351.ffr, ccolour, x0, y0-r, 1, 2*r+1,  S1351_params())
  dp=S1351draw(S1351.fcircH,x0, y0, r, 3, 0, ccolour, S1351_params())
end sub
 '
sub S1351.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=S1351draw(S1351.ffr, rcolour, x+r, y, w-2*r, 1,  S1351_params()) 
  dp=S1351draw(S1351.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  S1351_params()) 
  dp=S1351draw(S1351.ffr, rcolour, x, y+r, 1, h-2*r,  S1351_params()) 
  dp=S1351draw(S1351.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  S1351_params()) 
  dp=S1351draw(S1351.dcirch, rcolour, x+r, y+r, r, 1,S1351_params())
  dp=S1351draw(S1351.dcirch,  rcolour, x+w-r-1, y+r, r, 2,S1351_params())
  dp=S1351draw(S1351.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,S1351_params())
  dp=S1351draw(S1351.dcirch,  rcolour, x+r, y+h-r-1, r, 8,S1351_params())
end sub
'
sub S1351.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=S1351draw(S1351.ffr, colour, x+r, y, w-2*r, h,  S1351_params()) 
  dp=S1351draw(S1351.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, S1351_params())
  dp=S1351draw(S1351.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, S1351_params())
end sub
'
'C:\Users\Peter\Dropbox\MPLABXProjects\SSD1351\dist\default\production\S1351draw.bas

'
'S1351draw  2015-01-31 18:06:26 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction S1351draw
'writeCommand
	000006F5
	3c02bf88 24032000 ac436134 34038000 ac436134 3c02bf80 ac445820 3c03bf80 
	8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 3c02bf80 8c425820 
	03e00008 00000000 

'writeData
3c02bf88 24032000 ac436134 34038000 ac436138 3c02bf80 
	ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 
	3c02bf80 8c425820 03e00008 00000000 

'localfastfillrect
27bdffd0 afbf002c afb60028 afb50024 
	afb40020 afb3001c afb20018 afb10014 afb00010 8fa70040 8fa90048 8faa0050 
	8fa20058 7c913a00 8c430000 8c480008 8c420010 14400016 309000ff 00c0a821 
	00c3582a 00002021 1160008c 00002821 24d2ffff 02499021 0243282a 2464ffff 
	0085900a 00e0a021 00e8582a 00002021 11600082 00002821 24f3ffff 026a9821 
	0268282a 2504ffff 1000002d 0085900a 24040001 14440015 24040002 00063027 
	00c39021 00002021 06400074 00002821 00073827 00e89821 06600070 24020001 
	00494823 01324821 29350000 0015480b 0120a821 004a5023 01535021 29540000 
	0014500b 10000029 0140a021 14440014 2464ffff 00079027 02439021 0243282a 
	0085900a 024a2023 24840001 28950000 0015200b 0080a821 00c0a021 00c8582a 
	00002021 11600055 00002821 24d3ffff 02699821 0268282a 2504ffff 0085980a 
	24040003 14440011 00e3102a 00e0a821 00002021 10400049 00002821 24e7ffff 
	00ea9021 0243102a 2463ffff 00063027 00c89821 06600041 0062900a 02694823 
	25340001 2a820000 0002a00b 26420001 00551023 26760001 02d4b023 72c2b002 
	24040015 00002821 0411FF6D 00000000 02a02021 00152fc3 0411FF7B 00000000 
	02402021 00122fc3 0411FF77 00000000 24040075 00002821 0411FF61 00000000 
	02802021 00142fc3 0411FF6F 00000000 02602021 00132fc3 0411FF6B 00000000 
	2404005c 00002821 0411FF55 00000000 3c02bf88 24032000 ac436134 34038000 
	ac436138 12c00010 26d6ffff 3c02bf80 ac515820 8c435810 30630080 1060fffd 
	00000000 8c435820 ac505820 8c435810 30630080 1060fffd 00000000 8c435820 
	16c0fff3 26d6ffff 24032000 3c02bf88 ac436138 24040001 00002821 00801021 
	00a01821 8fbf002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0030 

'localdrawPixel
27bdffd8 afbf0024 afb40020 afb3001c afb20018 
	afb10014 afb00010 0080a021 00a09821 8fa30038 8fa20040 8c450000 8c440008 
	8c420010 24070001 14470006 00608821 00069027 02459021 00038827 1000000e 
	02248821 24070002 14470005 00c09021 00039027 00c08821 10000007 02459021 
	24070003 14470005 02511027 00068827 00609021 02248821 02511027 000217c2 
	0245282a 0224202a 00a42024 00441024 00002021 1040002b 00002821 24040015 
	00002821 0411FEFE 00000000 001287c3 02402021 02002821 0411FF0B 00000000 
	02402021 02002821 0411FF07 00000000 24040075 00002821 0411FEF1 00000000 
	001187c3 02202021 02002821 0411FEFE 00000000 02202021 02002821 0411FEFA 
	00000000 2404005c 00002821 0411FEE4 00000000 00132600 00141202 00822025 
	00132a03 0411FEF0 00000000 328400ff 00002821 0411FEEC 00000000 24040001 
	00002821 00801021 00a01821 8fbf0024 8fb40020 8fb3001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0028 

'swap
8c820000 8ca30000 ac830000 03e00008 aca20000 

'drawline
	27bdffa8 afbf0054 afb70050 afb6004c afb50048 afb40044 afb30040 afb2003c 
	afb10038 afb00034 0080a021 00a0a821 8fa40068 8fa20070 8fa30078 8fb30080 
	afa60020 afa40024 afa20028 afa3002c 0083882a 00642823 00831823 0071280a 
	00c2202a 00461823 00c21023 0064100b 0045882a 1220000a 8fa20028 27a40020 
	27a50024 0411FFD9 00000000 27a40028 27a5002c 0411FFD5 00000000 8fa20028 
	8fa30020 0043102a 1040000a 8fa30028 27a40020 27a50028 0411FFCC 00000000 
	27a40024 27a5002c 0411FFC8 00000000 8fa30028 8fa20020 8fa4002c 8fb20024 
	0244282a 10a00007 0062b023 00929023 001687c2 02168021 00108043 10000006 
	24170001 02449023 001687c2 02168021 00108043 2417ffff 0062182a 14600028 
	8fbf0054 1220000e 8fa30024 8fa70024 afa20010 000217c3 afa20014 afb30018 
	02802021 02a02821 00e03021 00073fc3 0411FF46 00000000 1000000c 02128023 
	afa30010 00031fc3 afa30014 afb30018 02802021 02a02821 00403021 00023fc3 
	0411FF3A 00000000 02128023 06010006 8fa20020 8fa20024 00571021 afa20024 
	02168021 8fa20020 24420001 afa20020 8fa30028 0062182a 1060ffda 8fbf0054 
	8fb70050 8fb6004c 8fb50048 8fb40044 8fb30040 8fb2003c 8fb10038 8fb00034 
	03e00008 27bd0058 

'drawchar
27bdff68 afbf0094 afbe0090 afb7008c afb60088 afb50084 
	afb40080 afb3007c afb20078 afb10074 afb00070 afa600a0 afa700a4 8fa200b0 
	afa20054 8fb500b8 8fa300c0 afa30050 8fb300d0 afb50058 00608821 8fa200c8 
	afa2005c afa40030 1440006c afa50034 00031823 afa30060 00111080 00511021 
	8fa30054 00621021 afa20048 24620005 afa20044 27b70030 27a30036 afa30038 
	0220a021 241e0001 0011b7c3 10000051 02209021 92e20000 02021007 30420001 
	10400020 00000000 165e000e 02351021 02151021 afa20010 000217c3 afa20014 
	afb30018 8fa400a0 8fa500a4 8fa60044 8fa7004c 0411FEE5 00000000 1000002f 
	26100001 afa20010 000217c3 afa20014 afb40018 afb6001c afb40020 afb60024 
	afb30028 8fa400a0 8fa500a4 8fa6003c 8fa70040 0411FE26 00000000 1000001f 
	26100001 165e000e 02351021 02151021 afa20010 000217c3 afa20014 afb30018 
	8fa400a8 8fa500ac 8fa60044 8fa7004c 0411FEC6 00000000 10000010 26100001 
	afa20010 000217c3 afa20014 afb40018 afb6001c afb40020 afb60024 afb30028 
	8fa400a8 8fa500ac 8fa6003c 8fa70040 0411FE07 00000000 26100001 24020008 
	1602ffbc 02348821 8fa30048 8fa20060 00621821 afa30048 8fa30044 2463ffff 
	afa30044 26f70001 8fa20038 52e20080 02408821 8fa30048 afa3003c 000317c3 
	afa20040 00008821 00008021 8fa30044 00031fc3 1000ffa7 afa3004c 24020001 
	8fa3005c 14620074 24020002 8fa20050 00021023 afa20060 8fa30054 24620001 
	8fa30050 00431023 afa20048 27a20030 27a3002a afa30038 0040b021 0220a821 
	8fa30058 24640001 001118c0 00831823 afa30064 241e0001 0011bfc3 8fa30054 
	00621023 afa20068 1000004b 0220a021 92c20005 02021007 30420001 1040001e 
	00000000 569e000d afb10010 afb20010 001217c3 afa20014 afb30018 8fa400a0 
	8fa500a4 8fa60044 8fa7004c 0411FE6F 00000000 1000002c 2610ffff 001117c3 
	afa20014 afb50018 afb7001c afb50020 afb70024 afb30028 8fa400a0 8fa500a4 
	8fa6003c 8fa70040 0411FDB1 00000000 1000001d 2610ffff 569e000d afb10010 
	afb20010 001217c3 afa20014 afb30018 8fa400a8 8fa500ac 8fa60044 8fa7004c 
	0411FE52 00000000 1000000f 2610ffff 001117c3 afa20014 afb50018 afb7001c 
	afb50020 afb70024 afb30028 8fa400a8 8fa500ac 8fa6003c 8fa70040 0411FD94 
	00000000 2610ffff 02358821 2402ffff 1602ffbf 26520001 8fa20048 8fa30060 
	00431021 afa20048 26d6ffff 8fa20038 52c20081 02808821 8fa30048 afa3003c 
	000317c3 afa20040 8fb10064 8fa30058 2472fff9 24100007 8fa20068 00561021 
	afa20044 00021fc3 1000ffa9 afa3004c 24020002 8fa3005c 14620070 24020003 
	8fa20050 00021023 afa20058 8fa30054 24620001 8fa30050 00431023 afa20048 
	afa00044 24170001 0220a021 0011b7c3 10000052 0220f021 27a30030 00701021 
	90420005 02421024 10400020 00000000 17d7000e 02351021 02b01023 afa20010 
	000217c3 afa20014 afb30018 8fa400a0 8fa500a4 8fa6004c 8fa70050 0411FE03 
	00000000 1000002f 2610ffff afa20010 000217c3 afa20014 afb40018 afb6001c 
	afb40020 afb60024 afb30028 8fa400a0 8fa500a4 8fa6003c 8fa70040 0411FD44 
	00000000 1000001f 2610ffff 17d7000e 02351021 02b01023 afa20010 000217c3 
	afa20014 afb30018 8fa400a8 8fa500ac 8fa6004c 8fa70050 0411FDE4 00000000 
	10000010 2610ffff afa20010 000217c3 afa20014 afb40018 afb6001c afb40020 
	afb60024 afb30028 8fa400a8 8fa500ac 8fa6003c 8fa70040 0411FD25 00000000 
	2610ffff 2402fffa 1602ffbb 02348821 8fa30044 24630001 afa30044 8fa20048 
	8fa30058 00431021 afa20048 24020008 8fa30044 1062008d 8fbf0094 8fa20044 
	00579004 8fa30048 afa3003c 000317c3 afa20040 00008821 00008021 8fa30054 
	8fa20044 00621823 afa3004c 00031fc3 1000ffa1 afa30050 24020003 8fa3005c 
	14620079 24170001 8fa20050 00021023 afa2005c 8fa30050 000310c0 00431023 
	8fa30054 00621021 afa20048 24620007 afa20044 24030007 afa3004c 0220a821 
	8fa20058 24430001 00112040 001110c0 00821023 00621021 afa20054 27a30036 
	afa30038 0011b7c3 0220f021 10000050 0260a021 92020000 02621024 1040001e 
	00000000 57d7000d afb10010 afb20010 001217c3 afa20014 afb40018 8fa400a0 
	8fa500a4 8fa60044 8fa70050 0411FD87 00000000 1000002c 26100001 001117c3 
	afa20014 afb50018 afb6001c afb50020 afb60024 afb40028 8fa400a0 8fa500a4 
	8fa6003c 8fa70040 0411FCC9 00000000 1000001d 26100001 57d7000d afb10010 
	afb20010 001217c3 afa20014 afb40018 8fa400a8 8fa500ac 8fa60044 8fa70050 
	0411FD6A 00000000 1000000f 26100001 001117c3 afa20014 afb50018 afb6001c 
	afb50020 afb60024 afb40028 8fa400a8 8fa500ac 8fa6003c 8fa70040 0411FCAC 
	00000000 26100001 02358821 8fa20038 1602ffc0 26520001 8fa3004c 2463ffff 
	afa3004c 8fa20048 8fa3005c 00431021 afa20048 8fa20044 2442ffff afa20044 
	2402ffff 8fa3004c 10620010 8fbf0094 8fa2004c 00579804 8fa30048 afa3003c 
	000317c3 afa20040 27b00030 8fb10054 8fa30058 2472fffb 8fa20044 000217c3 
	1000ffa4 afa20050 8fbf0094 8fbe0090 8fb7008c 8fb60088 8fb50084 8fb40080 
	8fb3007c 8fb20078 8fb10074 8fb00070 03e00008 27bd0098 

'nextchar
14e00008 24020001 
	00061040 000618c0 00621023 8c830000 00621021 10000012 ac820000 14e20007 
	00061040 000630c0 00463023 8c820000 00463021 03e00008 ac860000 24020002 
	14e20007 00061040 000630c0 00c23023 8ca20000 00463021 03e00008 aca60000 
	24020003 14e20006 00061040 000630c0 00463023 8ca20000 00463021 aca60000 
	03e00008 00000000 

'testchar
8fa30010 8c680000 8c620014 1c400007 8c690008 14400008 
	00000000 8c620010 2c420002 14400004 00000000 01001021 01204021 00404821 
	14e00006 24020001 00061040 000618c0 00621023 1000000e 00822021 14e20005 
	00061040 000630c0 00463023 1000000e 00862021 24020002 14e20005 00061040 
	000630c0 00c23023 10000007 00a62821 24020003 14e20004 00061040 000630c0 
	00463023 00a62821 04800006 00001021 04a00004 0104202a 14800002 0125282a 
	38a20001 03e00008 00000000 

'pstring
27bdff70 afbf008c afbe0088 afb70084 afb60080 
	afb5007c afb40078 afb30074 afb20070 afb1006c afb00068 8fa300a0 8fb000a8 
	8fb300b0 8fa700b8 8fa800c0 8fb500c8 8fb600cc afa60040 afa30044 02008821 
	02609021 00e0b821 afa40060 92c20000 10400049 0100f021 18400063 24100001 
	000717c3 afa20050 00081fc3 afa30054 001117c3 afa20058 00131fc3 afa3005c 
	02d01021 90420000 2443ffe0 306300ff 2c630060 50600008 00009821 2442ffe0 
	000210c0 8fa30060 00431021 8c530000 10000002 8c540004 0000a021 afb50010 
	8fa40040 8fa50044 02203021 02403821 0411FF95 00000000 1040004c 02602021 
	afbe0010 8fa20054 afa20014 8fa20040 afa20018 000217c3 afa2001c 8fa20044 
	afa20020 000217c3 afa20024 afb10028 8fa30058 afa3002c afb20030 8fa2005c 
	afa20034 afb50038 02802821 02e03021 8fa70050 0411FD64 00000000 afa20048 
	afa3004c 27a40040 27a50044 02203021 02403821 0411FF50 00000000 26100001 
	92c20000 0050102a 5040ffc6 02d01021 1000001e 8fa20040 afa80010 000847c3 
	afa80014 afa60018 000637c3 afa6001c afa30020 00031fc3 afa30024 afb00028 
	001017c3 afa2002c afb30030 001317c3 afa20034 afb50038 00e03021 00073fc3 
	0411FD41 00000000 afa20048 afa3004c 27a40040 27a50044 02003021 02603821 
	0411FF2D 00000000 8fa20040 aea20020 000217c3 aea20024 8fa20044 aea20028 
	000217c3 10000005 aea2002c 00001021 00001821 afa20048 afa3004c 8fa20048 
	8fa3004c 8fbf008c 8fbe0088 8fb70084 8fb60080 8fb5007c 8fb40078 8fb30074 
	8fb20070 8fb1006c 8fb00068 03e00008 27bd0090 

'dcirch
27bdffa0 afbf005c afbe0058 
	afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 
	afa40060 afa50064 00c0b021 8fb50070 8fb00078 8fa20080 8fb70088 afa60024 
	afb50028 afa20020 30420010 1040002a 02008821 000697c3 02151021 afa20010 
	000217c3 afa20014 afb70018 02403821 0411FC1E 00000000 02b01023 afa20010 
	000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 02403821 0411FC13 
	00000000 001597c3 02163821 afb50010 afb20014 afb70018 8fa40060 8fa50064 
	00e03021 00073fc3 0411FC08 00000000 02d03823 afb50010 afb20014 afb70018 
	8fa40060 8fa50064 00e03021 00073fc3 0411FBFE 00000000 1a20008f 24110001 
	02308823 0010f023 001ef040 26b3ffff 26d4ffff 26b50001 26d60001 00009021 
	8fa20020 30420004 afa2002c 8fa30020 30630002 afa30030 8fa20020 30420008 
	afa20034 8fa30020 30630001 afa30020 06200004 8fa2002c 2610ffff 27de0002 
	023e8821 10400019 26520001 8fa30028 02031021 afa20010 000217c3 afa20014 
	afb70018 8fa40060 8fa50064 02c03021 00163fc3 0411FBD5 00000000 8fa20024 
	02023821 afb50010 001517c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 
	00073fc3 0411FBC9 00000000 8fa30030 1060001a 8fa30034 8fa30028 00701023 
	afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 00163fc3 
	0411FBBA 00000000 8fa20024 02023821 afb30010 001317c3 afa20014 afb70018 
	8fa40060 8fa50064 00e03021 00073fc3 0411FBAE 00000000 8fa30034 1060001a 
	8fa20020 8fa20024 00503823 afb50010 001517c3 afa20014 afb70018 8fa40060 
	8fa50064 00e03021 00073fc3 0411FB9F 00000000 8fa30028 02031021 afa20010 
	000217c3 afa20014 afb70018 8fa40060 8fa50064 02803021 00143fc3 0411FB93 
	00000000 8fa20020 5040001a 2673ffff 8fa30024 00703823 afb30010 001317c3 
	afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FB84 00000000 
	8fa30028 00701023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 
	02803021 00143fc3 0411FB78 00000000 2673ffff 2694ffff 26b50001 0250102a 
	10400005 26d60001 00121040 24420001 1000ff87 02228821 8fbf005c 8fbe0058 
	8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 
	03e00008 27bd0060 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c 
	afb40058 afb30054 afb20050 afb1004c afb00048 8fb10080 8fb40090 8fbe00a0 
	afa40038 afa6003c 8fa20088 1a200076 02801821 24100001 02118023 0011b823 
	0017b840 2495ffff 24d3ffff 26940003 24960001 00009021 30440001 afa40030 
	24630001 afa30040 30420002 afa20034 06000004 8fa20030 2631ffff 26f70002 
	02178021 1040002a 26520001 8fa3003c 00711023 afa20010 000217c3 afa20014 
	24020001 00001821 afa20018 afa3001c 00111040 8fa30040 00621021 afa20020 
	000217c3 afa20024 afbe0028 8fa40098 8fa5009c 02c03021 00163fc3 0411FA74 
	00000000 8fa40038 02243821 afb30010 001317c3 afa20014 24020001 00001821 
	afa20018 afa3001c afb40020 001417c3 afa20024 afbe0028 8fa40098 8fa5009c 
	00e03021 00073fc3 0411FA61 00000000 8fa30034 5060002b 26b5ffff 8fa4003c 
	00911023 afa20010 000217c3 afa20014 24020001 00001821 afa20018 afa3001c 
	00111040 8fa30040 00621021 afa20020 000217c3 afa20024 afbe0028 8fa40098 
	8fa5009c 02a03021 00153fc3 0411FA48 00000000 8fa40038 00913823 afb30010 
	001317c3 afa20014 24020001 00001821 afa20018 afa3001c afb40020 001417c3 
	afa20024 afbe0028 8fa40098 8fa5009c 00e03021 00073fc3 0411FA35 00000000 
	26b5ffff 2673ffff 26940002 0251102a 10400005 26d60001 00121040 24420001 
	1000ff9b 02028021 8fbf006c 8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 
	8fb30054 8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'ftri
27bdff88 afbf0074 
	afb70070 afb6006c afb50068 afb40064 afb30060 afb2005c afb10058 afb00054 
	8fa20090 8fb400a8 8fb500ac 8fb100b0 afa40038 afa6003c 8fa30088 afa30040 
	afa20044 8fa30098 afa30048 8fa300a0 0046102a 10400009 afa3004c 27a4003c 
	27a50044 0411FB11 00000000 27a40038 27a50040 0411FB0D 00000000 8fa2004c 
	8fa30044 0043102a 1040000a 8fa20044 27a4004c 27a50044 0411FB04 00000000 
	27a40048 27a50040 0411FB00 00000000 8fa20044 8fa3003c 0043102a 1040000a 
	8fb0003c 27a4003c 27a50044 0411FAF7 00000000 27a40038 27a50040 0411FAF3 
	00000000 8fb0003c 8fa2004c 1602002e 8fb20044 8fa20038 afa20030 afa20034 
	8fa30040 0062202a 10800003 0043102a 10000003 afa30030 54400001 afa30034 
	8fa20048 8fa30030 0043182a 10600003 8fa30034 10000004 afa20030 0062182a 
	54600001 afa20034 8fa70030 8fa2003c afa20010 000217c3 afa20014 24020001 
	00001821 afa20018 afa3001c 8fa20034 24420001 00471023 afa20020 000217c3 
	afa20024 afb10028 02802021 02a02821 00e03021 00073fc3 0411F9B5 00000000 
	1000007a 8fbf0074 

'.LBB2
00521026 0002102b 02429023 0250102a 14400039 8fa2004c 
	24160001 0000b821 8fa20038 8fa3003c 02032823 8fa60040 00c23023 70a63002 
	8fa40044 00832023 00c4001a 008001f4 00002012 00822021 afa40030 8fa60048 
	00c23023 70a62802 8fa6004c 00c31823 00a3001a 006001f4 00001812 00621021 
	afa20034 0044102a 10400006 8fa70030 27a40030 27a50034 0411FA9C 00000000 
	8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 00471023 afa20018 
	000217c3 afa2001c afb60020 afb70024 afb10028 02802021 02a02821 00e03021 
	00073fc3 0411F97A 00000000 26100001 0250102a 1040ffcd 8fa20038 8fa2004c 
	0050182a 14600038 24120001 00009821 8fa60040 8fa40038 8fa50048 8fa80044 
	02083823 00a61823 70e33802 00484023 00e8001a 010001f4 00001812 00661821 
	afa30030 8fa7003c 02073023 00a42823 70c53002 00471023 00c2001a 004001f4 
	00001012 00442021 afa40034 0083202a 10800006 8fa70030 27a40030 27a50034 
	0411FA62 00000000 8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 
	00471023 afa20018 000217c3 afa2001c afb20020 afb30024 afb10028 02802021 
	02a02821 00e03021 00073fc3 0411F940 00000000 26100001 8fa2004c 0050182a 
	1060ffcc 8fa60040 

'.LBE2
8fbf0074 8fb70070 8fb6006c 8fb50068 8fb40064 8fb30060 
	8fb2005c 8fb10058 8fb00054 03e00008 27bd0078 

'main
27bdffb8 afbf0044 afb00040 
	00808021 00e01021 8faa0058 8fa9005c 8fa80060 8fac0064 8c830000 8c840004 
	00643825 14e00010 8fab0068 8ca50000 8cc70000 8c420000 afa20010 000217c3 
	afa20014 afaa0018 00a02021 00052fc3 00e03021 00073fc3 0411F9C4 00000000 
	100000c8 8fbf0044 24070001 14670018 24070002 14800016 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 
	8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 afa80028 
	0411F8FB 00000000 100000ae 8fbf0044 14670021 24070003 1480001f 00000000 
	8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 
	8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 
	8d020000 8d030004 afa20028 afa3002c 8d820000 8d830004 afa20030 afa30034 
	afab0038 0411FEBC 00000000 8e020000 1000008b 8e030004 14670019 24070004 
	14800017 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c420000 afa20010 
	000217c3 afa20014 8d420000 afa20018 000217c3 afa2001c 8d220000 afa20020 
	000217c3 afa20024 afa80028 0411F9D4 00000000 8e020000 10000071 8e030004 
	1467000a 24070005 14800008 00000000 8ca40000 8ca50004 0411F891 00000000 
	8e020000 10000066 8e030004 1467000a 24070007 14800008 00000000 8ca40000 
	8ca50004 0411F898 00000000 8e020000 1000005b 8e030004 14670022 24070008 
	14800020 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 
	afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 
	afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 8d820000 8d830004 
	afa20030 afa30034 afab0038 8fa2006c afa2003c 0411FC5D 00000000 10000039 
	8fbf0044 1467001d 24070009 1480001b 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 
	afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 
	afa3002c afac0030 0411FDB7 00000000 8e020000 1000001a 8e030004 14670019 
	8fbf0044 54800018 8fb00040 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 
	8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 
	8d230004 afa20020 afa30024 afa80028 0411FCC0 00000000 8e020000 8e030004 
	8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
'
'
sub S1351_test
  local integer i,j, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  S1351.fillscreen(black)
  S1351.setrot(0)
  wi= S1351_params(0)
  ht= S1351_params(1)

  S1351.pbitmap(58, 2, &HFF81818181FF, 1, 0, green, black)
  S1351.pstring(24, 14, "Welcome to the", 1, 0, green, black)
  S1351.pstring(8, 27, "Micromite", 2, 0, red, black)
  S1351.pstring(44,47,"MK2",2,0,red,black)
  S1351.pstring(36, 66,  "in colour", 1, 0, yellow, black)
  S1351.pstring(15, 77, "OLED SPI display", 1, 0, cyan, black)
  S1351.pstring(6, 86,  "SSD1351R controller", 1, 0, cyan, black)
  S1351.drect(0, 0, S1351_params(S1351_wi), S1351_params(S1351_ht), red)
  pause 4000
' demo fast line draw
  S1351.fillscreen(black)
  x0=0:y0=0:y1=S1351_params(S1351_ht)-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    x1=S1351_params(S1351_wi)*tn
    S1351.dline(x0, y0, x1, y1, red)
  next i
  x1=S1351_params(S1351_wi)-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    y1=S1351_params(S1351_ht)*tn
    S1351.dline(x0, y0, x1, y1, red)
  next i
  S1351.drect(0, 0, S1351_params(S1351_wi), S1351_params(S1351_ht), blue)
  pause 2000
'demo fast text write
  S1351.fillscreen(black)
  S1351.setrot(S1351_rt_right)
  for i=0 to S1351_params(S1351_wi)-8 step 8
    S1351.pstring(0, i, "Hello world:Bye world:Hello world", 1, S1351_normal, green, black)
  next i
  pause 2000
'
  S1351.setrot(S1351_normal)
  S1351.fillscreen(yellow)
  for i=S1351_params(S1351_ht)-1 to 15 step -16
    S1351.pstring(S1351_params(S1351_wi)-1, i, "Micromite MK2:Micromite MK2", 2, S1351_inverse, red, yellow)
  next i
  pause 2000
'
  S1351.fillscreen(blue)
  for i=23 to S1351_params(S1351_wi) + 24 step 24
    S1351.pstring(i, 0, "Rotate right", 3, S1351_rt_right, yellow, blue)
  next i
  pause 2000
'
  S1351.fillscreen(black)
  for i=S1351_params(S1351_wi)-32 to 0 step -32
    S1351.pstring(i, S1351_params(S1351_ht)-1, "Left", 4, S1351_rt_left, blue, black)
  next i
  pause 2000
'
  ' test drawing rectangles
  S1351.fillscreen(black)
  for i=0 to 3
     S1351.setrot(i)
     S1351.frect(4, 4, 12, 17, blue)
     S1351.drect(2, 2, 16, 21, red)
  next i
  pause 2000
' test drawing rounded rectangles
  S1351.fillscreen(black)
  for i=0 to 3
     S1351.setrot(i)
     S1351.frndrect(4, 4, 12, 17, 4, blue)
     S1351.drndrect(2, 2, 16, 21, 6, red)
  next i
  pause 2000
  S1351.fillscreen(black)
' test drawing circles
  for i=0 to 3
     S1351.setrot(i)
     S1351.fcirc(10, 10, 7, blue)
     S1351.dcirc(10, 10, 9, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  S1351.fillscreen(black)
  for i=0 to 3
     S1351.setrot(i)
     S1351.ftri(4, 4, 20, 6, 12, 14, blue)
     S1351.dtri(1, 2, 24, 4, 12, 17, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  S1351.fillscreen(black)
  S1351.setrot(S1351_normal)
  S1351.pstring(wi/2, ht/2, "N", 3, S1351_normal, white, black)
  S1351.pstring(0, 0, "S1351_normal", sz, S1351_normal, red, black)
  S1351.pstring(wi-1, ht-1, "Inverted", sz, S1351_inverse, blue, black)
  S1351.pstring(wi-1, 0, "Rotated right", sz, S1351_rt_right, green, black)
  S1351.pstring(0, ht-1, "Rotated left", sz, S1351_rt_left, yellow, black)
  pause 1000
  S1351.fillscreen(black)
  S1351.setrot(S1351_inverse)
  S1351.pstring(wi/2, ht/2, "I", 3, S1351_inverse, white, black)
  S1351.pstring(0, 0, "S1351_normal", sz, S1351_normal, red, black)
  S1351.pstring(wi-1, ht-1, "Inverted", sz, S1351_inverse, blue, black)
  S1351.pstring(wi-1, 0, "Rotated right", sz, S1351_rt_right, green, black)
  S1351.pstring(0, ht-1, "Rotated left", sz, S1351_rt_left, yellow, black)
  pause 1000
  S1351.fillscreen(black)
  S1351.setrot(S1351_rt_right)
  S1351.pstring(ht/2, wi/2, "R", 3, S1351_rt_left, white, black)
  S1351.pstring(0, 0, "S1351_normal", sz, S1351_normal, red, black)
  S1351.pstring(ht-1, wi-1, "Inverted", sz, S1351_inverse, blue, black)
  S1351.pstring(ht-1, 0, "Rotated right", sz, S1351_rt_right, green, black)
  S1351.pstring(0, wi-1, "Rotated left", sz, S1351_rt_left, yellow, black)
  pause 1000
  S1351.fillscreen(black)
  S1351.setrot(S1351_rt_left)
  S1351.pstring(ht/2, wi/2, "L", 3, S1351_rt_right, white, black)
  S1351.pstring(0, 0, "S1351_normal", sz, S1351_normal, red, black)
  S1351.pstring(ht-1, wi-1, "Inverted", sz, S1351_inverse, blue, black)
  S1351.pstring(ht-1, 0, "Rotated right", sz, S1351_rt_right, green, black)
  S1351.pstring(0, wi-1, "Rotated left", sz, S1351_rt_left, yellow, black)
  pause 1000
  next sz
end sub

