'************************************************************************************* 
' 
' Peter Mather
' 
' V2.0 
' 2015-04-02 
' 
' Graphics library with drivers for ILI9341 SPI display
' NB cFunctions are the same as for ST7735 and S6D02A1 serial displays
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub I9341.setrot(x) ;I9341_normal=normal, I9341_inverse=invert, I9341_rt_right=rotate right, I9341_rt_left=rotate left
' draw pixel: sub I9341.dcirc(x0, y0, colour) ;x, y coordinates, colour
' draw circle: sub I9341.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub I9341.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub I9341.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub I9341.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub I9341.pstring(xx0, yy0, text$, sz, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
'                 Use size=0 to print the alternate font
' print 8x5 bitmap: sub I9341.pbitmap(xx0, yy0, char, sz, forecolour, backcolour) ;x, y coordinates of top left of first character, bitmap, size, character orientation,  foreground colour,  background colour
' draw line: sub I9341.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub I9341.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub I9341.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub I9341.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub I9341.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option default none
option explicit
cpu 48

I9341.init
do
  I9341_test
loop
end
'
sub I9341.init
'Global "Constants"
'Local "CONSTANTS"
' 44-pin
'  const I9341_CS=11 'b13 fixed pin allocation to match Cfunction
'  const I9341_CD=15 'b15 fixed pin allocation to match Cfunction
'  const I9341_RESET=2 'use any pin as required
' 28-pin
  const I9341_CS=24 'b13 fixed pin allocation to match Cfunction
  const I9341_CD=26 'b15 fixed pin allocation to match Cfunction
  const I9341_RESET=2 'use any pin as required
' 64-pin
'  const I9341_CS=28 'b13 fixed pin allocation to match Cfunction
'  const I9341_CD=30 'b15 fixed pin allocation to match Cfunction
'  const I9341_RESET=2 'use any pin as required
'
' 100-pin
'  const I9341_CS=42 'b13 fixed pin allocation to match Cfunction
'  const I9341_CD=44 'b15 fixed pin allocation to match Cfunction
'  const I9341_RESET=1 'use any pin as required
'
  const ILI9341_SOFTRESET          =&H01
  Const ILI9341_SLEEPIN            =&H10
  Const ILI9341_SLEEPOUT           =&H11
  Const ILI9341_NORMALDISP         =&H13
  Const ILI9341_INVERTOFF          =&H20
  Const ILI9341_INVERTON           =&H21
  Const ILI9341_GAMMASET           =&H26
  Const ILI9341_DISPLAYOFF         =&H28
  Const ILI9341_DISPLAYON          =&H29
  Const ILI9341_COLADDRSET         =&H2A
  Const ILI9341_PAGEADDRSET        =&H2B
  Const ILI9341_MEMORYWRITE        =&H2C
  Const ILI9341_PIXELFORMAT        =&H3A
  Const ILI9341_FRAMECONTROL       =&HB1
  Const ILI9341_DISPLAYFUNC        =&HB6
  Const ILI9341_ENTRYMODE          =&HB7
  Const ILI9341_POWERCONTROL1      =&HC0
  Const ILI9341_POWERCONTROL2      =&HC1
  Const ILI9341_VCOMCONTROL1      =&HC5
  Const ILI9341_VCOMCONTROL2      =&HC7
  DIM integer  ILI9341_MEMCONTROL =&H36
  DIM integer  ILI9341_MADCTL_MY  =&H80
  DIM integer  ILI9341_MADCTL_MX  =&H40
  DIM integer  ILI9341_MADCTL_MV  =&H20
  DIM integer  ILI9341_MADCTL_ML  =&H10
  DIM integer  ILI9341_MADCTL_RGB =&H00
  DIM integer  ILI9341_MADCTL_BGR =&H08
  DIM integer  ILI9341_MADCTL_MH  =&H04
'  
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer I9341.pix=0
  dim integer I9341.ffr=1
  dim integer I9341.filltri=2
  dim integer I9341.drawline=3
  dim integer I9341.wcom=4
  dim integer I9341.wdata=5
  dim integer I9341.pfonts=6
  dim integer I9341.fpstring=7
  dim integer I9341.fcirch=8
  dim integer I9341.dcirch=9
  dim integer I9341_normal=0
  dim integer I9341_inverse=1
  dim integer I9341_rt_right=2
  dim integer I9341_rt_left=3
  dim integer I9341_AddrOfFont(1), I9341_params(6) ' Global variables
  DIM integer I9341_wi=0,I9341_ht=1,I9341_rot=2,I9341_nr=3,I9341_X=4,I9341_Y=5,I9341_seed=6  
  dim integer mycol(32*50) 'buffer for maximum font size allowed
  I9341_AddrOfFont(0)=PEEK(CFunAddr font0)  
  I9341_AddrOfFont(1)=peek(cfunaddr font1)
  local integer i
  spi open 12000000,3,8
  I9341_Params(I9341_wi)=240
  I9341_params(I9341_ht)=320
  pin(I9341_CS)=1
  setpin I9341_CS, DOUT
  pin(I9341_CD)=1
  setpin I9341_CD, DOUT
  pin(I9341_RESET)=1
  setpin I9341_RESET, DOUT'  Reset the display
  pin(I9341_RESET)=0
  pause 100
  pin(I9341_RESET)=1
  pause 100
  i=I9341draw(I9341.wcom,ILI9341_SOFTRESET)'software reset
  pause 150
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYOFF)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL1)
  i=I9341draw(I9341.wdata,&H23)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL2)
  i=I9341draw(I9341.wdata,&H10)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL1)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL2)
  i=I9341draw(I9341.wdata,&HC0)
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata,(ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR))
  i=I9341draw(I9341.wcom,ILI9341_PIXELFORMAT)
  i=I9341draw(I9341.wdata,&H55)
  i=I9341draw(I9341.wcom,ILI9341_FRAMECONTROL)
  i=I9341draw(I9341.wdata,&H00)
  i=I9341draw(I9341.wdata,&H1B)
  i=I9341draw(I9341.wcom,ILI9341_ENTRYMODE)
  i=I9341draw(I9341.wdata,&H07)
  i=I9341draw(I9341.wcom,ILI9341_SLEEPOUT)
  i=I9341draw(I9341.wdata,0)
  pause 150
  i=I9341draw(I9341.wcom,ILI9341_NORMALDISP)
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYON)
  pause 500
  I9341.setrot(I9341_normal)
  i=I9341draw(I9341.wcom,ILI9341_COLADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,239)
  i=I9341draw(I9341.wcom,ILI9341_PAGEADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,1)
  i=I9341draw(I9341.wdata,63)
  I9341.fillscreen(black)
end sub
'
sub I9341.setrot(x%) 'sets screen rotation: 0=I9341_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer i=x% \ 2 '0 for portrait, 1 for landscape
   local integer j=I9341_params(I9341_rot)\2 
   I9341_params(I9341_rot)=(x% and 3)
   if i<>j then 'swap height and width if landscape
     local integer k=I9341_params(I9341_wi)
     I9341_params(I9341_wi)=I9341_params(I9341_ht)
     I9341_params(I9341_ht)=k
   endif  
   on I9341_params(I9341_rot)+1 goto rnor,rinv,rrr,rrl
   rnor:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR)
     exit sub
   rinv:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_BGR)
     exit sub
   rrr:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
     exit sub
   rrl:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_MX OR ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
end sub
'
' Generic drawing routines
'
sub I9341.pixel(x0 as integer, y0 as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=I9341draw(I9341.pix, colour,x0,y0,I9341_params())
end sub
'
sub I9341.fillscreen(scol as integer)
  local integer i=I9341_params(I9341_rot)
  I9341_params(I9341_rot)=I9341_normal
  local integer j=I9341draw(I9341.ffr,scol, 0,0,I9341_params(I9341_wi),I9341_params(I9341_ht), I9341_params())
  I9341_params(I9341_rot)=i
end sub
'
sub I9341.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=I9341draw(I9341.dcirch, colour,x0,y0,r,31,I9341_params())

end sub
 '
sub I9341.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  I9341.dline(x0, y0, x1, y1, colour)
  I9341.dline(x1, y1, x2, y2, colour)
  I9341.dline(x2, y2, x0, y0, colour)
end sub
 '
sub I9341.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer i=I9341draw(I9341.filltri, x0,y0,x1,y1,x2,y2,colour,I9341_params())
end sub
'
sub I9341.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i
  if sz=0 then
    i=I9341draw(I9341.pfonts,mycol(),I9341_AddrOfFont(0),xx0,yy0, fontcolour,backgroundcolour,text$,I9341_params())
  else
    i=I9341draw(I9341.fpstring,I9341_AddrOfFont(1),xx0,yy0,sz,fontcolour,backgroundcolour,text$,I9341_params())
  endif
  xx0=I9341_params(I9341_x)
end sub
'
sub I9341.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=I9341draw(I9341.fpstring,char,xx0,yy0,sz,fontcolour,backgroundcolour,"",I9341_params())
  xx0=I9341_params(I9341_x)
end sub
'
sub I9341.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=I9341draw(I9341.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,I9341_params(),"")
end sub
'
sub I9341.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=I9341draw(I9341.drawline, colour, xx0, yy0, xx1, yy1,  I9341_params())
end sub
'
sub I9341.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, 1,  I9341_params()) 
  a=y+h-1
  dp=I9341draw(I9341.ffr, rcolour, x, a, w, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y, 1, h,  I9341_params()) 
  a=x+w-1
  dp=I9341draw(I9341.ffr, rcolour, a, y, 1, h,  I9341_params()) 
end sub
'
sub I9341.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, h,  I9341_params()) 
end sub
'
FUNCTION I9341.Getchar(char as integer) as integer
  local integer i=char<<3
  I9341.Getchar=PEEK(WORD I9341_AddrOfFont+i)+(PEEK(WORD I9341_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub I9341.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=I9341draw(I9341.ffr, ccolour, x0, y0-r, 1, 2*r+1,  I9341_params())
  dp=I9341draw(I9341.fcircH,x0, y0, r, 3, 0, ccolour, I9341_params())
end sub
 '
sub I9341.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x+r, y, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.dcirch, rcolour, x+r, y+r, r, 1,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+r, r, 2,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+r, y+h-r-1, r, 8,I9341_params())
end sub
'
sub I9341.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, colour, x+r, y, w-2*r, h,  I9341_params()) 
  dp=I9341draw(I9341.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, I9341_params())
  dp=I9341draw(I9341.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, I9341_params())
end sub
'
'C:\Users\Peter\Dropbox\MPLABXProjects\ILI9341ST7735ser.X\dist\default\production\I9341draw.bas

'
'I9341draw  2015-02-04 11:21:14 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction I9341draw
'writeCommand
	0000061A
	3c02bf88 24032000 ac436134 34038000 ac436134 3c02bf80 ac445820 3c03bf80 
	8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 3c02bf80 8c425820 
	03e00008 00000000 

'writeData
3c02bf88 24032000 ac436134 34038000 ac436138 3c02bf80 
	ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 
	3c02bf80 8c425820 03e00008 00000000 

'colourrect
27bdffc8 afbf0034 afbe0030 afb7002c 
	afb60028 afb50024 afb40020 afb3001c afb20018 afb10014 afb00010 0080a021 
	00a09821 8fa40048 8fa50058 8fa30060 8c620000 8c630008 00c0a821 0080f021 
	24d0ffff 8fa70050 04c10004 02078021 24c60002 02068021 0000a821 0202382a 
	2446ffff 00c7800a 2491ffff 07c10004 02258821 24840002 02248821 0000f021 
	0223282a 2464ffff 0085880a 0000b021 0600005e 0000b821 0620005c 02a2102a 
	1040005a 03c3182a 50600059 02c01021 24020001 00551823 00701821 005e9023 
	02519021 72439002 2404002a 00002821 0411FFA3 00000000 7ea43a00 00002821 
	0411FFB1 00000000 32a400ff 00002821 0411FFAD 00000000 7e043a00 00002821 
	0411FFA9 00000000 320400ff 00002821 0411FFA5 00000000 2404002b 00002821 
	0411FF8F 00000000 7fc43a00 00002821 0411FF9D 00000000 33c400ff 00002821 
	0411FF99 00000000 7e243a00 00002821 0411FF95 00000000 322400ff 00002821 
	0411FF91 00000000 2404002c 00002821 0411FF7B 00000000 3c02bf88 34038000 
	ac436138 24032000 ac436134 00002021 2406ffff 3c08bf88 24072000 3c02bf80 
	10000013 0014a02b ad076134 000428c0 02652821 90a30001 ac435820 8c435810 
	30630080 1060fffd 00000000 8c435820 90a30000 ac435820 8c435810 30630080 
	1060fffd 00000000 8c435820 00942021 2652ffff 1646ffec 24032000 3c02bf88 
	ac436138 0080b021 0000b821 02c01021 02e01821 8fbf0034 8fbe0030 8fb7002c 
	8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0038 

'localfastfillrect
27bdffb8 afbf0044 afa40030 afa50034 8fa20058 8fa3005c afa20010 
	afa30014 8fa20060 8fa30064 afa20018 afa3001c 8fa20068 8fa3006c afa20020 
	afa30024 8fa20070 afa20028 00002021 27a50030 0411FF56 00000000 00021fc3 
	8fbf0044 03e00008 27bd0048 

'localdrawPixel
27bdffd8 afbf0024 afb30020 afb2001c afb10018 
	afb00014 00808821 00c08021 8fb30038 8fa20040 8c440004 1c800008 24030001 
	54800006 00001821 8c440000 00c4202b 14800003 306300ff 00001821 306300ff 
	10600049 00002021 8c44000c 1c800008 24030001 54800006 00001821 8c420008 
	0262102b 14400003 306300ff 00001821 306300ff 5060003c 00002021 2404002a 
	00002821 0411FF06 00000000 7e123a00 02402021 00002821 0411FF13 00000000 
	321000ff 02002021 00002821 0411FF0E 00000000 02402021 00002821 0411FF0A 
	00000000 02002021 00002821 0411FF06 00000000 2404002b 00002821 0411FEF0 
	00000000 7e723a00 02402021 00002821 0411FEFD 00000000 327000ff 02002021 
	00002821 0411FEF8 00000000 02402021 00002821 0411FEF4 00000000 02002021 
	00002821 0411FEF0 00000000 2404002c 00002821 0411FEDA 00000000 7e243a00 
	00002821 0411FEE8 00000000 322400ff 00002821 0411FEE4 00000000 24040001 
	10000002 00002821 00002821 00801021 00a01821 8fbf0024 8fb30020 8fb2001c 
	8fb10018 8fb00014 03e00008 27bd0028 

'swap
8c820000 8ca30000 ac830000 03e00008 
	aca20000 

'drawline
27bdffa8 afbf0054 afb70050 afb6004c afb50048 afb40044 afb30040 
	afb2003c afb10038 afb00034 0080a021 00a0a821 8fa40068 8fa20070 8fa30078 
	8fb30080 afa60020 afa40024 afa20028 afa3002c 0083882a 00642823 00831823 
	0071280a 00c2202a 00461823 00c21023 0064100b 0045882a 1220000a 8fa20028 
	27a40020 27a50024 0411FFD9 00000000 27a40028 27a5002c 0411FFD5 00000000 
	8fa20028 8fa30020 0043102a 1040000a 8fa30028 27a40020 27a50028 0411FFCC 
	00000000 27a40024 27a5002c 0411FFC8 00000000 8fa30028 8fa20020 8fa4002c 
	8fb20024 0244282a 10a00007 0062b023 00929023 001687c2 02168021 00108043 
	10000006 24170001 02449023 001687c2 02168021 00108043 2417ffff 0062182a 
	14600028 8fbf0054 1220000e 8fa30024 8fa70024 afa20010 000217c3 afa20014 
	afb30018 02802021 02a02821 00e03021 00073fc3 0411FF3D 00000000 1000000c 
	02128023 afa30010 00031fc3 afa30014 afb30018 02802021 02a02821 00403021 
	00023fc3 0411FF31 00000000 02128023 06010006 8fa20020 8fa20024 00571021 
	afa20024 02168021 8fa20020 24420001 afa20020 8fa30028 0062182a 1060ffda 
	8fbf0054 8fb70050 8fb6004c 8fb50048 8fb40044 8fb30040 8fb2003c 8fb10038 
	8fb00034 03e00008 27bd0058 

'drawchar
27bdfdf8 afbf0204 afbe0200 afb701fc afb601f8 
	afb501f4 afb401f0 afb301ec afb201e8 afb101e4 afb001e0 afa60210 afa70214 
	8fb30220 afa401b8 afa501bc 0260b021 8fa2021c afa201cc afa001d8 afa001c8 
	27be01b7 0013bfc3 00071fc3 afa301d0 000617c3 10000044 afa201d4 92020000 
	02821024 10400019 00000000 16750006 8fa301c0 8fa30210 ae430000 8fa201d4 
	10000028 ae420004 afa30010 8fa201c4 afa20014 afb30018 afb7001c afb30020 
	afb70024 8fa30224 afa30028 8fa40210 8fa501d4 02203021 00113fc3 0411FEC9 
	00000000 10000018 2610ffff 16750006 8fa201c0 8fa20214 ae420000 8fa301d0 
	10000010 ae430004 afa20010 8fa301c4 afa30014 afb30018 afb7001c afb30020 
	afb70024 8fa20224 afa20028 8fa40214 8fa501d0 02203021 00113fc3 0411FEB1 
	00000000 2610ffff 02368821 161effcb 26520008 8fa301c8 24630006 afa301c8 
	8fa201d8 24420001 afa201d8 8fa301cc 00761821 afa301cc 24020030 8fa301c8 
	10620010 24020001 24140001 8fa201d8 0054a004 8fa301cc afa301c0 000317c3 
	afa201c4 27b001bd 8fb10218 8fa301c8 000390c0 27a20030 00529021 1000ffaf 
	24150001 16620017 8fa201c8 8fa3021c afa30010 000317c3 afa20014 24020006 
	00001821 afa20018 afa3001c 24020008 00001821 afa20020 afa30024 8fa20224 
	afa20028 24040001 27a50030 8fa60218 00063fc3 0411FDE6 00000000 afa201c8 
	8fa201c8 00021fc3 8fbf0204 8fbe0200 8fb701fc 8fb601f8 8fb501f4 8fb401f0 
	8fb301ec 8fb201e8 8fb101e4 8fb001e0 03e00008 27bd0208 

'pstring
27bdffb0 afbf004c 
	afbe0048 afb70044 afb60040 afb5003c afb40038 afb30034 afb20030 afb1002c 
	afb00028 00c08821 8fa60060 afa60024 8fb30068 8fa60070 8fa70078 8fb20080 
	8fb40084 02204021 8fbe0024 0260b821 00c0b021 afa40020 92490000 11200028 
	00e0a821 19200031 001380c0 00131040 02028023 02009821 02308021 24110001 
	02511021 90420000 2444ffe0 308400ff 2c840060 10800008 02131823 2442ffe0 
	000210c0 8fa40020 00441021 8c440000 10000003 8c450004 00002021 00002821 
	afa30010 afbe0014 afb70018 afb4001c 02c03021 02a03821 0411FF34 00000000 
	02004021 26310001 92440000 0091202a 1080ffe3 02138021 1000000d ae880020 
	afb10010 8fa20024 afa20014 afb30018 afb4001c 0411FF25 00000000 00132040 
	001340c0 01044023 02284021 ae880020 000847c3 ae880024 8fa40024 ae840028 
	8fa50024 000527c3 ae84002c 8fbf004c 8fbe0048 8fb70044 8fb60040 8fb5003c 
	8fb40038 8fb30034 8fb20030 8fb1002c 8fb00028 03e00008 27bd0050 

'dcirch
27bdffa0 
	afbf005c afbe0058 afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 
	afb1003c afb00038 afa40060 afa50064 00c0b021 8fb50070 8fb00078 8fa20080 
	8fb70088 afa60024 afb50028 afa20020 30420010 1040002a 02008821 000697c3 
	02151021 afa20010 000217c3 afa20014 afb70018 02403821 0411FE04 00000000 
	02b01023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 
	02403821 0411FDF9 00000000 001597c3 02163821 afb50010 afb20014 afb70018 
	8fa40060 8fa50064 00e03021 00073fc3 0411FDEE 00000000 02d03823 afb50010 
	afb20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FDE4 00000000 
	1a20008f 24110001 02308823 0010f023 001ef040 26b3ffff 26d4ffff 26b50001 
	26d60001 00009021 8fa20020 30420004 afa2002c 8fa30020 30630002 afa30030 
	8fa20020 30420008 afa20034 8fa30020 30630001 afa30020 06200004 8fa2002c 
	2610ffff 27de0002 023e8821 10400019 26520001 8fa30028 02031021 afa20010 
	000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 00163fc3 0411FDBB 
	00000000 8fa20024 02023821 afb50010 001517c3 afa20014 afb70018 8fa40060 
	8fa50064 00e03021 00073fc3 0411FDAF 00000000 8fa30030 1060001a 8fa30034 
	8fa30028 00701023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 
	02c03021 00163fc3 0411FDA0 00000000 8fa20024 02023821 afb30010 001317c3 
	afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FD94 00000000 
	8fa30034 1060001a 8fa20020 8fa20024 00503823 afb50010 001517c3 afa20014 
	afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FD85 00000000 8fa30028 
	02031021 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02803021 
	00143fc3 0411FD79 00000000 8fa20020 5040001a 2673ffff 8fa30024 00703823 
	afb30010 001317c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 
	0411FD6A 00000000 8fa30028 00701023 afa20010 000217c3 afa20014 afb70018 
	8fa40060 8fa50064 02803021 00143fc3 0411FD5E 00000000 2673ffff 2694ffff 
	26b50001 0250102a 10400005 26d60001 00121040 24420001 1000ff87 02228821 
	8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 
	8fb1003c 8fb00038 03e00008 27bd0060 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 
	afb60060 afb5005c afb40058 afb30054 afb20050 afb1004c afb00048 8fb10080 
	8fb40090 8fbe00a0 afa40038 afa6003c 8fa20088 1a200076 02801821 24100001 
	02118023 0011b823 0017b840 2495ffff 24d3ffff 26940003 24960001 00009021 
	30440001 afa40030 24630001 afa30040 30420002 afa20034 06000004 8fa20030 
	2631ffff 26f70002 02178021 1040002a 26520001 8fa3003c 00711023 afa20010 
	000217c3 afa20014 24020001 00001821 afa20018 afa3001c 00111040 8fa30040 
	00621021 afa20020 000217c3 afa20024 afbe0028 8fa40098 8fa5009c 02c03021 
	00163fc3 0411FCEF 00000000 8fa40038 02243821 afb30010 001317c3 afa20014 
	24020001 00001821 afa20018 afa3001c afb40020 001417c3 afa20024 afbe0028 
	8fa40098 8fa5009c 00e03021 00073fc3 0411FCDC 00000000 8fa30034 5060002b 
	26b5ffff 8fa4003c 00911023 afa20010 000217c3 afa20014 24020001 00001821 
	afa20018 afa3001c 00111040 8fa30040 00621021 afa20020 000217c3 afa20024 
	afbe0028 8fa40098 8fa5009c 02a03021 00153fc3 0411FCC3 00000000 8fa40038 
	00913823 afb30010 001317c3 afa20014 24020001 00001821 afa20018 afa3001c 
	afb40020 001417c3 afa20024 afbe0028 8fa40098 8fa5009c 00e03021 00073fc3 
	0411FCB0 00000000 26b5ffff 2673ffff 26940002 0251102a 10400005 26d60001 
	00121040 24420001 1000ff9b 02028021 8fbf006c 8fbe0068 8fb70064 8fb60060 
	8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'ftri
	27bdff88 afbf0074 afb70070 afb6006c afb50068 afb40064 afb30060 afb2005c 
	afb10058 afb00054 8fa20090 8fb400a8 8fb500ac 8fb100b0 afa40038 afa6003c 
	8fa30088 afa30040 afa20044 8fa30098 afa30048 8fa300a0 0046102a 10400009 
	afa3004c 27a4003c 27a50044 0411FD00 00000000 27a40038 27a50040 0411FCFC 
	00000000 8fa2004c 8fa30044 0043102a 1040000a 8fa20044 27a4004c 27a50044 
	0411FCF3 00000000 27a40048 27a50040 0411FCEF 00000000 8fa20044 8fa3003c 
	0043102a 1040000a 8fb0003c 27a4003c 27a50044 0411FCE6 00000000 27a40038 
	27a50040 0411FCE2 00000000 8fb0003c 8fa2004c 1602002e 8fb20044 8fa20038 
	afa20030 afa20034 8fa30040 0062202a 10800003 0043102a 10000003 afa30030 
	54400001 afa30034 8fa20048 8fa30030 0043182a 10600003 8fa30034 10000004 
	afa20030 0062182a 54600001 afa20034 8fa70030 8fa2003c afa20010 000217c3 
	afa20014 24020001 00001821 afa20018 afa3001c 8fa20034 24420001 00471023 
	afa20020 000217c3 afa20024 afb10028 02802021 02a02821 00e03021 00073fc3 
	0411FC30 00000000 1000007a 8fbf0074 

'.LBB2
00521026 0002102b 02429023 0250102a 
	14400039 8fa2004c 24160001 0000b821 8fa20038 8fa3003c 02032823 8fa60040 
	00c23023 70a63002 8fa40044 00832023 00c4001a 008001f4 00002012 00822021 
	afa40030 8fa60048 00c23023 70a62802 8fa6004c 00c31823 00a3001a 006001f4 
	00001812 00621021 afa20034 0044102a 10400006 8fa70030 27a40030 27a50034 
	0411FC8B 00000000 8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 
	00471023 afa20018 000217c3 afa2001c afb60020 afb70024 afb10028 02802021 
	02a02821 00e03021 00073fc3 0411FBF5 00000000 26100001 0250102a 1040ffcd 
	8fa20038 8fa2004c 0050182a 14600038 24120001 00009821 8fa60040 8fa40038 
	8fa50048 8fa80044 02083823 00a61823 70e33802 00484023 00e8001a 010001f4 
	00001812 00661821 afa30030 8fa7003c 02073023 00a42823 70c53002 00471023 
	00c2001a 004001f4 00001012 00442021 afa40034 0083202a 10800006 8fa70030 
	27a40030 27a50034 0411FC51 00000000 8fa70030 afb00010 001017c3 afa20014 
	8fa20034 24420001 00471023 afa20018 000217c3 afa2001c afb20020 afb30024 
	afb10028 02802021 02a02821 00e03021 00073fc3 0411FBBB 00000000 26100001 
	8fa2004c 0050182a 1060ffcc 8fa60040 

'.LBE2
8fbf0074 8fb70070 8fb6006c 8fb50068 
	8fb40064 8fb30060 8fb2005c 8fb10058 8fb00054 03e00008 27bd0078 

'pchars
27bdff98 
	afbf0064 afbe0060 afb7005c afb60058 afb50054 afb40050 afb3004c afb20048 
	afb10044 afb00040 03a0f021 8fc50080 8fca0088 8fcb008c 8fc20090 afc20038 
	8fcc0094 afcc003c 8fc20098 8fc3009c 8fc800a0 8fc900a4 8fcc0038 716c7002 
	8fcc003c 718a6802 01ae7021 8fcf0038 01ea0019 00006012 00006810 01cd7021 
	000e7fc3 31ef001f 01ec6021 018fb82b 02eeb821 0017bec0 000c6142 02ecb825 
	000b6fc3 31ad0007 01aa6021 018d702b 01cb7021 000e7740 000c60c2 01cc7025 
	01c08821 00176080 258c000e 000c60c2 000c60c0 03ace823 1d600005 27ad0030 
	15600013 2d4c0002 15800012 24140001 24140001 240c0001 24180001 01987804 
	028fa025 258c0001 000c7fc3 01ebf82a 57e0fffb 01987804 156f0006 018a782b 
	15e0fff7 01987804 10000002 00000000 24140001 5ae00046 8fc20078 8cac0000 
	000c6080 71977802 01e42021 afcd0030 00006021 8c8f0000 adaf0000 258c0001 
	24840004 0197782a 15e0fffa 25ad0004 afc00034 00009821 24180001 3c161fff 
	36d6ffff 01d6b021 0016b0c0 1000002b 26d60008 02557807 1a20001c 01f47824 
	0013c8c0 00b9c821 240effff 10000013 00008021 00986804 01af6824 51a00004 
	ad880000 ad820000 10000002 ad830004 ad890004 2484ffff 148efff6 258c0008 
	26100001 0211202a 14800003 27390040 10000006 02769821 03e07021 25df0008 
	03206021 1000ffeb 03e02021 024a9021 2a440020 1480ffe0 02557807 8fc40034 
	24840001 afc40034 8fcc0030 258c0004 0097202a 10800005 afcc0030 8fcd0030 
	8db50000 1000ffd3 00009021 8fc20078 8fc3007c afa20010 afa30014 afaa0018 
	afab001c 8fcf0038 afaf0020 8fc2003c afa20024 8fc200a8 afa20028 24040001 
	0411FA73 00000000 03c0e821 8fbf0064 8fbe0060 8fb7005c 8fb60058 8fb50054 
	8fb40050 8fb3004c 8fb20048 8fb10044 8fb00040 03e00008 27bd0068 

'pfonts
27bdff80 
	afbf007c afbe0078 afb70074 afb60070 afb5006c afb40068 afb30064 afb20060 
	afb1005c afb00058 8fb00090 8fb20094 8fb500b0 8fb600b4 8cc20000 305400ff 
	7c573a00 7c423c00 afa20048 82a20000 18400033 00809821 24110001 001417c3 
	afa2004c 24de0004 03c6302b 00c73021 afa60050 00171fc3 afa30054 02b11021 
	80420000 8fa30048 00431023 ae620000 000217c3 ae620004 8fa20098 8fa3009c 
	afa20010 afa30014 afb30018 afb40020 8fa3004c afa30024 afb70028 8fa20054 
	afa2002c 8fa200a0 8fa300a4 afa20030 afa30034 8fa200a8 8fa300ac afa20038 
	afa3003c afb60040 03c02021 8fa50050 02003021 02403821 0411FF10 00000000 
	02141021 0050182b 00408021 26310001 82a20000 0051102a 1040ffd8 00729021 
	aed00020 aed20024 8fa20098 8fa3009c aec20028 aec3002c 8fbf007c 8fbe0078 
	8fb70074 8fb60070 8fb5006c 8fb40068 8fb30064 8fb20060 8fb1005c 8fb00058 
	03e00008 27bd0080 

'main
27bdffb8 afbf0044 afb00040 00808021 00e01021 8faa0058 
	8fa9005c 8fa80060 8fab0064 8c830000 8c840004 00643825 14e00010 8fac0068 
	8ca50000 8cc70000 8c420000 afa20010 000217c3 afa20014 afaa0018 00a02021 
	00052fc3 00e03021 00073fc3 0411FA9F 00000000 100000fd 8fbf0044 24070001 
	14670018 24070002 14800016 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 
	8d220000 8d230004 afa20020 afa30024 afa80028 0411FA6B 00000000 100000e3 
	8fbf0044 14670021 24070003 1480001f 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 
	afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 
	afa3002c 8d620000 8d630004 afa20030 afa30034 afac0038 0411FDB1 00000000 
	8e020000 100000c0 8e030004 14670019 24070004 14800017 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c420000 afa20010 000217c3 afa20014 8d420000 
	afa20018 000217c3 afa2001c 8d220000 afa20020 000217c3 afa20024 afa80028 
	0411FAB8 00000000 8e020000 100000a6 8e030004 1467000a 24070005 14800008 
	00000000 8ca40000 8ca50004 0411F96C 00000000 8e020000 1000009b 8e030004 
	1467000a 24070006 14800008 00000000 8ca40000 8ca50004 0411F973 00000000 
	8e020000 10000090 8e030004 1467001d 24070007 1480001b 00000000 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 
	afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 
	afa3002c afab0030 afac0034 00a02021 0411FF02 00000000 8e020000 10000072 
	8e030004 1467001d 24070008 1480001b 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 
	afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 
	afa3002c afab0030 afac0034 0411FB72 00000000 10000055 8fbf0044 1467001d 
	24070009 1480001b 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 
	8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 
	8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c afab0030 
	0411FC93 00000000 8e020000 10000036 8e030004 14670019 2407000a 14800017 
	00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 
	afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 
	afa30024 afa80028 0411FB9C 00000000 8e020000 1000001c 8e030004 1467001b 
	8fbf0044 1480001a 8fb00040 8ca40000 8c430004 8c420000 8d4c0000 8d4d0004 
	afac0010 afad0014 8d2c0000 8d2d0004 afac0018 afad001c 8d090004 8d080000 
	afa80020 afa90024 afab0028 00c02821 00403021 00603821 0411F8F5 00000000 
	10000002 8fbf0044 8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font1
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
'
'
'SevenSegNumFontPlus  2015-01-21 16:48:44 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction font0
	00000000
	0b303220 00000000 00000000 00feff00 00ffff01 80ffff03 60ffff01 f0feff0c 
	f801001e f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f 7800003e 18000038 
	08000020 00000000 00000020 18000038 7800003e f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f000001e 60feff0c 00ffff01 80ffff03 00ffff01 
	00feff00 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
	60000000 f0000000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	78000000 18000000 08000000 00000000 00000000 18000000 78000000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f0000000 60000000 00000000 
	00000000 00000000 00000000 00000000 00000000 00000000 00000000 00feff00 
	00ffff01 80ffff03 60ffff01 f0feff00 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 78000000 18feff01 88ffff03 e0ffff0f c0ffff27 00ffff39 
	0000003e 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 
	0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000001e 
	00feff0c 00ffff01 80ffff03 00ffff01 00feff00 00000000 00000000 00000000 
	00000000 00feff00 00ffff01 80ffff03 60ffff01 f0feff00 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 78000000 18feff01 88ffff03 e0ffff0f 
	c0ffff07 18ffff01 78000000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f0000000 60feff00 00ffff01 80ffff03 00ffff01 00feff00 00000000 
	00000000 00000000 00000000 00000000 00000000 00000000 60000000 f000000c 
	f801001e f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f 7800003e 18feff39 
	88ffff23 e0ffff0f c0ffff07 18ffff01 78000000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f0000000 60000000 00000000 00000000 00000000 
	00000000 00000000 00000000 00000000 00000000 00feff00 00ffff01 80ffff03 
	00ffff01 00feff0c 0000001e 0000003f 0000003f 0000003f 0000003f 0000003f 
	0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 
	0000003e 00feff39 80ffff23 e0ffff0f c0ffff07 18ffff01 78000000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f0000000 60feff00 00ffff01 
	80ffff03 00ffff01 00feff00 00000000 00000000 00000000 00000000 00feff00 
	00ffff01 80ffff03 00ffff01 00feff0c 0000001e 0000003f 0000003f 0000003f 
	0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 0000003f 
	0000003f 0000003f 0000003e 00feff39 80ffff23 e0ffff0f c0ffff27 18ffff39 
	7800003e f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f f801003f f000001e 
	60feff0c 00ffff01 80ffff03 00ffff01 00feff00 00000000 00000000 00000000 
	00000000 00feff00 00ffff01 80ffff03 60ffff01 f0feff00 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 78000000 18000000 08000000 00000000 
	00000000 18000000 78000000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f0000000 60000000 00000000 00000000 00000000 00000000 00000000 
	00000000 00000000 00000000 00feff00 00ffff01 80ffff03 60ffff01 f0feff0c 
	f801001e f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f 7800003e 18feff39 
	88ffff23 e0ffff0f c0ffff27 18ffff39 7800003e f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f000001e 60feff0c 00ffff01 80ffff03 00ffff01 
	00feff00 00000000 00000000 00000000 00000000 00feff00 00ffff01 80ffff03 
	60ffff01 f0feff0c f801001e f801003f f801003f f801003f f801003f f801003f 
	f801003f f801003f f801003f f801003f f801003f f801003f f801003f f801003f 
	7800003e 18feff39 88ffff23 e0ffff0f c0ffff07 18ffff01 78000000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 f8010000 
	f8010000 f8010000 f8010000 f8010000 f8010000 f0000000 60feff00 00ffff01 
	80ffff03 00ffff01 00feff00 00000000 00000000 00000000 00000000 00000000 
	00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
	00000000 00e00000 00f00100 00f80300 00f80300 00f80300 00f00100 00e00000 
	00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
	00000000 00000000 00000000 00000000 00000000 00000000 00e00000 00f00100 
	00f80300 00f80300 00f80300 00f00100 00e00000 00000000 00000000 00000000 
	00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 
End CFunction
'
sub I9341_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  I9341.setrot(I9341_normal)
  wi= I9341_params(I9341_wi)
  ht= I9341_params(I9341_ht)
  I9341.fillscreen(black)
  I9341.drect(0, 0, wi, ht, red)
  I9341.pbitmap(114, 10, &HFF81818181FF, 2,magenta, black)
  I9341.pstring(40, 40, "Welcome to the", 2,  green, black)
  I9341.pstring(5, 70, "Micromite MK2", 3,  red, black)
  I9341.pstring(60, 120, "in colour", 2, yellow, black)
  I9341.pstring(48, 170, "ILI9341 SPI controller", 1, cyan, black)
  pause 2000
  I9341.setrot(I9341_rt_right)  
  I9341.fillscreen(black)
  I9341.pstring(10, 85, "12:22:35",0, cyan, black)
  pause 2000
' demo graph draw
  I9341.setrot(I9341_normal)  
  I9341.fillscreen(black)
  I9341.dline(0,0,0,ht-1,red)
  I9341.dline(0,ht-1,wi-1,ht-1,red)
  for tn=1 to ht 
    I9341.pixel(cint(sqr(tn)*13)+1,I9341_params(1)-cint(tn)-1,white)
  next tn 
  pause 2000
' demo fast line draw
  I9341.setrot(I9341_normal)
  I9341.fillscreen(black)
  x0=0:y0=0:y1=ht-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    x1=wi*tn
    I9341.dline(x0, y0, x1, y1, red)
  next i
  x1=wi-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    y1=ht*tn
    I9341.dline(x0, y0, x1, y1, red)
  next i
  I9341.drect(0, 00, wi, ht, blue)
  pause 2000
  I9341.fillscreen(black)
'demo fast text write
  I9341.setrot(I9341_normal)
  for i=0 to ht-8 step 8
    I9341.pstring(0, i, "Hello world:Bye world:Hello world:Bye world:Hello world:Bye world", 1,  green, black)
  next i
  I9341.setrot(I9341_normal)
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_inverse)
  for i=0 to ht-16 step 16
    I9341.pstring(0, i, "Micromite MK2:Micromite MK2", 2,  red, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_rt_right)
  for i=0 to wi-24 step 24
    I9341.pstring(0, i, "Rotate right:Rotate right", 3,  yellow, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  I9341.setrot(I9341_rt_left)
  for i=0 to wi-32 step 32
    I9341.pstring(0, i, "Rotate Left:Rotate Left", 4, blue, black)
  next i
  pause 2000
  I9341.fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     I9341.setrot(i)
     I9341.frect(5, 5, 30, 45, blue)
     I9341.drect(2, 2, 36, 51, red)
  next i
  pause 2000
' test drawing rounded rectangles
  I9341.fillscreen(black)
  for i=0 to 3
     I9341.setrot(i)
     I9341.frndrect(5, 5, 30, 45, 10, blue)
     I9341.drndrect(2, 2, 36, 51, 12, red)
  next i
  pause 2000
  I9341.fillscreen(black)
' test drawing circles
  for i=0 to 3
     I9341.setrot(i)
     I9341.fcirc(40, 40, 37, blue)
     I9341.dcirc(40, 40, 39, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  I9341.fillscreen(black)
  for i=0 to 3
     I9341.setrot(i)
     I9341.ftri(4, 4, 40, 6, 22, 24, blue)
     I9341.dtri(1, 2, 44, 4, 22, 27, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  I9341.fillscreen(black)
  I9341.setrot(I9341_normal)
  I9341.pstring(0, 0, "I9341_normal", sz,  red, black)
  I9341.setrot(I9341_inverse)
  I9341.pstring(0, 0, "Inverted", sz,  blue, black)
  I9341.setrot(I9341_rt_right)
  I9341.pstring(0, 0, "Rotated right", sz,  green, black)
  I9341.setrot(I9341_rt_left)
  I9341.pstring(0, 0, "Rotated left", sz,  yellow, black)
  pause 2000
  next sz
end SUB
