#define gsetport *(volatile unsigned int *)(0xbf886638) //latch registers
#define gclearport *(volatile unsigned int *)(0xbf886634) //latch registers
#define bport *(volatile unsigned int *)(0xbf886130) //latch registers
#define devid *(volatile unsigned int *)(0xBF80F220) //Device ID
#define cd 2//mask for command/data pin
#define wr 1//mask for write-data pin
//
const long long font[]= {
	0x000000000000,
	0x00005F000000,
	0x000700070000,
	0x147F147F1400,
	0x242A7F2A1200,
	0x231308646200,
	0x364956205000,
	0x000807030000,
	0x001C22410000,
	0x0041221C0000,
	0x2A1C7F1C2A00,
	0x08083E080800,
	0x008070300000,
	0x080808080800,
	0x000060600000,
	0x201008040200,
	0x3E5149453E00,
	0x00427F400000,
	0x724949494600,
	0x2141494D3300,
	0x1814127F1000,
	0x274545453900,
	0x3C4A49493100,
	0x412111090700,
	0x364949493600,
	0x464949291E00,
	0x000014000000,
	0x004034000000,
	0x000814224100,
	0x141414141400,
	0x004122140800,
	0x020159090600,
	0x3E415D594E00,
	0x7C1211127C00,
	0x7F4949493600,
	0x3E4141412200,
	0x7F4141413E00,
	0x7F4949494100,
	0x7F0909090100,
	0x3E4141517300,
	0x7F0808087F00,
	0x00417F410000,
	0x2040413F0100,
	0x7F0814224100,
	0x7F4040404000,
	0x7F021C027F00,
	0x7F0408107F00,
	0x3E4141413E00,
	0x7F0909090600,
	0x3E4151215E00,
	0x7F0919294600,
	0x264949493200,
	0x03017F010300,
	0x3F4040403F00,
	0x1F2040201F00,
	0x3F4038403F00,
	0x631408146300,
	0x030478040300,
	0x6159494D4300,
	0x007F41414100,
	0x020408102000,
	0x004141417F00,
	0x040201020400,
	0x404040404000,
	0x000307080000,
	0x205454784000,
	0x7F2844443800,
	0x384444442800,
	0x384444287F00,
	0x385454541800,
	0x00087E090200,
	0x18A4A49C7800,
	0x7F0804047800,
	0x00447D400000,
	0x2040403D0000,
	0x7F1028440000,
	0x00417F400000,
	0x7C0478047800,
	0x7C0804047800,
	0x384444443800,
	0xFC1824241800,
	0x18242418FC00,
	0x7C0804040800,
	0x485454542400,
	0x04043F442400,
	0x3C4040207C00,
	0x1C2040201C00,
	0x3C4030403C00,
	0x442810284400,
	0x4C9090907C00,
	0x4464544C4400,
	0x000836410000,
	0x000077000000,
	0x004136080000,
	0x020102040200,
	0x3C2623263C00
};

void writeCommand(unsigned long command){
  long j;
  gclearport=cd; //CD=0
  bport=command;
  gclearport=wr; //wr=0
  j=devid;
  gsetport=wr; //wr=1
}
void writeData(unsigned long databyte){ //write just the bottom 10 bits
  unsigned long j;
  gsetport=cd; //CD=0
  bport=databyte;
  gclearport=wr; //wr=0
  j=devid;
  gsetport=wr; //wr=1
}

void setxy(unsigned long xstart, unsigned long xend, unsigned long ystart, unsigned long yend){
    unsigned long j;
    writeCommand(0x2A);
    writeData(xstart>>8);
    writeData(xstart);
    writeData(xend>>8);
    writeData(xend);
    writeCommand(0x2B);
    writeData(ystart>>8);
    writeData(ystart);
    writeData(yend>>8);
    writeData(yend);
    writeCommand(0x2C);
      }
long long localfastfillrect(long colour,long long x,
    long long y, long long width,long long height, long long params[]){
    long long xstart,xend,ystart,yend;
    unsigned long i,j;
    unsigned long screenwidth=params[0];
    unsigned long screenheight=params[1];
    unsigned long rotation=params[2];
    if(rotation==0){
       xstart=x;
       if (xstart>=screenwidth)return 0; //nothing can be written
       xend=xstart+width-1;
       if (xend>=screenwidth)xend=screenwidth-1; //limit to screen dimensions
       ystart=y;
       if (ystart>=screenheight)return 0;
       yend=ystart+height-1;
       if (yend>=screenheight)xend=screenheight-1;
     }
     if(rotation==1){
       xend=screenwidth-x-1;
       if (xend<0) return 0; //nothing can be written
       xstart=xend-width+1;
       if(xstart<0) xstart=0;//limit to screen dimensions
       yend=screenheight-y-1;
       if (yend<0) return 0;
       ystart=yend-height+1;
       if(ystart<0)ystart=0;
     }
     if(rotation==2){
       xend=screenwidth-y-1;
       if (xend>=screenwidth)xend=screenwidth-1;
       xstart=xend-height+1;
       if(xstart<0) xstart=0;//limit to screen dimensions
       ystart=x;
       if (ystart>=screenheight)return 0; //nothing can be written
       yend=ystart+width-1;
       if (yend>=screenheight)yend=screenheight-1;
     }
      if(rotation==3){
        xstart=y;
        if (xstart>=screenwidth)return 0; //nothing can be written
        xend=xstart+height-1;
        if (xend>=screenwidth)xend=screenwidth-1; //limit to screen dimensions
        yend=screenheight-x-1;
        if (yend<0) return 0;
        ystart=yend-width+1;
        if(ystart<0)ystart=0;
      }
        i=xend-xstart+1;
        i*=(yend-ystart+1);
        writeCommand(0x44);
        setxy(xstart,xend,ystart,yend);
        bport=colour;
        gsetport=cd; //CD=1
        while (i--) {
          gclearport=wr; //wr=0
          j=devid;
          gsetport=wr; //wr=1
        }
        return 1;
}

long long localdrawPixel(long cl, long x,
   long y, long long params[]){
   long j,xp=x,yp=y;
   long width=params[0];
   long height=params[1];
   long rotation=params[2];
   if(rotation==1){
       xp=width-x-1;
       yp=height-y-1;
   }
   if(rotation==2){
       yp=x;
       xp=width-y-1;
    }
   if(rotation==3){
       yp=height-x-1;
       xp=y;
    }
    if ((xp<width) & (yp< height) & (xp>=0) & (yp>=0) ){
      setxy(xp,xp,yp,yp);
      gsetport=cd; //CD=1
      bport=cl;
      gclearport=wr; //wr=0
      j=devid;
      gsetport=wr; //wr=1
    }
    else return 0;
    return 1;
}
void swap(long *x, long *y){
    long temp;
    temp=*x;
    *x=*y;
    *y=temp;
}
void drawline(long long colour,long long xx0,long long yy0,
  long long xx1, long long yy1,long long params[]){
  long dx,dy,x0=xx0,y0=yy0,x1=xx1,y1=yy1,err,ystep,xstep,dp,temp,steep;
  long cl=colour;
// int steep=(abs(y1-y0))>(abs(x1-x0));
  if(y1>y0) ystep=y1-y0;
  else ystep=y0-y1;
  if(x1>x0) xstep=x1-x0;
  else xstep=x0-x1;
  steep=ystep>xstep;
  if (steep) {
    swap(&x0,&y0);
    swap(&x1,&y1);
  }
  if (x0>x1){
    swap(&x0,&x1);
    swap(&y0,&y1);
  }
  dx=x1-x0;
//  dy=abs(y1-y0);
  if(y1>y0) dy=y1-y0;
  else dy=y0-y1;
  err=dx / 2;
  if (y0<y1) {
    ystep=1;
  }
  else {
    ystep=-1;
  }
  while (x0<=x1){
    if (steep) {
      dp=localdrawPixel(cl,y0,x0,params);
    }
    else {
      dp=localdrawPixel(cl,x0,y0,params);
    }
    err=err-dy;
    if (err<0) {
      y0=y0+ystep;
      err=err+dx;
    }
    x0=x0+1;
  }
}
long long drawchar(long long thechar,long long colour,long long bcolour,long long xx,
    long long yy, long long size,long long or,long long params[]){
    unsigned long i,j,dp,x=xx,y=yy,sz=size,orientation=or;
    long cl=colour,bl=bcolour;
    union utype{
    unsigned long long b;
    unsigned long c[2];
    unsigned char a[8];
    }ch;
    ch.b=thechar; //get the character to be output
    if (orientation==0){ //normal
        for(i=0;i<=5;i++){
            for(j=0;j<=7;j++){
              if((ch.a[i]>>j)&1){
                  if(sz==1){
                     localdrawPixel(cl,x+5-i,y+j,params);
                   }
                   else{
                     dp=localfastfillrect(cl,x+(5-i)*sz,y+(j*sz),sz,sz,params);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(bl,x+5-i,y+j,params);
                   }
                   else{
                     dp=localfastfillrect(bl,x+(5-i)*sz,y+(j*sz),sz,sz,params);
                   }
              }
            }
        }

    }
    if (orientation==1){  //invert
       for(i=0;i<=5;i++){
            for(j=0;j<=7;j++){
              if(((ch.a[5-i])>>(7-j))&1){
                  if(sz==1){
                     localdrawPixel(cl,x-i,y+j-7,params);
                   }
                   else{
                    dp=localfastfillrect(cl,x-sz+1-(i*sz),y-sz+1-(7-j)*sz,sz,sz,params);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(bl,x-i,y+j-7,params);
                   }
                   else{
                     dp=localfastfillrect(bl,x-sz+1-(i*sz),y-sz+1-(7-j)*sz,sz,sz,params);
                   }
              }
            }
        }

    }   if (orientation==2){  //rotate right
       for(i=0;i<=7;i++){
            for(j=0;j<=5;j++){
              if((ch.a[5-j]>>i)&1){
                  if(sz==1){
                     localdrawPixel(cl,x-i,y+j,params);
                   }
                   else{
                     dp=localfastfillrect(cl,x-sz+1-i*sz,y+(j)*sz,sz,sz,params);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(bl,x-i,y+j,params);
                   }
                   else{
                     dp=localfastfillrect(bl,x-sz+1-i*sz,y+(j)*sz,sz,sz,params);
                   }
              }
            }
        }

    }
    if (orientation==3){  //rotate left
       for(i=0;i<=7;i++){
            for(j=0;j<=5;j++){
              if((ch.a[j]>>(7-i))&1){
                  if(sz==1){
                     localdrawPixel(cl,x-i+7,y+j-5,params);
                   }
                   else{
                     dp=localfastfillrect(cl,x-i*sz+7*sz,y+j*sz-6*sz+1,sz,sz,params);
                   }
              }
              else{
                   if(sz==1){
                      localdrawPixel(bl,x-i+7,y+j-5,params);
                   }
                   else{
                     dp=localfastfillrect(bl,x-i*sz+7*sz,y+j*sz-6*sz+1,sz,sz,params);
                   }
              }
            }
        }

    }
}
void nextchar(long *x, long *y, long sz, long orientation){
        if(orientation==0) *x=*x+(6*sz);
        if(orientation==1) *x=*x-(6*sz);
        if(orientation==2) *y=*y+(6*sz);
        if(orientation==3) *y=*y-(6*sz);
}
long testchar(long x, long y, long sz, long orientation, long long params[]){
        long wi=params[0],ht=params[1];
        if (params[2]>1){
            wi=params[1];
            ht=params[0];
        }
        if(orientation==0) x=x+(6*sz);
        if(orientation==1) x=x-(6*sz);
        if(orientation==2) y=y+(6*sz);
        if(orientation==3) y=y-(6*sz);
        if((x<0) || (y<0) || (x>wi) || y>ht){
            return 0;
        } else {
        return 1;
        }
}
long long pstring(long long afont,long long xx, long long yy,long long size,
        long long or, long long fc, long long bc,long long params[],unsigned char text[]){
    long x=xx,y=yy,sz=size,orientation=or,fontcolour=fc,backgroundcolour=bc,addroffont=afont;
    long *fonth,*fontl;
    long i;
    long long myreturn;
    union utype{
    unsigned long long b;
    unsigned long a[2];
    }mychr;
    if (text[0]){
      for(i=1;i<=(long)text[0];i++)
      {
        if (text[i]>=32 && text[i]<=127){
          fontl=(long*)(addroffont+(((long)text[i]-32)*8));
          fonth=fontl+1;
          mychr.a[0]=*fontl;
          mychr.a[1]=*fonth;
        } else {
          mychr.a[0]=0;
          mychr.a[1]=0;
        }
        if(testchar(x,y,sz,orientation,params)) { //Only write characters that will complete on the screen
            myreturn=drawchar(mychr.b,fontcolour,backgroundcolour, x, y, sz, orientation, params);
            nextchar(&x,&y,sz,orientation);
        }else{
            return 0;
        }
      }
    } else {
      myreturn=drawchar(afont,fontcolour,backgroundcolour, x, y, sz, orientation, params);
      nextchar(&x,&y,sz,orientation);
    }
    params[4]=x;
    params[5]=y;
    return myreturn;
}
long long dcirch( long long colour, long long xx0,
   long long yy0, long long rr,long long ccn, long long params[]){
   long r=rr, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp,x0=xx0,y0=yy0,cn=ccn;
   long cl=colour;
   if(cn&16){
     dp=localdrawPixel(cl, x0, y0+r,  params);
     dp=localdrawPixel(cl, x0, y0-r,  params);
     dp=localdrawPixel(cl, x0+r, y0,  params);
     dp=localdrawPixel(cl, x0-r, y0,  params);
   }
   while (x<y){
    if (f>=0){
      y=y-1;
      ddF_y=ddF_y+2;
      f=f+ddF_y;
    }
    x=x+1;
    ddF_x=ddF_x+2;
    f=f+ddF_x;
    if(cn&4){
      dp=localdrawPixel(cl, x0+x, y0+y,  params);
      dp=localdrawPixel(cl, x0+y, y0+x,  params);
    }
    if(cn&2){
      dp=localdrawPixel(cl, x0+x, y0-y,  params);
      dp=localdrawPixel(cl, x0+y, y0-x,  params);
    }
    if(cn&8){
      dp=localdrawPixel(cl, x0-y, y0+x,  params);
      dp=localdrawPixel(cl, x0-x, y0+y,  params);
    }
    if(cn&1){
      dp=localdrawPixel(cl, x0-y, y0-x,  params);
      dp=localdrawPixel(cl, x0-x, y0-y,  params);
     }
   }
}
void fcirch(long long xx0,long long yy0,long long rr,
  long long ccn, long long d,long long colour,long long params[]){
  long r=rr, dp, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r,x0=xx0,y0=yy0,cn=ccn,delta=d;
  while (x<y){
    if (f>=0) {
      y=y-1;
      ddF_y=ddF_y+2;
      f=f+ddF_y;
    }
    x=x+1;
    ddF_x=ddF_x+2;
    f=f+ddF_x;
    if (cn & 1) {
      dp=localfastfillrect(colour, x0+x, y0-y, 1, 2*y+1+delta, params) ;
      dp=localfastfillrect(colour, x0+y, y0-x, 1, 2*x+1+delta, params) ;
    }
    if (cn & 2) {
      dp=localfastfillrect(colour, x0-x, y0-y, 1, 2*y+1+delta,  params) ;
      dp=localfastfillrect(colour, x0-y, y0-x, 1, 2*x+1+delta,  params) ;
    }
  }
}
void ftri (long long xx0 , long long yy0, long long xx1,long long yy1, long long xx2, long long yy2, long long colour,long long params[]) {
  long a, b, y, dp, last,x0=xx0,y0=yy0,x1=xx1,y1=yy1,x2=xx2,y2=yy2;
  if (y0>y1) {
    swap(&y0, &y1);
    swap(&x0, &x1);
  }
  if (y1>y2) {
    swap(&y2, &y1);
    swap(&x2, &x1);
  }
  if (y0>y1) {
    swap(&y0, &y1);
    swap(&x0, &x1);
  }
  if(y0==y2) { // Handle awkward all-on-same-line case as its own thing
    a=x0;
    b=x0;
    if(x1<a) {
      a=x1;
    } else {
       if(x1>b) b=x1;
    }
    if(x2<a) {
      a=x2;
    } else {
      if(x2>b)  b=x2;
    }
    dp=localfastfillrect( colour, a, y0, 1, b-a+1,  params) ;
  } else {
    long  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0;
    if(y1==y2) {
      last=y1; //Include y1 scanline
    } else {
     last=y1-1; // Skip it
    }
    for (y=y0;y<=last;y++){
      a=x0+sa / dy01;
      b=x0+sb / dy02;
      sa=sa+dx01;
      sb=sb+dx02;
      a=x0+(x1-x0) * (y-y0) / (y1-y0);
      b=x0+(x2-x0) * (y-y0) / (y2-y0);
      if(a>b)swap(&a, &b);
      dp=localfastfillrect( colour, a, y, b-a+1, 1,  params) ;
     }
     sa=dx12 * (y-y1);
     sb=dx02 * (y-y0);
     while (y<=y2){
       a=x1+sa / dy12;
       b=x0+sb / dy02;
       sa=sa+dx12;
       sb=sb+dx02;
       a=x1+(x2-x1) * (y-y1) / (y2-y1);
       b=x0+(x2-x0) * (y-y0) / (y2-y0);
       if(a>b) swap(&a, &b);
       dp=localfastfillrect( colour, a, y, b-a+1, 1,  params) ;
       y=y+1;
     }
  }
}
long long main(long long *fn, long long *Arg1, long long *Arg2, long long *Arg3,
long long *Arg4, long long *Arg5,long long *Arg6, long long *Arg7,long long *Arg8, char *Arg9) {
    long long i;

    //Note 'if' statements are used rather than 'switch, case' because
    //'switch case' can generate 'peculiar' code resulting in JLR instructions
    //

    if (*fn==0x0){
        i=localdrawPixel((int)*Arg1,(int)*Arg2,(int)*Arg3,Arg4);
        return(i);
    }
    if (*fn==0x1){
        i=localfastfillrect((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,
                (long long)*Arg5,Arg6);
        return(i);
    }
    if (*fn==0x2){
        ftri((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,(long long)*Arg7,Arg8);
        return(*fn);
    }
    if (*fn==0x3){
        drawline((long long)*Arg1,(long long)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,Arg6);
        return(*fn);
    }
    if (*fn==0x4){
        writeCommand((long long)*Arg1);
        return(*fn);
    }
    if (*fn==0x5){
        writeData((long long)*Arg1);
        return(*fn);
    }
    if (*fn==0x7){
        i=pstring((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,(long long)*Arg7,Arg8,Arg9);
        return(i);
    }
    if (*fn==0x8){
        fcirch((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,Arg7);
        return(*fn);
    }
    if (*fn==0x9){
        dcirch((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,Arg6);
        return(*fn);
    }
}