'************************************************************************************* 
' 
' Peter Mather
' 
' 1.3 
' 2015-20-1 
' 
' Graphics library with drivers for SSD1983 display 
' 16 bit parallel outuput from Micromite 44-pin
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub T32.setrot(x) T32_normal=normal, T32_inverse=invert, T32_rt_right=rotate right, T32_rt_left=rotate left
' draw circle: sub T32.dcirc(x0, y0, r, colour) x, y coordinates of centre, radius, colour
' draw filled circle: sub T32.fcirc(x0, y0, r, colour) x, y coordinates of centre, radius, colour
' draw triangle:  sub T32.dtri(x0, y0, x1, y1, 	x2, y2, colour) three coordinate pairs, colour
' draw filled triangle sub T32.ftri (x0, y0, x1, y1, x2, y2, colour) three coordinate pairs, colour
' print string: sub T32.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' print 8x5 bitmap: sub T32.pbitmap(xx0, yy0, char, sz, orientation, forecolour, backcolour) x, y coordinates of top left of first character, bitmap, size, character orientation,  foreground colour,  background colour
' draw line: sub T32.dline(xx0, yy0, xx1, yy1, colour) x, y of start line, x, y of end line, colour
' draw rectangle: sub T32.drect(x, y, w, h, colour) x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub T32.frect(x, y, w, h, colour) x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub T32.drndrect(x, y, w, h, r, colour) x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub T32.frndrect(x, y, w, h, r, colour) x, y coordinates of top left, width, height, radius of corner, colour
'
option explicit
option default NONE
cpu 96
  print "start Init"
  T32.initdisplay
  print "Start main"
Do
   T32_test
loop

end
'
' 
 specific routines
'
sub T32.initdisplay
'Fixed Pins
  setpin 25,dout 'b0 - connect to D0
  setpin 24,dout 'b1 - connect to D1
  setpin 23,dout 'b2 - connect to D2
  setpin 22,dout 'b3 - connect to D3
  setpin 21,dout 'b4 - connect to D4
  setpin 20,dout 'b5 - connect to D5
  setpin 26,dout 'b6 - connect to D6
  setpin 27,dout 'b7 - connect to D7
  setpin 32,dout 'b8 - connect to D8
  setpin 33,dout 'b9 - connect to D9
  setpin 34,dout 'b10 - connect to D10
  setpin 35,dout 'b11 - connect to D11
  setpin 41,dout 'b12 - connect to D12
  setpin 42,dout 'b13 - connect to D13
  setpin 43,dout 'b14 - connect to D14
  setpin 44,dout 'b15 - connect to D15
  dim integer T32_WR=90 'g0
  dim integer T32_CD=89 'g1
' Connect RD to VCC
' Connect CS to GND
'
'Flexible pins
  DIM integer Master_reset=18 ' connect to reset pin display
'
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer T32.pix=0
  dim integer T32.ffr=1
  dim integer T32.filltri=2
  dim integer T32.drawline=3
  dim integer T32.writecommand=4
  dim integer T32.writedata=5
  dim integer T32.fpstring=7
  dim integer T32.fcirch=8
  dim integer T32.dcirch=9
  dim integer T32_normal=0
  dim integer T32_inverse=1
  dim integer T32_rt_right=2
  dim integer T32_rt_left=3
  ' Global variables
  dim integer T32_AddrOfFont,   T32_params(6) ' Global variables
  DIM integer T32_wi=0,T32_ht=1,T32_rot=2,T32_nr=3,T32_X=4,T32_Y=5,T32_seed=6
  T32_AddrOfFont=PEEK(CFunAddr FONT)  
  local integer i,j,k
  T32_params(T32_wi)=800
  T32_params(T32_ht)=480
  pin(T32_CD)=1
  setpin T32_CD, DOUT
  pin(T32_WR)=1
  setpin T32_WR, DOUT
  pin(Master_RESET)=1
  setpin Master_RESET, DOUT'  
  pin(Master_RESET)=0
  pause 100
  pin(Master_RESET)=1
  pause 100
	i=T32draw(T32.writecommand, &HE2)		'PLL multiplier, set PLL clock to 120M
	i=T32draw(T32.writedata, &H1E)	    'N=&H36 for 6.5M, &H23 for 10M crystal
	i=T32draw(T32.writedata, &H02)
	i=T32draw(T32.writedata, &H54)
	i=T32draw(T32.writecommand, &HE0)		' PLL enable
	i=T32draw(T32.writedata, &H01)
	pause 10)
	i=T32draw(T32.writecommand, &HE0)
	i=T32draw(T32.writedata, &H03)
	pause 10)
	i=T32draw(T32.writecommand, &H01)		' software reset
	pause 100)
	i=T32draw(T32.writecommand, &HE6)		'PLL setting for PCLK, depends on resolution
	i=T32draw(T32.writedata, &H03)
	i=T32draw(T32.writedata, &HFF)
	i=T32draw(T32.writedata, &HFF)

	i=T32draw(T32.writecommand, &HB0)		'LCD SPECIFICATION
	i=T32draw(T32.writedata, &H24)
	i=T32draw(T32.writedata, &H00)
	i=T32draw(T32.writedata, &H03)		'Set HDP	799
	i=T32draw(T32.writedata, &H1F)
	i=T32draw(T32.writedata, &H01)		'Set VDP	479
	i=T32draw(T32.writedata, &HDF)
	i=T32draw(T32.writedata, &H00)

	i=T32draw(T32.writecommand, &HB4)		'HSYNC
	i=T32draw(T32.writedata, &H03)		'Set HT	928
	i=T32draw(T32.writedata, &HA0)
	i=T32draw(T32.writedata, &H00)		'Set HPS	46
	i=T32draw(T32.writedata, &H2E)
	i=T32draw(T32.writedata, &H30)		'Set HPW	48
	i=T32draw(T32.writedata, &H00)		'Set LPS	15
	i=T32draw(T32.writedata, &H0F)
	i=T32draw(T32.writedata, &H00)

	i=T32draw(T32.writecommand, &HB6)		'VSYNC
	i=T32draw(T32.writedata, &H02)		'Set VT	525
	i=T32draw(T32.writedata, &H0D)
	i=T32draw(T32.writedata, &H00)		'Set VPS	16
	i=T32draw(T32.writedata, &H10)
	i=T32draw(T32.writedata, &H10)		'Set VPW	16
	i=T32draw(T32.writedata, &H00)		'Set FPS	8
	i=T32draw(T32.writedata, &H08)

	i=T32draw(T32.writecommand, &HBA)
	i=T32draw(T32.writedata, &H0F)		'GPIO[3:0] out 1

	i=T32draw(T32.writecommand, &HB8)
	i=T32draw(T32.writedata, &H07)	    'GPIO3=input, GPIO[2:0]=output
	i=T32draw(T32.writedata, &H01)		'GPIO0 normal

	i=T32draw(T32.writecommand, &H36)		'rotation
	i=T32draw(T32.writedata, &B00000011)

	i=T32draw(T32.writecommand, &HF0)		'pixel data interface
	i=T32draw(T32.writedata, &H03)
	i=T32draw(T32.writecommand, &H3A)		'pixel data interface
	i=T32draw(T32.writedata, &B01010000)
	i=T32draw(T32.writecommand, &H26)		'gamma curve
	i=T32draw(T32.writedata, &B00000001)


	pause 1

'	setXY(0, 0, 799, 479)
	i=T32draw(T32.writecommand, &H29)		'display on

	i=T32draw(T32.writecommand, &HBE)		'set PWM for B/L
	i=T32draw(T32.writedata, &H06)
	i=T32draw(T32.writedata, &Hf0)
	i=T32draw(T32.writedata, &H01)
	i=T32draw(T32.writedata, &Hf0)
	i=T32draw(T32.writedata, &H00)
	i=T32draw(T32.writedata, &H00)

	i=T32draw(T32.writecommand, &Hd0) 
	i=T32draw(T32.writedata, &H0d)	

	i=T32draw(T32.writecommand, &H2C) 
end sub
'
sub T32.wreg(register as integer, databyte as integer)
  local integer i
  i=T32draw(T32.writecommand, register)
  i=T32draw(T32.writedata, databyte)
end sub
'
sub T32.fillscreen(scol as integer)
  local integer i=T32_params(T32_rot)
  T32_params(T32_rot)=0
  local integer j=T32draw(T32.ffr,scol, 0,0,T32_params(T32_wi),T32_params(T32_ht), T32_params())
  T32_params(T32_rot)=i
end sub
'
' Generic drawing routines
'
sub T32.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=T32draw(T32.dcirch, colour,x0,y0,r,31,T32_params())

end sub
 '
sub T32.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  T32.dline(x0, y0, x1, y1, colour)
  T32.dline(x1, y1, x2, y2, colour)
  T32.dline(x2, y2, x0, y0, colour)
end sub
 '
sub T32.ftri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer i=T32draw(T32.filltri, x0,y0,x1,y1,x2,y2,colour,T32_params())
end sub
'
sub T32.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T32draw(T32.fpstring,T32_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T32_params(),text$)
end sub
'
sub T32.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T32draw(T32.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T32_params(),"")
end sub
'
sub T32.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=T32draw(T32.drawline, colour, xx0, yy0, xx1, yy1,  T32_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub T32.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=T32draw(T32.ffr, rcolour, x, y, w, 1,  T32_params()) 
  a=y+h-1
  dp=T32draw(T32.ffr, rcolour, x, a, w, 1,  T32_params()) 
  dp=T32draw(T32.ffr, rcolour, x, y, 1, h,  T32_params()) 
  a=x+w-1
  dp=T32draw(T32.ffr, rcolour, a, y, 1, h,  T32_params()) 
end sub
'
sub T32.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=T32draw(T32.ffr, rcolour, x, y, w, h,  T32_params()) 
end sub
'
FUNCTION T32.Getchar(char as integer) as integer
  local integer i=char<<3
  T32.Getchar=PEEK(WORD T32_AddrOfFont+i)+(PEEK(WORD T32_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub T32.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=T32draw(T32.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T32_params())
  dp=T32draw(T32.fcircH,x0, y0, r, 3, 0, ccolour, T32_params())
end sub
 '
sub T32.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T32draw(T32.ffr, rcolour, x+r, y, w-2*r, 1,  T32_params()) 
  dp=T32draw(T32.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T32_params()) 
  dp=T32draw(T32.ffr, rcolour, x, y+r, 1, h-2*r,  T32_params()) 
  dp=T32draw(T32.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T32_params()) 
  dp=T32draw(T32.dcirch, rcolour, x+r, y+r, r, 1,T32_params())
  dp=T32draw(T32.dcirch,  rcolour, x+w-r-1, y+r, r, 2,T32_params())
  dp=T32draw(T32.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,T32_params())
  dp=T32draw(T32.dcirch,  rcolour, x+r, y+h-r-1, r, 8,T32_params())
end sub
'
sub T32.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T32draw(T32.ffr, colour, x+r, y, w-2*r, h,  T32_params()) 
  dp=T32draw(T32.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, T32_params())
  dp=T32draw(T32.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, T32_params())
end sub
 '
sub T32.setrot(x%) 'sets screen rotation: 0=T32_normal, 1=invert, 2=rotate right, 3-rotate left
   T32_params(T32_rot)=(x% and 3)
end sub
'
'C:\Users\Peter\Dropbox\MPLABXProjects\ssd1963\dist\default\production\T32draw.bas

'
'T32draw  2015-02-20 18:00:09 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction T32draw
'writeCommand
	000006C9
	3c02bf88 24030002 ac436634 ac446130 24030001 ac436634 3c04bf81 8c84f220 
	ac436638 03e00008 00000000 

'writeData
3c02bf88 24030002 ac436638 ac446130 24030001 
	ac436634 3c04bf81 8c84f220 ac436638 03e00008 00000000 

'setxy
27bdffd8 afbf0024 
	afb30020 afb2001c afb10018 afb00014 00808821 00a09021 00c09821 00e08021 
	2404002a 0411FFDE 00000000 00112202 0411FFE6 00000000 02202021 0411FFE3 
	00000000 00122202 0411FFE0 00000000 02402021 0411FFDD 00000000 2404002b 
	0411FFCF 00000000 00132202 0411FFD7 00000000 02602021 0411FFD4 00000000 
	00102202 0411FFD1 00000000 02002021 0411FFCE 00000000 2404002c 0411FFC0 
	00000000 8fbf0024 8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 27bd0028 

'localfastfillrect
	27bdffc8 afbf0034 afb70030 afb6002c afb50028 afb40024 afb30020 afb2001c 
	afb10018 afb00014 00808021 8fa80048 8fa5004c 8faa0050 8fab0054 8fac0058 
	8fad005c 8fa20060 8c490000 8c440010 1480002d 8c4e0008 04e00005 0000c021 
	170700d4 00c9102b 504000d3 00002021 24c2ffff 0046782b 24e3ffff 01e37821 
	004a1821 0062102b 01eb7821 004f1021 04400006 00608821 57020004 2531ffff 
	0069182b 50600001 2531ffff 04a00005 00007821 15e500c2 010e102b 504000c1 
	00002021 2502ffff 0048c02b 24a3ffff 0303c021 004c1821 0062102b 030dc021 
	00581021 044000d7 00609021 55e200d5 25d1ffff 006e182b 546000d3 0100b021 
	100000d0 25d1ffff 24020001 54820026 24020002 00063027 00073827 00c94821 
	0126302b 00c73021 04c000a8 01208821 00084027 00052827 010e7021 01c8402b 
	01054021 050000a4 01c09021 24040001 008a5023 008a202b 00c43023 01494821 
	012a502b 00cb5823 014b1021 04410002 0120a021 0000a021 24020001 004c6023 
	004c102b 01024023 018e7021 01cc602b 010d6823 018d1821 04610065 01c0b021 
	10000063 0000b021 14820033 00087827 0005c027 01e91021 004f182b 00781821 
	00408821 04600008 00607821 54600005 2531ffff 0049102b 14400004 24020001 
	2531ffff 00007821 24020001 004cc023 0058102b 01e27823 03119021 0258c02b 
	01ed7823 030f1821 04610002 0240a021 0000a021 04e00005 00007821 15e70071 
	00ce102b 50400070 00002021 24c2ffff 0046c02b 24e3ffff 0303c021 004a1821 
	0062102b 030bc021 00581021 04400009 00609021 55e20005 25d2ffff 006e182b 
	54600005 00c0b021 25d2ffff 10000002 00c0b021 00c0b021 24020003 1482002d 
	26330001 04a00005 00001821 14650058 0109102b 10400057 00002021 2502ffff 
	0048782b 24a4ffff 01e42021 004c6021 0182102b 008d6821 004d1021 04400007 
	01808821 54620005 2531ffff 0189602b 55800003 00063027 2531ffff 00063027 
	00073827 00ce7021 01c6302b 00c73021 04c00042 01c09021 24020001 004a5023 
	004a102b 00c23023 014e7021 01ca502b 00cb5823 014b1821 04600003 01c0b021 
	10000003 0100a021 0100a021 0000b021 26330001 02749823 26420001 00561023 
	72629802 24040044 0411FEE5 00000000 02802021 02202821 02c03021 02403821 
	0411FEF5 00000000 3c02bf88 ac506130 24030002 ac436638 12600023 2673ffff 
	3c03bf88 24020001 3c05bf81 2404ffff ac626634 8ca6f220 ac626638 2673ffff 
	1664fffb 00000000 24040001 10000018 00002821 00002021 10000015 00002821 
	00002021 10000012 00002821 00002021 1000000f 00002821 00002021 1000000c 
	00002821 00002021 10000009 00002821 00002021 10000006 00002821 00002021 
	10000003 00002821 24040001 00002821 00801021 00a01821 8fbf0034 8fb70030 
	8fb6002c 8fb50028 8fb40024 8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 
	27bd0038 0100b021 1000ff8b 00c0a021 

'localdrawPixel
27bdffe8 afbf0014 afb00010 00808021 
	8ce40000 8ce30008 8ce20010 24070001 54470006 24070002 00052827 00a41021 
	00063827 1000000e 00e33821 54470005 24070003 00061027 00441021 10000008 
	00a03821 14470004 00053827 00e33821 10000003 00c01021 00c03821 00a01021 
	00472827 00052fc2 0044202a 00e3182a 00831824 00a31824 50600012 00002021 
	00402021 00402821 00e03021 0411FE92 00000000 3c02bf88 24030002 ac436638 
	ac506130 24030001 ac436634 3c04bf81 8c84f220 ac436638 24040001 10000002 
	00002821 00002821 00801021 00a01821 8fbf0014 8fb00010 03e00008 27bd0018 

'swap
	8c820000 8ca30000 ac830000 03e00008 aca20000 

'drawline
27bdffc0 afbf003c afb60038 
	afb50034 afb40030 afb3002c afb20028 afb10024 afb00020 8fb10050 8fa20058 
	8fa30060 8fb40068 afa60010 afb10014 afa20018 00809821 0223202a 10800003 
	afa3001c 10000002 00718823 02238823 00c2182a 50600002 00c21023 00461023 
	0051882a 1220000a 8fa20018 27a40010 27a50014 0411FFDA 00000000 27a40018 
	27a5001c 0411FFD6 00000000 8fa20018 8fa30010 0043102a 1040000a 8fa20018 
	27a40010 27a50018 0411FFCD 00000000 27a40014 27a5001c 0411FFC9 00000000 
	8fa20018 8fa60010 8fa3001c 8fb20014 0243202a 10800007 0046a823 00729023 
	001587c2 02158021 00108043 10000006 24160001 02439023 001587c2 02158021 
	00108043 2416ffff 0046102a 1440001c 8fbf003c 12200007 02602021 8fa50014 
	02803821 0411FF72 00000000 10000007 02128023 00c02821 8fa60014 02803821 
	0411FF6B 00000000 02128023 06010006 8fa60010 8fa20014 00561021 afa20014 
	02158021 8fa60010 24c60001 afa60010 8fa20018 0046102a 1040ffe6 8fbf003c 
	8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028 8fb10024 8fb00020 03e00008 
	27bd0040 

'drawchar
27bdff68 afbf0094 afbe0090 afb7008c afb60088 afb50084 afb40080 
	afb3007c afb20078 afb10074 afb00070 8fa200b0 afa20048 8fa300b8 afa30050 
	8fa200c0 afa2005c 8fb400d0 afa30058 00408021 8fa300c8 afa3004c 00c0f021 
	8fb700a8 afa40030 14600057 afa50034 00022823 afa50054 00021080 00501021 
	8fa50048 00a21021 afa20044 24a20005 afa20040 27b60030 27a30036 afa30038 
	10000043 00009021 92c20000 02221007 30420001 10400019 24020001 24050001 
	56050009 afb30010 03c02021 8fa50040 02a03021 02803821 0411FF1D 00000000 
	10000024 26310001 afb20014 afb00018 afb2001c afb00020 afb20024 afb40028 
	03c02021 8fa6003c 02403821 0411FDFC 00000000 10000017 26310001 56020009 
	afb30010 02e02021 8fa50040 02a03021 02803821 0411FF06 00000000 1000000d 
	26310001 afb20014 afb00018 afb2001c afb00020 afb20024 afb40028 02e02021 
	8fa6003c 02403821 0411FDE5 00000000 26310001 02709821 24030008 1623ffca 
	26b50001 8fa50044 8fa20054 00a22821 afa50044 8fa30040 2463ffff afa30040 
	26d60001 8fa50038 12c5006e 24020002 8fa20044 afa2003c 8fb50050 8fb30058 
	1000ffb9 02408821 24020001 8fa3004c 14620064 24020002 8fa5005c 00052823 
	afa50054 8fa30048 24620001 8fa5005c 00451023 afa20044 2462fffa afa20060 
	afa30040 00009021 8fa50058 00b01823 24630001 001010c0 00501023 00621023 
	afa20064 27a20030 8fa30048 00431023 10000042 afa20068 92c20005 02221007 
	30420001 10400019 24020001 24050001 56050009 afb30010 03c02021 8fa50040 
	02a03021 02803821 0411FEB9 00000000 10000024 2631ffff afb20014 afb00018 
	afb2001c afb00020 afb20024 afb40028 03c02021 8fa6003c 02403821 0411FD98 
	00000000 10000017 2631ffff 56020009 afb30010 02e02021 8fa50040 02a03021 
	02803821 0411FEA2 00000000 1000000d 2631ffff afb20014 afb00018 afb2001c 
	afb00020 afb20024 afb40028 02e02021 8fa6003c 02403821 0411FD81 00000000 
	2631ffff 02709821 2403ffff 1623ffca 26b50001 8fa50044 8fa20054 00a22821 
	afa50044 8fa30040 2463ffff afa30040 8fa50060 10650069 24020003 8fa20044 
	afa2003c 8fb30064 8fa30058 2475fff9 24110007 8fa50068 8fa20040 1000ffb6 
	00a2b021 8fa3004c 1462005c 24020003 8fa5005c 00052823 afa50054 8fa30048 
	24620001 8fa5005c 00451023 afa2004c afa00044 24160001 00009021 27a2002f 
	10000045 afa20038 92220000 8fa3003c 00621024 10400018 00000000 56160009 
	afb30010 03c02021 8fa50048 02a03021 02803821 0411FE5E 00000000 10000024 
	2631ffff afb20014 afb00018 afb2001c afb00020 afb20024 afb40028 03c02021 
	8fa60040 02403821 0411FD3D 00000000 10000017 2631ffff 56160009 afb30010 
	02e02021 8fa50048 02a03021 02803821 0411FE47 00000000 1000000d 2631ffff 
	afb20014 afb00018 afb2001c afb00020 afb20024 afb40028 02e02021 8fa60040 
	02403821 0411FD26 00000000 2631ffff 02709821 8fa50038 1625ffcb 26b50001 
	8fa20044 24420001 afa20044 8fa3004c 8fa50054 00651821 afa3004c 8fa20048 
	2442ffff afa20048 8fa30044 24050008 10650075 8fbf0094 8fa20044 00561004 
	afa2003c 8fa3004c afa30040 27b10035 8fb50050 1000ffb4 8fb30058 8fa5004c 
	14a20068 8fa5005c 8fa20050 24440001 00051840 000510c0 00431823 00831823 
	afa3004c 00051823 afa30054 00451023 8fa50048 00a21021 afa20050 24a20007 
	afa20044 24030007 afa30048 00009021 27a50036 10000047 afa50038 92220000 
	8fa3003c 00621024 10400019 24020001 24050001 56050009 afb50010 03c02021 
	8fa50044 02c03021 02803821 0411FDF8 00000000 10000024 26310001 afb20014 
	afb00018 afb2001c afb00020 afb20024 afb40028 03c02021 8fa60040 02403821 
	0411FCD7 00000000 10000017 26310001 56020009 afb30010 02e02021 8fa50044 
	02c03021 02803821 0411FDE1 00000000 1000000d 26310001 afb20014 afb00018 
	afb2001c afb00020 afb20024 afb40028 02e02021 8fa60040 02403821 0411FCC0 
	00000000 26310001 02b0a821 26d60001 8fa30038 1623ffc9 02709821 8fa50048 
	24a5ffff afa50048 8fa20050 8fa30054 00431021 afa20050 8fa50044 24a5ffff 
	afa50044 8fa20048 2403ffff 1043000e 8fbf0094 24050001 8fa20048 00452804 
	afa5003c 8fa30050 afa30040 27b10030 8fa50058 24b6fffb 8fb3004c 1000ffaf 
	0260a821 8fbf0094 8fbe0090 8fb7008c 8fb60088 8fb50084 8fb40080 8fb3007c 
	8fb20078 8fb10074 8fb00070 03e00008 27bd0098 

'nextchar
14e00008 24020001 00061040 
	000618c0 00621023 8c830000 00621021 10000012 ac820000 14e20007 00061040 
	000630c0 00463023 8c820000 00463021 03e00008 ac860000 24020002 14e20007 
	00061040 000630c0 00c23023 8ca20000 00463021 03e00008 aca60000 24020003 
	14e20006 00061040 000630c0 00463023 8ca20000 00463021 aca60000 03e00008 
	00000000 

'testchar
8fa30010 8c680000 8c690014 1d200007 8c620008 15200008 00000000 
	8c630010 2c630002 14600004 00000000 01001821 00404021 00601021 14e00006 
	24030001 00061840 000648c0 01231823 1000000e 00832021 14e30005 00061840 
	000630c0 00663023 1000000e 00862021 24030002 14e30005 00061840 000630c0 
	00c33023 10000007 00a62821 24030003 14e30004 00061840 000630c0 00663023 
	00a62821 0482000a 00001021 04a00006 0104202a 54800006 00001021 0045102a 
	03e00008 38420001 03e00008 00001021 03e00008 00000000 

'pstring
27bdff70 afbf008c 
	afbe0088 afb70084 afb60080 afb5007c afb40078 afb30074 afb20070 afb1006c 
	afb00068 8fa300a0 8fb000a8 8fb300b0 8fa700b8 8fa800c0 8fb500c8 8fb600cc 
	afa60040 afa30044 02008821 02609021 00e0b821 afa40060 92c20000 10400049 
	0100f021 18400063 24100001 000717c3 afa20050 00081fc3 afa30054 001117c3 
	afa20058 00131fc3 afa3005c 02d01021 90420000 2443ffe0 306300ff 2c630060 
	50600008 00009821 2442ffe0 000210c0 8fa30060 00431021 8c530000 10000002 
	8c540004 0000a021 afb50010 8fa40040 8fa50044 02203021 02403821 0411FF91 
	00000000 1040004c 02602021 afbe0010 8fa20054 afa20014 8fa20040 afa20018 
	000217c3 afa2001c 8fa20044 afa20020 000217c3 afa20024 afb10028 8fa30058 
	afa3002c afb20030 8fa2005c afa20034 afb50038 02802821 02e03021 8fa70050 
	0411FDA8 00000000 afa20048 afa3004c 27a40040 27a50044 02203021 02403821 
	0411FF4C 00000000 26100001 92c20000 0050102a 5040ffc6 02d01021 1000001e 
	8fa20040 afa80010 000847c3 afa80014 afa60018 000637c3 afa6001c afa30020 
	00031fc3 afa30024 afb00028 001017c3 afa2002c afb30030 001317c3 afa20034 
	afb50038 00e03021 00073fc3 0411FD85 00000000 afa20048 afa3004c 27a40040 
	27a50044 02003021 02603821 0411FF29 00000000 8fa20040 aea20020 000217c3 
	aea20024 8fa20044 aea20028 000217c3 10000005 aea2002c 00001021 00001821 
	afa20048 afa3004c 8fa20048 8fa3004c 8fbf008c 8fbe0088 8fb70084 8fb60080 
	8fb5007c 8fb40078 8fb30074 8fb20070 8fb1006c 8fb00068 03e00008 27bd0090 

'dcirch
	27bdffa8 afbf0054 afbe0050 afb7004c afb60048 afb50044 afb40040 afb3003c 
	afb20038 afb10034 afb00030 00808021 00c0b021 8fb50068 8fb20070 8fa20078 
	8fb70080 02408821 afa60018 afb5001c afa20014 30420010 10400018 0080f021 
	00c02821 02553021 02e03821 0411FC98 00000000 02002021 02c02821 02b23023 
	02e03821 0411FC92 00000000 02002021 02562821 02a03021 02e03821 0411FC8C 
	00000000 02002021 02d22823 02a03021 02e03821 0411FC86 00000000 1a20006b 
	24110001 02328823 00121023 00021040 afa20010 26b3ffff 26d4ffff 26b50001 
	26d60001 02408021 00009021 8fa20014 30420004 afa20020 8fa20014 30420002 
	afa20024 8fa20014 30420008 afa20028 8fa20014 30420001 afa20014 06200005 
	8fa20010 2610ffff 24420002 afa20010 02228821 8fa20020 1040000f 26520001 
	03c02021 02c02821 8fa2001c 02023021 02e03821 0411FC5E 00000000 03c02021 
	8fa20018 02022821 02a03021 02e03821 0411FC57 00000000 8fa20024 10400010 
	8fa20028 03c02021 02c02821 8fa2001c 00503023 02e03821 0411FC4D 00000000 
	03c02021 8fa20018 02022821 02603021 02e03821 0411FC46 00000000 8fa20028 
	10400010 8fa20014 03c02021 8fa20018 00502823 02a03021 02e03821 0411FC3C 
	00000000 03c02021 02802821 8fa2001c 02023021 02e03821 0411FC35 00000000 
	8fa20014 50400010 2673ffff 03c02021 8fa20018 00502823 02603021 02e03821 
	0411FC2B 00000000 03c02021 02802821 8fa2001c 00503023 02e03821 0411FC24 
	00000000 2673ffff 2694ffff 26b50001 0250102a 10400005 26d60001 00121040 
	24420001 1000ffad 02228821 8fbf0054 8fbe0050 8fb7004c 8fb60048 8fb50044 
	8fb40040 8fb3003c 8fb20038 8fb10034 8fb00030 03e00008 27bd0058 

'fcirch
27bdff90 
	afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 afb30054 afb20050 
	afb1004c afb00048 8fb10080 8fb40090 8fbe0098 afa40038 afa6003c 8fa20088 
	1a200076 02801821 24100001 02118023 0011b823 0017b840 2495ffff 24d3ffff 
	26940003 24960001 00009021 30440001 afa40030 24630001 afa30040 30420002 
	afa20034 06000004 8fa20030 2631ffff 26f70002 02178021 1040002a 26520001 
	8fa3003c 00711023 afa20010 000217c3 afa20014 24020001 00001821 afa20018 
	afa3001c 00111040 8fa30040 00621021 afa20020 000217c3 afa20024 8fa400a0 
	afa40028 03c02021 02c03021 00163fc3 0411FABB 00000000 8fa20038 02223821 
	afb30010 001317c3 afa20014 24020001 00001821 afa20018 afa3001c afb40020 
	001417c3 afa20024 8fa300a0 afa30028 03c02021 00e03021 00073fc3 0411FAA8 
	00000000 8fa40034 5080002b 26b5ffff 8fa3003c 00711023 afa20010 000217c3 
	afa20014 24020001 00001821 afa20018 afa3001c 00111040 8fa30040 00621021 
	afa20020 000217c3 afa20024 8fa400a0 afa40028 03c02021 02a03021 00153fc3 
	0411FA8F 00000000 8fa20038 00513823 afb30010 001317c3 afa20014 24020001 
	00001821 afa20018 afa3001c afb40020 001417c3 afa20024 8fa300a0 afa30028 
	03c02021 00e03021 00073fc3 0411FA7C 00000000 26b5ffff 2673ffff 26940002 
	0251102a 10400005 26d60001 00121040 24420001 1000ff9b 02028021 8fbf006c 
	8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 
	8fb00048 03e00008 27bd0070 

'ftri
27bdff90 afbf006c afb50068 afb40064 afb30060 
	afb2005c afb10058 afb00054 8fa20088 8fb100a0 8fb200a8 afa40038 afa6003c 
	8fa30080 afa30040 afa20044 8fa30090 afa30048 8fa30098 0046102a 10400009 
	afa3004c 27a4003c 27a50044 0411FB9C 00000000 27a40038 27a50040 0411FB98 
	00000000 8fa2004c 8fa30044 0043102a 1040000a 8fa20044 27a4004c 27a50044 
	0411FB8F 00000000 27a40048 27a50040 0411FB8B 00000000 8fa20044 8fa3003c 
	0043102a 1040000a 8fb0003c 27a4003c 27a50044 0411FB82 00000000 27a40038 
	27a50040 0411FB7E 00000000 8fb0003c 8fa2004c 1602002d 8fb30044 8fa20038 
	afa20030 afa20034 8fa30040 0062202a 10800003 0043102a 10000003 afa30030 
	54400001 afa30034 8fa20048 8fa30030 0043182a 10600003 8fa30034 10000004 
	afa20030 0062182a 54600001 afa20034 8fa70030 8fa2003c afa20010 000217c3 
	afa20014 24020001 00001821 afa20018 afa3001c 8fa20034 24420001 00471023 
	afa20020 000217c3 afa20024 afb20028 02202021 00e03021 00073fc3 0411FA00 
	00000000 10000077 8fbf006c 

'.LBB2
2663ffff 00531026 0062980b 0270102a 14400036 
	24140001 0000a821 8fa20038 8fa3003c 02032823 8fa60040 00c23023 70a63002 
	8fa40044 00832023 00c4001a 008001f4 00002012 00822021 afa40030 8fa60048 
	00c23023 70a62802 8fa6004c 00c31823 00a3001a 006001f4 00001812 00621021 
	afa20034 0044102a 10400006 8fa70030 27a40030 27a50034 0411FB29 00000000 
	8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 00471023 afa20018 
	000217c3 afa2001c afb40020 afb50024 afb20028 02202021 00e03021 00073fc3 
	0411F9C7 00000000 26100001 0270102a 1040ffce 8fa20038 8fa2004c 0050182a 
	14600037 24140001 0000a821 8fa60040 8fa40038 8fa50048 8fa80044 02083823 
	00a61823 70e33802 00484023 00e8001a 010001f4 00001812 00661821 afa30030 
	8fa7003c 02073023 00a42823 70c53002 00471023 00c2001a 004001f4 00001012 
	00442021 afa40034 0083202a 10800006 8fa70030 27a40030 27a50034 0411FAF0 
	00000000 8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 00471023 
	afa20018 000217c3 afa2001c afb40020 afb50024 afb20028 02202021 00e03021 
	00073fc3 0411F98E 00000000 26100001 8fa2004c 0050182a 1060ffcd 8fa60040 

'.LBE2
	8fbf006c 8fb50068 8fb40064 8fb30060 8fb2005c 8fb10058 8fb00054 03e00008 
	27bd0070 

'main
27bdffb8 afbf0044 afb00040 00808021 00e01021 8fa90058 8faa005c 
	8fa80060 8fac0064 8c830000 8c840004 00643825 14e00009 8fab0068 8ca40000 
	8cc50000 8c460000 01203821 0411FA80 00000000 100000c5 8fbf0044 24070001 
	14670017 24070002 14800015 00000000 8ca40000 8cc70004 8cc60000 8c430004 
	8c420000 afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 8d420000 
	8d430004 afa20020 afa30024 afa80028 0411F953 00000000 100000ac 8fbf0044 
	14670021 24070003 1480001f 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 
	8d420000 8d430004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 
	8d820000 8d830004 afa20030 afa30034 afab0038 0411FECD 00000000 8e020000 
	10000089 8e030004 14670019 24070004 14800017 00000000 8ca40000 8ca50004 
	8cc70004 8cc60000 8c420000 afa20010 000217c3 afa20014 8d220000 afa20018 
	000217c3 afa2001c 8d420000 afa20020 000217c3 afa20024 afa80028 0411FA6D 
	00000000 8e020000 1000006f 8e030004 14670009 24070005 14800007 00000000 
	8ca40000 0411F8C6 00000000 8e020000 10000065 8e030004 14670009 24070007 
	14800007 00000000 8ca40000 0411F8C7 00000000 8e020000 1000005b 8e030004 
	14670022 24070008 14800020 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 
	8d420000 8d430004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 
	8d820000 8d830004 afa20030 afa30034 afab0038 8fa2006c afa2003c 0411FCA6 
	00000000 10000039 8fbf0044 1467001d 24070009 1480001b 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d220000 
	8d230004 afa20018 afa3001c 8d420000 8d430004 afa20020 afa30024 8d020000 
	8d030004 afa20028 afa3002c afac0030 0411FDCA 00000000 8e020000 1000001a 
	8e030004 14670019 8fbf0044 54800018 8fb00040 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d220000 8d230004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 afa80028 0411FD09 00000000 
	8e020000 8e030004 8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
'
sub T32_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  T32.setrot(0)
  wi= T32_params(0)
  ht= T32_params(1)
  T32.fillscreen(black)
  T32.drect(0, 0, wi, ht, red)
  T32.pbitmap(wi/2-12, 10, &HFF81818181FF, 4, 0, magenta, black)
  T32.pstring(wi/12-156, 40, "Welcome to the", 4, 0, green, black)

  T32.pstring(wi/2-288, 150, "Micromite MKII++", 6, 0, red, black)

  T32.pstring(wi/2-81, 250, "in colour", 3, 0, yellow, black)
  T32.pstring(wi/2-204, 350,  "16-bit parallel SSD1963 controller", 2, 0, cyan, black)

 pause 4000
' demo fast line draw
  T32.setrot(T32_normal)
  T32.fillscreen(black)
  x0=0:y0=0:y1=ht-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    x1=wi*tn
    T32.dline(x0, y0, x1, y1, red)
  next i
  x1=wi-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    y1=ht*tn
    T32.dline(x0, y0, x1, y1, red)
  next i
  T32.drect(0, 00, wi, ht, blue)
  pause 2000
  T32.fillscreen(black)
'demo fast text write
  T32.setrot(T32_rt_right)
  for i=0 to wi-8 step 8
    T32.pstring(0, i, "Hello world:Bye world:Hello world:Bye world:Hello world:Bye world:Hello world:Bye world", 1, T32_normal, green, black)
  next i
  T32.setrot(T32_normal)
  pause 2000
  T32.fillscreen(black)
  for i=ht-1 to 15 step -16
    T32.pstring(wi-1, i, "Micromite MK2:Micromite MK2:Micromite MK2:Rotate Left:Rotate Left", 2, T32_inverse, red, black)
  next i
  pause 2000
  T32.fillscreen(black)
  for i=24 to wi step 24
    T32.pstring(i, 0, "Rotate right:Rotate right:Rotate right", 3, T32_rt_right, yellow, black)
  next i
  pause 2000
  T32.fillscreen(black)
  for i=wi-32 to 0 step -32
    T32.pstring(i, ht-1, "Rotate Left:Rotate Left:Rotate Left", 4, T32_rt_left, blue, black)
  next i
  pause 2000
  T32.fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     T32.setrot(i)
     T32.frect(5, 5, 130, 145, blue)
     T32.drect(2, 2, 136, 151, red)
  next i
  pause 2000
' test drawing rounded rectangles
  T32.fillscreen(black)
  for i=0 to 3
     T32.setrot(i)
     T32.frndrect(5, 5, 130, 145, 10, blue)
     T32.drndrect(2, 2, 136, 151, 12, red)
  next i
  pause 2000
  T32.fillscreen(black)
' test drawing circles
  for i=0 to 3
     T32.setrot(i)
     T32.fcirc(140, 140, 65, blue)
     T32.dcirc(140, 140, 69, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  T32.fillscreen(black)
  for i=0 to 3
     T32.setrot(i)
     T32.ftri(4, 4, 140, 6, 22, 124, blue)
     T32.dtri(1, 2, 144, 4, 22, 127, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 5
  T32.fillscreen(black)
  T32.setrot(T32_normal)
  T32.pstring(wi/2, ht/2, "N", 3, T32_normal, white, black)
  T32.pstring(0, 0, "T32_normal", sz, T32_normal, red, black)
  T32.pstring(wi-1, ht-1, "Inverted", sz, T32_inverse, blue, black)
  T32.pstring(wi-1, 0, "Rotated right", sz, T32_rt_right, green, black)
  T32.pstring(0, ht-1, "Rotated left", sz, T32_rt_left, yellow, black)
  pause 500
  T32.fillscreen(black)
  T32.setrot(T32_inverse)
  T32.pstring(wi/2, ht/2, "I", 3, T32_inverse, white, black)
  T32.pstring(0, 0, "T32_normal", sz, T32_normal, red, black)
  T32.pstring(wi-1, ht-1, "Inverted", sz, T32_inverse, blue, black)
  T32.pstring(wi-1, 0, "Rotated right", sz, T32_rt_right, green, black)
  T32.pstring(0, ht-1, "Rotated left", sz, T32_rt_left, yellow, black)
  pause 500
  T32.fillscreen(black)
  T32.setrot(T32_rt_right)
  T32.pstring(ht/2, wi/2, "R", 3, T32_rt_left, white, black)
  T32.pstring(0, 0, "T32_normal", sz, T32_normal, red, black)
  T32.pstring(ht-1, wi-1, "Inverted", sz, T32_inverse, blue, black)
  T32.pstring(ht-1, 0, "Rotated right", sz, T32_rt_right, green, black)
  T32.pstring(0, wi-1, "Rotated left", sz, T32_rt_left, yellow, black)
  pause 500
  T32.fillscreen(black)
  T32.setrot(T32_rt_left)
  T32.pstring(ht/2, wi/2, "L", 3, T32_rt_right, white, black)
  T32.pstring(0, 0, "T32_normal", sz, T32_normal, red, black)
  T32.pstring(ht-1, wi-1, "Inverted", sz, T32_inverse, blue, black)
  T32.pstring(ht-1, 0, "Rotated right", sz, T32_rt_right, green, black)
  T32.pstring(0, wi-1, "Rotated left", sz, T32_rt_left, yellow, black)
  pause 500
  next sz
end SUB
