OPTION EXPLICIT
option default integer
   
  'Go run the TestSuite 
  TestSuite() 
   
END 
   
   '*********************************************************** ************************** 
  ' 
  ' Peter Mather
  ' 
  ' V1.3 
  ' 2015-23-3 
  ' 
  ' ARMmite graphics library with drivers for SPI SSD1306 display 
  ' 
  ' Initialise Display Library 
  ' You MUST call OLED.Init BEFORE any other call to this library 
  ' SUB OLED.Init(rs,cd,cs,of,wi,ht,nr)              
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         cs : [mandatory] pin used for the displays CS line
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
'              ' 
  ' OLED.Init declares the following externally usable constants 
  '   OLED_ON=1 
  '   OLED_OFF=0 
  '   OLED_RT_RIGHT=2  Rotate Right 
  '   OLED_RT_LEFT=3   Rotate Left 
  '   OLED_NORMAL=0    Normal Aspect 
  '   OLED_INVERSE=1   Upside Down Aspect 
   
  ' The Drawing Primitives assume a graphics display where top left is point 0,0 
  ' The Drawing Primitives just update the memory image of the display 
  ' To actually update the physical display call SUB S_Refresh 
   
  ' Set screen orientation 
  ' SUB OLED.SetRot(x) 
  '     In : X  0=normal,1=invert,2=rotate right,3-rotate left 
   
  ' Draw circle 
  ' SUB OLED.DCirc(x0,y0,r) 
  '     In : x,y coordinates of centre,radius 
   
  ' Draw filled circle, ie a disc 
  ' SUB OLED.FCirc(x0,y0,r) 
  '     In: x,y coordinates of centre,r=radius 
   
  '     Draw triangle 
  ' SUB OLED.DTri(x0,y0, x1,y1, x2,y2)      
  '     In: three coordinate pairs representing each vertex 
   
  '     Draw filled triangle 
  ' SUB OLED.FTri (x0,y0, x1,y1, x2,y2) 
  '     In: three coordinate pairs representing each vertex 
   
  ' Print string 
  ' SUB OLED.PString(xx0,yy0,text$,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          text$,           String to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed text 

  ' Print 8x6 bitmap 
  ' SUB LCD.Pbitmap(xx0,yy0,bitmap,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          bitmap,           character to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed character 
   
  ' Draw line 
  ' SUB OLED.DLine(xx0,yy0,xx1,yy1) 
  '     In:     x0,y0           start of line 
  '          x1,y1           end of line 
   
  '     Draw rectangle 
  ' SUB OLED.DRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  ' Draw filled rectangle 
  ' SUB OLED.FRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Clear rectangluar area 
  ' SUB OLED.CRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Draw rounded rectangle 
  ' SUB OLED.DRndRect(x,y,w,h,r) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
  '          radius                Radius of corners 
   
  ' Draw filled rounded rectangle 
  ' SUB OLED.FRndRect(x,y,w,h,r) 
  '       In:     x,y                Coordinate of top left corner 
  '            width               Width 
  '            height               Height 
  '            radius                Radius of corners 
   
  ' Update the physical display 
  ' SUB OLED.Refresh 
  '       In:     N/A 
   
  '     Clear the physical display and internal memory map 
  ' SUB OLED.Cls 
  '       In:     N/A 
   
  ' 
  ' Initialise Display Library 
  ' You MUST call OLED.Init BEFORE any other call to this library 
  ' SUB OLED.Init(rs,cd,cs,wi,ht,nr)               
  ' 
  '   In  : rs : [mandatory] pin used for the displays RS line
  '         cd : [mandatory] pin used for the displays CD line
  '         cs : [mandatory] pin used for the displays CS line
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8
' 
  ' OLED.Init declares the following externally usable constants 
  '   OLED_ON=1 
  '   OLED_OFF=0 
  '   OLED_RT_RIGHT=2  Rotate Right 
  '   OLED_RT_LEFT=3   Rotate Left 
  '   OLED_NORMAL=0    Normal Aspect 
  '   OLED_INVERSE=1   Upside Down Aspect 
  ' 
SUB OLED.Init(rs,cd,cs,of,wi,ht,nr)
  dim integer OLED_rs=rs, OLED_cd=cd,OLED_cs=cs
  IF wi=0 THEN wi=128 
  IF ht=0 THEN ht=64 
  IF nr=0 THEN nr=ht\8 
  setpin OLED_rs, dout
  SETPIN OLED_cd, DOUT
  SETPIN OLED_cs, DOUT
  spi open 6000000,3
  pause 500
  pin(OLED_rs)=1 'set RESET high
  PIN(OLED_rs)=0
  PIN(OLED_rs)=1 'reset the display
   
  ' Global variables 
  DIM INTEGER OLED_FontPtr,OLED_of,OLED_rot_wi,OLED_rot_ht
  DIM INTEGER OLED_params(6)
  
  'set up arrays for screen map to mimic display 
  DIM INTEGER OLED_sc(wi),OLED_dd(wi)  
   
  'Global Constants 
  'CFunction DRAW function Indexes [sic] 
  DIM Integer OLED_PIX=0,OLED_FFR=1,OLED_FILLtri=2,OLED_DRAWLINE=3, OLED_PSTRING=4, OLED_FCIRCH=5, OLED_DCIRCH=6  
  DIM integer OLED_wi=0,OLED_ht=1,OLED_rot=2,OLED_nr=3,OLED_X=4,OLED_Y=5,OLED_seed=6  
    
  'Used by User program in calls to drawing primitives 
  DIM Integer OLED_ON=1,OLED_OFF=0 
  DIM Integer OLED_NORMAL=0,OLED_INVERSE=1,OLED_RT_RIGHT=2,OLED_RT_LEFT=3 
  OLED_params(OLED_wi)=wi
  OLED_params(OLED_ht)=ht
  OLED_params(OLED_rot)=OLED_NORMAL
  OLED_params(OLED_nr)=nr  
  OLED_params(OLED_seed)=0  
  OLED_FontPtr=PEEK(CFunAddr OLED_FONT) 
  OLED_of=of
   
  LOCAL i% 
  
  OLED.SCmd(&HAE)'DISPLAYOFF) 
  OLED.SCmd(&HD5)'DISPLAYCLOCKDIV 
  OLED.SCmd(&H80)'the suggested ratio &H80 
  OLED.SCmd(&HA8)'MULTIPLEX 
  OLED.SCmd(&H3F)' 
  OLED.SCmd(&HD3)'DISPLAYOFFSET 
  OLED.SCmd(&H0)'no offset 
  OLED.SCmd(&H40)'STARTLINE 
  OLED.SCmd(&H8D)'CHARGEPUMP 
  OLED.SCmd(&H14) 
  OLED.SCmd(&H20)'MEMORYMODE 
  OLED.SCmd(&H00)'&H0 act like ks0108 
  OLED.SCmd(&HA1)'SEGREMAP OR 1 
  OLED.SCmd(&HC8)'COMSCANDEC 
  OLED.SCmd(&HDA)'COMPINS 
  OLED.SCmd(&H12) 
  OLED.SCmd(&H81)'SETCONTRAST 
  OLED.SCmd(&HCF) 
  OLED.SCmd(&Hd9)'SETPRECHARGE 
  OLED.SCmd(&HF1) 
  OLED.SCmd(&HDB)'VCOMDETECT 
  OLED.SCmd(&H40) 
  OLED.SCmd(&HA4)'DISPLAYALLON_RESUME 
  OLED.SCmd(&HA6)'NORMALDISPLAY 
  OLED.SCmd(&HAF)'DISPLAYON end sub

  OLED.CLS
   
END SUB 

SUB OLED.SCmd(Comnd%) 
  local i
  pin(OLED_cd)=0                   ' Send this byte as a command
  PIN(OLED_cs)=0
  i=spi(Comnd%)
  PIN(OLED_cs)=1
END SUB 


SUB OLED.Refresh() 
  LOCAL StartRow%,StartCol%,R%,i% 
  LOCAL OutChar$ length 150 
  do 
    R%=OLEDUpdate(OutChar$,StartCol%,StartRow%,OLED_params(),OLED_sc(),OLED_dd()) 
    if R%>1 then
      OLED.SCz(StartCol%+OLED_of,StartRow%) 
      pin(OLED_cd)=1 'set for sending data
      pin(OLED_cs)=0
      spi write R%,outchar$
      pin(OLED_cs)=1
    else 
      if R%=1 then i%=spi(asc(outchar$))
    endif
  loop while R%<>0
  END SUB 
   
  'Clear Screen 
SUB OLED.Cls 
  LOCAL i 
  FOR i=0 TO OLED_params(OLED_wi)-1 
    OLED_sc(i)=0 
    OLED_dd(i)=-1 
  NEXT i 
  OLED.Refresh 
END SUB 
   
   
SUB OLED.SCz(x%,y%) 
  OLED.SCmd(&HB0+y%)        'set page address 
  OLED.SCmd(&H10+(x%>>4 AND &H0F))  'set high col address 
  OLED.SCmd(&H00+(x% AND &H0f))     'set low col address 
END SUB 
   
  ' 
  ' Generic drawing routines 
  ' 
sub OLED.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=OLEDdraw(OLED_dcirch, OLED_sc(),OLED_ON,x0,y0,r,31,OLED_params())
end sub

   
SUB OLED.DTri(x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  OLED.DLine(x0,y0,x1,y1) 
  OLED.DLine(x1,y1,x2,y2) 
  OLED.DLine(x2,y2,x0,y0) 
END SUB 

  
SUB OLED.FTri (x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LOCAL Integer dp
  dp=OLEDdraw(OLED_FILLtri,OLED_sc(),x0,y0,x1,y1,x2,y2,OLED_params()) 
END SUB 

sub OLED.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=OLEDdraw(OLED_pstring,OLED_FontPtr,OLED_ON,xx0,yy0,sz,orientation,OLED_params(),OLED_sc(),text$)
  xx0=OLED_params(OLED_X)
  yy0=OLED_params(OLED_Y)
end sub
'
sub OLED.pbitmap(xx0 as integer, yy0 as integer, bitmap as integer, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=OLEDdraw(OLED_pstring,bitmap,OLED_ON,xx0,yy0,sz,orientation,OLED_params(),OLED_sc(),"")
  xx0=OLED_params(OLED_X)
  yy0=OLED_params(OLED_Y)
end sub
'
SUB OLED.DLine(xx0%,yy0%,xx1%,yy1%) ' x,y of start line,x,y of end line 
  LOCAL  dp%=OLEDdraw(OLED_DRAWLINE,OLED_sc(),OLED_ON,xx0%,yy0%,xx1%,yy1%,OLED_params()) 
END SUB 

SUB OLED.DRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,OLED_params(OLED_wi),OLED_ht 
  LOCAL  Integer a,dp 
   dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x,y,w,1,OLED_params()) 
  a=y+h-1 
   dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x,a,w,1,OLED_params()) 
   dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x,y,1,h,OLED_params()) 
  a=x+w-1 
   dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,a,y,1,h,OLED_params()) 
END SUB 


SUB OLED.FRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x,y,w,h,OLED_params()) 
END SUB 


SUB OLED.CRect(x AS integer,y AS integer,w AS integer,h AS integer) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_OFF,x,y,w,h,OLED_params()) 
END SUB 


SUB OLED.FCirc(x0%,y0%,r%)  'x,y coordinates of centre,radius 
  LOCAL  dp%=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x0%,y0%-r%,1,2*r%+1,OLED_params()) 
  dp%=OLEDdraw(OLED_fcircH,OLED_sc(),OLED_ON,x0%, y0%, r%, 3, 0,  OLED_params())
END SUB 
   
   
SUB OLED.DRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer ) 'x,y coordinates of top left,width,height,radius of corner
  LOCAL Integer dp 
  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x+r,y,w-2*r,1,OLED_params()) 
  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x+r,y+h-1,w-2*r,1,OLED_params()) 
  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x,y+r,1,h-2*r,OLED_params()) 
  dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x+w-1,y+r,1,h-2*r,OLED_params()) 
  dp=OLEDdraw(OLED_dcirch, OLED_sc(),OLED_ON, x+r, y+r, r, 1,OLED_params())
  dp=OLEDdraw(OLED_dcirch, OLED_sc(),OLED_ON, x+w-r-1, y+r, r, 2,OLED_params())
  dp=OLEDdraw(OLED_dcirch, OLED_sc(),OLED_ON, x+w-r-1, y+h-r-1, r, 4,OLED_params())
  dp=OLEDdraw(OLED_dcirch, OLED_sc(),OLED_ON, x+r, y+h-r-1, r, 8,OLED_params())
END SUB 


SUB OLED.FRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer) 'x,y coordinates of top left,width,height,radius of corner 
  LOCAL Integer dp 
   dp=OLEDdraw(OLED_FFR,OLED_sc(),OLED_ON,x+r,y,w-2*r,h,OLED_params()) 
   dp=OLEDdraw(OLED_fcircH,OLED_sc(),OLED_ON,x+w-r-1, y+r, r, 1, h-2*r-1, OLED_params())
   dp=OLEDdraw(OLED_fcircH,OLED_sc(),OLED_ON,x+r, y+r, r, 2, h-2*r-1, OLED_params())
END SUB 


SUB OLED.SetRot(x%) 'sets screen rotation: 0=normal,1=invert,2=rotate right,3-rotate left 
  OLED_params(2)=(x% AND 3) 
  OLED_rot_wi=OLED_params(OLED_wi) 
  OLED_rot_ht=OLED_params(OLED_ht)
  IF x%>=2 THEN 
    OLED_rot_wi=OLED_params(OLED_ht) 
    OLED_rot_ht=OLED_params(OLED_wi) 
  ENDIF 
END SUB 

  ' 
  ' CFunctions 
  ' 
  ' 
  ' CFunctions 
  ' 
'
CFunction Oledupdate
	00000000
	b09fb480 60f8af00 607a60b9 683b603b e9d33318 46132300 683b667b 2300e9d3 
	663b4613 66fb2300 3330683b 2300e9d3 d00a4313 1c5968fb 3330683b 2300e9d3 
	700bb2d3 33016efb 230066fb e014677b 009b6f7b 0278f107 f04f4413 f84332ff 
	6f7b2c48 f107009b 44130278 32fff04f 2c68f843 33016f7b 6f7a677b 429a6e7b 
	2300dbe6 e04d677b 00db6f7b 2080f8d7 e9d34413 e9c72300 6f7b2316 f8d700db 
	44132084 2300e9d3 2314e9c7 673b2300 f107e031 6f3b0258 781a4413 0150f107 
	440b6f3b 429a781b 6f3bd022 f107009b 44130278 3c48f853 3ffff1b3 6f3bd110 
	f107009b 44130278 f8436f7a 6f3b2c48 f107009b 44130278 f8436f7a e0072c68 
	009b6f3b 0278f107 6f7a4413 2c68f843 33016f3b 6f3a673b 429a6e7b 6f7bdbc9 
	677b3301 6e3b6f7a dbad429a 33fff04f 6e7b66bb 677b3b01 6f7be00e f107009b 
	44130278 3c48f853 3ffff1b3 6f7bd001 6f7b66bb 677b3b01 2b006f7b 6ebbdaed 
	3ffff1b3 f04fd104 f04f0200 e05c0300 009b6ebb 0278f107 f8534413 461a3c48 
	601a68bb 009b6ebb 0278f107 f8534413 677b3c48 6f7be034 f8d700db 44132080 
	2300e9d3 2316e9c7 00db6f7b 2084f8d7 e9d34413 e9c72300 6efb2314 66fb3301 
	0258f107 44136ebb f1077819 6ebb0250 460a4413 6efb701a 441368fa 0150f107 
	440a6eba 701a7812 00db6f7b 2084f8d7 e9d718d1 e9c12314 6f7b2300 677b3301 
	009b6ebb 0278f107 f8534413 6f7b2c68 dac0429a 687b6eba 6efb601a 68fbb2da 
	6efb701a ea4f461a 461073e2 377c4619 f85d46bd 47707b04 
End CFunction
'
'
'----------> ARM THUMB Instruction Set <----------
'
'C:\Users\Peter\Dropbox\CoIDE\CfunctionTest\CfunctionTest\Debug\bin\OLEDdraw.bas
'
'OLEDdraw  2015-03-22 18:54:51 CFuncGen4ARM Ver 1.0.4 by user=Peter
'
CFunction OLEDdraw
'localfastfillrect
	00000641
	b0a1b480 60f8af00 e9c760b9 683b2300 f8d7667b 663b3088 3090f8d7 f8d765fb 
	65bb3098 30a0f8d7 e9d33310 46132300 f8d7657b e9d330a0 46132300 f8d7653b 
	330830a0 2300e9d3 64fb4613 f88723ff 23fe3020 3021f887 f88723fc 23f83022 
	3023f887 f88723f0 23e03024 3025f887 f88723c0 23803026 3027f887 753b2301 
	757b2303 75bb2307 75fb230f 763b231f 767b233f 76bb237f 76fb23ff 2b006d7b 
	6e7bd12d 6ffa67fb 429a6d3b f04fdb04 f04f0200 e1e90300 6dfb6ffa 3b014413 
	6fba67bb 429a6d3b 6d3bdb02 67bb3b01 677b6e3b 6cfb6f7a db04429a 0200f04f 
	0300f04f 6f7ae1d2 44136dbb 673b3b01 6cfb6f3a db02429a 3b016cfb 6d7b67bb 
	d12d2b01 6e7b6d3a 3b011ad3 6fbb67bb da042b00 0200f04f 0300f04f 6fbae1b6 
	1ad36dfb 67fb3301 2b006ffb 2300da01 6cfa67fb 1ad36e3b 673b3b01 2b006f3b 
	f04fda04 f04f0200 e19f0300 6dbb6f3a 33011ad3 6f7b677b da012b00 677b2300 
	2b026d7b 6d3ad12c 1ad36e3b 67bb3b01 6d3b6fba db02429a 3b016d3b 6fba67bb 
	1ad36dbb 67fb3301 2b006ffb 2300da01 6e7b67fb 6f7a677b 429a6cfb f04fdb04 
	f04f0200 e1710300 6dfb6f7a 3b014413 6f3a673b 429a6cfb 6cfbdb02 673b3b01 
	2b036d7b 6e3bd12d 6ffa67fb 429a6d3b f04fdb04 f04f0200 e1570300 6dbb6ffa 
	3b014413 6fba67bb 429a6d3b 6d3bdb02 67bb3b01 6e7b6cfa 3b011ad3 6f3b673b 
	da042b00 0200f04f 0300f04f 6f3ae13e 1ad36dfb 677b3301 2b006f7b 2300da01 
	6f7b677b da002b00 10db3307 6f3b64bb da002b00 10db3307 6cba647b 075b4613 
	00db1a9b 6f7b461a 643b4413 46136c7a 1a9b075b 461a00db 44136f3b 6cba63fb 
	429a6c7b 6ffbd157 e05066fb 00db6efb 441368fa 2300e9d3 230ce9c7 2b0068bb 
	f107d01c 6c3b0220 781a4413 0114f107 440b6bfb 4013781b 303bf887 0230f107 
	44136cbb f897781a 4313303b f107b2d9 6cbb0230 460a4413 e01d701a 0220f107 
	44136c3b f107781a 6bfb0114 781b440b b2db4013 f88743db f107303b 6cbb0230 
	781a4413 303bf897 b2d94013 0230f107 44136cbb 701a460a 00db6efb 18d168fa 
	230ce9d7 2300e9c1 33016efb 6efa66fb 429a6fbb 6cbbddaa 6c7b1c5a dc7b429a 
	66fb6ffb 6efbe074 68fa00db e9d34413 e9c72300 68bb230c d0162b00 0220f107 
	44136c3b f887781b f107303a 6cbb0230 781a4413 303af897 b2d94313 0230f107 
	44136cbb 701a460a f107e016 6c3b0220 781b4413 f88743db f107303a 6cbb0230 
	781a4413 303af897 b2d94013 0230f107 44136cbb 701a460a 2b0068bb f107d016 
	6bfb0214 781b4413 3039f887 0230f107 44136c7b f897781a 43133039 f107b2d9 
	6c7b0230 460a4413 e016701a 0214f107 44136bfb 43db781b 3039f887 0230f107 
	44136c7b f897781a 40133039 f107b2d9 6c7b0230 460a4413 6efb701a 68fa00db 
	e9d718d1 e9c1230c 6efb2300 66fb3301 6fbb6efa dd86429a 1c5a6cbb 429a6c7b 
	6cbbda34 66bb3301 6ffbe02c e02266fb 00db6efb 441368fa 2300e9d3 230ce9c7 
	2b0068bb f107d006 6ebb0230 22ff4413 e005701a 0230f107 44136ebb 701a2200 
	00db6efb 18d168fa 230ce9d7 2300e9c1 33016efb 6efa66fb 429a6fbb 6ebbddd8 
	66bb3301 6c7b6eba dbce429a 46194610 46bd3784 7b04f85d bf004770 

'localdrawPixel
	b08cb490 
	60f8af00 2300e9c7 33106cbb 2300e9d3 627b4613 e9d36cbb 46132300 6cbb623b 
	e9d33308 46132300 6bbb61fb 6c3b62fb 6a7b62bb d1092b01 6bbb6a3a 3b011ad3 
	69fa62fb 1ad36c3b 62bb3b01 2b026a7b 6bbbd106 6a3a62bb 1ad36c3b 62fb3b01 
	2b036a7b 69fad106 1ad36bbb 62bb3b01 62fb6c3b 6afb6a3a bf8c429a 23002301 
	69f9b2da 42996abb 2301bf8c b2db2300 b2db4013 d0552b00 2300e9d7 d0274313 
	0200f04f 0300f04f 2304e9c7 2b1f6abb 6abbd805 fa022201 613bf303 6abbe005 
	461a3b20 40932301 6afb617b 68fa00db 6afb18d4 68fa00db e9d34413 e9d70100 
	ea422304 ea430200 e9c40301 e02e2300 2b1f6abb 6abbd809 fa022201 43dbf303 
	f04f613b 617b33ff 6abbe009 461a3b20 40932301 617b43db 33fff04f 6afb613b 
	68fa00db 6afb18d4 68fa00db e9d34413 e9d70100 ea022304 ea030200 e9c40301 
	e0042300 0200f04f 0300f04f 6afbe005 6abb613b e9d7617b 46102304 37304619 
	bc9046bd bf004770 

'swap
	b085b480 6078af00 687b6039 60fb681b 681a683b 601a687b 
	68fa683b 3714601a f85d46bd 47707b04 

'drawline
	b096b580 60f8af06 2300e9c7 623b6cbb 
	61fb6d3b 61bb6dbb 617b6e3b 69fb697a dd04429a 69fb697a 637b1ad3 69fae003 
	1ad3697b 69ba637b 429a6a3b 69badd04 1ad36a3b e003633b 69bb6a3a 633b1ad3 
	6b3b6b7a bfcc429a 23002301 62fbb2db 2b006afb f107d00f f1070220 4610031c 
	f7ff4619 f107ffb1 f1070218 46100314 f7ff4619 6a3affa9 429a69bb f107dd0f 
	f1070220 46100318 f7ff4619 f107ff9d f107021c 46100314 f7ff4619 69baff95 
	1ad36a3b 697a62bb 429a69fb 697add04 1ad369fb e00363fb 697b69fa 63fb1ad3 
	0fda6abb 105b4413 69fa63bb 429a697b 2301da02 e002637b 33fff04f e043637b 
	2b006afb 69fbd017 ea4f4618 6a3b71e0 ea4f461a e9cd73e2 e9cd0100 6ebb2302 
	68f89304 2300e9d7 fea8f7ff 460b4602 627b4613 6a3be016 ea4f4618 69fb71e0 
	ea4f461a e9cd73e2 e9cd0100 6ebb2302 68f89304 2300e9d7 fe90f7ff 460b4602 
	627b4613 6bfb6bba 63bb1ad3 2b006bbb 69fada07 44136b7b 6bba61fb 44136abb 
	6a3b63bb 623b3301 69bb6a3a ddb7429a 46194610 46bd3740 bf00bd80 

'drawchar
	43f0e92d 
	af08b097 e9c760f8 6e3b2300 6ebb62fb 6f3b62bb 6fbb627b e9d7623b e9c72300 
	6a3b2304 f0402b00 230080bd e0b5637b 633b2300 f107e0ab 6b7b0210 781b4413 
	6b3b461a f303fa42 0301f003 d04d2b00 2b016a7b 6afbd119 6b7b1d5a 46181ad3 
	71e0ea4f 6b3b6aba 461a4413 73e2ea4f 0100e9cd 2302e9cd 3080f8d7 68f89304 
	2316e9d7 fe2af7ff 6dbee07e f1c36b7b 6a7a0305 f203fb02 44136afb ea4f4698 
	6b3b79e8 fb026a7a 6abbf203 461c4413 75e4ea4f 46186a7b 71e0ea4f 461a6a7b 
	73e2ea4f 4500e9cd 0102e9cd 2304e9cd 3080f8d7 68f89306 46424631 f7ff464b 
	4602fbaf 4613460b e04d61fb 2b016a7b 6afbd11b 6b7b1d5a 46181ad3 71e0ea4f 
	6b3b6aba 461a4413 73e2ea4f 0100e9cd 2302e9cd 3080f8d7 68f89304 0200f04f 
	0300f04f fddaf7ff 6b7be02e 0305f1c3 fb026a7a 6afbf203 46984413 79e8ea4f 
	6a7a6b3b f203fb02 44136abb ea4f461c 6a7b75e4 ea4f4618 6a7b71e0 ea4f461a 
	e9cd73e2 e9cd4500 e9cd0102 f8d72304 93063080 210068f8 464b4642 fb60f7ff 
	460b4602 61fb4613 33016b3b 6b3b633b f77f2b07 6b7baf50 637b3301 2b056b7b 
	af46f77f 2b016a3b 80ccf040 637b2300 2300e0c4 e0ba633b f1c36b7b f1070305 
	44130238 3c28f813 6b3b461a 0307f1c3 f303fa42 0301f003 d0522b00 2b016a7b 
	6afad119 1ad36b7b ea4f4618 6aba71e0 44136b3b 461a3b07 73e2ea4f 0100e9cd 
	2302e9cd 3080f8d7 68f89304 2316e9d7 fd64f7ff 6dbee088 6a7b6afa 1c5a1ad3 
	6a796b7b f303fb01 46981ad3 79e8ea4f 6a7b6aba 1c5a1ad3 3b076b3b fb016a79 
	4413f303 ea4f461c 6a7b75e4 ea4f4618 6a7b71e0 ea4f461a e9cd73e2 e9cd4500 
	e9cd0102 f8d72304 93063080 463168f8 464b4642 fae4f7ff 460b4602 61fb4613 
	6a7be052 d11b2b01 6b7b6afa 46181ad3 71e0ea4f 6b3b6aba 3b074413 ea4f461a 
	e9cd73e2 e9cd0100 f8d72302 93043080 f04f68f8 f04f0200 f7ff0300 e033fd0f 
	6a7b6afa 1c5a1ad3 6a796b7b f303fb01 46981ad3 79e8ea4f 6a7b6aba 1c5a1ad3 
	3b076b3b fb016a79 4413f303 ea4f461c 6a7b75e4 ea4f4618 6a7b71e0 ea4f461a 
	e9cd73e2 e9cd4500 e9cd0102 f8d72304 93063080 210068f8 464b4642 fa90f7ff 
	460b4602 61fb4613 33016b3b 6b3b633b f77f2b07 6b7baf41 637b3301 2b056b7b 
	af37f77f 2b026a3b 80c0f040 637b2300 2300e0b8 e0ae633b f1c36b3b f1070305 
	44130238 3c28f813 6b7b461a f303fa42 0301f003 d04d2b00 2b016a7b 6afad118 
	1ad36b7b ea4f4618 6aba71e0 44136b3b ea4f461a e9cd73e2 e9cd0100 f8d72302 
	93043080 e9d768f8 f7ff2316 e07ffc97 6afa6dbe 1ad36a7b 6b7b1c5a fb016a79 
	1ad3f303 ea4f4698 6b3b79e8 fb026a7a 6abbf203 461c4413 75e4ea4f 46186a7b 
	71e0ea4f 461a6a7b 73e2ea4f 4500e9cd 0102e9cd 2304e9cd 3080f8d7 68f89306 
	46424631 f7ff464b 4602fa1b 4613460b e04d61fb 2b016a7b 6afad11a 1ad36b7b 
	ea4f4618 6aba71e0 44136b3b ea4f461a e9cd73e2 e9cd0100 f8d72302 93043080 
	f04f68f8 f04f0200 f7ff0300 e02ffc47 6a7b6afa 1c5a1ad3 6a796b7b f303fb01 
	46981ad3 79e8ea4f 6a7a6b3b f203fb02 44136abb ea4f461c 6a7b75e4 ea4f4618 
	6a7b71e0 ea4f461a e9cd73e2 e9cd4500 e9cd0102 f8d72304 93063080 210068f8 
	464b4642 f9ccf7ff 460b4602 61fb4613 33016b3b 6b3b633b f77f2b05 6b7baf4d 
	637b3301 2b076b7b af43f77f 2b036a3b 80d5f040 637b2300 2300e0cd e0c3633b 
	0210f107 44136b3b 461a781b f1c36b7b fa420307 f003f303 2b000301 6a7bd058 
	d11a2b01 6b7b6afa 33071ad3 ea4f4618 6aba71e0 44136b3b 461a3b05 73e2ea4f 
	0100e9cd 2302e9cd 3080f8d7 68f89304 2316e9d7 fbd2f7ff 6dbee093 6a7a6b7b 
	f303fb02 1ad16afa 46136a7a 1a9b00db 4698440b 79e8ea4f 6a7a6b3b f203fb02 
	18d16abb 46136a7a 1a9b0092 440b005b 461c3301 75e4ea4f 46186a7b 71e0ea4f 
	461a6a7b 73e2ea4f 4500e9cd 0102e9cd 2304e9cd 3080f8d7 68f89306 46424631 
	f7ff464b 4602f94d 4613460b e05861fb 2b016a7b 6afad11c 1ad36b7b 46183307 
	71e0ea4f 6b3b6aba 3b054413 ea4f461a e9cd73e2 e9cd0100 f8d72302 93043080 
	f04f68f8 f04f0200 f7ff0300 e038fb77 6a7a6b7b f303fb02 1ad16afa 46136a7a 
	1a9b00db 4698440b 79e8ea4f 6a7a6b3b f203fb02 18d16abb 46136a7a 1a9b0092 
	440b005b 461c3301 75e4ea4f 46186a7b 71e0ea4f 461a6a7b 73e2ea4f 4500e9cd 
	0102e9cd 2304e9cd 3080f8d7 68f89306 46422100 f7ff464b 4602f8f3 4613460b 
	6b3b61fb 633b3301 2b056b3b af38f77f 33016b7b 6b7b637b f77f2b07 e9d7af2e 
	46102304 373c4619 e8bd46bd bf0083f0 

'nextchar
	b085b480 60f8af00 607a60b9 683b603b 
	d1092b00 681968fb 4613687a 4413005b 18ca005b 601a68fb 2b01683b 68fbd109 
	687a6819 00924613 005b1a9b 68fb18ca 683b601a d1092b02 681968bb 4613687a 
	4413005b 18ca005b 601a68bb 2b03683b 68bbd109 687a6819 00924613 005b1a9b 
	68bb18ca 3714601a f85d46bd 47707b04 

'pstring
	4fb0e92d af0cb0a0 0104e9c7 2302e9c7 
	627b6f3b 623b6fbb 3080f8d7 f8d764bb 647b3088 643b693b 3098f8d7 2b00781b 
	2301d06c e06164fb f8d76cfb 44132098 2b1f781b 6cfbd91c 2098f8d7 781b4413 
	b25bb2db db132b00 f8d76cfb 44132098 3b20781b 6c3b00da 63fb4413 33046bfb 
	6bfb63bb 61bb681b 681b6bbb e00361fb 61bb2300 61fb2300 2306e9d7 2300e9c7 
	46986a7b 79e8ea4f 461c6a3b 75e4ea4f 46186cbb 71e0ea4f 461a6c7b 73e2ea4f 
	ab02e9d7 ab00e9cd 8902e9cd 4504e9cd 0106e9cd 2308e9cd 3090f8d7 f8d7930a 
	e9d70094 f7ff2300 4602fc09 4613460b f107637b f1070224 46100320 6cba4619 
	f7ff6c7b 6cfbff45 64fb3301 3098f8d7 461a781b 429a6cfb e032da96 46986a7b 
	79e8ea4f 461c6a3b 75e4ea4f 46186cbb 71e0ea4f 461a6c7b 73e2ea4f ab02e9d7 
	ab00e9cd 8902e9cd 4504e9cd 0106e9cd 2308e9cd 3090f8d7 f8d7930a e9d70094 
	f7ff2304 4602fbcb 4613460b f107637b f1070224 46100320 6cba4619 f7ff6c7b 
	f8d7ff07 f1033090 6a7b0120 ea4f461a e9c173e2 f8d72300 f1033090 6a3b0128 
	ea4f461a e9c173e2 e9d72300 4610230a 37504619 e8bd46bd bf008fb0 

'dcirch
	b094b580 
	60f8af06 2300e9c7 623b6d3b f1c36a3b 637b0301 633b2301 46136a3a 1a9b07db 
	62fb005b 62bb2300 627b6a3b 61fb6c3b 61bb6cbb 617b6dbb f003697b 2b000310 
	69fbd063 ea4f4618 69ba71e0 44136a3b ea4f461a e9cd73e2 e9cd0100 6e3b2302 
	68f89304 2300e9d7 f9d8f7ff 460b4602 613b4613 461869fb 71e0ea4f 6a3b69ba 
	461a1ad3 73e2ea4f 0100e9cd 2302e9cd 93046e3b e9d768f8 f7ff2300 4602f9bf 
	4613460b 69fa613b 44136a3b ea4f4618 69bb71e0 ea4f461a e9cd73e2 e9cd0100 
	6e3b2302 68f89304 2300e9d7 f9a6f7ff 460b4602 613b4613 6a3b69fa 46181ad3 
	71e0ea4f 461a69bb 73e2ea4f 0100e9cd 2302e9cd 93046e3b e9d768f8 f7ff2300 
	4602f98d 4613460b e102613b 2b006b7b 6a7bdb09 627b3b01 33026afb 6b7a62fb 
	44136afb 6abb637b 62bb3301 33026b3b 6b7a633b 44136b3b 697b637b 0304f003 
	d0352b00 6abb69fa 46184413 71e0ea4f 6a7b69ba 461a4413 73e2ea4f 0100e9cd 
	2302e9cd 93046e3b e9d768f8 f7ff2300 4602f955 4613460b 69fa613b 44136a7b 
	ea4f4618 69ba71e0 44136abb ea4f461a e9cd73e2 e9cd0100 6e3b2302 68f89304 
	2300e9d7 f93af7ff 460b4602 613b4613 f003697b 2b000302 69fad035 44136abb 
	ea4f4618 69ba71e0 1ad36a7b ea4f461a e9cd73e2 e9cd0100 6e3b2302 68f89304 
	2300e9d7 f91af7ff 460b4602 613b4613 6a7b69fa 46184413 71e0ea4f 6abb69ba 
	461a1ad3 73e2ea4f 0100e9cd 2302e9cd 93046e3b e9d768f8 f7ff2300 4602f8ff 
	4613460b 697b613b 0308f003 d0352b00 6a7b69fa 46181ad3 71e0ea4f 6abb69ba 
	461a4413 73e2ea4f 0100e9cd 2302e9cd 93046e3b e9d768f8 f7ff2300 4602f8df 
	4613460b 69fa613b 1ad36abb ea4f4618 69ba71e0 44136a7b ea4f461a e9cd73e2 
	e9cd0100 6e3b2302 68f89304 2300e9d7 f8c4f7ff 460b4602 613b4613 f003697b 
	2b000301 69fad035 1ad36a7b ea4f4618 69ba71e0 1ad36abb ea4f461a e9cd73e2 
	e9cd0100 6e3b2302 68f89304 2300e9d7 f8a4f7ff 460b4602 613b4613 6abb69fa 
	46181ad3 71e0ea4f 6a7b69ba 461a1ad3 73e2ea4f 0100e9cd 2302e9cd 93046e3b 
	e9d768f8 f7ff2300 4602f889 4613460b 6aba613b 429a6a7b aef8f6ff 46194610 
	46bd3738 bf00bd80 

'fcirch
	b099b5f0 60f8af08 2300e9c7 62bb6ebb f1c36abb 63fb0301 
	63bb2301 46136aba 1a9b07db 637b005b 633b2300 62fb6abb 627b6dbb 623b6e3b 
	61fb6f3b 61bb6fbb 6bfbe0d0 db092b00 3b016afb 6b7b62fb 637b3302 6b7b6bfa 
	63fb4413 33016b3b 6bbb633b 63bb3302 6bbb6bfa 63fb4413 f00369fb 2b000301 
	683ed057 6b3b6a7a 461c4413 75e4ea4f 6afb6a3a 46181ad3 71e0ea4f 005b6afb 
	69bb1c5a 461a4413 73e2ea4f 0100e9cd 0001f04f 0100f04f 0102e9cd 2304e9cd 
	3080f8d7 68f89306 46224631 f7fe462b 4602fdc7 4613460b 683e617b 6afb6a7a 
	461c4413 75e4ea4f 6b3b6a3a 46181ad3 71e0ea4f 005b6b3b 69bb1c5a 461a4413 
	73e2ea4f 0100e9cd 0001f04f 0100f04f 0102e9cd 2304e9cd 3080f8d7 68f89306 
	46224631 f7fe462b 4602fd9b 4613460b 69fb617b 0302f003 d0572b00 6a7a683e 
	1ad36b3b ea4f461c 6a3a75e4 1ad36afb ea4f4618 6afb71e0 1c5a005b 441369bb 
	ea4f461a e9cd73e2 f04f0100 f04f0001 e9cd0100 e9cd0102 f8d72304 93063080 
	463168f8 462b4622 fd6af7fe 460b4602 617b4613 6a7a683e 1ad36afb ea4f461c 
	6a3a75e4 1ad36b3b ea4f4618 6b3b71e0 1c5a005b 441369bb ea4f461a e9cd73e2 
	f04f0100 f04f0001 e9cd0100 e9cd0102 f8d72304 93063080 463168f8 462b4622 
	fd3ef7fe 460b4602 617b4613 6afb6b3a f6ff429a 3744af2a bdf046bd 

'ftri
	b0a0b5b0 
	60f8af08 2300e9c7 62bb683b 627b6f3b 623b6fbb 3080f8d7 f8d761fb 61bb3088 
	3090f8d7 6a7a617b 429a69fb f107dd0f f1070224 4610031c f7ff4619 f107f815 
	f1070228 46100320 f7ff4619 69faf80d 429a697b f107dd0f f1070214 4610031c 
	f7ff4619 f107f801 f1070218 46100320 f7fe4619 6a7afff9 429a69fb f107dd0f 
	f1070224 4610031c f7fe4619 f107ffed f1070228 46100320 f7fe4619 6a7affe5 
	429a697b 6abbd144 6abb633b 6a3a62fb 429a6b3b 6a3bda02 e005633b 6afb6a3a 
	dd01429a 62fb6a3b 6b3b69ba da02429a 633b69bb 69bae005 429a6afb 69bbdd01 
	6b3b62fb ea4f461c 6a7b75e4 ea4f4618 6afa71e0 1ad36b3b 461a3301 73e2ea4f 
	0100e9cd 0001f04f 0100f04f 0102e9cd 2304e9cd 3098f8d7 68f89306 46222101 
	f7fe462b 4602fc9d 4613460b e11564fb 6abb6a3a 64bb1ad3 6a7b69fa 647b1ad3 
	6abb69ba 643b1ad3 6a7b697a 63fb1ad3 6a3b69ba 63bb1ad3 69fb697a 637b1ad3 
	657b2300 653b2300 697b69fa d102429a 65bb69fb 69fbe002 65bb3b01 65fb6a7b 
	6d7ae06a fb926c7b 6abbf2f3 633b4413 6bfb6d3a f2f3fb92 44136abb 6d7a62fb 
	44136cbb 6d3a657b 44136c3b 6a3a653b 1ad36abb 6df96a7a fb021a8a 69f9f203 
	1acb6a7b f2f3fb92 44136abb 69ba633b 1ad36abb 6df96a7a fb021a8a 6979f203 
	1acb6a7b f2f3fb92 44136abb 6b3a62fb 429a6afb f107dd07 f1070230 4610032c 
	f7fe4619 6b3bff31 ea4f461c 6dfb75e4 ea4f4618 6afa71e0 1ad36b3b 461a3301 
	73e2ea4f 0100e9cd 2302e9cd 0201f04f 0300f04f 2304e9cd 3098f8d7 68f89306 
	46222101 f7fe462b 4602fc0b 4613460b 6dfb64fb 65fb3301 6dbb6dfa dd90429a 
	6dfa69fb 6bba1ad3 f303fb02 6a7b657b 1ad36dfa fb026c3a 653bf303 6d7ae06a 
	fb926b7b 6a3bf2f3 633b4413 6bfb6d3a f2f3fb92 44136abb 6d7a62fb 44136bbb 
	6d3a657b 44136c3b 69ba653b 1ad36a3b 6df969fa fb021a8a 6979f203 1acb69fb 
	f2f3fb92 44136a3b 69ba633b 1ad36abb 6df96a7a fb021a8a 6979f203 1acb6a7b 
	f2f3fb92 44136abb 6b3a62fb 429a6afb f107dd07 f1070230 4610032c f7fe4619 
	6b3bfeb3 ea4f461c 6dfb75e4 ea4f4618 6afa71e0 1ad36b3b 461a3301 73e2ea4f 
	0100e9cd 2302e9cd 0201f04f 0300f04f 2304e9cd 3098f8d7 68f89306 46222101 
	f7fe462b 4602fb8d 4613460b 6dfb64fb 65fb3301 6dfa697b dd90429a 46bd3760 
	bf00bdb0 

'main
	4ff0e92d af0cb095 61396178 60bb60fa e9d3697b 43132300 68fbd124 
	2300e9d3 461c4613 75e4ea4f e9d368bb 46132300 ea4f4618 6cbb71e0 2300e9d3 
	461a4613 73e2ea4f 0100e9cd 2302e9cd 93046cfb 46226938 f7fe462b e9c7fd9f 
	e9d70106 e1332306 e9d3697b 2b002300 2a01bf08 68fbd122 2300e9d3 68bb4616 
	8900e9d3 e9d36cbb 6cfb4500 0100e9d3 e9d36d3b e9cd2300 e9cd4500 e9cd0102 
	6d7b2304 69389306 46424631 f7fe464b e9c7fb27 e9d70106 e1092306 e9d3697b 
	2b002300 2a02bf08 68fbd13c 2300e9d3 2300e9c7 e9d368bb 46132300 ea4f469a 
	6cbb7bea 2300e9d3 46984613 79e8ea4f e9d36cfb 46132300 ea4f461c 6d3b75e4 
	2300e9d3 46184613 71e0ea4f e9d36d7b 46132300 ea4f461a e9cd73e2 e9cdab00 
	e9cd8902 e9cd4504 e9cd0106 6dbb2308 6938930a 2300e9d7 fdb0f7ff e9d3697b 
	e0c52300 e9d3697b 2b002300 2a03bf08 68fbd131 ab00e9d3 e9d368bb 46132300 
	ea4f4698 6cbb79e8 2300e9d3 461c4613 75e4ea4f e9d36cfb 46132300 ea4f4618 
	6d3b71e0 2300e9d3 461a4613 73e2ea4f 8900e9cd 4502e9cd 0104e9cd 2306e9cd 
	93086d7b 46526938 f7fe465b 697bfdc1 2300e9d3 697be08c 2300e9d3 bf082b00 
	d12c2a04 e9d3693b e9c72300 68fb2300 ab00e9d3 e9d368bb 6cbb8900 4500e9d3 
	e9d36cfb 6d3b0100 2300e9d3 8900e9cd 4502e9cd 0104e9cd 2306e9cd 93086d7b 
	93096dbb 930a6dfb 0100e9d7 465b4652 f9def7ff 0106e9c7 2306e9d7 697be058 
	2300e9d3 bf082b00 d1282a05 e9d368fb e9c72300 68bb2300 ab00e9d3 e9d36cbb 
	6cfb8900 4500e9d3 e9d36d3b 6d7b0100 2300e9d3 ab00e9cd 8902e9cd 4504e9cd 
	0106e9cd 2308e9cd 930a6dbb e9d76938 f7ff2300 697bfc19 2300e9d3 697be028 
	2300e9d3 bf082b00 d1212a06 e9d368fb 68bbab00 8900e9d3 e9d36cbb 6cfb4500 
	0100e9d3 e9d36d3b e9cd2300 e9cd8900 e9cd4502 e9cd0104 6d7b2306 69389308 
	465b4652 fa5af7ff e9d3697b e7ff2300 46194610 46bd3724 8ff0e8bd 
End CFunction

CFunction OLED_font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
  
  '-------------------Delete ALL text below when using Library in your own programs 
   
   
SUB TestSuite 
   
  pause 1000
  PRINT "Starting initialisation" 
  PRINT "Using  1.3inch SPI SSD1306" 
   
  'initialise the display 
  OLED.Init 1,2,3,2 'note offset=2 for 1.3" display (PE2, PE3, PE4)
   
PRINT "starting main" 
  'Variables for use in main 
  LOCAL Integer i,xfs,yfs,x0=0,y0=0,x1,y1 ,wi,ht
  LOCAL FLOAT tn 
  LOCAL Integer Sz 
  wi= OLED_params(OLED_wi)
  ht= OLED_params(OLED_ht)

  DO 
    OLED.SetRot(OLED_NORMAL) 
    OLED.Cls 
    OLED.drect(0, 0, wi, ht)
    OLED.pbitmap(58, 2, &HFF818181FF, 2, 0)
    OLED.pstring(20, 24, "Welcome to the", 1, 0)
    OLED.pstring(29, 34, "ARMmite b20", 1, 0)   
    OLED.pstring(29, 44, "SSD1306 SPI", 1, 0)   
    OLED.Refresh
    pause 2000     
    ' demo fast line draw 
    OLED.SetRot(OLED_NORMAL) 
    OLED.Cls 
    y1=63
    FOR i=0 TO 45 STEP 5
      tn=TAN(RAD(i))
      x1=OLED_params(OLED_wi)*tn
      OLED.DLine(x0,y0,x1,y1)
    NEXT i

    x1=127
    FOR i=0 TO 40 STEP 5
      tn=TAN(RAD(i))
      y1=OLED_params(OLED_ht)*tn
      OLED.DLine(x0,y0,x1,y1)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    'demo fast text write
    FOR i=0 TO 56 STEP 8
      OLED.PString(0,i,"Hello world:Bye world",1,OLED_NORMAL)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    FOR i=63 TO 15 STEP -16
      OLED.PString(127,i,"Micromite2",2,OLED_INVERSE)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    FOR i=16 TO 128 STEP 16
      OLED.PString(i,0,"RIGHT",2,OLED_RT_RIGHT)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    FOR i=104 TO 0 STEP -24
      OLED.PString(i,63,"LEFT",3,OLED_RT_LEFT)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

' test drawing rectangles
    FOR i=0 TO 3 
      OLED.SetRot(i) 
      OLED.FRect(5,5,10,15) 
      OLED.DRect(2,2,16,21)
    NEXT i 
    OLED.Refresh 

    PAUSE 2000 
    OLED.Cls

    ' test drawing rounded rectangles
    FOR i=0 TO 3
      OLED.SetRot(i)
      OLED.FRndrect(5,5,10,15,4)
      OLED.DRndrect(2,2,16,21,6)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    ' test drawing circles
    FOR i=0 TO 3
      OLED.SetRot(i)
      OLED.FCirc(10,10,7)
      OLED.DCirc(10,10,9)
    NEXT i
    OLED.Refresh
    PAUSE 2000
    OLED.Cls

    ' test drawing triangles and line drawing
    FOR i=0 TO 3
      OLED.SetRot(i)
      OLED.FTri(4,4,20,6,12,14)
      OLED.DTri(0,3,24,4,12,17)
    NEXT i
    OLED.Refresh
    PAUSE 2000

    ' test character output and string output at all orientations
    FOR sz=1 TO 3
      OLED.Cls
      OLED.SetRot(OLED_NORMAL)
      xfs=0
      yfs=0
      OLED.PString(xfs,yfs,"nr",sz,OLED_NORMAL)
      OLED.PString(xfs,yfs,"g",sz,OLED_NORMAL)
      OLED.PString(OLED_rot_wi-1,OLED_rot_ht-1,"Iv",sz,OLED_INVERSE)
      OLED.PString(OLED_rot_wi-1,0,"Rr",sz,OLED_RT_RIGHT)
      OLED.PString(0,OLED_rot_ht-1,"Rl",sz,OLED_RT_LEFT)
      OLED.Refresh
      PAUSE 1000
      OLED.Cls
      OLED.SetRot(OLED_INVERSE)
      xfs=0
      yfs=0
      OLED.PString(xfs,yfs,"nr",sz,OLED_NORMAL)
      OLED.PString(xfs,yfs,"g",sz,OLED_NORMAL)
      OLED.PString(OLED_rot_wi-1,OLED_rot_ht-1,"Iv",sz,OLED_INVERSE)
      OLED.PString(OLED_rot_wi-1,0,"Rr",sz,OLED_RT_RIGHT)
      OLED.PString(0,OLED_rot_ht-1,"Rl",sz,OLED_RT_LEFT)
      OLED.Refresh
      PAUSE 1000
      OLED.Cls
      OLED.SetRot(OLED_RT_RIGHT)
      xfs=0
      yfs=0
      OLED.PString(xfs,yfs,"nr",sz,OLED_NORMAL)
      OLED.PString(xfs,yfs,"g",sz,OLED_NORMAL)
      OLED.PString(OLED_rot_wi-1,OLED_rot_ht-1,"Iv",sz,OLED_INVERSE)
      OLED.PString(OLED_rot_wi-1,0,"Rr",sz,OLED_RT_RIGHT)
      OLED.PString(0,OLED_rot_ht-1,"Rl",sz,OLED_RT_LEFT)
      OLED.Refresh
      PAUSE 1000
      OLED.Cls
      OLED.SetRot(OLED_RT_LEFT)
      xfs=0
      yfs=0
      OLED.PString(xfs,yfs,"nr",sz,OLED_NORMAL)
      OLED.PString(xfs,yfs,"g",sz,OLED_NORMAL)
      OLED.PString(OLED_rot_wi-1,OLED_rot_ht-1,"Iv",sz,OLED_INVERSE)
      OLED.PString(OLED_rot_wi-1,0,"Rr",sz,OLED_RT_RIGHT)
      OLED.PString(0,OLED_rot_ht-1,"Rl",sz,OLED_RT_LEFT)
      OLED.Refresh
      PAUSE 1000
    NEXT sz
  LOOP
   
END SUB
