
option explicit
option default NONE
'
const NSAMPLES=9 'number of times to sample each touch point
const t_CS=4 'chip select pin for XPT2046 touch controller
const T_IRQ=5 'interrupt pin for XPT2046 touch controller 
DIM INTEGER XLEFT0, XRIGHT0, YTOP0, YBOTTOM0 ' global variables to hold calibration values
DIM INTEGER XLEFT, XRIGHT, YTOP, YBOTTOM ' global variables to hold active values
DIM INTEGER xvalues(NSAMPLES-1),yvalues(NSAMPLES-1)' arrays to hold raw sample values
pin(t_CS)=1
setpin t_irq,din
setpin t_cs,dout
CONST default_rotation=2 'default screen orientation for this display type, in this case landscape
const screen_width=800 'width of display in use
const screen_height=480 'height of display in use
dim integer width=screen_width, height=screen_height 'set active values based on default orientation
' 0=portrait, 1=portrait inverted, 2=landscale, 3=landscape inverted
DIM integer XSAMPLE0=&H90 'parameters to hold XPT commands, these may be reversed by the calibration routine
'for a particular application these values can be saved and set as constants
DIM integer YSAMPLE0=&HD0
DIM INTEGER XSAMPLE, YSAMPLE
'
dim integer x,y 'main program variables
' ARM
'spi OPEN 1000000,3
'spi2 OPEN 1000000,3
spi3 open 1000000,3
' MX470
'spi OPEN 1000000,3,8
'spi2 OPEN 1000000,3,8
' MX170
'spi OPEN 1000000,3,8
'
display open ssd1963,1,2,3,16,screen_width,screen_height
'
T.calibrate 'calibrate the touch sensor
xleft=xleft0: xright=xright0 : ytop=ytop0 : ybottom=ybottom0 ' set the parameters for the default orientation
'for a particular application these values can be saved and set as constants
T.rotate(1)
display 0,0,0,&H07E0,0,"Top left",(height+width)/200,(height+width)/200
main:
if t.screenpos(x,y,1000) then
  if x>3 and x<width-3 and y>3 and y<height-3 then circle x,y,3,&HFFFF,f
endif
goto main

sub T.rotate(r as integer) 'rotate the screen to a particular orientation and remap the touch coordinates
  local integer temp
  rotate r 'set the screen rotation
  if default_rotation\2=r\2 then
    XSAMPLE=XSAMPLE0
    YSAMPLE=YSAMPLE0
    width=screen_width
    height=screen_height
    if r=default_rotation then
      xleft=xleft0: xright=xright0 : ytop=ytop0 : ybottom=ybottom0
    else
      xleft=xright0: xright=xleft0 : ytop=ybottom0 : ybottom=ytop0
    endif
  else
    XSAMPLE=YSAMPLE0
    YSAMPLE=XSAMPLE0
    width=screen_height
    height=screen_width
    if ((r mod 2) = (default_rotation mod 2)) then
      if default_rotation=2 then
         xleft=ybottom0
         xright=ytop0
         ytop=xleft0
         ybottom=xright0
       else
         xleft=ytop0
         xright=ybottom0
         ytop=xright0
         ybottom=xleft0
       endif
    else
      if default_rotation=0 then
         xleft=ybottom0
         xright=ytop0
         ytop=xleft0
         ybottom=xright0
       else
         xleft=ytop0
         xright=ybottom0
         ytop=xright0
         ybottom=xleft0
       endif
     endif
   endif
end sub
'
sub T.calibrate 'gets the orientation correct and then sets global variables XLEFT0, XRIGHT0, YTOP0, YBOTTOM0
  LOCAL integer x,y,refsize=(height+width)/100, refoffset=refsize\2, charsize=refsize\3
  print ""
  XSAMPLE=XSAMPLE0
  YSAMPLE=YSAMPLE0
  if (refsize mod 2) then refsize=refsize+1
  if charsize=0 then charsize=1
  SWITCHXY:
  box 0,height\2-refoffset,refsize,refsize,&Hffff,f
  display 0,width\2-charsize*4*6,height\2-charsize*4,&H07E0,0,"Touch box",charsize,charsize
  T.gettouch(xleft0,y)
  if xleft0>500 and xleft0<1500 then 'Switching orientation
    XSAMPLE0=&HD0:XSAMPLE=XSAMPLE0
    YSAMPLE0=&H90:YSAMPLE=YSAMPLE0
    GOTO SWITCHXY
  endif
  PRINT "XSAMPLE0=",hex$(XSAMPLE0)
  PRINT "YSAMPLE0=",HEX$(YSAMPLE0)
  print "XLEFT0=",xleft0
  cls : pause 1000
  box width-refsize,height\2-refoffset,refsize,refsize,&Hffff,f
  display 0,width\2-charsize*4*6,height\2-charsize*4,&H07E0,0,"Touch box",charsize,charsize
  T.gettouch(xright0,y)
  print "XRIGHT0=",xright0
  cls : pause 1000
  box width\2-refoffset,0,refsize,refsize,&Hffff,f
  display 0,width\2-charsize*4*6,height\2-charsize*4,&H07E0,0,"Touch box",charsize,charsize
  T.gettouch(x,ytop0)
  print "YTOP0=",ytop0
  cls : pause 1000
  box width\2-refoffset,height-refsize,refsize,refsize,&Hffff,f
  display 0,width\2-charsize*4*6,height\2-charsize*4,&H07E0,0,"Touch box",charsize,charsize
  T.gettouch(x,ybottom0)
  print "YBOTTOM0=",ybottom0
  cls : pause 1000
end sub
'
function T.screenpos(x as integer, y as integer, timeout as integer) as integer
  local integer j
  IF T.getxy(xvalues(),yvalues(),timeout,NSAMPLES)<>0 then
      j=shellsortARM(xvalues(),NSAMPLES) 'uncomment to use sort as required
'      j=shellsortMX(xvalues(),NSAMPLES) 'uncomment to use sort as required
      j=shellsortARM(yvalues(),NSAMPLES) 'uncomment to use sort as required
'      j=shellsortMX(yvalues(),NSAMPLES) 'uncomment to use sort as required
      x=xvalues(NSAMPLES\2) 'get the median value
      y=yvalues(NSAMPLES\2) 'get the median value
      if xleft>xright then 'x coordinates reversed
        if x<xright then x=xright
        if x>xleft then x=xleft
        x=width-((x-xright)*width/(xleft-xright))
      else 'x coordinates normal
        if x<xleft then x=xleft
        if x>xright then x=xright
        x=(x-xleft)*width/(xright-xleft)
      endif
      if ytop>ybottom then ' y coordinates reversed
        if y>ytop then y=ytop
        if y<ybottom then y=ybottom
        y=height-((y-ybottom)*height/(ytop-ybottom))
      else 'y coordinates normal 
        if y<ytop then y=ytop
        if y>ybottom then y=ybottom
        y=(y-ytop)*height/(ybottom-ytop)
      endif
      T.screenpos=1
   else
      T.screenpos=0
   endif
end function

sub T.gettouch(x as integer, y as integer)
  local integer j, n=51,xvalues(n-1),yvalues(n-1)
loophere:
  x=-500
  IF T.getxy(xvalues(),yvalues(),1000,n)<>0 then
      j=shellsortARM(xvalues(),n) 'change to use sort as required
'      j=shellsortMX(xvalues(),n) 'change to use sort as required
      j=shellsortARM(yvalues(),n) 'change to use sort as required
'      j=shellsortMX(yvalues(),n) 'change to use sort as required
      x=xvalues(n\2) 'get the median value
      y=yvalues(n\2) 'get the median value
   endif
   if x=-500 then goto loophere
end sub
'
function T.Getdata(command as integer) as integer 'get data from the touch controller
  local integer i,j,k
  pin(T_CS)=0
  i=spi3(command)
  j=spi3(0)
  k=spi3(0)
  pin(T_CS)=1
  T.Getdata= (j*256+k)>>4
end function
'
function T.getxy(x() as integer, y() as integer, timeout as integer, samples as integer) as integer
  local integer i
  timer=0
  T.getxy=1
  for i=0 to samples-1
    do while timer<timeout and pin(T_IRQ)=1:loop
    if timer>=timeout then 
      T.getxy=0
    else
      y(i)=T.getdata(YSAMPLE)
      x(i)=T.getdata(XSAMPLE)
    endif
  next i
end function
'
'CFunction shellsortMX
'	00000000
'	8ca20000 27bdfff8 afb10004 afb00000 00401821 00032fc2 00a31821 00031843 
'	5060003d 00001021 0062282a 10a0fffa 00032fc2 00036823 000370c0 000d60c0 
'	008e7021 0080c021 008c8021 00607821 0000c821 01e3282a 01c03021 8dd10000 
'	14a0001e 8dcb0004 8f070004 03202821 0167402a 11000034 8f090000 01e04021 
'	000840c0 00884021 00a3502a 02003021 ad090000 1540000f ad070004 8cc70004 
'	8cc90000 0167402a 00ad5021 1100001f 00cc3021 00a04021 01402821 000840c0 
'	00884021 00a3502a ad090000 1140fff3 ad070004 000528c0 00853021 25ef0001 
'	01e2282a acd10000 accb0004 27390001 25ce0008 27180008 14a0ffd6 26100008 
'	00032fc2 00a31821 00031843 1460ffc7 0062282a 00001021 00001821 8fb10004 
'	8fb00000 03e00008 27bd0008 14ebffe9 0229402b 5100ffe8 000528c0 00a04021 
'	1000ffde 01402821 54ebffe5 25ef0001 0229402b 5500ffca 01e04021 1000ffe0 
'	25ef0001 
'End CFunction

CFunction shellsortARM
	00000000
	b089b480 6078af00 683b6039 2300e9d3 613b4613 61fb693b 69fbe040 e03961bb 
	00db69bb 4413687a 2300e9d3 2302e9c7 617b69bb 697be011 687a00db 697a18d1 
	1ad369fb 687a00db e9d34413 e9c12300 697a2300 1ad369fb 697a617b 429a69fb 
	697adb0d 1ad369fb 687a00db e9d34413 e9d72300 42900102 0303eb71 697bdbdb 
	687a00db e9d718d1 e9c12302 69bb2300 61bb3301 693b69ba dbc1429a 0fda69fb 
	105b4413 69fb61fb d1b62b00 0200f04f 0300f04f 46194610 46bd3724 7b04f85d 
	bf004770 
End CFunction
