'************************************************************************************* 
' 
' Peter Mather
' 
' 1.2 
' 2015-4-27 
' 
' Graphics library with drivers for ILI9163C TFT 1.44" 128x128 display
' NB cFunctioms are the same as for ILI9341 serial display
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub T144.setrot(x) ;T144_normal=normal, T144_inverse=invert, T144_rt_right=rotate right, T144_rt_left=rotate left
' draw circle: sub T144.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub T144.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub T144.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub T144.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub T144.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' print 8x5 bitmap: sub I9341.pbitmap(xx0, yy0, char, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, bitmap, size, character orientation,  foreground colour,  background colour
' draw line: sub T144.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub T144.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub T144.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub T144.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub T144.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option default none
option explicit
cpu 48
T144.init
do
  T144_test
loop
end
'
sub T144.init
'Global "Constants"
' 44-pin
'  const T144_CS=11 'b13
'  const T144_CD=15 'b15
'  const T144_RESET=30 'a02
' 28-pin
  const T144_CS=24 'b13
  const T144_CD=26 'b15
  const T144_RESET=2 
'
  const CMD_NOP     	=&H00'Non operation
  const CMD_SWRESET 	=&H01'Soft Reset
  const CMD_SLPIN   	=&H10'Sleep ON
  const CMD_SLPOUT  	=&H11'Sleep OFF
  const CMD_PTLON   	=&H12'Partial Mode ON
  const CMD_NORML   	=&H13'Normal Display ON
  const CMD_DINVOF  	=&H20'Display Inversion OFF
  const CMD_DINVON   	=&H21'Display Inversion ON
  const CMD_GAMMASET 	=&H26'Gamma Set (=&H01[1],=&H02[2],=&H04[3],=&H08[4])
  const CMD_DISPOFF 	=&H28'Display OFF
  const CMD_DISPON  	=&H29'Display ON
  const CMD_IDLEON  	=&H39'Idle Mode ON
  const CMD_IDLEOF  	=&H38'Idle Mode OFF
  const CMD_CLMADRS   	=&H2A'Column Address Set
  const CMD_PGEADRS   	=&H2B'Page Address Set
  const CMD_RAMWR   	=&H2C'Memory Write
  const CMD_RAMRD   	=&H2E'Memory Read
  const CMD_CLRSPACE   	=&H2D'Color Space : 4K/65K/262K
  const CMD_PARTAREA	=&H30'Partial Area
  const CMD_VSCLLDEF	=&H33'Vertical Scroll Definition
  const CMD_TEFXLON		=&H35'Tearing Effect Line ON
  const CMD_TEFXLOF		=&H34'Tearing Effect Line OFF
  dim integer CMD_MADCTL  	=&H36'Memory Access Control
  const CMD_VSSTADRS	=&H37'Vertical Scrolling Start address
  const CMD_PIXFMT  	=&H3A'Interface Pixel Format
  const CMD_FRMCTR1 	=&HB1'Frame Rate Control (In normal mode/Full colors)
  const CMD_FRMCTR2 	=&HB2'Frame Rate Control(In Idle mode/8-colors)
  const CMD_FRMCTR3 	=&HB3'Frame Rate Control(In Partial mode/full colors)
  const CMD_DINVCTR		=&HB4'Display Inversion Control
  const CMD_RGBBLK		=&HB5'RGB Interface Blanking Porch setting
  const CMD_DFUNCTR 	=&HB6'Display Fuction set 5
  const CMD_SDRVDIR 	=&HB7'Source Driver Direction Control
  const CMD_GDRVDIR 	=&HB8'Gate Driver Direction Control 
  const CMD_PWCTR1  	=&HC0'Power_Control1
  const CMD_PWCTR2  	=&HC1'Power_Control2
  const CMD_PWCTR3  	=&HC2'Power_Control3
  const CMD_PWCTR4  	=&HC3'Power_Control4
  const CMD_PWCTR5  	=&HC4'Power_Control5
  const CMD_VCOMCTR1  	=&HC5'VCOM_Control 1
  const CMD_VCOMCTR2  	=&HC6'VCOM_Control 2
  const CMD_VCOMOFFS  	=&HC7'VCOM Offset Control
  const CMD_PGAMMAC		=&HE0'Positive Gamma Correction Setting
  const CMD_NGAMMAC		=&HE1'Negative Gamma Correction Setting
  const CMD_GAMRSEL		=&HF2'GAM_R_SEL
  dim integer _TFTWIDTH  	=	128'the REAL W resolution of the TFT
  dim integer _TFTHEIGHT 	=	128'the REAL H resolution of the TFT
'  
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer T144.pix=0
  dim integer T144.ffr=1
  dim integer T144.filltri=2
  dim integer T144.drawline=3
  dim integer T144.wcom=4
  dim integer T144.wdata=5
  dim integer T144.fastfillscreen=6
  dim integer T144.fpstring=7
  dim integer T144.fcirch=8
  dim integer T144.dcirch=9
  dim integer T144_normal=0
  dim integer T144_inverse=1
  dim integer T144_rt_right=2
  dim integer T144_rt_left=3
  dim integer T144_AddrOfFont, T144_params(6) ' Global variables
  dim integer _Mactrl_Data = 0
  DIM integer T144_wi=0,T144_ht=1,T144_rot=2,T144_nr=3,T144_X=4,T144_Y=5,T144_seed=6  
  dim integer pGammaSet(14)= (&H36,&H29,&H12,&H22,&H1C,&H15,&H42,&HB7,&H2F,&H13,&H12,&H0A,&H11,&H0B,&H06)
  dim integer nGammaSet(14)= (&H09,&H16,&H2D,&H0D,&H13,&H15,&H40,&H48,&H53,&H0C,&H1D,&H25,&H2E,&H34,&H39)
  local integer i,j
  spi open 10000000,3,8
  T144_params(T144_wi)=_TFTWIDTH
  T144_params(T144_ht)=_TFTHEIGHT
  T144_AddrOfFont=PEEK(CFunAddr FONT)  
  pin(T144_CS)=1
  setpin T144_CS, DOUT
  pin(T144_CD)=1
  setpin T144_CD, DOUT
  pin(T144_RESET)=1
  setpin T144_RESET, DOUT'  Reset the display
  pin(T144_RESET)=0
  pause 100
  pin(T144_RESET)=1
  pause 100
  i=T144draw(T144.wcom,CMD_SWRESET)'software reset
  pause 500
  i=T144draw(T144.wcom,CMD_SLPOUT)'exit sleep
  pause 5
  i=T144draw(T144.wcom,CMD_PIXFMT)'Set Color Format 16bit   
  i=T144draw(T144.wdata,&H05)
  pause 5
  i=T144draw(T144.wcom,CMD_GAMMASET)'default gamma curve 3
  i=T144draw(T144.wdata,&H04)'&H04
  pause 1
  i=T144draw(T144.wcom,CMD_GAMRSEL)'Enable Gamma adj    
  i=T144draw(T144.wdata,&H01) 
  pause 1
  i=T144draw(T144.wcom,CMD_NORML)
  i=T144draw(T144.wcom,CMD_DFUNCTR)
  i=T144draw(T144.wdata,&B11111111)'
  i=T144draw(T144.wdata,&B00000110)'
  i=T144draw(T144.wcom,CMD_PGAMMAC)'Positive Gamma Correction Setting
  for j=0 to 14
	i=T144draw(T144.wdata,pGammaSet(j))
  next j
  i=T144draw(T144.wcom,CMD_NGAMMAC)'Negative Gamma Correction Setting
  for j=0 to 14
	i=T144draw(T144.wdata,nGammaSet(j))
  next j
  i=T144draw(T144.wdata,&H08)'&H0C'&H08
  i=T144draw(T144.wdata,&H02)'&H14'&H08
  pause 1
  i=T144draw(T144.wcom,CMD_DINVCTR)'display inversion 
  i=T144draw(T144.wdata,&H07)
  pause 1
  i=T144draw(T144.wcom,CMD_PWCTR1)'Set VRH1[4:0] & VC[2:0] for VCI1 & GVDD   
  i=T144draw(T144.wdata,&H0A)'4.30 - &H0A
  i=T144draw(T144.wdata,&H02)'&H05
  pause 1
  i=T144draw(T144.wcom,CMD_PWCTR2)'Set BT[2:0] for AVDD & VCL & VGH & VGL   
  i=T144draw(T144.wdata,&H02)
  pause 1
  i=T144draw(T144.wcom,CMD_VCOMCTR1)'Set VMH[6:0] & VML[6:0] for VOMH & VCOML   
  i=T144draw(T144.wdata,&H50)'&H50
  i=T144draw(T144.wdata,99)'&H5b
  pause 1
  i=T144draw(T144.wcom,CMD_VCOMOFFS)
  i=T144draw(T144.wdata,0)'&H40
  pause 1
  i=T144draw(T144.wcom,CMD_CLMADRS)'Set Column Address  
  writedata16(&H00) 
  writedata16(_TFTWIDTH) 
  i=T144draw(T144.wcom,CMD_PGEADRS)'Set Page Address  
  writedata16(&H00) 
  writedata16(_TFTHEIGHT)
' set scroll area
  i=T144draw(T144.wcom,CMD_VSCLLDEF)
  writedata16(&H00)
  writedata16(_TFTHEIGHT)
  writedata16(0)
  i=T144draw(T144.wcom,CMD_DISPON)'display ON 
  pause 1
  i=T144draw(T144.wcom,CMD_RAMWR)'Memory Write
  pause 1
  T144.setrot(0)
  T144.fillscreen(black)
end sub
'
sub writedata16(d as integer)
  local integer i=T144draw(T144.wdata,d>>8)
  i=i=T144draw(T144.wdata,d)
end sub
'
sub T144.setrot(x%) 'sets screen rotation: 0=T144_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer i,R(3)=(&B00001000,&B11001000,&B01101000,&B10101000)
   x%=x% and 3
   T144_params(T144_rot)=x%
   i=T144draw(T144.wcom,CMD_MADCTL)'memory access control (directions)
   i=T144draw(T144.wdata,R(x%))
end sub
'
' Generic drawing routines
'
sub T144.fillscreen(scol as integer)
  local integer i=T144_params(T144_rot)
  T144_params(T144_rot)=T144_normal
  local integer j=T144draw(T144.ffr,scol, 0,0,_TFTWIDTH,_TFTHEIGHT, T144_params())
  T144_params(T144_rot)=i
end sub
'
sub T144.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=T144draw(T144.dcirch, colour,x0,y0,r,31,T144_params())

end sub
 '
sub T144.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  T144.dline(x0, y0, x1, y1, colour)
  T144.dline(x1, y1, x2, y2, colour)
  T144.dline(x2, y2, x0, y0, colour)
end sub
 '
sub T144.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer i=T144draw(T144.filltri, x0,y0,x1,y1,x2,y2,colour,T144_params())

end sub
sub T144.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T144draw(T144.fpstring,T144_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T144_params(),text$)
end sub
'
sub T144.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=T144draw(T144.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T144_params(),"")
end sub
'
sub T144.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=T144draw(T144.drawline, colour, xx0, yy0, xx1, yy1,  T144_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub T144.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=T144draw(T144.ffr, rcolour, x, y, w, 1,  T144_params()) 
  a=y+h-1
  dp=T144draw(T144.ffr, rcolour, x, a, w, 1,  T144_params()) 
  dp=T144draw(T144.ffr, rcolour, x, y, 1, h,  T144_params()) 
  a=x+w-1
  dp=T144draw(T144.ffr, rcolour, a, y, 1, h,  T144_params()) 
end sub
'
sub T144.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=T144draw(T144.ffr, rcolour, x, y, w, h,  T144_params()) 
end sub
'
FUNCTION T144.Getchar(char as integer) as integer
  local integer i=char<<3
  T144.Getchar=PEEK(WORD T144_AddrOfFont+i)+(PEEK(WORD T144_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub T144.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=T144draw(T144.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T144_params())
  dp=T144draw(T144.fcircH,x0, y0, r, 3, 0, ccolour, T144_params())
end sub
 '
sub T144.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T144draw(T144.ffr, rcolour, x+r, y, w-2*r, 1,  T144_params()) 
  dp=T144draw(T144.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T144_params()) 
  dp=T144draw(T144.ffr, rcolour, x, y+r, 1, h-2*r,  T144_params()) 
  dp=T144draw(T144.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T144_params()) 
  dp=T144draw(T144.dcirch, rcolour, x+r, y+r, r, 1,T144_params())
  dp=T144draw(T144.dcirch,  rcolour, x+w-r-1, y+r, r, 2,T144_params())
  dp=T144draw(T144.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,T144_params())
  dp=T144draw(T144.dcirch,  rcolour, x+r, y+h-r-1, r, 8,T144_params())
end sub
'
sub T144.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T144draw(T144.ffr, colour, x+r, y, w-2*r, h,  T144_params()) 
  dp=T144draw(T144.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, T144_params())
  dp=T144draw(T144.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, T144_params())
end sub
'
'C:\Users\Peter\Dropbox\MPLABXProjects\ILI9341ST7735ser.X\dist\default\production\T144draw.bas

'
'T144draw  2015-01-23 19:16:01 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction T144draw
'writeCommand
	000006AF
	3c02bf88 24032000 ac436134 34038000 ac436134 3c02bf80 ac445820 3c03bf80 
	8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 3c02bf80 8c425820 
	03e00008 00000000 

'writeData
3c02bf88 24032000 ac436134 34038000 ac436138 3c02bf80 
	ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24032000 ac436138 
	3c02bf80 8c425820 03e00008 00000000 

'colourrect
27bdffc8 afbf0034 afbe0030 afb7002c 
	afb60028 afb50024 afb40020 afb3001c afb20018 afb10014 afb00010 0080a021 
	00a09821 8fa40048 8fa50058 8fa30060 8c620000 8c630008 00c0a821 0080f021 
	24d0ffff 8fa70050 04c10004 02078021 24c60002 02068021 0000a821 0202382a 
	2446ffff 00c7800a 2491ffff 07c10004 02258821 24840002 02248821 0000f021 
	0223282a 2464ffff 0085880a 0000b021 0600005e 0000b821 0620005c 02a2102a 
	1040005a 03c3182a 50600059 02c01021 24020001 00551823 00701821 005e9023 
	02519021 72439002 2404002a 00002821 0411FFA3 00000000 7ea43a00 00002821 
	0411FFB1 00000000 32a400ff 00002821 0411FFAD 00000000 7e043a00 00002821 
	0411FFA9 00000000 320400ff 00002821 0411FFA5 00000000 2404002b 00002821 
	0411FF8F 00000000 7fc43a00 00002821 0411FF9D 00000000 33c400ff 00002821 
	0411FF99 00000000 7e243a00 00002821 0411FF95 00000000 322400ff 00002821 
	0411FF91 00000000 2404002c 00002821 0411FF7B 00000000 3c02bf88 34038000 
	ac436138 24032000 ac436134 00002021 2406ffff 3c08bf88 24072000 3c02bf80 
	10000013 0014a02b ad076134 000428c0 02652821 90a30001 ac435820 8c435810 
	30630080 1060fffd 00000000 8c435820 90a30000 ac435820 8c435810 30630080 
	1060fffd 00000000 8c435820 00942021 2652ffff 1646ffec 24032000 3c02bf88 
	ac436138 0080b021 0000b821 02c01021 02e01821 8fbf0034 8fbe0030 8fb7002c 
	8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014 8fb00010 03e00008 
	27bd0038 

'localfastfillrect
27bdffb8 afbf0044 afa40030 afa50034 8fa20058 8fa3005c afa20010 
	afa30014 8fa20060 8fa30064 afa20018 afa3001c 8fa20068 8fa3006c afa20020 
	afa30024 8fa20070 afa20028 00002021 27a50030 0411FF56 00000000 00021fc3 
	8fbf0044 03e00008 27bd0048 

'localdrawPixel
27bdffd8 afbf0024 afb30020 afb2001c afb10018 
	afb00014 00808821 00c08021 8fb30038 8fa20040 8c440004 1c800008 24030001 
	54800006 00001821 8c440000 00c4202b 14800003 306300ff 00001821 306300ff 
	10600049 00002021 8c44000c 1c800008 24030001 54800006 00001821 8c420008 
	0262102b 14400003 306300ff 00001821 306300ff 5060003c 00002021 2404002a 
	00002821 0411FF06 00000000 7e123a00 02402021 00002821 0411FF13 00000000 
	321000ff 02002021 00002821 0411FF0E 00000000 02402021 00002821 0411FF0A 
	00000000 02002021 00002821 0411FF06 00000000 2404002b 00002821 0411FEF0 
	00000000 7e723a00 02402021 00002821 0411FEFD 00000000 327000ff 02002021 
	00002821 0411FEF8 00000000 02402021 00002821 0411FEF4 00000000 02002021 
	00002821 0411FEF0 00000000 2404002c 00002821 0411FEDA 00000000 7e243a00 
	00002821 0411FEE8 00000000 322400ff 00002821 0411FEE4 00000000 24040001 
	10000002 00002821 00002821 00801021 00a01821 8fbf0024 8fb30020 8fb2001c 
	8fb10018 8fb00014 03e00008 27bd0028 

'swap
8c820000 8ca30000 ac830000 03e00008 
	aca20000 

'drawline
27bdffa8 afbf0054 afb70050 afb6004c afb50048 afb40044 afb30040 
	afb2003c afb10038 afb00034 0080a021 00a0a821 8fa40068 8fa20070 8fa30078 
	8fb30080 afa60020 afa40024 afa20028 afa3002c 0083882a 00642823 00831823 
	0071280a 00c2202a 00461823 00c21023 0064100b 0045882a 1220000a 8fa20028 
	27a40020 27a50024 0411FFD9 00000000 27a40028 27a5002c 0411FFD5 00000000 
	8fa20028 8fa30020 0043102a 1040000a 8fa30028 27a40020 27a50028 0411FFCC 
	00000000 27a40024 27a5002c 0411FFC8 00000000 8fa30028 8fa20020 8fa4002c 
	8fb20024 0244282a 10a00007 0062b023 00929023 001687c2 02168021 00108043 
	10000006 24170001 02449023 001687c2 02168021 00108043 2417ffff 0062182a 
	14600028 8fbf0054 1220000e 8fa30024 8fa70024 afa20010 000217c3 afa20014 
	afb30018 02802021 02a02821 00e03021 00073fc3 0411FF3D 00000000 1000000c 
	02128023 afa30010 00031fc3 afa30014 afb30018 02802021 02a02821 00403021 
	00023fc3 0411FF31 00000000 02128023 06010006 8fa20020 8fa20024 00571021 
	afa20024 02168021 8fa20020 24420001 afa20020 8fa30028 0062182a 1060ffda 
	8fbf0054 8fb70050 8fb6004c 8fb50048 8fb40044 8fb30040 8fb2003c 8fb10038 
	8fb00034 03e00008 27bd0058 

'drawchar
27bdfde0 afbf021c afbe0218 afb70214 afb60210 
	afb5020c afb40208 afb30204 afb20200 afb101fc afb001f8 00c0b821 8fb00238 
	afa401b8 afa501bc 8fa4023c 14800067 00e0f021 0200b021 8fa50234 afa501c8 
	afa001dc afa001e0 27a601b7 afa601c0 00108fc3 000717c3 afa201d4 00171fc3 
	afa301d8 afb701cc afa701d0 02009821 10000041 0220b821 92020000 02821024 
	10400018 00000000 56750006 afbe0010 8fa401cc ae440000 8fa501d8 10000026 
	ae450004 8fa601c4 afa60014 afb30018 afb7001c afb30020 afb70024 8fa20240 
	afa20028 8fa401cc 8fa501d8 02203021 00113fc3 0411FEC3 00000000 10000017 
	2610ffff 56750006 afbe0010 8fa301d0 ae430000 8fa401d4 1000000f ae440004 
	8fa501c4 afa50014 afb30018 afb7001c afb30020 afb70024 8fa60240 afa60028 
	8fa401d0 8fa501d4 02203021 00113fc3 0411FEAC 00000000 2610ffff 02368821 
	8fa201c0 1602ffcc 26520008 8fa301e0 24630006 afa301e0 8fa401dc 24840001 
	afa401dc 8fa501c8 00b62821 24020030 1062000f afa501c8 24140001 8fa601dc 
	00d4a004 8fbe01c8 001e17c3 afa201c4 27b001bd 8fb10230 8fa301e0 000390c0 
	27a40030 00929021 1000ffb3 24150001 8fb701cc 8fbe01d0 02608021 00131040 
	001318c0 10000082 00621023 24040001 8fa5023c 14a4007d 0200b021 8fa60234 
	24c60001 afa601f4 001010c0 00c21023 afa201d0 24020007 afa201dc afa001e0 
	8fa30230 24630001 afa301e4 00701823 00101080 00501021 00621023 afa201ec 
	27a401be afa401c0 00108fc3 00072fc3 afa501d8 afa701d4 02e0f021 02009821 
	10000042 0220b821 92020000 02821024 10400018 00000000 16750005 8fa201c4 
	ae5e0000 8fa601cc 10000028 ae460004 afa20010 8fa301c8 afa30014 afb30018 
	afb7001c afb30020 afb70024 8fa40240 afa40028 03c02021 8fa501cc 02203021 
	00113fc3 0411FE4F 00000000 10000018 26100001 16750006 8fa201c4 8fa501d4 
	ae450000 8fa601d8 10000010 ae460004 afa20010 8fa301c8 afa30014 afb30018 
	afb7001c afb30020 afb70024 8fa40240 afa40028 8fa401d4 8fa501d8 02203021 
	00113fc3 0411FE37 00000000 26100001 02368821 8fa501c0 1605ffcb 26520008 
	8fa601e0 24c60006 afa601e0 8fa201dc 2442ffff afa201dc 8fa301d0 00761821 
	24020030 10c20014 afa301d0 24140001 8fa401dc 0094a004 8fa501d0 afa501c4 
	000537c3 afa601c8 27b001b8 8fa201e4 afa201f0 8fb101ec 8fa301e0 000390c0 
	27a40030 00929021 24150001 001e2fc3 1000ffad afa501cc 03c0b821 8fbe01d4 
	02608021 001318c0 8fa601f4 00c33023 afa60234 00131040 00621023 8fa401f0 
	00822023 10000079 afa40230 afa001e0 24040002 8fa5023c 14a40076 24040003 
	0200a821 8fa60234 afa601dc 27b401bd 27a201b7 afa201c0 8fa301e0 afa301e8 
	8fa40230 24840001 afa401e4 001010c0 00821023 afa201f4 00108fc3 001e2fc3 
	afa501cc 001737c3 afa601d0 afb701d4 afbe01d8 02009821 10000042 0220f021 
	92820000 02021007 30420001 10400019 00000000 16760006 8fa401c4 8fa201d4 
	ae420000 8fa301d0 10000028 ae430004 afa40010 8fa501c8 afa50014 afb30018 
	afbe001c afb30020 afbe0024 8fa60240 afa60028 8fa401d4 8fa501d0 02203021 
	00113fc3 0411FDCF 00000000 10000018 2610ffff 16760006 8fa401c4 8fa201d8 
	ae420000 8fa301cc 10000010 ae430004 afa40010 8fa501c8 afa50014 afb30018 
	afbe001c afb30020 afbe0024 8fa60240 afa60028 8fa401d8 8fa501cc 02203021 
	00113fc3 0411FDB7 00000000 2610ffff 02358821 1617ffca 26520008 8fa201e8 
	24420008 afa201e8 8fa301dc 00751821 afa301dc 2694ffff 8fa401c0 52840010 
	02608021 8fa501dc afa501c4 000537c3 afa601c8 8fa201e4 afa201f0 8fb101f4 
	8fa301e8 000390c0 27a40030 00929021 24100007 24160001 1000ffb1 2417ffff 
	8fa501e0 24a50030 afa501e0 001318c0 8fa601f0 00c33023 afa60230 00601021 
	00132040 1000006d 00641823 24040003 8fa5023c 14a4006a 24040001 0200a821 
	00101840 001010c0 00621023 24420001 8fa60234 00c23021 afa60234 afa601d8 
	27b401b8 27a201be afa201c0 8fa301e0 afa301dc 00108fc3 001e27c3 afa401c8 
	00172fc3 afa501cc afb701d0 afbe01d4 02009821 10000040 0220b821 92820000 
	02021007 30420001 10400018 24060001 56660006 afbe0010 8fa201d0 ae420000 
	8fa301cc 10000026 ae430004 8fa401c4 afa40014 afb30018 afb7001c afb30020 
	afb70024 8fa50240 afa50028 8fa401d0 8fa501cc 02203021 00113fc3 0411FD59 
	00000000 10000017 26100001 56660006 afbe0010 8fa201d4 ae420000 8fa301c8 
	1000000f ae430004 8fa401c4 afa40014 afb30018 afb7001c afb30020 afb70024 
	8fa50240 afa50028 8fa401d4 8fa501c8 02203021 00113fc3 0411FD42 00000000 
	26100001 02358821 1616ffcc 26520008 8fa601dc 24c60008 afa601dc 8fa201d8 
	00551021 afa201d8 26940001 8fa301c0 5283000c 02608021 8fbe01d8 001e27c3 
	afa401c4 8fb10230 8fa501dc 000590c0 27a60030 00d29021 00008021 1000ffb7 
	24160008 8fa201e0 24420030 afa201e0 001310c0 00131840 00431823 24040001 
	56040015 8fa201e0 8fa40234 afa40010 000427c3 afa40014 afa20018 000217c3 
	afa2001c afa30020 00031fc3 afa30024 8fa60240 afa60028 24040001 27a50030 
	8fa60230 00063fc3 0411FC79 00000000 afa201e0 8fa201e0 00021fc3 8fbf021c 
	8fbe0218 8fb70214 8fb60210 8fb5020c 8fb40208 8fb30204 8fb20200 8fb101fc 
	8fb001f8 03e00008 27bd0220 

'pstring
27bdffa0 afbf005c afbe0058 afb70054 afb60050 
	afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 00c08021 8fa60070 
	afa6002c 8fa60078 afa60028 8fa90080 8fa60088 8fa70090 8fb50098 8fb4009c 
	02009821 8fb1002c 8fbe0028 01209021 00c0b821 afa40030 92880000 1100003c 
	00e0b021 19000063 24100001 001e1040 001e18c0 00621823 afa30028 00031023 
	afa2002c 39230003 afa30034 02901021 90420000 2443ffe0 306300ff 2c630060 
	50600008 00002021 2442ffe0 000210c0 8fa40030 00441021 8c440000 10000002 
	8c450004 00002821 afb30010 afb10014 afbe0018 afb2001c afb50020 02e03021 
	02c03821 0411FDC1 00000000 16400004 24060001 8fa50028 1000000a 02659821 
	16460003 8fa4002c 1000000a 02649821 24050002 16450003 8fa60028 10000005 
	02268821 8fa5002c 02252021 8fa60034 0086880a 26100001 92840000 0090202a 
	5080ffd3 02901021 1000002b aeb30020 afb00010 8fa2002c afa20014 8fa30028 
	afa30018 afa9001c afb50020 0411FD9F 00000000 16400007 24040001 8fa50028 
	00052040 000598c0 02649823 10000011 02139821 16440006 8fa60028 00069840 
	000620c0 02649823 10000012 02139821 24040002 16440007 8fa50028 00052040 
	000588c0 02248823 8fa6002c 10000009 00d18821 24040003 16440006 8fa40028 
	00048840 000420c0 02248823 8fa5002c 00b18821 aeb30020 00139fc3 aeb30024 
	aeb10028 00118fc3 aeb1002c 8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 
	8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 03e00008 27bd0060 

'dcirch
27bdffa0 
	afbf005c afbe0058 afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 
	afb1003c afb00038 afa40060 afa50064 00c0b021 8fb50070 8fb00078 8fa20080 
	8fb70088 afa60024 afb50028 afa20020 30420010 1040002a 02008821 000697c3 
	02151021 afa20010 000217c3 afa20014 afb70018 02403821 0411FC64 00000000 
	02b01023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 
	02403821 0411FC59 00000000 001597c3 02163821 afb50010 afb20014 afb70018 
	8fa40060 8fa50064 00e03021 00073fc3 0411FC4E 00000000 02d03823 afb50010 
	afb20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FC44 00000000 
	1a20008f 24110001 02308823 0010f023 001ef040 26b3ffff 26d4ffff 26b50001 
	26d60001 00009021 8fa20020 30420004 afa2002c 8fa30020 30630002 afa30030 
	8fa20020 30420008 afa20034 8fa30020 30630001 afa30020 06200004 8fa2002c 
	2610ffff 27de0002 023e8821 10400019 26520001 8fa30028 02031021 afa20010 
	000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 00163fc3 0411FC1B 
	00000000 8fa20024 02023821 afb50010 001517c3 afa20014 afb70018 8fa40060 
	8fa50064 00e03021 00073fc3 0411FC0F 00000000 8fa30030 1060001a 8fa30034 
	8fa30028 00701023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 
	02c03021 00163fc3 0411FC00 00000000 8fa20024 02023821 afb30010 001317c3 
	afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FBF4 00000000 
	8fa30034 1060001a 8fa20020 8fa20024 00503823 afb50010 001517c3 afa20014 
	afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FBE5 00000000 8fa30028 
	02031021 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02803021 
	00143fc3 0411FBD9 00000000 8fa20020 5040001a 2673ffff 8fa30024 00703823 
	afb30010 001317c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 
	0411FBCA 00000000 8fa30028 00701023 afa20010 000217c3 afa20014 afb70018 
	8fa40060 8fa50064 02803021 00143fc3 0411FBBE 00000000 2673ffff 2694ffff 
	26b50001 0250102a 10400005 26d60001 00121040 24420001 1000ff87 02228821 
	8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 
	8fb1003c 8fb00038 03e00008 27bd0060 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 
	afb60060 afb5005c afb40058 afb30054 afb20050 afb1004c afb00048 8fb10080 
	8fb40090 8fbe00a0 afa40038 afa6003c 8fa20088 1a200076 02801821 24100001 
	02118023 0011b823 0017b840 2495ffff 24d3ffff 26940003 24960001 00009021 
	30440001 afa40030 24630001 afa30040 30420002 afa20034 06000004 8fa20030 
	2631ffff 26f70002 02178021 1040002a 26520001 8fa3003c 00711023 afa20010 
	000217c3 afa20014 24020001 00001821 afa20018 afa3001c 00111040 8fa30040 
	00621021 afa20020 000217c3 afa20024 afbe0028 8fa40098 8fa5009c 02c03021 
	00163fc3 0411FB4F 00000000 8fa40038 02243821 afb30010 001317c3 afa20014 
	24020001 00001821 afa20018 afa3001c afb40020 001417c3 afa20024 afbe0028 
	8fa40098 8fa5009c 00e03021 00073fc3 0411FB3C 00000000 8fa30034 5060002b 
	26b5ffff 8fa4003c 00911023 afa20010 000217c3 afa20014 24020001 00001821 
	afa20018 afa3001c 00111040 8fa30040 00621021 afa20020 000217c3 afa20024 
	afbe0028 8fa40098 8fa5009c 02a03021 00153fc3 0411FB23 00000000 8fa40038 
	00913823 afb30010 001317c3 afa20014 24020001 00001821 afa20018 afa3001c 
	afb40020 001417c3 afa20024 afbe0028 8fa40098 8fa5009c 00e03021 00073fc3 
	0411FB10 00000000 26b5ffff 2673ffff 26940002 0251102a 10400005 26d60001 
	00121040 24420001 1000ff9b 02028021 8fbf006c 8fbe0068 8fb70064 8fb60060 
	8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'ftri
	27bdff88 afbf0074 afb70070 afb6006c afb50068 afb40064 afb30060 afb2005c 
	afb10058 afb00054 8fa20090 8fb400a8 8fb500ac 8fb100b0 afa40038 afa6003c 
	8fa30088 afa30040 afa20044 8fa30098 afa30048 8fa300a0 0046102a 10400009 
	afa3004c 27a4003c 27a50044 0411FB60 00000000 27a40038 27a50040 0411FB5C 
	00000000 8fa2004c 8fa30044 0043102a 1040000a 8fa20044 27a4004c 27a50044 
	0411FB53 00000000 27a40048 27a50040 0411FB4F 00000000 8fa20044 8fa3003c 
	0043102a 1040000a 8fb0003c 27a4003c 27a50044 0411FB46 00000000 27a40038 
	27a50040 0411FB42 00000000 8fb0003c 8fa2004c 1602002e 8fb20044 8fa20038 
	afa20030 afa20034 8fa30040 0062202a 10800003 0043102a 10000003 afa30030 
	54400001 afa30034 8fa20048 8fa30030 0043182a 10600003 8fa30034 10000004 
	afa20030 0062182a 54600001 afa20034 8fa70030 8fa2003c afa20010 000217c3 
	afa20014 24020001 00001821 afa20018 afa3001c 8fa20034 24420001 00471023 
	afa20020 000217c3 afa20024 afb10028 02802021 02a02821 00e03021 00073fc3 
	0411FA90 00000000 1000007a 8fbf0074 

'.LBB2
00521026 0002102b 02429023 0250102a 
	14400039 8fa2004c 24160001 0000b821 8fa20038 8fa3003c 02032823 8fa60040 
	00c23023 70a63002 8fa40044 00832023 00c4001a 008001f4 00002012 00822021 
	afa40030 8fa60048 00c23023 70a62802 8fa6004c 00c31823 00a3001a 006001f4 
	00001812 00621021 afa20034 0044102a 10400006 8fa70030 27a40030 27a50034 
	0411FAEB 00000000 8fa70030 afb00010 001017c3 afa20014 8fa20034 24420001 
	00471023 afa20018 000217c3 afa2001c afb60020 afb70024 afb10028 02802021 
	02a02821 00e03021 00073fc3 0411FA55 00000000 26100001 0250102a 1040ffcd 
	8fa20038 8fa2004c 0050182a 14600038 24120001 00009821 8fa60040 8fa40038 
	8fa50048 8fa80044 02083823 00a61823 70e33802 00484023 00e8001a 010001f4 
	00001812 00661821 afa30030 8fa7003c 02073023 00a42823 70c53002 00471023 
	00c2001a 004001f4 00001012 00442021 afa40034 0083202a 10800006 8fa70030 
	27a40030 27a50034 0411FAB1 00000000 8fa70030 afb00010 001017c3 afa20014 
	8fa20034 24420001 00471023 afa20018 000217c3 afa2001c afb20020 afb30024 
	afb10028 02802021 02a02821 00e03021 00073fc3 0411FA1B 00000000 26100001 
	8fa2004c 0050182a 1060ffcc 8fa60040 

'.LBE2
8fbf0074 8fb70070 8fb6006c 8fb50068 
	8fb40064 8fb30060 8fb2005c 8fb10058 8fb00054 03e00008 27bd0078 

'main
27bdffb8 
	afbf0044 afb00040 00808021 00e01021 8faa0058 8fa9005c 8fa80060 8fab0064 
	8c830000 8c840004 00643825 14e00010 8fac0068 8ca50000 8cc70000 8c420000 
	afa20010 000217c3 afa20014 afaa0018 00a02021 00052fc3 00e03021 00073fc3 
	0411FA0A 00000000 100000e4 8fbf0044 24070001 14670018 24070002 14800016 
	00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 
	afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 
	afa30024 afa80028 0411F9D6 00000000 100000ca 8fbf0044 14670021 24070003 
	1480001f 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 
	afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 8d220000 8d230004 
	afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 8d620000 8d630004 
	afa20030 afa30034 afac0038 0411FEBC 00000000 8e020000 100000a7 8e030004 
	14670019 24070004 14800017 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c420000 afa20010 000217c3 afa20014 8d420000 afa20018 000217c3 afa2001c 
	8d220000 afa20020 000217c3 afa20024 afa80028 0411FA23 00000000 8e020000 
	1000008d 8e030004 1467000a 24070005 14800008 00000000 8ca40000 8ca50004 
	0411F8D7 00000000 8e020000 10000082 8e030004 1467000a 24070007 14800008 
	00000000 8ca40000 8ca50004 0411F8DE 00000000 8e020000 10000077 8e030004 
	14670022 24070008 14800020 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 afa3001c 
	8d220000 8d230004 afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 
	8d620000 8d630004 afa20030 afa30034 afac0038 8fa2006c afa2003c 0411FC63 
	00000000 10000055 8fbf0044 1467001d 24070009 1480001b 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 
	8d430004 afa20018 afa3001c 8d220000 8d230004 afa20020 afa30024 8d020000 
	8d030004 afa20028 afa3002c afab0030 0411FDB7 00000000 8e020000 10000036 
	8e030004 14670019 2407000a 14800017 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d420000 8d430004 afa20018 
	afa3001c 8d220000 8d230004 afa20020 afa30024 afa80028 0411FCC0 00000000 
	8e020000 1000001c 8e030004 1467001b 8fbf0044 1480001a 8fb00040 8ca40000 
	8c430004 8c420000 8d4c0000 8d4d0004 afac0010 afad0014 8d2c0000 8d2d0004 
	afac0018 afad001c 8d090004 8d080000 afa80020 afa90024 afab0028 00c02821 
	00403021 00603821 0411F879 00000000 10000002 8fbf0044 8fbf0044 8fb00040 
	03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
End CFunction
'
'
sub T144_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  T144.fillscreen(black)
  T144.setrot(T144_normal)
  T144.pbitmap(58, 2, &HFF81818181FF, 1, 0, green, black)
  T144.pstring(24, 12, "Welcome to the", 1, 0, green, black)
  T144.pstring(8, 30, "Micromite", 2, 0, red, black)
  T144.pstring(44,50,"MK2",2,0,red,black)
  T144.pstring(8, 80, "in colour", 2, 0, yellow, black)
  T144.pstring(10, 100, "1.44in SPI display", 1, 0, cyan, black)
  T144.pstring(7, 115, "ILI9163C controller", 1, 0, cyan, black)
  T144.drect(0, 0, _TFTWIDTH, _TFTHEIGHT, red)
'
  pause 4000
' demo fast line draw
  T144.fillscreen(black)
  x0=0:y0=0:y1=_TFTHEIGHT-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    x1=_TFTWIDTH*tn
    T144.dline(x0, y0, x1, y1, red)
  next i
  x1=_TFTWIDTH-1
  for i=0 to 44 step 2
    tn=tan(rad(i))
    y1=T144_params(T144_ht)*tn
    T144.dline(x0, y0, x1, y1, red)
  next i
  T144.drect(0, 0, _TFTWIDTH, _TFTHEIGHT, blue)
  pause 2000
  T144.fillscreen(white)
'demo fast text write
  T144.setrot(T144_rt_right)
  for i=0 to _TFTWIDTH-8 step 8
    T144.pstring(0, i, "Hello world:Bye world:Hello world", 1, T144_normal, green, black)
  next i
  pause 2000
  T144.setrot(T144_normal)
  T144.fillscreen(white)

  for i=_TFTHEIGHT-1 to 15 step -16
    T144.pstring(_TFTWIDTH-1, i, "Micromite MK2:Micromite MK2", 2, T144_inverse, red, yellow)
  next i

  pause 2000
  T144.fillscreen(white)
  for i=23 to _TFTWIDTH + 24 step 24
    T144.pstring(i, 0, "Rotate right", 3, T144_rt_right, yellow, black)
  next i
  pause 2000
  T144.fillscreen(black)
  for i=_TFTWIDTH-32 to 0 step -32
    T144.pstring(i, _TFTHEIGHT-1, "Left", 4, T144_rt_left, blue, black)
  next i
  pause 2000
  T144.fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     T144.setrot(i)
     T144.frect(4, 4, 12, 17, blue)
     T144.drect(2, 2, 16, 21, red)
  next i
  pause 2000
' test drawing rounded rectangles
  T144.fillscreen(black)
  for i=0 to 3
     T144.setrot(i)
     T144.frndrect(4, 4, 12, 17, 4, blue)
     T144.drndrect(2, 2, 16, 21, 6, red)
  next i
  pause 2000
  T144.fillscreen(black)
' test drawing circles
  for i=0 to 3
     T144.setrot(i)
     T144.fcirc(10, 10, 7, blue)
     T144.dcirc(10, 10, 9, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  T144.fillscreen(black)
  for i=0 to 3
     T144.setrot(i)
     T144.ftri(4, 4, 20, 6, 12, 14, blue)
     T144.dtri(1, 2, 24, 4, 12, 17, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  T144.fillscreen(black)
  T144.setrot(T144_normal)
  T144.pstring(_TFTWIDTH/2, _TFTHEIGHT/2, "N", 3, T144_normal, white, black)
  T144.pstring(0, 0, "Normal", sz, T144_normal, red, black)
  T144.pstring(_TFTWIDTH-1, _TFTHEIGHT-1, "Inverted", sz, T144_inverse, blue, black)
  T144.pstring(_TFTWIDTH-1, 0, "Rotated right", sz, T144_rt_right, green, black)
  T144.pstring(0, _TFTHEIGHT-1, "Rotated left", sz, T144_rt_left, yellow, black)
  pause 2000
  T144.fillscreen(black)
  T144.setrot(T144_inverse)
  T144.pstring(_TFTWIDTH/2, _TFTHEIGHT/2, "I", 3, T144_inverse, white, black)
  T144.pstring(0, 0, "Normal", sz, T144_normal, red, black)
  T144.pstring(_TFTWIDTH-1, _TFTHEIGHT-1, "Inverted", sz, T144_inverse, blue, black)
  T144.pstring(_TFTWIDTH-1, 0, "Rotated right", sz, T144_rt_right, green, black)
  T144.pstring(0, _TFTHEIGHT-1, "Rotated left", sz, T144_rt_left, yellow, black)
  pause 2000
  T144.fillscreen(black)
  T144.setrot(T144_rt_right)
  T144.pstring(_TFTWIDTH/2, _TFTHEIGHT/2, "R", 3, T144_rt_left, white, black)
  T144.pstring(0, 0, "Normal", sz, T144_normal, red, black)
  T144.pstring(_TFTWIDTH-1, _TFTHEIGHT-1, "Inverted", sz, T144_inverse, blue, black)
  T144.pstring(_TFTWIDTH-1, 0, "Rotated Right", sz, T144_rt_right, green, black)
  T144.pstring(0, T144_params(T144_ht)-1, "Rotated left", sz, T144_rt_left, yellow, black)
  pause 2000
  T144.fillscreen(black)
  T144.setrot(T144_rt_left)
  T144.pstring(_TFTWIDTH/2, _TFTHEIGHT/2, "L", 3, T144_rt_right, white, black)
  T144.pstring(0, 0, "Normal", sz, T144_normal, red, black)
  T144.pstring(_TFTWIDTH-1, _TFTHEIGHT-1, "Inverted", sz, T144_inverse, blue, black)
  T144.pstring(_TFTWIDTH-1, 0, "Rotated right", sz, T144_rt_right, green, black)
  T144.pstring(0, _TFTHEIGHT-1, "Rotated left", sz, T144_rt_left, yellow, black)
  pause 2000
  next sz
end sub
