#define _SUPPRESS_PLIB_WARNING
#include <plib.h>
#define FAM
#include "APIDefs.h"
#define cport *(volatile unsigned int *)(0xbf886230) //latch registers
#define csetport *(volatile unsigned int *)(0xbf886238) //latch registers
#define cclrport *(volatile unsigned int *)(0xbf886234) //latch registers
#define ctris *(volatile unsigned int *)(0xbf886210) //direction registers
#define cread *(volatile unsigned int *)(0xbf886220) //latch registers
#define devid *(volatile unsigned int *)(0xBF80F220) //Device ID
#define rs params[7]
#define wr params[8]
#define db0 params[9]
#define db1 params[10]
#define db2 params[11]
#define db3 params[12]
#define db4 params[13]
#define db5 params[14]
#define db6 params[15]
#define db7 params[16]
#define db8 params[17]
#define rd params[18]
#define pintable params[19]
#define optimise params[20]
#define command(a) {PinSetBit(rs, LATCLR);psend(a,params);}
#define data(a) {PinSetBit(rs, LATSET);psend(a,params);}
#define CurrentX params[4]
#define CurrentY params[5]
#define localdrawPixel(a,b,c,d) localfastfillrect(a,b,c,1,1,d)
#define pread(a) {*portclr=rdpin;l=ctris;m=devid;*portset=rdpin;a=cread;}

//
void psend(int d, long long params[]){
   int changes, *p;
   p=(int *)(int)pintable;
   if(optimise){
       cport=d;
   } else {
   changes= d ^ (int)params[6];
   params[6]=d;
   if(changes &1)*(volatile unsigned int *)p[9]=p[10];
   if(changes &2)*(volatile unsigned int *)p[11]=p[12];
   if(changes &4)*(volatile unsigned int *)p[13]=p[14];
   if(changes &8)*(volatile unsigned int *)p[15]=p[16];
   if(changes &16)*(volatile unsigned int *)p[17]=p[18];
   if(changes &32)*(volatile unsigned int *)p[19]=p[20];
   if(changes &64)*(volatile unsigned int *)p[21]=p[22];
   if(changes &128)*(volatile unsigned int *)p[23]=p[24];
   if(changes &256)*(volatile unsigned int *)p[25]=p[26];
   }
   *(volatile unsigned int *)p[4]=p[5];
   *(volatile unsigned int *)p[3]=p[5];
}
void writeCommand(unsigned long command, long long params[]){
    int *p;
    p=(int *)(int)pintable;
    *(volatile unsigned int *)p[1]=p[2];
    psend(command,params);
}
void writeData(unsigned long databyte, long long params[]){ //write just the bottom 9 bits
   int *p;
    p=(int *)(int)pintable;
    *(volatile unsigned int *)p[0]=p[2];
    psend(databyte, params);
}
long long initdisplay(long long params[]){
    unsigned int volatile * p;
    p=GetMemory(128); //set up 128 byte working buffer
    p[0]=(int)(volatile unsigned int *)GetPortAddr(rs,LATSET);
    p[1]=(int)(volatile unsigned int *)GetPortAddr(rs,LATCLR);
    p[2]=1<<GetPinBit(rs);
    p[3]=(int)(volatile unsigned int *)GetPortAddr(wr,LATSET);
    p[4]=(int)(volatile unsigned int *)GetPortAddr(wr,LATCLR);
    p[5]=1<<GetPinBit(wr);
    p[9]=(int)(volatile unsigned int *)GetPortAddr(db0,LATINV);
    p[10]=1<<GetPinBit(db0);
    p[11]=(int)(volatile unsigned int *)GetPortAddr(db1,LATINV);
    p[12]=1<<GetPinBit(db1);
    p[13]=(int)(volatile unsigned int *)GetPortAddr(db2,LATINV);
    p[14]=1<<GetPinBit(db2);
    p[15]=(int)(volatile unsigned int *)GetPortAddr(db3,LATINV);
    p[16]=1<<GetPinBit(db3);
    p[17]=(int)(volatile unsigned int *)GetPortAddr(db4,LATINV);
    p[18]=1<<GetPinBit(db4);
    p[19]=(int)(volatile unsigned int *)GetPortAddr(db5,LATINV);
    p[20]=1<<GetPinBit(db5);
    p[21]=(int)(volatile unsigned int *)GetPortAddr(db6,LATINV);
    p[22]=1<<GetPinBit(db6);
    p[23]=(int)(volatile unsigned int *)GetPortAddr(db7,LATINV);
    p[24]=1<<GetPinBit(db7);
    p[25]=(int)(volatile unsigned int *)GetPortAddr(db8,LATINV);
    p[26]=1<<GetPinBit(db8);
    ExtCfg(rs,EXT_DIG_OUT,0);     ExtCfg(wr,EXT_DIG_OUT,0);
    ExtCfg(db0,EXT_DIG_OUT,0);    ExtCfg(db1,EXT_DIG_OUT,0);    ExtCfg(db2,EXT_DIG_OUT,0);
    ExtCfg(db3,EXT_DIG_OUT,0);    ExtCfg(db4,EXT_DIG_OUT,0);    ExtCfg(db5,EXT_DIG_OUT,0);
    ExtCfg(db6,EXT_DIG_OUT,0);    ExtCfg(db7,EXT_DIG_OUT,0);    ExtCfg(db8,EXT_DIG_OUT,0);
    PinSetBit(rs,LATSET);PinSetBit(wr,LATSET);
    PinSetBit(db0,LATCLR);PinSetBit(db1,LATCLR);PinSetBit(db2,LATCLR);
    PinSetBit(db3,LATCLR);PinSetBit(db4,LATCLR);PinSetBit(db5,LATCLR);
    PinSetBit(db6,LATCLR);PinSetBit(db7,LATCLR);PinSetBit(db8,LATCLR);
    if(rd){ //configure rd pin if set
      p[6]=(int)(volatile unsigned int *)GetPortAddr(rd,LATSET);
      p[7]=(int)(volatile unsigned int *)GetPortAddr(rd,LATCLR);
      p[8]=1<<GetPinBit(rd);
      ExtCfg(rd,EXT_DIG_OUT,0);
      PinSetBit(rd,LATSET);
    }
    if(optimise){ //set the spare port 5 pin to an output and zero it
        ExtCfg(5,EXT_DIG_OUT,0);
        PinSetBit(5,LATCLR);
    }
    return (long long)(unsigned int)p;
}
void defineregion(long x, long y, long width,long height, long direction, long long params[]){
    long x1=x,x2=x+width-1,y1=y,y2=y+height-1;
    unsigned long xstart,xend,ystart,yend;
    unsigned long rotation=params[2];
    unsigned long SSD1963DISPLAYWIDTH=params[0];
    unsigned long SSD1963DISPLAYHEIGHT=params[1];
    int *p;
    p=(int *)(int)pintable;
    if(rotation==0){
              xstart = y1;
              xend = y2;
              ystart = (SSD1963DISPLAYHEIGHT - 1) - x2;
              yend = (SSD1963DISPLAYHEIGHT - 1) - x1;
    }
    if(rotation==1){
              xstart = (SSD1963DISPLAYWIDTH - 1) - y2;
              xend = (SSD1963DISPLAYWIDTH - 1) - y1;
              ystart = x1;
              yend = x2;
    }
    if(rotation==2){
              xstart = x1;
              xend = x2;
              ystart = y1;
              yend = y2;
    }
    if(rotation==3){
              xstart = (SSD1963DISPLAYWIDTH - 1) - x2;
              xend = (SSD1963DISPLAYWIDTH - 1) - x1;
              ystart = (SSD1963DISPLAYHEIGHT - 1) - y2;
              yend = (SSD1963DISPLAYHEIGHT - 1) - y1;
    }
    *(volatile unsigned int *)p[1]=p[2];
    psend(0x2A,params);
    *(volatile unsigned int *)p[0]=p[2];
    psend(xstart>>8,params);
    psend(xstart,params);
    psend(xend>>8,params);
    psend(xend,params);
    *(volatile unsigned int *)p[1]=p[2];
    psend(0x2B,params);
    *(volatile unsigned int *)p[0]=p[2];
    psend(ystart>>8,params);
    psend(ystart,params);
    psend(yend>>8,params);
    psend(yend,params);
    *(volatile unsigned int *)p[1]=p[2];
    if(direction)psend(0x2C,params); else psend(0x2E,params);
    *(volatile unsigned int *)p[0]=p[2]; //set RS HIGH
}
long long localfastfillrect(long fc,long x, long y, long width,long height, long long params[]){
    unsigned long i,ch,cl;
    int *p;
    p=(int *)(int)pintable;
    i=width*height;
    defineregion(x,y,width,height, 1, params);
    // convert the colours to 666 format
       ch = ((fc >> 15) & 0b111111000) | ((fc >> 13) & 0b000000111);
       cl = ((fc >>  4) & 0b111000000) | ((fc >>  2) & 0b000111111);
       *(volatile unsigned int *)p[0]=p[2]; //set RS HIGH
       if(ch==cl){
           psend(ch,params);
           psend(cl,params);
           i--;
           while (i--){
              *(volatile unsigned int *)p[4]=p[5];
              *(volatile unsigned int *)p[3]=p[5];
              *(volatile unsigned int *)p[4]=p[5];
              *(volatile unsigned int *)p[3]=p[5];
           }
       } else{
          while (i--) {
            psend(ch, params);
            psend(cl, params);
          }
       }
        return 1;
}
//Print the bitmap of a char on the video output
//    x, y - the top left of the char
//    width, height - size of the char's bitmap
//    scale - how much to scale the bitmap
//	  fc, bc - foreground and background colour
//    bitmap - pointer to the butmap
void DBitmap(int x1, int y1, int width, int height, int scale, int fc, int bc, unsigned char bitmap[], long long params[] ){
    long i, j, k, m;
    unsigned int fhb,flb, bhb, blb, xtest, ytest;
    unsigned long rotation=params[2];
    if(rotation<2){
              xtest=params[1];
              ytest=params[0];
    } else {
              xtest=params[0];
              ytest=params[1];
    }
    // convert the colours to 666 format
    fhb = ((fc >> 15) & 0b111111000) | ((fc >> 13) & 0b000000111);
    flb = ((fc >>  4) & 0b111000000) | ((fc >>  2) & 0b000111111);
    bhb = ((bc >> 15) & 0b111111000) | ((bc >> 13) & 0b000000111);
    blb = ((bc >>  5) & 0b111000000) | ((bc >>  2) & 0b000111111);
    defineregion(x1,y1,width*scale,height*scale, 1, params);
    PinSetBit(rs, LATSET);                               //set CD high
    for(i = 0; i < height; i++) {                                   // step thru the font scan line by line
        for(j = 0; j < scale; j++) {                                // repeat lines to scale the font
            for(k = 0; k < width; k++) {                            // step through each bit in a scan line
                for(m = 0; m < scale; m++) {                        // repeat pixels to scale in the x axis
                    if(x1 + k * scale + m >= 0 && x1 + k * scale + m < xtest && y1 + i * scale + j >= 0 && y1 + i * scale + j < ytest) {  // if the coordinates are valid
                        if((bitmap[((i * width) + k)/8] >> (((height * width) - ((i * width) + k) - 1) %8)) & 1) {
                            psend(fhb, params); psend(flb, params);
                        } else {
                            psend(bhb, params); psend(blb, params);
                        }
                    }
                }
            }
        }
    }
}
void swap(long *x, long *y){
    long temp;
    temp=*x;
    *x=*y;
    *y=temp;
}
#define abs( a)     (((a)> 0) ? (a) : -(a))
void drawline(int c, long x1, long y1, long x2, long y2, long long params[]) {
    int  dx, dy, sx, sy, err, e2, dp;

    if(y1 == y2) {
        if(x1>x2)swap(&x1,&x2);
        dp=localfastfillrect(c, x1, y1, x2-x1+1, 1 , params) ;
        return;
    }
    if(x1 == x2) {
        if(y1>y2)swap(&y1,&y2);
        dp=localfastfillrect(c, x1, y1, 1 , y2-y1+1, params);                   // vert line
        return;
    }

    dx = abs(x2 - x1); sx = x1 < x2 ? 1 : -1;
    dy = -abs(y2 - y1); sy = y1 < y2 ? 1 : -1;
    err = dx + dy;
    while(1) {
        dp=localdrawPixel(c,x1,y1,params);
        e2 = 2 * err;
        if (e2 >= dy) {
            if (x1 == x2) break;
            err += dy; x1 += sx;
        }
        if (e2 <= dx) {
            if (y1 == y2) break;
            err += dx; y1 += sy;
        }
    }
}

long long drawchar(char thechar,int thefont, long colour,long bcolour,long x,
    long y, long size,long long params[]){
    long cl=colour,bl=bcolour,height,width;
    int offsetchr,charsize,cindex;
    unsigned char* p;

    //Point p at the font bitmap
    p=FontTable[thefont];

    //Return the Height and Width of the font
    height=p[1];
    width=p[0];
    if((thechar>=p[2]) && (thechar<(p[2]+p[3]))){
        offsetchr=thechar - p[2]; //remove the ascii offset
        charsize= ((int)p[0] * (int)p[1] ) >>3 ;//number of bytes per char
        cindex=offsetchr*charsize + 4;
        p+=cindex;
        DBitmap(x, y, width, height, size, cl, bl, p,  params );
    }
    else {
       localfastfillrect(bcolour,x, y, width*size,height*size, params) ;
    }
}
long testchar(long x, long y, long sz, long width,long long params[]){
        unsigned long rotation=params[2];
        long wi=params[0],ht=params[1];
        x=x+(width*sz);
        if(((rotation==2) || (rotation==3)) && ((x<0) || (y<0) || (x>wi) || y>ht)){
            return 0;
        } 
        if(((rotation==0) || (rotation==1)) && ((x<0) || (y<0) || (x>ht) || y>wi)){
            return 0;
        }
        return 1;
}
long long pstring(long long afont,long long xx, long long yy,long long size,
        long long fc, long long bc,long long params[],unsigned char text[]){
    long x=xx,y=yy,sz=size,fontcolour=fc,backgroundcolour=bc;
    long i,width;
    long long myreturn;
    unsigned char* p;

    //Point p at the font bitmap
    p=FontTable[afont];

    //Return the Height and Width of the font
    width=p[0];
      for(i=1;i<=(long)text[0];i++)
      {
        if(testchar(x,y,sz,width,params)) { //Only write characters that will complete on the screen
            myreturn=drawchar(text[i],afont,fontcolour,backgroundcolour, x, y, sz, params);
            x=x+(width*sz);
        }else{
            return 0;
        }
      }

    params[4]=x;
    params[5]=y;
    return myreturn;
}
long long dcirch( long long colour, long long xx0,
   long long yy0, long long rr,long long ccn, long long params[]){
   long r=rr, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp,x0=xx0,y0=yy0,cn=ccn;
   long cl=colour;
   if(cn&16){
     dp=localdrawPixel(cl, x0, y0+r,  params);
     dp=localdrawPixel(cl, x0, y0-r,  params);
     dp=localdrawPixel(cl, x0+r, y0,  params);
     dp=localdrawPixel(cl, x0-r, y0,  params);
   }
   while (x<y){
    if (f>=0){
      y=y-1;
      ddF_y=ddF_y+2;
      f=f+ddF_y;
    }
    x=x+1;
    ddF_x=ddF_x+2;
    f=f+ddF_x;
    if(cn&4){
      dp=localdrawPixel(cl, x0+x, y0+y,  params);
      dp=localdrawPixel(cl, x0+y, y0+x,  params);
    }
    if(cn&2){
      dp=localdrawPixel(cl, x0+x, y0-y,  params);
      dp=localdrawPixel(cl, x0+y, y0-x,  params);
    }
    if(cn&8){
      dp=localdrawPixel(cl, x0-y, y0+x,  params);
      dp=localdrawPixel(cl, x0-x, y0+y,  params);
    }
    if(cn&1){
      dp=localdrawPixel(cl, x0-y, y0-x,  params);
      dp=localdrawPixel(cl, x0-x, y0-y,  params);
     }
   }
}
void fcirch(long long xx0,long long yy0,long long rr,
  long long ccn, long long d,long long colour,long long params[]){
  long r=rr, dp, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r,x0=xx0,y0=yy0,cn=ccn,delta=d;
  while (x<y){
    if (f>=0) {
      y=y-1;
      ddF_y=ddF_y+2;
      f=f+ddF_y;
    }
    x=x+1;
    ddF_x=ddF_x+2;
    f=f+ddF_x;
    if (cn & 1) {
      dp=localfastfillrect(colour, x0+x, y0-y, 1, 2*y+1+delta, params) ;
      dp=localfastfillrect(colour, x0+y, y0-x, 1, 2*x+1+delta, params) ;
    }
    if (cn & 2) {
      dp=localfastfillrect(colour, x0-x, y0-y, 1, 2*y+1+delta,  params) ;
      dp=localfastfillrect(colour, x0-y, y0-x, 1, 2*x+1+delta,  params) ;
    }
  }
}
void ftri (long long xx0 , long long yy0, long long xx1,long long yy1, long long xx2, long long yy2, long long colour,long long params[]) {
  long a, b, y, dp, last,x0=xx0,y0=yy0,x1=xx1,y1=yy1,x2=xx2,y2=yy2;
  if (y0>y1) {
    swap(&y0, &y1);
    swap(&x0, &x1);
  }
  if (y1>y2) {
    swap(&y2, &y1);
    swap(&x2, &x1);
  }
  if (y0>y1) {
    swap(&y0, &y1);
    swap(&x0, &x1);
  }
  if(y0==y2) { // Handle awkward all-on-same-line case as its own thing
    a=x0;
    b=x0;
    if(x1<a) {
      a=x1;
    } else {
       if(x1>b) b=x1;
    }
    if(x2<a) {
      a=x2;
    } else {
      if(x2>b)  b=x2;
    }
    dp=localfastfillrect( colour, a, y0, 1, b-a+1,  params) ;
  } else {
    long  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0;
    if(y1==y2) {
      last=y1; //Include y1 scanline
    } else {
     last=y1-1; // Skip it
    }
    for (y=y0;y<=last;y++){
      a=x0+sa / dy01;
      b=x0+sb / dy02;
      sa=sa+dx01;
      sb=sb+dx02;
      a=x0+(x1-x0) * (y-y0) / (y1-y0);
      b=x0+(x2-x0) * (y-y0) / (y2-y0);
      if(a>b)swap(&a, &b);
      dp=localfastfillrect( colour, a, y, b-a+1, 1,  params) ;
     }
     sa=dx12 * (y-y1);
     sb=dx02 * (y-y0);
     while (y<=y2){
       a=x1+sa / dy12;
       b=x0+sb / dy02;
       sa=sa+dx12;
       sb=sb+dx02;
       a=x1+(x2-x1) * (y-y1) / (y2-y1);
       b=x0+(x2-x0) * (y-y0) / (y2-y0);
       if(a>b) swap(&a, &b);
       dp=localfastfillrect( colour, a, y, b-a+1, 1,  params) ;
       y=y+1;
     }
  }
}
long long scroll(int x, int y, int width, int height, int direction, long buffer[], long long params[]){
    int i,j,k,l,m,y2=y+height-1,x2=x+width-1,rdpin;
    unsigned int volatile * portset,* portclr;
    rdpin=1<<(GetPinBit(rd));
    portclr=(volatile unsigned int *)GetPortAddr(rd, LATCLR);
    portset=(volatile unsigned int *)GetPortAddr(rd, LATSET);
    for(k=x+1;k<=x2;k++){
        defineregion(k,y,1,height,0,params);
        ctris=0b111111111;
        PinSetBit(rs, LATSET);                               //set CD high
        j=0;
        for(i=y;i<y2;i++){
            pread(buffer[j++]);
            pread(buffer[j++]);
       }
        ctris=0;
        defineregion(k-1,y,1,height,1,params);
        PinSetBit(rs, LATSET);                               //set CD high
        j=0;
        for(i=y;i<y2;i++){
            psend(buffer[j++],params);
            psend(buffer[j++],params);
        }
    }
}

long long main(long long *fn, long long *Arg1, long long *Arg2, long long *Arg3,
long long *Arg4, long long *Arg5,long long *Arg6, long long *Arg7,long long *Arg8, char *Arg9) {
    long long i;

    //Note 'if' statements are used rather than 'switch, case' because
    //'switch case' can generate 'peculiar' code resulting in JLR instructions
    //

    if (*fn==0x0){
        i=localfastfillrect((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,1,
                1,Arg4);
        return(i);
    }
    if (*fn==0x1){
        i=localfastfillrect((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,
                (long long)*Arg5,Arg6);
        return(i);
    }
    if (*fn==0x2){
        ftri((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,(long long)*Arg7,Arg8);
        return(*fn);
    }
    if (*fn==0x3){
        drawline((long long)*Arg1,(long long)*Arg2,(int)*Arg3,(int)*Arg4,
                (int)*Arg5,Arg6);
        return(*fn);
    }
    if (*fn==0x4){
        writeCommand((long long)*Arg1,Arg2);
        return(*fn);
    }
    if (*fn==0x5){
        writeData((long long)*Arg1,Arg2);
        return(*fn);
    }
    if (*fn==0x7){
        i=pstring((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,Arg7,(char*)Arg8);
        return(i);
    }
    if (*fn==0x8){
        fcirch((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,(long long)*Arg6,Arg7);
        return(*fn);
    }
    if (*fn==0x9){
        dcirch((long long)*Arg1,(long long)*Arg2,(long long)*Arg3,(long long)*Arg4,(long long)*Arg5,Arg6);
        return(*fn);
    }
     if (*fn==0xA){
        DBitmap((int)*Arg1,(int)*Arg2,(int)*Arg3,(int)*Arg4,(int)*Arg5,(int)*Arg6,(int)*Arg7, (char*)Arg8, (long long*)Arg9 );
       return 0;
     }
     if (*fn==0xB){
        i=scroll((int)*Arg1,(int)*Arg2,(int)*Arg3,(int)*Arg4,(int) *Arg5, (long*)Arg6, (long long*)Arg7 );
     return i;
     }
    if (*fn==0xC){
        i=initdisplay(Arg1);
       return i;
     }
}
