'
'  CFGEN.BAS  V1.0
'
'  Program to convert a .ELF file to Basic statements formated for use as CFunctions
'  Runs under MMBasic for DOS V4.5
'
'  It is recommended that the .ELF file is copied to the same directory as this file
'  and that the filename is shortened to make life easier
'
'  To run open a DOS box on the computer
'  navigate to the directory containing the MMBasic.exe file and this program
'  run MMBasic and you will get the normal ">" prompt
'  Load this program
'  Type run
'
'  Then give the filename of the .elf file including the extension
'  Choose "join" or "merge" to define the output format
'      "join" is typically used for individual CFunctions, each function in the .ELF file is given
'      its own header, all the CFunctions are output to a single file but can then be copied and
'      pasted as required. When "join is chosen the "main" function is a dummy and is not included in the output
'      "merge" is used for CFunctions such as drivers where one C function can be called from another
'
'  Choose the name of the file for the Basic output. Do not include ".BAS", this will be appended automatically
'
'  You can run MMBasic for DOS from MMEDIT, but in this case you will need to specify the correct directory information for the .ELF file
'
dim program_header,section_header,program_header_size, program_header_num, section_header_size, section_header_num
dim string_table_sector, string_table, text_section, text_position, text_size, text_link, symtab_section, strtab_section
dim symtab_offset, symtab_num, symstr_offset, first
dim text_add$ length 31
dim symbols$(100,2) length 31
line input ".ELF filename ? ",inname$
do
   line input "mode(join, merge) ? ",m$
loop while (m$<>"join") and (m$<>"merge")
mode =0
if m$="merge" then mode=1
line input "CFunction name ? ",cname$
print "Created "+cname$+".bas"
open cname$+".bas" for output as #2
first=1 'first time into the various loops
print "processing ",inname$
open inname$ for random as #1
SEEK #1, 0
'
dat$ = INPUT$(16, #1) ' Get the .elf identification
dat$=input$(12,#1) 'Get unused header
dat$=input$(4,#1)
program_header=getnum4(dat$)
dat$=input$(4,#1)
section_header=getnum4(dat$)
dat$=input$(6,#1) 'step past the flags and header size
dat$=input$(2,#1) 
program_header_size=getnum2(dat$)
dat$=input$(2,#1) 
program_header_num=getnum2(dat$)
dat$=input$(2,#1) 
section_header_size=getnum2(dat$)
dat$=input$(2,#1) 
section_header_num=getnum2(dat$)
dim sections$(section_header_num+2)
dat$=input$(2,#1) 
string_table_sector=getnum2(dat$)
'
i=section_header+ (Section_header_size*string_table_sector) + 16 'get to the offset in the string table sector
seek #1,i
dat$=input$(4,#1) 
string_table= getnum4(dat$) 'get the offset to the string table
Print "Functions found:"
print "Address",chr$(9)+"Function"
for j=0 to section_header_num-1
    i=section_header+ (Section_header_size*j) 'get to the next sector header
    seek #1,i 'point to the .text section header
    dat$=input$(4,#1) 'get the pointer to the sector name string
	k=getnum4(dat$)
	seek #1,k+string_table 'point to the name string for this sector
    s$=""
    d$=input$(1,#1)
    do while asc(d$)<>0 'read in the zero terminated string
        S$=S$+D$
        d$=input$(1,#1)
    loop
    if s$=".text" and text_section=0 then 'store text sector number
	  text_section=j 
    endif
    if s$=".symtab" and symtab_section=0 then 'store symbol table sector number
	  symtab_section=j 
    endif
    if s$=".strtab" and strtab_section=0 then 'store symbol table strings sector number
	  strtab_section=j 
    endif
next j
'
i=section_header+ (Section_header_size*text_section) 'get to the .text offset 
seek #1,i 'point to the .text section header
dat$=input$(12,#1) 
dat$=input$(4,#1)
text_add$=getadd$(dat$)
dat$=input$(4,#1)
text_position=getnum4(dat$)
dat$=input$(4,#1)
text_size= getnum4(dat$)
dat$=input$(4,#1)
text_link= getnum4(dat$)
dat$=input$(4,#1)
text_info= getnum4(dat$)
dat$=input$(4,#1)
text_addralign= getnum4(dat$)
dat$=input$(4,#1)
text_entsize= getnum4(dat$)
'
i=section_header+ 16+ (Section_header_size*(symtab_section)) 
seek #1,i 'point to the .text section header
dat$=input$(4,#1) 'get the offset to the symbol table
symtab_offset=getnum4(dat$)
dat$=input$(4,#1)
symtab_num=getnum4(dat$)/16
'
i=section_header+ 16+ (Section_header_size*(strtab_section)) 
seek #1,i 'point to the .text section header
dat$=input$(4,#1) 'get the offset to the symbol table
symstr_offset=getnum4(dat$)
'
m=0 'counter for the stored symbols array
for i=1 to symtab_num 'loop through all the symbols
    seek #1,symtab_offset+(16*i) 'point to the next symbol in the .symtab section 
    dat$=input$(4,#1)
	k=getnum4(dat$)
	dat$=input$(4,#1)
	a$=getadd$(dat$)
	dat$=input$(4,#1)
	dat$=input$(1,#1)
	l=asc(dat$) 
	seek #1,k+symstr_offset 'point to the symbol name
    s$=""
    d$=input$(1,#1)
    do while asc(d$)<>0
        S$=S$+D$
        d$=input$(1,#1)
    loop
	if l=18 and left$(s$,1)<>"_" then 'Only store function names
	    symbols$(m,1)=a$
	    symbols$(m,2)=s$
		print symbols$(m,1),symbols$(m,2)
		m=m+1
		if s$="main" then main_offset$=a$
	endif
next i
'
s$= hex$(subtract(right$(main_offset$,5),right$(text_add$,5))) 'calculate the offset of the main function
if len(s$)=1 then s$="0000000"+S$
if len(s$)=2 then s$="000000"+S$
if len(s$)=3 then s$="00000"+S$
if len(s$)=4 then s$="0000"+S$
if len(s$)=5 then s$="000"+S$
if len(s$)=6 then s$="00"+S$
if len(s$)=7 then s$="0"+S$
main$=s$
'
seek #1,text_position
k=0
currentfunction=0
s$=text_add$
for i=1 to text_size step 4
    for j=0 to m-1
        if s$=symbols$(j,1) then 'address matches the start of a function
	        currentfunction=j
	        if k<>0 and mode then print #2,"" 'The last function didn't end with a newline so output one
	        if k<>0  and (not mode) and symbols$(j,2)<>"main" then print #2,"" 
	        k=0
	        if first and mode then ' First time in for a merged file output the Cfunction name
	   	        print #2,"CFunction "+cname$
  	            print #2,chr$(9)+main$
	        endif
	        if mode then print #2,chr$(9)+"'"+symbols$(j,2)
	        if not mode and symbols$(j,2)<>"main" then
	        if not first then 
		        print #2,"End CFunction"
		        print #2,"'"
		    endif
	   	    print #2,"CFunction "+symbols$(j,2)
   	        print #2,chr$(9)+"00000000"
 	    endif
	    first=0
    endif
    next j
    if k=0 then print #2,chr$(9);
    dat$=getadd$(input$(4,#1))
    if left$(dat$,3)="0F4" then 'Jump instruction found convert to a branch
	    a$=getjumpaddress$(right$(dat$,5)) 'this the address for the jump
	    branchoffset=subtract(right$(s$,5),right$(a$,5))
	    branch$="0411FFFF"
	    do
	        decrement(branch$)
	        branchoffset=branchoffset-1
	    loop while branchoffset
	    if not mode and symbols$(currentfunction,2)<>"main" then print #2, branch$+" ";
	    if mode then print #2, branch$+" ";
    else
        if not mode and symbols$(currentfunction,2)<>"main" then print #2, dat$+" ";
        if mode then print #2, dat$+" ";
    endif
    k=k+1
    if k=8 then 'deal with line feed every eight words
        if not mode and symbols$(currentfunction,2)<>"main" then print #2,""
        if mode then print #2,""
	    k=0
    endif
    increment4(s$) 'step on the program counter 
next i
if k<>0 then print #2,""
print #2,"End CFunction"
close #1
close #2
'
end

function subtract(b$,c$)
  local a,b,c,d,e,f,g,a$
  a=asc(mid$(b$,5,1)) : a=a-48 : if a> 9 then a=a-7
  b=asc(mid$(b$,4,1)) : b=b-48 : if b> 9 then b=b-7
  c=asc(mid$(b$,3,1)) : c=c-48 : if c> 9 then c=c-7
  d=asc(mid$(b$,2,1)) : d=d-48 : if d> 9 then d=d-7
  e=asc(mid$(b$,1,1)) : e=e-48 : if e> 9 then e=e-7
  f=((((((((e * 16) + d) * 16 ) + c ) * 16 ) + b ) * 16 ) + a)
  a=asc(mid$(c$,5,1)) : a=a-48 : if a> 9 then a=a-7
  b=asc(mid$(c$,4,1)) : b=b-48 : if b> 9 then b=b-7
  c=asc(mid$(c$,3,1)) : c=c-48 : if c> 9 then c=c-7
  d=asc(mid$(c$,2,1)) : d=d-48 : if d> 9 then d=d-7
  e=asc(mid$(c$,1,1)) : e=e-48 : if e> 9 then e=e-7
  g=((((((((e * 16) + d) * 16 ) + c ) * 16 ) + b ) * 16 ) + a)
  subtract=(f-g)/4
end function

function getjumpaddress$(a$)
  local a,b,c,d,e,f
  a=asc(mid$(a$,5,1)) : a=a-48 : if a> 9 then a=a-7
  b=asc(mid$(a$,4,1)) : b=b-48 : if b> 9 then b=b-7
  c=asc(mid$(a$,3,1)) : c=c-48 : if c> 9 then c=c-7
  d=asc(mid$(a$,2,1)) : d=d-48 : if d> 9 then d=d-7
  e=asc(mid$(a$,1,1)) : e=e-48 : if e> 9 then e=e-7
  f=((((((((e * 16) + d) * 16 ) + c ) * 16 ) + b ) * 16 ) + a)*4 + 1048576
  getjumpaddress$=left$(text_add$,3)+right$(hex$(f),5)
  
end function

function getadd$(d$)
   local a,b,c,d
   a=asc(left$(d$,1))+256
   b=asc(mid$(d$,2,1))+256
   c=asc(mid$(d$,3,1))+256
   d=asc(right$(d$,1))+256
   getadd$=right$(hex$(d),2)+right$(hex$(c),2)+right$(hex$(b),2)+right$(hex$(a),2)
end function

function getnum4(d$)
   local a,b,c,d
   a=asc(left$(d$,1))
   b=asc(mid$(d$,2,1))
   c=asc(mid$(d$,3,1))
   d=asc(right$(d$,1))
   getnum4=((((d*256)+c)*256)+b)*256+a
end function

function getoffset(d$)

end function
function getnum2(d$)
   local a,b
   a=asc(left$(d$,1))
   b=asc(right$(d$,1))
   getnum2=b*256+a
end function

sub increment4(p$)
  local a,b,c,d,e,f,g,h,v
  a=asc(mid$(p$,8,1)) : a=a-48 : if a> 9 then a=a-7
  b=asc(mid$(p$,7,1)) : b=b-48 : if b> 9 then b=b-7
  c=asc(mid$(p$,6,1)) : c=c-48 : if c> 9 then c=c-7
  d=asc(mid$(p$,5,1)) : d=d-48 : if d> 9 then d=d-7
  e=asc(mid$(p$,4,1)) : e=e-48 : if e> 9 then e=e-7
  f=asc(mid$(p$,3,1)) : f=f-48 : if f> 9 then f=f-7
  g=asc(mid$(p$,2,1)) : g=g-48 : if g> 9 then g=g-7
  h=asc(mid$(p$,1,1)) : h=h-48 : if h> 9 then h=h-7
  a=a+4 : if a=16 then 
    b=b+1 : a=0
	if b=16 then 
      c=c+1 : b=0: if c=16 then
	    d=d+1 : c=0: if d=16 then
		  e=e+1 : d=0 : if e=16 then
		    f=f+1 : e=0 : if f=16 then
			  g=g+1: f=0 : if g=16 then
			    g=0: h=h+1
			    endif
			  endif
			endif
		  endif
		endif
	  endif
    endif
  endif
  a=a+48: if a> 57 then a=a+ 7
  b=b+48: if b> 57 then b=b+ 7
  c=c+48: if c> 57 then c=c+ 7
  d=d+48: if d> 57 then d=d+ 7
  e=e+48: if e> 57 then e=e+ 7
  f=f+48: if f> 57 then f=f+ 7
  g=g+48: if g> 57 then g=g+ 7
  h=h+48: if h> 57 then h=h+ 7
  p$=chr$(h)+chr$(g)+chr$(f)+chr$(e)+chr$(d)+chr$(c)+chr$(b)+chr$(a)
end sub

sub decrement(p$)
  local a,b,c,d,e,f,g,h
  a=asc(mid$(p$,8,1)) : a=a-48 : if a> 9 then a=a-7
  b=asc(mid$(p$,7,1)) : b=b-48 : if b> 9 then b=b-7
  c=asc(mid$(p$,6,1)) : c=c-48 : if c> 9 then c=c-7
  d=asc(mid$(p$,5,1)) : d=d-48 : if d> 9 then d=d-7

  if a<>0 then
     a=a-1
  else
     a=15
	 if b<>0 then
	   b=b-1
	 else
	   b=15
	   if c<>0 then
	     c=c-1
	   else
	     c=15
		 if d<>0 then
	       d=d-1
	     else
	       d=15
	   endif
	 endif
	endif
  endif
  a=a+48: if a> 57 then a=a+ 7
  b=b+48: if b> 57 then b=b+ 7
  c=c+48: if c> 57 then c=c+ 7
  d=d+48: if d> 57 then d=d+ 7
  p$=left$(p$,4)+chr$(d)+chr$(c)+chr$(b)+chr$(a)
 end sub
