CPU 120
option explicit
option default none
dim integer i,j=0,toggle,channel1buff(400),channel2buff(400),microsecondsperdivision=50
dim integer y1pos=90, y2pos=30, c1mvperdivision=200, c2mvperdivision=1000, c1trig=90, c2trig=0

setpin 16,ain 'Channel 1
setpin 12,ain 'Channel 2

colour rgb(white),rgb(blue)
cls
font 2
'
'  Starting code for a Micromite based oscilloscope - needs a GUI (volunteers?)
'  Runs on MM+ with a 800x480 SSD1963 display
'  Uses pin 16 for channel 0 and pin 12 for channel 1
'  Maximum conversion rate is approximately 1.6 Megasamples / second on each channel at 10-bits resolution
'  The CFunction will automatically compensate for CPU speed but obviously the higher the speed the better
'  
'
'  Parameters for call to CFunction "scope"
'
'      Returns the scaling factor used for the display or a large number if triggering is enabled and has timed out
'      A scale factor of 1 means every x-coordinate has a unique value
'
'      microsecondsperdivision: specifies the number of microseconds to scale the display for each graticle line
'         note: durations less than 100uSec will use scaling. i.e.every other x-coordinate will be missed if scale = 2
'      toggle: initialised to 0, used by the CFunction to control its double buffering
'      channel1buff: buffer used for channel 1, used as 2 buffers of 800 x 16-bit words
'      channel2buff: buffer used for channel 2, used as 2 buffers of 800 x 16-bit words
'      y-position for channel 1: specifies the screen position of the zero volts on channel 1 in rows from the bottom of the display
'           use any negative number to turn off the channel
'      y-position for channel 2: specifies the screen position of the zero volts on channel 2 in rows from the bottom of the display
'           use any negative number to turn off the channel
'      trigger for channel 1
'           specifies the ADC reading and direction to trigger the trace for channel 1 (-1024 to +1023)
'           a zero value means triggering is disabled for this channel
'           a positive value triggers when the ADC reading passes the trigger value in a positive going sense
'           a negative value triggers when the ADC reading passes the absolute trigger value in a negative going sense
'      trigger for channel 2
'           specifies the ADC reading and direction to trigger the trace for channel 2 (-1024 to +1023)
'           a zero value means triggering is disabled for this channel
'           a positive value triggers when the ADC reading passes the trigger value in a positive going sense
'           a negative value triggers when the ADC reading passes the absolute trigger value in a negative going sense
'      NB: if both trigger levels are set to zero the scope will free run
'      millivolts per division for channel 1 based on VDD=3.3V 
'      millivolts per division for channel 2 based on VDD=3.3V 
' 
         
do
  i= scope(microsecondsperdivision,toggle,channel1buff(),channel2buff(),y1pos, y2pos, c1trig, c2trig ,c1mvperdivision,c2mvperdivision)
  if i>1 and i<1024 and j=0 then
      print "Warning reduced resolution x"+str$(i) 
      j=1
  endif
  if i>1024 then
      PRINT "No trigger"
  endif
  text 2,2,"T:"+str$(microsecondsperdivision)+"us/div"
  if y1pos>=0 then text 2,24,"C1:"+str$(c1mvperdivision)+"mv/div"
  if y2pos>=0 then text 2,46,"C2:"+str$(c2mvperdivision)+"mv/div"
loop
end
'
CFunction scope
    00000000
    27BDFFA8 AFBF0054 AFBE0050 AFB7004C AFB60048 AFB50044 AFB40040 AFB3003C 
    AFB20038 AFB10034 AFB00030 8FA20074 8C830000 3C049D00 8C840000 8C880000 
    240403E8 0104001B 008001F4 8FA40078 8C840000 AFA40018 8FA4007C 8C840000 
    AFA4001C 8CA90000 8CA80004 01282025 10800006 00005012 24F50640 24D60640 
    AFA6002C 10000007 AFA70028 24E40640 AFA40028 24D00640 AFB0002C 00C0B021 
    00E0A821 00094827 ACA90000 00084027 ACA80004 706A3002 24050001 3C040002 
    24847100 00C4001B 008001F4 00003812 00001812 00042042 2CE70040 14E0FFF9 
    00052840 00052842 AFA50020 8FA40070 8C870000 14E00005 2404FFFF 8C460000 
    0006200B 10000006 00803021 18E00004 00003021 7C073E20 10000004 2418FFFF 
    00073823 7C073E20 0000C021 8C480000 19000003 2413FFFF 10000004 7C084620 
    00084023 7C084620 00009821 3C04BF88 3C021000 AC821064 3C02BF88 AC401068 
    34058000 3C09BF81 AD259004 3C0A0400 3C09BF81 AD2A9040 3C09BF88 AD206118 
    3C09BF88 AD206108 3C0AFFFF 3C09BF81 AD2A9050 240A0300 3C09BF81 AD2A9020 
    240A0007 3C09BF81 AD2A9010 340A80E4 3C09BF81 AD2A9000 3C09BF81 AD259008 
    3C050008 AC851064 AC401068 3C04BF81 8C829010 7C4201C0 1040FFFD 3C02BF81 
    8C429070 3C02BF81 8C429080 3C04BF81 8C829010 30420080 1440FFFD 3C02BF81 
    8C4290F0 3C02BF81 8C429100 3C02BF81 8C429070 24420001 A6C20000 3C02BF81 
    8C429080 24420001 A6A20000 00001021 40824800 24020320 8FA40020 0044001B 
    008001F4 0000B812 0000A012 00002821 00002021 3C090007 3529A120 3C02BF81 
    3C0EBF81 3C0DBF81 00006021 240FFFFF 026FF826 030F5026 AFAA0024 3C0BBF81 
    10000075 3C0ABF81 8C599010 7F3901C0 1320FFFD 00000000 40194800 0323001B 
    006001F4 00008012 0090C82B 13200030 00000000 8DD99070 27390001 8DB09080 
    10C00008 26100001 00048840 02D19021 A6590000 02B18821 A6300000 10000024 
    24840001 10E0000E 00000000 86D10000 0227902A 5240017A 00F1882A 0327F02B 
    01E09021 00D8900A 10000174 025E300A 16200003 00068827 8FB20024 0232300B 
    5100000F A6D90000 86B10000 0228902A 52400170 0111882A 0208902B 5640016D 
    0111882A 00069027 10000169 0253300B 16200003 A6D90000 00068827 023F300B 
    A6B00000 0180C821 40994800 24A50001 8C599010 33390080 1720FFFD 00000000 
    40194800 0323001B 006001F4 00008012 0090C82B 13200031 0094C82B 8D7990F0 
    27390001 8D509100 10C00008 26100001 00048840 02D19021 A6590000 02B18821 
    A6300000 10000024 24840001 10E0000E 00000000 86D10000 0227902A 5240014A 
    00F1882A 0327F02B 01E09021 00D8900A 10000144 025E300A 16200003 00068827 
    8FB20024 0232300B 5100000F A6D90000 86B10000 0228902A 52400140 0111882A 
    0208902B 5640013D 0111882A 00069027 10000139 0253300B 16200003 A6D90000 
    00068827 023F300B A6B00000 0180C821 40994800 24A50001 0094C82B 13200003 
    00A9C82B 1720FF88 00000000 40024800 3C04BF88 3C021000 AC821064 3C03BF88 
    AC601068 34068000 3C02BF81 AC469004 3C020008 AC821064 AC621068 2442A120 
    00A2282B 10A000C7 3C020007 2EF70002 16E000C6 8FB70028 8FBE002C 8FB20020 
    00009821 241F0001 3C109D00 241101DF 3C0200FF 3442FFFF AFA20024 AFB40028 
    03E0A021 8FA20068 8C430000 04600028 240A0001 87C20000 000220C0 00022940 
    00A42023 00821021 00022100 00821023 00022140 00441021 8FA40018 0044001B 
    008001F4 00002812 00052982 02252823 87C20002 000220C0 00023140 00C42023 
    00821021 00022100 00821023 00022140 00441021 8FA40018 0044001B 008001F4 
    00003812 00073982 02273823 AFAA0010 240200FF AFA20014 8E020050 02602021 
    00A32823 02403021 0040F809 00E33823 8FA2006C 8C430000 04600028 240A0001 
    86E20000 000220C0 00022940 00A42023 00821021 00022100 00821023 00022140 
    00441021 8FA4001C 0044001B 008001F4 00002812 00052982 02252823 86E20002 
    000220C0 00023140 00C42023 00821021 00022100 00821023 00022140 00441021 
    8FA4001C 0044001B 008001F4 00003812 00073982 02273823 AFAA0010 240200FF 
    AFA20014 8E020050 02602021 00A32823 02403021 0040F809 00E33823 8FA20068 
    8C430000 04600028 240A0001 86C20000 000220C0 00022940 00A42023 00821021 
    00022100 00821023 00022140 00441021 8FA40018 0044001B 008001F4 00002812 
    00052982 02252823 86C20002 000220C0 00023140 00C42023 00821021 00022100 
    00821023 00022140 00441021 8FA40018 0044001B 008001F4 00003812 00073982 
    02273823 AFAA0010 8FA20024 AFA20014 8E020050 02602021 00A32823 02403021 
    0040F809 00E33823 8FA4006C 8C830000 04600028 240A0001 86A20000 000220C0 
    00022940 00A42023 00821021 00022100 00821023 00022140 00441021 8FA4001C 
    0044001B 008001F4 00002812 00052982 02252823 86A20002 000220C0 00023140 
    00C42023 00821021 00022100 00821023 00022140 00441021 8FA4001C 0044001B 
    008001F4 00003812 00073982 02273823 AFAA0010 8FA20024 AFA20014 8E020050 
    02602021 00A32823 02403021 0040F809 00E33823 26940001 26B50002 8FA40020 
    02649821 02449021 26D60002 26F70002 8FAA0028 1554FF4B 27DE0002 10000004 
    00008021 3442A120 AFA20020 00008021 3C119D00 24120001 3C130080 36738080 
    241401E0 AFB20010 AFB30014 8E220050 00002021 02002821 2406031F 0040F809 
    02003821 2610003C 5614FFF7 AFB20010 00008021 3C119D00 24120001 3C130080 
    36738080 24140320 AFB20010 AFB30014 8E220050 02002021 00002821 02003021 
    0040F809 240701DF 26100050 5614FFF7 AFB20010 3C109D00 24110001 AFB10010 
    3C120080 36528080 AFB20014 8E020050 00002021 240501DF 2406031F 0040F809 
    240701DF AFB10010 AFB20014 8E020050 2404031F 00002821 2406031F 0040F809 
    240701DF 8FA20020 00001821 8FBF0054 8FBE0050 8FB7004C 8FB60048 8FB50044 
    8FB40040 8FB3003C 8FB20038 8FB10034 8FB00030 03E00008 27BD0058 00F1882A 
    1620FE8B 00F9882B 1000FE8D 00000000 0111882A 1620FE96 0110882B 1000FE98 
    A6D90000 00F1882A 1620FEBB 00F9882B 1000FEBD 00000000 0111882A 1620FEC6 
    0110882B 1000FEC8 A6D90000 
End CFunction

