long long scope(long long *microsecondsperdivision, long long *toggle, short *channel0, short *channel1, long *c0pos, long *c1pos, long *c0trig, long *c1trig, long *mpv0, long *mpv1){
    unsigned int count=800,loop=0,k=479,div=160000,mps=*microsecondsperdivision,scale=1;
    unsigned int cpu=CurrentCpuSpeed/1000,s0=*mpv0,s1=*mpv1;
    unsigned int current_ticks=0,ticktest=0,triggered=0,currentc0,currentc1, triggertimeout=0;
    short c0dir=0,c1dir=0,c0lev=0,c1lev=0;
    short *c1;
    short *c0;
    short *c1last;
    short *c0last;
    if(*toggle){ //decide which buffer to use
        c1=channel1+800;
        c0=channel0+800;
        c1last=channel1;
        c0last=channel0;
    } else {
        c1=channel1;
        c0=channel0;
        c1last=channel1+800;
        c0last=channel0+800;
    }
    *toggle=~(*toggle); //swap buffers for next time

    while(ticktest<64){ //implement scaling if display resolution too high for the ADC
        ticktest=cpu*mps/div;
        div/=2;
        scale*=2;
    }
    scale/=2;

    if (*c0trig==0 && *c1trig==0)triggered=~triggered; //no trigger specified so free run
    if(*c0trig>0){
        c0lev=*c0trig;
        c0dir=~c0dir;
    } else {
        c0lev=-(*c0trig);
    }
    if(*c1trig>0){
        c1lev=*c1trig;
        c1dir=~c1dir;
    } else {
        c1lev=-(*c1trig);
    } 

// configure and enable the ADC
CloseADC10();// ensure the ADC is off before setting the configuration
// define setup parameters for OpenADC10
#define PARAM1 ADC_MODULE_ON | ADC_FORMAT_INTG | ADC_CLK_AUTO | ADC_AUTO_SAMPLING_ON
#define PARAM2 ADC_VREF_AVDD_AVSS | ADC_OFFSET_CAL_DISABLE | ADC_SCAN_OFF| ADC_SAMPLES_PER_INT_2 | ADC_ALT_BUF_ON | ADC_ALT_INPUT_ON
#define PARAM3 ADC_CONV_CLK_SYSTEM | ADC_SAMPLE_TIME_3 
#define PARAM5 SKIP_SCAN_ALL
#define PARAM4 0
#define maxwait 500000 //wait for 500,000 samples before timing out if no trigger
 // configure to sample AN4 & AN5
SetChanADC10( ADC_CH0_NEG_SAMPLEA_NVREF | ADC_CH0_POS_SAMPLEA_AN0 |ADC_CH0_NEG_SAMPLEB_NVREF | ADC_CH0_POS_SAMPLEB_AN4);
// configure ADC and enable it
OpenADC10( PARAM1, PARAM2, PARAM3, PARAM4, PARAM5 );
// Now enable the ADC logic
EnableADC10();
// the results of the conversions are available in channel4 and channel5
mT4IntEnable(0);       											// disable interrupt

while (~ReadActiveBufferADC10() & 1); //wait for first conversions to complete
currentc0=ReadADC10(0);
currentc1=ReadADC10(1);
while (ReadActiveBufferADC10()); //wait for first conversions to complete
currentc0=ReadADC10(8);
currentc1=ReadADC10(9);
c0[0]=(ReadADC10(0)+1);
c1[0]=(ReadADC10(1)+1);

asm volatile("mtc0 %0, $9": "+r"(current_ticks)); //set the current number of ticks to 0 
while(loop<count/scale && triggertimeout<maxwait)
{
    while (~ReadActiveBufferADC10() & 1); //wait for first conversions to complete

    asm volatile("mfc0 %0, $9" : "=r"(current_ticks));//get the time in ticks since zeroed 
    if(current_ticks/ticktest>loop){ //save if I'm into the next time period
        currentc0=(ReadADC10(0)+1);
        currentc1=(ReadADC10(1)+1);
        if(triggered){
            c0[loop] = currentc0;
            c1[loop] = currentc1;
            loop++;
        } else{
            if((c0lev) && (c0[0]<c0lev) && (currentc0>=c0lev) && (c0dir)) triggered=~triggered;
            if((c0lev) && (c0[0]>c0lev) && (currentc0<=c0lev) && (~(c0dir))) triggered=~triggered;
            if((c1lev) && (c1[0]<c1lev) && (currentc1>=c1lev) && (c1dir)) triggered=~triggered;
            if((c1lev) && (c1[0]>c1lev) && (currentc1<=c1lev) && (~(c1dir))) triggered=~triggered;
            c0[0] = currentc0;
            c1[0] = currentc1;
            current_ticks=0;
            asm volatile("mtc0 %0, $9": "+r"(current_ticks)); //set the current number of ticks to 0 
            triggertimeout++;
        }
    }
    while (ReadActiveBufferADC10()); //wait for first conversions to complete
    //while(count--)
    asm volatile("mfc0 %0, $9" : "=r"(current_ticks));//get the time in ticks since zeroed 
    if(current_ticks/ticktest>loop){ //save if I'm into the next time period
        currentc0=(ReadADC10(8)+1);
        currentc1=(ReadADC10(9)+1);
        if(triggered){
               c0[loop] = currentc0;
               c1[loop] = currentc1;
               loop++;
        } else{
            if((c0lev) && (c0[0]<c0lev) && (currentc0>=c0lev) && (c0dir)) triggered=~triggered;
            if((c0lev) && (c0[0]>c0lev) && (currentc0<=c0lev) && (~(c0dir))) triggered=~triggered;
            if((c1lev) && (c1[0]<c1lev) && (currentc1>=c1lev) && (c1dir)) triggered=~triggered;
            if((c1lev) && (c1[0]>c1lev) && (currentc1<=c1lev) && (~(c1dir))) triggered=~triggered;
            c0[0] = currentc0;
            c1[0] = currentc1;
            current_ticks=0;
            asm volatile("mtc0 %0, $9": "+r"(current_ticks)); //set the current number of ticks to 0 
            triggertimeout++;
        }
    }
}
asm volatile("mfc0 %0, $9" : "=r"(current_ticks));//get the time in ticks since zeroed 

CloseADC10();
mT4IntEnable(1); 
if(triggertimeout<maxwait){
for(loop=1;loop<count/scale;loop++){
    if(*c0pos>=0)DrawLine((loop-1)*scale,k-((unsigned int)c0last[loop-1]*12375/s0)/64-*c0pos,loop*scale,k-((unsigned int)c0last[loop]*12375/s0)/64-*c0pos,1,0xFF);
    if(*c1pos>=0)DrawLine((loop-1)*scale,k-((unsigned int)c1last[loop-1]*12375/s1)/64-*c1pos,loop*scale,k-((unsigned int)c1last[loop]*12375/s1)/64-*c1pos,1,0xFF);
    if(*c0pos>=0)DrawLine((loop-1)*scale,k-((unsigned int)c0[loop-1]*12375/s0)/64-*c0pos,loop*scale,k-((unsigned int)c0[loop]*12375/s0)/64-*c0pos,1,0xFFFFFF);
    if(*c1pos>=0)DrawLine((loop-1)*scale,k-((unsigned int)c1[loop-1]*12375/s1)/64-*c1pos,loop*scale,k-((unsigned int)c1[loop]*12375/s1)/64-*c1pos,1,0xFFFFFF);
}
} else {
    scale=maxwait;
}

for(loop=0;loop<480;loop+=60)DrawLine(0,loop,799,loop,1,0x808080);
for(loop=0;loop<800;loop+=80)DrawLine(loop,0,loop,479,1,0x808080);
DrawLine(0,479,799,479,1,0x808080);
DrawLine(799,0,799,479,1,0x808080);
return scale;
}