#define Version 101     //Version 1.01
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "../cfunctions.h"
// SD code based on PetitFAT by chan
/*----------------------------------------------------------------------------/
/  Petit FatFs - FAT file system module  R0.03                  (C)ChaN, 2014
/-----------------------------------------------------------------------------/
/ Petit FatFs module is a generic FAT file system module for small embedded
/ systems. This is a free software that opened for education, research and
/ commercial developments under license policy of following trems.
/
/  Copyright (C) 2014, ChaN, all right reserved.
/
/ * The Petit FatFs module is a free software and there is NO WARRANTY.
/ * No restriction on use. You can use, modify and redistribute it for
/   personal, non-profit or commercial products UNDER YOUR RESPONSIBILITY.
/ * Redistributions of source code must retain the above copyright notice.
/
/-----------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------/
/ Locale and Namespace Configurations
/---------------------------------------------------------------------------*/

#define _USE_LCC	1	/* Allow lower case characters for path name */

#define	_CODE_PAGE	437
/* FatFs refers the members in the FAT structures with byte offset instead
/ of structure member because there are incompatibility of the packing option
/ between various compilers. */

#define BS_jmpBoot			0
#define BS_OEMName			3
#define BPB_BytsPerSec		11
#define BPB_SecPerClus		13
#define BPB_RsvdSecCnt		14
#define BPB_NumFATs			16
#define BPB_RootEntCnt		17
#define BPB_TotSec16		19
#define BPB_Media			21
#define BPB_FATSz16			22
#define BPB_SecPerTrk		24
#define BPB_NumHeads		26
#define BPB_HiddSec			28
#define BPB_TotSec32		32
#define BS_55AA				510

#define BS_DrvNum			36
#define BS_BootSig			38
#define BS_VolID			39
#define BS_VolLab			43
#define BS_FilSysType		54

#define BPB_FATSz32			36
#define BPB_ExtFlags		40
#define BPB_FSVer			42
#define BPB_RootClus		44
#define BPB_FSInfo			48
#define BPB_BkBootSec		50
#define BS_DrvNum32			64
#define BS_BootSig32		66
#define BS_VolID32			67
#define BS_VolLab32			71
#define BS_FilSysType32		82

#define MBR_Table			446

#define	DIR_Name			0
#define	DIR_Attr			11
#define	DIR_NTres			12
#define	DIR_CrtTime			14
#define	DIR_CrtDate			16
#define	DIR_FstClusHI		20
#define	DIR_WrtTime			22
#define	DIR_WrtDate			24
#define	DIR_FstClusLO		26
#define	DIR_FileSize		28
#define IsUpper(c)	(((c)>='A')&&((c)<='Z'))
#define IsLower(c)	(((c)>='a')&&((c)<='z'))

typedef int				INT;
typedef unsigned int	UINT;

/* These types must be 8-bit integer */
typedef unsigned char	UCHAR;
typedef unsigned char	BYTE;

/* These types must be 16-bit integer */
typedef short			SHORT;
typedef unsigned short	USHORT;
typedef unsigned short	WORD;
typedef unsigned short	WCHAR;

/* These types must be 32-bit integer */
typedef long			LONG;
typedef unsigned long	ULONG;
typedef unsigned long	DWORD;
/* Status of Disk Functions */
typedef BYTE	DSTATUS;
#define	CLUST	DWORD
typedef struct {
	BYTE	fs_type;	/* FAT sub type */
	BYTE	flag;		/* File status flags */
	BYTE	csize;		/* Number of sectors per cluster */
	BYTE	pad1;
	WORD	n_rootdir;	/* Number of root directory entries (0 on FAT32) */
	CLUST	n_fatent;	/* Number of FAT entries (= number of clusters + 2) */
	DWORD	fatbase;	/* FAT start sector */
	DWORD	dirbase;	/* Root directory start sector (Cluster# on FAT32) */
	DWORD	database;	/* Data start sector */
	DWORD	fptr;		/* File R/W pointer */
	DWORD	fsize;		/* File size */
	CLUST	org_clust;	/* File start cluster */
	CLUST	curr_clust;	/* File current cluster */
	DWORD	dsect;		/* File current data sector */
} FATFS;



/* Directory object structure */

typedef struct {
	WORD	index;		/* Current read/write index number */
	BYTE*	fn;			/* Pointer to the SFN (in/out) {file[8],ext[3],status[1]} */
	CLUST	sclust;		/* Table start cluster (0:Static table) */
	CLUST	clust;		/* Current cluster */
	DWORD	sect;		/* Current sector */
} DIR;



/* File status structure */

typedef struct {
	DWORD	fsize;		/* File size */
	WORD	fdate;		/* Last modified date */
	WORD	ftime;		/* Last modified time */
	BYTE	fattrib;	/* Attribute */
	char	fname[13];	/* File name */
} FILINFO;



/* File function return code (FRESULT) */

typedef enum {
	FR_OK = 0,			/* 0 */
	FR_DISK_ERR,		/* 1 */
	FR_NOT_READY,		/* 2 */
	FR_NO_FILE,			/* 3 */
	FR_NOT_OPENED,		/* 4 */
	FR_NOT_ENABLED,		/* 5 */
	FR_NO_FILESYSTEM	/* 6 */
} FRESULT;
/*--------------------------------------------------------------*/
/* Flags and offset address                                     */

/* File status flag (FATFS.flag) */

#define	FA_OPENED	0x01
#define	FA_WPRT		0x02
#define	FA__WIP		0x40


/* FAT sub type (FATFS.fs_type) */

#define FS_FAT32	3


/* File attribute bits for directory entry */

#define	AM_RDO	0x01	/* Read only */
#define	AM_HID	0x02	/* Hidden */
#define	AM_SYS	0x04	/* System */
#define	AM_VOL	0x08	/* Volume label */
#define AM_LFN	0x0F	/* LFN entry */
#define AM_DIR	0x10	/* Directory */
#define AM_ARC	0x20	/* Archive */
#define AM_MASK	0x3F	/* Mask of defined bits */


/*--------------------------------*/
/* Multi-byte word access macros  */

#define	LD_WORD(ptr)		(WORD)(((WORD)*((BYTE*)(ptr)+1)<<8)|(WORD)*(BYTE*)(ptr))
#define	LD_DWORD(ptr)		(DWORD)(((DWORD)*((BYTE*)(ptr)+3)<<24)|((DWORD)*((BYTE*)(ptr)+2)<<16)|((WORD)*((BYTE*)(ptr)+1)<<8)|*(BYTE*)(ptr))
#define	ST_WORD(ptr,val)	*(BYTE*)(ptr)=(BYTE)(val); *((BYTE*)(ptr)+1)=(BYTE)((WORD)(val)>>8)
#define	ST_DWORD(ptr,val)	*(BYTE*)(ptr)=(BYTE)(val); *((BYTE*)(ptr)+1)=(BYTE)((WORD)(val)>>8); *((BYTE*)(ptr)+2)=(BYTE)((DWORD)(val)>>16); *((BYTE*)(ptr)+3)=(BYTE)((DWORD)(val)>>24)



/* Results of Disk Functions */
typedef enum {
	RES_OK = 0,		/* 0: Function succeeded */
	RES_ERROR,		/* 1: Disk error */
	RES_NOTRDY,		/* 2: Not ready */
	RES_PARERR		/* 3: Invalid parameter */
} DRESULT;

#define CMD0	(0x40+0)	/* GO_IDLE_STATE */
#define CMD1	(0x40+1)	/* SEND_OP_COND (MMC) */
#define	ACMD41	(0xC0+41)	/* SEND_OP_COND (SDC) 69*/
#define CMD8	(0x40+8)	/* SEND_IF_COND */
#define CMD16	(0x40+16)	/* SET_BLOCKLEN */
#define CMD17	(0x40+17)	/* READ_SINGLE_BLOCK */
#define CMD24	(0x40+24)	/* WRITE_BLOCK */
#define CMD55	(0x40+55)	/* APP_CMD 77*/
#define CMD58	(0x40+58)	/* READ_OCR 7A*/
#define CT_MMC		0x01		/* MMC ver 3 */
#define CT_SD1		0x02		/* SD ver 1 */
#define CT_SD2		0x04		/* SD ver 2 */
#define CT_SDC		(CT_SD1|CT_SD2)	/* SD */
#define CT_BLOCK	0x08		/* Block addressing */
#define STA_NOINIT		0x01	/* Drive not initialized */
#define STA_NODISK		0x02	/* No medium in the drive */
#define STA_PROTECT		0x04	/* Write protected */
#define SPI2CON *(volatile unsigned int *)(0xbf805A00)              
#define SPI2STAT *(volatile unsigned int *)(0xbf805A10)             
#define SPI2BUF *(volatile unsigned int *)(0xbf805A20)              
#define SPI2BRG *(volatile unsigned int *)(0xbf805A30)             
//#define SPIsend(a) {SPIBUF=a; while((SPISTAT & 0x80)==0); j=SPIBUF;}
#define SPI2send(a) {SPI2BUF=a; while((SPI2STAT & 0x80)==0); j=SPI2BUF;}
#define FATFS_CS_HIGH  PinSetBit(Option->SDCARD_CS,LATSET);
#define FATFS_CS_LOW  PinSetBit(Option->SDCARD_CS,LATCLR);
#define _EXCVT {0x80,0x9A,0x90,0x41,0x8E,0x41,0x8F,0x80,0x45,0x45,0x45,0x49,0x49,0x49,0x8E,0x8F,0x90,0x92,0x92,0x4F,0x99,0x4F,0x55,0x55,0x59,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F, \
				0x41,0x49,0x4F,0x55,0xA5,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0x21,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF, \
				0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF, \
				0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF}

#define IsDBCS1(c)	0
#define IsDBCS2(c)	0

int wait_ready (	UINT wt	){
    unsigned int time_in_ticks; 
    unsigned int tick_rate; 
	BYTE j;
    unsigned int current_ticks = 0; 
    tick_rate = CurrentCpuSpeed /2; //get the number of clock ticks per second 
    time_in_ticks= wt * tick_rate /1000; 
    asm volatile("mtc0 %0, $9": "+r"(current_ticks)); //set the current number of ticks to 0 
	do {
		SPI2send(0xFF);
        asm volatile("mfc0 %0, $9" : "=r"(current_ticks));//get the time in ticks since zeroed 
	} while (j != 0xFF && current_ticks<time_in_ticks);	/* Wait for card goes ready or timeout */
	return (j == 0xFF) ? 1 : 0;
}
void deselect (void)
{
    BYTE j;
	FATFS_CS_HIGH;			/* CS = H */
	SPI2send(0xFF);			/* Dummy clock (force DO hi-z for multiple slave SPI) */
}
int select (void)	/* 1:OK, 0:Timeout */
{
    BYTE j;
	FATFS_CS_LOW;
	SPI2send(0xFF);	/* Dummy clock (force DO enabled) */

	if (wait_ready(500)) {
		return 1;	/* OK */
	}
	deselect();
	return 0;	/* Timeout */
}
void mem_set (void* dst, int val, int cnt) {
	char *d = (char*)dst;
	while (cnt--) *d++ = (char)val;
}

/* Compare memory to memory */

int mem_cmp (const void* dst, const void* src, int cnt) {
	const char *d = (const char *)dst, *s = (const char *)src;
	int r = 0;
	while (cnt-- && (r = *d++ - *s++) == 0) ;
	return r;
}
char *MtoC(char *p) {
    int i;
    char *p1, *p2;
    i = *p;
    p1 = p + 1; p2 = p;
    while(i) {
        if(p1) *p2++ = *p1;
        p1++;
        i--;
    }
    *p2 = 0;
    return p;
}

BYTE send_cmd (		/* Return value: R1 resp (bit7==1:Failed to send) */
	unsigned char cmd,		/* Command index */
	DWORD arg		/* Argument */
)
{
	BYTE n, res, j;

	
	if (cmd & 0x80) {	/* Send a CMD55 prior to ACMD<n> */
		cmd &= 0x7F;
		res = send_cmd(CMD55, 0);
		if (res > 1) return res;
	}

	/* Select the card */
	FATFS_CS_HIGH;
	SPI2send(0xFF);
	FATFS_CS_LOW;
	SPI2send(0xFF);

	/* Send command packet */
	SPI2send(cmd);				/* Start + command index */
	SPI2send((BYTE)(arg >> 24));		/* Argument[31..24] */
	SPI2send((BYTE)(arg >> 16));		/* Argument[23..16] */
	SPI2send((BYTE)(arg >> 8));			/* Argument[15..8] */
	SPI2send((BYTE)arg);				/* Argument[7..0] */
	n = 0x01;							/* Dummy CRC + Stop */
	if (cmd == CMD0) n = 0x95;			/* Valid CRC for CMD0(0) */
	if (cmd == CMD8) n = 0x87;			/* Valid CRC for CMD8(0x1AA) */
	SPI2send(n);

	n = 10;								/* Wait for response (10 bytes max) */
	do {
		SPI2send(0xFF);}
	while ((j & 0x80) && --n);

	return j;							/* Return received response */
}
DRESULT disk_readp (
	BYTE *buff,		/* Pointer to the read buffer (NULL:Read bytes are forwarded to the stream) */
	DWORD sector,	/* Sector number (LBA) */
	UINT offset,	/* Byte offset to read from (0..511) */
	UINT count		/* Number of bytes to read (ofs + cnt mus be <= 512) */
)
{
	DRESULT res;
	BYTE j;
	UINT bc;


//	sector *= 512;	/* Convert to byte address if needed */

	res = RES_ERROR;
	if (send_cmd(CMD17, sector) == 0) {		/* READ_SINGLE_BLOCK */

		bc = 40000;
		do {							/* Wait for data packet */
            SPI2send(0xFF);
		} while (j == 0xFF && --bc);

		if (j == 0xFE) {				/* A data packet arrived */
			bc = 514 - offset - count;

			/* Skip leading bytes */
			if (offset) {
				do {SPI2send(0xFF);} while (--offset);
			}

			/* Receive a part of the sector */
				do {
                    SPI2send(0xFF);
					*buff++ = j;
				} while (--count);

			/* Skip remaining bytes and CRC */
			do {SPI2send(0xFF);} while (--bc);

			res = RES_OK;
		}
	}

	deselect();
	SPI2send(0xFF);
	return res;
}

DWORD clust2sect (	/* !=0: Sector number, 0: Failed - invalid cluster# */
    FATFS *fs,  
	CLUST clst		/* Cluster# to be converted */
)
{


	clst -= 2;
	if (clst >= (fs->n_fatent - 2)) return 0;		/* Invalid cluster# */
	return (DWORD)clst * fs->csize + fs->database;
}
FRESULT dir_rewind (
    FATFS *fs,  
	DIR *dj			/* Pointer to directory object */
)
{
	CLUST clst;


	dj->index = 0;
	clst = dj->sclust;
	if (clst == 1 || clst >= fs->n_fatent)	/* Check start cluster range */
		return FR_DISK_ERR;
	if (!clst)	/* Replace cluster# 0 with root cluster# if in FAT32 */
		clst = (CLUST)fs->dirbase;
	dj->clust = clst;						/* Current cluster */
	dj->sect = clust2sect(fs,clst);	/* Current sector */

	return FR_OK;	/* Seek succeeded */
}
FRESULT create_name (
	DIR *dj,			/* Pointer to the directory object */
	const char **path	/* Pointer to pointer to the segment in the path string */
)
{
	BYTE c, ni, si, i, *sfn;
	const char *p;
#if _USE_LCC
#ifdef _EXCVT
	static const BYTE cvt[] = _EXCVT;
#endif
#endif

	/* Create file name in directory form */
	sfn = dj->fn;
	mem_set(sfn, ' ', 11);
	si = i = 0; ni = 8;
	p = *path;
	for (;;) {
		c = p[si++];
		if (c <= ' ' || c == '/') break;	/* Break on end of segment */
		if (c == '.' || i >= ni) {
			if (ni != 8 || c != '.') break;
			i = 8; ni = 11;
			continue;
		}
#if _USE_LCC
#ifdef _EXCVT
		if (c >= 0x80)					/* To upper extended char (SBCS) */
			c = cvt[c - 0x80];
#endif
		if (IsDBCS1(c) && i < ni - 1) {	/* DBC 1st byte? */
			BYTE d = p[si++];			/* Get 2nd byte */
			sfn[i++] = c;
			sfn[i++] = d;
		} else
#endif
		{						/* Single byte code */
			if (_USE_LCC && IsLower(c)) c -= 0x20;	/* toupper */
			sfn[i++] = c;
		}
	}
	*path = &p[si];						/* Rerurn pointer to the next segment */

	sfn[11] = (c <= ' ') ? 1 : 0;		/* Set last segment flag if end of path */

	return FR_OK;
}
CLUST get_clust (
    FATFS *fs,  
	BYTE* dir		/* Pointer to directory entry */
)
{
	CLUST clst = 0;


	clst = LD_WORD(dir+DIR_FstClusHI);
	clst <<= 16;
	clst |= LD_WORD(dir+DIR_FstClusLO);

	return clst;
}
CLUST get_fat (	/* 1:IO error, Else:Cluster status */
    FATFS *fs,   
	CLUST clst	/* Cluster# to get the link information */
)
{
	BYTE buf[4];

	if (clst < 2 || clst >= fs->n_fatent)	/* Range check */
		return 1;


		if (disk_readp(buf, fs->fatbase + clst / 128, ((UINT)clst % 128) * 4, 4)) return 1;
		return LD_DWORD(buf) & 0x0FFFFFFF;



		/* An error occurred at the disk I/O layer */
}
FRESULT dir_next (	/* FR_OK:Succeeded, FR_NO_FILE:End of table */
    FATFS *fs,   
	DIR *dj			/* Pointer to directory object */
)
{
	CLUST clst;
	WORD i;


	i = dj->index + 1;
	if (!i || !dj->sect)	/* Report EOT when index has reached 65535 */
		return FR_NO_FILE;

	if (!(i % 16)) {		/* Sector changed? */
		dj->sect++;			/* Next sector */

		if (dj->clust == 0) {	/* Static table */
			if (i >= fs->n_rootdir)	/* Report EOT when end of table */
				return FR_NO_FILE;
		}
		else {					/* Dynamic table */
			if (((i / 16) & (fs->csize - 1)) == 0) {	/* Cluster changed? */
				clst = get_fat(fs,dj->clust);		/* Get next cluster */
				if (clst <= 1) return FR_DISK_ERR;
				if (clst >= fs->n_fatent)		/* When it reached end of dynamic table */
					return FR_NO_FILE;			/* Report EOT */
				dj->clust = clst;				/* Initialize data for new cluster */
				dj->sect = clust2sect(fs,clst);
			}
		}
	}

	dj->index = i;

	return FR_OK;
}
FRESULT dir_find (
    FATFS *fs,   
	DIR *dj,		/* Pointer to the directory object linked to the file name */
	BYTE *dir		/* 32-byte working buffer */
)
{
	FRESULT res;
	BYTE c;


	res = dir_rewind(fs,dj);			/* Rewind directory object */
	if (res != FR_OK) return res;

	do {
		res = disk_readp(dir, dj->sect, (dj->index % 16) * 32, 32)	/* Read an entry */
			? FR_DISK_ERR : FR_OK;
		if (res != FR_OK) break;
		c = dir[DIR_Name];	/* First character */
		if (c == 0) { res = FR_NO_FILE; break; }	/* Reached to end of table */
		if (!(dir[DIR_Attr] & AM_VOL) && !mem_cmp(dir, dj->fn, 11)) /* Is it a valid entry? */
			break;
		res = dir_next(fs,dj);					/* Next entry */
	} while (res == FR_OK);

	return res;
}

FRESULT follow_path (	/* FR_OK(0): successful, !=0: error code */
    FATFS *fs,   
	DIR *dj,			/* Directory object to return last directory and found object */
	BYTE *dir,			/* 32-byte working buffer */
	const char *path	/* Full-path string to find a file or directory */
)
{
	FRESULT res;


	while (*path == ' ') path++;		/* Strip leading spaces */
	if (*path == '/') path++;			/* Strip heading separator if exist */
	dj->sclust = 0;						/* Set start directory (always root dir) */

	if ((BYTE)*path < ' ') {			/* Null path means the root directory */
		res = dir_rewind(fs,dj);
		dir[0] = 0;

	} else {							/* Follow path */
		for (;;) {
			res = create_name(dj, &path);	/* Get a segment */
			if (res != FR_OK) break;
			res = dir_find(fs,dj, dir);		/* Find it */
			if (res != FR_OK) break;		/* Could not find the object */
			if (dj->fn[11]) break;			/* Last segment match. Function completed. */
			if (!(dir[DIR_Attr] & AM_DIR)) { /* Cannot follow path because it is a file */
				res = FR_NO_FILE; break;
			}
			dj->sclust = get_clust(fs,dir);	/* Follow next */
		}
	}

	return res;
}

#define ABORT(err)	{fs->flag = 0; return err;}
FRESULT pf_lseek (
    FATFS *fs,
	DWORD ofs		/* File pointer from top of file */
)
{
	CLUST clst;
	DWORD bcs, sect, ifptr;


	if (!fs) return FR_NOT_ENABLED;		/* Check file system */
	if (!(fs->flag & FA_OPENED))		/* Check if opened */
			return FR_NOT_OPENED;

	if (ofs > fs->fsize) ofs = fs->fsize;	/* Clip offset with the file size */
	ifptr = fs->fptr;
	fs->fptr = 0;
	if (ofs > 0) {
		bcs = (DWORD)fs->csize * 512;	/* Cluster size (byte) */
		if (ifptr > 0 &&
			(ofs - 1) / bcs >= (ifptr - 1) / bcs) {	/* When seek to same or following cluster, */
			fs->fptr = (ifptr - 1) & ~(bcs - 1);	/* start from the current cluster */
			ofs -= fs->fptr;
			clst = fs->curr_clust;
		} else {							/* When seek to back cluster, */
			clst = fs->org_clust;			/* start from the first cluster */
			fs->curr_clust = clst;
		}
		while (ofs > bcs) {				/* Cluster following loop */
			clst = get_fat(fs,clst);		/* Follow cluster chain */
			if (clst <= 1 || clst >= fs->n_fatent) ABORT(FR_DISK_ERR);
			fs->curr_clust = clst;
			fs->fptr += bcs;
			ofs -= bcs;
		}
		fs->fptr += ofs;
		sect = clust2sect(fs,clst);		/* Current sector */
		if (!sect) ABORT(FR_DISK_ERR);
		fs->dsect = sect + (fs->fptr / 512 & (fs->csize - 1));
	}

	return FR_OK;
}
FRESULT pf_read (
    FATFS *fs,   
	void* buff,		/* Pointer to the read buffer (NULL:Forward data to the stream)*/
	UINT btr,		/* Number of bytes to read */
	UINT* br		/* Pointer to number of bytes read */
)
{
	DRESULT dr;
	CLUST clst;
	DWORD sect, remain;
	UINT rcnt;
	BYTE cs, *rbuff = buff;


	*br = 0;
	if (!fs) return FR_NOT_ENABLED;		/* Check file system */
	if (!(fs->flag & FA_OPENED))		/* Check if opened */
		return FR_NOT_OPENED;

	remain = fs->fsize - fs->fptr;
	if (btr > remain) btr = (UINT)remain;			/* Truncate btr by remaining bytes */

	while (btr)	{									/* Repeat until all data transferred */
		if ((fs->fptr % 512) == 0) {				/* On the sector boundary? */
			cs = (BYTE)(fs->fptr / 512 & (fs->csize - 1));	/* Sector offset in the cluster */
			if (!cs) {								/* On the cluster boundary? */
				if (fs->fptr == 0)					/* On the top of the file? */
					clst = fs->org_clust;
				else
					clst = get_fat(fs,fs->curr_clust);
				if (clst <= 1) ABORT(FR_DISK_ERR);
				fs->curr_clust = clst;				/* Update current cluster */
			}
			sect = clust2sect(fs,fs->curr_clust);		/* Get current sector */
			if (!sect) ABORT(FR_DISK_ERR);
			fs->dsect = sect + cs;
		}
		rcnt = 512 - (UINT)fs->fptr % 512;			/* Get partial sector data from sector buffer */
		if (rcnt > btr) rcnt = btr;
		dr = disk_readp(!buff ? 0 : rbuff, fs->dsect, (UINT)fs->fptr % 512, rcnt);
		if (dr) ABORT(FR_DISK_ERR);
		fs->fptr += rcnt; rbuff += rcnt;			/* Update pointers and counters */
		btr -= rcnt; *br += rcnt;
	}

	return FR_OK;
}
/*-----------------------------------------------------------------------*/
/* Write partial sector                                                  */
/*-----------------------------------------------------------------------*/


DRESULT disk_writep (
	BYTE *buff,	/* Pointer to the bytes to be written (NULL:Initiate/Finalise sector write) */
	DWORD sc			/* Number of bytes to send, Sector number (LBA) or zero */
)
{
	DRESULT res;
	UINT bc;
	static WORD wc;
    BYTE j;

	res = RES_ERROR;

	if (buff) {		/* Send data bytes */
		bc = (WORD)sc;
		while (bc && wc) {		/* Send data bytes to the card */
			SPI2send(*buff++);
			wc--; bc--;
		}
		res = RES_OK;
	} else {
		if (sc) {	/* Initiate sector write process */
			if (send_cmd(CMD24, sc) == 0) {			/* WRITE_SINGLE_BLOCK */
				SPI2send(0xFF); SPI2send(0xFE);		/* Data block header */
				wc = 512;							/* Set byte counter */
				res = RES_OK;
			}
		} else {	/* Finalize sector write process */
			bc = wc + 2;
			while (bc--) SPI2send(0);	/* Fill left bytes and CRC with zeros */
            SPI2send(0xFF);
			if ((j & 0x1F) == 0x05) {	/* Receive data resp and wait for end of write process in timeout of 500ms */
				for (bc = 5000; j != 0xFF && bc; bc--) {uSec(100);SPI2send(0xFF);}	/* Wait ready */
				if (bc) res = RES_OK;
			}
			deselect();
			SPI2send(0xFF);
		}
	}

	return res;
}
FRESULT pf_write (
	FATFS *fs,
    BYTE *buff,	/* Pointer to the data to be written */
	UINT btw,			/* Number of bytes to write (0:Finalize the current write operation) */
	UINT* bw			/* Pointer to number of bytes written */
)
{
	CLUST clst;
	DWORD sect, remain;
	BYTE *p = buff;
	BYTE cs;
	UINT wcnt;


	*bw = 0;
	if (!fs) return FR_NOT_ENABLED;		/* Check file system */
	if (!(fs->flag & FA_OPENED))		/* Check if opened */
		return FR_NOT_OPENED;

	if (!btw) {		/* Finalise request */
		if ((fs->flag & FA__WIP) && disk_writep(0, 0)) ABORT(FR_DISK_ERR);
		fs->flag &= ~FA__WIP;
		return FR_OK;
	} else {		/* Write data request */
		if (!(fs->flag & FA__WIP))		/* Round-down fptr to the sector boundary */
			fs->fptr &= 0xFFFFFE00;
	}
	remain = fs->fsize - fs->fptr;
	if (btw > remain) btw = (UINT)remain;			/* Truncate btw by remaining bytes */

	while (btw)	{									/* Repeat until all data transferred */
		if ((UINT)fs->fptr % 512 == 0) {			/* On the sector boundary? */
			cs = (BYTE)(fs->fptr / 512 & (fs->csize - 1));	/* Sector offset in the cluster */
			if (!cs) {								/* On the cluster boundary? */
				if (fs->fptr == 0)					/* On the top of the file? */
					clst = fs->org_clust;
				else
					clst = get_fat(fs,fs->curr_clust);
				if (clst <= 1) ABORT(FR_DISK_ERR);
				fs->curr_clust = clst;				/* Update current cluster */
			}
			sect = clust2sect(fs,fs->curr_clust);		/* Get current sector */
			if (!sect) ABORT(FR_DISK_ERR);
			fs->dsect = sect + cs;
			if (disk_writep(0, fs->dsect)) ABORT(FR_DISK_ERR);	/* Initiate a sector write operation */
			fs->flag |= FA__WIP;
		}
		wcnt = 512 - (UINT)fs->fptr % 512;			/* Number of bytes to write to the sector */
		if (wcnt > btw) wcnt = btw;
		if (disk_writep(p, wcnt)) ABORT(FR_DISK_ERR);	/* Send data to the sector */
		fs->fptr += wcnt; p += wcnt;				/* Update pointers and counters */
		btw -= wcnt; *bw += wcnt;
		if ((UINT)fs->fptr % 512 == 0) {
			if (disk_writep(0, 0)) ABORT(FR_DISK_ERR);	/* Finalise the current sector write operation */
			fs->flag &= ~FA__WIP;
		}
	}

	return FR_OK;
}
int disk_initialize (void) {
    int FATFS_SD_Stat;
	BYTE n, j, ty, ocr[4];
    unsigned int time_in_ticks; 
    unsigned int tick_rate; 
    unsigned int current_ticks = 0; 
    tick_rate = CurrentCpuSpeed /2; //get the number of clock ticks per second 
    time_in_ticks = tick_rate; //1 second timeout
	SPI2BRG=59; //set to 400,000HZ
	for (n = 10; n; n--) {
		SPI2send(0xFF);
	}
	ty = 0;
	if (send_cmd(CMD0, 0) == 1) {				/* Put the card SPI/Idle state */
		//Timer1 = 1000;						/* Initialisation timeout = 1 sec */
        asm volatile("mtc0 %0, $9": "+r"(current_ticks)); //set the current number of ticks to 0 
		if (send_cmd(CMD8, 0x1AA) == 1) {	/* SDv2? */
			for (n = 0; n < 4; n++){ SPI2send(0xFF); ocr[n] = j;}	/* Get 32 bit return value of R7 resp */
			if (ocr[2] == 0x01 && ocr[3] == 0xAA) {				/* Is the card supports vcc of 2.7-3.6V? */
				do {
                    asm volatile("mfc0 %0, $9" : "=r"(current_ticks));//get the time in ticks since zeroed 
                }
                while (time_in_ticks>current_ticks && send_cmd(ACMD41, 1UL << 30)) ;	/* Wait for end of initialization with ACMD41(HCS) */
				if (time_in_ticks>current_ticks && send_cmd(CMD58, 0) == 0) {		/* Check CCS bit in the OCR */
					for (n = 0; n < 4; n++) {
                        SPI2send(0xFF);
						ocr[n] = j;
					}
					ty = (ocr[0] & 0x40) ? CT_SD2 | CT_BLOCK : CT_SD2;	/* Card id SDv2 */
				}
			}
		} 
	}
	FATFS_SD_Stat = ty;	/* Card type */
	deselect();
	if (ty) {			/* OK */
		FATFS_SD_Stat &= ~STA_NOINIT;	/* Clear STA_NOINIT flag */
		SPI2BRG=2;
	} else {			/* Failed */
		FATFS_SD_Stat = STA_NOINIT;
	}

	
	return FATFS_SD_Stat;
}
BYTE check_fs (	/* 0:The FAT boot record, 1:Valid boot record but not an FAT, 2:Not a boot record, 3:Error */
	BYTE *buf,	/* Working buffer */
	DWORD sect	/* Sector# (lba) to check if it is an FAT boot record or not */
)
{
    BYTE i;
	if (disk_readp(buf, sect, 510, 2))		/* Read the boot record */
		return 3;
	if (LD_WORD(buf) != 0xAA55)				/* Check record signature */
		return 2;
    i=disk_readp(buf, sect, BS_FilSysType32, 2);
	if (!i && LD_WORD(buf) == 0x4146)	return 0;
	return 1;
}
FRESULT pf_mount ( FATFS *fs)
{
	BYTE fmt, buf[36];
	DWORD bsect, fsize, tsect, mclst;

	/* Search FAT partition on the drive */
	bsect = 0;
	fmt = check_fs(buf, bsect);			/* Check sector 0 as an SFD format */
	if (fmt == 1) {						/* Not an FAT boot record, it may be FDISK format */
		/* Check a partition listed in top of the partition table */
		if (disk_readp(buf, bsect, MBR_Table, 16)) {	/* 1st partition entry */
			fmt = 3;
		} else {
			if (buf[4]) {					/* Is the partition existing? */
				bsect = LD_DWORD(&buf[8]);	/* Partition offset in LBA */
                fmt = check_fs(buf, bsect);	/* Check the partition */
			}
		}
	}
	if (fmt == 3) return FR_DISK_ERR;
	if (fmt) return FR_NO_FILESYSTEM;	/* No valid FAT partition is found */

	/* Initialise the file system object */
	if (disk_readp(buf, bsect, 13, sizeof (buf))) return FR_DISK_ERR;

	fsize = LD_DWORD(buf+BPB_FATSz32-13);

	fsize *= buf[BPB_NumFATs-13];						/* Number of sectors in FAT area */
	fs->fatbase = bsect + LD_WORD(buf+BPB_RsvdSecCnt-13); /* FAT start sector (lba) */
	fs->csize = buf[BPB_SecPerClus-13];					/* Number of sectors per cluster */
	fs->n_rootdir = LD_WORD(buf+BPB_RootEntCnt-13);		/* Number of root directory entries */
	tsect = LD_WORD(buf+BPB_TotSec16-13);				/* Number of sectors on the file system */
	if (!tsect) tsect = LD_DWORD(buf+BPB_TotSec32-13);
	mclst = (tsect						/* Last cluster# + 1 */
		- LD_WORD(buf+BPB_RsvdSecCnt-13) - fsize - fs->n_rootdir / 16
		) / fs->csize + 2;
	fs->n_fatent = (CLUST)mclst;

	fmt = 0;							/* Determine the FAT sub type */
	if (mclst >= 0xFFF7)
		fmt = FS_FAT32;
	if (!fmt) return FR_NO_FILESYSTEM;
	fs->fs_type = fmt;

	fs->dirbase = LD_DWORD(buf+(BPB_RootClus-13));	/* Root directory start cluster */
	fs->database = fs->fatbase + fsize + fs->n_rootdir / 16;	/* Data start sector (lba) */
	fs->flag = 0;
	return FR_OK;
}
/* Open or Create a File                                                 */
/*-----------------------------------------------------------------------*/

FRESULT pf_open (
    FATFS *fs,   
	char *path	/* Pointer to the file name */
)
{
	FRESULT res;
	DIR dj;
	BYTE sp[12], dir[32];


	if (!fs) return FR_NOT_ENABLED;		/* Check file system */

	fs->flag = 0;
	dj.fn = sp;
	res = follow_path(fs,&dj, dir, path);	/* Follow the file path */
	if (res != FR_OK) return res;		/* Follow failed */
	if (!dir[0] || (dir[DIR_Attr] & AM_DIR))	/* It is a directory */
		return FR_NO_FILE;

	fs->org_clust = get_clust(fs,dir);		/* File start cluster */
	fs->fsize = LD_DWORD(dir+DIR_FileSize);	/* File size */
	fs->fptr = 0;						/* File pointer */
	fs->flag = FA_OPENED;

	return FR_OK;
}
#define SPI2_INP_PIN        (HAS_44PINS ?  23 : 6) //B2
#define SPI2_OUT_PIN        (HAS_44PINS ?  11 : 24)//B13 
#define SPI2_CLK_PIN        (HAS_44PINS ?  15 : 26)//B15
#define SPI2_PPS_OPEN       {PPSInput(3, SDI2, RPB2); PPSOutput(3, RPB13, SDO2); }

long long main(void *FATheader, long *mode, char *p1, long *p2, long *p3, long *p4){
        int i=0,j,k,nextsector, loopend;
        DWORD secstart,secoffset;
        FATFS *FatFs;
        char *r, *s, *p;
        FatFs=FATheader;
        if(*mode==0){//initialise and mount the SDcard
            ExtCfg(SPI2_OUT_PIN, EXT_DIG_OUT, 0); ExtCfg(SPI2_OUT_PIN, EXT_RESERVED, 0);
            ExtCfg(SPI2_INP_PIN, EXT_DIG_IN, 0); ExtCfg(SPI2_INP_PIN, EXT_RESERVED, 0);
            ExtCfg(SPI2_CLK_PIN, EXT_DIG_OUT, 0); ExtCfg(SPI2_CLK_PIN, EXT_RESERVED, 0);
            SPI2_PPS_OPEN;
            SPI2CON=0x8060;
            SPI2CON2=0xC00;// this is defined in IOPorts.h
            Option->SDCARD_CS=*p1;
            ExtCfg(Option->SDCARD_CS,EXT_DIG_OUT,0);
            PinSetBit(Option->SDCARD_CS, LATSET);
            i=disk_initialize();
            if(i & STA_NOINIT)return 1;
            i=pf_mount(FatFs);
        }
        if(*mode==1){ //open a file
            i=pf_open(FatFs,MtoC(p1));
        }
        if(*mode==2 ){ //read or write a file
            if(*p2>=0)i=pf_lseek(FatFs,*p2);
            if(!i){
               if(*p3<256){ //return as a string
                    i=pf_read(FatFs,p1+1,*p3,&j );
                    p1[0]=j;
                } else {
                    i=pf_read(FatFs,p1,*p3,&j );
                }
            *p4=j;
            } 
        }
        if(*mode==3){
            secstart= *p2 & 0xFFFFFE00; //point to sector start
            secoffset= *p2 & 0x1FF; //offset into the sector
            i=pf_lseek(FatFs,secstart);
            s=p1; if(*p3<256) s=p1+1; //move past the length byte if a string
            if(secstart!=*p2){ //not sector aligned
                p=GetTempMemory(512);
                i=pf_read(FatFs,p,512,&j ); //read in the sector
                i=pf_lseek(FatFs,secstart);
                if(!i){ //read OK
                    if(512 < *p3+secoffset){
                        loopend=512;
                        nextsector=*p3+secoffset-512;
                    } else {
                        loopend=*p3+secoffset;
                        nextsector=0;
                    }
                    for(k=secoffset;k<  loopend ;k++){
                        p[k]=s[k-secoffset]; //write the new data into the buffer
                    }
                    i=pf_write(FatFs,p,j,&j );
                    if(nextsector)i=pf_write(FatFs,s+(*p3-nextsector),nextsector,&j );
                    i=pf_write(FatFs,0,0,&j ); //finish the write
                }
            } else {
                i=pf_write(FatFs,s,*p3,&j );
                i=pf_write(FatFs,0,0,&j );
            }
        }
        return i;
}
