#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "../cfunctions.h"
#define magic 0
#define t1pin 1
#define t1port 2
#define t1count 3
#define debugging

//
    void T1Int(void){
    *(volatile unsigned int *)CFuncRam[t1port]=CFuncRam[t1pin];
    if(!(CFuncRam[t1count]--)){
        mT1IntEnable(0);
        T1CON=0;
        CFuncT1=0;
        CFuncRam[t1pin]=0;
        CFuncRam[t1port]=0;
    }
}


__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) 
     { 
         *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;      
     } 

#ifdef debugging
void p_string(const char *s){
    volatile unsigned int libAddr ; 
    getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor 
    getFPCLab: { } 
    unsigned char  * testData    = (unsigned char *)((void *)s + libAddr );
    MMPrintString(testData);
}
void p_int(int a,int base){
    char b[64];
    IntToStr(b,a,base);
    MMPrintString(b);
}
void p_float(float a,int m, int n, char c){
// m is the nbr of chars before the decimal point
// n is the nbr chars after the point
// ch is the leading pad char
    char b[14];
    FloatToStr(b,a, m, n ,c);
    MMPrintString(b);
}
#endif

void main(long long *pin, float *frequency, float *duration){

    volatile unsigned int libAddr ; 
    getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor 
    getFPCLab: { } 
    int ps,clockspeed,divide=1;
    float counts,tickspersecond,tickrate;
    counts=FMul(*frequency,*duration);
    counts=FMul(counts,LoadFloat(0x40000000)); //number of interrupts for the pulse train
    clockspeed=CurrentCpuSpeed; 
#ifdef debugging
    static const char crlf[]="\r\n";
    static const char s1[]="Clock speed= ";
    static const char s2[]="Tick Rate= ";
#endif
    CFuncRam[magic]=0xA5A5A5A5;
    if(clockspeed>80000000){ //start by assuming divide by 1
        clockspeed/=4;
    } else {
        clockspeed/=2;        
    }
    tickspersecond=IntToFloat(clockspeed);
    tickrate=FDiv(tickspersecond,*frequency);
#ifdef debugging
    p_string(s1);    p_float(tickspersecond,10,1,' '); p_string(crlf);
    p_string(s2);    p_float(tickrate,10,1,' '); p_string(crlf);
#endif
    while(FCmp(tickrate,IntToFloat(0xFFFF))==1){
        tickrate=FDiv(tickrate,LoadFloat(0x41000000));
        divide*=8;
    }
    
    mT1IntEnable(0);          
    ExtCfg(*pin,EXT_DIG_OUT,0);
    CFuncRam[t1port]=(int)(volatile unsigned int *)GetPortAddr(*pin,LATINV);
    CFuncRam[t1pin]=1<<GetPinBit(*pin);
    PinSetBit(*pin, LATCLR);

    CFuncT1=(unsigned int)&T1Int + libAddr;
    CFuncRam[t1count]=FloatToInt(counts); //used to hold count of cycles
    ps=0;
    if(divide==8)ps=0x10;
    if(divide==64)ps=0x20;
    PR1 = FloatToInt(tickrate);
    T1CON = 0x8000 | ps;         										// T5 on, prescaler as input
    mT1SetIntPriority(1);  											// high priority
    mT1ClearIntFlag();      										// clear interrupt flag
    mT1IntEnable(1);

 }
