option explicit 
option default FLOAT 
'
'  Micromite AHRS using MPU6050
'  Original source ode from kriswiner (https://github.com/kriswiner/MPU-6050)
'  and Sebastion Madgwick's Open source IMU and AHRS algorithms
'
'  Use TFT display in landscape mode to display position
'
'   MPU6050 connections
'   GND
'   VCC - 3.3V
'   SCL to I2C clock
'   SDA to I2C data
'   NCS to 3.3V (needed to force I2C)
'   INT to intPin
'   AD0 to GND or 3.3V (see address below)
const  intPin = 16  
'const MPU6050_ADDRESS =&H69  ' Device address when ADO = 1
const MPU6050_ADDRESS =&H68  ' Device address when ADO = 0
backlight 10
'
const  screenIO=0 'set to 1 to do fast output on TFT screen, otherwise 0
'
'Magnetometer Registers and constants
const  HMC5883L_I2C = &h1e 
const  HMC5883_MAGGAIN_4_7 = &hA0' +/- 4.7 
const  hmc5883_Gauss_LSB_X  = 381 'least significant bits per uT 
const  hmc5883_Gauss_LSB_Y  = 403  
const  hmc5883_Gauss_LSB_Z   = 349 
const  magbias_x = 12.2 ' User environmental correction  (hard-iron) in MICROTESLA from calibration routine 
const  magbias_y = 20.6  
const  magbias_z = 2.7  
const  GAUSS_TO_MICROTESLA = 100 
Const  HMC5883_CONFIG_A = 0
Const  HMC5883_CONFIG_B = 1
Const  HMC5883_MODE = 2
Const  HMC5883_MSB_X = 3
Const  HMC5883_ID_A = 10

' Gyro/accelerometer registers
const SMPLRT_DIV       =&H19
const CONFIG           =&H1A
const GYRO_CONFIG      =&H1B
const ACCEL_CONFIG     =&H1C
const INT_PIN_CFG      =&H37
const INT_ENABLE       =&H38
const DMP_INT_STATUS   =&H39  ' Check DMP interrupt
const ACCEL_XOUT_H     =&H3B
const TEMP_OUT_H       =&H41
const USER_CTRL        =&H6A  ' Bit 7 enable DMP, bit 3 reset DMP
const PWR_MGMT_1       =&H6B ' Device defaults to the SLEEP mode
const WHO_AM_I_MPU6050 =&H75 ' Should return =&H71
const AFS_2G = 0
const AFS_4G =1
const AFS_8G =2
const AFS_16G =3
const GFS_250DPS = 0
const GFS_500DPS =1
const GFS_1000DPS =2
const GFS_2000DPS =3
const MFS_14BITS = 0'  0.6 mG per LSB
const MFS_16BITS =1' 0.15 mG per LSB
const sampleFreq=4.0			' sample frequency in Hz
const twoKpDef=1	' 2 * proportional gain
'
' 3D solid graphics demo using quaternions to rotate the coordinates 
'
cls 
backlight 50
'
' Adjust the following to fit your display
'
dim scale=600 'length of the edge of the cube in "real" space
'define the projection plane in units from the observer
DIM viewplane = -500 
DIM cubelocation(2)=(mm.hres/2,MM.VRES/6,-2000) 'actual location of the centre of the cube in "real" 3D space 
'
'
' define the coordinates of a cube with the z-axis towards the viewer and the centre at 0,0,0
dim cube(3,7)=(-1,-0.5,0.2,0, -1,0.5,0.2,0, 1,0.5,0.2,0, 1,-0.5,0.2,0, -1,-0.5,-0.2,0, -1,0.5,-0.2,0, 1,0.5,-0.2,0, 1,-0.5,-0.2,0 ) 'coordinates of the cube
dim cubeini(3,7)=(-1,-0.5,0.2,0, -1,0.5,0.2,0, 1,0.5,0.2,0, 1,-0.5,0.2,0, -1,-0.5,-0.2,0, -1,0.5,-0.2,0, 1,0.5,-0.2,0, 1,-0.5,-0.2,0 ) 'coordinates of the cube
dim centroid(3,5)=(0,0,0.2,0,  -1,0,0,0,   0,0.5,0,0,   1,0,0,0,   0,0,-0.2,0,  0,-0.5,0,0) 'centre of each face in space
dim centroidini(3,5)=(0,0,0.2,0,  -1,0,0,0,   0,0.5,0,0,   1,0,0,0,   0,0,-0.2,0,  0,-0.5,0,0) 'centre of each face in space
'
' define the coordinate triples that make up two triangles for each face of the cube, together with a face index number
' all drawing is done as filled triangles
' NB the triangles must be in the same order as the faces, two triangles/face
'
dim cubetriangles%(3,11)=(0,1,2,0, 0,2,3,0,  0,1,5,1, 0,4,5,1,  1,2,6,2, 1,5,6,2,  3,6,7,3, 3,2,6,3,  4,6,7,4, 4,5,6,4,  0,4,7,5, 0,3,7,5) 
'
dim v(4),vout(4),M_PI=3.14159265359,i%,j%,k%,x1,y1,z1,x2,y2,z2,x3,y3,z3,p%
'
dim float accelbias(2)=(0.009,-0.024,0.0), gyrobias(2)=(0.032,-0.015,0.0)
'
' 
' Global Variable definitions 
' 
DIM FLOAT BETA = 0.2 ' gain of algorithm derived from testing 
dim float q(4) = (0,0,0,0,0)' quaternion of sensor frame relative to auxiliary frame set to North
q(1)=sqr(2)/2 
q(2)=sqr(2)/2 
dim csort(5)
dim sortorder%(5)
DIM integer yinc, xx0(11), yy0(11), xx1(11), yy1(11), xx2(11), yy2(11), tcol(5) ,scol(11) 'arrays for calling the triangle draw routine
'
' Golbal Variable definitions
'
DIM INTEGER Gscale = GFS_250DPS
DIM INTEGER Ascale = AFS_8G
DIM INTEGER Mscale = MFS_16BITS ' Choose either 14-bit or 16-bit magnetometer resolution
DIM float magcount(6)        ' 2 for 8 Hz, 6 for 100 Hz continuous magnetometer data read
DIM FLOAT magbias(2),gRes,mRes,aRes
dim float ax,ay,az,gx,gy,gz,mx,my,mz,fmult
dim float pitch,yaw,roll
dim integer gdata(13),mData(5),temp%
DIM ID$ length 3
DIM INTEGER lastrun
DIM FLOAT accs(2),mags(2),gees(2)
'
'  Setup
'
i2c open 400,1000
setpin intPin,DIN
pause 100
writeByte(MPU6050_ADDRESS,PWR_MGMT_1,&H80)
pause 500
initMPU6050
temp%=readByte(MPU6050_ADDRESS,WHO_AM_I_MPU6050)
if temp%<>&H68 then
    Print "MPU6050 not found"
    end
endif
readByteString(HMC5883L_I2C,HMC5883_ID_A,3,ID$)
if ID$<>"H43" then
    Print "HMC5883 not found"
    end
endif
print "Internal temperature is ",readTempData()
cls
initHMC5883
getAres
getGres
getMres
fmult=gRes*PI/180.0
magbias(0) = 0'  ' User environmental x-axis correction in MICROTESLA, should be automatically calculated
magbias(1) = 0'  ' User environmental y-axis correction in MICROTESLA
magbias(2) = 0'  ' User environmental z-axis correction in MICROTESLA

timer=0
'
for i%=0 to 7 'scale the cube verticies up depending on the display size
  for j%=0 to 2
    cube(j%,i%)=cube(j%,i%)*scale/2
    cubeini(j%,i%)=cubeini(j%,i%)*scale/2
  next j%
next i%  
'
for i%=0 to 5 'scale the centroid positions up depending on the display size
  for j%=0 to 2
    centroid(j%,i%)=centroid(j%,i%)*scale/2
    centroidini(j%,i%)=centroidini(j%,i%)*scale/2
  next j%
next i%  
' 

'
' define the colour of each face of the cube
tcol(0)=rgb(red)
tcol(1)=rgb(blue)
tcol(2)=rgb(magenta)
tcol(3)=rgb(yellow)
tcol(4)=rgb(cyan)
tcol(5)=rgb(green)

 
for i%=0 to 7 'convert coordinates to normalised form 
  x1=cube(0,i%): y1=cube(1,i%): z1=cube(2,i%) 
  create_vector(x1,y1,z1,v()) 
  cube(0,i%)=v(2): cube(1,i%)=v(3): cube(2,i%)=v(4): cube(3,i%)=v(0) 
  cubeini(0,i%)=v(2): cubeini(1,i%)=v(3): cubeini(2,i%)=v(4): cubeini(3,i%)=v(0) 
next i% 
'
for i%=0 to 5 'convert centroid coordinates to normalised form 
  x1=centroid(0,i%): y1=centroid(1,i%): z1=centroid(2,i%) 
  create_vector(x1,y1,z1,v()) 
  centroid(0,i%)=v(2): centroid(1,i%)=v(3): centroid(2,i%)=v(4): centroid(3,i%)=v(0) 
  centroidini(0,i%)=v(2): centroidini(1,i%)=v(3): centroidini(2,i%)=v(4): centroidini(3,i%)=v(0) 
next i% 

'
p%=0 'start by writing to the first page
ssd1963 2' start by displaying page 2
do 
  getquaternion
  'create_normalised_quaternion(15,1,0.5,0.25,q())
  for i%=0 to 7 'rotate coordinates 
    v(2)=cubeini(0,i%): v(3)=cubeini(1,i%): v(4)=cubeini(2,i%): v(0)=cubeini(3,i%): v(1)=0 
    rotate_vector(vout(),v(),q()) 
    cube(0,i%)=vout(2): cube(1,i%)=vout(3): cube(2,i%)=vout(4): cube(3,i%)=vout(0) 
  next i% 
  '
  for i%=0 to 5 'rotate centroids 
    v(2)=centroidini(0,i%): v(3)=centroidini(1,i%): v(4)=centroidini(2,i%): v(0)=centroidini(3,i%): v(1)=0 
    rotate_vector(vout(),v(),q()) 
    centroid(0,i%)=vout(2): centroid(1,i%)=vout(3): centroid(2,i%)=vout(4): centroid(3,i%)=vout(0) 
    csort(i%)=vout(4)
    sortorder%(i%)=i%
  next i% 
'
  floatindexsort(csort(),sortorder%(),6) 'sort the faces in the order of the depth
'
  yinc=0
  if p% and 1 then yinc=272
  p%=p%+1    
  for i%=0 to 5 'project the coordinates onto the viewplane 
    j%=sortorder%(i%)*2 'get the furthest, as yet undisplayed, face from the viewer
    k%=i%*2
    z1=cube(2,cubetriangles%(0,j%))*cube(3,cubetriangles%(0,j%))+cubelocation(2) 
    x1=(cube(0,cubetriangles%(0,j%))*cube(3,cubetriangles%(0,j%))*viewplane/z1 +cubelocation(0)) 
    y1=(cube(1,cubetriangles%(0,j%))*cube(3,cubetriangles%(0,j%))*viewplane/z1 +cubelocation(1)) +yinc
    z2=cube(2,cubetriangles%(1,j%))*cube(3,cubetriangles%(1,j%))+cubelocation(2) 
    x2=(cube(0,cubetriangles%(1,j%))*cube(3,cubetriangles%(1,j%))*viewplane/z2 +cubelocation(0)) 
    y2=(cube(1,cubetriangles%(1,j%))*cube(3,cubetriangles%(1,j%))*viewplane/z2 +cubelocation(1)) +yinc 
    z3=cube(2,cubetriangles%(2,j%))*cube(3,cubetriangles%(2,j%))+cubelocation(2) 
    x3=(cube(0,cubetriangles%(2,j%))*cube(3,cubetriangles%(2,j%))*viewplane/z3 +cubelocation(0)) 
    y3=(cube(1,cubetriangles%(2,j%))*cube(3,cubetriangles%(2,j%))*viewplane/z3 +cubelocation(1)) +yinc 
    xx0(k%)=x1 :yy0(k%)=y1: xx1(k%)=x2 :yy1(k%)=y2: xx2(k%)=x3 :yy2(k%)=y3 :scol(k%)=tcol(j%\2)
    k%=k%+1
    z1=cube(2,cubetriangles%(0,j%+1))*cube(3,cubetriangles%(0,j%+1))+cubelocation(2) 
    x1=(cube(0,cubetriangles%(0,j%+1))*cube(3,cubetriangles%(0,j%+1))*viewplane/z1 +cubelocation(0)) 
    y1=(cube(1,cubetriangles%(0,j%+1))*cube(3,cubetriangles%(0,j%+1))*viewplane/z1 +cubelocation(1)) +yinc 
    z2=cube(2,cubetriangles%(1,j%+1))*cube(3,cubetriangles%(1,j%+1))+cubelocation(2) 
    x2=(cube(0,cubetriangles%(1,j%+1))*cube(3,cubetriangles%(1,j%+1))*viewplane/z2 +cubelocation(0))
    y2=(cube(1,cubetriangles%(1,j%+1))*cube(3,cubetriangles%(1,j%+1))*viewplane/z2 +cubelocation(1)) +yinc 
    z3=cube(2,cubetriangles%(2,j%+1))*cube(3,cubetriangles%(2,j%+1))+cubelocation(2) 
    x3=(cube(0,cubetriangles%(2,j%+1))*cube(3,cubetriangles%(2,j%+1))*viewplane/z3 +cubelocation(0)) 
    y3=(cube(1,cubetriangles%(2,j%+1))*cube(3,cubetriangles%(2,j%+1))*viewplane/z3 +cubelocation(1)) +yinc 
    xx0(k%)=x1 :yy0(k%)=y1: xx1(k%)=x2 :yy1(k%)=y2: xx2(k%)=x3 :yy2(k%)=y3 :scol(k%)=tcol(j%\2)
  next i% 
  triangles(12,xx0(),yy0(),xx1(),yy1(),xx2(),yy2(),scol(),0) 
  if yinc=0 then 
    ssd1963 1 'swap to page 1
    box 0,272,480,272,0,0,0 ' clear page 2
  else 
    ssd1963 2 'swap to page 2
    box 0,0,480,272,0,0,0 'clear page 1
  endif 
loop 
end 
'
sub getquaternion()
  readMPU6050andmag 
  accs(0)=ax:accs(1)=ay:accs(2)=az
  gees(0)=gx:gees(1)=gy:gees(2)=gz
  mags(0)=my:mags(1)=-mx:mags(2)=mz 'swap/reverse mag reading to match orientation of accelerometer
  q(0)=q(1):q(1)=q(3):q(2)=q(2):q(3)=-q(4)
  MadgwickQuaternionUpdate(q(),accs(),gees(),mags(),beta, lastrun, yaw ,pitch, roll)
  q(4)=-q(3):q(3)=q(1):q(2)=q(2):q(1)=q(0):q(0)=1
end sub
' 
sub invert_quaternion(n(),q()) 
  n(0)=q(0) 
  n(1)=q(1) 
  n(2)=-q(2) 
  n(3)=-q(3) 
  n(4)=-q(4) 
end sub 
' 
sub multiply_quaternion(n(),q1(),q2()) 
  local a1=q1(1),a2=q2(1),b1=q1(2),b2=q2(2),c1=q1(3),c2=q2(3),d1=q1(4),d2=q2(4) 
  n(1)=a1*a2-b1*b2-c1*c2-d1*d2 
  n(2)=a1*b2+b1*a2+c1*d2-d1*c2 
  n(3)=a1*c2-b1*d2+c1*a2+d1*b2 
  n(4)=a1*d2+b1*c2-c1*b2+d1*a2  
  n(0)=q1(0)*q2(0) 
end sub 
' 
sub create_vector(x,y,z,v()) 
  v(0)=sqr(x*x + y*y + z*z) 
  v(1)=0 
  v(2)=x/v(0) 
  v(3)=y/v(0) 
  v(4)=z/v(0) 
end sub 

sub rotate_vector(vnew(),v(),q()) 
  local n(4),iq(4) 
  multiply_quaternion(n(),q(),v()) 
  invert_quaternion(iq(),q()) 
  multiply_quaternion(vnew(),n(),iq()) 
end sub 

sub readMPU6050andmag 
  do while not(pin(intPin)): loop 
  readBytes(MPU6050_ADDRESS, ACCEL_XOUT_H, 14, gData()) 
  readBytes(HMC5883L_I2C, HMC5883_MSB_X, 6, mData())' Read the six raw data 
' Calculate the magnetometer values in milliGauss 
' Include factory calibration per data sheet and user environmental corrections 
  mx = (sint16((mData(0) << 8) OR mData(1)))/hmc5883_Gauss_LSB_X * GAUSS_TO_MICROTESLA   + magbias_x 
  my = (sint16((mData(4) << 8) OR mData(5)))/hmc5883_Gauss_LSB_Y * GAUSS_TO_MICROTESLA   + magbias_y 
  mz = (sint16((mData(2) << 8) OR mData(3)))/hmc5883_Gauss_LSB_Z * GAUSS_TO_MICROTESLA   + magbias_z
' Now we'll calculate the acceleration value into actual g's
' this depends on scale being set
  ax = sint16((gData(0) << 8) OR gData(1))*aRes +accelbias(0)' Turn the MSB and LSB into a signed 16-bit value
  ay = sint16((gData(2) << 8) OR gData(3))*aRes +accelbias(1)  
  az = sint16((gData(4) << 8) OR gData(5))*aRes +accelbias(2)
' Calculate the gyro value into actual radians per second
  gx = RAD(sint16((gData(8) << 8) OR gData(9))* gRes) +gyrobias(0) 'Turn the MSB and LSB into a signed 16-bit value
  gy = RAD(sint16((gData(10) << 8) OR gData(11))* gRes) +gyrobias(1)  
  gz = RAD(sint16((gData(12) << 8) OR gData(13))* gRes) +gyrobias(2) 
  if screenIO then text 0,20,"Acc X="+str$(ax,3,3," ")+"  Y="+str$(ay,3,3," ")+"  Z="+str$(az,3,3," ")
  if screenIO then text 0,40,"Rot X="+str$(gx,3,3," ")+"  Y="+str$(gy,3,3," ")+"  Z="+str$(gz,3,3," ") 
  if screenIO then text 0,0, "Mag X="+str$(mx,3,3," ")+"  Y="+str$(my,3,3," ")+"  Z="+str$(mz,3,3," ") 
end sub 
'
sub initMPU6050 
  LOCAL INTEGER c 
' wake up device 
  writeByte(MPU6050_ADDRESS, PWR_MGMT_1, &H00) ' Clear sleep mode bit (6), enable all sensors  
  pause 100 ' Wait for all registers to reset  
' get stable time source 
  writeByte(MPU6050_ADDRESS, PWR_MGMT_1, &H01)  ' Auto select clock source to be PLL gyroscope reference if ready else 
  pause 200  
' Configure Gyro and Thermometer 
' Disable FSYNC and set thermometer and gyro bandwidth to 41 and 42 Hz, respectively  
' minimum delay time for this setting is 5.9 ms, which means sensor fusion update rates cannot 
' be higher than 1 / 0.0059 = 170 Hz 
' DLPF_CFG = bits 2:0 = 100 this limits the sample rate to 1000 Hz for both 
' With the MPU6050, it is possible to get gyro sample rates of 32 kHz (!), 8 kHz, or 1 kHz 
  writeByte(MPU6050_ADDRESS, CONFIG, &H04)   
' Set sample rate = gyroscope output rate/(1 + SMPLRT_DIV) 
  writeByte(MPU6050_ADDRESS, SMPLRT_DIV, &H04)  ' Use a 200 Hz rate a rate consistent with the filter update rate  
' Set gyroscope full scale range 
' Range selects FS_SEL and AFS_SEL are 0 - 3, so 2-bit values are left-shifted into positions 4:3 
  c = readByte(MPU6050_ADDRESS, GYRO_CONFIG) 
  c=c AND &B11100100 
  c = c OR (Gscale << 3) ' Set full scale range for the gyro 
  writeByte(MPU6050_ADDRESS, GYRO_CONFIG, c ) ' Write new GYRO_CONFIG value to register 
' Set accelerometer full-scale range configuration 
  c = readByte(MPU6050_ADDRESS, ACCEL_CONFIG) 
  c=c AND &B11100111 
  c =  c OR (Ascale << 3) ' Set full scale range for the accelerometer  
  writeByte(MPU6050_ADDRESS, ACCEL_CONFIG, c) ' Write new ACCEL_CONFIG register value 
' Set accelerometer sample rate configuration 
' It is possible to get a 4 kHz sample rate from the accelerometer by choosing 1 for 
' accel_fchoice_b bit (3) in this case the bandwidth is 1.13 kHz 
' The accelerometer, gyro, and thermometer are set to 1 kHz sample rates,  
' but all these rates are further reduced by a factor of 5 to 200 Hz because of the SMPLRT_DIV setting 
' Configure Interrupts and Bypass Enable 
' Set interrupt pin active high, push-pull, hold interrupt pin level HIGH until interrupt cleared, 
' clear on read of INT_STATUS, and enable I2C_BYPASS_EN so additional chips  
' can join the I2C bus and all can be controlled by the Arduino as master 
   writeByte(MPU6050_ADDRESS, INT_PIN_CFG, &H32)  'set interrupt cleared by any read   
   writeByte(MPU6050_ADDRESS, INT_ENABLE, &H01)  ' Enable data ready (bit 0) interrupt 
   writeByte(MPU6050_ADDRESS, USER_CTRL, &H05) 
   pause 100 
end sub 

sub initHMC5883() 
  I2C WRITE HMC5883L_i2c, 0, 2, HMC5883_CONFIG_A, &h18 '1-average, 75 Hz, normal measurement  
  I2C WRITE HMC5883L_i2c, 0, 2, HMC5883_CONFIG_B, HMC5883_MAGGAIN_4_7 'Gain=4, or any other desired gain  
  I2C WRITE HMC5883L_i2c, 0, 2, HMC5883_MODE, &h00 'Single-measurement mode  
end sub

sub writeByte(address%,reg%,value%)
  i2c write address%,0,2,reg%,value%
end sub
'
function readByte(address%,reg%) as integer
  i2c write address%,1,1,reg%
  i2c read address%,0,1,readByte
end function
'
sub readBytes(address%,reg%,n%,a%())
  i2c write address%,1,1,reg%
  i2c read address%,0,n%,a%()
end sub
'
sub readByteString(address%,reg%,n%,s$)
  i2c write address%,1,1,reg%
  i2c read address%,0,n%,S$
end sub
'
sub getMres
  select case Mscale
 	' Possible magnetometer scales (and their register bit settings) are:
	' 14 bit resolution (0) and 16 bit resolution (1)
    case MFS_14BITS
          mRes = 10.*4912./8190. ' Proper scale to return milliGauss
    case MFS_16BITS
          mRes = 10.*4912./32760.0 ' Proper scale to return milliGauss
  end select
end sub
'
sub getGres
  select case Gscale
 	' Possible gyro scales (and their register bit settings) are:
	'250 DPS (00), 500 DPS (01), 1000 DPS (10), and 2000 DPS  (11). 
        ' Here's a bit of an algorith to calculate DPS/(ADC tick) based on that 2-bit value:
    case GFS_250DPS
          gRes = 250.0/32768.0
    case GFS_500DPS
          gRes = 500.0/32768.0
    case GFS_1000DPS
          gRes = 1000.0/32768.0
    case GFS_2000DPS
          gRes = 2000.0/32768.0
  end select
end sub
'
sub getAres
  select case Ascale
 	' Possible accelerometer scales (and their register bit settings) are:
	' 2 Gs (00), 4 Gs (01), 8 Gs (10), and 16 Gs  (11). 
        ' Here's a bit of an algorith to calculate DPS/(ADC tick) based on that 2-bit value:
    case AFS_2G
          aRes = 2.0/32768.0
    case AFS_4G
          aRes = 4.0/32768.0
    case AFS_8G
          aRes = 8.0/32768.0
    case AFS_16G:
          aRes = 16.0/32768.0
  end select
end sub  
'
function readTempData() as float
  local integer rawData(1)  ' x/y/z gyro register data stored here
  readBytes(MPU6050_ADDRESS, TEMP_OUT_H, 2, rawData()) ' Read the two raw data registers sequentially into data array 
  readTempData=sint16((rawData(0) << 8) OR rawData(1)) / 340 + 36.53
end function
'
FUNCTION sint16(x as integer) as float ' convert to signed 16 bit number 
  local a%=x
  IF a% AND &H8000 then a%=a% OR &HFFFFFFFFFFFF0000
  sint16 = a% 
END FUNCTION
'
CSUB MadgwickQuaternionUpdate
    000000DA
    'atan2
    27BDFFC8 AFBF0034 AFBE0030 AFB7002C AFB60028 AFB50024 AFB40020 AFB3001C
    AFB20018 AFB10014 AFB00010 00809021 00A0A021 3C109D00 8E02009C 3C044049
    0040F809 24840FDA 0040B021 8E02009C 3C043FC9 0040F809 24840FDA 0040B821
    8E02009C 3C04BFC9 0040F809 24840FDA 0040F021 8E02009C 3C0440C9 0040F809
    24840FDA 0040A821 8E02009C 0040F809 00002021 00408821 8E02009C 0040F809
    00002021 00409821 8E020068 02802021 0040F809 00002821 24030001 1443000A
    3C029D00 8C500078 8C420064 02402021 0040F809 02802821 0200F809 00402021
    10000054 00409821 8C420068 02402021 0040F809 02202821 2403FFFF 10430015
    3C029D00 8C420068 02802021 0040F809 02202821 2403FFFF 1443000E 3C029D00
    8C53005C 8C500078 8C420064 02402021 0040F809 02802821 0200F809 00402021
    02C02021 0260F809 00402821 10000039 00409821 8C420068 02402021 0040F809
    02202821 2403FFFF 14430015 3C029D00 8C420068 02802021 0040F809 02202821
    2403FFFF 1443000E 3C029D00 8C530060 8C500078 8C420064 02402021 0040F809
    02802821 0200F809 00402021 00402021 0260F809 02C02821 1000001E 00409821
    8C420068 02402021 0040F809 02202821 24030001 14430008 3C029D00 8C420068
    02802021 0040F809 02202821 50400011 02E09821 3C029D00 8C420068 02402021
    0040F809 02202821 2403FFFF 1443000A 3C029D00 8C420068 02802021 0040F809
    02202821 50400003 03C09821 10000002 3C029D00 3C029D00 8C420068 02602021
    0040F809 02202821 2403FFFF 14430008 02601021 3C029D00 8C42005C 02602021
    0040F809 02A02821 00409821 02601021 8FBF0034 8FBE0030 8FB7002C 8FB60028
    8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0038
    'asin
    27BDFFC8 AFBF0034 AFB70030 AFB6002C AFB50028 AFB40024 AFB30020 AFB2001C
    AFB10018 AFB00014 00808821 3C109D00 8E02009C 0040F809 3C043F00 0040A021
    8E02009C 0040F809 3C043F80 00409021 8E170078 8E160064 8E150074 8E130060
    8E020058 02202021 0040F809 02202821 02402021 0260F809 00402821 00402021
    02A0F809 02802821 02202021 02C0F809 00402821 02E0F809 00402021 8FBF0034
    8FB70030 8FB6002C 8FB50028 8FB40024 8FB30020 8FB2001C 8FB10018 8FB00014
    03E00008 27BD0038
    'main
    27BDFF30 AFBF00CC AFBE00C8 AFB700C4 AFB600C0 AFB500BC AFB400B8 AFB300B4
    AFB200B0 AFB100AC AFB000A8 0080B021 8FA200E4 40034800 8C440000 AFA40018
    8C440004 14800007 00608021 54800007 AC500000 8FA80018 0068202B 50800003
    AC500000 00608021 AC500000 AC400004 8ED40000 8ED70004 8ED20008 8ED3000C
    8CBE0000 8CA20004 AFA20010 8CA50008 AFA50020 8CC30000 AFA30054 8CC40004
    AFA40058 8CC60008 AFA6005C 8CE80000 AFA80028 8CE20004 AFA20030 8CE70008
    AFA70024 3C119D00 8E22009C 0040F809 3C044000 0040A821 8E22009C 0040F809
    3C043F00 AFA20038 8E22009C 0040F809 3C043F80 AFA20044 8E22009C 0040F809
    00002021 AFA20040 8E22009C 0040F809 3C044080 AFA20050 8E22009C 3C044265
    0040F809 24842EE2 AFA20078 8FA200E0 8C420000 AFA20060 8E230058 AFA3001C
    8E240064 AFA40014 8FA80018 02088023 8E220080 02002021 0040F809 00102FC3
    00408021 8E230000 8E220080 8C640000 0040F809 00002821 02002021 8FA30014
    0060F809 00402821 00402021 8FA8001C 0100F809 02A02821 AFA20064 8E220058
    02A02021 0040F809 02802821 AFA2006C 8E220058 02A02021 0040F809 02E02821
    AFA20048 8E220058 02A02021 0040F809 02402821 AFA20068 8E220058 02A02021
    0040F809 02602821 AFA20084 8E300058 02A02021 0200F809 02802821 00402021
    0200F809 02402821 AFA20088 8E300058 02A02021 0200F809 02402821 00402021
    0200F809 02602821 AFA2008C 8E220058 02802021 0040F809 02802821 AFA2004C
    8E220058 02802021 0040F809 02E02821 AFA20070 8E220058 02802021 0040F809
    02402821 AFA20074 8E220058 02802021 0040F809 02602821 AFA2007C 8E220058
    02E02021 0040F809 02E02821 AFA2002C 8E220058 02E02021 0040F809 02402821
    AFA20090 8E220058 02E02021 0040F809 02602821 AFA2003C 8E220058 02402021
    0040F809 02402821 AFA20014 8E220058 02402021 0040F809 02602821 AFA20080
    8E220058 02602021 0040F809 02602821 AFA20034 8E220074 AFA20018 8E30005C
    8E220058 03C02021 0040F809 03C02821 AFA2001C 8E220058 8FA40010 0040F809
    00802821 8FA4001C 0200F809 00402821 AFA2001C 8E220058 8FA40020 0040F809
    00802821 8FA4001C 0200F809 00402821 00402021 8FA30018 0060F809 8FA50038
    AFA20018 8E220068 8FA40018 0040F809 8FA50040 104004FD 8FBF00CC 3C109D00
    8E020064 8FA40044 0040F809 8FA50018 00408821 8E020058 03C02021 0040F809
    02202821 AFA2009C 8E020058 8FA40010 0040F809 02202821 AFA200A0 8E020058
    8FA40020 0040F809 02202821 AFA200A4 8E040074 AFA40010 8E11005C 8E020058
    8FA40028 0040F809 00802821 0040F021 8E020058 8FA40030 0040F809 00802821
    03C02021 0220F809 00402821 0040F021 8E020058 8FA40024 0040F809 00802821
    03C02021 0220F809 00402821 00402021 8FA80010 0100F809 8FA50038 0040F021
    8E020068 03C02021 0040F809 8FA50040 104004C6 8FBF00CC 3C119D00 8E220064
    8FA40044 0040F809 03C02821 00408021 8E220058 8FA40028 0040F809 02002821
    AFA2001C 8E220058 8FA40030 0040F809 02002821 AFA20020 8E220058 8FA40024
    0040F809 02002821 AFA20018 8E300058 02A02021 0200F809 02802821 00402021
    0200F809 8FA5001C AFA20028 8E300058 02A02021 0200F809 02802821 00402021
    0200F809 8FA50020 AFA20030 8E300058 02A02021 0200F809 02802821 00402021
    0200F809 8FA50018 AFA20024 8E300058 02A02021 0200F809 02E02821 00402021
    0200F809 8FA5001C AFA20094 8E3E005C 8E220060 AFA20010 8E220058 8FA4001C
    0040F809 8FA5004C 00408021 8E220058 8FA40030 0040F809 02602821 02002021
    8FA30010 0060F809 00402821 00408021 8E220058 8FA40024 0040F809 02402821
    02002021 03C0F809 00402821 00408021 8E220058 8FA4001C 0040F809 8FA5002C
    02002021 03C0F809 00402821 AFA20098 8E300058 8FA40048 0200F809 8FA50020
    00402021 0200F809 02402821 8FA40098 03C0F809 00402821 AFA20098 8E300058
    8FA40048 0200F809 8FA50018 00402021 0200F809 02602821 8FA40098 03C0F809
    00402821 00408021 8E220058 8FA4001C 0040F809 8FA50014 02002021 8FA80010
    0100F809 00402821 00408021 8E220058 8FA4001C 0040F809 8FA50034 02002021
    8FA30010 0060F809 00402821 0040F021 8E220058 8FA40028 0040F809 02602821
    00408021 8E24005C AFA40010 8E220058 8FA40020 0040F809 8FA5004C 02002021
    8FA80010 0100F809 00402821 00408021 8E220060 AFA20010 8E220058 8FA40024
    0040F809 02E02821 02002021 8FA30010 0060F809 00402821 00408021 8E24005C
    AFA40010 8E220058 8FA40094 0040F809 02402821 02002021 8FA80010 0100F809
    00402821 00408021 8E220060 AFA20010 8E220058 8FA40020 0040F809 8FA5002C
    02002021 8FA30010 0060F809 00402821 00408021 8E24005C AFA40010 8E220058
    8FA40020 0040F809 8FA50014 02002021 8FA80010 0100F809 00402821 AFA20010
    8E22005C AFA20024 8E300058 8FA40068 0200F809 8FA50018 00402021 0200F809
    02602821 8FA40010 8FA30024 0060F809 00402821 00408021 8E240060 AFA40010
    8E220058 8FA40020 0040F809 8FA50034 02002021 8FA80010 0100F809 00402821
    00408021 8E220074 AFA20010 8E23005C AFA30024 8E220058 03C02021 0040F809
    03C02821 0040F021 8E220058 02002021 0040F809 02002821 03C02021 8FA80024
    0100F809 00402821 00402021 8FA30010 0060F809 8FA50038 AFA20010 8E220058
    8FA40030 0040F809 02E02821 00408021 8E3E0060 8E220058 8FA40028 0040F809
    02402821 02002021 03C0F809 00402821 00408021 8E3E005C 8E220058 8FA40018
    0040F809 8FA5004C 02002021 03C0F809 00402821 00408021 8E3E005C 8E220058
    8FA40094 0040F809 02602821 02002021 03C0F809 00402821 00408021 8E3E0060
    8E220058 8FA40018 0040F809 8FA5002C 02002021 03C0F809 00402821 0040F021
    8E24005C AFA40028 8E300058 8FA40068 0200F809 8FA50020 00402021 0200F809
    02602821 03C02021 8FA80028 0100F809 00402821 00408021 8E3E0060 8E220058
    8FA40018 0040F809 8FA50014 02002021 03C0F809 00402821 00408021 8E3E005C
    8E220058 8FA40018 0040F809 8FA50034 02002021 03C0F809 00402821 0040F021
    8E220058 02A02021 0040F809 8FA50010 AFA2004C 8E220058 02A02021 0040F809
    03C02821 AFA20094 8E220058 AFA20028 8E300060 8FA40038 0200F809 8FA5002C
    00402021 0200F809 8FA50014 03C02021 8FA30028 0060F809 00402821 AFA20030
    8E300058 8E22005C 8FA40070 0040F809 8FA50080 03C02021 0200F809 00402821
    AFA20024 8E300058 8E220060 8FA4003C 0040F809 8FA50074 03C02021 0200F809
    00402821 AFA20080 8E240058 AFA40028 8E300060 8FA40038 0200F809 8FA50014
    00402021 0200F809 8FA50034 8FA40010 8FA80028 0100F809 00402821 AFA20034
    8E300058 8E220060 8FA40090 0040F809 8FA5007C 8FA40010 0200F809 00402821
    AFA2007C 8E300058 8E22005C 8FA40074 0040F809 8FA5003C 8FA40010 0200F809
    00402821 AFA20074 8E300060 8E220058 02A02021 0040F809 8FA5003C 00402021
    0200F809 8FA50088 00402021 0200F809 8FA5009C AFA20028 8E300060 8E22005C
    8FA4007C 0040F809 8FA50024 00402021 0200F809 8FA50020 AFA20020 8E300060
    8E22005C 8FA40074 0040F809 8FA50030 00402021 0200F809 8FA50018 AFA20018
    8E300060 8E22005C 8FA40034 0040F809 8FA50080 00402021 0200F809 8FA5001C
    AFA2001C 8E220060 AFA20030 8E30005C 8E220058 02A02021 0040F809 8FA50070
    00402021 0200F809 8FA5008C 00402021 8FA30030 0060F809 8FA500A0 AFA20030
    8E300060 8E220058 02A02021 0040F809 8FA5002C 8FA40044 0200F809 00402821
    AFA20024 8E220058 02A02021 0040F809 8FA50014 8FA40024 0200F809 00402821
    00402021 0200F809 8FA500A4 AFA20034 8E24005C AFA40014 8E280060 AFA80024
    8E220058 8FA40048 0040F809 8FA50030 00408021 8E220058 8FA40068 0040F809
    8FA50028 02002021 8FA30024 0060F809 00402821 AFA2002C 8E300058 03C02021
    0200F809 02402821 00402021 0200F809 8FA5001C 8FA4002C 8FA80024 0100F809
    00402821 AFA20024 8E220060 AFA2002C 8E220058 03C02021 0040F809 02E02821
    AFA2003C 8E300058 8FA40010 0200F809 02602821 8FA4003C 8FA3002C 0060F809
    00402821 8FA40020 0200F809 00402821 8FA40024 8FA80014 0100F809 00402821
    AFA20024 8E300058 8FA40010 0200F809 02402821 00402021 0200F809 8FA50018
    8FA40024 8FA30014 0060F809 00402821 AFA20024 8E240060 AFA4002C 8E28005C
    AFA80014 8E220058 8FA40084 0040F809 8FA50028 00408021 8E220058 8FA4006C
    0040F809 8FA50030 02002021 8FA30014 0060F809 00402821 AFA2003C 8E300058
    8FA40050 0200F809 02E02821 00402021 0200F809 8FA50034 8FA4003C 8FA8002C
    0100F809 00402821 AFA2002C 8E300058 03C02021 0200F809 02602821 00402021
    0200F809 8FA5001C 8FA4002C 8FA30014 0060F809 00402821 AFA2002C 8E24005C
    AFA40014 8E220058 8FA40010 0040F809 02402821 AFA2003C 8E300058 03C02021
    0200F809 02802821 8FA4003C 8FA80014 0100F809 00402821 8FA40020 0200F809
    00402821 8FA4002C 8FA30014 0060F809 00402821 AFA2002C 8E240060 AFA4003C
    8E220058 8FA40010 0040F809 02602821 AFA20070 8E300058 8FA40094 0200F809
    02E02821 8FA40070 8FA8003C 0100F809 00402821 8FA40018 0200F809 00402821
    8FA4002C 8FA30014 0060F809 00402821 AFA2002C 8E24005C AFA4003C 8E280060
    AFA80014 8E220058 8FA40084 0040F809 8FA50030 00408021 8E220058 8FA4006C
    0040F809 8FA50028 02002021 8FA30014 0060F809 00402821 AFA2006C 8E300058
    8FA40050 0200F809 02402821 00402021 0200F809 8FA50034 8FA4006C 8FA80014
    0100F809 00402821 AFA20034 8E300058 8E220060 AFA20014 8FA40040 0040F809
    8FA5004C 00402021 0200F809 02402821 AFA20050 8E300058 03C02021 0200F809
    02802821 8FA40050 8FA30014 0060F809 00402821 8FA4001C 0200F809 00402821
    8FA40034 8FA8003C 0100F809 00402821 AFA20034 8E22005C AFA20014 8E220058
    8FA40010 0040F809 02E02821 AFA2003C 8E300058 03C02021 0200F809 02602821
    8FA4003C 8FA30014 0060F809 00402821 8FA40020 0200F809 00402821 8FA40034
    8FA80014 0100F809 00402821 AFA20034 8E220060 AFA2003C 8E220058 8FA40010
    0040F809 02802821 AFA20050 8E300058 8FA40094 0200F809 02402821 8FA40050
    8FA3003C 0060F809 00402821 8FA40018 0200F809 00402821 8FA40034 8FA80014
    0100F809 00402821 AFA20034 8E22005C AFA20014 8E220058 8FA40048 0040F809
    8FA50028 00408021 8E220058 8FA40068 0040F809 8FA50030 02002021 8FA30014
    0060F809 00402821 AFA20028 8E240060 AFA40030 8E220058 03C02021 0040F809
    02E02821 AFA20048 8E300058 8FA4004C 0200F809 02602821 8FA40048 8FA80030
    0100F809 00402821 8FA4001C 0200F809 00402821 8FA40028 8FA30014 0060F809
    00402821 AFA2001C 8E240060 AFA40028 8E220058 03C02021 0040F809 02402821
    0040F021 8E300058 8FA40010 0200F809 02802821 03C02021 8FA80028 0100F809
    00402821 8FA40020 0200F809 00402821 8FA4001C 8FA30014 0060F809 00402821
    0040F021 8E300058 8FA40010 0200F809 02E02821 00402021 0200F809 8FA50018
    03C02021 8FA80014 0100F809 00402821 0040F021 8E220074 AFA20010 8E30005C
    8E220058 8FA40024 0040F809 00802821 AFA20020 8E220058 8FA4002C 0040F809
    00802821 8FA40020 0200F809 00402821 AFA20020 8E220058 8FA40034 0040F809
    00802821 8FA40020 0200F809 00402821 AFA20020 8E220058 03C02021 0040F809
    03C02821 8FA40020 0200F809 00402821 00402021 8FA30010 0060F809 8FA50038
    8E230064 8FA40044 0060F809 00402821 00408021 8E220058 8FA40024 0040F809
    02002821 AFA20010 8E220058 8FA4002C 0040F809 02002821 AFA20020 8E220058
    8FA40034 0040F809 02002821 AFA20018 8E220058 03C02021 0040F809 02002821
    AFA2001C 3C029D00 8C500058 8E3E0060 8FA40040 03C0F809 02E02821 00402021
    0200F809 8FA50054 00408021 8E220058 02402021 0040F809 8FA50058 02002021
    03C0F809 00402821 AFA20014 8E300058 02602021 0200F809 8FA5005C 8FA40014
    03C0F809 00402821 8FA40038 0200F809 00402821 00408021 8E220058 8FA40060
    0040F809 8FA50010 02002021 03C0F809 00402821 AFA20010 8E3E0060 8E24005C
    AFA40014 8E220058 02802021 0040F809 8FA50054 00408021 8E220058 02402021
    0040F809 8FA5005C 02002021 8FA80014 0100F809 00402821 AFA20014 8E300058
    02602021 0200F809 8FA50058 8FA40014 03C0F809 00402821 8FA40038 0200F809
    00402821 00408021 8E220058 8FA40060 0040F809 8FA50020 02002021 03C0F809
    00402821 AFA20020 8E22005C AFA20014 8E3E0060 8E220058 02802021 0040F809
    8FA50058 00408021 8E220058 02E02021 0040F809 8FA5005C 02002021 03C0F809
    00402821 AFA20028 8E300058 02602021 0200F809 8FA50054 8FA40028 8FA30014
    0060F809 00402821 8FA40038 0200F809 00402821 00408021 8E220058 8FA40060
    0040F809 8FA50018 02002021 03C0F809 00402821 AFA20018 8E3E0060 8E24005C
    AFA40014 8E220058 02802021 0040F809 8FA5005C 00408021 8E220058 02E02021
    0040F809 8FA50058 02002021 8FA80014 0100F809 00402821 AFA20014 8E300058
    02402021 0200F809 8FA50054 8FA40014 03C0F809 00402821 8FA40038 0200F809
    00402821 00408021 8E220058 8FA40060 0040F809 8FA5001C 02002021 03C0F809
    00402821 AFA2001C 8E30005C 8E220058 8FA40010 0040F809 8FA50064 02802021
    0200F809 00402821 0040F021 8E30005C 8E220058 8FA40020 0040F809 8FA50064
    02E02021 0200F809 00402821 0040B821 8E30005C 8E220058 8FA40018 0040F809
    8FA50064 02402021 0200F809 00402821 0040A021 8E30005C 8E220058 8FA4001C
    0040F809 8FA50064 02602021 0200F809 00402821 00409021 8E220074 AFA20010
    8E30005C 8E220058 03C02021 0040F809 03C02821 00409821 8E220058 02E02021
    0040F809 02E02821 02602021 0200F809 00402821 00409821 8E220058 02802021
    0040F809 02802821 02602021 0200F809 00402821 00409821 8E220058 02402021
    0040F809 02402821 02602021 0200F809 00402821 00402021 8FA30010 0060F809
    8FA50038 8E230064 8FA40044 0060F809 00402821 00408021 8E220058 03C02021
    0040F809 02002821 AEC20000 8E220058 02E02021 0040F809 02002821 AEC20004
    8E220058 02802021 0040F809 02002821 AEC20008 8E220058 02402021 0040F809
    02002821 AEC2000C 8E33005C 8E220058 8EC40004 0040F809 8EC50008 00409021
    8E300058 8EC40000 0200F809 8EC5000C 02402021 0260F809 00402821 02A02021
    0200F809 00402821 0040A021 8E300060 8E33005C 8EC50000 8E220058 0040F809
    00A02021 00409021 8EC50004 8E220058 0040F809 00A02021 02402021 0260F809
    00402821 00409021 8EC50008 8E220058 0040F809 00A02021 02402021 0200F809
    00402821 00409821 8E320058 8EC5000C 0240F809 00A02021 02602021 0200F809
    00402821 02802021 0411F9A3 00402821 8FA40078 0240F809 00402821 8FA300E8
    AC620000 8E320060 8E220058 8EC40004 0040F809 8EC5000C 00409821 8E300058
    8EC40000 0200F809 8EC50008 02602021 0240F809 00402821 02A02021 0200F809
    00402821 0411FA34 00402021 8FA40040 0240F809 00402821 8FA40078 0200F809
    00402821 8FA300EC AC620000 8E33005C 8E220058 8EC40000 0040F809 8EC50004
    00409021 8E300058 8EC40008 0200F809 8EC5000C 02402021 0260F809 00402821
    02A02021 0200F809 00402821 0040A021 8E33005C 8E300060 8EC50000 8E220058
    0040F809 00A02021 00409021 8EC50004 8E220058 0040F809 00A02021 02402021
    0200F809 00402821 00409021 8EC50008 8E220058 0040F809 00A02021 02402021
    0200F809 00402821 00409021 8E300058 8EC5000C 0200F809 00A02021 02402021
    0260F809 00402821 02802021 0411F952 00402821 8FA40078 0200F809 00402821
    8FA300F0 AC620000 8FBF00CC 8FBE00C8 8FB700C4 8FB600C0 8FB500BC 8FB400B8
    8FB300B4 8FB200B0 8FB100AC 8FB000A8 03E00008 27BD00D0
End CSUB
Csub triangles 'draws multiple triangles with a delay between if required
    00000000
    8C820004 27BDFFA0 AFBF005C AFBE0058 AFB70054 AFB60050 AFB5004C AFB40048
    AFB30044 AFB20040 AFB1003C AFB00038 AFA40060 AFA50064 AFA60068 184000EE
    AFA7006C AFA00030 3C159D00 8FA30030 8FA50068 8FA80070 000310C0 00A22021
    01021821 8C840000 8C630000 8FA90064 AFA40018 01223821 AFA3001C 8FA40074
    8FA3006C 8FA80078 8FA9007C 00623021 00822821 01022021 01221021 8FA80018
    8FA9001C 8CC60000 8CA50000 0128182A 8CF30000 8C9E0000 AFA60028 AFA5002C
    10600006 8C540000 02601021 AFA90018 00C09821 AFA8001C AFA20028 8FA5001C
    03C5102A 10400008 8FA90018 8FA20028 8FA8002C AFBE001C AFA80028 00A0F021
    AFA2002C 8FA90018 8FA3001C 0069102A 10400008 8FA50018 8FA4001C 02601021
    AFA40018 8FB30028 AFA9001C AFA20028 8FA50018 10BE008C 8FA4001C 109E00A4
    8FA50018 2483FFFF 0065102A 1440002E 8FB00018 8FA90028 8FA2002C 8FA8001C
    01334823 00531023 03C5B023 AFBE0034 0105B823 0280F021 AFA90020 AFA20024
    00A08021 00009021 00008821 0060A021 0237001A 02E001F4 8FA30024 8FA20020
    02002821 02003821 02228821 26100001 00002012 0256001A 02C001F4 00932021
    02439021 00003012 00D33021 00C4182A 10600003 00801021 00C02021 00403021
    8EA20048 AFBE0010 8C420000 0040F809 00000000 0290102A 1040FFE5 00000000
    03C0A021 8FBE0034 03D0102A 14400030 8FA8001C 8FA90018 8FA4002C 8FA50028
    0093B023 0085B823 02089023 02098823 03C91823 03C81023 72579002 72368802
    AFB40018 AFB6001C AFB70020 0260B021 00A0B821 00609821 0040A021 0254001A
    028001F4 8FA3001C 8FA20020 02002821 02003821 02429021 26100001 00002012
    0233001A 026001F4 00972021 02238821 00003012 00D63021 00C4182A 10600003
    00801021 00C02021 00403021 8FA80018 8EA20048 AFA80010 8C420000 0040F809
    00000000 03D0102A 1040FFE4 00000000 8FA90080 8D240000 8D220004 00821025
    5440001D 8EA20004 8FA20030 8FA40060 24420001 8C830004 AFA20030 000217C3
    0043202A 5480FF52 8FA30030 14620006 8FA50060 8FA80030 8CA20000 0102102B
    1440FF4B 8FA30030 8FBF005C 8FBE0058 8FB70054 8FB60050 8FB5004C 8FB40048
    8FB30044 8FB20040 8FB1003C 8FB00038 03E00008 27BD0060 0040F809 00000000
    1000FFE2 8FA20030 8FA80028 0113102A 1440001D 02603821 0268102A 1440001C
    8FA70028 02603821 02602021 8FA9002C 0124102A 54400003 8FA4002C 00E9102A
    0122380B 8EA20048 8FA30018 AFB40010 00E33821 8C420000 00602821 00803021
    0040F809 00E43823 1000FFC2 8FA90080 8FA3001C 0065102A 1040FF5F 8FA90028
    1000FF89 8FB00018 1000FFE8 8FA40028 1000FFE6 02602021 1440FFCC 8FBF005C
    8C820000 5440FF10 AFA00030 1000FFC8 8FBE0058
End Csub


Csub floatindexsort ' sorts a floating point array but keeps an index so you know the original order
    00000000
    8CC60000 27BDFF98 AFB00040 AFBF0064 AFBE0060 AFB7005C AFB60058 AFB50054
    AFB40050 AFB3004C AFB20048 AFB10044 AFA6001C AFA40068 AFA5006C 00C08021
    3C039D00 001017C2 00508021 00108043 12000068 8FBF0064 8FA4001C 0204102A
    1040FFF9 001017C2 8FA60068 00102080 00C42021 00102823 AFA50010 AFA40028
    8FA5001C 8FA4006C 001010C0 AFA6002C 8FA60010 00821021 00B02823 AFA20024
    AFA50034 AFA00020 0006F080 0006B8C0 8FA20020 8FA50028 0202B021 8FA20024
    8CA60000 AFA50014 8C450000 02D0202A AFA60018 1480002A AFA50030 8FA60020
    8FA2006C 000690C0 00529021 8FB50024 8FB40028 8FB1002C 1000000F 00C09821
    8E220000 8E440000 8E450004 0213B021 02D0302A AE820000 023E8821 02401021
    AEA40000 AEA50004 02579021 029EA021 14C00013 02B7A821 8FA40010 8E250000
    8C620068 02649821 8FA40018 AFA30038 0040F809 AFB10014 2405FFFF 1045FFE8
    8FA30038 8FA60068 00161080 8FA4006C 00C21021 0016B0C0 AFA20014 00961021
    8FA60020 8FA50030 24C60001 AFA60020 000527C3 8FA60018 8FA50014 ACA60000
    8FA50028 8FA60030 24A50004 AFA50028 AC460000 AC440004 8FA20024 8FA4002C
    8FA50020 8FA60034 24420008 24840004 AFA20024 14A6FFB6 AFA4002C 001017C2
    00508021 00108043 5600FF9C 8FA4001C 8FBF0064 8FBE0060 8FB7005C 8FB60058
    8FB50054 8FB40050 8FB3004C 8FB20048 8FB10044 8FB00040 03E00008 27BD0068
End Csub

