#define _SUPPRESS_PLIB_WARNING
#include <plib.h>
#include "../cfunctions.h"
#define MX470
#define LANDSCAPE       1
#define PORTRAIT        2
#define RLANDSCAPE      3
#define RPORTRAIT       4
#define swap(a, b) {int t; t = a; a = b; b = t; }

#define bclrport *(volatile unsigned int *)(0xbf886134) //latch registers
#define bsetport *(volatile unsigned int *)(0xbf886138) //latch registers
#define cport *(volatile unsigned int *)(0xbf886230) //latch registers
#define cread *(volatile unsigned int *)(0xbf886220) //latch registers
#define ctrisinv *(volatile unsigned int *)(0xbf88621C) //latch registers
#define cclrport *(volatile unsigned int *)(0xbf886234) //latch registers
#define csetport *(volatile unsigned int *)(0xbf886238) //latch registers
#define eport *(volatile unsigned int *)(0xbf886430) //latch registers
#define eread *(volatile unsigned int *)(0xbf886420) //latch registers
#define etrisinv *(volatile unsigned int *)(0xbf88641C) //latch registers
#define eclrport *(volatile unsigned int *)(0xbf886434) //latch registers
#define esetport *(volatile unsigned int *)(0xbf886438) //latch registers
#define DEVID (*(volatile unsigned int *)0xBF80F220)

//Offsets into the persistent RAM of variables
#ifdef MX470
    #define RS_Pin_No 27
    #define WR_Pin_No 24
    #define RS_Pin 0x1000
    #define WR_Pin 0x0800
    #define clrport bclrport
    #define setport bsetport
    #define port eport
    #define read eread
    #define trisinv etrisinv
    #define RSLo    {clrport=RS_Pin;}
    #define RSHi    {setport=RS_Pin;}
    #define WRLo    {clrport=WR_Pin;}
    #define WRHi    {setport=WR_Pin;}
#else
    #define RS_Pin_No 4
    #define WR_Pin_No 5
    #define RS_Pin 0x100
    #define WR_Pin 0x200
    #define clrport cclrport
    #define setport csetport
    #define port cport
    #define read cread
    #define trisinv ctrisinv
    #define RSLo    clrport=RS_Pin
    #define RSHi    setport=RS_Pin
    #define WRLo    clrport=WR_Pin
    #define WRHi    setport=WR_Pin
#endif
#define Both WR_Pin | RS_Pin
#define RDLo    (*(volatile unsigned int *)RDclrport)=RDpin
#define RDHi    (*(volatile unsigned int *)RDsetport)=RDpin


void defineregion(long x, long y, long width,long height){ //SSD1963
    long x1=x,x2=x+width-1,y1=y,y2=y+height-1;
    unsigned long xstart,xend,ystart,yend,Vertical,Horizontal;
#ifdef MX470
        RSLo;
#endif
        if(HRes>VRes){
        Vertical=VRes;
        Horizontal=HRes;
    }
    else {
        Vertical=HRes;
        Horizontal=VRes;
    }
     if(Option->DISPLAY_ORIENTATION!=LANDSCAPE)goto isP;
              xstart = x1;
              xend = x2;
              ystart = y1;
              yend = y2;
              if(Option->LCD_CD>6){ //reverse for 7" displays
                xstart = (Horizontal - 1) - x2;
                xend = (Horizontal - 1) - x1;
              }
              goto setreg;
     isP:         
     if(Option->DISPLAY_ORIENTATION!=PORTRAIT)goto isRL;
              xstart = y1;
              xend = y2;
              ystart = (Vertical - 1) - x2;
              yend = (Vertical - 1) - x1;
              goto setreg;
    isRL:
    if(Option->DISPLAY_ORIENTATION!=RLANDSCAPE)goto isRP;
              xstart = (Horizontal - 1) - x2;
              xend = (Horizontal - 1) - x1;
              ystart = (Vertical - 1) - y2;
              yend = (Vertical - 1) - y1;
              if(Option->LCD_CD>6){//reverse for 7" displays
                xstart = x1;
                xend = x2;
              }
              goto setreg;
     isRP:
              xstart = (Horizontal - 1) - y2;
              xend = (Horizontal - 1) - y1;
              ystart = x1;
              yend = x2;
    setreg:
    port=0x22A ;WRLo;    WRHi; // RS low
    #ifdef MX470
        RSHi;
    #endif
    port=(xstart>>8 ) | Both;  WRLo;    WRHi; // RS HIGH
    port=(xstart) | Both;  WRLo;    WRHi; // RS HIGH
    port=(xend>>8 ) | Both;  WRLo;    WRHi; // RS HIGH
    port=(xend) | Both;  WRLo;    WRHi; // RS HIGH
    #ifdef MX470
        RSLo;
    #endif
    port=0x22B ;  WRLo;    WRHi; // RS low
    #ifdef MX470
        RSHi;
    #endif
    port=(ystart>>8 ) | Both;  WRLo;    WRHi; // RS HIGH
    port=(ystart) | Both;  WRLo;    WRHi; // RS HIGH
    port=(yend>>8 ) | Both;  WRLo;    WRHi; // RS HIGH
    port=(yend) | Both;  WRLo;    WRHi; // RS HIGH    RSHi;
}
void writeRectangle(int x1, int y1, int width, int height,  int fc,  char p[]){
    unsigned long i,fhb,fmb,flb;
    // make sure the coordinates are kept within the display area
    // convert the colours to 888 format
    fhb = (fc >> 16) | Both;
    fmb = (fc >> 8) | Both;
    flb = fc  | Both;

    defineregion(x1,y1,width,height);
    #ifdef MX470
        RSLo;
    #endif
    port=0x22C ;  WRLo;    WRHi; // RS low
    #ifdef MX470
        RSHi;
    #endif
        i=width*height;
        while(i--){
            port=fhb;    WRLo;    WRHi;
            port=fmb;    WRLo;    WRHi;
            port=flb;    WRLo;    WRHi;
        }
}
int ReadRectangle(int x1, int y1, int width, int height, int pos, char p[]){
    unsigned long j,n, RDpin, RDsetport, RDclrport;
        RDpin=1<<GetPinBit(Option->LCD_CS);
        RDsetport=(unsigned int)GetPortAddr(Option->LCD_CS,LATSET);
        RDclrport=(unsigned int)GetPortAddr(Option->LCD_CS,LATCLR);
        j=width*height*3+pos;
        defineregion(x1,y1,width,height);
        #ifdef MX470
            RSLo;
        #endif
        port=0x22E ;  WRLo;    WRHi; // RS low
        #ifdef MX470
            RSHi;
        #endif
        trisinv=0xFF; //set pins to read
        do { //read in the screen area to be overlayed
            RDLo;
            n=DEVID;n=DEVID;
            RDHi;
            p[pos++]=(read & 0xFF);
            RDLo;
            n=DEVID;n=DEVID;
            RDHi;
            p[pos++]=(read & 0xFF);
            RDLo;
            n=DEVID;n=DEVID;
            RDHi;
            p[pos++]=(read & 0xFF);
        } while(pos<j);
        trisinv=0xFF; //set pins to write
        return pos;
}
int RestoreRectangle(int x1, int y1, int width, int height, int pos, char p[]){
    int i;
    defineregion(x1,y1,width,height);
    #ifdef MX470
        RSLo;
    #endif
    port=0x22C ;  WRLo;    WRHi; // RS low
    #ifdef MX470
        RSHi;
    #endif
        i=width*height;
        while(i--){
            port=p[pos++] | Both;    WRLo;    WRHi;
            port=p[pos++] | Both;    WRLo;    WRHi;
            port=p[pos++] | Both;    WRLo;    WRHi;
        }
        return pos;
}

long triangles(int mode, int buffpos, char *buff, long  col, long x0, long y0, long x1, long y1,long x2, long y2) {//Cfunction
  long a, b, y, last;
  long  dx01,  dy01,  dx02,  dy02, dx12,  dy12,  sa, sb;
      
      if (y0>y1) {
        swap(y0, y1);
        swap(x0, x1);
      }
      if (y1>y2) {
        swap(y2, y1);
        swap(x2, x1);
      }
      if (y0>y1) {
        swap(y0, y1);
        swap(x0, x1);
      }
      if(y0==y2) { // Handle awkward all-on-same-line case as its own thing
        a=x0;
        b=x0;
        if(x1<a) {
          a=x1;
        } else {
          if(x1>b) b=x1;
        }
        if(x2<a) {
          a=x2;
        } else {
          if(x2>b)  b=x2;
        }
        if(mode==0){
            buffpos=ReadRectangle(a,y0,1,b-a+1,buffpos,buff);
        } else if(mode==1) {
            buffpos=RestoreRectangle(a,y0,1,b-a+1,buffpos,buff);
        } else {
            writeRectangle(a,y0,1,b-a+1,col,buff);
        }
      } else {
        dx01=x1-x0;  dy01=y1-y0;  dx02=x2-x0;  dy02=y2-y0; dx12=x2-x1;  dy12=y2-y1;  sa=0; sb=0;
        if(y1==y2) {
            last=y1; //Include y1 scanline
        } else {
            last=y1-1; // Skip it
        }
        for (y=y0;y<=last;y++){
            a=x0+sa / dy01;
            b=x0+sb / dy02;
            sa=sa+dx01;
            sb=sb+dx02;
            a=x0+(x1-x0) * (y-y0) / (y1-y0);
            b=x0+(x2-x0) * (y-y0) / (y2-y0);
            if(a>b)swap(a,b);
            if(mode==0){
                buffpos=ReadRectangle(a,y,b-a+1,1,buffpos,buff);
            } else if(mode==1) {
                buffpos=RestoreRectangle(a,y,b-a+1,1,buffpos,buff);
            } else {
                writeRectangle(a,y,b-a+1,1,col,buff);
            }
        }
        sa=dx12 * (y-y1);
        sb=dx02 * (y-y0);
        while (y<=y2){
            a=x1+sa / dy12;
            b=x0+sb / dy02;
            sa=sa+dx12;
            sb=sb+dx02;
            a=x1+(x2-x1) * (y-y1) / (y2-y1);
            b=x0+(x2-x0) * (y-y0) / (y2-y0);
            if(a>b) swap(a,b);
            if(mode==0){
                buffpos=ReadRectangle(a,y,b-a+1,1,buffpos,buff);
            } else if(mode==1) {
                buffpos=RestoreRectangle(a,y,b-a+1,1,buffpos,buff);
            } else {
                writeRectangle(a,y,b-a+1,1,col,buff);
            }
            y=y+1;
            }
        }

  return buffpos;
}
/*void setrd(long *RD){
    Option->LCD_CS=*RD;
    ExtCfg(Option->LCD_CS, EXT_DIG_OUT,0);
    ExtCfg(Option->LCD_CS, EXT_BOOT_RESERVED,0);
    PinSetBit(Option->LCD_CS, LATSET);
}*/
long long main(long *count, char *buff, long long col[], long long x0[], long long y0[], long long x1[], long long y1[],long long x2[], long long y2[]) {//Cfunction
    int i=0,j,buffpos=0;
    while(i<*count && col[i]<0){ //repeat for any restores
        buffpos=triangles(1,buffpos,buff,col[i],x0[i],y0[i],x1[i],y1[i],x2[i],y2[i]);
        i++;
    }  
    buffpos=0;
    j=i;
    while(i<*count && col[i]>=0){ //repeat for any store and write commands
        buffpos=triangles(0,buffpos,buff,col[i],x0[i],y0[i],x1[i],y1[i],x2[i],y2[i]);
        i++;
    }
    i=j;
    while(i<*count && col[i]>=0){ //repeat for any store and write commands
        buffpos=triangles(2,buffpos,buff,col[i],x0[i],y0[i],x1[i],y1[i],x2[i],y2[i]);
        i++;
    }
    return buffpos>>3;
}

