Option explicit
option default NONE
' 
'  Demo of functionality of ILI9341 enhanced functionality driver for Micromite MX170
' 
const SD_CS_PIN = 23 'set to 0 for demo if SDcard not connected
' connect other SD card pins in parallel with ILI9341 display i.e. SPI 1
' 
' Codes for use of the ILI9341 driver
'
const writebuffer=5 
' writes colour data saved in a string into a region previously defined 
' The zero position of the string contains its length and the subsequent bytes the RGB intensities 
' e.g. 6,R1,G1,B1,R2,G2,B2 
' this routine can be called repeatedly to fill the defined region 
' The string length must be divisible by 3 
const saverectangle=6 
' reads the contents of a rectangle off the screen, 3 bytes per pixel (R,G,B) 
' the parameters are: 
'   address of a buffer to receive the data  
'   x,y coordinates of top left, width, height 
'   byte position in the buffer to start writing 
const restorerectangle=7 
' writes the contents of a buffer to the screen, 3 bytes per pixel (R,G,B) 
' the parameters are: 
'   address of a buffer to provide the data  
'   x,y coordinates of top left, width, height 
'   byte position in the buffer to start reading 
const defineregion=8 
' defines a region that can be written into specified as x,y coordinates of top left, width, height 
' the parameters are: 
'   code to indicate the region will be used for writing (1) or reading (0)  
'   x,y coordinates of top left, width, height 
const writetriangle=9 '
' routine to write a single filled triangle to the screen
'   the parameters are: 
'   dummy parameter - set to zero
'   colour of the triangle to be written 
'   arrays of the x1,y1,  x2,y2,  x3,y3 coordinates of the triangle 
const triangles=128 ' + number of triangles 
' routine to save current screen data for a triangle and replace it with a user supplied colour and/or replace the screen data with information previously stored. 
'   the parameters are: 
'   Number of triangles to be processed 
'   a buffer big enough to hold the RGB data for all the triangles to be stored (3 bytes per pixel) 
'   array of the colours of the triangles to be written (use -1 to restore from the buffer) 
'   arrays of the x1,y1,  x2,y2,  x3,y3 coordinates of the triangles 
'   returns the number of byte used in the buffer: divide by 8 and add 1 to get the required number of integers
' 
'
' Codes for use of the SD card driver
' see http://www.thebackshed.com/forum/forum_posts.asp?TID=8648 for more details
'
const mount=0
const fileopen=1
const readfile=2
const writefile=3
const opendir=4
const readdir=5
'
const buffersize=5000
dim integer buff(buffersize),i,j,maxd


if MM.vres>mm.hres then
   maxd=mm.vres
else
   maxd=mm.hres
endif
if SD_CS_PIN then
  DisplayPicture("tiger2.ppm",0,0)  
else
  cls rgb(GRAY)
  for i=5 to sqr(mm.hres^2 + mm.Vres^2)/2 step 5 'cover the screen in circles
    circle mm.hres\2,mm.vres\2,i
  next i
endif
i=ILI9341_MX170(saverectangle, buff(), 95, 80, 130, 80, 0) 'save the central screen area to a buffer

for j=0 to 10 'flash transparent text overlayed on the background
  text mm.hres\2,mm.vres\2-28,"ILI9341",CM,,2,rgb(red),1
  text mm.hres\2,mm.vres\2,"Enhanced",CM,,2,rgb(red),1
  text mm.hres\2,mm.vres\2+28,"Driver",CM,,2,rgb(red),1
  pause 500
  i=ILI9341_MX170(restorerectangle, buff(), 95, 80, 130, 80, 0) 'restore the central screen area to a buffer
  pause 500
next j
'
'  rotate a pointer over the background
'
const Y_top = 0 'Y coordinate of top of the area swept by the pointer on the screen
const X_left = 0 'X coordinate of left of the iarea swept by the pointer on the screen
const Y_point = mm.vres\2 'Y coodinate of the centre of the pointer relative to the top
const X_point = mm.hres\2 'X coodinate of the centre of the pointer relative to the left
' 
' Now we define the pointer as the X,Y coordinates of a number of triangles with the rotation point at 0,0
' It is simplest to define this in the 12-oclock position which means the Y-coordinates at the top of the pointer will be negative
' The order of data elements in the array is:
' t1x1,t1y1,t1x2,t1y2,t1x3,t1y3, t2x1,t2y1,t2x2,t2y2,t2x3,t2y3,...tntx1,tnty1,tntx2,tnty2,tntx3,tnty3 
'
dim integer nt=2 'Number of triangles used to define the pointer
dim integer ptr(5,nt-1)=(-4,100,-4,-100,4,100,-4,-100,4,-100,4,100)
DIM INTEGER pcolour=rgb(green) 'define the colour of the pointer
dim integer xx0(nt*2-1),yy0(nt*2-1),xx1(nt*2-1),yy1(nt*2-1),xx2(nt*2-1),yy2(nt*2-1),tcol(nt*2-1)
dim integer first=1 'marker to control alternate processing on first time through the loop

for j=0 to 360*10 step 3
  drawpointer(j)
  pause 100
next j

end

Sub drawpointer(angle as float)  
    Local integer i 
    for i=0 to nt-1
      rotatetriangle(i,pcolour,angle,X_point+X_left,Y_point+Y_top,ptr(0,i),ptr(1,i),ptr(2,i),ptr(3,i),ptr(4,i),ptr(5,i)) 'rotate the pointer into the drawing array
    next i
    if first then 'store the background and write the pointer 
      i=ILI9341_MX170(triangles or nt, buff() , tcol(nt), xx0(nt), yy0(nt), xx1(nt), yy1(nt), xx2(nt), yy2(nt))  
      first=0 
    else 'replace the background over the last pointer, store the background for the new pointer and write itand write the pointer 
      i=ILI9341_MX170(triangles or nt*2, buff() , tcol(), xx0(), yy0(), xx1(), yy1(), xx2(), yy2())  
    endif 
End Sub    
'
sub rotatetriangle(n as integer, col as integer, angle as float, x as integer, y as integer, x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer)
   local float sine=sin(rad(angle)),cosine=cos(rad(angle))
   local integer x0a,y0a,x1a,y1a,x2a,y2a
   x0a= x0*cosine - y0 * sine + x
   y0a= y0*cosine + x0 * sine + y
   x1a= x1*cosine - y1 * sine + x
   y1a= y1*cosine + x1 * sine + y
   x2a= x2*cosine - y2 * sine + x
   y2a= y2*cosine + x2 * sine + y
   xx0(n)=xx0(n+nt)
   yy0(n)=yy0(n+nt)
   xx1(n)=xx1(n+nt)
   yy1(n)=yy1(n+nt)
   xx2(n)=xx2(n+nt)
   yy2(n)=yy2(n+nt)
   xx0(n+nt)=x0a 
   yy0(n+nt)=y0a
   xx1(n+nt)=x1a 
   yy1(n+nt)=y1a 
   xx2(n+nt)=x2a 
   yy2(n+nt)=y2a 
   tcol(n)=-1 
   tcol(n+nt)=col
end sub

'***************************************************************************************************  
'  
'  Display a picture from the SD card  
'    Code should work on any of the MM2 supported displays ILI9341, ST7735, ILI9163  
'    Picture must be in binary .PPM format   
'  
'    Parameters are:  
'       PIC$ = filename of the picture to be displayed  
'       StartX% = X coordinate of the top left of the picture  
'       StartY% = Y coordinate of the top left of the picture  
'  
'    Note: the routine checks that the picture is not too big for the screen and reports an error if it is 
'  
Sub DisplayPicture(PIC$, StartX%, StartY%)  
  LOCAL Buffer$,addbuffer$ length 3  
  LOCAL Result%=-1  
  LOCAL NumBytes%,a%,i%  
  if(SDcard(mount,SD_CS_PIN)) THEN : Print "Unable to mount Disk" : END : ENDIF 
  IF(SDcard(fileopen,PIC$)) then : print "Unable to open file" : END : ENDIF 
  'Read the first 128 bytes  
  Buffer$=STRING$(128," ")  
  IF(SDcard(readfile,buffer$,0,len(buffer$),NumBytes%)) THEN : PRINT "Unable to read file" : END : ENDIF
  a%=instr(buffer$,chr$(10)) ' look for the first CR  
  if left$(buffer$,a%-1)="P6" then   
      buffer$=right$(buffer$,len(buffer$)-a%)  
      a%=instr(buffer$,chr$(10)) ' look for the second CR  
      buffer$=right$(buffer$,len(buffer$)-a%)  
      a%=instr(buffer$,chr$(32)) ' look for the space between dimensions  
      local width%=val(left$(buffer$,a%-1))  
      buffer$=right$(buffer$,len(buffer$)-a%)  
      a%=instr(buffer$,chr$(10)) ' look for the third CR  
      LOCAL height%=val(left$(buffer$,a%-1))  
      buffer$=right$(buffer$,len(buffer$)-a%)  
      a%=instr(buffer$,chr$(10)) ' look for the fourth CR  
      buffer$=right$(buffer$,len(buffer$)-a%)  
      a%=len(buffer$) mod 3  
      addBuffer$=STRING$(3-a%," ") ' we need to make sure we have a number of bytes divisible by three in the buffer  
      Result%=SDcard(readfile,addbuffer$,-1,len(addbuffer$),NumBytes%) 
      buffer$=buffer$+addbuffer$        
      if (StartX%+width%>MM.HRES) OR (StartY%+height%>MM.VRES) then   
          print "Picture too big", width%," x",height%  
      else 
          i%=ILI9341_MX170(defineregion, 1, StartX%, StartY%, width%, height%)
          i%=ILI9341_MX170(writeregion,Buffer$)  
          Buffer$=STRING$(255,chr$(0))  
          do  
              Result%=SDcard(readfile,buffer$,-1,255,NumBytes%) 
              if numbytes%<>0 then i%=ILI9341_MX170(writeregion,Buffer$)  
          loop while NumBytes%<>0 
      endif  
  else  
     Print "Invalid File Format"  
  endif 
   
end sub
  
CFunction SDcard ' SPI 1 version 
    0000062F 
    'rcv_spi 
    240300FF 3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80  
    8C425820 03E00008 304200FF  
    'xmit_spi 
    308400FF 3C02BF80 AC445820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80  
    8C425820 03E00008 304200FF  
    'mem_set 
    10C00006 00801021 00862021 A0450000 24420001 5444FFFE A0450000 03E00008  
    00000000  
    'mem_cmp 
    2407FFFF 24C6FFFF 10C70008 00001021 80830000 80A20000 00621023 14400003  
    24840001 1000FFF7 24A50001 03E00008 00000000  
    'mystrlen 
    80830000 10600006 00001021 24420001 00821821 80630000 5460FFFD 24420001  
    03E00008 00000000  
    'MtoC 
    00801021 80870000 10E0000A 00802821 24830001 00873821 10600004 00000000  
    90660000 A0A60000 24A50001 1467FFFA 24630001 03E00008 A0A00000  
    'send_cmd 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 309100FF 7C111420 04410009  
    00A09021 24040077 00002821 0411FFF4 00000000 2C430002 10600034 8FBF001C  
    3231007F 3C109D00 8E030090 8E02001C 80640030 0040F809 24050006 0411FFA3  
    00000000 8E030090 8E02001C 80640030 0040F809 24050005 0411FF9C 00000000  
    02202021 0411FFA4 00000000 00122602 0411FFA1 00000000 7E443C00 0411FF9E  
    00000000 7E443A00 0411FF9B 00000000 324400FF 0411FF98 00000000 24020040  
    12220006 24040095 3A310048 24020001 24030087 00402021 0071200A 0411FF8E  
    00000000 2410000A 0411FF80 00000000 7C021C20 04610004 2610FFFF 321000FF  
    1600FFF9 00000000 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0020  
    'disk_readp 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809021  
    00C09821 00E0A021 3C029D00 8C42008C 8C4300FC 30630008 00051240 24040051  
    0043280A 0411FFA6 00000000 14400024 24100001 34109C40 241100FF 0411FF5B  
    00000000 14510005 2610FFFF 1600FFFB 00000000 1000001A 24100001 240300FE  
    14430017 24100001 00138823 26310202 12600006 02348823 0411FF4C 00000000  
    2673FFFF 1660FFFC 00000000 02548021 0411FF46 00000000 A2420000 26520001  
    1650FFFB 00000000 0411FF40 00000000 2631FFFF 1620FFFC 00000000 00008021  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FF34 00000000  
    02001021 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0028  
    'clust2sect 
    24A5FFFE 8C830008 2463FFFE 00A3182B 10600005 00001021 90830002 8C820014  
    70A32002 00821021 03E00008 00000000  
    'dir_rewind 
    27BDFFE8 AFBF0014 AFB00010 00A08021 A4A00000 8CA50008 24030001 10A30015  
    24020001 8C830008 00A3182B 50600012 8FBF0014 54A00008 AE05000C 90830000  
    24020003 54620008 AE00000C 8C850010 10A00005 AE05000C 0411FFDD 00000000  
    10000003 AE020010 8C820010 AE020010 00001021 8FBF0014 8FB00010 03E00008  
    27BD0018  
    'create_name 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00A08021 8C910004 02202021 24050020  
    2406000B 0411FF09 00000000 8E080000 00002021 00001821 24070008 2409002F  
    2406002E 240A0008 01031021 90420000 24630001 2C450021 14A00018 306300FF  
    50490017 01031821 10460003 0087282B 14A00008 2445FF9F 54EA0011 01031821  
    5446000F 01031821 01402021 1000FFEE 2407000B 30A500FF 2CA5001A 10A00003  
    02242821 2442FFE0 304200FF A0A20000 24840001 1000FFE4 308400FF 01031821  
    AE030000 2C420021 A222000B 00001021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'get_clust 
    90840000 24020003 14820006 00001821 90A30015 00031A00 90A20014 00621825  
    00031C00 90A2001B 00021200 90A4001A 00441025 03E00008 00621025  
    'get_fat 
    27BDFFE0 AFBF001C 2CA20002 1440001B 24030001 8C820008 00A2102B 10400018  
    00601021 000519C2 8C82000C 30A6007F 27A40010 00622821 00063080 24070004  
    0411FF31 00000000 1440000C 24030001 93A30013 00031E00 93A20012 00021400  
    00621825 93A20010 00621825 93A20011 00021200 00621825 7C63D800 00601021  
    8FBF001C 03E00008 27BD0020  
    'dir_next 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00808821 00A08021 94B20000  
    26520001 3252FFFF 12400028 24020003 8CA30010 50600026 8FBF001C 3242000F  
    54400021 A6120000 24630001 ACA30010 8CA5000C 14A00007 00121902 94830004  
    0243182B 14600017 24020003 10000018 8FBF001C 90820002 2442FFFF 00621024  
    54400011 A6120000 0411FFBA 00000000 00402821 2C430002 1460000C 24020001  
    8E230008 00A3182B 10600008 24020003 AE05000C 02202021 0411FF39 00000000  
    AE020010 A6120000 00001021 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0020  
    'dir_find 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00809821 00A08821  
    00C09021 0411FF31 00000000 14400021 00408021 96260000 30C6000F 02402021  
    8E250010 00063140 24070020 0411FED2 00000000 0002802B 16000017 02001021  
    92420000 50400013 24100003 9242000B 30420008 14400008 02602021 02402021  
    8E250004 2406000B 0411FE55 00000000 10400008 02602021 02202821 0411FF9F  
    00000000 1040FFE3 00408021 10000002 02001021 02001021 8FBF0024 8FB30020  
    8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'follow_path 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00809021 00A08021 AFA7002C  
    80E20000 24030020 14430006 00C08821 24E70001 AFA7002C 80E20000 5043FFFD  
    24E70001 2403002F 54430004 AE000008 24E70001 AFA7002C AE000008 8FA2002C  
    90420000 2C420020 10400008 02002021 02402021 02002821 0411FEE7 00000000  
    1000001B A2200000 02002021 27A5002C 0411FF02 00000000 14400015 02402021  
    02002821 02203021 0411FFA0 00000000 14400010 8FBF001C 8E030004 9063000B  
    5460000D 8FB20018 9222000B 30420010 10400006 02402021 02202821 0411FF28  
    00000000 1000FFE8 AE020008 24020003 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_lseek 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 1080004F  
    24020005 90830001 30630001 1060004B 24020004 8C82001C 0045902B 00B2100A  
    00409021 8C830018 AC800018 12400043 00001021 90910002 10600012 00118A40  
    2463FFFF 2642FFFF 0051001B 022001F4 00001012 0071001B 022001F4 00002012  
    0044102B 54400008 8E050020 00111023 00431824 AE030018 02439023 10000003  
    8E050024 8E050020 AE050024 0232102B 10400018 00119823 02519023 02002021  
    0411FEFC 00000000 00402821 2C420002 54400006 A2000001 8E020008 00A2102B  
    54400004 AE050024 A2000001 1000001B 24020001 8E020018 00511021 AE020018  
    02531021 00511821 0223182B 5460FFEB 00409021 8E020018 00529021 AE120018  
    02002021 0411FE6E 00000000 54400004 92040002 A2000001 10000008 24020001  
    2484FFFF 8E030018 00031A42 00831824 00431021 AE020028 00001021 8FBF0024  
    8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'pf_read 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00A0A821 00E09821 ACE00000 1080004A 24020005 90830001  
    30630001 10600046 24020004 8C92001C 8C820018 02429023 0246102B 00C2900A  
    1240003F 00001021 00A0A021 24160200 8E020018 304301FF 5460001F 8E060018  
    00021A42 92110002 2631FFFF 00718824 323100FF 1620000E 02002021 54400003  
    8E050024 10000003 8E020020 0411FEA3 00000000 2C430002 50600004 AE020024  
    A2000001 10000026 24020001 02002021 8E050024 0411FE24 00000000 14400004  
    00518821 A2000001 1000001D 24020001 AE110028 8E060018 30C601FF 02C61023  
    0052882B 0251100A 00408821 00002021 0295200B 8E050028 00403821 0411FDC9  
    00000000 50400004 8E020018 A2000001 1000000B 24020001 00511021 AE020018  
    02519023 8E620000 00511021 12400003 AE620000 1000FFC6 0291A021 00001021  
    8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0030  
    'disk_initialize 
    27BDFFD0 AFBF002C AFB30028 AFB20024 AFB10020 AFB0001C 2403003B 3C02BF80  
    AC435830 3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 2410000A  
    0411FD11 00000000 2610FFFF 321000FF 1600FFFB 24040040 00002821 0411FD4F  
    00000000 24030001 14430061 3C029D00 24040048 240501AA 0411FD48 00000000  
    24030001 14430037 240400E9 27B00010 27B10014 0411FCFC 00000000 A2020000  
    26100001 1611FFFB 93A30012 24020001 1462004E 00008021 93A30013 240200AA  
    1462004B 3C029D00 10000008 24112710 0040F809 24040064 2631FFFF 16200005  
    240400E9 1000003F 00008021 3C109D00 240400E9 3C054000 0411FD28 00000000  
    5440FFF3 8E020004 12200038 00008021 2404007A 00002821 0411FD20 00000000  
    14400033 3C029D00 24110004 0411FCD6 00000000 27A40010 00901821 26100001  
    1611FFFA A0620000 93B00010 32100040 2402000C 24030004 0070100A 10000023  
    00408021 00002821 0411FD0C 00000000 2C420002 24030002 24100001 0062800B  
    240300E9 24130041 0062980B 24112710 10000006 3C129D00 0040F809 24040064  
    2631FFFF 52200011 00008021 02602021 00002821 0411FCF9 00000000 5440FFF6  
    8E420004 52200009 00008021 24040050 24050200 0411FCF1 00000000 10000003  
    0002800B 10000002 3C029D00 3C029D00 8C43008C AC7000FC 8C430090 8C42001C  
    80640030 0040F809 24050006 0411FC9E 00000000 12000003 24030002 3C02BF80  
    AC435830 2E020001 8FBF002C 8FB30028 8FB20024 8FB10020 8FB0001C 03E00008  
    27BD0030  
    'disk_writep 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 10800014 00808021 30A5FFFF  
    10A00052 00009021 97828010 1040004F 00858821 92040000 26100001 0411FC8C  
    00000000 97828010 2442FFFF 3042FFFF 12110045 A7828010 5440FFF7 92040000  
    10000042 00009021 10A00016 97908010 3C029D00 8C42008C 8C4300FC 30630008  
    00051240 24040058 0043280A 0411FCB2 00000000 14400035 24120001 240400FF  
    0411FC73 00000000 240400FE 0411FC70 00000000 24020200 A7828010 1000002B  
    00009021 26100002 12000008 2610FFFF 2411FFFF 00002021 0411FC65 00000000  
    2610FFFF 1611FFFC 00002021 0411FC55 00000000 3042001F 24030005 14430010  
    24120001 10000005 241207D0 0040F809 240403E8 10000003 2652FFFF 241100FF  
    3C109D00 0411FC47 00000000 50510004 2E520001 5640FFF5 8E020004 24120001  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FC3A 00000000  
    10000003 02401021 00009021 02401021 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_write 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00C09021 00E09821 ACE00000 1080007B 24020005 90830001  
    30640001 10800077 24020004 14C00010 30630040 5060000A 92020001 00002021  
    00002821 0411FF84 00000000 50400004 92020001 A2000001 1000006A 24020001  
    304200BF A2020001 10000066 00001021 54600006 8E03001C 8E030018 2402FE00  
    00621024 AE020018 8E03001C 8E020018 00621023 0052182B 14600005 00000000  
    00A0A021 24150200 10000005 2416FFBF 1440FFFB 00409021 10000053 8FBF002C  
    8E020018 304301FF 54600029 8E110018 00021A42 92110002 2631FFFF 00718824  
    323100FF 1620000E 02002021 54400003 8E050024 10000003 8E020020 0411FD32  
    00000000 2C430002 50600004 AE020024 A2000001 1000003B 24020001 02002021  
    8E050024 0411FCB3 00000000 14400004 00512821 A2000001 10000032 24020001  
    AE050028 00002021 0411FF43 00000000 50400004 92020001 A2000001 10000029  
    24020001 34420040 A2020001 8E110018 323101FF 02B18823 0232102B 0242880A  
    02802021 02202821 0411FF33 00000000 50400004 8E020018 A2000001 10000019  
    24020001 00511021 AE020018 8E620000 00511021 AE620000 8E020018 304201FF  
    5440000D 02519023 00002021 00002821 0411FF21 00000000 50400004 92020001  
    A2000001 10000007 24020001 00561024 A2020001 02519023 1640FFB1 0291A021  
    00001021 8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014  
    8FB00010 03E00008 27BD0030  
    'check_fs 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00808021 00A08821 240601FE 24070002  
    0411FC20 00000000 14400028 24030003 92040001 00042200 92020000 00822025  
    7C042620 2402AA55 14820020 24030002 02002021 02202821 24060036 24070002  
    0411FC10 00000000 1440000A 02002021 92040001 00042200 92020000 00822025  
    7C042620 24024146 10820010 00001821 02002021 02202821 24060052 24070002  
    0411FC00 00000000 14400008 24030001 92030001 00031A00 92020000 00621825  
    7C031E20 38634146 0003182B 00601021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'pf_mount 
    27BDFFB8 AFBF0044 AFB10040 AFB0003C 00808021 0411FE3B 00000000 30420001  
    14400087 24030002 27A40010 00002821 0411FFBA 00000000 24030001 1443001A  
    00008821 27A40010 00002821 240601BE 24070010 0411FBDA 00000000 14400078  
    24030001 93A20014 10400075 24030006 93B1001B 00118E00 93A2001A 00021400  
    02228825 93A20018 02228825 93A20019 00021200 02228825 27A40010 02202821  
    0411FF9E 00000000 24040003 10440064 24030001 14400062 24030006 27A40010  
    02202821 2406000D 24070024 0411FBBC 00000000 1440005A 24030001 93A2001A  
    00021200 93A30019 00431025 1440000C 93A30013 93A3002A 00031E00 93A20029  
    00021400 00621025 93A30027 00431025 93A30028 00031A00 00431025 93A30013  
    70431002 93A60012 00063200 93A30011 00C33025 02268821 AE11000C 93A50010  
    A2050002 93A40015 00042200 93A30014 00832025 A6040004 93A30017 00031A00  
    93A70016 00671825 1460000B 00042102 93A70026 00073E00 93A30025 00031C00  
    00E31825 93A70023 00671825 93A70024 00073A00 00671825 00661823 00621823  
    00641823 0065001B 00A001F4 00003012 24C50002 AE050008 24C6F00A 3407EFFF  
    00C7302B 2CA70FF7 24030002 0066380B 3403FFF7 00A3282B 10A0001F 24030003  
    10E00017 24030006 24030003 14E3000D A2070000 93A50032 00052E00 93A30031  
    00031C00 00A32825 93A3002F 00A32825 93A30030 00031A00 00A31825 10000003  
    AE030010 00511821 AE030010 02248821 02221021 AE020014 A2000001 00001821  
    00601021 8FBF0044 8FB10040 8FB0003C 03E00008 27BD0048 1000FFE6 A2030000  
    'pf_open 
    27BDFFA0 AFBF005C AFB10058 AFB00054 00808821 00A03821 10800025 24100005  
    A0800001 27A20024 AFA20014 27A50010 27A60030 0411FC99 00000000 1440001C  
    00408021 93A20030 10400018 93A2003B 30420010 54400016 24100003 02202021  
    27A50030 0411FBED 00000000 AE220020 93A3004F 00031E00 93A2004E 00021400  
    00621025 93A3004C 00431025 93A3004D 00031A00 00431025 AE22001C AE200018  
    24020001 10000002 A2220001 24100003 02001021 8FBF005C 8FB10058 8FB00054  
    03E00008 27BD0060  
    'pf_opendir 
    27BDFFB0 AFBF004C AFB10048 AFB00044 00808021 00A08821 00C03821 10800018  
    24020005 27A20010 ACA20004 27A6001C 0411FC68 00000000 14400012 8FBF004C  
    93A2001C 1040000B 02002021 93A30027 30630010 1060000A 24020003 02002021  
    27A5001C 0411FBBB 00000000 AE220008 02002021 02202821 0411FB5C 00000000  
    8FBF004C 8FB10048 8FB00044 03E00008 27BD0050  
    'get_fileinfo 
    8C830010 10600036 24C20009 90A30000 24040020 1064000E 00A02021 244A0008  
    24090005 240800E5 10000003 240B0020 106B0007 24840001 00693826 0107180A  
    A0430000 24420001 544AFFF9 90830001 90A40008 24030020 1083000A 2403002E  
    A0430000 90A30008 24040020 1464001E 24420001 10000004 90A3000B A0430000  
    24420001 90A3000B A0C30008 90A4001F 00042600 90A3001E 00031C00 00831825  
    90A4001C 00641825 90A4001D 00042200 00641825 ACC30000 90A30019 00031A00  
    90A40018 00641825 A4C30004 90A30017 00031A00 90A40016 00641825 A4C30006  
    03E00008 A0400000 A0430000 90A30009 24040020 1064FFE3 24420001 A0430000  
    90A3000A 1464FFDD 24420001 1000FFDE 90A3000B  
    'dir_read 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809821  
    00A08021 00C08821 24020003 241200E5 10000019 2414002E 30C6000F 02202021  
    00063140 24070020 0411FAA9 00000000 0002102B 54400016 AE000010 92230000  
    50600012 24020003 10720005 9224000B 10740003 30840008 1080000E 8FBF0024  
    02602021 02002821 0411FB7A 00000000 54400007 AE000010 8E050010 54A0FFE6  
    96060000 10400003 8FBF0024 AE000010 8FBF0024 8FB40020 8FB3001C 8FB20018  
    8FB10014 8FB00010 03E00008 27BD0028  
    'pf_readdir 
    27BDFFB0 AFBF004C AFB20048 AFB10044 AFB00040 00808821 00A08021 00C09021  
    1080001B 24020005 27A20010 14C00005 ACA20004 0411FACF 00000000 10000015  
    8FBF004C 27A6001C 0411FFB9 00000000 24030003 10430004 02002021 1440000D  
    8FBF004C 02002021 27A5001C 02403021 0411FF6A 00000000 02202021 02002821  
    0411FB48 00000000 38430003 0003100A 8FBF004C 8FB20048 8FB10044 8FB00040  
    03E00008 27BD0050  
    'main 
    27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C  
    AFB20028 AFB10024 AFB00020 00808821 00A0A021 00C0A821 00E0B021 3C02BF80  
    34038060 AC435800 24030C00 AC435840 24030002 AC435830 3C039D00 8C72008C  
    26530050 26570078 8C445830 AE440044 8C455800 8C64008C AC850048 8C445840  
    8C62008C AC44004C 8E220000 144000C0 00008021 3C02BF81 8C44F220 7C84D800  
    3C030661 3463A053 1083000B 24020050 3C02BF81 8C43F220 7C63D800 3C020660  
    3442A053 00621026 24030050 2404000C 0082180B 00601021 3C039D00 8C630088  
    00431021 8C430000 24020065 10620084 3C029D00 8C420010 3C03BF81 8C65F220  
    7CA5D800 3C030661 3463A053 10A3000B 24040014 3C03BF81 8C64F220 7C84D800  
    3C030660 3463A053 00832026 24030014 24050003 00A4180B 00602021 24050008  
    0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661  
    3463A053 10A3000B 24040014 3C03BF81 8C64F220 7C84D800 3C030660 3463A053  
    00832026 24030014 24050003 00A4180B 00602021 24050064 0040F809 00003021  
    3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000B  
    24040029 3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026 24030029  
    2405000E 00A4180B 00602021 24050002 0040F809 00003021 3C029D00 8C420010  
    3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000B 24040029 3C03BF81  
    8C64F220 7C84D800 3C030660 3463A053 00832026 24030029 2405000E 00A4180B  
    00602021 24050064 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220  
    7CA5D800 3C030661 3463A053 10A3000B 2404000E 3C03BF81 8C64F220 7C84D800  
    3C030660 3463A053 00832026 2403000E 24050019 00A4180B 00602021 24050008  
    0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661  
    3463A053 10A3000B 2404000E 3C03BF81 8C64F220 7C84D800 3C030660 3463A053  
    00832026 2403000E 24050019 00A4180B 00602021 24050064 0040F809 00003021  
    3C02BF81 8C43FA84 24040001 7C831804 AC43FA84 3C02BF81 8C43FB04 24040003  
    7C831804 AC43FB04 3C02BF80 34038060 AC435800 24030C00 AC435840 3C109D00  
    8E020090 92830000 A0430030 8E030090 8E020010 80640030 24050008 0040F809  
    00003021 8E030090 8E02001C 80640030 0040F809 24050006 8E02008C AC4000F8  
    02602021 0411FD8C 00000000 00408021 8E230000 24020001 1462000B 24020002  
    82820000 02821021 A0400001 02602021 26850001 0411FE18 00000000 00408021  
    8E230000 24020002 5462001E 8E230000 8EA50000 04A00004 02602021 0411FAF7  
    00000000 00408021 56000016 8E230000 8EC60000 28C20100 10400009 02602021  
    26850001 27A70010 0411FB4A 00000000 00408021 8FA20010 10000006 A2820000  
    02802821 27A70010 0411FB42 00000000 00408021 8FA30010 8FA20058 AC430000  
    8E230000 24020003 54620067 8E230000 8EA20000 04410005 3C029D00 8C42008C  
    8C4200F8 AEA20000 3C029D00 8C42008C 8C4400F8 8EC30000 00831821 AC4300F8  
    8EBE0000 2410FE00 03D08024 02602021 02002821 0411FAC9 00000000 8EC60000  
    28C20100 02821021 AFA20018 8EA20000 10500040 3C029D00 8C42003C 0040F809  
    24040200 0040A821 02602021 00402821 24060200 27A70010 0411FB16 00000000  
    02602021 02002821 0411FAB4 00000000 1440002A 00408021 33DE01FF 8EC40000  
    03C42021 2C820201 14400003 00008021 2490FE00 24040200 03C4102A 10400008  
    8FA20018 02BEF021 02A42021 90430000 A3C30000 27DE0001 17C4FFFC 24420001  
    02602021 02A02821 8FA60010 27A70010 0411FC4D 00000000 1200000A 02602021  
    8EC50000 00B02823 8FA20018 00452821 02003021 27A70010 0411FC43 00000000  
    02602021 00002821 00003021 27A70010 0411FC3D 00000000 00408021 3C029D00  
    8C420044 0040F809 02A02021 1000000E 8E230000 02602021 8FA50018 27A70010  
    0411FC31 00000000 02602021 00002821 00003021 27A70010 0411FC2B 00000000  
    00408021 8E230000 24020004 5462000B 8E230000 02802021 0411F888 00000000  
    02602021 02E02821 00403021 0411FDB4 00000000 00408021 8E230000 24020005  
    1462003E 3C029D00 265200A0 02602021 02E02821 02403021 0411FE47 00000000  
    92440008 24030016 14830007 00408021 02602021 02E02821 02403021 0411FE3E  
    00000000 00408021 56000029 82430009 8FA20010 02421021 80420009 50400024  
    82430009 92420008 30420010 54400006 2402003C 24110001 02911821 00001021  
    1000000C 2405000C A2820001 24020044 A2820002 24020069 A2820003 24020072  
    A2820004 2402003E A2820005 1000FFF2 24110006 02422021 90840009 A0640000  
    24420001 1445FFFB 24630001 2402000C AFA20010 26440009 0411F83E 00000000  
    2631FFFF 02228821 A2910000 82430009 2402FFFF 0043800A 3C029D00 8C43008C  
    8C640044 3C02BF80 AC445830 8C640048 AC445800 8C63004C AC435840 00101FC3  
    02001021 8FBF0044 8FBE0040 8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C  
    8FB20028 8FB10024 8FB00020 03E00008 27BD0048  
End CFunction 
