Option explicit
option default NONE
' 
'  Demo of functionality of ILI9341 enhanced functionality driver for Micromite MX470
' 
const SD_CS_PIN = 52 'set to 0 for demo if SDcard not connected
' connect other SD card pins in parallel with ILI9341 display i.e. SPI 1
' 
' Codes for use of the ILI9341 driver
'
const writeregion=5 
' writes colour data saved in a string into a region previously defined 
' The zero position of the string contains its length and the subsequent bytes the RGB intensities 
' e.g. 6,R1,G1,B1,R2,G2,B2 
' this routine can be called repeatedly to fill the defined region 
' The string length must be divisible by 3 
const saverectangle=6 
' reads the contents of a rectangle off the screen, 3 bytes per pixel (R,G,B) 
' the parameters are: 
'   address of a buffer to receive the data  
'   x,y coordinates of top left, width, height 
'   byte position in the buffer to start writing 
const restorerectangle=7 
' writes the contents of a buffer to the screen, 3 bytes per pixel (R,G,B) 
' the parameters are: 
'   address of a buffer to provide the data  
'   x,y coordinates of top left, width, height 
'   byte position in the buffer to start reading 
const defineregion=8 
' defines a region that can be written into specified as x,y coordinates of top left, width, height 
' the parameters are: 
'   code to indicate the region will be used for writing (1) or reading (0)  
'   x,y coordinates of top left, width, height 
const writetriangle=9 '
' routine to write a single filled triangle to the screen
'   the parameters are: 
'   dummy parameter - set to zero
'   colour of the triangle to be written 
'   arrays of the x1,y1,  x2,y2,  x3,y3 coordinates of the triangle 
const triangles=128 ' + number of triangles 
' routine to save current screen data for a triangle and replace it with a user supplied colour and/or replace the screen data with information previously stored. 
'   the parameters are: 
'   Number of triangles to be processed 
'   a buffer big enough to hold the RGB data for all the triangles to be stored (3 bytes per pixel) 
'   array of the colours of the triangles to be written (use -1 to restore from the buffer) 
'   arrays of the x1,y1,  x2,y2,  x3,y3 coordinates of the triangles 
'   returns the number of byte used in the buffer: divide by 8 and add 1 to get the required number of integers
' 
'
' Codes for use of the SD card driver
' see http://www.thebackshed.com/forum/forum_posts.asp?TID=8648 for more details
'
const mount=0
const fileopen=1
const readfile=2
const writefile=3
const opendir=4
const readdir=5
'
const buffersize=5000
dim integer buff(buffersize),i,j,maxd


if MM.vres>mm.hres then
   maxd=mm.vres
else
   maxd=mm.hres
endif
if SD_CS_PIN then
  load image "tiger2.bmp",0,0
else
  cls rgb(GRAY)
  for i=5 to sqr(mm.hres^2 + mm.Vres^2)/2 step 5 'cover the screen in circles
    circle mm.hres\2,mm.vres\2,i
  next i
endif
i=ILI9341_MX470(saverectangle, buff(), 95, 80, 130, 80, 0) 'save the central screen area to a buffer

for j=0 to 10 'flash transparent text overlayed on the background
  text mm.hres\2,mm.vres\2-28,"ILI9341",CM,,2,rgb(red),1
  text mm.hres\2,mm.vres\2,"Enhanced",CM,,2,rgb(red),1
  text mm.hres\2,mm.vres\2+28,"Driver",CM,,2,rgb(red),1
  pause 500
  i=ILI9341_MX470(restorerectangle, buff(), 95, 80, 130, 80, 0) 'restore the central screen area to a buffer
  pause 500
next j
'
'  rotate a pointer over the background
'
const Y_top = 0 'Y coordinate of top of the area swept by the pointer on the screen
const X_left = 0 'X coordinate of left of the iarea swept by the pointer on the screen
const Y_point = mm.vres\2 'Y coodinate of the centre of the pointer relative to the top
const X_point = mm.hres\2 'X coodinate of the centre of the pointer relative to the left
' 
' Now we define the pointer as the X,Y coordinates of a number of triangles with the rotation point at 0,0
' It is simplest to define this in the 12-oclock position which means the Y-coordinates at the top of the pointer will be negative
' The order of data elements in the array is:
' t1x1,t1y1,t1x2,t1y2,t1x3,t1y3, t2x1,t2y1,t2x2,t2y2,t2x3,t2y3,...tntx1,tnty1,tntx2,tnty2,tntx3,tnty3 
'
dim integer nt=2 'Number of triangles used to define the pointer
dim integer ptr(5,nt-1)=(-4,100,-4,-100,4,100,-4,-100,4,-100,4,100)
DIM INTEGER pcolour=rgb(green) 'define the colour of the pointer
dim integer xx0(nt*2-1),yy0(nt*2-1),xx1(nt*2-1),yy1(nt*2-1),xx2(nt*2-1),yy2(nt*2-1),tcol(nt*2-1)
dim integer first=1 'marker to control alternate processing on first time through the loop

for j=0 to 360*10 step 3
  drawpointer(j)
  pause 100
next j

end

Sub drawpointer(angle as float)  
    Local integer i 
    for i=0 to nt-1
      rotatetriangle(i,pcolour,angle,X_point+X_left,Y_point+Y_top,ptr(0,i),ptr(1,i),ptr(2,i),ptr(3,i),ptr(4,i),ptr(5,i)) 'rotate the pointer into the drawing array
    next i
    if first then 'store the background and write the pointer 
      i=ILI9341_MX470(triangles or nt, buff() , tcol(nt), xx0(nt), yy0(nt), xx1(nt), yy1(nt), xx2(nt), yy2(nt))  
      first=0 
    else 'replace the background over the last pointer, store the background for the new pointer and write itand write the pointer 
      i=ILI9341_MX470(triangles or nt*2, buff() , tcol(), xx0(), yy0(), xx1(), yy1(), xx2(), yy2())  
    endif 
End Sub    
'
sub rotatetriangle(n as integer, col as integer, angle as float, x as integer, y as integer, x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer)
   local float sine=sin(rad(angle)),cosine=cos(rad(angle))
   local integer x0a,y0a,x1a,y1a,x2a,y2a
   x0a= x0*cosine - y0 * sine + x
   y0a= y0*cosine + x0 * sine + y
   x1a= x1*cosine - y1 * sine + x
   y1a= y1*cosine + x1 * sine + y
   x2a= x2*cosine - y2 * sine + x
   y2a= y2*cosine + x2 * sine + y
   xx0(n)=xx0(n+nt)
   yy0(n)=yy0(n+nt)
   xx1(n)=xx1(n+nt)
   yy1(n)=yy1(n+nt)
   xx2(n)=xx2(n+nt)
   yy2(n)=yy2(n+nt)
   xx0(n+nt)=x0a 
   yy0(n+nt)=y0a
   xx1(n+nt)=x1a 
   yy1(n+nt)=y1a 
   xx2(n+nt)=x2a 
   yy2(n+nt)=y2a 
   tcol(n)=-1 
   tcol(n+nt)=col
end sub
