sub mm.startup 
' 
' include initialisation for display driver here if required 
' 
    local i%=ILI9341_MX170(3,6,15,16)
    sdcard 0,10,2 'set up the chip select pin for the SDcard 
end sub 
sub load(f$) 
  sdcard 6,f$ 
  end 
end sub 
sub save(f$) 
  sdcard 7,f$ 
end sub 
CSub SDcard ' SPI2 version 
    00000676 
    'rcv_spi 
    240300FF 3C02BF80 AC435A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80  
    8C425A20 03E00008 304200FF  
    'xmit_spi 
    308400FF 3C02BF80 AC445A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80  
    8C425A20 03E00008 304200FF  
    'mem_set 
    10C00006 00801021 00862021 A0450000 24420001 5444FFFE A0450000 03E00008  
    00000000  
    'mem_cmp 
    2407FFFF 24C6FFFF 10C70008 00001021 80830000 80A20000 00621023 14400003  
    24840001 1000FFF7 24A50001 03E00008 00000000  
    'mystrlen 
    80830000 10600006 00001021 24420001 00821821 80630000 5460FFFD 24420001  
    03E00008 00000000  
    'send_cmd 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 309100FF 7C111420 04410009  
    00A09021 24040077 00002821 0411FFF4 00000000 2C430002 10600034 8FBF001C  
    3231007F 3C109D00 8E030090 8E02001C 80640030 0040F809 24050006 0411FFB2  
    00000000 8E030090 8E02001C 80640030 0040F809 24050005 0411FFAB 00000000  
    02202021 0411FFB3 00000000 00122602 0411FFB0 00000000 7E443C00 0411FFAD  
    00000000 7E443A00 0411FFAA 00000000 324400FF 0411FFA7 00000000 24020040  
    12220006 24040095 3A310048 24020001 24030087 00402021 0071200A 0411FF9D  
    00000000 2410000A 0411FF8F 00000000 7C021C20 04610004 2610FFFF 321000FF  
    1600FFF9 00000000 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0020  
    'disk_readp 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809021  
    00C09821 00E0A021 3C029D00 8C42008C 8C4300FC 30630008 00051240 24040051  
    0043280A 0411FFA6 00000000 14400024 24100001 34109C40 241100FF 0411FF6A  
    00000000 14510005 2610FFFF 1600FFFB 00000000 1000001A 24100001 240300FE  
    14430017 24100001 00138823 26310202 12600006 02348823 0411FF5B 00000000  
    2673FFFF 1660FFFC 00000000 02548021 0411FF55 00000000 A2420000 26520001  
    1650FFFB 00000000 0411FF4F 00000000 2631FFFF 1620FFFC 00000000 00008021  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FF43 00000000  
    02001021 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0028  
    'clust2sect 
    24A5FFFE 8C830008 2463FFFE 00A3182B 10600005 00001021 90830002 8C820014  
    70A32002 00821021 03E00008 00000000  
    'dir_rewind 
    27BDFFE8 AFBF0014 AFB00010 00A08021 A4A00000 8CA50008 24030001 10A30015  
    24020001 8C830008 00A3182B 50600012 8FBF0014 54A00008 AE05000C 90830000  
    24020003 54620008 AE00000C 8C850010 10A00005 AE05000C 0411FFDD 00000000  
    10000003 AE020010 8C820010 AE020010 00001021 8FBF0014 8FB00010 03E00008  
    27BD0018  
    'create_name 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00A08021 8C910004 02202021 24050020  
    2406000B 0411FF18 00000000 8E080000 00002021 00001821 24070008 2409002F  
    2406002E 240A0008 01031021 90420000 24630001 2C450021 14A00018 306300FF  
    50490017 01031821 10460003 0087282B 14A00008 2445FF9F 54EA0011 01031821  
    5446000F 01031821 01402021 1000FFEE 2407000B 30A500FF 2CA5001A 10A00003  
    02242821 2442FFE0 304200FF A0A20000 24840001 1000FFE4 308400FF 01031821  
    AE030000 2C420021 A222000B 00001021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'get_clust 
    90840000 24020003 14820006 00001821 90A30015 00031A00 90A20014 00621825  
    00031C00 90A2001B 00021200 90A4001A 00441025 03E00008 00621025  
    'get_fat 
    27BDFFE0 AFBF001C 2CA20002 1440001B 24030001 8C820008 00A2102B 10400018  
    00601021 000519C2 8C82000C 30A6007F 27A40010 00622821 00063080 24070004  
    0411FF31 00000000 1440000C 24030001 93A30013 00031E00 93A20012 00021400  
    00621825 93A20010 00621825 93A20011 00021200 00621825 7C63D800 00601021  
    8FBF001C 03E00008 27BD0020  
    'dir_next 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00808821 00A08021 94B20000  
    26520001 3252FFFF 12400028 24020003 8CA30010 50600026 8FBF001C 3242000F  
    54400021 A6120000 24630001 ACA30010 8CA5000C 14A00007 00121902 94830004  
    0243182B 14600017 24020003 10000018 8FBF001C 90820002 2442FFFF 00621024  
    54400011 A6120000 0411FFBA 00000000 00402821 2C430002 1460000C 24020001  
    8E230008 00A3182B 10600008 24020003 AE05000C 02202021 0411FF39 00000000  
    AE020010 A6120000 00001021 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0020  
    'dir_find 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00809821 00A08821  
    00C09021 0411FF31 00000000 14400021 00408021 96260000 30C6000F 02402021  
    8E250010 00063140 24070020 0411FED2 00000000 0002802B 16000017 02001021  
    92420000 50400013 24100003 9242000B 30420008 14400008 02602021 02402021  
    8E250004 2406000B 0411FE64 00000000 10400008 02602021 02202821 0411FF9F  
    00000000 1040FFE3 00408021 10000002 02001021 02001021 8FBF0024 8FB30020  
    8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'follow_path 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00809021 00A08021 AFA7002C  
    80E20000 24030020 14430006 00C08821 24E70001 AFA7002C 80E20000 5043FFFD  
    24E70001 2403002F 54430004 AE000008 24E70001 AFA7002C AE000008 8FA2002C  
    90420000 2C420020 10400008 02002021 02402021 02002821 0411FEE7 00000000  
    1000001B A2200000 02002021 27A5002C 0411FF02 00000000 14400015 02402021  
    02002821 02203021 0411FFA0 00000000 14400010 8FBF001C 8E030004 9063000B  
    5460000D 8FB20018 9222000B 30420010 10400006 02402021 02202821 0411FF28  
    00000000 1000FFE8 AE020008 24020003 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_lseek 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 1080004F  
    24020005 90830001 30630001 1060004B 24020004 8C82001C 0045902B 00B2100A  
    00409021 8C830018 AC800018 12400043 00001021 90910002 10600012 00118A40  
    2463FFFF 2642FFFF 0051001B 022001F4 00001012 0071001B 022001F4 00002012  
    0044102B 54400008 8E050020 00111023 00431824 AE030018 02439023 10000003  
    8E050024 8E050020 AE050024 0232102B 10400018 00119823 02519023 02002021  
    0411FEFC 00000000 00402821 2C420002 54400006 A2000001 8E020008 00A2102B  
    54400004 AE050024 A2000001 1000001B 24020001 8E020018 00511021 AE020018  
    02531021 00511821 0223182B 5460FFEB 00409021 8E020018 00529021 AE120018  
    02002021 0411FE6E 00000000 54400004 92040002 A2000001 10000008 24020001  
    2484FFFF 8E030018 00031A42 00831824 00431021 AE020028 00001021 8FBF0024  
    8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'pf_read 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00A0A821 00E09821 ACE00000 1080004A 24020005 90830001  
    30630001 10600046 24020004 8C92001C 8C820018 02429023 0246102B 00C2900A  
    1240003F 00001021 00A0A021 24160200 8E020018 304301FF 5460001F 8E060018  
    00021A42 92110002 2631FFFF 00718824 323100FF 1620000E 02002021 54400003  
    8E050024 10000003 8E020020 0411FEA3 00000000 2C430002 50600004 AE020024  
    A2000001 10000026 24020001 02002021 8E050024 0411FE24 00000000 14400004  
    00518821 A2000001 1000001D 24020001 AE110028 8E060018 30C601FF 02C61023  
    0052882B 0251100A 00408821 00002021 0295200B 8E050028 00403821 0411FDC9  
    00000000 50400004 8E020018 A2000001 1000000B 24020001 00511021 AE020018  
    02519023 8E620000 00511021 12400003 AE620000 1000FFC6 0291A021 00001021  
    8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0030  
    'disk_initialize 
    27BDFFD0 AFBF002C AFB30028 AFB20024 AFB10020 AFB0001C 2403003B 3C02BF80  
    AC435A30 3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 2410000A  
    0411FD20 00000000 2610FFFF 321000FF 1600FFFB 24040040 00002821 0411FD4F  
    00000000 24030001 14430061 3C029D00 24040048 240501AA 0411FD48 00000000  
    24030001 14430037 240400E9 27B00010 27B10014 0411FD0B 00000000 A2020000  
    26100001 1611FFFB 93A30012 24020001 1462004E 00008021 93A30013 240200AA  
    1462004B 3C029D00 10000008 24112710 0040F809 24040064 2631FFFF 16200005  
    240400E9 1000003F 00008021 3C109D00 240400E9 3C054000 0411FD28 00000000  
    5440FFF3 8E020004 12200038 00008021 2404007A 00002821 0411FD20 00000000  
    14400033 3C029D00 24110004 0411FCE5 00000000 27A40010 00901821 26100001  
    1611FFFA A0620000 93B00010 32100040 2402000C 24030004 0070100A 10000023  
    00408021 00002821 0411FD0C 00000000 2C420002 24030002 24100001 0062800B  
    240300E9 24130041 0062980B 24112710 10000006 3C129D00 0040F809 24040064  
    2631FFFF 52200011 00008021 02602021 00002821 0411FCF9 00000000 5440FFF6  
    8E420004 52200009 00008021 24040050 24050200 0411FCF1 00000000 10000003  
    0002800B 10000002 3C029D00 3C029D00 8C43008C AC7000FC 8C430090 8C42001C  
    80640030 0040F809 24050006 0411FCAD 00000000 12000005 3C029D00 8C420090  
    8043003C 3C02BF80 AC435A30 2E020001 8FBF002C 8FB30028 8FB20024 8FB10020  
    8FB0001C 03E00008 27BD0030  
    'disk_writep 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 10800014 00808021 30A5FFFF  
    10A00052 00009021 97828010 1040004F 00858821 92040000 26100001 0411FC99  
    00000000 97828010 2442FFFF 3042FFFF 12110045 A7828010 5440FFF7 92040000  
    10000042 00009021 10A00016 97908010 3C029D00 8C42008C 8C4300FC 30630008  
    00051240 24040058 0043280A 0411FCB0 00000000 14400035 24120001 240400FF  
    0411FC80 00000000 240400FE 0411FC7D 00000000 24020200 A7828010 1000002B  
    00009021 26100002 12000008 2610FFFF 2411FFFF 00002021 0411FC72 00000000  
    2610FFFF 1611FFFC 00002021 0411FC62 00000000 3042001F 24030005 14430010  
    24120001 10000005 241207D0 0040F809 240403E8 10000003 2652FFFF 241100FF  
    3C109D00 0411FC54 00000000 50510004 2E520001 5640FFF5 8E020004 24120001  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FC47 00000000  
    10000003 02401021 00009021 02401021 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_write 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00C09021 00E09821 ACE00000 1080007B 24020005 90830001  
    30640001 10800077 24020004 14C00010 30630040 5060000A 92020001 00002021  
    00002821 0411FF84 00000000 50400004 92020001 A2000001 1000006A 24020001  
    304200BF A2020001 10000066 00001021 54600006 8E03001C 8E030018 2402FE00  
    00621024 AE020018 8E03001C 8E020018 00621023 0052182B 14600005 00000000  
    00A0A021 24150200 10000005 2416FFBF 1440FFFB 00409021 10000053 8FBF002C  
    8E020018 304301FF 54600029 8E110018 00021A42 92110002 2631FFFF 00718824  
    323100FF 1620000E 02002021 54400003 8E050024 10000003 8E020020 0411FD30  
    00000000 2C430002 50600004 AE020024 A2000001 1000003B 24020001 02002021  
    8E050024 0411FCB1 00000000 14400004 00512821 A2000001 10000032 24020001  
    AE050028 00002021 0411FF43 00000000 50400004 92020001 A2000001 10000029  
    24020001 34420040 A2020001 8E110018 323101FF 02B18823 0232102B 0242880A  
    02802021 02202821 0411FF33 00000000 50400004 8E020018 A2000001 10000019  
    24020001 00511021 AE020018 8E620000 00511021 AE620000 8E020018 304201FF  
    5440000D 02519023 00002021 00002821 0411FF21 00000000 50400004 92020001  
    A2000001 10000007 24020001 00561024 A2020001 02519023 1640FFB1 0291A021  
    00001021 8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014  
    8FB00010 03E00008 27BD0030  
    'check_fs 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00808021 00A08821 240601FE 24070002  
    0411FC1E 00000000 14400028 24030003 92040001 00042200 92020000 00822025  
    7C042620 2402AA55 14820020 24030002 02002021 02202821 24060036 24070002  
    0411FC0E 00000000 1440000A 02002021 92040001 00042200 92020000 00822025  
    7C042620 24024146 10820010 00001821 02002021 02202821 24060052 24070002  
    0411FBFE 00000000 14400008 24030001 92030001 00031A00 92020000 00621825  
    7C031E20 38634146 0003182B 00601021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'pf_mount 
    27BDFFB8 AFBF0044 AFB10040 AFB0003C 00808021 0411FE39 00000000 30420001  
    14400087 24030002 27A40010 00002821 0411FFBA 00000000 24030001 1443001A  
    00008821 27A40010 00002821 240601BE 24070010 0411FBD8 00000000 14400078  
    24030001 93A20014 10400075 24030006 93B1001B 00118E00 93A2001A 00021400  
    02228825 93A20018 02228825 93A20019 00021200 02228825 27A40010 02202821  
    0411FF9E 00000000 24040003 10440064 24030001 14400062 24030006 27A40010  
    02202821 2406000D 24070024 0411FBBA 00000000 1440005A 24030001 93A2001A  
    00021200 93A30019 00431025 1440000C 93A30013 93A3002A 00031E00 93A20029  
    00021400 00621025 93A30027 00431025 93A30028 00031A00 00431025 93A30013  
    70431002 93A60012 00063200 93A30011 00C33025 02268821 AE11000C 93A50010  
    A2050002 93A40015 00042200 93A30014 00832025 A6040004 93A30017 00031A00  
    93A70016 00671825 1460000B 00042102 93A70026 00073E00 93A30025 00031C00  
    00E31825 93A70023 00671825 93A70024 00073A00 00671825 00661823 00621823  
    00641823 0065001B 00A001F4 00003012 24C50002 AE050008 24C6F00A 3407EFFF  
    00C7302B 2CA70FF7 24030002 0066380B 3403FFF7 00A3282B 10A0001F 24030003  
    10E00017 24030006 24030003 14E3000D A2070000 93A50032 00052E00 93A30031  
    00031C00 00A32825 93A3002F 00A32825 93A30030 00031A00 00A31825 10000003  
    AE030010 00511821 AE030010 02248821 02221021 AE020014 A2000001 00001821  
    00601021 8FBF0044 8FB10040 8FB0003C 03E00008 27BD0048 1000FFE6 A2030000  
    'pf_open 
    27BDFFA0 AFBF005C AFB10058 AFB00054 00808821 00A03821 10800025 24100005  
    A0800001 27A20024 AFA20014 27A50010 27A60030 0411FC97 00000000 1440001C  
    00408021 93A20030 10400018 93A2003B 30420010 54400016 24100003 02202021  
    27A50030 0411FBEB 00000000 AE220020 93A3004F 00031E00 93A2004E 00021400  
    00621025 93A3004C 00431025 93A3004D 00031A00 00431025 AE22001C AE200018  
    24020001 10000002 A2220001 24100003 02001021 8FBF005C 8FB10058 8FB00054  
    03E00008 27BD0060  
    'pf_opendir 
    27BDFFB0 AFBF004C AFB10048 AFB00044 00808021 00A08821 00C03821 10800018  
    24020005 27A20010 ACA20004 27A6001C 0411FC66 00000000 14400012 8FBF004C  
    93A2001C 1040000B 02002021 93A30027 30630010 1060000A 24020003 02002021  
    27A5001C 0411FBB9 00000000 AE220008 02002021 02202821 0411FB5A 00000000  
    8FBF004C 8FB10048 8FB00044 03E00008 27BD0050  
    'get_fileinfo 
    8C830010 10600036 24C20009 90A30000 24040020 1064000E 00A02021 244A0008  
    24090005 240800E5 10000003 240B0020 106B0007 24840001 00693826 0107180A  
    A0430000 24420001 544AFFF9 90830001 90A40008 24030020 1083000A 2403002E  
    A0430000 90A30008 24040020 1464001E 24420001 10000004 90A3000B A0430000  
    24420001 90A3000B A0C30008 90A4001F 00042600 90A3001E 00031C00 00831825  
    90A4001C 00641825 90A4001D 00042200 00641825 ACC30000 90A30019 00031A00  
    90A40018 00641825 A4C30004 90A30017 00031A00 90A40016 00641825 A4C30006  
    03E00008 A0400000 A0430000 90A30009 24040020 1064FFE3 24420001 A0430000  
    90A3000A 1464FFDD 24420001 1000FFDE 90A3000B  
    'dir_read 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809821  
    00A08021 00C08821 24020003 241200E5 10000019 2414002E 30C6000F 02202021  
    00063140 24070020 0411FAA7 00000000 0002102B 54400016 AE000010 92230000  
    50600012 24020003 10720005 9224000B 10740003 30840008 1080000E 8FBF0024  
    02602021 02002821 0411FB78 00000000 54400007 AE000010 8E050010 54A0FFE6  
    96060000 10400003 8FBF0024 AE000010 8FBF0024 8FB40020 8FB3001C 8FB20018  
    8FB10014 8FB00010 03E00008 27BD0028  
    'pf_readdir 
    27BDFFB0 AFBF004C AFB20048 AFB10044 AFB00040 00808821 00A08021 00C09021  
    1080001B 24020005 27A20010 14C00005 ACA20004 0411FACD 00000000 10000015  
    8FBF004C 27A6001C 0411FFB9 00000000 24030003 10430004 02002021 1440000D  
    8FBF004C 02002021 27A5001C 02403021 0411FF6A 00000000 02202021 02002821  
    0411FB46 00000000 38430003 0003100A 8FBF004C 8FB20048 8FB10044 8FB00040  
    03E00008 27BD0050  
    'getFPC 
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008  
    'errstring 
    27BDFFE0 AFBF001C AFB00018 00808021 00002021 3C059D00 24A518D0 27A60010  
    0411FFEF 00000000 8FA20010 1200003C 24030001 16030006 24030002 8FA30010  
    3C049D00 248424FC 10000012 00832021 56030006 3C049D00 8FA30010 3C049D00  
    2484250C 10000013 00832021 248424EC 00822021 24020003 16020007 24020004  
    8FA30010 3C049D00 24842518 10000011 00832021 24020004 16020007 24020005  
    8FA30010 3C049D00 24842524 10000011 00832021 24020005 16020007 24020006  
    8FA30010 3C049D00 24842534 10000010 00832021 24020006 16020007 24020007  
    8FA30010 3C049D00 24842544 10000008 00832021 24020007 16020006 3C029D00  
    8FA30010 3C049D00 24842558 00832021 3C029D00 8C4200BC 0040F809 00000000  
    8FBF001C 8FB00018 03E00008 27BD0020  
    'main 
    27BDFFA8 AFBF0054 AFBE0050 AFB7004C AFB60048 AFB50044 AFB40040 AFB3003C  
    AFB20038 AFB10034 AFB00030 00808021 00A08821 00C0A821 00E09821 3C02BF80  
    34038260 AC435A00 24030C00 AC435A40 3C039D00 8C640090 8084003C AC445A30  
    8C72008C 26540050 8E060000 24020001 10C20006 26570078 24020006 10C20003  
    24020007 14C20006 24020004 82250000 04A10007 00001021 1000000F 03A52821  
    14C2001A 24020007 1000FFF9 82250000 27A40010 00821821 02222021 90840000  
    A0640000 24420001 00A2182A 1060FFF9 27A40010 03A52821 24020006 14C20005  
    A0A00011 3C029D00 8C4200C4 0040F809 00000000 8E060000 24020001 10C20007  
    24020006 10C20005 24020007 10C20003 24020004 54C200CA 8E030000 82220000  
    3C039D00 8C630088 00021080 00431021 8C430000 24020065 10620003 24040007  
    0411FF63 00000000 3C02BF81 8C44F220 7C84D800 3C030661 3463A053 1083000B  
    2402002C 3C02BF81 8C43F220 7C63D800 3C020660 3442A053 00621026 2403002C  
    24040060 0082180B 00601021 3C039D00 8C630088 00431021 8C430000 24020065  
    10620084 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053  
    10A3000B 2404000B 3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026  
    2403000B 24050018 00A4180B 00602021 24050008 0040F809 00003021 3C029D00  
    8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000B 2404000B  
    3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026 2403000B 24050018  
    00A4180B 00602021 24050064 0040F809 00003021 3C029D00 8C420010 3C03BF81  
    8C65F220 7CA5D800 3C030661 3463A053 10A3000B 24040017 3C03BF81 8C64F220  
    7C84D800 3C030660 3463A053 00832026 24030017 24050006 00A4180B 00602021  
    24050002 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800  
    3C030661 3463A053 10A3000B 24040017 3C03BF81 8C64F220 7C84D800 3C030660  
    3463A053 00832026 24030017 24050006 00A4180B 00602021 24050064 0040F809  
    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053  
    10A3000B 2404000F 3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026  
    2403000F 2405001A 00A4180B 00602021 24050008 0040F809 00003021 3C029D00  
    8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000B 2404000F  
    3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026 2403000F 2405001A  
    00A4180B 00602021 24050064 0040F809 00003021 3C02BF81 8C43FA90 24040004  
    7C831804 AC43FA90 3C02BF81 8C43FB60 7C831804 AC43FB60 3C02BF80 34038260  
    AC435A00 24030C00 AC435A40 3C029D00 8C42008C AC4000F8 02802021 0411FD1A  
    00000000 00402021 0411FEB1 00000000 8E030000 24020001 1462000A 24020002  
    02802021 27A50011 0411FDA7 00000000 00402021 0411FEA6 00000000 8E030000  
    24020002 54620022 8E030000 8EA50000 04A00006 02802021 0411FA82 00000000  
    00402021 0411FE9A 00000000 8E660000 28C20100 1040000B 02802021 26250001  
    27A70020 0411FAD5 00000000 00402021 0411FE8F 00000000 8FA20020 10000008  
    A2220000 02202821 27A70020 0411FACB 00000000 00402021 0411FE85 00000000  
    8FA30020 8FA20068 AC430000 8E030000 24020003 5462007B 8E030000 8EA20000  
    04410005 3C029D00 8C42008C 8C4200F8 AEA20000 3C029D00 8C42008C 8C4400F8  
    8E630000 00831821 AC4300F8 8EB60000 241EFE00 02DEF024 02802021 03C02821  
    0411FA50 00000000 00402021 0411FE68 00000000 8E660000 28C20100 02221021  
    AFA2002C 8EA20000 105E004C 32D601FF AFB60028 3C029D00 8C420040 0040F809  
    24040200 0040B021 02802021 00402821 24060200 27A70020 0411FA98 00000000  
    00402021 0411FE52 00000000 02802021 03C02821 0411FA33 00000000 00402021  
    0411FE4B 00000000 8E650000 8FA20028 00452821 2CA20201 14400003 0000F021  
    24BEFE00 24050200 8FA30028 0065102A 10400009 8FA3002C 8FA40028 02C41021  
    02C52821 90640000 A0440000 24420001 1445FFFC 24630001 02802021 02C02821  
    8FA60020 27A70020 0411FBCB 00000000 00402021 0411FE2E 00000000 13C0000D  
    02802021 8E650000 00BE2823 8FA2002C 00452821 03C03021 27A70020 0411FBBE  
    00000000 00402021 0411FE21 00000000 02802021 00002821 00003021 27A70020  
    0411FBB5 00000000 00402021 0411FE18 00000000 10000013 8E030000 02802021  
    8FA5002C 27A70020 0411FBAB 00000000 00402021 0411FE0E 00000000 02802021  
    00002821 00003021 27A70020 0411FBA2 00000000 00402021 0411FE05 00000000  
    8E030000 24020004 5462000A 8E030000 02802021 02E02821 27A60010 0411FD2C  
    00000000 00402021 0411FDF9 00000000 8E030000 24020005 5462003C 8E030000  
    265200A0 02802021 02E02821 02403021 0411FDBD 00000000 00402021 0411FDEC  
    00000000 92430008 24020016 5462000A 82420009 02802021 02E02821 02403021  
    0411FDB1 00000000 00402021 0411FDE0 00000000 82420009 50400023 A2200000  
    92420008 30420010 54400006 2402003C 24130001 02331821 00001021 1000000C  
    2405000C A2220001 24020044 A2220002 24020069 A2220003 24020072 A2220004  
    2402003E A2220005 1000FFF2 24130006 02422021 90840009 A0640000 24420001  
    1445FFFB 24630001 2402000C AFA20020 26440009 0411F7C0 00000000 2673FFFF  
    02629821 A2330000 8E030000 24020006 5462003E 8E030000 3C029D00 8C420040  
    0040F809 3404C800 0040B821 02802021 27A50011 0411FCAC 00000000 00402021  
    0411FDAB 00000000 02802021 00002821 0411F98C 00000000 00402021 0411FDA4  
    00000000 02E09021 0000B021 24130001 02802021 02402821 24060080 27A70020  
    0411F9DE 00000000 00402021 0411FD98 00000000 8FA30020 1860000E 00001021  
    02421821 80630000 54600006 24420001 52600004 24420001 AFA20020 00009821  
    24420001 8FA30020 0043202A 5480FFF5 02421821 24020080 14620003 02C3B021  
    1000FFE3 26520080 02F6B021 A2C00000 A2C00001 3C029D00 8C4200B8 02E02021  
    0040F809 00002821 8E030000 24020007 5462004D 8E020000 02802021 27A50011  
    0411FC71 00000000 00402021 0411FD70 00000000 02802021 00002821 0411F951  
    00000000 00402021 0411FD69 00000000 3C129D00 8E420040 0040F809 24040100  
    00409821 8E5600C0 24120001 3C179D00 1000001D 241E000D 1452FFFF 02602021  
    8EE200C8 0040F809 02C02821 0040B021 02602021 0411F758 00000000 02621821  
    A07E0000 2404000A A0640001 02802021 02602821 24460002 27A70020 0411FAE6  
    00000000 00402021 0411FD49 00000000 82C20000 14400005 00000000 82C20001  
    50400005 A2600000 82C20000 1440FFE2 00000000 A2600000 A2600001 02802021  
    02602821 24060002 27A70020 0411FAD2 00000000 00402021 0411FD35 00000000  
    02802021 00002821 00003021 27A70020 0411FAC9 00000000 00402021 0411FD2C  
    00000000 8E020000 1440002E 3C029D00 8C420090 92230000 12A00006 A0430030  
    3C029D00 8C420090 8EA30000 10000005 A043003C 3C029D00 8C420090 24030002  
    A043003C 82220000 3C039D00 8C630088 00021080 00431021 8C430000 24020065  
    1062000D 3C109D00 8E030090 8E020010 80640030 24050008 0040F809 00003021  
    8E030090 8E020010 80640030 24050065 0040F809 00003021 3C109D00 8E030090  
    8E02001C 80640030 0040F809 2405FFFD 8E030090 8E02001C 80640030 0040F809  
    24050006 8FBF0054 8FBE0050 8FB7004C 8FB60048 8FB50044 8FB40040 8FB3003C  
    8FB20038 8FB10034 8FB00030 03E00008 27BD0058  
    '.rodata 
    'err0 
    6E6B6E55 206E776F 6F727265 000A0D72  
    'err1 
    6B736944 72724520 0A0D726F 00000000  
    'err2 
    20746F4E 64616552 000A0D79  
    'err3 
    46206F4E 0D656C69 0000000A 20746F4E 6E65704F 0A0D6465 00000000 20746F4E  
    62616E45 0D64656C 0000000A 46206F4E 20656C69 74737953 0A0D6D65 00000000  
    20746F4E 6E756F6D 0D646574 0000000A  
End CSub 

CFunction ILI9341_MX170
    0000045E
    'spi_write_data
    27BDFFE0 AFBF001C AFB10018 AFB00014 309100FF 3C109D00 8E030090 8E02001C 
    8064002C 0040F809 24050006 8E030090 8E02001C 8064002D 0040F809 24050005 
    3C02BF80 AC515820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C425820 
    3C029D00 8C430090 8C42001C 8064002D 0040F809 24050006 8FBF001C 8FB10018 
    8FB00014 03E00008 27BD0020 
    'spi_write_command
    27BDFFE0 AFBF001C AFB10018 AFB00014 309100FF 3C109D00 8E030090 8E02001C 
    8064002C 0040F809 24050005 8E030090 8E02001C 8064002D 0040F809 24050005 
    3C02BF80 AC515820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C425820 
    3C029D00 8C430090 8C42001C 8064002D 0040F809 24050006 8FBF001C 8FB10018 
    8FB00014 03E00008 27BD0020 
    'spi_write_cd
    27BDFFD8 AFBF0024 AFB10020 AFB0001C AFA60030 AFA70034 00A08821 27A20030 
    AFA20010 308400FF 0411FFD2 00000000 1A20000A 00008021 8FA20010 24430004 
    AFA30010 90440000 0411FFA7 00000000 26100001 1611FFF9 8FA20010 8FBF0024 
    8FB10020 8FB0001C 03E00008 27BD0028 
    'DefineRegion
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 00A09021 
    00C08821 00E09821 3C029D00 8C430090 8C42001C 8064002C 0040F809 24050005 
    2403002A 3C02BF80 AC435820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 
    8C425820 3C029D00 8C430090 8C42001C 8064002C 0040F809 24050006 3C03BF80 
    8C625810 30420002 1440FFFD 3C02BF80 00101A03 AC435820 3C03BF80 8C625810 
    30420002 1440FFFD 3C02BF80 AC505820 3C03BF80 8C625810 30420002 1440FFFD 
    3C02BF80 00111A03 AC435820 AC515820 3C03BF80 8C625810 30420080 1040FFFD 
    3C10BF80 8E025820 3C029D00 8C430090 8C42001C 8064002C 0040F809 24050005 
    2402002B AE025820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C425820 
    3C029D00 8C430090 8C42001C 8064002C 0040F809 24050006 3C03BF80 8C625810 
    30420002 1440FFFD 3C02BF80 00121A03 AC435820 3C03BF80 8C625810 30420002 
    1440FFFD 3C02BF80 AC525820 3C03BF80 8C625810 30420002 1440FFFD 3C02BF80 
    00131A03 AC435820 AC535820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 
    8C425820 3C029D00 8C430090 8C42001C 8064002C 0040F809 24050005 8FA20038 
    1040000C 2403002E 2403002C 3C02BF80 AC435820 3C03BF80 8C625810 30420080 
    1040FFFD 3C02BF80 8C425820 1000000A 3C029D00 3C02BF80 AC435820 3C03BF80 
    8C625810 30420080 1040FFFD 3C02BF80 8C425820 3C029D00 8C430090 8C42001C 
    8064002C 0040F809 24050006 8FBF0024 8FB30020 8FB2001C 8FB10018 8FB00014 
    03E00008 27BD0028 
    'ReadRectangle
    27BDFFD8 AFBF0024 AFB10020 AFB0001C 8FB10038 24020001 00458023 02078021 
    00441023 00461021 72028002 AFA00010 0411FF61 00000000 3C02BF80 AC405830 
    AC405820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C435820 8C425810 
    30420020 14400006 3C02BF80 8C435820 8C435810 30630020 1060FFFC 00000000 
    1200001A 2610FFFF 8FA4003C 00912021 02002821 3C03BF80 AC605820 AC605820 
    AC605820 8C625810 30420080 1040FFFD 00000000 8C625820 A0820000 8C625820 
    A0820001 8C625820 A0820002 10A00003 24840003 1000FFF0 24A5FFFF 26310003 
    00101040 00508021 02308821 3C109D00 8E030090 8E02001C 8064002C 0040F809 
    24050005 8E030090 8E02001C 8064002D 0040F809 24050006 3C02BF80 AC405830 
    8E030090 8E02001C 8064002D 0040F809 24050005 02201021 8FBF0024 8FB10020 
    8FB0001C 03E00008 27BD0028 
    'RestoreRectangle
    27BDFFD8 AFBF0024 AFB10020 AFB0001C 8FB10038 24020001 00458023 02078021 
    00441823 00661821 72038002 AFA20010 0411FF0E 00000000 1200001F 2610FFFF 
    8FA4003C 00912021 02003021 3C02BF80 8C435810 30630002 1460FFFD 00802821 
    80830000 AC435820 8C435810 30630002 1460FFFD 00000000 80A30001 AC435820 
    8C435810 30630002 1460FFFD 00000000 80A30002 AC435820 10C00003 24840003 
    1000FFEB 24C6FFFF 26310003 00101040 00508021 02308821 3C03BF80 8C625810 
    30420080 1040FFFD 3C02BF80 8C425810 30420020 14400006 3C02BF80 8C435820 
    8C435810 30630020 1060FFFC 00000000 24030040 3C02BF80 AC435814 02201021 
    8FBF0024 8FB10020 8FB0001C 03E00008 27BD0028 
    'DrawBitmapSPI
    27BDFFA0 AFBF005C AFBE0058 AFB70054 AFB60050 AFB5004C AFB40048 AFB30044 
    AFB20040 AFB1003C AFB00038 AFA40060 AFA50064 00C0F021 AFA7006C 8FB30074 
    8FB00078 3C02BF80 8C435830 AFA30028 8C445800 AFA4002C 8C455840 AFA50030 
    AC405800 3C030001 34638260 AC435800 AC405830 24030C00 AC435840 3C119D00 
    8E230090 8E22001C 8064002D 0040F809 24050005 8FA30064 28620000 0002180B 
    AFA30020 8FA40060 28820000 0002200B AFA40024 8FA50060 24A2FFFF 8FA30070 
    707E2002 00821821 AFA30018 8E220094 8C420000 0062182B 2442FFFF 8FA50018 
    0043280A AFA50018 8FA30020 2462FFFF 8FA30070 8FA4006C 70642802 00A21821 
    AFA3001C 3C029D00 8C420098 8C420000 0062182B 2442FFFF 8FA4001C 0043200A 
    AFA4001C 24020001 16020015 0000A021 24040003 73C42002 8FA2006C 70822002 
    8FA20070 70822002 3C029D00 8C42003C 8FA30070 0040F809 70832002 0040A021 
    AFA00010 AFA20014 8FA40024 8FA50020 8FA60018 8FA7001C 0411FF09 00000000 
    7E713C00 7E723A00 327300FF 7E153C00 7E163A00 321700FF 24020001 AFA20010 
    8FA40024 8FA50020 8FA60018 8FA7001C 0411FE69 00000000 001E2023 AFA40020 
    8FA2006C 705EC802 2739FFFF AFBE0024 8FAF0064 00006821 00003821 AFA0001C 
    8FAE0070 3C069D00 240C0001 3C02BF80 10000073 8FB8007C 25EF0001 25E3FFFF 
    04600066 8FA30018 8CC30098 8C630000 006F182B 14600096 8FBF005C 1FC0004F 
    03205021 1000005D 8FA30018 24630001 2464FFFF 04800042 00000000 8CC40094 
    8C840000 0083202B 1480003D 00000000 91240000 00882024 10800012 00000000 
    8C445810 30840002 1480FFFD 00000000 AC515820 8C445810 30840002 1480FFFD 
    00000000 AC525820 8C445810 30840002 1480FFFD 00000000 AC535820 10000028 
    24E70003 160C0017 00000000 8C445810 30840002 1480FFFD 02872021 80840000 
    AC445820 24E70001 8C445810 30840002 1480FFFD 02872021 80840000 AC445820 
    24E70001 8C445810 30840002 1480FFFD 02872021 80840000 AC445820 10000010 
    24E70001 8C445810 30840002 1480FFFD 00000000 AC555820 8C445810 30840002 
    1480FFFD 00000000 AC565820 8C445810 30840002 1480FFFD 00000000 AC575820 
    5465FFBB 24630001 256B0001 157E0005 254AFFFF 10000011 8FA30018 8FA30060 
    00005821 016D2021 24850007 28890000 00A9200B 000448C3 03094821 000A27C3 
    00042742 01444021 31080007 01044023 010C4004 1000FFA5 006E2821 55E3FF97 
    25EF0001 8FA4001C 24840001 AFA4001C 8FA50020 0325C821 8FA30024 01A36821 
    8FA4001C 8FA5006C 0085182A 10600005 8FA30070 1860FFF3 01E32021 1000FF86 
    AFA40018 3C02BF80 8C435810 30630080 1060FFFD 00000000 10000002 3C02BF80 
    8C435820 8C435810 30630020 1060FFFC 00000000 3C02BF80 AC405800 24040040 
    3C03BF80 AC645814 8FA50028 AC455830 8FA3002C AC435800 8FA40030 AC445840 
    12800004 3C029D00 8C420044 0040F809 02802021 3C029D00 8C430090 8C42001C 
    8064002D 0040F809 24050006 8FBF005C 8FBE0058 8FB70054 8FB60050 8FB5004C 
    8FB40048 8FB30044 8FB20040 8FB1003C 8FB00038 03E00008 27BD0060 
    'DrawRectangleSPI
    27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C 
    AFB20028 AFB10024 AFB00020 00808021 00A09021 00C08821 00E0A021 8FB70058 
    3C02BF80 8C5E5830 8C435800 AFA30018 8C435840 AFA3001C AC405800 3C030001 
    34638260 AC435800 AC405830 24030C00 AC435840 3C029D00 8C430090 8C42001C 
    8064002D 0040F809 24050005 0211102A 14400005 0254102A 02001021 02208021 
    00408821 0254102A 14400004 2A160000 02401021 02809021 0040A021 0016800B 
    0200B021 3C029D00 8C420094 8C420000 0202202B 2443FFFF 0064B00A 2A350000 
    0015880B 0220A821 0222182B 2442FFFF 0043A80A 2A530000 0013900B 02409821 
    3C029D00 8C420098 8C420000 0242202B 2443FFFF 0064980A 2A830000 0003A00B 
    0282182B 2442FFFF 0043A00A 7EF23C00 7EF13A00 32F000FF 24170001 AFB70010 
    02C02021 02602821 02A03021 02803821 0411FD5A 00000000 02F32023 00942021 
    02F6B023 02D5A821 70952002 10800013 2484FFFF 3C02BF80 8C435810 30630002 
    1460FFFD 00000000 AC525820 8C435810 30630002 1460FFFD 00000000 AC515820 
    8C435810 30630002 1460FFFD 00000000 AC505820 1480FFF0 2484FFFF 3C03BF80 
    8C625810 30420080 1040FFFD 3C02BF80 8C425810 30420020 14400006 3C02BF80 
    8C435820 8C435810 30630020 1060FFFC 00000000 3C02BF80 AC405800 24040040 
    3C03BF80 AC645814 AC5E5830 8FA30018 AC435800 8FA3001C AC435840 3C029D00 
    8C430090 8C42001C 8064002D 0040F809 24050006 8FBF0044 8FBE0040 8FB7003C 
    8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 8FB10024 8FB00020 03E00008 
    27BD0048 
    'triangles
    27BDFFA8 AFBF0054 AFBE0050 AFB7004C AFB60048 AFB50044 AFB40040 AFB3003C 
    AFB20038 AFB10034 AFB00030 00809021 00A09821 AFA60060 AFA70064 8FB10068 
    8FBE006C 8FB70070 8FA30074 007E102A 10400008 8FB6007C 03C01021 0060F021 
    AFA20074 02201021 02E08821 0040B821 8FA30074 02C3102A 10400008 007E102A 
    AFB60074 0060B021 02E01021 8FB70078 AFA20078 8FA30074 007E102A 10400006 
    03C01021 0060F021 AFA20074 02201021 02E08821 0040B821 17D60035 8FA30074 
    02F1102A 14400006 02203821 0237102A 10400005 8FA30078 10000002 02E03821 
    02E08821 8FA30078 0071102A 54400003 8FB10078 00E3102A 0062380B 1640000D 
    24020001 00FE3821 AFB30010 8FA20060 AFA20014 02202021 03C02821 02203021 
    00F13823 0411FD5E 00000000 1000009E 00409821 1642000C 00FE3821 AFB30010 
    8FA30060 AFA30014 02202021 03C02821 02203021 00F13823 0411FDA4 00000000 
    10000091 00409821 8FA20064 AFA20010 02202021 03C02821 02203021 00F13823 
    0411FF06 00000000 10000088 02601021 00761026 0002102B 00621023 AFA20020 
    005E102A 14400040 03C08021 02F11023 AFA20024 8FA30078 00711823 AFA30028 
    0000A021 0000A821 8FA20074 005E1023 AFA20018 02DE1823 AFA3001C 8FA30018 
    02A3001A 006001F4 00002012 00912021 8FA3001C 0283001A 006001F4 00003012 
    00D13021 00C4102A 10400003 00801021 00C02021 00403021 1640000A 24030001 
    AFB30010 8FA20060 AFA20014 02002821 02003821 0411FD1A 00000000 10000011 
    00409821 1643000A 8FA30064 AFB30010 8FA20060 AFA20014 02002821 02003821 
    0411FD62 00000000 10000006 00409821 AFA30010 02002821 02003821 0411FEC7 
    00000000 26100001 8FA20024 02A2A821 8FA30028 0283A021 8FA30020 0070102A 
    1040FFCF 8FA30018 02D0102A 1440003E 8FA20078 00571023 AFA2001C 8FA30074 
    0203A023 7054A002 8FA20078 00511023 AFA20020 021EA823 7055A802 02C31023 
    AFA20018 02DEF023 8FA30018 0283001A 006001F4 00002012 00972021 02BE001A 
    03C001F4 00003012 00D13021 00C4102A 10400003 00801021 00C02021 00403021 
    1640000A 24030001 AFB30010 8FA20060 AFA20014 02002821 02003821 0411FCD8 
    00000000 10000011 00409821 1643000A 8FA30064 AFB30010 8FA20060 AFA20014 
    02002821 02003821 0411FD20 00000000 10000006 00409821 AFA30010 02002821 
    02003821 0411FE85 00000000 26100001 8FA2001C 0282A021 8FA30020 02D0102A 
    1040FFD1 02A3A821 02601021 8FBF0054 8FBE0050 8FB7004C 8FB60048 8FB50044 
    8FB40040 8FB3003C 8FB20038 8FB10034 8FB00030 03E00008 27BD0058 
    'getFPC
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008 
    'pstring
    27BDFFE0 AFBF001C AFB00018 00808021 00002021 3C059D00 24A51154 27A60010 
    0411FFEF 00000000 8FA40010 3C029D00 8C42002C 0040F809 02042021 8FBF001C 
    8FB00018 03E00008 27BD0020 
    'main
    27BDFF98 AFBF0064 AFBE0060 AFB7005C AFB60058 AFB50054 AFB40050 AFB3004C 
    AFB20048 AFB10044 AFB00040 00808021 00A0A021 00C0B821 00E0A821 8FBE0080 
    00002021 3C059D00 24A511D0 27A60028 0411FFD0 00000000 3C02BF80 8C435830 
    AFA30030 8C445800 AFA40034 8C425840 AFA20038 8E020000 28420005 54400010 
    8E160000 3C02BF80 AC405800 3C030001 34638260 AC435800 AC405830 24030C00 
    AC435840 3C029D00 8C430090 8C42001C 8064002D 0040F809 24050005 8E160000 
    2EC20005 104001AD 24020005 3C029D00 8C430090 8EE40000 A064002E 8C430090 
    92840000 A064002C 8C430090 8EA40000 A064002D 8C430090 8E040000 A0640015 
    8C430090 8064002E 8C420088 00041880 00621021 8C430000 24020065 1062000B 
    3C109D00 8E020010 24050008 0040F809 00003021 8E030090 8E020010 8064002E 
    24050065 0040F809 00003021 3C109D00 8E030090 8E02001C 8064002E 0040F809 
    24050006 8E020090 8044002C 8E020088 00041880 00621021 8C430000 24020065 
    1062000A 24050008 8E020010 0040F809 00003021 8E030090 8E020010 8064002C 
    24050065 0040F809 00003021 3C109D00 8E030090 8E02001C 8064002C 0040F809 
    24050006 8E020090 8044002D 8E020088 00041880 00621021 8C430000 24020065 
    1062000A 24050008 8E020010 0040F809 00003021 8E030090 8E020010 8064002D 
    24050065 0040F809 00003021 3C029D00 8C430090 8C42001C 8064002D 0040F809 
    24050006 3C02BF81 8C44F220 7C84D800 3C030661 3463A053 1083000B 24020050 
    3C02BF81 8C43F220 7C63D800 3C020660 3442A053 00621026 24030050 2404000C 
    0082180B 00601021 3C039D00 8C630088 00431021 8C430000 24020065 1062007E 
    3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000A 
    24040014 3C03BF81 8C65F220 7CA5D800 3C030660 3463A053 00A32826 24030014 
    24040003 0065200A 24050008 0040F809 00003021 3C029D00 8C420010 3C03BF81 
    8C65F220 7CA5D800 3C030661 3463A053 10A3000A 24040014 3C03BF81 8C65F220 
    7CA5D800 3C030660 3463A053 00A32826 24030014 24040003 0065200A 24050065 
    0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 
    3463A053 10A3000A 24040029 3C03BF81 8C65F220 7CA5D800 3C030660 3463A053 
    00A32826 24030029 2404000E 0065200A 24050002 0040F809 00003021 3C029D00 
    8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000A 24040029 
    3C03BF81 8C65F220 7CA5D800 3C030660 3463A053 00A32826 24030029 2404000E 
    0065200A 24050065 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 
    7CA5D800 3C030661 3463A053 10A3000A 2404000E 3C03BF81 8C65F220 7CA5D800 
    3C030660 3463A053 00A32826 2403000E 24040019 0065200A 24050008 0040F809 
    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 
    10A3000A 2404000E 3C03BF81 8C65F220 7CA5D800 3C030660 3463A053 00A32826 
    2403000E 24040019 0065200A 24050065 0040F809 00003021 3C02BF81 8C43FA84 
    24110001 7E231804 AC43FA84 3C02BF81 8C43FB04 24040003 7C831804 AC43FB04 
    3C02BF80 24030060 AC435800 3C120001 36528260 AC525800 AC515830 24030C00 
    AC435840 3C109D00 8E030090 8E02001C 8064002E 0040F809 24050006 8E020004 
    0040F809 24042710 8E030090 8E02001C 8064002E 0040F809 24050005 8E020004 
    0040F809 24042710 8E030090 8E02001C 8064002E 0040F809 24050006 8E020004 
    0040F809 24042710 24040028 0411FA79 00000000 240400C0 24050001 24060023 
    0411FA97 00000000 240400C1 24050001 24060010 0411FA92 00000000 240400C5 
    24050002 2406002B 2407002B 0411FA8C 00000000 240400C7 24050001 240600C0 
    0411FA87 00000000 2404003A 24050001 24060066 0411FA82 00000000 240400B1 
    24050002 00003021 2407001B 0411FA7C 00000000 240400B7 24050001 24060007 
    0411FA77 00000000 24040011 24050001 00003021 0411FA72 00000000 8E020004 
    0040F809 3404C350 24040013 0411FA49 00000000 24040029 0411FA46 00000000 
    8E020004 0040F809 26440440 8E020090 80420015 14510007 3C029D00 24040036 
    24050001 24060028 0411FA5D 00000000 3C029D00 8C420090 80430015 24020002 
    14620007 3C029D00 24040036 24050001 24060048 0411FA52 00000000 3C029D00 
    8C420090 80430015 24020003 14620007 3C029D00 24040036 24050001 240600E8 
    0411FA47 00000000 3C029D00 8C420090 80430015 24020004 14620007 3C029D00 
    24040036 24050001 24060088 0411FA3C 00000000 3C029D00 8C420090 90420015 
    30420001 10400008 3C029D00 8C430098 240400F0 AC640000 8C420094 24030140 
    10000007 AC430000 8C430094 240400F0 AC640000 8C420098 24030140 AC430000 
    8FA50028 3C029D00 8C430048 3C049D00 24840ACC 00852021 AC640000 8FA50028 
    8C43004C 3C049D00 24840630 00852021 AC640000 8C430048 8C440094 8C860000 
    8C420098 8C470000 AFA00010 8C620000 00002021 00002821 24C6FFFF 0040F809 
    24E7FFFF 3C049D00 24841E10 0411FE11 00000000 10000116 00008021 16C20029 
    24020006 92910000 12E00004 24100001 8EF10000 2631FFFF 00008021 3C029D00 
    8C430090 8C42001C 8064002C 0040F809 24050006 0230102A 14400105 0290A021 
    3C02BF80 8C435810 30630002 1460FFFD 02802021 92830000 AC435820 8C435810 
    30630002 1460FFFD 00000000 90830001 AC435820 8C435810 30630002 1460FFFD 
    00000000 90830002 AC435820 26100003 0230182A 1060FFEB 26940003 100000ED 
    3C03BF80 16C20012 24020007 8EE40000 8EA50000 2486FFFF 8FA80078 8D030000 
    24A7FFFF 8FA8007C 8D020000 8FC80000 AFA80010 AFB40014 00C33021 00E23821 
    0411FA7D 00000000 100000D9 00408021 16C20012 24020008 8EE40000 8EA50000 
    2486FFFF 8FA20078 8C430000 24A7FFFF 8FA8007C 8D020000 8FC80000 AFA80010 
    AFB40014 00C33021 00E23821 0411FABD 00000000 100000C6 00408021 16C20011 
    24020009 8EE40000 8EA50000 2486FFFF 8FA20078 8C430000 24A7FFFF 8FA8007C 
    8D020000 92880000 AFA80010 00C33021 00E23821 0411F9C6 00000000 100000B4 
    24100008 56C20019 32D6007F 8EE70000 8EA20000 AFA20010 8FA30078 8C620000 
    AFA20014 8FA4007C 8C820000 AFA20018 8FC20000 AFA2001C 8FA80084 8D020000 
    AFA20020 8FA30088 8C620000 AFA20024 24040002 00002821 00003021 0411FC96 
    00000000 1000009A 24100009 1AC0002B 00008821 8EE30004 04600004 8EE70000 
    00008821 100000BF 00001021 02E09021 00001021 00008021 00008821 02A21821 
    8C630000 AFA30010 8FA40078 00821821 8C630000 AFA30014 8FA8007C 01021821 
    8C630000 AFA30018 03C21821 8C630000 AFA3001C 8FA40084 00821821 8C630000 
    AFA30020 8FA80088 01021021 8C420000 AFA20024 24040001 02002821 02803021 
    0411FC6D 00000000 26310001 16360005 00408021 10000030 0236102A 1000002D 
    00008021 001110C0 8E470008 8E43000C 0460FFDA 26520008 02E21821 8C670000 
    8C630004 04630090 26330001 10000022 0236102A 02A21821 8C630000 AFA30010 
    8FA40078 00821821 8C630000 AFA30014 8FA8007C 01021821 8C630000 AFA30018 
    03C21821 8C630000 AFA3001C 8FA40084 00821821 8C630000 AFA30020 8FA80088 
    01021021 8C420000 AFA20024 00002021 02002821 02803021 0411FC3F 00000000 
    00408021 26520001 0256102A 1440000C 02F31021 0236102A 1040003D 001110C0 
    02E21821 8C670000 8C630004 04600038 26330001 001398C0 1000000A 3C129D00 
    8C470000 8C430004 0460FFF2 26640008 02511026 0002800A 02601021 1000FFCD 
    00809821 02A21821 8C630000 AFA30010 8FA40078 00821821 8C630000 AFA30014 
    8FA8007C 01021821 8C630000 AFA30018 03C21821 8C630000 AFA3001C 8FA40084 
    00821821 8C630000 AFA30020 8FA80088 01021021 8C420000 AFA20024 24040002 
    02002821 02803021 0411FC0B 00000000 00408021 8E430090 8E42001C 8064002D 
    0040F809 24050005 26310001 12360008 02F31021 8C470000 8C430004 04600004 
    26640008 02601021 1000FFD6 00809821 3C03BF80 8C625810 30420080 1040FFFD 
    3C02BF80 8C425810 30420020 14400006 3C02BF80 8C435820 8C435810 30630020 
    1060FFFC 00000000 3C02BF80 AC405800 24040040 3C03BF80 AC645814 8FA30030 
    AC435830 8FA40034 AC445800 8FA80038 AC485840 3C029D00 8C430090 8C42001C 
    8064002D 0040F809 24050006 02001021 00001821 8FBF0064 8FBE0060 8FB7005C 
    8FB60058 8FB50054 8FB40050 8FB3004C 8FB20048 8FB10044 8FB00040 03E00008 
    27BD0068 26330001 001398C0 02209021 1000FF70 00008021 
    '.rodata
    'startup
    39494C49 20313433 76697264 6C207265 6564616F 000A0D64 
End CFunction
