option explicit
option default none
'
const RD=6 ' pin connected to RD on the SSD1963 Explore100
'
' define the size and number of sprites that can be active
' NB all sprites must be the same size as coded here but this could be generalised further
'
const maxsprites=7 ' must be 2^n-1
const spritewidth=16
const spriteheight=16
'
const SpriteBytes = spriteheight * spritewidth * 3
const spritearraysize = SpriteBytes * 2 \ 8
const spritesaveoffset = spritearraysize \ 2
const forread=1
const forwrite=0
'
dim sprite%(spritearraysize,maxsprites) 'holding buffer for sprites + screen memory overwritten by sprites
DIM collision%, i%
'
pin(RD)=1
setpin RD,DOUT
cls
'
if readSSDid(RD)<>&H157 then 'check we can read the chip ID
  Print "Unable to read from SSD1963, check wiring of RD"
  end
endif
'
displaybackground "tiger-3.ppm",0,0
loadsprite 1,"pac_man.ppm"
loadsprite 2,"blinky.ppm"
loadsprite 3,"blinky.ppm"
'
collision% = ShowSprite(1,200,140)
if collision% then print "Program Bug"
collision% = ShowSprite(1,400,140) 'should get a report that it is already displayed
if collision%<>-1 then print "Program Bug"
collision% = ShowSprite(2,220,140)
if collision% then print "Program Bug"
collision% = ShowSprite(3,210,140)
If collision% then
  for i%=1 to maxsprites
    if (collision%>>i%) and 1 then print "collision with sprite number ",i%
  next i%
endif
pause 4000
if RemoveSprite(1) then print "Program Bug"
IF RemoveSprite(2) then print "Program Bug"
IF RemoveSprite(3)<>-1 then print "Program Bug" 'should get a report that it is not displayed
end

function ShowSprite(spritenum%, x%, y%) as integer
  local integer i
  if sprite%(spritearraysize,spritenum%)=-1 then
    defineregionSSD x%, y%, spritewidth, spriteheight, forread
    readbufferssd sprite%(spritesaveoffset,spritenum%), SpriteBytes, RD
    i=CheckCollision(sprite%(spritesaveoffset,spritenum%), SpriteBytes, maxsprites)
    if i then
      ShowSprite=i
    else
      defineregionSSD x%,y%, spritewidth, spriteheight, forwrite
      DisplaySpriteSSD sprite%(0,spritenum%),SpriteBytes, spritenum%
      sprite%(spritearraysize,spritenum%)=(x% << 32) OR y%
      ShowSprite=0
    endif
  else
    print "Error: Sprite ", spritenum%, " is already displayed"
    ShowSprite=-1
  endif
end function
'
function RemoveSprite(spritenum%) as integer
  local integer x%, y%
  if sprite%(spritearraysize,spritenum%)<>-1 then  
    x%=sprite%(spritearraysize,spritenum%)>>32
    y%=sprite%(spritearraysize,spritenum%) and &HFFFFFFFF
    defineregionSSD x%, y%, spritewidth, spriteheight ,forwrite
    DisplayBufferSSD sprite%(spritesaveoffset,spritenum%),SpriteBytes
    RemoveSprite=0
  else
    print "Error: Sprite ", spritenum%, " is not currently displayed"
    RemoveSprite=-1
  endif
end function
'
' subroutine to read a sprite stored as an binary .ppm file into a array
' parameters are:
'   sprite number
'   string containing the filename
'
Sub loadsprite(spritenum%, PIC$) 
  LOCAL Buffer$
  LOCAL numBytes%, a%, x%, y%, chpos%=0    
  open pic$ for random as #1
  seek #1,1
  'Read the first 128 bytes   
  buffer$=input$(128,#1)
  a%=instr(buffer$,chr$(10)) ' look for the first CR   
  if left$(buffer$,a%-1)="P6" then    
    buffer$=right$(buffer$,len(buffer$)-a%) 
    if left$(buffer$,1)="#" then  
      a%=instr(buffer$,chr$(10)) ' look for the second CR   
      buffer$=right$(buffer$,len(buffer$)-a%)   
    endif
    a%=instr(buffer$,chr$(32)) ' look for the space between dimensions   
    x%=val(left$(buffer$,a%-1))   
    buffer$=right$(buffer$,len(buffer$)-a%)   
    a%=instr(buffer$,chr$(10)) ' look for the third CR   
    y%=val(left$(buffer$,a%-1))  
    if x%<>spritewidth and y%<>spriteheight then
      Print "Incorrect sprite size"
      close #1
      end
    endif
    numbytes%=x%*y%*3 
    buffer$=right$(buffer$,len(buffer$)-a%)   
    a%=instr(buffer$,chr$(10)) ' look for the fourth CR   
    buffer$=right$(buffer$,len(buffer$)-a%)   
    setbottombits(buffer$, maxsprites, spritenum%)
    chpos%=packbytes(buffer$,chpos%,sprite%(0,spritenum%)) 
    numbytes%=numbytes%-len(buffer$)
    do while numbytes%>255  
      buffer$=input$(255,#1)
      setbottombits(buffer$, maxsprites, spritenum%) 
      chpos%=packbytes(buffer$,chpos%,sprite%(0,spritenum%)) 
      numbytes%=numbytes%-255
    loop
    buffer$=input$(numbytes%,#1)
    setbottombits(buffer$, maxsprites, spritenum%)
    chpos%=packbytes(buffer$,chpos%,sprite%(0,spritenum%)) 
    sprite%(spritearraysize,spritenum%)=-1 'set sprite not visible
  else   
     Print "Invalid File Format"   
  endif
  close #1  
  end sub

Sub Displaybackground(PIC$, StartX%, StartY%)   
  LOCAL Buffer$,addbuffer$ length 3   
  LOCAL Result%=-1   
  LOCAL numBytes%,a%
  open pic$ for random as #1
  seek #1,1
  'Read the first 128 bytes   
  buffer$=input$(128,#1)
  a%=instr(buffer$,chr$(10)) ' look for the first CR   
  if left$(buffer$,a%-1)="P6" then    
    buffer$=right$(buffer$,len(buffer$)-a%) 
    if left$(buffer$,1)="#" then  
      a%=instr(buffer$,chr$(10)) ' look for the second CR   
      buffer$=right$(buffer$,len(buffer$)-a%)   
    endif
    a%=instr(buffer$,chr$(32)) ' look for the space between dimensions   
    local width%=val(left$(buffer$,a%-1))   
    buffer$=right$(buffer$,len(buffer$)-a%)   
    a%=instr(buffer$,chr$(10)) ' look for the third CR   
    LOCAL height%=val(left$(buffer$,a%-1))  
    numbytes%=width%*height%*3 
    buffer$=right$(buffer$,len(buffer$)-a%)   
    a%=instr(buffer$,chr$(10)) ' look for the fourth CR   
    buffer$=right$(buffer$,len(buffer$)-a%)   
    a%=len(buffer$) mod 3   
    addBuffer$=STRING$(3-a%," ") ' we need to make sure we have a number of bytes divisible by three in the buffer   
    addbuffer$=input$( len(addbuffer$),#1) 
    buffer$=buffer$+addbuffer$ 
    clearbottombits(buffer$,maxsprites)
    numbytes%=numbytes%-len(buffer$)
    if (StartX%+width%>MM.HRES) OR (StartY%+height%>MM.VRES) then    
      print pic$," too big", width%," x",height%   
    else  
      defineregionSSD StartX%, StartY%, width%, height%, forwrite
      DisplayBufferSSD Buffer$  
      do while numbytes%>255  
        buffer$=input$(255,#1)
        clearbottombits(buffer$,maxsprites)
        DisplayBufferSSD Buffer$
        numbytes%=numbytes%-255
      loop
      buffer$=input$(numbytes%,#1)
      clearbottombits(buffer$,maxsprites)
      DisplayBufferSSD Buffer$
    endif   
  else   
     Print "Invalid File Format"   
  endif
  close #1  
end sub
'
CFunction CheckCollision
    00000000
    8CA30000 90C90000 00001021 00002821 2463FFFF 10000007 24080001 90E60000 
    24A50001 01263024 10C00002 00C83804 00471025 00A3302A 14C0FFF8 00853821 
    03E00008 00021FC3 
End CFunction
'
CFunction PackBytes
    00000000
    90820000 5840000C 8CA30000 24030001 8CA70000 00834021 91090000 00C34021 
    24630001 01074021 0043382A 10E0FFF8 A109FFFF 8CA30000 00431021 03E00008 
    00021FC3 
End CFunction
'
CSub ClearBottomBits
    00000000
    90A70000 90860000 00073827 18C00009 7C073C20 24020001 90850001 24420001 
    00C2182A 00E52824 A0850001 1060FFFA 24840001 03E00008 00000000 
End CSub
'
CSub SetBottomBits
    00000000
    90A30000 90820000 00031827 1840000C 7C031C20 24050001 90870001 24A50001 
    0045402A 00673824 A0870001 90C90000 00E93825 A0870001 1100FFF7 24840001 
    03E00008 00000000 
End CSub
'
' 64-pin routines
'
'CFunction ReadSSDid
'    00000000
'    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 3C109D00 00808821
'    8E020028 0040F809 8C840000 00409821 8E240000 8E020024 0040F809 24050006
'    00409021 8E240000 8E020024 0040F809 24050005 24030001 3C04BF88 02639804
'    24061000 24070800 240500FF 240802A1 AC866134 3C03BF81 AC886430 AC876134
'    AC876138 AC866138 AC85641C AC530000 8C66F220 8C66F220 8C66F220 8C66F220
'    AE530000 8C866420 AC530000 8C62F220 8C62F220 8C62F220 8C62F220 AE530000
'    8C836420 AC85641C 30C200FF 8FBF0024 306300FF 00021200 00431025 00021FC3
'    8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
'End CFunction
''
'CSUB ReadBufferSSD
'    00000000
'    27BDFFD0 AFBF002C AFB50028 AFB40024 AFB2001C AFB10018 AFB00014 AFB30020
'    3C149D00 00808821 8E820028 8CC40000 00C0A821 0040F809 8CB30000 8E830024
'    8EA40000 24050006 24100001 0060F809 00508004 00409021 8EA40000 8E820024
'    0040F809 24050005 3C03BF88 240400FF AC64641C 3C07BF88 00001821 00000000
'    00000000 00000000 AC500000 00000000 00000000 00000000 00000000 AE500000
'    00000000 00000000 00000000 00000000 00000000 8CE66420 02232821 24630001
'    0073202B 1480FFED A0A60000 240300FF 3C02BF88 AC43641C 8FBF002C 8FB50028
'    8FB40024 8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0030
'End CSUB
''
'CSub DisplayBufferSSD
'    00000000
'    14A00003 90880000 10000004 24050001 8CA80000 00002821 2508FFFF 00A8102A
'    10400017 00852021 3C02BF88 24030800 90870000 24A50003 00A8302A 34E71800
'    AC476430 AC436134 AC436138 90870001 34E71800 AC476430 AC436134 AC436138
'    90870002 24840003 34E71800 AC476430 AC436134 AC436138 54C0FFEE 90870000
'    03E00008 00000000
'End CSub
''
'CSub DefineRegionSSD
'    00000000
'    3C029D00 8C420090 8C830000 8CA50000 8CC40000 24081000 8CE60000 3C07BF88
'    ACE86134 80420015 24A7FFFF 2468FFFF 00E63821 24060001 10460004 01042021
'    24060003 14460005 3C029D00 00604821 00804021 10000008 00E01821 8C420094
'    00A04821 00E04021 8C420000 2442FFFF 00442823 00431823 00096202 00085A02
'    3C02BF88 24060800 24071000 00052202 00035202 35081800 358C1800 35291800
'    356B1800 240D022A AC4D6430 34841800 AC466134 34A51800 AC466138 354A1800
'    AC476138 34631800 AC4C6430 AC466134 AC466138 AC496430 AC466134 AC466138
'    AC4B6430 AC466134 AC466138 AC486430 2408022B AC466134 AC466138 AC476134
'    AC486430 AC466134 AC466138 AC476138 AC446430 AC466134 AC466138 AC456430
'    AC466134 AC466138 AC4A6430 AC466134 AC466138 AC436430 AC466134 AC466138
'    AC476134 8FA20010 8C420000 10400006 2403022C 2403022E 3C02BF88 AC436430
'    10000004 3C02BF88 3C02BF88 AC436430 3C02BF88 24030800 AC436134 AC436138
'    24031000 AC436138 03E00008 00000000
'End CSub
''
'CSub DisplaySpriteSSD
'    00000000
'    8CA20000 24080003 3C03BF88 00825021 24050800 10000033 2442FFFF 90CB0000
'    00804821 1567001F 34EC1800 908B0001 1567001C 00000000 908B0002 15670019
'    00000000 914B0000 00EB3825 34E71800 AC676430 AC656134 AC656138 90CB0000
'    91470001 01673825 30E700FF 34E71800 AC676430 AC656134 AC656138 90CB0000
'    91470002 01673825 30E700FF 34E71800 AC676430 AC656134 AC656138 1000000F
'    25080003 AC6C6430 AC656134 AC656138 91270001 34E71800 AC676430 AC656134
'    AC656138 91270002 34E71800 AC676430 AC656134 AC656138 25080003 254A0003
'    24840003 2507FFFD 00E2382A 54E0FFCB 90870000 03E00008 00000000
'End CSub
'
' 100-pin routines
'
CFunction ReadSSDid
    00000000
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 3C109D00 00808821
    8E020028 0040F809 8C840000 00409821 8E240000 8E020024 0040F809 24050006
    00409021 8E240000 8E020024 0040F809 24050005 24030001 3C04BF88 02639804
    24060100 24070200 240500FF 240802A1 AC866434 3C03BF81 AC886430 AC876434
    AC876438 AC866438 AC85641C AC530000 8C66F220 8C66F220 8C66F220 8C66F220
    AE530000 8C866420 AC530000 8C62F220 8C62F220 8C62F220 8C62F220 AE530000
    8C836420 AC85641C 30C200FF 8FBF0024 306300FF 00021200 00431025 00021FC3
    8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
End CFunction
'
CSub ReadBufferSSD
    00000000
    27BDFFD0 AFBF002C AFB50028 AFB40024 AFB2001C AFB10018 AFB00014 AFB30020
    3C149D00 00808821 8E820028 8CC40000 00C0A821 0040F809 8CB30000 8E830024
    8EA40000 24050006 24100001 0060F809 00508004 00409021 8EA40000 8E820024
    0040F809 24050005 3C03BF88 240400FF AC64641C 3C07BF88 00001821 00000000
    00000000 00000000 AC500000 00000000 00000000 00000000 00000000 AE500000
    00000000 00000000 00000000 00000000 00000000 8CE66420 02232821 24630001
    0073202B 1480FFED A0A60000 240300FF 3C02BF88 AC43641C 8FBF002C 8FB50028
    8FB40024 8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0030
End CSub
'
CSUB DisplayBufferSSD
    00000000
    14A00003 90880000 10000004 24050001 8CA80000 00002821 2508FFFF 00A8102A
    10400017 00852021 3C02BF88 24030200 90870000 24A50003 00A8302A 34E70300
    AC476430 AC436434 AC436438 90870001 34E70300 AC476430 AC436434 AC436438
    90870002 24840003 34E70300 AC476430 AC436434 AC436438 54C0FFEE 90870000
    03E00008 00000000
End CSUB
'
CSub DefineRegionSSD
    00000000
    3C029D00 8C420090 8C830000 8CA50000 8CC40000 24080100 8CE60000 3C07BF88
    ACE86434 80420015 24A7FFFF 2468FFFF 00E63821 24060001 10460004 01042021
    24060003 14460005 3C029D00 00604821 00804021 10000008 00E01821 8C420094
    00A04821 00E04021 8C420000 2442FFFF 00442823 00431823 00096202 00085A02
    3C02BF88 24060200 24070100 00052202 00035202 35080300 358C0300 35290300
    356B0300 240D022A AC4D6430 34840300 AC466434 34A50300 AC466438 354A0300
    AC476438 34630300 AC4C6430 AC466434 AC466438 AC496430 AC466434 AC466438
    AC4B6430 AC466434 AC466438 AC486430 2408022B AC466434 AC466438 AC476434
    AC486430 AC466434 AC466438 AC476438 AC446430 AC466434 AC466438 AC456430
    AC466434 AC466438 AC4A6430 AC466434 AC466438 AC436430 AC466434 AC466438
    AC476434 8FA20010 8C420000 10400006 2403022C 2403022E 3C02BF88 AC436430
    10000004 3C02BF88 3C02BF88 AC436430 3C02BF88 24030200 AC436434 AC436438
    24030100 AC436438 03E00008 00000000
End CSub
'
CSub DisplaySpriteSSD
    00000000
    8CA20000 24080003 3C03BF88 00825021 24050200 10000033 2442FFFF 90CB0000
    00804821 1567001F 34EC0300 908B0001 1567001C 00000000 908B0002 15670019
    00000000 914B0000 00EB3825 34E70300 AC676430 AC656434 AC656438 90CB0000
    91470001 01673825 30E700FF 34E70300 AC676430 AC656434 AC656438 90CB0000
    91470002 01673825 30E700FF 34E70300 AC676430 AC656434 AC656438 1000000F
    25080003 AC6C6430 AC656434 AC656438 91270001 34E70300 AC676430 AC656434
    AC656438 91270002 34E70300 AC676430 AC656434 AC656438 25080003 254A0003
    24840003 2507FFFD 00E2382A 54E0FFCB 90870000 03E00008 00000000
End CSUB
