;------------------------------------------------------------------------------
;
; Title:			ds30 Loader for PIC12F and PIC16F
;
; File description:	user init and exit code
;
; Copyright: 		Copyright  2011, Mikael Gustafsson
;                                                                             
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;    This file is part of ds30 Loader.
;
;    ds30 Loader is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation.
;
;    ds30 Loader is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with ds30 Loader. If not, see <http://www.gnu.org/licenses/>.
;------------------------------------------------------------------------------


;------------------------------------------------------------------------------
; UserInit()
; Description: this is executed immediately on start-up before the boot loader code
;------------------------------------------------------------------------------
UserInit macro 	
		ifndef DEV_MODE
			banksel OSCCON
			movlw	(1<<SPLLEN)|(1<<SPLLMULT)|(1<<IRCF3)|(1<<IRCF2)|(1<<IRCF1)|(1<<IRCF0)
			movwf	OSCCON
			banksel OSCSTAT

; Wait for the oscillator and PLL to stabilize
; NOTE: remove in a pinch? the time taken below for the CRC calculation *should* be more than the worse case here
_wosc	movlw	(1<<PLLRDY)|(1<<HFIOFR)|(1<<HFIOFS)
			andwf	OSCSTAT,w
			sublw	(1<<PLLRDY)|(1<<HFIOFR)|(1<<HFIOFS)
			bnz	_wosc

; Enable active clock tuning
			movlw	(1<<ACTEN)|(1<<ACTSRC)
			movwf	ACTCON
			; Make uart pins digital
			ifdef	ANSEL				
				error Do you need to configura uart pins to be digital? If not, remove this line
				;banksel ANSEL
			endif
			ifdef	ANSELA
;				error Do you need to configura uart pins to be digital? If not, remove this line
				banksel ANSELA
				clrf 	ANSELA
				banksel ANSELC
				clrf 	ANSELC
			endif
		endif ;DEV_MODE
		endm
		
		
;------------------------------------------------------------------------------
; UserExit()
; Description: this is executed right before the user application is loadaed
;------------------------------------------------------------------------------
UserExit macro
		
		endm
		

;------------------------------------------------------------------------------
; End of file
;------------------------------------------------------------------------------	
