Option explicit
option default NONE
'
const pgd=26 'Pin on Micromite to PIC16F1455 pin 10
const pgc=25 'Pin on Micromite to PIC16F1455 pin 9
'
' Program to upload V1.17 of the USB/UART/Pic32prog application to a PIC16F1454 or PIC16F1455
' load this file to the Micromite
' Version 1.02 Includes Full verify
' Version 1.03 Verify/Print Device type
'
' PIC16F1454/5 connections
' Connect GND to pin 14
' Connect 3.3V to pins 1 and 11
' Connect PGD and PGC to the Micromite using the pins defined above
' Connect a 10K resistor between GND and pin 4
' Make sure there are no other connections to the PIC16F1455
' Connect the negative terminal of a 9V PP3 Battery to GND (MN1604, PP3-HP, 006P, 6LR61, 6LF22, 6LF62)
' Have a wire on the positive terminal that you can connect to pin 4 of the PIC16F1455 when requested by the program,
' a simple SPST latching switch is ideal for this
' Type run
' Follow the instructions
'
' ICSP programming commands
const LoadConfiguration=0
const LoadDataForProgramMemory=2
const ReadDataFromProgramMemory=4
const IncrementAddress=6
const ResetAddress=&H16
const BeginInternallyTimedProgramming=8
const BeginExternallyTimedProgramming=&H18
const EndExternallyTimedProgramming=&H0A
const BulkEraseProgramMemory=9
const RowEraseProgramMemory=&H11
' ICSP programming wait times
const TPINTP=3
const TPINTC=5
const TERAB=5
const config1 = &H0F8C
const config2 = &H1FCF

' Initialisation
dim integer j,k,n=0,r,t,DEVID
dim s$,l1$,L2$,devname$
pin(pgd)=0
pin(pgc)=0
setpin pgd,dout
setpin pgc,dout
'
' Main program
input "Connect a PP3 battery between GND and pin 4 on the PIC16F1455: Press return to continue",s$
timer=0
sendit(LoadConfiguration,6,pgc,pgd)
sendit(config1,16,pgc,pgd)
for k=&H8000 to &H8005 'step through to config1
  sendit(IncrementAddress,6,pgc,pgd)
next k
sendit(ReadDataFromProgramMemory,6,pgc,pgd)
DEVID=readit(pgc,pgd)
select case DEVID
  case &H3020
    devname$="PIC16F1454"
  case &H3021
    devname$="PIC16F1455"
  case &H3024
    devname$="PIC16LF1454"
  case &H3025
    devname$="PIC16LF1455"
  CASE ELSE
    Print "Device ID : ",hex$(DEVID,4)," Not Supported: Disconnect the battery"
    setpin pgc,din
    setpin pgd,din
    end
end select

Print devname$+": Erasing"
sendit(ResetAddress,6,pgc,pgd)
sendit(BulkEraseProgramMemory,6,pgc,pgd)
pause TERAB
read s$
print "Programing code area"
do while s$<>"XXX"
  print ".";
  n=n+1
  if (n mod 64) =0 then print ""
  for j=0 to 31
    sendit(LoadDataForProgramMemory,6,pgc,pgd)
    k=val("&H"+mid$(s$,j*4+3,2)+mid$(s$,j*4+1,2))
    sendit(k,16,pgc,pgd)
    if j=31 then
      sendit(BeginInternallyTimedProgramming,6,pgc,pgd)
      pause TPINTP
    endif
    sendit(IncrementAddress,6,pgc,pgd)
  next j
  read s$
loop
print ""
print "Programming configuration words"
sendit(LoadConfiguration,6,pgc,pgd)
sendit(config1,16,pgc,pgd)
for k=&H8000 to &H8006 'step through to config1
  sendit(IncrementAddress,6,pgc,pgd)
next k
sendit(BeginInternallyTimedProgramming,6,pgc,pgd)
pause TPINTC
sendit(LoadConfiguration,6,pgc,pgd)
sendit(config2,16,pgc,pgd)
for k=&H8000 to &H8007 'step through to config2
  sendit(IncrementAddress,6,pgc,pgd)
next k
sendit(BeginInternallyTimedProgramming,6,pgc,pgd)
pause TPINTC

Print "Starting verify"
restore
read s$
n=0
sendit(ResetAddress,6,pgc,pgd)
do while s$<>"XXX"
  print ".";
  n=n+1
  if (n mod 64) =0 then print ""
  for j=0 to 31
    sendit(ReadDataFromProgramMemory,6,pgc,pgd)
    r=readit(pgc,pgd)
    t=val("&H"+mid$(s$,j*4+3,2)+mid$(s$,j*4+1,2)) and &H3FFF
    if r <> t then
      print " Data Verify Error : Disconnect the battery"
      setpin pgc,din
      setpin pgd,din
      end
    endif
    sendit(IncrementAddress,6,pgc,pgd)
  next j
  read s$
loop
sendit(LoadConfiguration,6,pgc,pgd)
sendit(&H0F8C,16,pgc,pgd)
for k=&H8000 to &H8006 'step through to config1
  sendit(IncrementAddress,6,pgc,pgd)
next k
sendit(ReadDataFromProgramMemory,6,pgc,pgd)
if readit(pgc,pgd)<>config1 then
  print " Config1 Verify Error : Disconnect the battery"
  end
endif
sendit(IncrementAddress,6,pgc,pgd)
sendit(ReadDataFromProgramMemory,6,pgc,pgd)
if readit(pgc,pgd)<>config2 then
  print " Config2 Verify Error : Disconnect the battery"
  end
endif
print ""
Print "Verification OK"
print "Programming complete : ",timer/1000, " seconds, Now disconnect the battery"
setpin pgc,din
setpin pgd,din
end
'
CSUB sendit 'data to send, number of bits, pgc, pgd
00000000
27BDFFD0 AFB60028 AFB40020 AFB20018 AFBF002C AFB50024 AFB3001C AFB10014
AFB00010 8CB30000 24020010 00A0B021 00C09021 00E0A021 16620018 8C950000
3C109D00 8CE40000 8E02001C 24050005 0040F809 2413000E 8E020004 0040F809
24040003 8E440000 8E02001C 0040F809 24050006 8E020004 0040F809 24040003
8E02001C 8E440000 0040F809 24050005 00008821 10000005 3C109D00 1E60FFFD
00008821 10000038 8FBF002C 02351007 30420001 10400007 24050005 8E02001C
8E840000 0040F809 24050006 10000005 8E020004 8E02001C 0040F809 8E840000
8E020004 24040003 0040F809 26310001 8E440000 8E02001C 0040F809 24050006
8E020004 0040F809 24040003 8E02001C 8E440000 0040F809 24050005 0233102A
1440FFE3 02351007 8EC30000 24020010 14620015 8FBF002C 3C109D00 8E840000
8E02001C 0040F809 24050005 8E020004 0040F809 24040003 8E440000 8E02001C
0040F809 24050006 8E020004 0040F809 24040003 8E02001C 8E440000 0040F809
24050005 8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014
8FB00010 03E00008 27BD0030
End CSUB
'
CFunction readit
00000000
27BDFFD0 AFBF002C AFB60028 AFB50024 3C169D00 AFB40020 AFB3001C AFB20018
AFB10014 AFB00010 00809021 8EC2001C 8CA40000 00A0A021 0040F809 2405FFFE
8E440000 8EC2001C 24050006 0040F809 00009821 8EC20004 24040003 0040F809
00008821 8E440000 8EC2001C 24050005 0040F809 3C109D00 8EC20004 24040003
0040F809 2415000E 8E440000 8E02001C 0040F809 24050006 8E020004 0040F809
24040003 8E440000 8E02001C 0040F809 24050005 8E020004 0040F809 24040003
8E020020 0040F809 8E840000 02221004 26310001 1635FFEC 02629825 3C109D00
8E440000 8E02001C 0040F809 24050006 8E020004 0040F809 24040003 8E440000
8E02001C 0040F809 24050005 8E020004 0040F809 24040003 8E02001C 8E840000
0040F809 2405FFFD 8FBF002C 00131FC3 02601021 8FB60028 8FB50024 8FB40020
8FB3001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0030
End CFunction

'void sendit(int *command, int *bits, int *pgc, int *pgd){
'int j, c=*command, n=*bits;
'if(*bits==16){
'n=14;
'PinSetBit(*pgd,LATCLR);
'uSec(3);
'PinSetBit(*pgc,LATSET);
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'
'}
'for(j=0;j<n;j++){
'if((c>>j) & 1){
'PinSetBit(*pgd,LATSET);
'} else {
'PinSetBit(*pgd,LATCLR);
'}
'uSec(3);
'PinSetBit(*pgc,LATSET);
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'}
'if(*bits==16){
'PinSetBit(*pgd,LATCLR);
'uSec(3);
'PinSetBit(*pgc,LATSET);
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'}
'}
'
'long long readit(int *pgc, int *pgd){
'int j,ret=0;
'PinSetBit(*pgd,TRISSET);
'PinSetBit(*pgc,LATSET); //through away the first bit
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'uSec(3);
'
'for(j=0;j<14;j++){
'PinSetBit(*pgc,LATSET);
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'uSec(3);
'ret|=(PinRead(*pgd)<<j);
'}
'PinSetBit(*pgc,LATSET); //through away the first bit
'uSec(3);
'PinSetBit(*pgc,LATCLR);
'uSec(3);
'PinSetBit(*pgd,TRISCLR);
'return ret;
'}
'
DATA "9831002F003008007E1480312000911C0A280B2853282100CE0ACB0A0319CC0A23005403031D15281628192822000E155028550803191D281E282928D5012000"
DATA "6E08031D242825282928E801E9010130EE0020006E0803192E282F284E2868086904031D34283528372822000E153230200068066904031D3E283F2841282200"
DATA "0E119630200068066904031D482849284A28EE01E80A0319E90A502822000E112000911056288B31722380317E10090080315A2823009C31C0248031DF009C31"
DATA "C1248031E0009C31C2248031E1009C31C3248031E2009C31C4248031E3009C31C5248031E4009C31C6248031E50024009D31A1258031D8009D31A2258031D900"
DATA "9D31A3258031DA009D31A4258031DB009D31A5258031DC009D31A6258031DD009D31A7258031DE009D31A8258031DF009D31A9258031E0009D31AA258031E100"
DATA "9D31AB258031E2009D31AC258031E3009D31AD258031E4009D31AE258031E5009D31AF258031E6009D31B0258031E7009D31B1258031E8009D31B2258031E900"
DATA "9D31B3258031EA009D31B4258031EB009D31B5258031EC00AA308400213085004630FE000230FF009C31FA24803164308400003085000C30FE000030FF009C31"
DATA "FA2480312100CB01CC01CD01CE01CF01CB308400013085001430FE000030FF009C31FA24803120308400023085003830FE000030FF009C31FA2480317E102000"
DATA "8131022921302100C900AA30C800C7014908A1004808A0009131252181319D31CC2581319C31EE2481319431592481312300D401643021004E02031C20292129"
DATA "1A29CE0123004D08031D27292829A42920008C192C292D29672921004708031D322933293829C701C70ACB01CC01A42901304C02903003194B02031C40294129"
DATA "44298E1122008E110F3021004C02A13003194B02031C4D294E295A2911304C02303003194B020318562957295A292300D401D40A113021004C02303003194B02"
DATA "031C63296429A4292300D401A42921004703031D6C296D29A42901304C02903003194B020318752976297729C7010F304C02A03003194B0203187F2980299529"
DATA "C7012300D401D40ACD01CD0A21008E1122008E1121008C1222008C1221000C1222000C1231302100C0000F304C02A03003194B02031C9D299E29A429C7015830"
DATA "933142238131A4299C31A7248131003A0319AB29AC292229023090313E208131003A031DB429B529832A02309D312F258131003A0319BD29BE29832A4808443E"
DATA "86000230493D87004030B8000230B900403F3802BA00413F393BBB003B08803ABC0080303C02031DD72941303A02031CDA29DB29832AC1302100A30002309E31"
DATA "48268131C400C50144084504031DE929EA29EB297F2ACA015C2A4808443E86000230493D8700403FB800413FB9003908803ABA0082303A02031D002A40303802"
DATA "0318032A042A5A2A21004A08B800B9013808410786003908423D87000108BA004808403E86000230493D8700403F4807BB00413F493DBC003B0886003C088700"
DATA "3A0881004808403E86000230493D87000130810741310318810A4808403E86000230493D8700403FB800413FB9003908803ABA0082303A02031D402A40303802"
DATA "031C432A442A4E2A21004808403E86000230493D87000030C03FC13F21004808443E86000230493D87000130810741310318810A2100CA0A4A08B800B9014508"
DATA "3902031D652A44083802031C682A692AED29403044064504031D6F2A702A7F2A02309D3106258131003A031D782A792A702AA401A50102309231972281310230"
DATA "9331FB23813123004D080319882A892A642E20008C198D2A8E2AA52A21004708031D932A942A992AC701C70ACB01CC01BB2A0F304C02A03003194B02031CA12A"
DATA "A22ABB2A2300D401BB2A21004703031DAA2AAB2ABB2A0F304C02A03003194B020318B32AB42AB62AC701BB2AC70158309331422381312100BF014A2EBF0A4808"
DATA "423E86000230493D8700403F48078400413F493D85000008CA004808423E86000230493D87000130810741310318810A4808423E86000230493D8700403FB800"
DATA "413FB9003908803ABA0082303A02031DEB2A40303802031CEE2AEF2AF92A21004808423E86000230493D87000030C03FC13F21004808443E86000230493D8700"
DATA "FF3081074131FF30813D7F3169304A06031D0B2B0C2B7E2B8C1222008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16"
DATA "000022000C12000022000C16000022000C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C120000"
DATA "22000C16000022000C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C12000022000C1600002200"
DATA "0C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C12000022000C16000022000C124A2E65304A06"
DATA "0319832B842B902B7A304A060319892B8A2B902B61304A06031D8F2B902BF82B8C1222008C12000022000C16000022000C128C16000022000C16000022000C12"
DATA "21008C16000022000C16000022000C12000022000C16000022000C12653021004A06031DB42BB52BB72B4A2E4A2E8C1222008C12000022000C16000022000C12"
DATA "000022000C16000022000C1221008C16000022000C16000022000C12000022000C16000022000C127A3021004A06031DDA2BDB2BDC2B4A2E8C12000022000C16"
DATA "000022000C12000022000C16000022000C1221008C16000022000C16000022000C12000022000C16000022000C124A2E49304A06031DFD2BFE2B982CC3018C12"
DATA "22008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C1220008C1E1A2C1B2C1E2C2100C301C30A00002200"
DATA "0C16000022000C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C1220008C1E3E2C3F2C422C2100"
DATA "C30AC30A000022000C16000022000C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C1220008C1E"
DATA "622C632C662C04302100C307000022000C16000022000C1221008C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C160000"
DATA "22000C1220008C1E862C872C8A2C08302100C307000022000C16000022000C1249302100C30743089C31E32481314A2E44304A06031D9D2C9E2CCA2C8C122200"
DATA "8C12000022000C16000022000C12000022000C16000022000C1221008C16000022000C16000022000C1220008C1EB92CBA2CBF2C31309C31E3248131C32C3030"
DATA "9C31E3248131000022000C16000022000C124A2E61304A02031CCF2CD02CD62C7B304A02031CD52CD62CE22C41304A02031CDB2CDC2CEE2C5B304A020318E12C"
DATA "E22CEE2CBD01BD0ABE01BE0A61304A02031CEB2CEC2CEF2CBE01EF2CBD013D080319F32CF42C3D2E3E080319F82CF92C502D2330C60049304A02031C002D012D"
DATA "372D59304A020318062D072D372D4A08B73E8931A1218131C600452DA001A00A00309031EF208131C600452DA00101309031EF208131C600452DA001A00A0130"
DATA "9031EF208131C600452DA001A00A00309031EF208131A00100309031EF208131A00100309031EF208131C600452D4A08413A0319252D043A03190E2D033A0319"
DATA "162D013A03191D2D452D2330460603194A2D4B2D4A2E46089C31E32481314A2E69304A02031C552D562D752D79304A0203185B2D5C2D752D4A08973E9531C025"
DATA "81314A2EA00100309031902081314A2EA00101309031902081314A2EA001A00A01309031902081314A2E4A08643A0319622D023A0319682D013A03196E2DB62B"
DATA "00309D315C2581314A2E01309D315C2581314A2EA00100309031EF208131303A031D932D942D4A2E3030C0004A2E3C309C31E32481310230CE004A2E40089C31"
DATA "E32481313130C0004A2E8E1122008E114A2E8E154A2E0E142300CE0121004A089331422381314A2E4D080319B82DB92D4A2E0E1022000E102300CE01CE0A4A2E"
DATA "8E142300CF0121004A089331422381314A2E4D080319CD2DCE2D4A2E8E1022008E102300CF01CF0A4A2ECE0114304E02031CDB2DDC2DD62D4A2ECD01CD0A4A2E"
DATA "9D31B62581319C31E32481314A2E56309C31E324813131309C31E32481312E309C31E324813131309C31E324813137309C31E32481310D309C31E32481310A30"
DATA "9C31E32481314A2E61309C31E324813173309C31E324813163309C31E324813169309C31E324813169309C31E324813120309C31E324813149309C31E3248131"
DATA "43309C31E324813153309C31E324813150309C31E324813120309C31E324813176309C31E324813131309C31E32481314E309C31E32481314A2E4A08DF3E031C"
DATA "B62B84001F3004020318B62B90310435003E820021004808443E86000230493D8700160001040319562E572E5D2E24303F02031C5C2E5D2EBE2A0A30A9000130"
DATA "9131D121813122292000911E682E692E6F2E9D317D2581319C31E32481313C302100A90028309131D121813121004808443E86000230493D8700160001040319"
DATA "822E832ED52E23009E1C872E882ED52E21004808423E86000230493D8700403F48078400413F493D85000008CA004808423E86000230493D8700013081074131"
DATA "0318810A4808423E86000230493D8700403FB800413FB9003908803ABA0082303A02031DB52E40303802031CB82EB92EC32E21004808423E86000230493D8700"
DATA "0030C03FC13F21004808443E86000230493D8700FF3081074131FF30813D7F314A089C31B924813122292229803158287834033446340034413400344B340034"
DATA "453400342034003453340034653400347234003469340034613400346C340034203400344E340034753400346D3400346234003465340034723400343A340034"
DATA "20340034443400346F3400346E340034273400347434003420340034733400346834003469340034703400342034003461340034203400347034003472340034"
DATA "6F34003464340034753400346334003474340034203400346C340034693400346B3400346534003420340034743400346834003469340034733400342E340034"
DATA "20340034503400344C3400344534003441340034533400344534003421340034303403345334003469340034673400346E340034613400346C34003420340034"
DATA "313400343134003420340034533400346F340034663400347434003477340034613400347234003465340034203400344C3400344C340034433400342E340034"
DATA "26340334433400344434003443340034203400344434003461340034743400346134003420340034493400346E34003474340034653400347234003466340034"
DATA "6134003463340034653400341C34033443340034443400344334003420340034493400346E340034743400346534003472340034663400346134003463340034"
DATA "653400341A3403345534003453340034423400342034003443340034443400344334003420340034543400346534003473340034743400340434033409340434"
DATA "09340234463400340234013402348034323408340B34003402340234023400340234093404340034003401340234023400340334053424340034103401340434"
DATA "2434023406340534243406340034013407340534813403340A3400340134093404340134003402340A3400340034043407340534823402344034003401340734"
DATA "0534023402344034003401341234013410340134EF34023401340834D83404340A34003400340134013402340034013408302000A1008030A00008002108BD00"
DATA "6B03031D4428452858286608670403194A284B285428FC01FC0A6A08FD0067088A0066080A0088319C31CF248831D1286C0803195C285D28D1283D08B800B901"
DATA "65083902031D662864083802031C69286A286F286508BB006408BA0072283D08BA00BB013A08BE006C08860001308700862823005F0884006008850020003E08"
DATA "B80012001E00B80B81288728792820003E08EC073E08E402031CE50308303D02031C932894289A2864086504031D99289A28D1283D083E0203189F28A028B228"
DATA "9C31AE248831660867040319A828A9285428FC016A08FD0067088A0066080A0088315428BC01660867040319B828B928C428FC01FC0A6A08FD0067088A006608"
DATA "0A0088312000BC00BC1FC728C828CC289C31AE248831CF289C31B3248831E601E7010800440886004508870044310108CE004408860045088700413120300106"
DATA "031DE328E4282029440886004508870021300106031DED28EE2820294E082300D700200044088600450887004631403FC600413FC70000304702073003194602"
DATA "031C0329042908290730C800C901112944088600450887004631403FC800413FC9004908F1004808F0003D30F2001D30F300F401D8309D316C2588310030A029"
DATA "4408860045088700413121300106031D2A292B296D294408860045088700A1300106031D342935296D29D830F0004E08803102208831CC00CC1F3F2940294229"
DATA "FF30A02944088600450887004631403FC600413FC70000304702073003194602031C5329542958290730CA00CB01612944088600450887004631403FCA00413F"
DATA "CB004B08C0004A08BF00C101C201C301D8309D31E22588311E294408860045088700413123300106031D772978294029440886004508870021300106031D8129"
DATA "8229402944088600450887004231403FF000413FF1004E089E319A2688312000CD00CD1F9429952996294029BF01C001C101C201C30100309D31E22588311E29"
DATA "0800A300A2018C1223080139A000A00EA00D22000C0821002006DF39200622008C00000022000C16000022000C128C12000022000C16000022000C1221008C16"
DATA "000022000C16000022000C1220008C1ECA29CB29CE292100A201A20A000022000C16000022000C1221008C1223360139A000A00EA00D22000C0821002006DF39"
DATA "200622008C00000022000C16000022000C128C12000022000C16000022000C1221008C16000022000C16000022000C1220008C1EFC29FD29002A2100A20AA20A"
DATA "000022000C16000022000C1221008C122308A000A036A03620080139A100A10EA10D22000C0821002106DF39210622008C00000022000C16000022000C128C12"
DATA "000022000C16000022000C1221008C16000022000C16000022000C1220008C1E322A332A362A04302100A207000022000C16000022000C1221008C122308A000"
DATA "A036A036A03620080139A100A10EA10D22000C0821002106DF39210622008C00000022000C16000022000C128C12000022000C16000022000C1221008C160000"
DATA "22000C16000022000C1220008C1E692A6A2A6D2A08302100A207000022000C16000022000C1249302100A2072208080020006D0803197D2A7E2AE52A2130FB00"
DATA "AA30FA007B08F1007A08F0009031BA208A3121008E1122008E11E52A9C30F0003F309E317E268A31672B4E30F0001F309E317E268A31672B2730F0000F309E31"
DATA "7E268A31672B1330F00087309E317E268A31672B0930F000C3309E317E268A31672B0430F000E1309E317E268A31672B0230F00071309E317E268A31672BF001"
DATA "F00A37309E317E268A31672BF001D0309E317E268A31672BF0019B309E317E268A31672BF00168309E317E268A31672BF00133309E317E268A31672BF001F00A"
DATA "37309E317E268A31672B7508860001308700403FF600413FF700423FF800433FF9007908003A03195C2BDE2A7708013A0319132B033A0319182B063A03191D2B"
DATA "0D3A0319222B1B3A0319272B373A03192C2B6E3A0319312BDD3A0319362B773A03193B2BDE2A76082C3A03198E2ADE2A7608583A0319952ADE2A7608B03A0319"
DATA "9C2ADE2A7608603A0319A32ADE2A7608C03A0319AA2ADE2A7608803A0319B12ADE2A7608003A0319B82ADE2A7608003A0319BF2ADE2A7608003A0319C62ADE2A"
DATA "77082C3A0319482BEE3A03194D2BDE2A7608003A0319CC2ADE2A7608003A0319D22ADE2A7708843A0319572BDE2A7608003A0319D82ADE2A7808003A0319F62A"
DATA "013A0319402B023A0319522BDE2A20006D0803196C2B6D2B702BED0121008E15003008003D00101C762B772B7F2B9C31A0248B3193319D238B313D001010901E"
DATA "822B832BAD2B2000E101E10AE20198302000DB000E30DC0061085B07DD0062085C3DDE005D08DF005E08E0005F088600600887000110E10A0319E20A6208803A"
DATA "DB0080305B02031DA72B03306102031CAA2BAB2B872B3D009012901DB02BB12B5D2C921DB42BB52B5D2C0F0C2000DB00DB0C5B0C0F39003A031DBF2BC02BEB2B"
DATA "3D000F19C42BC52BEB2B2000200C890C0F39E3000D306306031DCF2BD02BD42B9231EA228B31E72B09306306031DD92BDA2BDB2BE72B6303031DDF2BE02BE42B"
DATA "88313E208B31E72B9C31AE248B31883138208B315B2C3D000F0C2000DB00DB0C5B0C0F39003A031DF62BF72B002C3D000F1DFB2BFC2B002C953138258B315B2C"
DATA "3D000F0C2000DB00DB0C5B0C0F39003A03190B2C0C2C5B2C3D000F0C2000DB00DB0C5B0C0F39DC0003305C020318192C1A2C5B2C3D000F1D1E2C1F2C3D2C0730"
DATA "F0000F0C2000DB00DB0C5B0C0F3991315B218B315E3E860002308700811C312C322C5B2C3D000F0C2000DB00DB0C5B0C0F3990314D208B315B2C0730F0000F0C"
DATA "2000DB00DB0C5B0C0F3991315B218B315E3E860002308700011C4F2C502C5B2C3D000F0C2000DB00DB0C5B0C0F399D318E258B315B2C3D009011101F602C612C"
DATA "652C9C319F248B3110132000121D692C6A2C6B2C12110800C901230060082000D70023005F082000D6005608860057088700413106300106031D7F2C802C1F2D"
DATA "560886005708870080300106031D892C8A2C1F2D56088600570887004231403FBF00413FC0004008D400560886005708870042310108D0005403031DA02CA12C"
DATA "B92C2630F7008830F80026308400883085000008F900FA0156088600570887004631403FFB00413FFC009431B9248C31FD2E02305406031DBE2CBF2CF12C5008"
DATA "0319C32CC42CC82C9C31AE248C31FD2E5035E43E860001308700403FCB00413FCC004C08F8004B08F7004C08C0004B08BF0002303F07840040080318400A8500"
DATA "003FF900013FFA0056088600570887004631403FFB00413FFC009431B9248C31FD2E03305406031DF62CF72CF82CC42C5708F1005608F0004F30F2009C31A424"
DATA "8C317108CE007008CD00CE1F082D092D0A2DC42C4F08F7000030F8004E08FA004D08F90056088600570887004631403FFB00413FFC009431B9248C31FD2E5608"
DATA "860057088700413105300106031D292D2A2D3A2D2300D101D10A20005608860057088700423101082300D0009C31B3248C31FD2E560886005708870041310930"
DATA "0106031D442D452D552D560886005708870042310108C700963172268C319C31B3248C314708EF00FD2E5608860057088700413108300106031D5F2D602D742D"
DATA "6F30F7000030F800F901F90AFA0156088600570887004631403FFB00413FFC009431B9248C31FD2E560886005708870041310108031D7D2D7E2DFB2D56088600"
DATA "5708870001081F39003A031D882D892DA42D9C31A1248C317108C2007008C1004130F7000030F8000230F900FA0156088600570887004631403FFB00413FFC00"
DATA "9431B9248C31FD2E560886005708870001081F39023A031DAE2DAF2DC42C560886005708870044310108D2000F30D205033052020318BD2DBE2DC42C0730F000"
DATA "520891315B218C315E3E86000230870001082000D10056088600570887004431811BD32DD42DD92D51080139C500C601DD2D51080239C500C60145084604031D"
DATA "E22DE42D0130E52D0030C300C4014330F7000030F8000230F900FA0156088600570887004631403FFB00413FFC009431B9248C31FD2E56088600570887004131"
DATA "0B300106031D052E062E072E362D560886005708870041310A300106031D112E122E272EC8014830F7000030F800F901F90AFA0156088600570887004631403F"
DATA "FB00413FFC009431B9248C31FD2E5608860057088700413101030319302E312E3C2E5608860057088700413103300106031D3B2E3C2EFB2ECA01CA0A56088600"
DATA "5708870001081F39023A031D482E492EF52E5608860057088700423116000104031D532E542EF52E560886005708870044310108D5000F30D505560886005708"
DATA "870044310108D3008030D3050330550203186B2E6C2EF52E5608860057088700413103300106031D762E772E862E530803197B2E7C2E812E55089E31B7268C31"
DATA "F32E55089E31D4268C31F32E530803198A2E8B2EBF2E5508090709070907253E860087010730F000550891315B218C315D3E8400023085000008810020005508"
DATA "090709070907243E8600870181010730F000550891315B218C315E3E86000230870081110730F0002000550891315B218C315E3E8600023087008110F32E5508"
DATA "090709070907213E860087010730F000550891315B218C315C3E8400023085000008810020005508090709070907203E86008701883081000730F00055089131"
DATA "5B218C315E3E86000230870001150730F0002000550891315B218C315E3E86000230870001102000CA014A08031DF92EFA2EC42C362DC901C903200049080800"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "8531E72D8331B62B8331B62B8331B62B8331B62B8331B62B8331B62B8331B62B8331B62B8331B62B85318A2D8331B62B8531E02D8331B62B8331B62B8531802D"
DATA "8531852D8531A52D8531A92D8531AB2D8531B42D8531C02D8531C92D8531D52D8531DD2D8331B62B8331B62B8331B62B85319E2D8531972D8631042E2100A300"
DATA "0730A00023089131962190315E3E860002308700010801390800F3007308090709070907253E860087010730F000730891315B2190315D3E8400023085000008"
DATA "81007308090709070907243E8600870184308100080000309D3113259031003A031D732874288F282300E31978287A2801307B280030F6002000A40176080319"
DATA "8228832888287408A500C830A4008C287408A5008830A40008302300E3060800A1008C12210C2200031C8C1203188C16000022000C16000022000C122100200C"
DATA "2200031C8C1203188C16000022000C16000022000C1221008C16000022000C16000022000C12000022000C16000022000C1208007008443E86000230713D8700"
DATA "0030C03FC13F7008403E86000230713D87000030C03FC13F7008423E86000230713D87000030C03FC13FF301F4017308700786007408713D87008101F30A0319"
DATA "F40A7408803AF20082307202031DEA2840307302031CED28EE28D7280800A1003030A2008C12210C2200031C8C1203188C16000022000C16000022000C122100"
DATA "200C2200031C8C1203188C16000022000C16000022000C1221008C16000022000C16000022000C1220008C1E182919291C2931302100A200000022000C160000"
DATA "22000C122100220808002008443E86000230213D87000030C03FC13F2008403E86000230213D87000030C03FC13F2008423E86000230213D87000030C03FC13F"
DATA "A301A40121002308200786002408213D87008101A30A0319A40A2408803AA20082302202031D562940302302031C59295A2942290800F100F201711C60296129"
DATA "63297008F207F035F11C672968296A297008F207F035711D6E296F2971297008F207F035F11D7529762978297008F207F035711E7C297D297F297008F207F035"
DATA "F11E8329842986297008F207F035711F8A298B298D297008F207F035F11F9129922994297008F20772080800A200A101221C9B299C299E292008A107A035A21C"
DATA "A229A329A5292008A107A035221DA929AA29AC292008A107A035A21DB029B129B3292008A107A035221EB729B829BA292008A107A035A21EBE29BF29C1292008"
DATA "A107A035221FC529C629C8292008A107A035A21FCC29CD29CF292008A10721080800AB002B084E020318D729D829DE2929084F02031CDD29DE290F2A4F080319"
DATA "E229E3290C2A02309D3106259131003A031DEB29EC29E32902309D314C2591312308860024088700012A203084000230850021004F08AA0012001E00AA0BFC29"
DATA "022AF52921004F08A400A50102309231972291312100CF01CE0120009A0108002708B1002608B00020303102003003193002031C1C2A1D2A222A3108A7003008"
DATA "A600522A3108AE003008AF002F088039A800A9012E08AA00AB01AA35AB0D28082A07AC0029082B3DAD002C082D04031D3A2A3C2A01303D2A0030A000A1015030"
DATA "A200A3019E31142692312108A7002008A6002F087F39A6070318A70AE030A6071F30A73D080077082000BB007608BA0020303B02003003193A02031C602A612A"
DATA "662A3B08F7003A08F600962A3B08B8003A08B90039088039F800F9013808FA00FB01FA35FB0D78087A07FC0079087B3DFD007C087D04031D7E2A802A0130812A"
DATA "0030F000F1015030F200F3019D31FB2592317108F7007008F60039087F39F6070318F70AE030F6071F30F73D0800A70020006F0803199D2A9E2AE92A21002708"
DATA "9D3121259231003A031DA72AA82AE92A2708090709070907243EA8000730A00027089131962192315E3E8600023087008119BB2ABD2A0130BE2A0030A6002808"
DATA "86008701810126080319C72AC82AD32A280A8600870124088100280886008701C8308100DD2A280A8600870124088100280886008701883081000730A0002708"
DATA "9131962192315E3E860002308700083081060800230060082000DA0023005F082000D900590886005A0887000030811B0130EB009C31AA249231A41F002B012B"
DATA "042B0830A500A401640865040319092B0A2B1B2B6608670403190F2B102B182BFC016A08FD0067088A0066080A0093319C31CF249231590886005A088700010E"
DATA "890C0339003A031D262B272B2F2B8C316C249231D800D81F2E2B2F2B3F2B5A08D0005908CF009C31C72492312000D800D81F3B2B3C2B3F2B9C31AE2492313D00"
DATA "0E120800A7004D080319472B482B532B23004F08031D4D2B4E2B532B4E080319522B532B652B21004D08031D582B592B5F2B3430270603195E2B5F2B652B5830"
DATA "2706031D642B652B9C2B2300D40158302100270603196D2B6E2B742B2000ED01ED0A22008C120C122100CE0105304E02031C7B2B7C2B762B8E152300CD012130"
DATA "2100A600AA30A5002608A1002508A0009131252193312100CE0105304E02031C922B932B8D2B8C160C168E140E142300CF01CE012100CD010800111091109201"
DATA "97018E15111611159011901190119011900192159216121412179830F0000E30F100F201F3011030F400F5019E312D2693313D00181698111815981418102000"
DATA "BF01BF0A3F08983EBD00BE010E30BE3D3D08C0003E08C10040088600410887000116400886004108870081154008860041088700011540088600410887008114"
DATA "40088600410887000110BF0A03303F02031CEB2BEC2BC22B3D0096012300D1012000EF019631722693319C31CF2493312100121508002100A4000730A0002408"
DATA "9131962193315E3E86000230870001190A2C0C2C01300D2C0030A30023080319122C132C302C2408090709070907213E860087010730A0002408913196219331"
DATA "5C3E840002308500000881002408090709070907203E86008701C83081004C2C2408090709070907213E860087010730A00024089131962193315C3E84000230"
DATA "8500000881002408090709070907203E86008701883081000730A00024089131962193315E3E8600023087000430810608003D0011109110920197018E151116"
DATA "111590119011901190119001921592161214121798302100A0000E30A100A201A3011030A400A5019E31632694313D00181698111815981418102100B501B50A"
DATA "3508983EB300B4010E30B43D3308B6003408B7003608860037088700011636088600370887008115360886003708870001153608860037088700811436088600"
DATA "370887000110B50A03303502031CA92CAA2C802C3D0096012300D1012000EF019731342794319C31D924943121001215080000307A02083003197902031CC12C"
DATA "C22CC62C0830BA00BB01CA2C7A08BB007908BA003A08BE003E08B800B9017C083902031DD52C7B083802031CD82CD92CDE2C7C08BD007B08BC00E12C3E08BC00"
DATA "BD013C08BE007C087A02031DE92C7B087902031CEC2CEE2C0130EF2C00302300D60020003E080319F62CF72C0A2D23006108860062088700092D770884007808"
DATA "850020003E08B80012001E00B80B042D0A2DFD2C78082300CC007708CB0020003E082300CB070318CC0A7A087C02031D1B2D79087B02031C1E2D1F2D252D7A08"
DATA "2000E5007908E4002A2D7C082000E5007B08E4003E08E402031CE5032300E31520003E08F400F50190316B20943108002300510803193D2D3E2D432D50083D00"
DATA "96002300D1012000640865040319492D4A2D982D00306502083003196402031C522D532D572D0830B900BA015B2D6508BA006408B9003908BB00230061088600"
DATA "62088700702D23004B0884004C08850020003B08B80012001E00B80B6B2D712D632D20003B08E402031CE5033B082300CB070318CC0A200064086504031D812D"
DATA "822D902D08303B06031D872D882D902D2300560803198D2D8E2D902DD301D30A20003B08F400F50190316B209531BF2D2300530803199D2D9E2DA92DF401F501"
DATA "90316B2095312300D3019C31CF249531BF2D20006B08031DAE2DAF2DBF2D660867040319B42DB52DA52DFC01FC0A6A08FD0067088A0066080A009531A52D0800"
DATA "A2008C1222080139A000A00EA00D22000C0821002006DF39200622008C00000022000C16000022000C128C12000022000C16000022000C1221008C1600002200"
DATA "0C16000022000C12000022000C16000022000C1221008C1222360139A000A00EA00D22000C0821002006DF39200622008C00000022000C16000022000C128C12"
DATA "000022000C16000022000C1221008C16000022000C16000022000C12000022000C16000022000C1221008C122208A000A036A03620080139A100A10EA10D2200"
DATA "0C0821002106DF39210622008C00000022000C16000022000C128C12000022000C16000022000C1221008C16000022000C16000022000C12000022000C160000"
DATA "22000C1221008C122208A000A036A036A03620080139A100A10EA10D22000C0821002106DF39210622008C00000022000C16000022000C128C12000022000C16"
DATA "000022000C1221008C16000022000C16000022000C12000022000C16000022000C1208003D000E172300E3012000BC010730F0003C0891315B2196315E3E8600"
DATA "02308700043081002000BC0A03303C02031C8B2E8C2E782E2030F0000030F100F201F3011830F400F5019E312D26963123006008F7005F08F600923153229631"
DATA "7708A3007608A2000830A1008030A00023006208F7006108F6009231532296317708A7007608A6000830A500A401BC01BC0A0730F0003C0891315B219631583E"
DATA "860002308700403FF600413FF7009231532296313C08090709070907223E860087017608C03F7708C13F3C08090709070907213E860087010730F0003C089131"
DATA "5B2196315C3E8400023085000008810020003C08090709070907203E86008701883081000730F0003C0891315B2196315A3E860002308700403FF600413FF700"
DATA "9231532296313C08090709070907263E860087017608C03F7708C13F3C08090709070907253E860087010730F0003C0891315B2196315D3E8400023085000008"
DATA "810020003C08090709070907243E860087018101BC0A03303C02031C302F312FB92E3D000E1308003D000E172300E3012100B2010730A0003208913196219731"
DATA "5E3E86000230870004308100B20A03303202031C4C2F4D2F3A2F2030A0000030A100A201A3011830A400A5019E3163269731230060082100A70023005F082100"
DATA "A60092311022973127082000A300210026082000A2000830A1008030A000230062082100A700230061082100A60092311022973127082000A700210026082000"
DATA "A6000830A500A4012100B201B20A0730A0003208913196219731583E860002308700403FA600413FA7009231102297313208090709070907223E860087012608"
DATA "C03F2708C13F3208090709070907213E860087010730A00032089131962197315C3E840002308500000881003208090709070907203E86008701883081000730"
DATA "A00032089131962197315A3E860002308700403FA600413FA7009231102297313208090709070907263E860087012608C03F2708C13F3208090709070907253E"
DATA "860087010730A00032089131962197315D3E840002308500000881003208090709070907243E860087018101B20A03303202031CFC2FFD2F872F3D000E130800"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"
DATA "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F0800"
DATA "0800F001F1010800F001F101080020006F0808000830A500A40108000830A5008430A40008002000A401A501C830A4000800A000200823009A000130D5000800"
DATA "80342034883420340034E03487345008C5004F08C4008831D2209C3108002300CB01CC012000EC01E401E501E601E70108002300CB01CC012000EC01E401E501"
DATA "E601E70108002100A0004F08203E86000230870020088100CF0A0800583020009C049C101C147D309B002100911420001C1508006400800101310130FE020030"
DATA "FF3B7F087E04031DFB2C00342100A0002008090709070907243E86008701010D010D01390800F3000730F000730891315B219D315E3E86000230870001080239"
DATA "0800A3000730A0002308913196219D315E3E860002308700010802390800A0002008090709070907203E860087010310811F03140030093D08007C08031D412D"
DATA "422D442DFF304B2DD830F500230057088A3178229D310800A6000730A0002608913196219D315A3E860002308700403FA300413FA40008002100A0008C12200C"
DATA "2200031C8C1203188C16000022000C16000022000C120800F5009C31CF249D317308E7007208E6007508EC007108E5007008E4007408EA00080023009D1C812D"
DATA "822D852D1D1219081D1619082100A00001302300D500210020080800F0007008090709070907213E8600870181017008090709070907203E8600870184308100"
DATA "08000034003400340034003400340034903420349134203401340A3400349B342034DB34203440344034003430302100A0008C16000022000C16000022000C12"
DATA "000020008C1EC52DC62DC92D31302100A0002100200808003C302100990427001B169B1723008C018E01FF3021008C00FF308E000E11951324008C158C160B17"
DATA "8B170800FD004208E7004108E6004308EA007D08F700FF39031D0130F8004008FA003F08F9004008FC003F08FB009431B9249D310800F401F501701C002E012E"
DATA "052E7208F4077308F53DF235F30DF136F00C70087104031D0E2E0F2EFD2D7508F1007408F0000800A401A501201C192E1A2E1E2E2208A4072308A53DA235A30D"
DATA "A136A00C20082104031D272E282E162E2508A1002408A00008007108F7007008F6003B2E760886007708870072088100F60A0319F70A0130F4020030F53B740A"
DATA "031D462E750A031D462E472E322E0800A4000730A0002408913196219E31583E860002308700230884008501403F803F413F813F2408090709070907213E8600"
DATA "8701010808002108A7002008A600712E260886002708870022088100A60A0319A70A0130A4020030A53B240A031D7C2E250A031D7C2E7D2E682E0800F1002100"
DATA "8E160E12243023009E0090309D0008309F001D161E129D1771089B009C0170089C009D1C942E952E982E9D1319089D171908080023005208031D9F2EA02EB42E"
DATA "21008E1122008E11000000000000000000000000000000000000000021008E152300D201D20AB52ED20100300800F40074080319BC2EBD2ED32E03307402031C"
DATA "C22EC32EC42ED32E0730F000740891315B219E315E3E8600023087008114740890314D209E310800F30073080319D92EDA2EF02E03307302031CDF2EE02EE12E"
DATA "F02E0730F000730891315B219E315E3E860002308700011473089D318E259E310800FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F803100005828"
'Bootstrap
DATA "2100FC309900210051301A05513C031D042F90309B0023008C0123008E0186276430F50067309F27C13C03191A2FF50B122F452F8230B1270130B1278230B127"
DATA "83014B30B127F0019E279E2723009200F6009E27230091009E27F7009E27F100203084009E278000840AF10B322FF008031D762F20308400771C402F7814202F"
DATA "F718482F5530B127232F95278301FD2E781C4F2F9430792723001512F8012030F900FA00000823009300840A00089400840A843079272300910AF90B522F9103"
DATA "2300151400000000840300083F3923009402031D732F840300089302031D732FFA0B5F2F202F5630B127232F4E30B127232F2300950055309600AA3096009514"
DATA "000000009518822F15110800230038309B00013023009C0023009F15903023009D00243023009E00080023009D0123009E0123009C0123009F0108003330F200"
DATA "6430F300F4012000911EAA2F23001908F0070800F40BA32FF30BA22FF20BA02F452F23009A0023009E1CB42F0800FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"
data "XXX"
