Option EXPLICIT
Option DEFAULT FLOAT
Const i2caddr=&b1110111
Const MS7=7 'set default wait period
Const signed=1
Const unsigned=0
'
Dim i2cin$ length 8 'max size for integer conversion
Dim UT%,UP%
Dim ac1%,ac2%,ac3,ac4%,ac5%,ac6%,b1%,b2%,mb%,mc%,md% 'bmp180 parameters
Dim x1%,x2%,b5%,b6%,x3,b3%,b4%,b7%,OSS%
Dim temperature%,pressure%
Dim altitude,QNH,pressureinHpa
Dim OSSdata%(4)
Dim OSSscale%(4)
I2C OPEN 400,1000
init:
  OSS%=1 'set oversampling ratio
' OSS%=0 ' Uncomment this line to check algorithm against datasheet
  OSSdata%(0)=&H34 'commands to sample pressure% with different levels of oversampling
  OSSdata%(1)=&H74
  OSSdata%(2)=&Hb4
  OSSdata%(3)=&HF4
  OSSscale%(0)=1 'scale factors for calcs when oversampled
  OSSscale%(1)=2
  OSSscale%(2)=4
  OSSscale%(3)=8
'
  I2C WRITE i2caddr,1,1,&HAA 'send read calibration data command
  I2C READ i2caddr,0,22,i2cin$() 'read in calibration data
  ac1%=intconv(Mid$(i2cin$,1,2),signed)
  ac2%=intconv(Mid$(i2cin$,3,2),signed)
  ac3=intconv(Mid$(i2cin$,5,2),signed)
  ac4%=intconv(Mid$(i2cin$,7,2),unsigned)
  ac5%=intconv(Mid$(i2cin$,9,2),unsigned)
  ac6%=intconv(Mid$(i2cin$,11,2),unsigned)
  b1%=intconv(Mid$(i2cin$,13,2),signed)
  b2%=intconv(Mid$(i2cin$,15,2),signed)
  mb%=intconv(Mid$(i2cin$,17,2),signed)
  mc%=intconv(Mid$(i2cin$,19,2),signed)
  md%=intconv(Right$(i2cin$,2),signed)
'
' Uncomment this block to check algorithm against datasheet
'
'  ac1%=408
'  ac2%=-72
'  AC3=-14383
'  ac4%=32741
'  ac5%=32757
'  ac6%=23153
'  b1%=6190
'  b2%=4
'  mb%=-32768
'  mc%=-8711
'  md%=2868

main:
  I2C WRITE i2caddr,0,2,&HF4,&H2E 'send temp conversion
  Pause MS7 'wait for temperature% conversion
  I2C WRITE i2caddr,1,1,&HF6 'send read data
  I2C READ i2caddr,0,2,i2cin$() 'read 2 bytes
  UT%=intconv(i2cin$,unsigned)
'  UT%=27898 ' Uncomment this line to check algorithm against datasheet
  I2C WRITE i2caddr,0,2,&HF4,ossdata%(oss%) 'send pressure% conversion
  Pause (oss%+1)*ms7 'wait for the p  ressure% conversion
  I2C WRITE i2caddr,1,1,&HF6 'send read data
  I2C READ i2caddr,0,3,i2cin$() 'read 3 bytes
  UP%=intconv(i2cin$,unsigned)
  UP%=UP%>>(8-oss%) 'scale the oUT%pUT% by the numb%er of unused bits in the xlsb byte
'  UP%=23843' Uncomment this line to check algorithm against datasheet
  calc_temp
  calc_pressure
  pressureinHpa=pressure%/100
  Print "Temperature = ",Str$(temperature%/10,4,1),"Deg C"
  Print "Local pressure = ",Str$(pressure%/100,4,1),"Hectopascal/mb"
  Input "QNH in Hpa/Mb  ? ",QNH
  altitude=calcaltitude(QNH,pressureinHpa)
  Print "Current altitude in feet = ",altitude
  Print "Reverse calculate Sea level pressure = ",calcQNH(altitude,pressureinHpa),"Hectopascal/mb"
End
'
' calc_temperature%: calculate the temperature% from the raw temperature% given the calibration parameters
'
Sub calc_temp
  x1%=(UT%-ac6%)*ac5%\powerof2(15)
  x2%=mc%*powerof2(11)/(x1%+md%) 'This needs to be a floating divide to match the datasheet
  b5%=x1%+x2%
  temperature%=(b5%+8)\powerof2(4)
End Sub
'
' calc_pressure: calculate the pressure% from the raw pressure% given the calibration parameters and temperature% oUT%pUT%
'
Sub calc_pressure
   b6%=b5%-4000
   x1%=(b2%*(b6%*b6%/powerof2(12)))\powerof2(11)
   x2%=ac2%*b6%\powerof2(11)
   x3=x1%+x2%
   b3%=(((ac1%*4+x3)*ossscale%(oss%))+2)\4
   x1%=AC3*b6%\POWEROF2(13)
   x2%=(b1%*(b6%*b6%/POWEROF2(12)))\POWEROF2(16)
   x3=((x1%+x2%)+2)\4
   b4%=ac4%*(Abs(x3+32768))\powerof2(15)
   b7%=Abs(UP%-b3%)*(50000\ossscale%(oss%))
   pressure%=(b7%*2)\b4%
   x1%=(pressure%\powerof2(8))*(pressure%\powerof2(8))
   x1%=(x1%*3038)\powerof2(16)
   x2%=(-7357*pressure%)\powerof2(16)
   pressure%=pressure%+(x1%+x2%+3791)\powerof2(4)
   End Sub
'
Function calcQNH(currentaltitude,localpressure)
  calcQNH=(localpressure*100)/((1-(currentaltitude*0.3048/44330))^5.255)/100
End Function
'
Function log10(x)
  log10=Log(x)/2.302585093
End Function
'
Function calcaltitude(sealevelpressure, localpressure)
  Local a As float, b As float
  calcaltitude=((10^(log10(localpressure/sealevelpressure)/5.2558797))-1)/-6.8755856  *1000000
End Function
'
'cFunctions source and binary
'
'unsigned long long intconv(unsigned char innumb%er[],unsigned int *signednum){
'    int i,j;
'    union UT%ype{
'        unsigned long long b;
'        unsigned char a[8];
'    }u;
'    u.b=0;
'    j=innumb%er[0];//get the  numb%er of bytes
'    for(i=1;i<=innumb%er[0];i++)u.a[j-i] =innumb%er[i];
'    if (*signednum){i=u.a[j-1] & 0x80;//get the top bit
'      if(i){
'        for( ;j<=7;j++)u.a[j]=0xFF;//sign extend
'      }
'    }
'    return u.b;
'}
'unsigned long long powerof2(unsigned int *power){
'    int octet,place;
'    union UT%ype{
'        unsigned long long b;
'        unsigned char a[8];
'    }u;
'    u.b=0;
'    octet=*power/8;
'    place=*power-(octet*8);
'    u.a[octet]=1<<place;
'    return u.b;
'}'
Function intconv(s$, p%) As integer
 Local integer l,k,j,i=Len(s$)
 k=Peek(varaddr j)
 For l=1 To i
  Poke byte k+i-l,Asc(Mid$(s$,l,1))
 Next l
 If p% Then
 If (Asc(Left$(s$,1)) And &H80) Then
    For l=i To 7
      Poke byte k+l,&HFF
     Next l
 EndIf
 EndIf
 intconv=j
End Function
'
Function powerof2(i As integer) As integer
powerof2=(1<<i)
End Function
