Option explicit
option default NONE
CONST  BNO055_ADDRESS_A = &H28 'connectI2C-SEL to GND
CONST  BNO055_ADDRESS_B = &H29 'connectI2C-SEL to VCC
CONST  BNO055_ID        = &HA0
CONST PAGE_ID_ADDR = &H07

' PAGE0 REGISTER DEFINITION START
CONST CHIP_ID_ADDR = &H00
CONST ACCEL_REV_ID_ADDR  = &H01
CONST MAG_REV_ID_ADDR    = &H02
CONST GYRO_REV_ID_ADDR   = &H03
CONST SW_REV_ID_LSB_ADDR = &H04
CONST SW_REV_ID_MSB_ADDR = &H05
CONST BL_REV_ID_ADDR     = &H06

' Accel data register 
CONST ACCEL_DATA_X_LSB_ADDR    = &H08
CONST ACCEL_DATA_X_MSB_ADDR    = &H09
CONST ACCEL_DATA_Y_LSB_ADDR    = &H0A
CONST ACCEL_DATA_Y_MSB_ADDR    = &H0B
CONST ACCEL_DATA_Z_LSB_ADDR    = &H0C
CONST ACCEL_DATA_Z_MSB_ADDR    = &H0D

' Mag data register 
CONST MAG_DATA_X_LSB_ADDR= &H0E
CONST MAG_DATA_X_MSB_ADDR= &H0F
CONST MAG_DATA_Y_LSB_ADDR= &H10
CONST MAG_DATA_Y_MSB_ADDR= &H11
CONST MAG_DATA_Z_LSB_ADDR= &H12
CONST MAG_DATA_Z_MSB_ADDR= &H13

' Gyro data registers 
CONST GYRO_DATA_X_LSB_ADDR     = &H14
CONST GYRO_DATA_X_MSB_ADDR     = &H15
CONST GYRO_DATA_Y_LSB_ADDR     = &H16
CONST GYRO_DATA_Y_MSB_ADDR     = &H17
CONST GYRO_DATA_Z_LSB_ADDR     = &H18
CONST GYRO_DATA_Z_MSB_ADDR     = &H19

' Euler data registers 
CONST EULER_H_LSB_ADDR   = &H1A
CONST EULER_H_MSB_ADDR   = &H1B
CONST EULER_R_LSB_ADDR   = &H1C
CONST EULER_R_MSB_ADDR   = &H1D
CONST EULER_P_LSB_ADDR   = &H1E
CONST EULER_P_MSB_ADDR   = &H1F

' Quaternion data registers 
CONST QUATERNION_DATA_W_LSB_ADDR     = &H20
CONST QUATERNION_DATA_W_MSB_ADDR     = &H21
CONST QUATERNION_DATA_X_LSB_ADDR     = &H22
CONST QUATERNION_DATA_X_MSB_ADDR     = &H23
CONST QUATERNION_DATA_Y_LSB_ADDR     = &H24
CONST QUATERNION_DATA_Y_MSB_ADDR     = &H25
CONST QUATERNION_DATA_Z_LSB_ADDR     = &H26
CONST QUATERNION_DATA_Z_MSB_ADDR     = &H27

' Linear acceleration data registers 
CONST LINEAR_ACCEL_DATA_X_LSB_ADDR   = &H28
CONST LINEAR_ACCEL_DATA_X_MSB_ADDR   = &H29
CONST LINEAR_ACCEL_DATA_Y_LSB_ADDR   = &H2A
CONST LINEAR_ACCEL_DATA_Y_MSB_ADDR   = &H2B
CONST LINEAR_ACCEL_DATA_Z_LSB_ADDR   = &H2C
CONST LINEAR_ACCEL_DATA_Z_MSB_ADDR   = &H2D

' Gravity data registers 
CONST GRAVITY_DATA_X_LSB_ADDR  = &H2E
CONST BNO055_GRAVITY_DATA_X_MSB_ADDR  = &H2F
CONST GRAVITY_DATA_Y_LSB_ADDR  = &H30
CONST GRAVITY_DATA_Y_MSB_ADDR  = &H31
CONST GRAVITY_DATA_Z_LSB_ADDR  = &H32
CONST GRAVITY_DATA_Z_MSB_ADDR  = &H33

' Temperature data register 
CONST TEMP_ADDR    = &H34

' Status registers 
CONST CALIB_STAT_ADDR    = &H35
CONST SELFTEST_RESULT_ADDR     = &H36
CONST INTR_STAT_ADDR     = &H37

CONST SYS_CLK_STAT_ADDR  = &H38
CONST SYS_STAT_ADDR= &H39
CONST SYS_ERR_ADDR = &H3A

' Unit selection register 
CONST UNIT_SEL_ADDR= &H3B
CONST DATA_SELECT_ADDR   = &H3C

' Mode registers 
CONST OPR_MODE_ADDR= &H3D
CONST PWR_MODE_ADDR= &H3E

CONST SYS_TRIGGER_ADDR   = &H3F
CONST TEMP_SOURCE_ADDR   = &H40

' Axis remap registers 
CONST AXIS_MAP_CONFIG_ADDR     = &H41
CONST AXIS_MAP_SIGN_ADDR = &H42

' SIC registers 
CONST SIC_MATRIX_0_LSB_ADDR    = &H43
CONST SIC_MATRIX_0_MSB_ADDR    = &H44
CONST SIC_MATRIX_1_LSB_ADDR    = &H45
CONST SIC_MATRIX_1_MSB_ADDR    = &H46
CONST SIC_MATRIX_2_LSB_ADDR    = &H47
CONST SIC_MATRIX_2_MSB_ADDR    = &H48
CONST SIC_MATRIX_3_LSB_ADDR    = &H49
CONST SIC_MATRIX_3_MSB_ADDR    = &H4A
CONST SIC_MATRIX_4_LSB_ADDR    = &H4B
CONST SIC_MATRIX_4_MSB_ADDR    = &H4C
CONST BNO055_SIC_MATRIX_5_LSB_ADDR    = &H4D
CONST SIC_MATRIX_5_MSB_ADDR    = &H4E
CONST SIC_MATRIX_6_LSB_ADDR    = &H4F
CONST SIC_MATRIX_6_MSB_ADDR    = &H50
CONST SIC_MATRIX_7_LSB_ADDR    = &H51
CONST SIC_MATRIX_7_MSB_ADDR    = &H52
CONST SIC_MATRIX_8_LSB_ADDR    = &H53
CONST SIC_MATRIX_8_MSB_ADDR    = &H54

' Accelerometer Offset registers 
CONST ACCEL_OFFSET_X_LSB_ADDR   = &H55
CONST ACCEL_OFFSET_X_MSB_ADDR   = &H56
CONST ACCEL_OFFSET_Y_LSB_ADDR   = &H57
CONST ACCEL_OFFSET_Y_MSB_ADDR   = &H58
CONST ACCEL_OFFSET_Z_LSB_ADDR   = &H59
CONST ACCEL_OFFSET_Z_MSB_ADDR   = &H5A

' Magnetometer Offset registers 
CONST MAG_OFFSET_X_LSB_ADDR     = &H5B
CONST MAG_OFFSET_X_MSB_ADDR     = &H5C
CONST MAG_OFFSET_Y_LSB_ADDR     = &H5D
CONST MAG_OFFSET_Y_MSB_ADDR     = &H5E
CONST MAG_OFFSET_Z_LSB_ADDR     = &H5F
CONST MAG_OFFSET_Z_MSB_ADDR     = &H60

' Gyroscope Offset register s
CONST GYRO_OFFSET_X_LSB_ADDR    = &H61
CONST GYRO_OFFSET_X_MSB_ADDR    = &H62
CONST GYRO_OFFSET_Y_LSB_ADDR    = &H63
CONST GYRO_OFFSET_Y_MSB_ADDR    = &H64
CONST GYRO_OFFSET_Z_LSB_ADDR    = &H65
CONST GYRO_OFFSET_Z_MSB_ADDR    = &H66

' Radius registers 
CONST ACCEL_RADIUS_LSB_ADDR     = &H67
CONST ACCEL_RADIUS_MSB_ADDR     = &H68
CONST MAG_RADIUS_LSB_ADDR = &H69
CONST MAG_RADIUS_MSB_ADDR = &H6A
' Power Mode Settings
CONST POWER_MODE_NORMAL = &H00
CONST POWER_MODE_LOWPOWER = &H01
CONST POWER_MODE_SUSPEND = &H02
' Operation mode settings
CONST OPERATION_MODE_CONFIG = &H00
CONST OPERATION_MODE_ACCONLY = &H01
CONST OPERATION_MODE_MAGONLY = &H02
CONST OPERATION_MODE_GYRONLY = &H03
CONST OPERATION_MODE_ACCMAG = &H04
CONST OPERATION_MODE_ACCGYRO = &H05
CONST OPERATION_MODE_MAGGYRO = &H06
CONST OPERATION_MODE_AMG = &H07
CONST OPERATION_MODE_IMUPLUS = &H08
CONST OPERATION_MODE_COMPASS = &H09
CONST OPERATION_MODE_M4G = &H0A
CONST OPERATION_MODE_NDOF_FMC_OFF = &H0B
CONST OPERATION_MODE_NDOF = &H0C
CONST REMAP_CONFIG_P0 = &H21
CONST REMAP_CONFIG_P1 = &H24 ' default
CONST REMAP_CONFIG_P2 = &H24
CONST REMAP_CONFIG_P3 = &H21
CONST REMAP_CONFIG_P4 = &H24
CONST REMAP_CONFIG_P5 = &H21
CONST REMAP_CONFIG_P6 = &H21
CONST REMAP_CONFIG_P7 = &H24
CONST REMAP_SIGN_P0 = &H04
CONST REMAP_SIGN_P1 = &H00 ' default
CONST REMAP_SIGN_P2 = &H06
CONST REMAP_SIGN_P3 = &H02
CONST REMAP_SIGN_P4 = &H03
CONST REMAP_SIGN_P5 = &H01
CONST REMAP_SIGN_P6 = &H07
CONST REMAP_SIGN_P7 = &H05
DIM INTEGER  id
DIM INTEGER BNO055_ADDRESS = BNO055_ADDRESS_A
const C_INSIDE = 0' 0000 
const C_LEFT = 1  ' 0001 
const C_RIGHT = 2 ' 0010 
const C_BOTTOM = 4' 0100 
const C_TOP = 8   ' 1000 

cls  
dim integer w = 266 
dim integer h=w 
dim integer wby2 = w\2 
dim integer xm = 239 
dim integer ym = 135 
dim integer xmin = 106 
dim integer xmax = xmin+w 
dim integer ymin=2 
dim integer ymax=w+ymin 
dim integer xmn3=xm-3 
dim integer xmn7=xm-7 
dim integer xmn10=xm-10 
dim integer xmn15=xm-15 
dim integer xmn20=xm-20 
dim integer xmn21=xm-21 
dim integer xmn25=xm-25 
dim integer xmn26=xm-26 
dim integer xmn30=xm-30 
dim integer xmp7=xm+7 
dim integer xmp10=xm+10 
dim integer xmp15=xm+15 
dim integer xmp20=xm+20 
dim integer xmp21=xm+21 
dim integer xmp25=xm+25 
dim integer xmp26=xm+26 

dim integer ymn2=ym-2 
dim integer ymn16=ym-16 
dim integer ymn32=ym-32 
dim integer ymn48=ym-48 
dim integer ymn64=ym-64 
dim integer ymp4=ym+4 
dim integer ymp13=ym+13 
dim integer ymp16=ym+16 
dim integer ymp32=ym+32 
dim integer ymp48=ym+48 
dim integer ymp64=ym+64 
dim integer ymp80=ym+80 
dim integer ymp96=ym+96 
dim integer ymp112=ym+112 

dim integer radius = 101 
dim integer ymmr16 = ym-radius+16 
dim integer ymmrm16 = ym-radius-16 
dim integer ymmr1 = ym-radius+1 
dim integer ymmrm1 = ym-radius-1 
dim integer rp20 = radius+20 
dim integer rp10 = radius+10 
dim integer rp15 = radius+15 
dim integer rm20 = radius-20 
dim integer xmnr = xm-radius 
dim integer rgbw = rgb(white) 
dim integer rgbb = rgb(black) 
dim integer rgby = rgb(yellow) 
dim integer rgbbr = rgb(brown) 
dim integer rgbbl = rgb(blue) 
pause 10 
dim float pitch=0, roll=0 
dim integer x0,y0,x1,y1,x2,y2 
dim integer rx1(9),ry1(9),rx2(9),ry2(9),rcol(9)=(rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw) 
dim float pitchperdegree=3.2 
dim integer  lx1(24)=(xmn26,xmn21,xmn26,xmp20,xmp25,xmp20,xmn15,xmn15,xmn15,xmn15,xmn15,xmn15,xmn25,xmn25,xmn25,xmn25,xmn25,xmp10,xmp10,xmp10,xmp10,xmp10,xmp7,xm,xm) 
dim integer  ly1(24)=(ymp4,ymp4,ymp13,ymp4,ymp4,ymp13,ymp16,ymp48,ymp80,ymp112,ymn16,ymn48,ymn32,ymn64,ymp64,ymp32,ymp96,ymn32,ymn64, ymp64,ymp32,ymp96,ymmr16,ymmr1,ymmr1) 
dim integer  lx2(24)=(xmn26,xmn21,xmn21,xmp20,xmp25,xmp25,xmp15,xmp15,xmp15,xmp15,xmp15,xmp15,xmn10,xmn10,xmn10,xmn10,xmn10,xmp25,xmp25,xmp25,xmp25,xmp25,xmn7,xmp7,xmn7) 
dim integer  ly2(24)=(ymp13,ymp13,ymp13,ymp13,ymp13,ymp13,ymp16,ymp48,ymp80,ymp112,ymn16,ymn48,ymn32,ymn64,ymp64,ymp32,ymp96,ymn32,ymn64,ymp64,ymp32,ymp96,ymmr16,ymmr16,ymmr16)
dim integer  lcol(24)=(rgbb,rgbb,rgbb,rgbb,rgbb,rgbb,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbw,rgbb,rgbb,rgbb) 
'
const FUSION=1

i2c open 400,1000
resetBNO
setMode(OPERATION_MODE_CONFIG)
if fusion then
  writebyte(PAGE_ID_ADDR,1) 'switch to page 1
  writebyte(&H09,&B11101) 'mag high accuracy 20Hz
  writebyte(PAGE_ID_ADDR,0) 'switch to page 0
endif
pause 50
writeByte(UNIT_SEL_ADDR,&HA7) 'set output in radians and milli-g
if fusion then
  setMode(OPERATION_MODE_AMG) 'turn on all sensors - non-fusion mode
else
  setMode(OPERATION_MODE_NDOF)
endif
pause 50
Print "Move in figures of 8 until calibrated"
do
  if fusion then
    readData
  else
    readEUL
  endif
loop
end
'
sub resetBNO 'reset the sensor
  writeByte(SYS_TRIGGER_ADDR, &H20)
  timer=0
  do 
  pause 10
  loop until readByte(CHIP_ID_ADDR)=BNO055_ID  or timer>4000
  if timer> 4000 then
    print "BNO055 not found"
    end
  ENDIF
  pause 50
end sub
'
sub setMode(value%) 'set to a specific operation mode (see values above)
  writeByte(OPR_MODE_ADDR,value%)
  timer=0
  do 
  pause 10
  loop until readByte(CHIP_ID_ADDR)=BNO055_ID  or timer>4000
  if timer> 4000 then
    print "BNO055 not found"
    end
  ENDIF
  pause 50
end sub
'
sub writeByte(reg%,value%) 'write a single register
  i2c write BNO055_ADDRESS,0,2,reg%,value%
end sub
'
function readByte(reg%) as integer 'read a single register
  i2c write BNO055_ADDRESS,1,1,reg%
  pause 100
  i2c read BNO055_ADDRESS,0,1,readByte
end function

sub readData
  local a$
  local float mx, my, mz, mtot, gx, gy, gz, ax, ay, az, yaw, heading
  i2c write BNO055_ADDRESS,1,1,ACCEL_DATA_X_LSB_ADDR
  i2c read BNO055_ADDRESS,0,18,a$
  ax=intconv(MID$(a$,1,2),1)/1000
  ay=intconv(mid$(a$,3,2),1)/1000
  az=intconv(mid$(a$,5,2),1)/1000
  mx=intconv(mid$(a$,7,2),1)/16*1000
  my=intconv(mid$(a$,9,2),1)/16*1000
  mz=intconv(mid$(a$,11,2),1)/16*1000
  gx=intconv(mid$(a$,13,2),1)/900
  gy=intconv(mid$(a$,15,2),1)/900
  gz=intconv(mid$(a$,17,2),1)/900
  if fusion=1 then
    SENSORFUSION MAHONY ax, ay, az, gx, gy, gz, mx, my, mz,  pitch, roll, yaw, 2.0,0.2
  else
    SENSORFUSION MADGWICK ax, ay, az, gx, gy, gz, mx, my, mz,  pitch, roll, yaw, 0.2
  endif
  pitch=-pitch/pi*180
  roll=roll/pi*180
  yaw=yaw/pi*180+180
  option autorefresh off
  drawAI
  option autorefresh on
end sub

sub readEUL 'read in the Euler angles
  local a$
  local float i,j,k
  i2c write BNO055_ADDRESS,1,1,EULER_H_LSB_ADDR
  i2c read BNO055_ADDRESS,0,6,a$
  i=intconv(left$(a$,2),1)/16
  j=intconv(mid$(a$,3,2),1)/16
  k=intconv(right$(a$,2),1)/16
  if k< 0 then
    k=-(k+180)
  else
    k=180-k
  endif
  if(readByte(CALIB_STAT_ADDR) AND &HC0 = &HC0) then 
  pitch=k
  roll=j
    option autorefresh off
    drawAI
    option autorefresh on
  endif
end sub

sub readQUAT 'read in the quaternions
local a$
local float qw,qx,qy,qz,s=1<<14
  i2c write BNO055_ADDRESS,1,1,QUATERNION_DATA_W_LSB_ADDR
  pause 10
  i2c read BNO055_ADDRESS,0,8,a$
  qw=intconv(left$(a$,2),1)/s
  qx=intconv(mid$(a$,3,2),1)/s
  qy=intconv(mid$(a$,5,2),1)/s
  qz=intconv(right$(a$,2),1)/s
  print qw," ",qx," ",qy," ",qz
end sub

Function intconv(s$, p%) as integer 'convert values to signed integers
 local integer l,k,j,i=len(s$)
 k=peek(varaddr j)
 for l=1 to i
  poke byte k+l-1,asc(mid$(s$,l,1))
 next l
 if p% then
 if (asc(mid$(s$,i,1)) and &H80) then
    for l=i to 7
      poke byte k+l,&HFF
     next l 
 endif
 endif
 intconv=j
End Function 
sub drawAI
  local float xf1,yf1,xf2,yf2, pitchoffset, rolloffset,yo1,yo2 
  local integer xi1,yi1,xi2,yi2,rgbtop,rgbbottom
  local integer offscreen
  local float rroll=rad(roll) 
  if cos(rad(roll))>=0 then 
    rgbtop=rgbbl 
    rgbbottom=rgbbr 
  else 
    rgbtop=rgbbr 
    rgbbottom=rgbbl 
  endif 
' 
'sections which vary with pitch and roll 
' 
  pitchoffset=pitch*pitchperdegree 
  rolloffset=wby2 * tan(rroll) 
  xf1=xmin 
  xf2=xmax 
  yf1=ym+pitchoffset+rolloffset:yo1=yf1 
  yf2=ym+pitchoffset-rolloffset:yo2=yf2 
  offscreen = CohenSutherlandLineClip(xf1,yf1,xf2,yf2) 
  xi1=fix(xf1):yi1=fix(yf1):xi2=fix(xf2):yi2=fix(yf2) 
  if NOT offscreen then
    box xmin-2,0,w+4,h+4,2,rgbw,rgbtop
    if yo2<yo1 then
      if (xi1=xmin) then
        triangle xi1,yi1,xi2,yi2,xi2,yi1,rgbbottom,rgbbottom
        if xi2<>xmax then
          box xi1,yi1,w,ymax-yi1,0,,rgbbottom
          box xi2,yi2,xmax-xi2,h,0,,rgbbottom
        else 
          box xi1,yi1,w,ymax-yi1,0,,rgbbottom
        endif
      else 
        triangle xi1,yi1,xi2,yi2,xi2,yi1,rgbbottom,rgbbottom
        if xi2<>xmax then box xi2,yi2,xmax-xi2,h,0,,rgbbottom
      endif
    elseif yo1<yo2 then
      if xi1<>xmin then
        triangle xi1,yi1,xi2,yi2,xi1,yi2,rgbbottom,rgbbottom
        if  xi2=xmax then
          box xmin,yi2,w,ymax-yi2,0,,rgbbottom
          box xmin,yi1,xi1-xmin,h,0,,rgbbottom
        else 
          box xmin,yi1,xi1-xmin,h,0,,rgbbottom
        endif
      else
        triangle xi1,yi1,xi2,yi2,xi1,yi2,rgbbottom,rgbbottom
        if xi2=xmax then box xi1,yi2,w,ymax-yi2,0,,rgbbottom
      endif
    else 
      box xi1,yi1,w,ymax-yi1,0,,rgbbottom
    endif
    dcirch  xm,ym,radius,rgbw,xmn30,ymp96,xmn30+60,ymp96+8
    line xi1,yi1,xi2,yi2,,rgbw
  else 'no useful information
    if (offscreen and C_TOP) then
      box xmin-2,0,w+4,h+4,2,rgbw,rgbtop
    else
      box xmin-2,0,w+4,h+4,2,rgbw,rgbbottom
    endif
    dcirch  xm,ym,radius,rgbw,xmn30,ymp96,xmn30+60,ymp96+8
  endif
' 
' fixed background 
' 
  text xm,ymn64,"20",CM,,,rgbw,-1 
  text xm,ymn32,"10",CM,,,rgbw,-1 
  text xm,ymp64,"20",CM,,,rgbw,-1 
  text xm,ymp32,"10",CM,,,rgbw,-1 
  text xm,ymp96,"30",CM,,,rgbw,-1 
  triangle xm,ymmr1,xmn7,ymmr16,xmp7,ymmr16,rgby,rgby 
  BOX xmn3,ymn2,6,6,1,rgbb,rgby 
  BOX xmnr ,ymn2,rm20,6,1,rgbb,rgby 
  BOX xmp20 ,ymn2,rm20,6,1,rgbb,rgby 
  box xmn25,ymp4-1,4,10,,rgby,rgby 
  box xmp21,ymp4-1,4,10,,rgby,rgby
' 
  line lx1(),ly1(),lx2(),ly2(),,lcol()
' 
'  sections which vary with roll 
' 
  rotxy(xm,ym,roll,xm,ymmrm1,x0,y0) 
  rotxy(xm,ym,roll,xmn7,ymmrm16,x1,y1) 
  rotxy(xm,ym,roll,xmp7,ymmrm16,x2,y2) 
  triangle x0,y0,x1,y1,x2,y2,rgbw,rgbw
  radial xm,ym,rp20,330-roll,radius,0 
  radial xm,ym,rp20,30-roll,radius,1 
  radial xm,ym,rp20,300-roll,radius,2 
  radial xm,ym,rp20,60-roll,radius,3 
  radial xm,ym,rp10,10-roll,radius,4 
  radial xm,ym,rp10,20-roll,radius,5 
  radial xm,ym,rp10,340-roll,radius,6 
  radial xm,ym,rp10,350-roll,radius,7 
  radial xm,ym,rp15,45-roll,radius,8 
  radial xm,ym,rp15,315-roll,radius,9 
  line rx1(),ry1(),rx2(),ry2(),,rcol()
end sub 
' 
sub rotxy(xC as float, yC as float, angleD as float, x as float, y as float, xmaxot as integer, yrot as integer) 
  local float angle = rad(-angled) 
  local float s=sin(Angle),c=cos(Angle) 
  xmaxot = FIX(xC + c * (x - xC) - s * (y - yC)) 
  yRot = FIX(yC + s * (x - xC) + c * (y - yC)) 
end sub 
' 
' Routine to draw a radial to a circle 
' Parameters are:  
' x-coordinate of centre of circle  
' y-coordinate of centre of circle  
' radius of circle  
' radial of segment to be drawn (0-360 degrees)  
' colour to draw segment  
' inner radius for drawing radial lines, leave blank or set to zero if not required  
'  
Sub radial(x As integer, y As integer, o As integer, sr As integer, i as integer ,lpos as integer)  
  Local integer x1, x2, y1, y2 
  local float s=Sin(Rad(sr)) 
  local float c=-Cos(Rad(sr)) 
  rx2(lpos)=s*o + x  
  ry2(lpos)=c*o + y  
  rx1(lpos)=s*i + x 'i is 0 if not specified so a complete line from the centre is drawn  
  ry1(lpos)=c*i + y  
End Sub  
'  
function CohenSutherlandLineClip(x0 as float, y0 as float, x1 as float, y1 as float) as integer 
  ' compute outcodes for P0, P1, and whatever point lies outside the clip rectangle 
  local integer outcode0 = ComputeOutCode(x0, y0) 
  local integer outcode1 = ComputeOutCode(x1, y1) 
  local integer outcodeout 
  local float x,y 
     do while (1)  
          if (NOT(outcode0 OR outcode1)) then ' Bitwise OR is 0. Trivially accept and get out of loop 
               CohenSutherlandLineClip = 0 
               exit do       
          elseif (outcode0 AND outcode1) then 'Bitwise AND is not 0. Trivially reject and get out of loop 
      CohenSutherlandLineClip = (outcode0 AND outcode1) 
               exit do 
          else 
               ' failed both tests, so calculate the line segment to clip 
               ' from an outside point to an intersection with clip edge 
               ' At least one endpoint is outside the clip rectangle; pick it. 
      if outcode0 then 
        outcodeOut = outcode0  
      else 
        outcodeOut =  outcode1 
      endif 
               ' Now find the intersection point; 
               ' use formulas y = y0 + slope * (x - x0), x = x0 + (1 / slope) * (y - y0) 
               if (outcodeOut and C_TOP) then ' point is above the clip rectangle 
                    x = x0 + (x1 - x0) * (ymax - y0) / (y1 - y0) 
                    y = ymax 
               elseif (outcodeOut AND C_BOTTOM) then ' point is below the clip rectangle 
                    x = x0 + (x1 - x0) * (ymin - y0) / (y1 - y0) 
                    y = ymin 
               elseif (outcodeOut AND C_RIGHT) then ' point is to the right of clip rectangle 
                    y = y0 + (y1 - y0) * (xmin - x0) / (x1 - x0) 
                    x = xmax 
               elseif (outcodeOut AND C_LEFT) then' point is to the left of clip rectangle 
                    y = y0 + (y1 - y0) * (xmax - x0) / (x1 - x0) 
                    x = xmin 
               endif 
               ' Now we move outside point to intersection point to clip 
               ' and get ready for next pass. 
               if (outcodeOut = outcode0) then 
                    x0 = x 
                    y0 = y 
                    outcode0 = ComputeOutCode(x0, y0) 
               else  
                    x1 = x 
                    y1 = y 
                    outcode1 = ComputeOutCode(x1, y1) 
               endif 
          endif 
     loop 
end function 

function ComputeOutCode(x as float, y as float) as integer 
     ComputeOutCode = C_INSIDE      ' initialised as being inside of clip window 
     if (x < xmin)  then         ' to the left of clip window 
          ComputeOutCode =ComputeOutCode OR C_LEFT 
     elseif (x > xmax) then     ' to the right of clip window 
          ComputeOutCode =ComputeOutCode OR  RIGHT 
  endif 
     if (y < ymin)  then         ' below the clip window 
          ComputeOutCode =ComputeOutCode OR C_BOTTOM 
     elseif (y > ymax) then     ' above the clip window 
          ComputeOutCode =ComputeOutCode OR C_TOP 
  endif 
end function 
' 
CSub dcirch
    00000000
    27BDFF90 AFBF006C AFBE0068 AFB70064 AFB60060 AFB5005C AFB40058 AFB30054 
    AFB20050 AFB1004C AFB00048 8FB20080 8CD70000 8C840000 AFA40030 8E420000 
    00172023 8FA60030 00C2182A 8FBE0088 24060001 00D73023 AFA60028 00042040 
    AFA40038 8CF50000 8CA50000 1460017C AFA50034 8FC30000 8FA40030 0064182A 
    1060016A 8FA40084 8FA20034 02E21021 AFA20020 3C029D00 8C424048 AFB50010 
    8FA40030 8C590000 8FA50020 00803021 0320F809 00A03821 8E420000 8FA40030 
    0082182A 54600006 8FA20034 8FC30000 0064182A 10600165 8FA50084 8FA20034 
    00571023 AFA20024 3C029D00 8C424048 AFB50010 8FA40030 8C590000 8FA50024 
    00803021 0320F809 00A03821 8E420000 8FA30030 00778021 0202182A 5460000C 
    3C029D00 8FC30000 0070182A 54600008 3C029D00 8FA40084 8C830000 8FA50034 
    00A3182A 1060015D 8FA6008C 3C029D00 8C424048 AFB50010 02002021 8C590000 
    8FA50034 02003021 0320F809 00A03821 8E420000 8FA30030 00778823 0222102A 
    1440000C 3C029D00 8FC20000 0051102A 14400008 3C029D00 8FA30084 8C620000 
    8FA30034 0062102A 1040013D 8FA3008C 3C029D00 8C424048 AFB50010 02202021 
    8C590000 8FA50034 02203021 0320F809 00A03821 1AE00109 3C169D00 8FA20034 
    2454FFFF 24530001 24030001 AFA3002C 8FA30030 00621023 AFA2003C 8FA20028 
    0440000F 8FA30038 26F7FFFF 24630002 AFA30038 00431021 AFA20028 8FA20034 
    02E21021 AFA20020 8FA30034 00771823 AFA30024 8FA20030 00578021 00578823 
    8E420000 8FA3002C 00032840 8FA4003C 00931821 24A50001 0062202A 8FA6002C 
    AFA60040 8FA60028 00C53021 14800010 AFA60028 8FC40000 0083202A 5480000D 
    8EC24048 8FA50084 8CA40000 8FA60020 00C4202A 54800007 8EC24048 8FA5008C 
    8CA40000 0086202A 1080000D 0202202A 8EC24048 AFB50010 00602021 8C590000 
    8FA50020 00603021 00A03821 0320F809 AFA30044 8E420000 8FA30044 0202202A 
    54800010 8EC24048 8FC40000 0090202A 5480000C 8EC24048 8FA60084 8CC40000 
    0264202A 54800007 8EC24048 8FA5008C 8CA40000 0093202A 1080000D 0062202A 
    8EC24048 AFB50010 02002021 8C590000 02602821 02003021 02603821 0320F809 
    AFA30044 8E420000 8FA30044 0062202A 54800011 8EC24048 8FC40000 0083202A 
    5480000D 8EC24048 8FA60084 8CC40000 8FA50024 00A4202A 54800007 8EC24048 
    8FA6008C 8CC40000 0085202A 5080000B 0202182A 8EC24048 AFB50010 00602021 
    8C590000 8FA50024 00603021 0320F809 00A03821 8E420000 0202182A 54600010 
    8EC24048 8FC30000 0070182A 5460000C 8EC24048 8FA40084 8C830000 0283182A 
    54600007 8EC24048 8FA5008C 8CA30000 0074182A 1060000B 0222182A 8EC24048 
    AFB50010 02002021 8C590000 02802821 02003021 0320F809 02803821 8E420000 
    0222182A 54600010 8EC24048 8FC30000 0071182A 5460000C 8EC24048 8FA60084 
    8CC30000 0263182A 54600007 8EC24048 8FA4008C 8C830000 0073182A 1060000B 
    8FA5003C 8EC24048 AFB50010 02202021 8C590000 02602821 02203021 0320F809 
    02603821 8E420000 8FA5003C 02851821 0062202A 54800011 8EC24048 8FC40000 
    0083202A 5480000D 8EC24048 8FA60084 8CC40000 8FA50020 00A4202A 54800007 
    8EC24048 8FA6008C 8CC40000 0085202A 1080000D 0222202A 8EC24048 AFB50010 
    00602021 8C590000 8FA50020 00603021 00A03821 0320F809 AFA30044 8E420000 
    8FA30044 0222202A 54800010 8EC24048 8FC40000 0091202A 5480000C 8EC24048 
    8FA50084 8CA40000 0284202A 54800007 8EC24048 8FA6008C 8CC40000 0094202A 
    1080000D 0062102A 8EC24048 AFB50010 02202021 8C590000 02802821 02203021 
    02803821 0320F809 AFA30044 8E420000 8FA30044 0062102A 54400011 8EC24048 
    8FC20000 0043102A 5440000D 8EC24048 8FA40084 8C820000 8FA50024 00A2102A 
    54400007 8EC24048 8FA6008C 8CC20000 0045102A 5040000A 8FA30040 8EC24048 
    AFB50010 00602021 8C590000 8FA50024 00603021 0320F809 00A03821 8FA30040 
    0077102A 8FA3002C 24630001 AFA3002C 2694FFFF 1440FF01 26730001 8FBF006C 
    8FBE0068 8FB70064 8FB60060 8FB5005C 8FB40058 8FB30054 8FB20050 8FB1004C 
    8FB00048 03E00008 27BD0070 8C830000 8FA50034 00B72821 00A3202A 1480FE95 
    AFA50020 8FA6008C 8CC40000 0085202A 10800008 8FA40034 1000FE8F 3C029D00 
    02E51021 1000FE8B AFA20020 8CA30000 8FA40034 00972023 0083182A 1460FE9A 
    AFA40024 8FA5008C 8CA30000 0064182A 1060FEA0 8FA30030 1000FE94 3C029D00 
    8C620000 8FA30034 0043102A 1040FEC9 3C029D00 1000FEC0 8C424048 8CC30000 
    0065182A 1060FEAC 8FA30030 1000FEA0 3C029D00 
End CSub
