#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "../cfunctions.h"
//#define MX470
#define magic 0
#define t1pin 1
#define t1port 2
#define t1count 3
#define t1dwell 4
#define t1duration 5
//
void T1Int(void){
    PR1=CFuncRam[t1duration];
    *(volatile unsigned int *)CFuncRam[t1port]=CFuncRam[t1pin];
    if(!(CFuncRam[t1count]--)){
        mT1IntEnable(0);
        T1CON=0;
    }
}
void E2Int(void){
    CFuncRam[t1count]=1; //used to hold count of cycles
    PR1=CFuncRam[t1dwell];
    T1CON = 0x8010;         										// T5 on, prescaler as input
    mT1IntEnable(1);
}
__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) 
     { 
         *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;      
     } 

void main(long long *pin, long long *dwell, long long *duration){
    volatile unsigned int libAddr ; 
    getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor 
    getFPCLab: { } 
    int mydwell=*dwell, myduration=*duration, tickspersecond;
    tickspersecond=CurrentCpuSpeed/8; 
    if(*pin==0){
        mT1IntEnable(0);
        T1CON=0;
        CFuncInt2=NULL;
        CFuncT1=NULL;
        return;
    }
    if(!CFuncInt2){
        mT1IntEnable(0);  
        ExtCfg(*pin,EXT_DIG_OUT,0);
        CFuncRam[t1port]=(int)(volatile unsigned int *)GetPortAddr(*pin,LATINV);
        CFuncRam[t1pin]=1<<GetPinBit(*pin);
        PinSetBit(*pin, LATCLR);
        CFuncInt2=(unsigned int)&E2Int + libAddr;
        CFuncT1=(unsigned int)&T1Int + libAddr;
    } else while(T1CON);
    CFuncRam[t1count]=1; //used to hold count of cycles
    CFuncRam[t1dwell] = (mydwell*(tickspersecond/1000000)); //wait time in ticks
    CFuncRam[t1duration]=(myduration*(tickspersecond/1000000));
    mT1SetIntPriority(1);  											// high priority
    mT1ClearIntFlag();      										// clear interrupt flag
 }
