/**
 * Copyright (c) 2017, ?ukasz Marcin Podkalicki <lpodkalicki@gmail.com>
 * The ASM code is based on Ralph Doncaster's project (https://github.com/nerdralph/nerdralph/tree/master/avr/libs/bbuart)
 * Software UART for ATtiny13
 */

#include <avr/interrupt.h>
#include "uart.h"
#define BAUDRATE           19200
#if (CYCLES_PER_BIT > 255)
#define DIVISOR             8
#define PRESCALE            2
#else
#define DIVISOR             1
#define PRESCALE            1
#endif
#define FULL_BIT_TICKS      ( CYCLES_PER_BIT / DIVISOR )

void
uart_putc(char c)
{
#ifdef	UART_TX_ENABLED
	uint8_t sreg, i=8;
	sreg = SREG;
	cli();
	PORTB &= ~(1 << UART_TX); //start bit
	delayMicroseconds(26);
	while(i--){
		if(c & 1)PORTB |= 1 << UART_TX; //on bit
		else PORTB &= ~(1 << UART_TX); //off bit
		c >>=1;
		delayMicroseconds(26);
	}
	PORTB |= 1 << UART_TX; //stop bit
	delayMicroseconds(26);
	delayMicroseconds(26);
	SREG = sreg;
	sei();
#endif /* !UART_TX_ENABLED */
}

void
uart_puts(const char *s)
{
     	while (*s) uart_putc(*(s++));
}
