/*
  pins_arduino.c - pin definitions for the Arduino board
  Part of Arduino / Wiring Lite

  Copyright (c) 2005 David A. Mellis

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General
  Public License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA  02111-1307  USA

  $Id: pins_arduino.c 565 2009-03-25 10:50:00Z dmellis $

  Modified 28-08-2009 for attiny84 R.Wiersma
  Modified 09-10-2009 for attiny45 A.Saporetti
*/

#ifndef Pins_Arduino_h
#define Pins_Arduino_h

#include <avr/pgmspace.h>
// ATMEL ATTINY45 / ARDUINO
//
//                  +-\/-+
// Ain0 (D 5) PB5  1|    |8  Vcc
// Ain3 (D 3) PB3  2|    |7  PB2 (D 2)  Ain1
// Ain2 (D 4) PB4  3|    |6  PB1 (D 1) pwm1
//            GND  4|    |5  PB0 (D 0) pwm0
//                  +----+

#define TCCR1A GTCCR


// these arrays map port names (e.g. port B) to the
// appropriate addresses for various functions (e.g. reading
// and writing) tiny45 only port B 

#define NOT_ON_TIMER 0
#define TIMER0A 1
#define TIMER0B 2
#define TIMER1A 3
#define TIMER1B 4
#define INPUT 0x0
#define OUTPUT 0x1
#define INPUT_PULLUP 0x2
#define HIGH 0x1
#define LOW  0x0



const uint8_t PROGMEM digital_pin_to_timer_PGM[] = {
	TIMER0A, /* OC0A */
	TIMER0B,
	NOT_ON_TIMER,
	NOT_ON_TIMER,
	TIMER1B,
	NOT_ON_TIMER,
	NOT_ON_TIMER,
	NOT_ON_TIMER,
	NOT_ON_TIMER,
	NOT_ON_TIMER,
};
uint8_t digitalPinToTimer(uint8_t P){
	return ( (volatile uint16_t)pgm_read_byte( digital_pin_to_timer_PGM + (P) ) );
};
#define NOT_A_PIN 0
#define NOT_A_PORT 0
#define I2C_READ 0x01
#define I2C_WRITE 0x00

#define NOT_AN_INTERRUPT -1

#define analogInPinToBit(P) (P)
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif
#define dly() delayMicroseconds(5);
#define PI2C_SDA 3
#define PI2C_SCL 4
#define SDA_OFF (DDRB = DDRB | (1<<PI2C_SDA))
#define SDA_ON (DDRB = DDRB & ~(1<<PI2C_SDA))
#define SCL_OFF (DDRB = DDRB | (1<<PI2C_SCL))
#define SCL_ON (DDRB = DDRB & ~(1<<PI2C_SCL))
#define SDA_READ (PINB>>PI2C_SDA & 1)
#define SCL_READ (PINB>>PI2C_SCL & 1)
#define	UART_RX_ENABLED		(1) // Enable UART RX
#define	UART_TX_ENABLED		(1) // Enable UART TX

#ifndef F_CPU
# define        F_CPU           (16000000UL) // 1.2 MHz
#endif  /* !F_CPU */

#if defined(UART_TX_ENABLED) && !defined(UART_TX)
# define        UART_TX         PB1 // Use PB3 as TX pin
#endif  /* !UART_TX */

#if defined(UART_RX_ENABLED) && !defined(UART_RX)
# define        UART_RX         PB2 // Use PB4 as RX pin
#endif  /* !UART_RX */


void uart_putc(char c);
void uart_puts(const char *s);
extern volatile signed char uart_inchar;
extern void delayMicroseconds(unsigned int us);
#endif