  ' TassyJim Jun2020
  ' PS2 mouse to serial and I2C interface demo
  ' Arduino sends 4 bytes
  ' Button states - byte,X movement - signed byte,Y movement - signed byte, Wheel movement- signed byte
  '
  DIM INTEGER mouseX, mouseY, mouseW, mouseB, mouseR, mouseL, mouseM          ' mouse position and buttons
  DIM INTEGER mouseMove, mouseClick' flags to indicate changes
  '
  dim integer wiiX, wiiY, wiiB, wiiMove, wiiClick, wiiL, wiiM, wiiR, wiiPort = 1
  dim wwt$, mwt$
  '
  wii classic open wiiPort, checkWii
  OPEN "com1: 19200,256,mousetrap,4" AS #2 ' 19200 is the fastest that all Maximite/micromites can handle
  initM
  wiiX = MM.HRES/2
  wiiY = MM.VRES/2
  settick 100, checkWii '  we need to periodically check the xy values as interrupt only triggers for button change
  
  DO
    'IF INKEY$ = " " THEN initM ' might be needed if the mouse interface is interrupted.
    
    IF mouseMove = 1 or mouseClick = 1 THEN
      mouseL = mouseB AND 1
      mouseR = (mouseB AND 2)/2     ' extract the individual button states
      mouseM = (mouseB AND 4)/4
      IF mouseX < 0 THEN mouseX = 0 ' keep the pointer on the screen
      IF mouseY < 0 THEN mouseY = 0
      IF mouseX >= MM.HRES THEN mouseX = MM.HRES -1
      IF mouseY >= MM.VRES THEN mouseY = MM.VRES -1
      if mouseW < 0 then
        mwt$ = "-"
      elseif mouseW > 0 then
        mwt$ = "+"
      else
        mwt$ = " "
      endif
      TEXT 10,30, "Serial  "+STR$(mouseX,6,0)+STR$(mouseY,6,0)+"   "+mwt$+STR$(mouseL,3,0)+STR$(mouseM,2,0)+STR$(mouseR,2,0)
      mouseClick = 0
      mouseMove = 0
    ENDIF
    
    if wiiMove = 1 or wiiClick = 1 then
      wiiR = wiiB and 1 ' wii buttons
      wiiM = (wiiB >> 2) and 1
      wiiL = (wiiB >> 4) and 1
      wiiW = ((wiiB >> 1) and 1) - ((wiiB >> 3) and 1)
      if wiiX < 0 then wiiX = 0
      IF wiiY < 0 THEN wiiY = 0
      IF wiiX >= MM.HRES THEN wiiX = MM.HRES -1
      IF wiiY >= MM.VRES THEN wiiY = MM.VRES -1
      if wiiW < 0 then
        wwt$ = "-"
      elseif wiiW > 0 then
        wwt$ = "+"
      else
        wwt$ = " "
      endif
      TEXT 10,50, "I2C wii "+STR$(wiiX,6,0)+STR$(wiiY,6,0)+"   "+wwt$+STR$(wiiL,3,0)+STR$(wiiM,2,0)+STR$(wiiR,2,0)
      wiiMove = 0
      wiiClick = 0
    endif
  LOOP until inkey$ <>""
  wii classic close wiiPort
  CLOSE #2
  
SUB initM
  LOCAL j$
  j$ = INPUT$(255,#2) ' flush the serial buffer
  mouseX = MM.HRES/2
  mouseY = MM.VRES/2
  CLS
  text 10,10,"Device      X      Y   W  L M R"
END SUB
  
SUB mousetrap
  LOCAL INTEGER deltaB, deltaX, deltaY, deltaW
  local junk$
  deltaB = ASC(INPUT$(1,#2))  ' read 4 bytes
  deltaX = ASC(INPUT$(1,#2))
  deltaY = ASC(INPUT$(1,#2))
  deltaW = ASC(INPUT$(1,#2))
  junk$ = INPUT$(100,#2)      ' flush input buffer
  
  deltaB = deltaB AND 7
  IF deltaX > 127 THEN deltaX = deltaX - 256        ' signed 8 bit integers
  IF deltaY > 127 THEN deltaY = deltaY - 256
  IF deltaW > 127 THEN deltaW = deltaW - 256
  IF mouseB <> deltaB THEN                          '  buttons have changed
    mouseClick = 1                                  ' set the flag
    mouseB = deltaB                                 ' remember button states
  ENDIF
  IF deltaX <>0 OR deltaY <> 0 or deltaW <> 0 THEN  ' mouse has moved
    mouseMove = 1                                   ' set the flag
    mouseX = mouseX + deltaX
    mouseY = mouseY - deltaY
    mouseW = deltaW
  ENDIF
END SUB
  
sub checkWii
  local integer deltaB, deltaX, deltaY
  deltaX = classic(LX,wiiPort) - 124 ' adjust as required to remove drift
  deltaY = classic(LY,wiiPort) - 124
  deltaB = classic(B ,wiiPort)
  if deltaX <>0 or deltaY <> 0 then
    wiiMove = 1
    wiiX = wiiX + deltaX
    wiiY = wiiY - deltaY
  endif
  if wiiB <> deltaB then
    wiiClick = 1
    wiiB = deltaB
  endif
end sub