 OPTION EXPLICIT
 OPTION DEFAULT FLOAT
 MODE 1,8
 DIM INTEGER viewplane = 500
 CONST CAMERA = 1
 dim integer mouse_port, quit,oldlmb
 DIM q(4)
 DIM yaw=RAD(1),pitch=RAD(2),roll=RAD(0.5)
 DIM INTEGER nv=8, nf=6 ' cube has 8 vertices and 6 faces
 'array to hold vertices
 DIM v(2,nv-1)=(-1,1,-1,  1,1,-1, 1,-1,-1, -1,-1,-1, -1,1,1, 1,1,1, 1,-1,1,  -1,-1,1)
 MATH SCALE v(),100,v()
 ' array to hold number of vertices for each face
 DIM INTEGER fc(nf-1) =(4,4,4,4,4,4)
 DIM INTEGER cindex(9)=(RGB(RED),RGB(BLUE),RGB(GREEN),RGB(MAGENTA),RGB(YELLOW),RGB(CYAN),RGB(WHITE),RGB(BROWN),RGB(GRAY),0)
 DIM INTEGER fcol(nf-1)=(9,9,9,9,9,9)
 DIM INTEGER bcol(nf-1)=(0,1,2,3,4,5)
 'array to hold vertices for each face
 DIM INTEGER fv(MATH(sum fc())-1)=(1,5,6,2, 1,0,4,5,  0,3,7,4,  5,4,7,6, 2,6,7,3, 0,1,2,3)
 DRAW3D CREATE 1, nv, nf, CAMERA, v(), fc(), fv(),cindex(),fcol(),bcol()
 DIM INTEGER camx, camy
 DIM FLOAT inc_yaw, inc_pitch, inc_roll, inc_view
 cls
 mouse_port = mm.info(option mouse)
 if mouse_port = -1 then ' no mouse set
   mouse_port = 0 ' assume PS/2 mouse - change to suit
 else
   print "Mouse port ";mouse_port
   pause 2000
 endif
 PAGE WRITE 1
 CLS
 CONTROLLER MOUSE OPEN mouse_port
 '
 GUI CURSOR ON 1,MOUSE(x,mouse_port), MOUSE(y,mouse_port)
 BOX 0,0,MM.HRES-1,MM.VRES-1
 camx = MM.HRES/2 - MOUSE(x,mouse_port)
 camy = MOUSE(y,mouse_port) - MM.VRES/2
 inc_yaw = 0
 inc_pitch = 0
 inc_roll = 0
 DO
   IF MOUSE(w,mouse_port) THEN                    ' wheel button > reset box position
     camx = MM.HRES/2 - MOUSE(x,mouse_port)
     camy = MOUSE(y,mouse_port) - MM.VRES/2
     inc_yaw = 0
     inc_pitch = 0
     inc_roll = 0
     viewplane = 500
     yaw=RAD(1):pitch=RAD(2):roll=RAD(0.5)
   ELSEIF MOUSE(r,mouse_port) THEN                ' right mouse button > camera movement
     camx = MM.HRES/2 - MOUSE(x,mouse_port)
     camy = MOUSE(y,mouse_port) - MM.VRES/2
   ELSEIF MOUSE(L,mouse_port) THEN                ' left mouse button > roll
     IF oldlmb = 0 THEN ' left button just pressed.
       if MOUSE(x,mouse_port)> mm.hres-40 and MOUSE(y,mouse_port)<18 then quit = 1
       oldlmb = 1
     ENDIF
     inc_roll = (MM.HRES/2 - MOUSE(x,mouse_port))/4000
     'viewplane = MAX(viewplane + (MOUSE(y)-MM.VRES/2)/50,0)
   ELSE                                ' no button pressed > yaw and pitch
     oldlmb = 0
     inc_yaw = (MOUSE(x,mouse_port)-MM.HRES/2)/4000
     inc_pitch = (MM.VRES/2-MOUSE(y,mouse_port))/4000
   ENDIF
   inc_view = MOUSE(S,mouse_port)
   viewplane = MAX(viewplane + inc_view ,0) ' scroll > zoom
   '
   DRAW3D CAMERA 1,viewplane,camx,camy
   MATH Q_CREATE roll,1,1,1,q()
   DRAW3D SHOW 1,0,0,1000
   MATH Q_EULER yaw,pitch,roll,q()
   DRAW3D ROTATE q(),1
   
   TEXT 10,10,"Yaw  "+STR$(yaw,3,3)+" "+CHR$(241)+STR$(inc_yaw,3,3)
   TEXT 10,30,"Pitch"+STR$(pitch,3,3)+" "+CHR$(241)+STR$(inc_pitch,3,3)
   TEXT 10,50,"Roll "+STR$(roll,3,3)+" "+CHR$(241)+STR$(inc_roll,3,3)
   TEXT 10,70,"VP   "+STR$(viewplane,7,0)+" "+CHR$(241)+STR$(inc_view,3,0)
   text mm.hres - 40,5,"QUIT",LT,1,1,rgb(red),rgb(white)
   
   INC yaw,inc_yaw
   INC pitch,inc_pitch
   INC roll,inc_roll
   PAGE COPY 1 TO 0,b
   if MOUSE(y,mouse_port) < 100 then
     pause 20 ' needed to alow the cursor to show in the top section of the display
   endif
   GUI CURSOR MOUSE(x,mouse_port), MOUSE(y,mouse_port)
 LOOP UNTIL quit = 1
 ' tidy up
 DRAW3D CLOSE ALL
 CONTROLLER MOUSE CLOSE mouse_port
 GUI CURSOR OFF
 CLS
 PAGE WRITE 0
 CLS