
option Explicit

dim DeviceIP$, XData, Dot(3), intX, IPV4$(4), IPCodeKey$, Raw_Inp1$, Raw_Inp2$, EncOut$, DecOut$, XorVal_1, XorVal_2

' DeviceIP$ is the local device IP Number which is 4 bytes
' Example: 192.168.10.1
' Therfore the IPCodeKey$ is a byte value, with traling zero of Hex$(192,2) + Hex$(168,2) + Hex$(10,2) + hex$(1,2)
' intX = General purpose counter to determine "." position in Ip string
' Dot(intX)= "." position in IP string from start of string
' IPV4$(x) is the 4 segments of the IP string in Hex Value converted to 4 seperate group of string
' IPCodeKey$= Encryption / Decryption Key utilizing the local device IPV4 IP Segments
' Raw_Inp1$= Raw Data packet from the user to the outbound network datagram
' Raw_Inp2$= Raw Data packet from the inbound network datagram to the user
' EncOut$=  Encrypted Data Output
' DecOut$=  Decrypted Data Input
' XorVal_1= Ascii value of the string/byte data to be Encryptrd/Decrypted
' XorVal_2= Ascii value of the IPCodeKeys$ combined with the modulos of IPCodeKey$ length



  DeviceIP$="192.168.100.10"  ' Device IP Number is the Pseudo Encrytion / Decryption Key in IPV4 format
  
  Raw_Inp1$= "1234567890ABCDEF"  ' User Outbound Protocol data sample in alphanumeric, any lenght



  For XData=1 to len(DeviceIP$)
    
    if mid$(DeviceIP$,XData,1)="." Then 
      intX=intX+1   ' General purpose counter to determine "." position in Ip string
      Dot(intX)=XData ' "." position in IP string from start of string
    end if
    
  next XData
  
  
  'IPV4$(x) is the 4 segments of the IP string in Hex Value converted to 4 seperate group of string
  
  IPV4$(1)=hex$(VAL(MID$(DeviceIP$, 1, Dot(1)-1)), 2)
  IPV4$(2)=hex$(VAL(mid$(DeviceIP$, Dot(1)+1, Dot(2)-Dot(1)-1)), 2)
  IPV4$(3)=hex$(val(mid$(DeviceIP$, Dot(2)+1, Dot(3)-Dot(2)-1)), 2)
  IPV4$(4)=Hex$(val(mid$(DeviceIP$, Dot(3)+1, len(DeviceIP$)-Dot(3))), 2)
  
  
  ' IPCodeKey$ is the Encrypt / Decrypt Key string 
 
  for XData=1 to 4
    IPCodeKey$=IPCodeKey$ + IPV4$(XData)
  next XData

  print ""
  print ""
  
  
  print "Data Encryption --------------------------------------------"
  print ""

'--------------------------------------------------------------------
' Data Encryption-----------------------------------------------------
 
  for XData= 1 to len(Raw_Inp1$)
    XorVal_1= asc(mid$(Raw_Inp1$,XData,1))
    XorVal_2= asc(mid$(IPCodeKey$,(XData mod len(IPCodeKey$))+1,1))
    EncOut$=EncOut$+chr$(XorVal_1 xor XorVal_2)
  next XData
  
  
  Print "Device IP : ";DeviceIP$
  print "IPCodeKey : ";IPCodeKey$
  print ""
  print "Outbound Protocol Data String : ";Raw_Inp1$
  print "Outbound Data Lenght : ";len(Raw_Inp1$)
  print ""
  print "Encrypted Protocol Data as a serial string: ";EncOut$
  Print "Encrypted Protocol Data as a serial byte ASCii code: ";
  
  for XData= 1 to len(EncOut$)
    print asc(mid$(EncOut$,XData,1));",";
  next XData
  print ""
  
  print "Encrypted Protocol Serial Byte Data : ";
  for XData= 1 to len(EncOut$)
    print hex$(asc(mid$(EncOut$,XData,1)),2);",";
  next XData
  print ""
  
  print "Outbound Encrypted Data Lenght : ";len(EncOut$)
  print ""
  print ""
  print ""
  print ""
  
'-----------------------------------------------------------------------  
' Data Decryption-------------------------------------------------------  
  
  print "Data Decryption --------------------------------------------"
  print ""

  Raw_Inp2$=EncOut$
  for XData= 1 to len(Raw_Inp2$)
    XorVal_1= asc(mid$(Raw_Inp2$,XData,1))
    XorVal_2= asc(mid$(IPCodeKey$,(XData mod len(IPCodeKey$))+1,1))
    DecOut$=DecOut$+chr$(XorVal_1 xor XorVal_2)
  next XData
  
  Print "Device IP : ";DeviceIP$
  print "IPCodeKey : ";IPCodeKey$
  print ""
  print "Inbound Encrypted Protocol Data String : ";Raw_Inp2$
  print "Inbound Data Lenght : ";len(Raw_Inp2$)
  print ""
  print "Decrypted Data as a serial string: ";DecOut$
  Print "Deccrypted Data as a serial ASCii code: ";
  
  for XData= 1 to len(DecOut$)
    Print asc(mid$(DecOut$,XData,1));",";
  next XData
  print ""
  
  print "Decrypted Protocol Data as serial byte : ";
  for XData= 1 to len(DecOut$)
    print hex$(asc(mid$(DecOut$,XData,1)),2);",";
  next XData
  print ""
  
  print "Inbound Decrypted Data Lenght : ";len(DecOut$)
  print ""
  print ""
  print ""
  print ""
  