'RTTTL Player for Micromite using PWM pin.  Pin 4.
'By Peter Vane - a development of an original program from Jeff Ledger
'Enhancements include full support for a typical RTTTL string and the use
'of DATA statements for the RTTTL strings. Also made good use of the new CASE statement
Option default none
Option explicit
'===========================
'Constants declared here
'===========================
Const true = 1, false = 0 'it's a convention!

'===========================
'Vars declared here
'===========================
Dim As string Data_item$
Dim As string g$, song$, nte$, fullnte$
Dim As integer songptr, songtotal, colonpos, song_name
Dim As integer pointer, length, duration, notedur, octave
Dim As integer header_check, ok_to_play
Dim As integer colon_flg, comma_flg, equal_flg, eos_flg, dot_flg
Dim As integer dur_default,oct_default,beat_default

Dim As float note, period,period2,period4,period8,period16,period32
Dim As float this_period

'Data statements containing complete RTTTL strings
Data "Adams Family:d=4,o=5,b=160:8c,f,8a,f,8c,b4,2g,8f,e,8g,e,8e,a4,2f,8c,f,8a,f,8c,b4,2g,8f,e,8c, d,8e,1f,8c,8d,8e,8f,1p,8d,8e,8f#,8g,1p,8d,8e,8f#,8g,p,8d,8e,8f#,8g,p,8c,8d,8e,8f#"
Data "Agadoo:d=4,o=5,b=160:8b,8g#,e,8e,8e,e,8e,8e,8e,8e,8d#,8e,f#,8a,8f#,d#,8d#,8d#,d#,8d#,8d#,8d#,8d#,8c#,8d#,e"
Data "Bolero:d=4,o=5,b=80:c6,8c6,16b,16c6,16d6,16c6,16b,16a,8c6,16c6,16a,c6,8c6,16b,16c6,16a,16g,16e,16f,2g,16g,16f,16e,16d,16e,16f,16g,16a,g,g,16g,16a,16b,16a,16g,16f,16e,16d,16e,16d,8c,8c,16c,16d,8e,8f,d,2g"
Data "The Simpsons:d=4,o=5,b=160:c6.,e6,f#6,8a6,g6.,e6,c6,8a,8f#,8f#,8f#,2g,8p,8p,8f#,8f#,8f#,8g,a#.,8c6,8c6,8c6,c6"
Data "The Entertainer:d=4,o=5,b=140:8d,8d#,8e,c6,8e,c6,8e,2c6.,8c6,8d6,8d#6,8e6,8c6,8d6,e6,8b,d6,2c6,p,8d,8d#,8e,c6,8e,c6,8e,2c6.,8p,8a,8g,8f#,8a,8c6,e6,8d6,8c6,8a,2d6"
Data "Looney Tunes:d=4,b=140:32p,c6,8f6,8e6,8d6,8c6,a.,8c6,8f6,8e6,8d6,8d#6,e.6,8 e6,8e6,8c6,8d6,8c6,8e6,8c6,8d6,8a,8c6,8g,8a#,8a,8f"
Data "MASH:d=4,b=250:4a,4g,f#,g,p,f#,p,g,p,f#,p,2e.,p,f#,e,4f#,e,f#,p,e,p ,4d.,p,f#,4e,d,e,p,d,p,e,p,d,p,2c#.,p,d,c#,4d,c#,d,p,e,p,4f# ,p,a,p,4b,a,b,p,a,p,b,p,2a.,4p,a,b,a,4b,a,b,p,2a.,a,4f#,a,b, p,d6,p,4e.6,d6,b,p,a,p,2b"
Data "The Smurfs:d=4,b=250:4c#6,16p,4f#6,p,16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,1 6a#,p,8f#,p,8a#,p,4g#,4p,g#,p,a#,p,b,p,c6,p,4c#6,16p,4f#6,p, 16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,16a#,p,8b,p,8f,p,4f#"
Data "End"

songtotal = No_of_Songs()
Dim As string songs$(songtotal), songname$(songtotal)

make_songlist songs$(), songname$()


While (g$ <>"X")
  print_songlist songname$(), songtotal

  Input "Enter Your Selection: ";g$
  songptr = Val(g$) - 1
  If (songptr >= 0 And songptr < songtotal) Then

    'first job is to read off the header data
    Data_item$ = songs$(songptr)    'pick up the next song string
    pointer = 1
    HeaderLoad Data_item$
    ok_to_play = true 'allow the run through first time
    While (eos_flg = false)
      StringPair Data_item$ 'returns duration, note, octave, dot_flg
      note = adjust_for_octave(note, octave)
      this_period = adjust_for_dotting(duration)
      While (ok_to_play = false)
      'do nothing while we wait for the last note to finish
      Wend
'      Print fullnte$;" ";
      If note > 0 Then
        PWM 1, note, 50
      Else
        PWM 1,STOP
      EndIf
      ok_to_play = false
      SetTick this_period,chk_time ,1   'set up the timer for the current note
    Wend
    While (ok_to_play = false)
    'do nothing while we wait for the very last note to finish
    Wend
    PWM 1,STOP
    Pause 500
  Else
    Print "Entry Error!"
  EndIf
Wend
Exit


'==============================
'Subroutines below here
'==============================
chk_time:
  PWM 1,STOP
'  Pause ntepause 'just a little pause between notes
  ok_to_play = true
IReturn

Sub Make_songlist (songs$(),sname$())
Local string data$
Local integer ptr, colonpos
Restore

  ptr = 0 : Data$ = ""
  While(data$ <> "End")
    Read data$
    If data$ <> "End" Then
      songs$(ptr) = data$
      colonpos = Instr(data$,":") - 1
      sname$(ptr) = Left$(data$,colonpos)
      ptr = ptr + 1
    EndIf
  Wend

End Sub

Sub Print_songlist (sname$() As string, stot As integer)
Local integer ptr
  Print
  Print "Song List"
  Print "========="
  Print
  For ptr= 0 To stot - 1
    Print ptr + 1;". ";sname$(ptr)
  Next ptr
  Print
End Sub

Sub HeaderLoad (data$ As string)
Local integer header_check = 0, v1
Local string d$

  'these are the standard settings for RTTTL
  dur_default = 4 : oct_default = 6 : beat_default = 63
  While (header_check < 2 )
    d$ = GetItem$(data$,pointer)
 '   Print "Item: ";d$;" pointer: ";pointer
 '   Input g$
    If (colon_flg And header_check = 0) Then
     'must be the song name
     ' songptr = songptr + 1
     ' songname$(songptr) = d$
      Print
      Print "Song is: ";songname$(songptr)
    EndIf
    If colon_flg Then header_check = header_check + 1
    If equal_flg Then
     v1 = Val(GetItem$(data$,pointer)) 'grab the value
     Select Case trim$(d$)
      Case "d","D"
       dur_default = v1
      Case "o","O"
       oct_default = v1
      Case "b","B"
       beat_default = v1
     End Select
     If colon_flg Then header_check = header_check + 1
     If header_check = 2 Then
    Print "Defaults duration: ";dur_default;
    Print " Octave: ";oct_default;" Beats: ";beat_default
      period = (60 / beat_default) * 4
      period32 = period / 32    'smallest note timing
      period16 = period / 16
      period8 = period / 8
      period4 = period / 4
      period2 = period / 2
      period32 = (period32 * 1000)   'rounded in millisecs
      period16 = (period16 * 1000)
      period8 = (period8 * 1000)
      period4 = (period4 * 1000)
      period2 = (period2 * 1000)
      period = (period * 1000)
'      Print " Period: ";period
 '     Print " 2: ";period2;" 4: ";period4;" 8 ";period8;" 16 ";period16;
  '    Print " 32: ";period32
    EndIf
    EndIf
  Wend
End Sub

Sub StringPair (data$ As string)
Local integer chrs1,o1
Local string sp$

  sp$ = trim$(GetItem$(data$,pointer))
  fullnte$ = sp$
  chrs1 = Instr(sp$,"e")
  'Unfortunately something like "8e6" is interpreted by VAL command
  'as a valid number...that's why the following line is needed
  If chrs1 > 0 Then sp$ = Replace$(sp$,"z",chrs1) 'swap out the e
 ' Print "Before: ";sp$
  o1 = Val(sp$)
  If chrs1 > 0 Then sp$ = Replace$(sp$,"e",chrs1) 'swap the e back in
 ' Print "After: ";sp$
  Select Case o1
    Case 1,2,4,8,16,32
      duration = o1
    Case Else
      duration = dur_default
  End Select
  If o1 > 0 Then
    chrs1 = Len(Str$(o1))
    sp$ = Right$(sp$,Len(sp$) - chrs1) 'discard the duration part of the string
  EndIf
  If Instr(sp$,"#") Then    'check for sharp pitch
    chrs1 = 2
  Else
    chrs1 = 1
  EndIf
  nte$ = Left$(sp$,chrs1)
  note = SetNote(nte$)
  sp$ = Right$(sp$,Len(sp$) - chrs1)  'discard the note part of the string
  dot_flg = false
  If Len(sp$) = 0 Then
    octave = oct_default
  Else
    o1 = Val(sp$)
    Select Case o1
    Case 4,5,6,7
      octave = o1
    Case Else
      octave = oct_default
    End Select
    If Instr(sp$,".") Then
        dot_flg = true
    EndIf
  EndIf

End Sub


'=========================
'Functions below here
'=========================

'function to return the next item out of the data string
'also sets global flag depending on whether it was a colon or comma or equals

Function GetItem$( d$ , ptr As integer ) As string
Local integer p1,p2,p3,str_len,pmin

  colon_flg = false : comma_flg = false : equal_flg = false
  eos_flg = false
  p1 = Instr(ptr,d$,":")
  p2 = Instr(ptr,d$,",")
  p3 = Instr(ptr,d$,"=")
'  Print ": ";p1;" , ";p2;" = ";p3
  If (p1+p2+p3 = 0) Then
   str_len = Len(d$)
   GetItem$ = Right$(d$,str_len - ptr + 1)  'maybe the last item just return it
   ptr = str_len
   eos_flg = true
  Else
    pmin = Min(p1,p2,p3)
 '   Print "pmin: ";pmin
    If pmin = p1 Then colon_flg = true
    If pmin = p2 Then comma_flg = true
    If pmin = p3 Then equal_flg = true
    GetItem$ = Mid$(d$,ptr,pmin - ptr)
    ptr = pmin + 1
  EndIf

End Function

Function SetNote(tone$ As string) As float
Local float n1

  Select Case tone$
  Case "a"
    n1 = 440
  Case "a#"
    n1 = 466.08
  Case "b"
    n1 = 493
  Case "c"
    n1 = 261.63
  Case "c#"
    n1 = 277.18
  Case "d"
    n1 = 293.66
  Case "d#"
    n1 = 311.13
  Case "e"
    n1 = 329.63
  Case "f"
    n1 = 349.23
  Case "f#"
    n1 = 369.13
  Case "g"
    n1 = 392
  Case "g#"
    n1 = 415.30
  Case "p"
    n1 = 0
  End Select

  SetNote = n1
End Function

Function Adjust_for_Octave(nte As float, oct1 As integer) As float

   Select Case oct1
   Case 5
    nte = nte * 2
   Case 6
    nte = nte * 4
   Case 7
    nte = nte * 8
   End Select
   Adjust_for_Octave = nte

End Function

Function Adjust_for_Dotting(dur1 As integer) As integer
Local integer p1

   Select Case dur1
   Case 1
    p1 = period
    If dot_flg = true Then p1 = p1 + period2
   Case 2
    p1 = period2
    If dot_flg = true Then p1 = p1 + period4
   Case 4
    p1 = period4
    If dot_flg = true Then p1 = p1 + period8
   Case 8
    p1 = period8
    If dot_flg = true Then p1 = p1 + period16
   Case 16
    p1 = period16
    If dot_flg = true Then p1 = p1 + period32
   Case 32
    p1 = period32
    If dot_flg = true Then p1 = p1 + period32/2
   End Select

   Adjust_for_Dotting = p1

End Function

Function trim$(d$ As string) As string
Local integer pos1
Local string trimmed$, templ$, tempr$
  pos1 = 1
  trimmed$ = d$
  While (pos1 <> 0)
    pos1 = Instr(pos1,trimmed$," ")
    If pos1 > 0 Then
      templ$ = Left$( trimmed$, pos1 - 1 )
      tempr$ = Right$( trimmed$, Len( trimmed$ ) - pos1 )
      trimmed$ = templ$ + tempr$
    EndIf
  Wend
  trim$ = trimmed$

End Function

Function Replace$(d$ As string, e$ As string, p1 As integer) As string
Local string templ$, tempr$
Local integer l1,l2

  l1 = Len(e$)
  templ$ = Left$(d$,p1 - 1)
  l2 = Len(d$) - p1 - l1 + 1
  If l2 > 0 Then
    tempr$ = Right$(d$,l2)
  Else
    tempr$ = ""
  EndIf
  Replace$ = templ$ + e$ + tempr$

End Function

Function Min(p1 As integer,p2 As integer,p3 As integer) As integer
 If p1 = 0 Then p1 = 20000
 If p2 = 0 Then p2 = 20000
 If p3 = 0 Then p3 = 20000
 If p1 < p2 Then
  If p1 < p3 Then
   Min = p1
  Else
   Min = p3
  EndIf
 Else
  If p2 < p3 Then
   Min = p2
  Else
   Min = p3
  EndIf
 EndIf
End Function

Function No_of_Songs() As integer
Local integer ptr
Local string data$
  While(data$ <> "End")
    Read data$
    If data$ <> "End" Then
      ptr = ptr + 1
    EndIf
  Wend
  No_of_Songs = ptr
End Function                                                                  