'Concentration
option base 1
dim string card$(104) length 3, grid$(104) length 3
dim string rank$ length 2, suit$ length 1, card_file$(104) length 40, again$
dim integer i, j, k, r, rx, ry, x, y, initial, num_cards, data_num
dim integer version, card_selected(104) 'values 0 = not selected yet, 1 = selected
dim integer gx, gy, sc1, sc2, card_faceup(104) 'values 0 = turned over, 1 = face up
dim integer wrong_guesses
dim string v1$(2) length 10 = (" 75x114", " 61x94")
dim integer v2(2) = (78, 63)
dim integer v3(2) = (117, 96)
dim integer v4(2) = (5, 0)
dim integer v5(5) = (31, 18, 10, 23, 12)
dim integer v6(3) = (46, 34, 32)
dim integer v7(2) = (16, 840)
dim integer v8(2) = (500, 20)
dim integer v9(3) = (524, 40, 60)
dim integer v10(2) = (3, 2)
mode 9, 16
font 3 '16x24
color rgb(orange)
initial = 0 : rank$ = "" : suit$ = ""
'Initialize array
for i = 1 to 104
  card$(104) = ""
next i
main()

sub main()
  cls
  text 16,  24, "Concentration"
  text 16,  72, "1. One deck, match diamonds with hearts for each rank"
  text 16,  96, "             match clubs with spades for each rank"
  text 16, 120, "2. Two decks, match clone cards"
  text 16, 168, "Which version (1 or 2)"
  text 16, 192, ""
  do
    input version
    if version < 1 or version > 2 then continue do
    exit do
  loop
  cls

  'Initialize arrays
  for i = 1 to 104
    grid$(i) = ""
    card_selected(i) = 0
    card_file$(i) = ""
    card_faceup(i) = 0
  next i 
  wrong_guesses = 0

  if initial = 0 then
    do
      read data_num, rank$, suit$    
      if data_num = 0 then
        inc num_cards, -1
        exit do
      endif
      inc num_cards
      card$(num_cards) = rank$ + suit$
      card$(num_cards + 52) = rank$ + suit$
    loop
    initial = 1
  endif

  'Randomly select cards and place them on the grid face up
  for i = 1 to 52 * version
    do
      r = int(rnd * 52 * version + 1)
      if card_selected(r) = 1 then continue do
      card_selected(r) = 1
      grid$(i) = card$(r)
      card_file$(i) = "graphics/" + card$(r) + v1$(version)
      exit do
    loop
  next i
  for y = 1 to 4 * version
    for x = 1 to 13
      page write 1
      load png card_file$(13 * (y - 1) + x), v2(version) * (x - 1) + 5, v3(version) * (y - 1) + v4(version)
    next x
  next y  
  page copy 1 to 0, B
  page write 0
  if version = 1 then
    text 16, 540, "Press ENTER key when ready..."
  else 'version = 2
    text 840, 20, "Press ENTER"
    text 840, 40, "when ready"
  endif
  
  'After user presses Enter, display the grid cards face down and place numbers on backs of cards
  do
    if keydown(1) = 10 then 'Enter key
      pause 125
      color rgb(black)
      if version = 1 then
        font 5
        for y = 1 to 4 * version
          for x = 1 to 13
            card_file$(13 * (y - 1) + x) = "graphics/red_back" + v1$(version)
            page write 1
            load png card_file$(13 * (y - 1) + x), v2(version) * (x - 1) + 5, v3(version) * (y - 1) + v4(version)
            if y = 1 and x < 10 then 'One digit number
              print @(v2(version) * (x - 1) + v5(1), v3(version) * (y - 1) + v6(1), 1) str$(13 * (y - 1) + x)
            else
              print @(v2(version) * (x - 1) + v5(2), v3(version) * (y - 1) + v6(1), 1) str$(13 * (y - 1) + x)
            endif
          next x
        next y              
      else 'version = 2
        for y = 1 to 4 * version
          for x = 1 to 13
            card_file$(13 * (y - 1) + x) = "graphics/red_back" + v1$(version)
            page write 1
            load png card_file$(13 * (y - 1) + x), v2(version) * (x - 1) + 5, v3(version) * (y - 1) + v4(version)            
            if y = 8 and x > 8 then 'Three digit number
              font 3
              print @(v2(version) * (x - 1) + v5(3), v3(version) * (y - 1) + v6(2), 1) str$(13 * (y - 1) + x)
            elseif y = 1 and x < 10 then 'One digit number
              font 5
              print @(v2(version) * (x - 1) + v5(4), v3(version) * (y - 1) + v6(3), 1) str$(13 * (y - 1) + x)
            else
              font 5
              print @(v2(version) * (x - 1) + v5(5), v3(version) * (y - 1) + v6(3), 1) str$(13 * (y - 1) + x)
            endif
          next x
        next y
      endif
      page copy 1 to 0, B
      cls '***
      page write 0
      for i = 1 to 52 * version
        card_faceup(i) = 0
      next i
      exit do
    endif
  loop

  do
    color rgb(orange) 
    'Player selects first of two cards
    if version = 1 then
      font v10(version)
      text v7(version), v8(version), "Select Card 1 of 2"
      do
        text v7(version), v9(1), "        "
        text v7(version), v9(1), ""
        input sc1
        if sc1 < 1 or sc1 > 52 * version then continue do
        if card_faceup(sc1) = 1 then continue do      
        'Turn the selected card face up
        card_file$(sc1) = "graphics/" + grid$(sc1) + v1$(version)
        gx = choice(sc1 mod 13 = 0, 13, sc1 mod 13)
        gy = choice(sc1 mod 13 = 0, fix(sc1 / 13), fix(sc1 / 13) + 1)
        load png card_file$(sc1), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)
        card_faceup(sc1) = 1 
        exit do
      loop
    else 'version = 2
      font v10(version)
      text v7(version), v8(version), "Select"
      text v7(version), v9(2), "Card 1 of 2"
      do
        text v7(version), v9(3), "        "
        text v7(version), v9(3), ""
        input sc1
        if sc1 < 1 or sc1 > 52 * version then continue do
        if card_faceup(sc1) = 1 then continue do
        card_file$(sc1) = "graphics/" + grid$(sc1) + v1$(version)
        gx = choice(sc1 mod 13 = 0, 13, sc1 mod 13)
        gy = choice(sc1 mod 13 = 0, fix(sc1 / 13), fix(sc1 / 13) + 1)
        load png card_file$(sc1), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)
        card_faceup(sc1) = 1
        exit do
      loop
    endif

    'Player selects second of two cards
    if version = 1 then
      font v10(version)
      text v7(version), v8(version), "                  "
      text v7(version), v8(version), "Select Card 2 of 2"
      do
        text v7(version), v9(1), "        "
        text v7(version), v9(1), ""
        input sc2
        if sc2 < 1 or sc2 > 52 * version then continue do
        if card_faceup(sc2) = 1 then continue do
        card_file$(sc2) = "graphics/" + grid$(sc2) + v1$(version)
        gx = choice(sc2 mod 13 = 0, 13, sc2 mod 13)
        gy = choice(sc2 mod 13 = 0, fix(sc2 / 13), fix(sc2 / 13) + 1)
        load png card_file$(sc2), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)      
        card_faceup(sc2) = 1
        exit do
      loop
    else 'version = 2
      font v10(version)
      text v7(version), v8(version), "Select"
      text v7(version), v9(2), "           "
      text v7(version), v9(2), "Card 2 of 2"
      do
        text v7(version), v9(3), "        "
        text v7(version), v9(3), ""
        input sc2
        if sc2 < 1 or sc2 > 52 * version then continue do
        if card_faceup(sc2) = 1 then continue do
        card_file$(sc2) = "graphics/" + grid$(sc2) + v1$(version)
        gx = choice(sc2 mod 13 = 0, 13, sc2 mod 13)
        gy = choice(sc2 mod 13 = 0, fix(sc2 / 13), fix(sc2 / 13) + 1)
        load png card_file$(sc2), v2(version) * (gx - 1) + 5), v3(version) * (gy - 1) + v4(version)
        card_faceup(sc2) = 1
        exit do
      loop
    endif

    'Do we have a match?  If not, then place both cards face down.
    pause 1000
    if version = 1 then
      do
        if left$(grid$(sc1), 1) <> left$(grid$(sc2), 1) then face_down() : exit do
        if right$(grid$(sc1), 1) = "D" and right$(grid$(sc2), 1) <> "H" then face_down() : exit do
        if right$(grid$(sc1), 1) = "H" and right$(grid$(sc2), 1) <> "D" then face_down() : exit do
        if right$(grid$(sc1), 1) = "C" and right$(grid$(sc2), 1) <> "S" then face_down() : exit do
        if right$(grid$(sc1), 1) = "S" and right$(grid$(sc2), 1) <> "C" then face_down() : exit do
        exit do
      loop
    else
      if grid$(sc1) <> grid$(sc2) then face_down()
    endif    

    'Have all cards been matched?
    do
      for i = 1 to 52 * version
        if card_faceup(i) = 0 then exit do
      next i
      ending()
    loop    
  loop
end sub
  
sub face_down
  inc wrong_guesses
  color rgb(black)
  if version = 1 then
    font 5
    card_file$(sc1) = "graphics/red_back" + v1$(version)
    gx = choice(sc1 mod 13 = 0, 13, sc1 mod 13)
    gy = choice(sc1 mod 13 = 0, fix(sc1 / 13), fix(sc1 / 13) + 1) 
    load png card_file$(sc1), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)
    card_faceup(sc1) = 0
    'Put the number back on the backside of the card
    if sc1 < 10 then 'One digit number
      print @(v2(version) * (gx - 1) + v5(1), v3(version) * (gy - 1) + v6(1), 1) str$(13 * (gy - 1) + gx)
    else 'Two digit number
      print @(v2(version) * (gx - 1) + v5(2), v3(version) * (gy - 1) + v6(1), 1) str$(13 * (gy - 1) + gx)
    endif
    card_file$(sc2) = "graphics/red_back" + v1$(version)
    gx = choice(sc2 mod 13 = 0, 13, sc2 mod 13)
    gy = choice(sc2 mod 13 = 0, fix(sc2 / 13), fix(sc2 / 13) + 1) 
    load png card_file$(sc2), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)
    card_faceup(sc2) = 0
    if sc2 < 10 then
      print @(v2(version) * (gx - 1) + v5(1), v3(version) * (gy - 1) + v6(1), 1) str$(13 * (gy - 1) + gx)
    else 
      print @(v2(version) * (gx - 1) + v5(2), v3(version) * (gy - 1) + v6(1), 1) str$(13 * (gy - 1) + gx)
    endif
  else
    card_file$(sc1) = "graphics/red_back" + v1$(version)
    gx = choice(sc1 mod 13 = 0, 13, sc1 mod 13)
    gy = choice(sc1 mod 13 = 0, fix(sc1 / 13), fix(sc1 / 13) + 1)
    load png card_file$(sc1), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version) 
    card_faceup(sc1) = 0
    if sc1 > 99 then
      font 3
      print @(v2(version) * (gx - 1) + v5(3), v3(version) * (gy - 1) + v6(2), 1) str$(13 * (gy - 1) + gx)
    elseif sc1 < 10 then
      font 5
      print @(v2(version) * (gx - 1) + v5(4), v3(version) * (gy - 1) + v6(3), 1) str$(13 * (gy - 1) + gx)
    else
      font 5
      print @(v2(version) * (gx - 1) + v5(5), v3(version) * (gy - 1) + v6(3), 1) str$(13 * (gy - 1) + gx)
    endif
    card_file$(sc2) = "graphics/red_back" + v1$(version)
    gx = choice(sc2 mod 13 = 0, 13, sc2 mod 13)
    gy = choice(sc2 mod 13 = 0, fix(sc2 / 13), fix(sc2 / 13) + 1)
    load png card_file$(sc2), v2(version) * (gx - 1) + 5, v3(version) * (gy - 1) + v4(version)   
    card_faceup(sc2) = 0 
    if sc2 > 99 then
      font 3
      print @(v2(version) * (gx - 1) + v5(3), v3(version) * (gy - 1) + v6(2), 1) str$(13 * (gy - 1) + gx)
    elseif sc2 < 10 then
      font 5
      print @(v2(version) * (gx - 1) + v5(4), v3(version) * (gy - 1) + v6(3), 1) str$(13 * (gy - 1) + gx)
    else
      font 5
      print @(v2(version) * (gx - 1) + v5(5), v3(version) * (gy - 1) + v6(3), 1) str$(13 * (gy - 1) + gx)
    endif  
  endif
  font 3 : color rgb(orange)
end sub

sub ending
  if version = 1 then
    text 16, 548, "That's all the cards."
    text 16, 572, str$(wrong_guesses) + " Wrong Guesses"
    text 16, 596, "Play again"
    text 16, 620, ""
  else
    text 840,  80, "That's all."
    text 840, 100, str$(wrong_guesses) + " Wrong"
    text 840, 120, "Play again"
    text 840, 140, ""
  endif
  input again$
  if left$(lcase$(again$), 1) = "y" then
    cls
    main()
  else
    end
  endif  
end sub

data  1, "2", "D"
data  2, "3", "D"
data  3, "4", "D"
data  4, "5", "D"
data  5, "6", "D"
data  6, "7", "D"
data  7, "8", "D"
data  8, "9", "D"
data  9, "10", "D"
data 10, "J", "D"
data 11, "Q", "D"
data 12, "K", "D"
data 13, "A", "D"
data 14, "2", "H"
data 15, "3", "H"
data 16, "4", "H"
data 17, "5", "H"
data 18, "6", "H"
data 19, "7", "H"
data 20, "8", "H"
data 21, "9", "H"
data 22, "10", "H"
data 23, "J", "H"
data 24, "Q", "H"
data 25, "K", "H"
data 26, "A", "H"
data 27, "2", "C"
data 28, "3", "C"
data 29, "4", "C"
data 30, "5", "C"
data 31, "6", "C"
data 32, "7", "C"
data 33, "8", "C"
data 34, "9", "C"
data 35, "10", "C"
data 36, "J", "C"
data 37, "Q", "C"
data 38, "K", "C"
data 39, "A", "C"
data 40, "2", "S"
data 41, "3", "S"
data 42, "4", "S"
data 43, "5", "S"
data 44, "6", "S"
data 45, "7", "S"
data 46, "8", "S"
data 47, "9", "S"
data 48, "10", "S"
data 49, "J", "S"
data 50, "Q", "S"
data 51, "K", "S"
data 52, "A", "S"
data  0, "0", "0"
