// setup for large black F407VET boards
// generic STM32F4 series
// choose FK407M1 STM32F407VET
// U(S)ART support Enabled (generic serial)
// USB support if available CDC (generic serial supersede USART
// optimise Fast -)1 with LTO



// DAC
volatile uint32_t *dacdual =   (uint32_t *)(0x40007420);
volatile uint32_t *dacctl =    (uint32_t *)(0x40007400);
// adc stuff
volatile uint32_t *adcsr =         (uint32_t *)(0x40012000);
volatile uint32_t *adccr1 =       (uint32_t *)(0x40012004);
volatile uint32_t *adccr2 =       (uint32_t *)(0x40012008);
volatile uint32_t *adcsmpr1 =       (uint32_t *)(0x4001200c);
volatile uint32_t *adcsmpr2 =       (uint32_t *)(0x40012010);
volatile uint32_t *adcdr =        (uint32_t *)(0x4001204c);
volatile uint32_t *adcsqr1 =        (uint32_t *)(0x4001202c);
volatile uint32_t *adcsqr3 =        (uint32_t *)(0x40012034);
volatile uint32_t *adcccr =         (uint32_t *)(0x40012304);
volatile uint32_t *rcccfgr =      (uint32_t *)(0x40023808);

#include "CMSIS_DSP.h"

#define CLOCKSPEED 167808766   // for black board F407VET  "FK407M1 ..."

#define NFFT 4096       // 4096, 2048, 1024, 512, 256, 128 
float rdata[NFFT], odata[NFFT+2],bw[NFFT];
int mag[NFFT];
volatile int scount,mcount, nfft, old_nfft, ave_samples,win_type, old_win_type, time_ave,db;
volatile uint32_t trace_speed, int_speed;

char *win_type_str[] = {"none","Blackman","Blackman-Harris 4 terms","flat top"};
float coherent_gain[] = {1.0,0.42,0.42,0.22};

// max is 600,000
// ARR only 16 bits. so 168MHz clock and 16 bit counter is about 2500 Hz period with zero prescaler
// if int_speed > 3000 use prescaler = 0
// else use prescaler = 19, so clock is /20 and then use int_speed * 20
// this lets int_speed get down to 250 Hz
#define INT_SPEED 1000

HardwareTimer t1(TIM1);     // need this for some other init code..

char lcdbuf[81], *bp, lcdcount;
volatile int intflag = 10;

extern "C" void  TIM1_IRQHandler()     
{  
  int a,i;
  if ((TIM1->SR & 0x0010) == 0x0010)
   {   
    TIM1->SR =0;    // reset int flag - mandatory or else it fires continuously
    //GPIOD->ODR &= 0x8;    GPIOD->ODR |= ~(0x8);  
    intflag = 1;
    if (scount < nfft)
      {
        if (ave_samples > 0)
          {
          a=0;
          for (i=0; i < ave_samples; i++)
            a += get_adc(1) - 2048;
          a /= ave_samples;
          }
        else
          a = get_adc(1) - 2048;
        rdata[scount] = bw[scount]*(float)(a) / 2048.0;
        scount++;
      }
    if (mcount < nfft/2)
      {  
        *dacdual =  mag[mcount];
        mcount++;
      }
    intflag = 0;
   }
}

void do_timer_arr(long i)
  {
    if (i < 3000)
      {
        TIM1->PSC = 19;
        TIM1->ARR = CLOCKSPEED/(20 * i); 
      }
    else
      {
        TIM1->PSC = 0;
        TIM1->ARR = CLOCKSPEED/i;
      }
  }

void Timer1_config(void)
{
  // timer1
  __HAL_RCC_TIM1_CLK_ENABLE();
  TIM1->BDTR = 0x0c00;    // DT part is low 8 bits
  TIM1->PSC = 0;
  TIM1->ARR = 168000000/INT_SPEED;
  TIM1->CR1 = 0;
  TIM1->RCR = 0;
  TIM1->CCR4 = 10;     
  TIM1->CR2 = 0;
  TIM1->CR1 |= 0x0080;    // enable preload
  TIM1->BDTR |= 0x8000;   // enable PWM outputs, needed for timer1
  TIM1->CR1 |= 0x0001;    // enable timer
}

void setupadc()
{
  uint16_t c0t,c1t,c2t;
  // do this last, after pwm pin setup
  GPIO_InitTypeDef GPIO_InitDef;
   __HAL_RCC_GPIOA_CLK_ENABLE();
  GPIO_InitDef.Pin = GPIO_PIN_0 |GPIO_PIN_1 |GPIO_PIN_2 |GPIO_PIN_3  ;      
  GPIO_InitDef.Mode = GPIO_MODE_ANALOG;
  GPIO_InitDef.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOA, &GPIO_InitDef);
  __HAL_RCC_ADC1_CLK_ENABLE();
  *adccr1 = 0x00000000;   // 0x0n000000 where n=0,1,2,3 for 12,10,8 and 6 bit rez ADC
  *adccr2 |= 1 ;    // ADC ON
  *adcccr =  ADC_TWOSAMPLINGDELAY_5CYCLES;
  *adcsqr1 = 0;
  *adcsmpr2 = 0;
  c0t = c1t = c2t = 7;      // sample time 3 bits per channel
  *adcsmpr1 = c0t + (c1t <<3) + (c2t << 6);
  *adcsmpr1 = 0;
  *adcsqr3 = 1;     
}

unsigned int get_adc(int c)
{
//GPIOD->ODR &= 0x8;    GPIOD->ODR |= ~(0x8);
*adcsqr3 = c;
*adccr2 |= 0x40000000;
while(!(*adcsr & 2))
  ;
return  *adcdr;
}


arm_rfft_fast_instance_f32 qq;

void init_fft()
{
  int i;
  float c;
  arm_rfft_fast_init_f32(&qq,nfft);
  
  for (i=0; i < nfft; i++)                  // fill the window function
   {
   c = 3.14159 * (float) i /(float)(nfft);
   if ( win_type == 0) bw[i] = 1.0;
   if ( win_type == 1) bw[i] = 0.42 - 0.5* cos(2.0 * c) + 0.08 * cos(4.0 *c);   // Blackman
   if ( win_type == 2) bw[i] = 0.3635819 - 0.4891775*cos(2.0*c) + 0.1365995 * cos(4.0*c) - 0.0106411 * cos(6.0*c);          // Balckman-Harris 4 Terms
   if ( win_type == 3) bw[i] = 0.21557895 - 0.41663158 * cos(2.0*c) + 0.277263158 * cos(4.0*c) - 0.083578947 * cos(6.0*c) + 0.006947368 * cos(8.0 *c);    // flat top
   }
old_nfft = nfft;
old_win_type = win_type;
c = 0.5 * (float)(nfft) / 12e-4;
trace_speed = (uint32_t)(c);
mcount = nfft;
}

void setup() 
{
  int i;
  float c;
  db = 1;
  nfft = NFFT;
  win_type =  old_win_type = 1;
  time_ave = 1;
  nfft = 4096; // 256,512,1024,4096
  ave_samples = 0; // 0,4,8,16
  win_type = 3; // 1,2,3
  time_ave = 1; //8,32
  int_speed = 50000;
  init_fft();
      
  scount = 0;
  
  // DAC setup
  RCC->APB1ENR |= (1 << 29);      // enable DAC peripheral clock
  *dacctl = (1 << 16) + 1 ;      // enable dac1 and dac2   *dacdual takes 2 values
  setupadc();
  
  Timer1_config(); 
  HAL_NVIC_SetPriority(TIM1_UP_TIM10_IRQn ,1,2);
  SysTick->CTRL = 0;
  TIM1->DIER = 0x0001;    // let it rip, enable TIMER1
//SysTick->CTRL = 0;
  Serial.begin(9600);
  pinMode(PD7,OUTPUT);
}


float fast_log(float val) 
{
    union { float val; int32_t x; } u = { val };
    float log_2 = (float)(((u.x >> 23) & 255) - 128);              
    u.x   &= ~(255 << 23);
    u.x   += 127 << 23;
    log_2 += ((-0.3358287811f) * u.val + 2.0f) * u.val  -0.65871759316667f; 
    return (log_2);
} 

void loop() 
{
  int c,i,a1,d;
  float log_10,a;
  if (Serial.available())
   {
    c = Serial.read();
    if (c == '?')
      {
        Serial.print("N = "); Serial.print(nfft);
        Serial.print(", Fs = "); Serial.print(int_speed);
        Serial.print(", t = "); Serial.println(time_ave);
        Serial.print("window = "); Serial.print(win_type_str[win_type]);
        Serial.print(", ave_samples = "); Serial.println(ave_samples);
      }
    if (c == 'n')
      {
        i = Serial.read();
        if (i == '1')          nfft = 256;
        if (i == '2')          nfft = 512;
        if (i == '3')          nfft = 1024;
        if (i == '4')          nfft = 2048;
        if (i == '5')          nfft = 4096;
        if (i == '5')          nfft = 4096;
        Serial.print("nfft = "); Serial.println(nfft);
      }
    if (c == 'd')
      {
        i = Serial.read();
        if (i == '2')          db = 2;
        if (i == '1')          db = 1;
        if (i == '0')          db = 0;
        if (db == 0) Serial.println("db scale"); else Serial.println("linear scale");
      }  
    if (c == 'a')
      {
        i = Serial.read();
        if (i == '1')          ave_samples = 0;
        if (i == '2')          ave_samples = 4;
        if (i == '3')          ave_samples = 8;
        if (i == '4')          ave_samples = 16;
        if (i == '5')          ave_samples = 64;
        Serial.print("sample averaging = "); Serial.println(ave_samples);
      }  
     if (c == 'w')
      {
        i = Serial.read();
        if (i == '0')          win_type = 0;
        if (i == '1')          win_type = 1;
        if (i == '2')          win_type = 2;
        if (i == '3')          win_type = 3;
        Serial.print("window type = "); Serial.println(win_type_str[win_type]);
      }  
     if (c == 's')
      {
        i = Serial.read();
        if (i == '1')          int_speed = 200;
        if (i == '2')          int_speed = 500;
        if (i == '3')          int_speed = 1000;
        if (i == '4')          int_speed = 2000;
        if (i == '5')          int_speed = 5000;
        if (i == '6')          int_speed = 10000;
        if (i == '7')          int_speed = 20000;
        if (i == '8')          int_speed = 50000;
        if (i == '9')          int_speed = 100000;
        if (i == 'a')          int_speed = 200000;
        if (i == 'b')          int_speed = 500000;
        Serial.print("sample rate = "); Serial.println(int_speed);
      }    
     if (c == 't')
      {
        i = Serial.read();
        if (i == '1')          time_ave = 1;
        if (i == '2')          time_ave = 8;
        if (i == '3')          time_ave = 32;
        Serial.print("time_average = "); Serial.println(time_ave);
      }    
   } 
 
 // wait until sampling complete
  while (scount < nfft)
    ;
  
  if ((win_type != old_win_type) || (nfft != old_nfft))
    init_fft();

  // get fft  
  *dacdual = 4000 << 16;
  arm_rfft_fast_f32(&qq,rdata,odata,0);
  arm_cmplx_mag_f32(odata,odata,nfft);
  arm_scale_f32(odata,1.0/coherent_gain[win_type],odata,nfft/2);
  
  *dacdual = 4000 << 16;
  // get power spectrum in db
  log_10 = 1.0 / ( fast_log(10.0));
  for(i=0; i < nfft/2; i++)
         {
         if (db == 2)             d = (int)(650.0*fast_log(odata[i]/(float)(nfft))*log_10) + 4400;
         if (db == 1)             d = (int)(1300.0*fast_log(odata[i]/(float)(nfft))*log_10) + 5000;
         if (db == 0)             d = (int)(4095.0 * 9.2 *(odata[i]/(float)nfft));
         if (d < 0) d = 0;
         if (d > 4095) d = 4095;
         if (time_ave == 1)           mag[i] = d;
         if (time_ave == 8)           mag[i] = (mag[i] * 7 + d)/8;
         if (time_ave == 32)          mag[i] = (mag[i] * 31 + d)/32; 
         } 
  
  // show spectrum      
  TIM1->PSC = 0;   
  TIM1->ARR = CLOCKSPEED/trace_speed;

  mcount = 0;
  while(mcount < nfft/2)
    ;
  *dacdual = 0;
    
  // set sample rate 
  do_timer_arr(int_speed);  
  
  // start sampling
  scount = 0; 
}
