unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Registry, Menus, Math;

type
  TForm1 = class(TForm)
    Label1: TLabel;                    // time field
    Label2: TLabel;                    // latitude field
    Label3: TLabel;                    // N/S field
    Label4: TLabel;                    // longitude field
    Label5: TLabel;                    // E/W field
    Label6: TLabel;                    // fix quality
    Label7: TLabel;                    // satellites in use
    Label8: TLabel;                    // horizontal dilution
    Label9: TLabel;                    // altitude above MSL
    Label10: TLabel;                   // "M"
    Label11: TLabel;                   // separation between geoid and MSL
    Label12: TLabel;                   // "M"
    Label13: TLabel;                   // time since last TxD to VK16E
    LabelD: TLabel;                    // date field
    LabelX: TLabel;                    // delta X (in metres) "easting"
    LabelY: TLabel;                    // delta Y (in metres) "northing"
    LabelR: TLabel;                    // distace from waypoint (in metres)
    LabelT: TLabel;                    // bearing from waypoint

    L1: TLabel;                        // "time"
    L2: TLabel;                        // "latitude"
    L3: TLabel;                        // "longitude"
    L4: TLabel;                        // "quality"
    L5: TLabel;                        // "satellites"
    L6: TLabel;                        // "H. dilution"
    L7: TLabel;                        // "altitude (MSL)"
    L8: TLabel;                        // "geoid seperation"
    L9: TLabel;                        // "delta X ="
    L10: TLabel;                       // "delta Y ="
    L11: TLabel;                       // "M"
    L12: TLabel;                       // "M"
    L13: TLabel;                       // "range ="
    L14: TLabel;                       // "bearing ="
    L15: TLabel;                       // "M"
    L16: TLabel;                       // degree symbol

    RichEdit1: TRichEdit;
    CheckBox1: TCheckBox;              // static navigation selector
    CheckBox2: TCheckBox;              // display all strings selector

    Button1: TButton;                  // "pause"/"resume"
    Button2: TButton;                  // "config SiRF"
    Button3: TButton;                  // "zero offset"
    Button4: TButton;                  // "log"
    Button5: TButton;                  // "reset SiRF"

    Bevel1: TBevel;
    Panel1: TPanel;                    // fixes top left corner of form
    Panel2: TPanel;                    // fixes top right corner of form
    Panel3: TPanel;                    // fixes bottom left corner of form
    Panel4: TPanel;                    // fixes bottom right corner of form
    Shape1: TShape;                    // activity indicator

    Timer1: TTimer;                    // timer container
    PopupMenu1: TPopupMenu;            // popup menu container
    HotReset: TMenuItem;
    WarmReset1: TMenuItem;
    WarmReset2: TMenuItem;
    ColdReset: TMenuItem;
    FactoryReset: TMenuItem;
    procedure FormCreate(Sender: TObject);       // run once on create
    procedure FormDestroy(Sender: TObject);      // run once on shutdown
    procedure FormActivate(Sender: TObject);     // run every time focused
    procedure Timer1Timer(Sender: TObject);      // 20mS timer event
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ResetOption(Sender: TObject);      // common code for reset items
    procedure CheckBoxClick(Sender: TObject);    // common code for checkboxes
    procedure FormDblClick(Sender: TObject);     // info popup
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses Shared;

var CommFile: THandle;
    RxBuffer:string;

var X1,Y1,X2,Y2:double;
      Xlen,Ylen:double;
        LogFile:text;
             T0:TDateTime;
const ZeroFlag:boolean=false;  // command to establish waypoint
       LogFlag:boolean=false;  // log file is active
       Running:boolean=false;  // respond to buttons

const m1 = 111132.92;          // latitude calculation term 1
      m2 = -559.82;            // latitude calculation term 2
      m3 = 1.175;              // latitude calculation term 3
      m4 = -0.0023;            // latitude calculation term 4
      p1 = 111412.84;          // longitude calculation term 1
      p2 = -93.5;              // longitude calculation term 2
      p3 = 0.118;              // longitude calculation term 3


function degrees(s:string):double;
var error,i:integer;
        d,m:double;
begin
  degrees:=0;
  i:=pos('.',s);                  // there should always be a dp
  if i=0 then exit;
  val(copy(s,1,i-3),d,error);     // exclude dp and 2 digits to left
  if error<>0 then exit;
  val(copy(s,i-2,9),m,error);     // 7 would suffice: "00.0000"
  if error<>0 then exit;
  degrees:=d+(m/60.0)
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.Title:='GPS info';
  Form1.DoubleBuffered:=true
// most configuration must be carried out in the first call to
// FormActivate as the comm port hasn't been selected yet.
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  Timer1.Enabled:=false;
  try
    CloseHandle(CommFile)
  except
  end;
  if LogFlag then
  try
    CloseFile(LogFile)
  except
  end
end;


procedure TForm1.FormActivate(Sender: TObject);
var DeviceName:array [0..80] of char;
           DCB:TDCB;
        Config:string;
       CommTOs:TCommTimeouts;
          proc:string;
begin
  if InitFlag then
  begin
    InitFlag:=false;

    RxBuffer:='';
    X1:=0.0;
    Y1:=0.0;
    X2:=0.0;
    Y2:=0.0;

    try
      StrPCopy(DeviceName, '\\.\'+CommPortName);
      proc:='CreateFile';
      CommFile:=CreateFile(DeviceName,
                           GENERIC_READ or GENERIC_WRITE,
                           0, Nil,
                           OPEN_EXISTING,
                           FILE_ATTRIBUTE_NORMAL, 0);
      if (CommFile=INVALID_HANDLE_VALUE) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end;
      proc:='SetupComm';
      if not SetupComm(CommFile, 1024, 1024) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end;
      proc:='GetCommState';
      if not GetCommState(CommFile, DCB) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end;
      Config:='baud='+IntToStr(9600)+' parity=n data=8 stop=1'#0;
      proc:='BuildCommDCB';
      if not BuildCommDCB(@Config[1], DCB) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end;
      proc:='SetCommState';
      if not SetCommState(CommFile, DCB) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end;
      with CommTOs do
      begin
        ReadIntervalTimeout := 10;               // 0
        ReadTotalTimeoutMultiplier := 0;         // 0
        ReadTotalTimeoutConstant := 10;          // 300
        WriteTotalTimeoutMultiplier := 0;        // 0
        WriteTotalTimeoutConstant := 10          // 300
      end;
      proc:='SetCommTimeouts';
      if not SetCommTimeouts(CommFile, CommTOs) then
      begin
        showmessage('Serial I/O error: '+proc+' failed');
        halt
      end
    except
      try CloseHandle(CommFile); except end;
      showmessage('Serial I/O error: '+proc+' exception');
      halt
    end;

    T0:=now;
    Form1.Timer1.Enabled:=true;
    Running:=true
  end
end;


procedure TForm1.Timer1Timer(Sender: TObject);
var d:array[1..80] of char;
    s:string;
    i,j,k:integer;
    got:DWORD;
    dX,dY,lat,R,T:double;
    GPStime:string;
    SatsVis,Q:integer;
begin
  try
    if not ReadFile(CommFile, d[1], sizeof(d), got, nil) then
    begin
      Timer1.Enabled:=false;
      showmessage('Serial I/O error: ReadFile failed');
      halt
    end
  except
    Timer1.Enabled:=false;
    showmessage('Serial I/O error: ReadFile exception');
    halt
  end;

  if got<>0 then Shape1.Brush.Color:=clRed
            else Shape1.Brush.Color:=clBtnFace;
  i:=trunc((now-T0)*60.0*60.0*24.0);
  s:=IntToStr(I div 60)+'m '+IntToStr(I mod 60)+'s';
  if s[length(s)-2]=' ' then insert('0',s,length(s)-1);
  Label13.Caption:=s;

  GPStime:='';
  SatsVis:=0;
  Q:=0;

  for i:=1 to got do
  begin
    if d[i]>=#32 then RxBuffer:=RxBuffer+d[i] else
    if d[i]=#13 then
    begin

      if CheckBox2.Checked then
      begin
        while RichEdit1.Lines.Count>99 do RichEdit1.lines.Delete(0);
        RichEdit1.Lines.Add(RxBuffer);           // completed line into memo
        SendMessage(RichEdit1.Handle, WM_VSCROLL, SB_BOTTOM, 0)
//      RichEdit1.SetFocus;
//      RichEdit1.SelStart:=RichEdit1.GetTextLen;
//      RichEdit1.Perform(EM_SCROLLCARET,0,0)
      end;

      if pos('$GPRMC',RxBuffer)=1 then           // only use RMC to get date
      begin
        delete(RxBuffer,1,7);                    // delete header + first comma
        k:=1;
        while (RxBuffer<>'') and (k<=11) do      // 11=last field
        begin
          j:=pos(',',RxBuffer);                  // find first comma
          if j<>0 then begin
                         s:=copy(RxBuffer,1,j-1);
                         delete(RxBuffer,1,j)
                       end
                  else begin
                         s:=RxBuffer;
                         RxBuffer:=''
                       end;
//        if s='' then s:='N/A';

          case k of 9:if s<>'' then LabelD.Caption:=s     // date field
          end;  {of case}
          inc(k)
        end
      end;

      if pos('$GPGGA',RxBuffer)=1 then
      begin
        if not CheckBox2.Checked then
        begin
          while RichEdit1.Lines.Count>99 do RichEdit1.lines.Delete(0);
          RichEdit1.Lines.Add(RxBuffer);         // completed line into memo
          SendMessage(RichEdit1.Handle, WM_VSCROLL, SB_BOTTOM, 0)
//        RichEdit1.SetFocus;
//        RichEdit1.SelStart:=RichEdit1.GetTextLen;
//        RichEdit1.Perform(EM_SCROLLCARET,0,0)
        end;

        delete(RxBuffer,1,7);                    // delete header + first comma
        k:=1;
        while (RxBuffer<>'') and (k<=14) do      // 14=last field
        begin
          j:=pos(',',RxBuffer);                  // find first comma
          if j<>0 then begin
                         s:=copy(RxBuffer,1,j-1);
                         delete(RxBuffer,1,j)
                       end
                  else begin
                         s:=RxBuffer;
                         RxBuffer:=''
                       end;
          if s='' then s:='N/A';

          case k of 1:begin
                        Label1.Caption:=s;       // time
                        j:=pos('.',s);
                        if j<>0 then GPStime:=copy(s,1,j-1)
                                else GPStime:=s
                      end;
                    2:begin
                        Label2.Caption:=s;       // latitude
                        Y2:=degrees(s);
                      end;
                    3:begin
                        Label3.Caption:=s;       // N/S hemisphere
                        if s='S' then Y2:=-Y2;
                      end;
                    4:begin
                        Label4.Caption:=s;       // longitude
                        X2:=degrees(s);
                      end;
                    5:begin
                        Label5.Caption:=s;       // E/W
                        if s='W' then X2:=-X2
                      end;
                    6:begin                      // fix status
                        try Q:=strtoint(s) except Q:=0 end;
                        if s='0' then Label6.Caption:='0: invalid' else
                        if s='1' then Label6.Caption:='1: GPS fix (SPS)' else
                        if s='2' then Label6.Caption:='2: DGPS fix' else
                        if s='3' then Label6.Caption:='3: PPS fix' else
			if s='4' then Label6.Caption:='4: RT Kinematic' else
			if s='5' then Label6.Caption:='5: Float RTK' else
                        if s='6' then Label6.Caption:='6: Estimated (DR)' else
			if s='7' then Label6.Caption:='7: Manual IP Mode' else
			if s='8' then Label6.Caption:='8: Simulation Mode' else
                                      Label6.Caption:='(unknown type)'
                      end;
                    7:begin
                        Label7.Caption:=s;       // visible satellites
                        try SatsVis:=strtoint(s) except SatsVis:=0 end
                      end;
                    8:Label8.Caption:=s;         // horizontal dilution
                    9:Label9.Caption:=s;         // antenna altitude above MSL
                   10:Label10.Caption:=s;        // units (M)
                   11:Label11.Caption:=s;        // geoid separation
                   12:Label12.Caption:=s         // units (M)
          end;  {of case}
          inc(k)
        end;

        if ZeroFlag then
        begin
          X1:=X2;
          Y1:=Y2;
          ZeroFlag:=false
        end;

        dX:=X2-X1;
        dY:=Y2-Y1;
        if dX>+180.0 then dX:=dX-360.0 else
        if dX<-180.0 then dX:=dX+360.0;
        if dY>+180.0 then dY:=dY-360.0 else
        if dY<-180.0 then dY:=dY+360.0;

//      dX:=dX*(40075160.0/360.0)*cos((Y1+Y2)*pi/360.0);
//      dY:=dY*(40008000.0/360.0);       // simple conversion -> metres

        lat:=(Y1+Y2)*pi/360.0;           // latitude in radians
        XLen:=(p1*cos(  lat))            // p1 = 111412.84  (4010 8622 /360)
             +(p2*cos(3*lat))
             +(p3*cos(5*lat));
        YLen:=m1+(m2*cos(2*lat))         // m1 = 111132.92  (4000 7851 /360)
                +(m3*cos(4*lat))
                +(m4*cos(6*lat));
        dX:=dX*XLen;                     // decimal degrees -> metres
        dY:=dY*YLen;                     // decimal degrees -> metres

        R:=sqrt((dX*dX)+(dY*dY));
        if (dX=0.0) and (dY>=0.0) then T:=  0.0 else  // due north
        if (dX=0.0) and (dY< 0.0) then T:=180.0 else  // due south
        if (dY=0.0) and (dX> 0.0) then T:= 90.0 else  // due east
        if (dY=0.0) and (dX< 0.0) then T:=270.0 else  // due west
            T:=(180.0/pi)*arctan2(dX,dY);             // atan(easting/northing)

        if T<0.0 then T:=T+360.0;

        if dX>+9999.99 then dX:=+9999.99;
        if dX<-9999.99 then dX:=-9999.99;
        if dY>+9999.99 then dY:=+9999.99;
        if dY<-9999.99 then dY:=-9999.99;
        if R>19999.99 then R:=19999.99;

        str(dX:1:2,s);
        LabelX.Caption:=s;
        str(dY:1:2,s);
        LabelY.Caption:=s;
        str(R:1:2,s);
        LabelR.Caption:=s;
        str(T:1:1,s);
        while length(s)<5 do insert('0',s,1);
        if R<15000.0 then
        if (dX=0.0) and (dY=0.0) then LabelT.Caption:='---.-'
                                 else LabelT.Caption:=s;

        if LogFlag { and (Q<>0) } then
        try
          if (Q<>0) then writeln(LogFile,GPStime,' , ',Q:2,' , ',SatsVis:3,' , ',dX:10:2,' , ',dY:10:2)
                    else writeln(LogFile,GPStime,' , ',Q:2,' , ',SatsVis:3)
        except
          LogFlag:=false;
          try
            CloseFile(LogFile)
          finally
            Button4.Font.Style:=Button4.Font.Style-[fsStrikeOut]
          end
        end
      end;

      RxBuffer:=''
    end
  end
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if not Running then exit;
  Timer1.Enabled:=not Timer1.Enabled;
  if Timer1.Enabled then Button1.Caption:='pause'
                    else Button1.Caption:='resume';
  RichEdit1.SetFocus
end;


procedure TForm1.Button2Click(Sender: TObject);
const ds1:array [1..26] of char='$PSRF100,0,9600,8,1,0*0C'#13#10;
      ds2:array [1..10] of byte=   // disable static navigation
         ($A0,$A2,      // header
          $00,$02,      // payload length (2 bytes)
          $8F,$00,      // command + SN flag
          $00,$8F,      // payload checksum
          $B0,$B3);     // footer

      ds3:array [1..10] of byte=   // enable static navigation
         ($A0,$A2,      // header
          $00,$02,      // payload length (2 bytes)
          $8F,$01,      // command + SN flag
          $00,$90,      // payload checksum
          $B0,$B3);     // footer

      ds4:array [1..32] of byte=   // return to NMEA mode
         ($A0,$A2,      // header
          $00,$18,      // payload length (24 bytes)
          $81,$02,      // command + mode
          $01,$01,      // GGA (1) (interval + CS flag) *
          $00,$01,      // GLL     (interval + CS flag)
          $00,$01,      // GSA (1) (interval + CS flag) #
          $00,$01,      // GSV (5) (interval + CS flag) #
          $0A,$01,      // RMC (1) (interval + CS flag) *
          $00,$01,      // VTG (1) (interval + CS flag) *
          $00,$01,      // MSS     (interval + CS flag)
          $00,$01,      // <unused>
          $00,$01,      // ZDA     (interval + CS flag)
          $00,$01,      // <unused>
          $25,$80,      // baud rate (9600)
          $FF,$FF,      // payload checksum (0x013A)
          $B0,$B3);     // footer
var put:DWORD;
    i,c:integer;
     ok:boolean;
begin
  if not Running then exit;
  Button2.Enabled:=false;
  try
    if not WriteFile(CommFile,ds1,length(ds1),put,nil) then      // switch to SiRF mode
    begin
      Timer1.Enabled:=false;
      showmessage('Serial I/O error: WriteFile failed (1)');
      halt
    end
  except
    Timer1.Enabled:=false;
    showmessage('Serial I/O error: WriteFile exception (1)');
    halt
  end;
  sleep(300);
  Application.ProcessMessages;

  try
    if CheckBox1.Checked then ok:=WriteFile(CommFile,ds3,length(ds3),put,nil)
                         else ok:=WriteFile(CommFile,ds2,length(ds2),put,nil);
    if not ok then
    begin
      Timer1.Enabled:=false;
      showmessage('Serial I/O error: WriteFile failed (2)');
      halt
    end
  except
    Timer1.Enabled:=false;
    showmessage('Serial I/O error: WriteFile exception (2)');
    halt
  end;
  sleep(300);
  Application.ProcessMessages;

  c:=0;          // needed if we change any of the sentence settings
  for i:=5 to 28 do inc(c,ds4[i]);    // recalculate checksum on ds4
  ds4[29]:=c div $100;                // insert high byte
  ds4[30]:=c mod $100;                // insert low byte

  try
    if not WriteFile(CommFile,ds4,length(ds4),put,nil) then      // return to NMEA mode
    begin
      Timer1.Enabled:=false;
      showmessage('Serial I/O error: WriteFile failed (3)');
      halt
    end
  except
    Timer1.Enabled:=false;
    showmessage('Serial I/O error: WriteFile exception (3)');
    halt
  end;
  Button2.Enabled:=true;
  T0:=now;
  RichEdit1.SetFocus
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
  if not Running then exit;
  ZeroFlag:=true;
  RichEdit1.SetFocus
end;


procedure TForm1.Button4Click(Sender: TObject);
var s:string;
begin
  if not Running then exit;
  s:='C:\gps.csv';
  if LogFlag then
  try
    CloseFile(LogFile);
  finally
    LogFlag:=false
  end else
  begin
    AssignFile(LogFile,s);
    try
      if FileExists(s) then Append(LogFile)
                       else Rewrite(LogFile);
      LogFlag:=true
    except
    end
  end;
  if LogFlag then Button4.Font.Style:=Button4.Font.Style+[fsStrikeOut]
             else Button4.Font.Style:=Button4.Font.Style-[fsStrikeOut];
  RichEdit1.SetFocus
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
  Button5.Enabled:=false;
  PopupMenu1.Popup(Mouse.CursorPos.x,Mouse.CursorPos.y);
  Button5.Enabled:=true;
  RichEdit1.SetFocus
end;


procedure TForm1.ResetOption(Sender: TObject);
const ds5:array [1..30] of char='$PSRF101,0,0,0,0,0,0,12,1*15'#13#10;       // hot
      ds6:array [1..30] of char='$PSRF101,0,0,0,0,0,0,12,2*16'#13#10;       // warm (no init)
      ds7:array [1..30] of char='$PSRF101,0,0,0,0,0,0,12,3*17'#13#10;       // warm (init)
      ds8:array [1..30] of char='$PSRF101,0,0,0,0,0,0,12,4*10'#13#10;       // cold (or 6?)
      ds9:array [1..30] of char='$PSRF101,0,0,0,0,0,0,12,8*1C'#13#10;       // factory
var put:DWORD;
     ok:boolean;
begin
  if not Running then exit;
  try
    ok:=true;
    if Sender=HotReset     then ok:=WriteFile(CommFile,ds5,length(ds5),put,nil); // hot reset
    if Sender=WarmReset1   then ok:=WriteFile(CommFile,ds6,length(ds6),put,nil); // warm (no init)
    if Sender=WarmReset2   then ok:=WriteFile(CommFile,ds7,length(ds7),put,nil); // warm (init)
    if Sender=ColdReset    then ok:=WriteFile(CommFile,ds8,length(ds8),put,nil); // cold reset
    if Sender=FactoryReset then ok:=WriteFile(CommFile,ds9,length(ds9),put,nil); // factory reset
    if not ok then
    begin
      Timer1.Enabled:=false;
      showmessage('Serial I/O error: WriteFile failed (4)');
      halt
    end
  except
    Timer1.Enabled:=false;
    showmessage('Serial I/O error: WriteFile exception (4)');
    halt
  end;
  T0:=now
end;


procedure TForm1.CheckBoxClick(Sender: TObject);
begin
  RichEdit1.SetFocus
end;


procedure TForm1.FormDblClick(Sender: TObject);
begin
  showmessage('(c)  Robert Rozee  2015'#13'Release 1 (22-dec-2015)')
end;


end.
