unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Registry;

type
  TForm2 = class(TForm)
    ListBox1: TListBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure ListBox1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ListBox1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

uses Shared, Unit1;

var CommPortList:TStringList;

const InitList:boolean=true;


procedure TForm2.FormCreate(Sender: TObject);
begin
  CommPortList:=TStringList.Create
end;


procedure TForm2.FormActivate(Sender: TObject);  // also button1 click
var reg:TRegistry;
      i:integer;
begin
  if InitList or (Sender=Button1) then
  begin
    reg:=TRegistry.Create;
    CommPortList.Clear;
    ListBox1.Clear;

    with reg do
    try
      RootKey:=HKEY_LOCAL_MACHINE;
      if OpenKeyReadOnly('hardware\devicemap\serialcomm') then
      begin
        try
          GetValueNames(CommPortList);
          for i:=0 to CommPortList.Count-1 do
          begin
            CommPortList.Strings[i]:=ReadString(CommPortList.Strings[i])+' = '+CommPortList.Strings[i];
            ListBox1.Items.Insert(i,CommPortList.Strings[i])
          end
        except
          showmessage('exception accessing registry')
        end
      end

    finally
      CloseKey;
      reg.Free
    end;
    ListBox1.ItemIndex:=0;
    ListBox1.SetFocus;
    InitList:=false
  end
end;


procedure TForm2.ListBox1DblClick(Sender: TObject);
begin
  CommPortName:=CommPortList.Names[ListBox1.ItemIndex];
  InitFlag:=true;
  Application.ProcessMessages;
  Form1.Show;
  Form2.Close
end;


procedure TForm2.ListBox1KeyPress(Sender: TObject; var Key: Char);
begin
  if (Key=#13) and (TListBox(Sender).ItemIndex<>-1) then
  begin
    CommPortName:=CommPortList.Names[ListBox1.ItemIndex];
    InitFlag:=true;
    Form1.Show;
    Form2.Close
  end
end;


procedure TForm2.FormDeactivate(Sender: TObject);
begin
  if not InitFlag then Form2.SetFocus
end;


procedure TForm2.Button2Click(Sender: TObject);
begin
  halt
end;


end.
