unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ScktComp, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    ClientSocket1: TClientSocket;
    Memo1: TMemo;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Timer1: TTimer;
    Label2: TLabel;
    procedure ClientSocket1Read(Sender: TObject; Socket: TCustomWinSocket);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.ClientSocket1Read(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Memo1.Lines.BeginUpdate;

  Memo1.Text:= Memo1.Text+Socket.ReceiveText;
  if Memo1.Lines.Count>24 then Memo1.Lines.Delete(0);
  Memo1.SelStart:=length(Memo1.Text);
  Memo1.SelLength:=0;
  SendMessage(Memo1.Handle, WM_VSCROLL, SB_BOTTOM, 0);

  Memo1.Lines.EndUpdate
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  Memo1.Lines.Clear;
  SpeedButton3.Caption:=ClientSocket1.Host;
  SpeedButton4.Caption:=IntToStr(ClientSocket1.Port);
  ClientSocket1.Open
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
  ClientSocket1.Close;
  SpeedButton3.Caption:='host';
  SpeedButton4.Caption:='port'
end;


procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Label1.Caption:=IntToHex(ord(Key),2);

  case Key of #13:ClientSocket1.Socket.SendText(#13#10)
           else   ClientSocket1.Socket.SendText(Key)
  end  { of case }
end;


procedure TForm1.SpeedButton3Click(Sender: TObject);
var S:string;
begin
  if InputQuery('','enter host name:',S) then
  begin
    SpeedButton3.Caption:=S;
    ClientSocket1.Host:=S
  end
end;


procedure TForm1.SpeedButton4Click(Sender: TObject);
var S:string;
    I:integer;
begin
  if InputQuery('','enter port number:',S) then
  try
    I:=StrtoInt(S);
    SpeedButton4.Caption:=S;
    ClientSocket1.Port:=I
  except end
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if ClientSocket1.Active then begin
                                 Label2.Caption:='online';
                                 Label2.Color:=clLime
                               end
                          else begin
                                 Label2.Caption:='offline';
                                 Label2.Color:=Label1.Color
                               end
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  Form1.DoubleBuffered:=true;
  Memo1.DoubleBuffered:=true;
  Form1.Caption:='telnet test';
  Application.Title:=Form1.Caption
end;


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if ClientSocket1.Active then ClientSocket1.Close
end;



end.
