  if XMinit then                                                       // common code (XMload and XMsave)
  begin
    Timer3.Enabled:=false;                                             // ensures we won't be interrupted
    XMinit:=false;                                                     // makes doubly sure of the above
    CCflag:=false;                                                     // ctrl-C hasn't been pressed

////////////////////////////////////////////////////////////////////////////////
// XMODEM RECEIVE (load from file on host)                                    //
////////////////////////////////////////////////////////////////////////////////
    if XMload then
    begin
      RxBuffer.tail:=RxBuffer.head;                                    // drain serial Rx buffer
      QueueSerialWrite(#24);                                           // CAN (cancel transfer)
      timeout:=not WaitSerialQueue(#06, 3000);                         // wait for ACK response

// LOAD TEXT FROM FILE /////////////////////////////////////////////////////////
      if not timeout and OpenDialog2.Execute then                      // get name of file to upload
      begin
        SL:=TStringlist.Create;
        try
          SL.LoadFromFile(OpenDialog2.Filename);                       // grab content into a string list
          T:=SL.Text                                                   // convert to a single string
        except
          T:='';
          ShowMessage(#13+pL+'Exception reading from file '+OpenDialog2.Filename+pR+#13)
        end;
        SL.Free;
        CleanUpString(T, false, true);                                 // clean up string, no trailing ctrl-Z, pad to 128 byte boundary
// END (LOAD TEXT FROM FILE) ///////////////////////////////////////////////////

// DO XMODEM TRANSFER //////////////////////////////////////////////////////////
        if length(T)<>0 then
        begin
          RxBuffer.tail:=RxBuffer.head;                                // drain serial Rx buffer
          QueueSerialWrite('XMODEM RECEIVE'+#13);                      // restart transfer
          timeout:=not WaitSerialQueue(#21, 3000);                     // wait for initial NAK

          block:=0;
          while (length(T)<>0) and not (timeout or CCflag) do
          begin
            inc(block);                                                // first block is #1
{###}       sprint('  '+IntToStr(length(T))+' '+#13);                  // display progress (counts down)
            S:=#01+chr(block)+chr(255-block)+copy(T, 1, 128);          // build packet (3 byte header + 128 bytes of data)
            delete(T, 1, 128);

            checksum:=0;
            for I:=1 to length(S) do checksum:=checksum+ord(S[I]);
            S:=S+chr(checksum);                                        // add checksum to end -> 132 bytes total packet size

            QueueSerialWrite(S);                                       // send packet

            timeout:=not WaitSerialQueue(#06, 3000)                    // wait for ACK response
          end;

          if not timeout then                                          // timeout error  --> send no final response
          begin
{###}       sprint('  wait...'+#13);                                   // display closing message
            if CCflag then QueueSerialWrite(#24)                       // ctrl-C pressed --> send CAN
                      else QueueSerialWrite(#04)                       // completed ok   --> send EOT
          end
        end
// END (XMODEM TRANSFER) ///////////////////////////////////////////////////////

      end;
{###} if timeout then sprint(space(16)+#13+'** timeout error **');
      XMload:=false                                                    // unblock keyboard, etc.
    end;

////////////////////////////////////////////////////////////////////////////////
// XMODEM SEND (save to file on host)                                         //
////////////////////////////////////////////////////////////////////////////////
    if XMsave then
    begin
      T:='';
      OK:=false;
      RxBuffer.tail:=RxBuffer.head;                                    // drain serial Rx buffer
      QueueSerialWrite(#21);                                           // send NAK to kick off transfer

// DO XMODEM TRANSFER //////////////////////////////////////////////////////////
      repeat
        S:='';
        timeout:=not ReadSerialQueue(ch, 3000);
        if timeout then break;

        case ch of #01:begin                                           // #01 = valid block *******
                         timeout:=not ReadSerialQueue(ch, 50);         // get block number - ignore
                         if timeout then break;                        // -> failed (not OK)

                         timeout:=not ReadSerialQueue(ch, 50);         // 255-block number - ignore
                         if timeout then break;                        // -> failed (not OK)

                         repeat
                           timeout:=not ReadSerialQueue(ch, 50);       // 128 bytes of data
                           S:=S+ch
                         until (length(S)=128) or timeout;
                         if timeout then break;                        // -> failed (not OK)

                         timeout:=not ReadSerialQueue(ch, 50);         // checksum - ignore
                         if timeout then break;                        // -> failed (not OK)

                         if CCflag then begin
                                          QueueSerialWrite(#24);       // ctrl-C pressed --> send CAN
{###}                                     sprint(space(16)+#13);
                                          break;                       // -> failed (not OK)
                                        end
                                   else begin
                                          QueueSerialWrite(#06);       // block completed ok --> send ACK
                                          T:=T+S;
{###}                                     sprint('  '+IntToStr(length(T))+#13)
                                        end
                       end;
                   #04:begin                                           // #04 = no more data ******
                         QueueSerialWrite(#06);                        // donwload completed ok --> send ACK
{###}                    sprint(space(16)+#13);
                         OK:=true
                       end
        end  { of case}
      until OK;
// END (XMODEM TRANSFER) ///////////////////////////////////////////////////////

// SAVE TEXT TO FILE ///////////////////////////////////////////////////////////
      if OK then
      begin
        while (length(T)<>0) and (T[length(T)]=#00) do SetLength(T, length(T)-1);      // remove trailing NULs
        if not (RightStr(T,2)=#13#10) then T:=T+#13#10;                                // ensure ends with <cr><lf>

        if SaveDialog2.Execute then try
                                      AssignFile(TF, SaveDialog2.FileName);
                                      ReWrite(TF);
                                      Write(TF, T);
                                      CloseFile(TF)
                                  except
                                    try CloseFile(TF) except end;
                                    ShowMessage(#13+pL+'Exception writing to file '+SaveDialog2.Filename+pR+#13)
                                  end
      end;
// END (SAVE TEXT TO FILE) /////////////////////////////////////////////////////

{###} if timeout then sprint(space(16)+#13+'** timeout error **'+#13#10);
      XMsave:=false                                                    // unblock keyboard, etc.
    end;

    Timer3.Enabled:=true;                                              // enable further Timer3 events
    exit
  end;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////  
