#define _DISABLE_OPENADC10_CONFIGPORT_WARNING
#define _SUPPRESS_PLIB_WARNING

#include <plib.h>
#include "cfunctions.h"

#pragma config JTAGEN = OFF

#define dat Option->LCD_Reset 
#define clk Option->LCD_CD
#define addr 0x38
#define SetHi(p) PinSetBit(p, TRISSET) 
#define SetLo(p) PinSetBit(p, TRISCLR)

// delay for a certain number of core timer ticks (one tick every 50nS at 40MHz CPU speed, 100nS at 20MHz, etc) 
void Delay(unsigned int ticks) { 
    unsigned int current_ticks; 
    asm volatile("mfc0   %0, $9" : "=r"(current_ticks));            // get the core timer ticks 
    ticks += current_ticks;                                         // this is what we want to count up to 
     do { 
         asm volatile("mfc0   %0, $9" : "=r"(current_ticks));       // get the core timer ticks 
     } while(current_ticks < ticks); 
} 

// I2C Start condition, data line goes low when clock is high 
void BBStart(int speed) { 
    SetHi(dat); 
    SetHi(clk); 
    Delay(speed); 
    SetLo(dat); 
    Delay(speed); 
    SetLo(clk); 
    Delay(speed); 
} 


// I2C Stop condition, clock goes high when data is low 
void BBStop (int speed) { 
    SetLo(clk); 
    SetLo(dat); 
    Delay(speed); 
    SetHi(clk); 
    Delay(speed); 
    SetHi(dat); 
    Delay(speed); 
} 


// I2C write a bit 
void BBWriteBit(int speed, int timeout, int bit) { 
    int i = 0; 
    if(bit) 
        SetHi(dat); 
    else 
        SetLo(dat); 
    SetHi(clk); 
    asm volatile("mtc0   %0, $9": "+r"(i));       // set the core timer to zero 
    while(!PinRead(clk)) {                        // Wait for clock to go high - clock stretching 
         asm volatile("mfc0   %0, $9" : "=r"(i)); // get the core timer ticks 
         if(i >= timeout)  
         return;                                  // return nothing if there is a timeout 
    } 
    Delay(speed); 
    SetLo(clk); 
} 


// I2C read a bit 
int BBReadBit(int speed, int timeout) { 
    int i = 0; 
    SetHi(dat); Delay(speed); 
    SetHi(clk); Delay(speed); 
    asm volatile("mtc0   %0, $9": "+r"(i));         // set the core timer to zero 
    while(!PinRead(clk)) {                          // Wait for clock to go high - clock stretching 
         asm volatile("mfc0   %0, $9" : "=r"(i));   // get the core timer ticks 
         if(i >= timeout) 
             return 0;                              // return nothing if there is a timeout 
    } 
    i = PinRead(dat); 
    SetLo(clk); 
    return i; 
} 


// I2C Write, returns true if ACK received 
int BBWriteByte(int speed, int timeout, unsigned char data) { 
    int i; 
    for(i = 0; i < 8; i++) { 
        BBWriteBit(speed, timeout, (data & 0x80)); 
        data  <<= 1; 
    } 
    return !BBReadBit(speed, timeout); // read the ACK bit and return true is ACK received 
} 

// I2C read a bit 
int BBReadByte(int speed, int timeout,unsigned char ack) { 
    unsigned char get_data, i = 0;
    ExtCfg(Option->LCD_Reset,EXT_DIG_IN,0);//set input
    for(i = 0; i < 8; i++)
    {
        get_data<<=1;
        BBReadBit(speed,timeout);
    }
    ExtCfg(Option->LCD_Reset,EXT_DIG_OUT,0);//set output
    if(ack)
        SetLo(dat);
    else
        SetHi(dat);
    SetHi(clk);
    Delay(speed);
    SetLo(clk);
    Delay(speed);
    return get_data;
} 

//write one byte to REG
void FT6206_Write_Reg(int reg, unsigned char data)
{
   unsigned  int speed= (CurrentCpuSpeed/1600000); 
   unsigned int timeout = (CurrentCpuSpeed/2000) * 5000; // calculate the number of core timer ticks for the timeout (5mS)
   BBStart(speed);
   BBWriteByte(speed, timeout, (addr << 1));
   BBWriteByte(speed, timeout, reg);
   BBWriteByte(speed, timeout, data);
   BBStop(speed);
}
//read one byte from REG
int FT6206_Read_Reg(int reg,unsigned char ack)
{
   unsigned char data;
   unsigned int speed= (CurrentCpuSpeed/1600000); 
   unsigned int timeout = (CurrentCpuSpeed/2000) * 5000; // calculate the number of core timer ticks for the timeout (5mS)
   BBStart(speed);
   BBWriteByte(speed, timeout, (addr << 1));
   BBWriteByte(speed, timeout, reg);
   BBStart(speed);
   BBWriteByte(speed, timeout, ((addr << 1)|(0x01)));
   data = BBReadByte(speed, speed, ack);
   BBStop(speed);
   return data;
}
long long main(long long *CD, long long *RST)
{
    Option->LCD_Reset=*RST; 
    Option->LCD_CD=*CD;
    PinSetBit(Option->LCD_Reset, LATCLR); 
    ExtCfg(Option->LCD_Reset,EXT_DIG_OUT,0);ExtCfg(Option->LCD_Reset,EXT_BOOT_RESERVED,0); 
    PinSetBit(Option->LCD_CD, LATCLR); 
    ExtCfg(Option->LCD_CD,EXT_DIG_OUT,0);ExtCfg(Option->LCD_CD,EXT_BOOT_RESERVED,0);
    return 0;
}