Option Explicit On

Mode 3, 8
Const RED = Rgb(255, 0, 0)
Const GREEN = Rgb(0, 255, 0)
Const BLUE = Rgb(0, 0, 255)
Dim COLORS(1) = (RED, GREEN)
Const ARRAY = 1
Const SCALAR = 0

boxes(ARRAY)      : wait_for_space()
boxes(SCALAR)     : wait_for_space()
circles(ARRAY)    : wait_for_space()
circles(SCALAR)   : wait_for_space()
lines(ARRAY)      : wait_for_space()
lines(SCALAR)     : wait_for_space()
pixels(ARRAY)     : wait_for_space()
pixels(SCALAR)    : wait_for_space()
polygons(ARRAY)   : wait_for_space()
polygons(SCALAR)  : wait_for_space()
rboxes(ARRAY)     : wait_for_space()
rboxes(SCALAR)    : wait_for_space()
triangles(ARRAY)  : wait_for_space()
triangles(SCALAR) : wait_for_space()

Sub wait_for_space()
  Do : Loop Until Inkey$ = ""
  Do : Loop Until Inkey$ = " "
End Sub

Sub boxes(color_array)
  Local x(1), y(1), w(1), h(1), lw(1)
  x(0) = 0  : y(0) = 0  : w(0) = 100 : h(0) = 200 : lw(0) = 1
  x(1) = 50 : y(1) = 50 : w(1) = 50  : h(1) = 100 : lw(1) = 1

  Cls

  If color_array Then
    Box x(), y(), w(), h(), lw(), COLORS(), COLORS()
  Else
    Box x(), y(), w(), h(), lw(), BLUE, BLUE
  EndIf
End Sub

Sub circles(color_array)
  Local x(1), y(1), r(1), lw(1), a(1)
  x(0) = 50 : y(0) = 50 : r(0) = 50 : lw(0) = 1 : a(0) = 1
  x(1) = 150 : y(1) = 150 : r(1) = 30 : lw(1) = 1 : a(1) = 1

  Cls

  If color_array Then
    ' NOT GREAT: the circle perimeter has uncoloured pixels
    Circle x(), y(), r(), lw(), a(), COLORS(), COLORS()
  Else
    ' FAILS: draws an unfilled blue circle and a blue circle with a white fill
    Circle x(), y(), r(), lw(), a(), BLUE, BLUE
  EndIf
End Sub

Sub lines(color_array)
  Local x1(1), y1(1), x2(1), y2(1), lw(1)
  x1(0) = 0 : y1(0) = 0   : x2(0) = 100 : y2(0) = 100 : lw(0) = 1
  x1(1) = 0 : y1(1) = 100 : x2(1) = 150 : y2(1) = 150 : lw(1) = 1

  Cls

  If color_array Then
    Line x1(), y1(), x2(), y2(), lw(), COLORS()
  Else
    Line x1(), y1(), x2(), y2(), lw(), BLUE
  EndIf
End Sub

Sub pixels(color_array)
  Local x(1), y(1)
  x(0) = 50 : y(0) = 70
  x(1) = 30 : y(1) = 100

  Cls

  If color_array Then
    Pixel x(), y(), COLORS()
  Else
    Pixel x(), y(), BLUE
  EndIf
End Sub

Sub polygons(color_array)
  Local n(1)
  n(0) = 3 : n(1) = 3

  ' Why did you explicitly say the x & y arrays are integer arrays in your post
  ' and in the current version of the MMBasic manual when this is not the case
  ' for the documentation of other graphics functions?
  Local x%(5) = (0, 100, 100, 110, 210, 210)
  Local y%(5) = (0,   0, 100, 100, 100, 200)

  Cls

  If color_array Then
    Polygon n(), x%(), y%(), COLORS(), COLORS()
  Else
    Polygon n(), x%(), y%(), BLUE, BLUE
  EndIf
End Sub

Sub rboxes(color_array)
  Local x(1), y(1), w(1), h(1), r(1)
  x(0) = 0  : y(0) = 0  : w(0) = 100 : h(0) = 200 : r(0) = 10
  x(1) = 50 : y(1) = 50 : w(1) = 50  : h(1) = 100 : r(1) = 10

  Cls

  If color_array Then
    Rbox x(), y(), w(), h(), r(), COLORS(), COLORS()
  Else
    ' FAILS: draws two unfilled blue boxes that slowly fade to black !!!
    Rbox x(), y(), w(), h(), r(), BLUE, BLUE
  EndIf
End Sub

Sub triangles(color_array)
  Local x1(1), y1(1), x2(1), y2(1), x3(1), y3(1)
  x1(0) = 0   : y1(0) = 0
  x2(0) = 100 : y2(0) = 0
  x3(0) = 100 : y3(0) = 100
  x1(1) = 110 : y1(1) = 100
  x2(1) = 210 : y2(1) = 100
  x3(1) = 210 : y3(1) = 200

  Cls

  If color_array Then
    Triangle x1(), y1(), x2(), y2(), x3(), y3(), COLORS(), COLORS()
  Else
    ' FAILS with Error: Dimensions
    Triangle x1(), y1(), x2(), y2(), x3(), y3(), BLUE, BLUE
  EndIf
End Sub
