  MODE 1,8
  CLS

  '***********************************
  ' Build the lander sprites.
  ' The sprite file only contains images of the lander straight up
  ' with and without rocket burn. For nice rotation, 18 more images
  ' are generated, every 5 degrees, from 5 to 90 degrees (counter clockwise.)
  ' The rest of the circle is done by mirroring the sprite sideways/
  ' vertically/both.
  ' The base image is loaded onto page 2.
  ' Then the 90` rotation is built across the page on a 40 pixel grid.
  ' Finally, the 38 total sprites are then yanked from the page.
  PAGE WRITE 2
  CLS

  ' The CMM2 5.05.06 firmware fixes a "bug" present in the direction of rotation
  ' produced by the IMAGE ROTATE command of the 5.05.05 firmware. This code is
  ' intended to identify and use the correct rotation.
  PIXEL 0,1  ' draw one white pixel, left edge middle of a 3x3 region
  IMAGE ROTATE 0,0,3,3,0,0,90
  IF PEEK(byte mm.info(page address 2) + 1) = 255 THEN ' test for pixel top center
    rotfactor = -1
  ELSE
    rotfactor = 1
  ENDIF
  CLS

  LOAD PNG "LanderPict.png"

  ' generate the rotations
  FOR i = 1 TO 18
    IMAGE ROTATE 0, 0,40,40,i*40, 0,i*5*rotfactor
    IMAGE ROTATE 0,40,40,40,i*40,40,i*5*rotfactor
  NEXT i

  ' populate the sprites
  FOR i = 1 TO 19
    SPRITE READ i,(i-1)*40,0,40,40
    SPRITE READ 20+i,(i-1)*40,40,40,40
  NEXT i

  PAGE WRITE 1
  CLS
  PAGE COPY 2,0,B
  Do : Loop
