' Transpiled on 22-11-2020 14:26:30

' Copyright (c) 2020 Thomas Hugo Williams

Option Base 0
Option Default None
Option Explicit On

' BEGIN:     #Include "../common/array.inc" ------------------------------------
' Copyright (c) 2020 Thomas Hugo Williams
' For Colour Maximite 2, MMBasic 5.05

' Gets the upper-bound that should be used to dimension an array of the given
' capacity, irrespective of OPTION BASE.
'
' e.g. To create a string array that can hold 10 elements:
'        Dim my_array$(array.new%(10))
Function array.new%(capacity%)
  array.new% = capacity% + Mm.Info(Option Base) - 1
End Function

' Case-sensitive binary search for a value in a SORTED array.
'
' @param  a$()    the array.
' @param  s$      the value to search for.
' @param  flags$  "i" to search case-insensitively,
' @param  lb%     the lower bound to search from,
'                 if 0/unset then search from the first element.
' @param  ub%     the upper bound to search from,
'                 if 0/unset then search from the last element.
' @return         the index of the element containing the value,
'                 or -1 if not present.
Function array.bsearch%(a$(), s$, flags$, lb%, ub%)
  Local lb_% = Max(Mm.Info(Option Base), lb%)
  Local ub_% = ub%
  If ub_% = 0 Then ub_% = Bound(a$(), 1)
  Local i%

  If InStr(UCase$(flags$), "I") Then
    Local us$ = UCase$(s$)
    Local ua$
    Do While ub_% >= lb_%
      i% = (lb_% + ub_%) \ 2
      ua$ = UCase$(a$(i%))
      If us$ > ua$ Then
        lb_% = i% + 1
      ElseIf us$ < ua$ Then
        ub_% = i% - 1
      Else
        Exit Do
      EndIf
    Loop
  Else
    Do While ub_% >= lb_%
      i% = (lb_% + ub_%) \ 2
      If s$ > a$(i%) Then
        lb_% = i% + 1
      ElseIf s$ < a$(i%) Then
        ub_% = i% - 1
      Else
        Exit Do
      EndIf
    Loop
  EndIf

  If ub_% >= lb_% Then array.bsearch% = i% Else array.bsearch% = -1
End Function

' Gets the capacity (number of elements) that string array a$() can hold.
Function array.capacity%(a$())
  array.capacity% = Bound(a$(), 1) - Bound(a$(), 0) + 1
End Function

' Copies a string array.
'
' @param  src$()    the source array.
' @param  dst$()    the destination array.
' @param  flags$    "r" to copy elements in reverse order.
' @param  src_idx%  the start index in the source,
'                   if 0/unset then use the index of the first element.
' @param  dst_idx%  the start index in the destination,
'                   if 0/unset then use the index of the first element.
' @param  num%      the number of elements to copy,
'                   if 0/unset then copy all the elements (from idx%) from the source.
Sub array.copy(src$(), dst$(), src_idx%, dst_idx%, num%)
  Local base% = Mm.Info(Option Base 0)
  Local i%
  Local j% = Max(base%, dst_idx%)
  Local lb% = Max(base%, src_idx%)
  Local ub% = src_idx% + num% - 1
  If num% = 0 Then ub% = Bound(src$(), 1)

  ' TODO: Use a memory copy instead of a loop.
  For i% = lb% To ub% : dst$(j%) = src$(i%) : Inc j% : Next
End Sub

' Fills all the elements of string array a$() to x$.
Sub array.fill(a$(), x$)
  Local lb% = Bound(a$(), 0)
  Local ub% = Bound(a$(), 1)
  Local i%
  For i% = lb% To ub% : a$(i%) = x$ : Next
End Sub

' Sorts a string array.
'
' @param  array$()  array to sort
' @param  flags$  "i" to sort case-insensitively,
'                 "d" to sort into descending order.
' @param  idx%    the index in array$() to sort from,
'                 if 0/unset then use the index of the first element.
' @param  num%    the number of elements to sort,
'                 if 0/unset then sort all the elements (from idx%) in array$().
Sub array.sort(a$(), flags$, idx%, num%)
  Local base% = Mm.Info(Option Base)
  Local lb% = Max(idx%, base%)
  Local num_% = num%
  If num_% = 0 Then num_% = Bound(a$(), 1) - lb% + 1
  If num_% <= 1 Then Exit Sub
  Local ub% = lb% + num_% - 1

  ' If possible just use the default sort.
  If lb% = base% Then
    If ub% = Bound(a$(), 1) Then
      If flags$ = "" Then Sort a$() : Exit Sub
    EndIf
  EndIf

  Local tmp$(array.new%(num_%))
  Local i%
  Local j% = base%

  If InStr(UCase$(flags$), "I") Then
    ' Case-insensitive sort.
    Local tmp_ub% = Bound(tmp$(), 1)
    Local indexes%(array.new%(num_%))
    For i% = lb% To ub% : tmp$(j%) = UCase$(a$(i%)) : Inc j% : Next
    Sort tmp$(), indexes%()
    For i% = base% To tmp_ub% : tmp$(i%) = a$(indexes%(i%) + lb% - base%) : Next
  Else
    ' Case-sensitive sort.
    ' TODO: Use a memory copy instead of a loop.
    For i% = lb% To ub% : tmp$(j%) = a$(i%) : Inc j% : Next
    Sort tmp$()
  EndIf

  j% = base%
  If InStr(UCase$(flags$), "D") Then
    ' Descending sort.
    For i% = ub% To lb% Step -1 : a$(i%) = tmp$(j%) : Inc j% : Next
  Else
    ' Ascending sort.
    ' TODO: Use a memory copy instead of a loop.
    For i% = lb% To ub% : a$(i%) = tmp$(j%) : Inc j% : Next
  EndIf
End Sub
' END:       #Include "../common/array.inc" ------------------------------------
' BEGIN:     #Include "../common/file.inc" -------------------------------------
' Copyright (c) 2020 Thomas Hugo Williams
' For Colour Maximite 2, MMBasic 5.05

Const FIL.PROG_DIR$ = fil.get_parent$(Mm.Info$(Current))

Function check_file_included%() : End Function

' Does the file/directory 'f$' exist?
'
' @return 1 if the file exists, otherwise 0
Function fil.exists%(f$)
  Local f_$ = fil.get_canonical$(f$)
  If f_$ = "A:" Then
    fil.exists% = 1
  Else
    fil.exists% = Mm.Info(FileSize f_$) <> -1
  EndIf
End Function

' Find files whose names match pattern$
'
' @param   path$     root directory to start looking from.
' @param   pattern$  file pattern to match on, e.g. "*.bas".
' @param   type$     type of files to return, "dir", "file" or "all".
' @return  the absolute path to the first match found. To retrieve subsequent
'          matches call this function with no parameters, i.e. f$ = fil.find().
'          Returns the empty string if there are no more matches.
'
' TODO: In order to return the files in alphabetical order this uses a 128K workspace.
'       I think there is another potential implementation where it just records the last
'       file returned by the previous call and restarts the search from there, however
'       that would be much slower and probably better implemented as a CSUB.
Function fil.find$(path$, pattern$, type$)
  Static stack$(list.new%(1000)) Length 128 ' 128K workspace.
  Static pattern_$
  Static type_$
  Local base% = Mm.Info(Option Base)
  Local f$, is_dir%, lb%, name$, num%

  If path$ <> "" Then
    list.init(stack$())
    f$ = fil.get_canonical$(path$)
    list.push(stack$(), f$)
    pattern_$ = pattern$
    If pattern_$ = "" Then pattern_$ = "*"
    type_$ = UCase$(type$)
    If type_$ = "" Then type_$ = "FILE"
    If InStr("|ALL|DIR|FILE|", "|" + type_$ + "|") < 1 Then Error "unknown type: " + type_$
  EndIf

  Do
'    list.dump(stack$())
    Do
      fil.find$ = list.pop$(stack$())
      If fil.find$ = list.NULL$ Then fil.find$ = "" : Exit Function
      name$ = fil.get_name$(fil.find$)
    Loop Until name$ <> ".git" ' Doesn't recurse into .git directories.

    ' If it is a directory then expand it.
    is_dir% = fil.is_directory%(fil.find$)
    If is_dir% Then
      lb% = base% + list.size%(stack$())
      If type_$ = "DIR" Then f$ = Dir$(fil.find$ + "/*", Dir) Else f$ = Dir$(fil.find$ + "/*", All)
      Do While f$ <> ""
        list.push(stack$(), fil.find$ + "/" + f$)
        f$ = Dir$()
      Loop

      ' Sort the newly pushed dirs/files so that those beginning 'a|A'
      ' are at the top and those beginning 'z|Z' are near the bottom.
      num% = base% + list.size%(stack$()) - lb%
      If num% > 0 Then array.sort(stack$(), "id", lb%, num%)
    EndIf

    ' I've profiled it and its faster to do the name checks before the type checks.
    If fil.fnmatch%(pattern_$, name$) Then
      Select Case type_$
        Case "ALL"  : Exit Do
        Case "DIR"  : If is_dir% Then Exit Do
        Case "FILE" : If Not is_dir% Then Exit Do
      End Select
    EndIf

  Loop

End Function

' Does name$ match pattern$ ?
'
' @param   pattern$  *nix style 'shell wildcard' pattern.
' @param   name$     the name to test.
' @return  1 if the name matches the pattern otherwise 0.
Function fil.fnmatch%(pattern$, name$)
  Local p$ = UCase$(pattern$)
  Local n$ = UCase$(name$)
  Local c%, px% = 1, nx% = 1, nextPx% = 0, nextNx% = 0

  Do While px% <= Len(p$) Or nx% <= Len(n$)

    If px% <= Len(p$) Then

      c% = Peek(Var p$, px%)
      Select Case c%
        Case 42 ' *
          ' Zero-or-more-character wildcard
          ' Try to match at sx%,
          ' if that doesn't work out,
          ' restart at nx%+1 next.
          nextPx% = px%
          nextNx% = nx% + 1
          Inc px%
          Goto fil.fnmatch_cont

        Case 63 ' ?
          ' Single-character wildcard
          If nx% <= Len(n$) Then
            Inc px%
            Inc nx%
            Goto fil.fnmatch_cont
          EndIf

        Case Else
          ' Ordinary character
          If nx% <= Len(n$) Then
            If c% = Peek(Var n$, nx%) Then
              Inc px%
              Inc nx%
              Goto fil.fnmatch_cont
            EndIf
          EndIf
      End Select

    EndIf

    If nextNx% > 0 Then
      If nextNx% <= Len(n$) + 1 Then
        px% = nextPx%
        nx% = nextNx%
        Goto fil.fnmatch_cont
      EndIf
    EndIf

    Exit Function

    fil.fnmatch_cont:

  Loop

  fil.fnmatch% = 1

End Function

' Gets the canonical path for file/directory 'f$'.
Function fil.get_canonical$(f$)
  Local elements$(list.new%(20)) Length 128
  Local lb% = Bound(elements$(), 0)

  list.init(elements$())

  If fil.is_absolute%(f$) Then
    If Instr(UCase$(f$), "A:") = 1 Then
      str.tokenise(f$, "/\", elements$())
    Else
      str.tokenise("A:" + f$, "/\", elements$())
    EndIf
  Else
    str.tokenise(Cwd$ + "/" + f$, "/\", elements$())
  EndIf

  elements$(lb%) = "A:"

  Local num_elements% = list.size%(elements$())
  Local i% = lb%
  Do While i% < lb% + num_elements%
    If elements$(i%) = "." Then
      list.remove(elements$(), i%)
    ElseIf elements$(i%) = ".." Then
      list.remove(elements$(), i%)
      list.remove(elements$(), i% - 1)
      i% = i% - 1
    Else
      i% = i% + 1
    EndIf
  Loop

  fil.get_canonical$ = str.join$(elements$(), "/")
End Function

' Gets the name of file/directory 'f$' minus any path information.
Function fil.get_name$(f$)
  Local i%

  For i% = Len(f$) To 1 Step -1
    If InStr("/\", Mid$(f$, i%, 1)) > 0 Then Exit For
  Next i%

  fil.get_name$ = Mid$(f$, i% + 1)
End Function

' Gets the parent directory of 'f$', or the empty string if it does not have one.
Function fil.get_parent$(f$)
  Local i%

  For i% = Len(f$) To 1 Step -1
    If InStr("/\", Mid$(f$, i%, 1)) > 0 Then Exit For
  Next i%

  If i% > 0 Then fil.get_parent$ = Left$(f$, i% - 1)
End Function

Function fil.is_absolute%(f$)
  fil.is_absolute% = 1
  If InStr(f$, "/") = 1 Then Exit Function
  If InStr(f$, "\") = 1 Then Exit Function
  If InStr(UCase$(f$), "A:\") = 1 Then Exit Function
  If InStr(UCase$(f$), "A:/") = 1 Then Exit Function
  If UCase$(f$) = "A:" Then Exit Function
  fil.is_absolute% = 0
End Function

Function fil.is_directory%(f$)
  Local f_$ = fil.get_canonical$(f$)
  If f_$ = "A:" Then
    fil.is_directory% = 1
  Else
    fil.is_directory% = Mm.Info(FileSize f_$) = -2
  EndIf
End Function

' Makes directory 'f$' if it does not already exist.
Sub fil.mkdir(f$)
  If Not fil.exists%(f$) Then MkDir f$
End Sub
' END:       #Include "../common/file.inc" -------------------------------------
' BEGIN:     #Include "../common/list.inc" -------------------------------------
' Copyright (c) 2020 Thomas Hugo Williams

Function check_list_included%() : End Function

' Used as the value for elements beyond the size of the list.
Const list.NULL$ = String$(4, Chr$(&h7F))

' Gets the upper-bound that should be used to dimension an array to hold a list
' of the given capacity, irrespective of OPTION BASE.
'
' e.g. To create a string array that can be used as a list of 10 elements:
'        Dim my_list$(list.new%(10))
Function list.new%(capacity%)
  list.new% = capacity% + Mm.Info(Option Base)
End Function

' Gets the capacity of the list.
Function list.capacity%(list$())
  list.capacity% = Bound(list$(), 1) - Bound(list$(), 0)
End Function

' Initialises the list.
Sub list.init(lst$())
  Local i%
  For i% = Bound(lst$(), 0) To Bound(lst$(), 1)
    lst$(i%) = list.NULL$
  Next
  lst$(Bound(lst$(), 1)) = "0"
End Sub

' Appends an element to the end of the list.
Sub list.add(lst$(), s$)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  lst$(lb% + sz%) = s$
  lst$(ub%) = Str$(sz% + 1)
End Sub

' Clears the list and resets its size to 0.
Sub list.clear(lst$())
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  Local i%
  For i% = lb% To lb% + sz% - 1
    lst$(i%) = list.NULL$
  Next
  lst$(ub%) = "0"
End Sub

' Prints the contents of the list.
Sub list.dump(lst$())
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  Local i%
  For i% = lb% To lb% + sz% - 1
    Print "[" Str$(i%) "] " lst$(i%)
  Next
  Print "END"
End Sub

' Gets a list element with bounds checking.
' To get a list element without bounds checking just do s$ = lst$(index%) directly.
Function list.get$(lst$(), index%)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  If index% >= lb% + sz% Then Error "index out of bounds: " + Str$(index%) : Exit Function
  list.get$ = lst$(index%)
End Function

' Inserts an element into the list.
Sub list.insert(lst$(), index%, s$)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  Local i%
  If index% >= lb% + sz% + 1 Then Error "index out of bounds: " + Str$(index%) : Exit Function
  For i% = lb% + sz% To lb% + index% + 1 Step -1
    lst$(i%) = lst$(i% - 1)
  Next
  lst$(i%) = s$
  lst$(ub%) = Str$(sz% + 1)
End Sub

' Returns the element at the end of the list.
' If the list is empty then returns list.NULL$
Function list.peek$(lst$())
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  If sz% > 0 Then list.peek$ = lst$(lb% + sz% - 1) Else list.peek$ = list.NULL$
End Function

' Removes and returns the element at the end of the list.
' If the list is empty then returns list.NULL$
Function list.pop$(lst$())
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  If sz% > 0 Then
    list.pop$ = lst$(lb% + sz% - 1)
    lst$(ub%) = Str$(sz% - 1)
  Else
    list.pop$ = list.NULL$
  EndIf
End Function

' Synonym for add().
Sub list.push(lst$(), s$)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  lst$(lb% + sz%) = s$
  lst$(ub%) = Str$(sz% + 1)
End Sub

' Removes an element from the list.
Sub list.remove(lst$(), index%)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  Local i%
  If index% >= lb% + sz% Then Error "index out of bounds: " + Str$(index%) : Exit Sub
  For i% = index% To lb% + sz% - 2
    lst$(i%) = lst$(i% + 1)
  Next
  lst$(i%) = list.NULL$
  lst$(ub%) = Str$(sz% - 1)
End Sub

' Sets a list element with bounds checking.
' To set a list element without bounds checking just do lst$(index%) = s$ directly.
Sub list.set(lst$(), index%, s$)
  Local lb% = Bound(lst$(), 0)
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  If index% >= lb% + sz% Then Error "index out of bounds: " + Str$(index%) : Exit Sub
  lst$(index%) = s$
End Sub

' Sorts the list.
Sub list.sort(lst$())
  Local ub% = Bound(lst$(), 1)
  Local sz% = Val(lst$(ub%))
  lst$(ub%) = list.NULL$
  Sort lst$()
  lst$(ub%) = Str$(sz%)
End Sub

' Gets the size of the list.
Function list.size%(list$())
  list.size% = Val(list$(Bound(list$(), 1)))
End Function
' END:       #Include "../common/list.inc" -------------------------------------
' BEGIN:     #Include "../common/strings.inc" ----------------------------------
' Copyright (c) 2019-20 Thomas Hugo Williams
' For Colour Maximite 2, MMBasic 5.05

Function check_strings_included() : check_strings_included = 1 : End Function

Function str.centre$(s$, x%)
  If Len(s$) < x% Then
    str.centre$ = Space$((x% - Len(s$)) \ 2) + s$
    str.centre$ = str.centre$ + Space$(x% - Len(str.centre$))
  Else
    str.centre$ = s$
  EndIf
End Function

Sub str.tokenise(s$, sep$, lst$())
  Local c$, i%, start% = 1
  For i% = 1 To Len(s$)
    c$ = Mid$(s$, i%, 1)
    If Instr(sep$, c$) > 0 Then
      list.add(lst$(), Mid$(s$, start%, i% - start%))
      start% = i% + 1
    EndIf
  Next i%

  If i% > start% Then list.add(lst$(), Mid$(s$, start%, i% - start%))
End Sub

Function str.join$(lst$(), ch$)
  Local lb% = Bound(lst$(), 0)
  Local sz% = list.size%(lst$())
  Local i%
  For i% = lb% To lb% + sz% - 1
    If i% > lb% Then str.join$ = str.join$ + ch$
    str.join$ = str.join$ + lst$(i%)
  Next i%
End Function

Function str.lpad$(s$, x%)
  str.lpad$ = s$
  If Len(s$) < x% Then str.lpad$ = Space$(x% - Len(s$)) + s$
End Function

' Returns the next space separated token from a string.
' Any excess spaces are ignored, empty tokens are never returned
' except when there are no tokens remaining.
'
' @param[in, out]  on input the string,
'                  on output the remainder of the string after the
'                  next token has been returned.
' @return          the next token, or the empty string if there are
'                  no more tokens.
Function str.next_token$(s$)
  Local en%, st% = 1
  Do
    en% = InStr(st%, s$, " ")
    If en% < 1 Then
      str.next_token$ = Mid$(s$, st%)
      s$ = ""
      Exit Function
    EndIf

    If en% = st% Then
      st% = st% + 1
    Else
      str.next_token$ = Mid$(s$, st%, en% - st%)
      s$ = Mid$(s$, en%)
      Exit Function
    EndIf
  Loop
End Function

Function str.rpad$(s$, x%)
  str.rpad$ = s$
  If Len(s$) < x% Then str.rpad$ = s$ + Space$(x% - Len(s$))
End Function
' END:       #Include "../common/strings.inc" ----------------------------------

Dim f$ = fil.find$(Cwd$, Mm.CmdLine$, "all")
Do While f$ <> ""
  Print f$
  f$ = fil.find$()
Loop
