  '=============================================================================|
  ' PicoRocks in Space - Teaser
  '
  ' written by Vegipete, Jan 2024
  ' Ported from CMM2 (somewhat)
  '
  ' needs:
  ' OPTION CPUSPEED 252000 (KHz)
  ' OPTION KEYBOARD xx,0,0,0,0  xx=country code i.e. UK, US

  '=============================================================================
  ' Versions
  ' rocks1      adapt VegiPete version to 640x80, copy some from CMM2 version
  ' rocks2      fly the ship
  ' rocks3      fire gun, detect asteroid hit
  ' rocks4      hit asteroids, split when hit, clear keyboard buffer
  ' rocks5_MH   MartinH changes, Fleet shown, respawn
  ' rocks6      much research about shooting,, nothing new
  ' rocks7      initial scores, initial levels
  ' rocks8      adapt to official arcade rules
  ' rocks9      UFO's essential implemented, lacking finesse and aiming(small ufo)
  ' rocks10     Several gameplay changes
  ' rocks10t    Test version with fast PS2 keyboard support, but no USB support
  ' rocks11     Sounds, simple game end, ufo moves, ufo hit ship, single line NES disable.
  ' rocks12     Minor changes to increase fun
  ' rocks13     New SFX from Martin, some timing improvements

  If Mm.Device$ = "MMB4L" Then Option Simulate "PicoMiteVGA"

  Option DEFAULT INTEGER
  ' Option LCDPANEL NOCONSOLE
  option angle degrees

  NES_Controller=1    'set to 0 for keyboard control

  Const USE_PS2 = 1
  Dim ps2_scan_map%(31)

  'screen setup
  mode 1:cls 0:font 10

  'Init NES-Controller on port DB9 of PicoGameVGA
  if NES_Controller then Init_NES
  If USE_PS2 Then init_ps2_input()

  'game initialisation, array init default with 0
  const MAXROCKS = 26         ' arcade rule, was 50
  dim float rock(MAXROCKS,7)  ' rocks: scale,angle,x,y,vx,vy,a,da
  dim trock (MAXROCKS)        ' type of rock
  dim float v(1)              ' for math
  dim float pv,px,py,pvx,pvy  ' ship parameter

  ' rock vector shapes
  ' Note: any resemblance to a country is purely coincidental
  dim r1x(14)=( 0, 3, 4, 3, 5, 4, 1,-2,-4,-5,-3,-5,-3,-2, 0)
  dim r1y(14)=( 5, 4, 3, 1, 0,-4,-5,-4,-4,-1,-1, 2, 3, 5, 5)
  dim r2x(14)=( 0,-2,-3,-4,-5,-4,-4,-3,-1, 4, 4, 5, 4, 2, 0)
  dim r2y(14)=(-6,-4,-3,-4,-1, 2, 3, 3, 5, 3, 1, 0,-3,-4,-6)
  dim r3x(14)=( 1,-2,-2,-4,-4,-5,-5,-3,-2, 0, 4, 3, 5, 3, 1)
  dim r3y(14)=(-4,-5,-3,-4,-2, 0, 3, 4, 3, 5, 3, 2, 1,-5,-4)
  dim r4x(14)=( 0,-2,-4,-4,-5,-3,-1, 2, 1, 3, 5, 3, 4, 3, 0)
  dim r4y(14)=(-5,-4,-4,-1, 1, 4, 5, 5, 3, 4, 1,-2,-3,-4,-5)

  ' ufo data
  dim ufo(5)      ' type 0/1/2,xpos,ypos,xvel,yvel,life ' ufo data
  ufolife = 10000 ' max ufo lifetime

  'UFO shape
  dim ux(11)=( 2,-2,-6,-2, 2, 6,-6, 6, 2, 2,-2,-2)
  dim uy(11)=(-4,-4, 0, 4, 4, 0, 0, 0,-4,-6,-6,-4)

  'Javavi artwork alternative
  'Dim r1x(14)=( 5, 5, 1,-1, 4, 5, 5,-5,-5,-1, 1,-4,-5,-5, 5)  'Z
  'Dim r1y(14)=( 5, 3, 0,-3,-3,-2,-5,-5,-3, 0, 3, 3, 2, 5, 5)
  'Dim r2x(14)=( 0, 4, 5, 4, 0, 0,-3, 0, 3, 0, 0,-4,-5,-4, 0)  'O
  'Dim r2y(14)=( 5, 4, 0,-4,-5,-4, 0, 4, 0,-4,-5,-4, 0, 4, 5)
  'Dim r3x(14)=( 1, 3, 2, 5, 5, 2, 1,-1,-2,-5,-5,-2,-3,-1, 1)  'V
  'Dim r3y(14)=(-2, 3, 5, 5, 3,-4,-5,-5,-4, 4, 5, 5, 3,-2,-2)
  'Dim r4x(14)=( 1, 2, 5, 5, 2, 2, 5, 5, 3,-3,-5,-5,-3,-3, 1)  'T
  'Dim r4y(14)=( 5, 3, 3, 2, 2, 0,-1,-3,-5,-5,-3, 0, 0, 5, 5)

  ' player ship and exhaust flame shapes
  dim shpx(4)=(0,-6,0,6,0)
  dim shpy(4)=(-10,10,6,10,-10)
  dim flmx(4)=(0,-2,0,2,0)
  dim flmy(4)=(8,10,14,10,8)

  FRAMEBUFFER Create   ' hidden layer to draw scene
  FRAMEBUFFER Write F : CLS

  ph = 0 : pv = 0
  px = MM.HRES/2-6 : pvx = 0
  py = MM.VRES/2-6 : pvy = 0

  smash=0             'are you hit ?
  newrun=0            '1?
  fire=0              'are you firing bullets

  timeout=2000        'respawn time out
  hbeat=30            'minimum loop time

  score=0             'start with 0
  level=1             'game level (determies how many new rocks)

  ships=5             'to start with 5 ships
  buls=4              'arcade rule: max 4 bullets on screen
  bspd=10             'bullet speed
  dim bult(buls,4)    'n bullets (exist,x,y,velx,vely)

  'copied from CMM2 sound
  play modfile "sfx-bg.mod" '"RISsound.mod"
  'sfx_bg.mod contains following sounds
  s_fire=1:s_bigufo=2:s_miniufo=3:s_thrust=4:s_bangsmall=5
  s_bangmid=6:s_bangbig=7:s_ship=8:s_beat1=9:s_beat2=10

  'start a level
  newrocks(4) 'arcade rule 4,6,8,10,11,11,11...
  mot = timer         'motor on timer
  tm = timer + hbeat  'for loop time


  do
    tz=timer

    'stabilize loop speed and empty keyboard buffers
    k=0
    do
      If USE_PS2 Then
        k2 = get_ps2_input%()
        If k2 Then k = k2
      Else
        e$=inkey$
        if e$<>"" then k=asc(e$)
      EndIf
    loop while timer<tm
    tm = timer + hbeat

    'handling for NES controller  'adapt for Murmulator
    if NES_Controller then
      NES_Ctrl = Reading_NES_Ctrl()
      If NES_Ctrl And 1 Then k=32
      If NES_Ctrl And 16 Then k=128
      If NES_Ctrl And 64  Then k=130
      If NES_Ctrl And 128 Then k=131
      'if NES_Ctrl and xx then k=27 'end game
    end if

    'function parser
    if k then
      burn = 0
      select case k
        Case 128  ' up
          IF pvx^2 + pvy^2 < 225 then
            inc pvx, sin(ph)/2
            inc pvy,-cos(ph)/2
            Play modsample s_thrust,2   'motor hum
          end if
          mot = timer + 200   ' keep flame visible for a while
        Case 130  ' left
          inc ph,-5
          if ph < 0 then ph = 355
        Case 131  ' right
          inc ph,5
          if ph > 355 then ph = 0
        case 32 'space for fire '102 'f'for fire
          fire=1:DrawFire
        case 27
          ? : end
      end select
    endif

    'progress ship
    Inc px,pvx-(MM.HRes+10)*(px > MM.HRes)+(MM.HRes+10)*(px<5)  '@Martin
    Inc py,pvy-(MM.VRes+10)*(py > MM.VRes)+(MM.VRes+10)*(py<0)  '@Martin

    ' velocity decays away slowly
    pvx = pvx * .99 '@Volhout .995
    pvy = pvy * .99 '@Volhout .995

    'UFO creation
    if ufo(0)=0 then
      ufo(0)=(rnd < 0.005) 'once in a while create a random ufo
      if ufo(0) then
        ufo(0)=choice(rnd<level/5,1,2)        'size 1 or 2 depending level
        ufo(1)=choice(rnd<0.5,0,mm.hres)      'position x left or right
        ufo(2)=rnd*mm.vres                    'random position y
        ufo(3)=choice(rnd<0.5,3/ufo(0),-3/ufo(0)) 'speed vx depends size
        ufo(4)=0                              'speed vy
        ufo(5)=timer + rnd*ufolife            'ufo lifetime
        if ufo(0)=1 then                      'sound depends ufo type
          play modsample s_miniufo,4
        else
          play modsample s_bigufo,4
        end if
        settick 1000,ufoctrl,1                 'for lifetime management
      end if
    end if

    ' manage ufo on screen
    if ufo(0) then  'it exists
      'move and wrap around corners
      inc ufo(1),ufo(3):ufo(1)=(ufo(1)+mm.hres) mod mm.hres
      inc ufo(2),ufo(4):ufo(2)=(ufo(2)+mm.vres) mod mm.Vres
    end if

    'move the bullets on screen
    for j = 0 to buls
      if bult(j,0) then ' does this bullet exist?
        'move it, when off-screen then skip bullet
        inc bult(j,1),bult(j,3):if bult(j,1)>MM.HRES or bult(j,1)<0 then bult(j,0)=0
        inc bult(j,2),bult(j,4):if bult(j,2)>MM.VRES or bult(j,2)<0 then bult(j,0)=0
      end if
    next

    ' move rocks
    for i = 0 to MAXROCKS
      if trock(i) then   ' rock exists

        'move rocks and keep in window
        inc rock(i,2),rock(i,4):rock(i,2)=(rock(i,2)+mm.hres) mod mm.hres
        inc rock(i,3),rock(i,5):rock(i,3)=(rock(i,3)+mm.vres) mod mm.Vres

        'move bullets and check if something is hit
        for j = 0 to buls
          ' test for player bullet hitting asteroid
          if bult(j,0) then ' does this bullet exist?
            'check for hit
            v(1) = bult(j,1) - rock(i,2) 'x coordinate compare
            v(0) = bult(j,2) - rock(i,3) 'y coordinate compare
            if math(magnitude v()) < 5*rock(i,0) then
              AstHit(i,j)
              continue for
            endif
          endif
        next

        if (smash = 0) and (newrun = 0) then
          ' test for asteroid hit player ship
          v(0) = px - rock(i,2) : v(1) = py - rock(i,3)
          if math(magnitude v()) < 10 + 5*rock(i,0) then
            print "ship hit asteroid" 'debug
            smash = 1
            play modsample s_bangbig,3            ' player explosion
            if ships=0 then end_game
            inc ships,-1
            'sprd = 5    ' start the debris field
            thit=timer                      ' for respawn delay
            'new start location = centre
            px = MM.HRES/2 : pvx = 0
            py = MM.VRES/2 : pvy = 0
            AstHit(i,0) 'do damage to asteroid also
            continue for
          endif
        endif

        'test for asteroid hit ufo
        v(0) = ufo(1) - rock(i,2) : v(1) = ufo(2) - rock(i,3)
        if math(magnitude v()) < 6*ufo(0) + 5*rock(i,0) then
          ufo_end : AstHit(i,0)
        end if

        'test for bullet hit ufo or ship
        for j = 0 to buls
          if bult(j,0) then ' does this bullet exist?
            'any bullet can hit ufo
            if abs(bult(j,1)-ufo(1))<6*ufo(0) then
              if abs(bult(j,2)-ufo(2))<6*ufo(0) then
                points=1000/ufo(0)         'small ufo =1000, large = 500
                inc score,points           'update score
                if (score mod 10000)<points then inc ships,1  'add ship with every 10k
                ufo_end
                bult(j,0)=0 'bullet vaporizes with ufo
                exit for
              end if
            end if
          end if
          if bult(j,0)=2 then  'ufo bullet hit ship
            if abs(bult(j,1)-px)<10 then
              if abs(bult(j,2)-py)<10 then
                print "ship hit by ufo bullet"
                bult(j,0)=0 'bullet remove from game
                if ships=0 then end_game
                inc ships,-1
                'sprd = 5    ' start the debris field
                play modsample s_bangmid,3      ' player explosion
                thit=timer                      ' for respawn delay
                'new start location = centre
                px = MM.HRES/2 : pvx = 0
                py = MM.VRES/2 : pvy = 0
                exit for
              end if
            end if
          end if
        next

      endif
    next i

    'check win
    if math(sum trock())=0 then
      math set 0,bult()
      level_up
    end if

    cls
    DrawShip
    DrawRocks
    DrawBullet
    DrawFleet
    DrawUfo

    'score
    Box 0,0,640,480,,0 : text 0,0,str$(score,6,0)
    text 630,0,str$(timer-tz,3,0),R '@Volhout game loop time in ms
    'text 630,0,str$(mm.info(heap),8,0),R '@Volhout heap size
    'text 630,0,str$(mm.info(stack)-&h2003f800,8,0),R '@Volhout stack size
    FRAMEBUFFER copy F,N,B

  loop

sub end_game
  cls
  text mm.hres/2,mm.vres/2,"GAME OVER",CM
  text 0,0," "
  FRAMEBUFFER copy F,N,B
  print : end
end sub

sub ufo_end
  ufo(0)=0
  settick 0,0,1
end sub

sub level_up
  inc level,1
  text mm.hres/2,mm.vres/2,"LEVEL "+str$(level),CM
  newrocks((min(2*level+2,11)))
  FRAMEBUFFER copy F,N,B
  pause 3000
end sub


sub AstHit(n,m)
  local i,x,y
  print "astroid ";n;" hit" 'debug

  'rock sizes 6,4,2 give 20,50,100 points arcade rules
  points=20*(7-rock(n,0))    'progressives points
  inc score,points           'update score
  if (score mod 10000)<points then inc ships,1  'add ship with every 10k
  Play modsample s_bangsmall,3

  'handle bullet
  bult(m,0)=0 'bullet does not fly any further

  'handle rock
  if rock(n,0)<3 then   'small rock vaporizes

    trock(n)=0  'remove from game play

  else  'split the asteroid in 2 equal pieces half the size

    'rock n modify
    rock(n,0) = max(rock(n,0)-2,2)    'next size down
    x=rock(n,4) : y=rock(n,5)         'temp copy
    rock(n,4) = -cos(bult(m,3))+x     'new x velocity
    rock(n,5) = -sin(bult(m,3))+y     'new y velocity

    'find a slot for the second asteroid
    for i = 0 to MAXROCKS             'find second free slot
      if trock(i)=0 then
        print "new astroid ";i'debug
        'rock i is the new ones
        trock(i) = trock(n)           'same type of asteroid
        rock(i,0) = rock(n,0)         'both same size
        rock(i,2) = rock(n,2)         'x location
        rock(i,3) = rock(n,3)         'y location
        rock(i,4) = cos(bult(m,3))+x  'new x velocity
        rock(i,5) = sin(bult(m,3))+y  'new y velocity
        rock(i,6) = rnd*360           'starting angle random
        rock(i,7) = rock(n,7)         'rotation speed
        exit for  'found it and filles
      end if
    next

  end if

end sub


sub DrawBullet
  local i
  for i=0 to buls
    'if bult(i,0) then pixel bult(i,1),bult(i,2)
    if bult(i,0) then box bult(i,1),bult(i,2),2,2
  next
end sub

sub DrawUfo
  local x(11),y(11)
  if ufo(0) then
    math scale ux(),ufo(0),x()  'can be 1 or 2
    math scale uy(),ufo(0),y()
    math add x(),ufo(1),x()     'position ship
    math add y(),ufo(2),y()
    polygon 12,x(),y()
  end if
end sub

sub DrawShip
  local x(4),y(4)
  if smash=1 then
    if timer-thit>timeout then smash=0  'you can fly again
  else
    'off = (mot > timer) * 6624
    'this is the ship
    math scale shpx(),1,x()
    math scale shpy(),1,y()
    math v_rotate 0,0,ph,x(),y(),x(),y()
    math add x(),px,x()  ' position ship
    math add y(),py,y()
    polygon 5,x(),y()
    'this is the exhaust flame
    if mot > timer then
      math scale flmx(),1,x()
      math scale flmy(),1,y()
      math v_rotate 0,0,ph,x(),y(),x(),y()
      math add x(),px,x()  ' position rocket flame
      math add y(),py,y()
      polygon 5,x(),y()
    endif
  end if
end sub

sub DrawFleet
  local x(4),y(4),i,textx=30,texty=30,textw=16
  math add shpx(),textx,x()
  math add shpy(),texty,y()
  for i=1 to ships,x(),y()
    polygon 5,x(),y()
    math add x(),textw,x()
  next
end sub

  ' Go through the list of rocks and draw any that exist
sub DrawRocks
  local i
  local x(14),y(14)

  for i = 0 to MAXROCKS
    if trock(i) then   ' rock exists
      inc rock(i,6),rock(i,7) ' spin rock
      if rock(i,6) > 360 then inc rock(i,6),-360
      if rock(i,6) < 0 then inc rock(i,6),360

      select case trock(i) ' what shape of rock is it?
        case 1
          math scale r1x(),rock(i,0),x()
          math scale r1y(),rock(i,0),y()
        case 2
          math scale r2x(),rock(i,0),x()
          math scale r2y(),rock(i,0),y()
        case 3
          math scale r3x(),rock(i,0),x()
          math scale r3y(),rock(i,0),y()
        case 4
          math scale r4x(),rock(i,0),x()
          math scale r4y(),rock(i,0),y()
      end select
      math v_rotate 0,0,rock(i,6),x(),y(),x(),y()
      math add x(),rock(i,2),x()  ' position rock
      math add y(),rock(i,3),y()
      polygon 15,x(),y()
    endif
  next i
end sub

sub DrawFire
  local i
  if fire then
    for i=0 to buls
      if bult(i,0)=0 then
        play modsample s_fire,1
        bult(i,0)=1:bult(i,1)=px:bult(i,2)=py
        bult(i,3)=bspd*sin(ph):bult(i,4)=-bspd*cos(ph)
        fire=0 : exit for
      end if
    next
  end if
end sub

sub UfoFire 'use bullet buffer to include ufo bullet
  local i,p
  for i=0 to buls
    if bult(i,0)=0 then     'we found a free slot
      if ufo(0)=2 then
        p=rnd*360           'large ufo shoot random direction
        play modsample s_fire,1
      else
        p=atan2(py-ufo(2),px-ufo(1)) 'small ufo aims at player
        play modsample s_fire,1
      end if
      bult(i,0)=2 'add the bullet, type 2 is ufo bullet
      bult(i,3)=bspd*cos(p):bult(i,4)=bspd*sin(p)   'direction
      bult(i,1)=ufo(1)+(ufo(0)+1)*bult(i,3)   'prevent ufo shooting itself
      bult(i,2)=ufo(2)+(ufo(0)+1)*bult(i,4)
      exit for
    end if
  next
end sub

sub newrocks(n)
  ' create n large rocks as start
  local k = 1
  for i = 1 to n
    trock(i)  = 1 + (k and 3) ' rock type (0=doesn't exist)
    rock(i,0) = 6             ' arcade rule: max rock size
    do  'initial place rocks 100 pix away from ship
      rock(i,2) = rnd*MM.HRES   ' x location
      rock(i,3) = rnd*MM.VRES   ' y location
    loop while ((rock(i,2)-MM.HRES/2)^2 + (rock(i,3)-MM.VRES/2)^2)<100*100
    rock(i,4) = 1-rnd*2   ' x velocity
    rock(i,5) = 1-rnd*2   ' y velocity
    rock(i,6) = rnd*360   ' starting angle
    rock(i,7) = 3-rnd*6   ' rotation speed
    inc k
  next
end sub

  'NES controller support
Function Reading_NES_Ctrl()
  Local bits, i
  Pulse NES_A_LATCH, NES_PULSE!
  For i = 0 To 7
    If Not Pin(NES_A_DATA) Then bits=bits Or 2^i
    Pulse NES_A_CLOCK, NES_PULSE!
  Next
  Reading_NES_Ctrl=bits
End Function

sub Init_NES
  NES_PULSE!  = 0.012   ' 12uS
  NES_A_CLOCK = MM.Info(PinNo GP3)  'adapt for Murmulator
  NES_A_LATCH = MM.Info(PinNo GP2)  'adapt for Murmulator
  NES_A_DATA  = MM.Info(PinNo GP1)  'adapt for Murmulator
  SetPin NES_A_CLOCK, DOut
  SetPin NES_A_LATCH, DOut
  SetPin NES_A_DATA,  DIn
end sub

  'lifetime namagement
sub ufoctrl
  if ufo(5)-timer<0 then
    ufo_end  'vanish after time
  else
    if ufo(0)=1 then                      'sound depends ufo type
      play modsample s_miniufo,4
    else
      play modsample s_bigufo,4
    end if
    if rnd<0.3 then 'once every 3 seconds average
      UfoFire
      'ufo flight trajectory
      if ufo(4)=0 then
        ufo(4)=choice(rnd<0.5,ufo(3),-ufo(3))
      else
        ufo(4)=0
      end if
    end if
  end if
end sub

Sub init_ps2_input()
  Read Save
  Restore ps2_scan_map_data
  Local i%
  For i% = Bound(ps2_scan_map%(), 0) To Bound(ps2_scan_map%(), 1)
    Read ps2_scan_map%(i%)
  Next
  Read Restore
End Sub

Function get_ps2_input%()
  Const ps2% = Mm.Info(PS2)
  If (ps2% And &hF000) = &hF000 Then Exit Function ' Key up
  Select Case ps2%
    Case < &hE000 : get_ps2_input% = Peek(Var ps2_scan_map%(), ps2% And &hFF)
    Case < &hF000 : get_ps2_input% = Peek(Var ps2_scan_map%(), (ps2% And &hFF) + &h80)
    Case < &hE0F000 : get_ps2_input% = Peek(Var ps2_scan_map%(), ps2% And &hFF)
    Case Else : get_ps2_input% = Peek(Var ps2_scan_map%(), (ps2% And &hFF) + &h80)
  End Select
Exit Function

  ' asteroids16
  ' Font type    : Full (64 Characters)
  ' Font size    : 16x16 pixels
  ' Memory usage : 2048
DefineFont #10
  40201010
  0000000000000000000000000000000000000000000000000000000000000000
  0002000200020002000200020002000200020002000000000002000200000000
  2008200820082008401040100000000000000000000000000000000000000000
  00000000100810081008FC3F1008100810081008FC3F10081008100800000000
  800080008008FC0780108010F007800808010801F03F00010003000300000000
  0030003030CC30CCC030C03000030003300C300CCC30CC303000300000000000
  000F000FC030C030003000300C0F0C0FCC30CC3030303030CC0FCC0F00000000
  C000C000C000C000000300030000000000000000000000000000000000000000
  C000C00000030003000C000C000C000C000C000C00030003C000C00000000000
  000C000C00030003C000C000C000C000C000C00000030003000C000C00000000
  000000000003000330333033C00FC00F30333033000300030000000000000000
  000000000003000300030003F03FF03F00030003000300030000000000000000
  00000000000000000000000000000000000000000003000300030003000C000C
  000000000000000000000000F03FF03F00000000000000000000000000000000
  0000000000000000000000000000000000000000000300030003000300000000
  0C000C0030003000C000C00000030003000C000C0030003000C000C000000000
  0420FC3F0420042004200420042004200420042004200420FC3F042000000000
  8000800080008000800080008000800080008000800080008000800000000000
  0400FC3F04000400040004000020FC3F0020002000200020FC3F002000000000
  0400FC3F04000400040004000400FC3F0400040004000400FC3F040000000000
  0420042004200420042004200400FC3F04000400040004000400040000000000
  0020FC3F00200020002000200400FC3F0400040004000400FC3F040000000000
  0020002000200020002000200420FC3F0420042004200420FC3F042000000000
  0400FC3F04000400040004000400040004000400040004000400040000000000
  0420FC3F0420042004200420FC3F04200420042004200420FC3F042000000000
  0420FC3F0420042004200420FC3F042004000400040004000400040000000000
  0000000000030003000300030000000000000000000300030003000300000000
  00000000000300030003000300000000000000000003000300030003000C000C
  00000000F000F000000F000F00300030000F000FF000F0000000000000000000
  0000000000000000FC3FFC3F00000000FC3FFC3F000000000000000000000000
  00000000000F000FF000F0000C000C00F000F000000F000F0000000000000000
  F00FF00F0C300C300C000C00F000F00000030003000000000003000300000000
  F00FF00F0C300C30CCC3CCC3CCCCCCCCF0C3F0C300300030F00FF00F00000000
  400180001004200204100808041004100410FC1F041004100410041000000000
  1020E03F04200820082004201020F03F0420082008200420E03F102000000000
  0020FC3F0020002000200020002000200020002000200020FC3F002000000000
  4020803F1020202004200820042004200820042020201020C03F402000000000
  0020FC3F00200020002000200020F03F0020002000200020FC3F002000000000
  0020FC3F00200020002000200020F03F00200020002000200020002000000000
  0420FC3F04200420002000200020002004207C2004200420FC3F042000000000
  0420042004200420042004200420FC3F04200420042004200420042000000000
  0001F83F0001000100010001000100010001000100010001F83F000100000000
  100010001000100010001000100010001000100010101020F007100800000000
  8020402000220021002800240028003000220024802000212020402000000000
  002000200020002000200020002000200020002000200020F03F002000000000
  0C30042024241428842144220420042004200420042004200420042000000000
  043004200424042804210422442084201420242004200C200420042000000000
  0420FC3F0420042004200420042004200420042004200420FC3F042000000000
  0420FC3F04200420042004200020FC3F00200020002000200020002000000000
  1020F03F102010201020102010201020102110224020A020103FA02000000000
  0420FC3F04200420042004200021FC3F40208020102020200420082000000000
  0020FC3F00200020002000200400FC3F0400040004000400FC3F040000000000
  0001F83F00010001000100010001000100010001000100010001000100000000
  102010201020102010201020102010201020102010201020F03F102000000000
  081004201008100820081008200420042004200440024002C003400200000000
  04200420042004200420042004200420442284211428242404200C3000000000
  0840048020101020800440080003000340088004102020100480084000000000
  1010082040042008000180020001000100010001000100010001000100000000
  0400FC3F1000080040002000000180000004000200100008FC3F002000000000
  C00FC00F000C000C000C000C000C000C000C000C000C000CC00FC00F00000000
  00C000C000300030000C000C00030003C000C000300030000C000C0000000000
  C00FC00FC000C000C000C000C000C000C000C000C000C000C00FC00F00000000
  00030003C00CC00CC00CC00C3030303000000000000000000000000000000000
  00000000000000000000000000000000000000000000000000000000FFFFFFFF
End DefineFont

ps2_scan_map_data:

Data &h9C92919395009900, &h0060099496989A00, &h0031710000008B00, &h00327761737A0000
Data &h0033346564786300, &h0035727466762000, &h0036796768626E00, &h003837756A6D0000
Data &h0039306F696B2C00, &h002D703B6C2F2E00, &h00003D5B00270000, &h000023005D0A0000
Data &h0008000000005C00, &h0000003734003100, &h001B383635322E30, &h008C392A2D332B9B
Data &h0000000097000000, &h0000000000000000, &h0000000000008B00, &h0000000000000000
Data &h0000000000000000, &h0000000000000000, &h0000000000000000, &h0000000000000000
Data &h0000000000000000, &h00000000002F0000, &h0000000000000000, &h00000000000A0000
Data &h0000000000000000, &h0000008682008700, &h0000808300817F84, &h0000889D00890000
