'************************************************************
' FS, FileSelector v.047 (beta)
'
' MMBasic 4.5 / Maximite / Duinomite / B/W
' by twofingers 11-2014 at TBS
'
' Contains code "Bblsort" from MMBasic library (Hugh Buckle)
' and Peters (G8JCF on TBS) Trim() functions
'------------------------------------------------------------
' still to do:
' scroll (to have more then 210 files)
' replace slow Bblsort() with cfunction (some day ...)
' multi delete, move, copy
' copy
'-------------------------------------------------
' Purpose:
' This file selector can
' 1. Navigate on your SD.
' 2. Replaces "Files" command
' 3. Run (execute) ".BAS" files
' 4. Show the content of ".TXT" and ".BMP" files
'    to get a impression i.e. before you decide to delete
' 5. Delete selected file
' 6. Rename selected file
'*********************************************************
' This code may be freely distributed and  changed.
' Provided AS IS without any warranty.
' Use it at your own risk. All information is provided for
' educational purposes only!
' ---------------------------------------------
' Credit to Geoff for his great MMBasic
'*********************************************************

'*********************************************************
' Operation keys:
' 4 arrow keys, Home, End (for positioning the cursor)
' Ascii keys find the resp. files (positioning)"
' Del (deletes files)
' Enter (execute BAS file, show text and BMP files)
' Space (sorts displayed files)
' F1 show a help page
' F2 Rename
' F3 ViewFile
' F12 runs B:\FS (there should be this program)
' <ESC> quits this program
'*********************************************************
Mode 1
Option base 1
Option F12 "RUN "+Chr$(34)+"B:\FS"+Chr$(34)+Chr$(13)

Dim i,iDir,max_i
max_i=211

Dim f$(max_i) length 12,fExt$,msg$,newF$
Dim errText$(16)
Dim c,c0,r,r0,p,p0
Dim keyval, NewFNError, RenameError

ProgVer$="047"

'"No error"
errText$(1) ="No SD card found"
errText$(2) ="SD card is writ protected"
errText$(3) ="Not enough space"
errText$(4) ="All root directory entries are taken"
errText$(5) ="Invalid filename"
errText$(6) ="Cannot find file"
errText$(7) ="Cannot find directory"
errText$(8) ="File is read only"
errText$(9) ="Cannot open file"
errText$(10)="Error reading from file"
errText$(11)="Error writing to file"
errText$(12)="Not a file"
errText$(13)="Not a directory"
errText$(14)="Directory not empty"
errText$(15)="Hardware error accessing the storage media"
errText$(16)="Flash memory write failure"


ReadDir
If i=0 Then Print "Sorry! There is nothing to display! SD empty?"


Do ' Main loop
   fExt$=LCase$(Right$(f$(p),4))
   Print @(0,MM.VRes-12) MM.Drive$+Right$(Space$(12)+f$(p),12)

   Do:keyval=KeyDown:Pause 30:Loop While keyval=0
   r0=r:c0=c:p0=p            ' store old values

   If keyval=131 Then p = p+1          ' >
   If keyval=130 Then p = p-1          ' <
   If keyval=128 Then p = p-6          ' up
   If keyval=129 Then p = p+6          ' down
   If keyval=134 Then p = 1            ' Home
   If keyval=135 Then p = i            ' End
   If keyval=027 Then Exit             ' Esc (exits this program)
   If keyval=032 Then Bblsort          ' Sort
   If keyval=145 Then Help             ' Help   F1
   If keyval=147 Then ViewFile         ' View   F2
   If keyval=146 And p >iDir Then      ' Rename F3
     Print @(2*6,MM.VRes-12);
     newF$=LCase$(trim$(LineEdit$(Right$(Space$(12)+f$(p),12))))
     If f$(p)<>newF$ Then
      ' 1. Check if there is already a file with that name (ERR=6).
      ' 2. Is that new name "valid"? (ERR=5)
      NewFNError=GetFNError(newF$)
      If NewFNError=6 Then        ' New file name is not yet on SD, thats good
         Option Error Continue
         Name f$(p) As newF$
         RenameError = MM.Errno
         Option Error Abort
         If RenameError Then
            Print @(0,MM.VRes-12);"Rename Error (1):"errText$(RenameError)
            Pause 3000
         EndIf
      Else
         Print @(0,MM.VRes-12);"Rename Error (2):"errText$(NewFNError)
         Pause 3000
      EndIf
      ReadDir
      p=p0
     EndIf
   EndIf
   If keyval=127 And p>iDir Then       ' Del
      msg$=" Okay to delete file: "
      If i>0 And AskOK(msg$) Then
        Kill f$(p)
        ReadDir
        p=p0
      EndIf
   EndIf
   If p<1 Then p=1
   If p>i Then p=i
   If keyval=013 Then                  ' Enter
      If fExt$ =".bmp" Then
         LoadBMP f$(p)
         waitkey
         ReNewScreen
         p=p0
      ElseIf fExt$ =".txt" Or fExt$ =".csv" Then
         ViewFile
      ElseIf p<=iDir Then
         Chdir f$(p)
         ReadDir
      ElseIf fExt$ =".bas" Then
        msg$=" Okay to execute file "
        If AskOK(msg$) Then Run f$(p)
      EndIf
   EndIf

   If keyval>32 And keyval<127 Then   ' move cursor to the F$ with first letter
     For v=p+1 To i                   ' equal keyval
       If Asc(f$(v)) = keyval Then p =v: Exit For
     Next v
   EndIf
   r=(p+5) \ 6:c=(p+5) Mod  6+ 1

   invert c,r
   invert c0,r0
   Pause 80
Loop        ' to escape this loop press "Esc"

End '------------------------------------------------------



Sub ReadDir
  Cls
  Timer=0
  i=1
  f$(i) = Dir$("*.*", DIR)
  If f$(i)="." Then f$(i) = Dir$() ' we don't need the "."
  Do While f$(i) <> "" And i<max_i
    Print Right$("            "+f$(i),12);" ";
    If i Mod 6 = 0 Then Print
    i=i+1
    f$(i) = Dir$()
  Loop
  iDir=i-1

  f$(i) = LCase$(Dir$("*.*", FILE))
  Do While f$(i) <> "" And i<max_i
    Print Right$("            "+f$(i),12);" ";
    If i Mod 6 = 0 Then Print
    i=i+1
    f$(i) = LCase$(Dir$())
  Loop

  i=i-1
  p=1
  r=1 'row
  c=1 'col
  r0=r
  c0=c
  tx=Timer
  invert c,r
  Line(0,MM.VRes-13)-(MM.HRes,MM.VRes-13),1,bf
End Sub


' cursor for file names
Sub invert x,y ' hor, vert
  Local h,v

  h=x*13-13:v=y
  Line(h*6,v*12-12)-(h*6+12*6,v*12-2),-1,bf
End Sub


' clear row
Sub Clr vert
  Line(0,vert)-(MM.HRes,vert+12),0,bf
End Sub


Sub WaitKey
  Do:Loop While Inkey$=""
End Sub


' prompt for y/n question
Function AskOk msg$
  Local k$

  Pause 200
  AskOk=FALSE
  Clr MM.VRes-12
  Font#1,,1
  Print @(0,MM.VRes-12)msg$;f$(p) "? <y/n>";
  Font#1
  Do:k$=LCase$(Inkey$):Loop While k$<>"y" And k$<>"n"
  AskOk=(k$="y")
  Clr MM.VRes-12
  Pause 200 ' to empty keyboard input buffer
End Function


Sub ViewFile
Local a$, kp, crPos, fPos

  fPos=0

  If p<=iDir Then Exit Sub
  Cls
  Line(0,MM.VRes-12)-(MM.HRes,MM.VRes),1,bf   ' inverted screen
  msg$="Press any key to continue - Exit with <ESC>"
  Font #1,,1:Print @(Hcenter(msg$),MM.VRes-12)msg$;
  Open f$(p) For input As 1
  Print @(0,MM.VRes-12);"("Str$(fPos)"/"Str$(Lof(1))")";
  Font #1,,0:Print @(0,0);           ' to mark the view mode

  kp=0
  Do
    a$=Input$(1,#1)
    crPos=MM.HPos =>MM.HRes-5        ' current cursor pos right
    If MM.VPos >MM.VRes-24 Or (MM.VPos >MM.VRes-36 And crPos) Then
      Do:kp= KeyDown:Loop While kp=0
      Line(0,0)-(MM.HRes,MM.VRes-13),0,bf
      Font #1,,1:Print @(0,MM.VRes-12);"("Str$(fPos)"/"Str$(Lof(1))")";
      Font #1:Print @(0,0);
    EndIf
    Print a$;
    fPos=fPos+1
  Loop While Not Eof(1) And kp<>27   ' ESC
  Close 1
  If kp<>27 Then waitkey
  Font 1

  ReNewScreen
  p=p0
End Sub


Function Hcenter(s$)
  Hcenter=(MM.HRes-Len(s$)*6)/2
End Function


Sub ReNewScreen
  Cls
  For n=1 To i
    Print Right$("            "+f$(n),12);" ";
    If n Mod 6 = 0 Then Print
  Next n

  p=1
  r=1 'row
  c=1 'col
  r0=r
  c0=c

  invert c,r
  Line(0,MM.VRes-13)-(MM.HRes,MM.VRes-13),1,bf
End Sub


'********************************************************
' Bubble Sort Routine  copied from GW-BASIC online manual
' by Hugh Buckle - Jan 2012
' needs: sub SWAP X$,Y$
'********************************************************
Sub BblSort
Local Flips, counter, n,lc
  Flips = 1
  counter=0

  Line(0,MM.VRes-12)-(MM.HRes,MM.VRes),1,bf  ' init progressbar
  Print @(0,MM.VRes-12)"  sorting ...";

  Do
    Flips = 0
    counter=counter+1
    For n=iDir+1 To i-1
      If f$(n) > f$(n+1) Then
        SWAP f$(n),f$(n+1)
        Flips = 1
      EndIf
    Next n
    lc=MM.HRes/i
    Line(MM.HRes-counter*lc,MM.VRes-12)-(MM.HRes,MM.VRes),0,bf  ' progressbar
  Loop While Flips = 1

  ' End Bubblesort --------------------------
  ' re-display sorted array of file names

  ReNewScreen
End Sub


Sub SWAP X$,Y$ ' used by bblsort
  ' This function mimics GW-Basic SWAP X,Y function
  Local Z$
  Z$ = X$
  X$ = Y$
  Y$ = Z$
End Sub


Sub Help
  Cls
  Do
  Print @(0,0);
  Print "---------------------------------------------------------"
  Print " File selector " ProgVer$ + "          " Date$ "  " Time$
  Print "---------------------------------------------------------"
  Print " Operation keys:"
  Print " 4 arrow keys, Home, End (for positioning the cursor)"
  Print " Ascii keys find the resp. files (positioning)"
  Print " Del (deletes files)"
  Print " Enter (execute BAS file, show text and BMP files)"
  Print " - <ESC> returns immediately from view text mode."
  Print " Space (sorts files)"
  Print " F1  this help page"
  Print " F2  Rename"
  Print " F3  ViewFile"
  Print " F12 runs B:\FS (hopefully this program) to restart."
  Print " <ESC> quits this program"
  Print "---------------------------------------------------------"
  Pause 200
  Loop While Inkey$=""
  ReadDir
End Sub


'*************************************************
'*
'*            LineEdit$ V.95
'*
'*          MMBasic 4.5/Maximite
'*
'* line editor for small strings (e.g. file names)
'*
'*************************************************
Function LineEdit$ edText$
Local hpos, vpos, p, ep, keyvalue, enterPressed,escPressed
Local text$,ltext$,mtext$,rtext$
Local TRUE, FALSE
Local insertMode

  TRUE=1
  FALSE=0
  hpos=MM.HPos:vpos=MM.VPos ' save print position
  text$=edText$             ' use local copy of text$ string
  LineEdit$=edText$         ' backup edText$ for Esc
  enterPressed=FALSE        ' Flag to EXIT the loop
  escPressed=FALSE
  p=Len(text$)              ' cursor pointer
  ep=p                      ' end pointer
  shift$=" "                ' shift out buffer
  insertMode=FALSE

  Pause 200 ' es gibt einen Zeitfaktor fuer keyboard input buffer ~140ms

  Print @(hpos,vpos)Left$(text$,p-1);
  Font#1,,1:Print Right$(text$,1);:Font#1

  Do
    Do:keyvalue=KeyDown:Pause 20:Loop While keyvalue=0

    If keyvalue=130 And p>1 Then p=p-1    'left arrow
    If keyvalue=131 And p<ep Then p=p+1   'right arrow
    If keyvalue=13 Then
       enterPressed=TRUE                  'Enter
    EndIf
    If keyvalue=27 Then
       Print @(hpos,vpos)LineEdit$;
       escPressed=TRUE                    'ESC Function
    EndIf
    If keyvalue=134 Then p=1              'Home
    If keyvalue=135 Then p=ep             'End
    If keyvalue=132 Then
       insertMode=Not insertMode          'Insert toggle
    EndIf
    If keyvalue>=32 And keyvalue<127 Then 'all ASCII chars
      If insertMode And Len(shift$) <255 Then
        If p<ep Then
          p=p+1
          ltext$=ltext$+Chr$(keyvalue)
          mtext$=""
          rtext$=Mid$(text$,p-1,ep-p+1)
        Else
          ltext$=Left$(text$,p-1)+Chr$(keyvalue)
          mtext$=""
          rtext$=""
        EndIf
        shift$=Right$(text$,1)+shift$
      Else
        If p<ep Then
          p=p+1
          ltext$=ltext$+Chr$(keyvalue)
          mtext$=Mid$(text$,p,1)
          rtext$=Mid$(text$,p+1)
        Else
          ltext$=Left$(text$,p-1)
          mtext$=Chr$(keyvalue)
          rtext$=""
        EndIf
      EndIf
    ElseIf keyvalue=8 And p>1 Then        'Backspace
      If insertMode Then
        p=p-1
        ltext$=Mid$(text$,1,p-1)
        mtext$=""
        rtext$=Mid$(text$,p+1)+Left$(shift$,1)
        shift$=Mid$(shift$,2)
      Else
        p=p-1
        ltext$=Mid$(text$,1,p-1)
        mtext$=Mid$(text$,p+1,1)
        rtext$=Mid$(text$,p+2)+Left$(shift$,1)
        shift$=Mid$(shift$,2)
      EndIf
    ElseIf keyvalue=127 Then              'Del
        ltext$=Mid$(text$,1,p-1)
        mtext$=Mid$(text$,p+1,1)
        rtext$=Mid$(text$,p+2)+Left$(shift$,1)
        shift$=Mid$(shift$,2)
    Else
      If insertMode Then
        ltext$=Mid$(text$,1,p-1)          'move cursor / insert mode
        mtext$=""
        rtext$=Mid$(text$,p,ep-p+1)
      Else
        ltext$=Mid$(text$,1,p-1)          'move cursor / over write
        mtext$=Mid$(text$,p,1)
        rtext$=Mid$(text$,p+1,ep-p)
      EndIf
    EndIf

    Print @(hpos,vpos)ltext$;
    Font#1,,Not insertMode
    Print mtext$;
    Font#1
    Print rtext$;

    If insertMode Then
      Line (hpos+p*6-7,vpos)-(hpos+p*6-7+1,vpos+9),-1,BF
    EndIf
    text$=Left$(ltext$+mtext$+rtext$,ep)
    If shift$="" Then shift$=" "

    Pause 120 ' some wait states to slow down key input
  Loop While Not enterPressed And Not escPressed
  If Not escPressed Then
    LineEdit$=ltext$+mtext$+rtext$
    Print @(hpos,vpos)LineEdit$;
  EndIf
End Function
'*****************************************************


'
'Remove leading Spaces from string
'
Function LTrim$(X$)
  Local I,Z$ Length Len(X$)

  'Make copy of caller's string so that we don't damage it
  Z$=X$

  For I=1 To Len(Z$)

    'Find first NON-Space character
    If Mid$(Z$,I,1)<>" " Then
      Z$=Mid$(Z$,I)
      Exit For
    EndIf

  Next I

  LTrim$=Z$

End Function


'
' Remove trailing Spaces from string
' Peters rTrim, modified by twofingers
'
Function RTrim$(X$)
  Local I

  For I=Len(X$) To 1 Step -1
    'Find first NON-Space character
    If Mid$(X$,I,1)<>" " Then
      Exit For ' be careful with Exit For
    EndIf
  Next I

  RTrim$=Mid$(X$,1,I)

End Function


'
'Remove spaces from LHS and RHS of string
'
Function Trim$(X$)
  Local Y$ length Len(X$)

  'MMBasic doesn't like Trim$=RTrim$(LTrim$(X$))

  Y$=LTrim$(X$)
  Trim$=RTrim$(Y$)

End Function


Function GetFNError N$
  Option Error Continue
  Open N$ For Input As #9
  GetFNError = MM.Errno
  If MM.Errno=0 Then Close #9
  Option Error Abort
End Function


Function InvalidFName N$
Local TRUE,FALSE
  TRUE=1:FALSE=0
  InvalidFName=FALSE
  Option error continue
  Open N$ For input As #10
  If MM.Errno=5 Then InvalidFName=TRUE
  If MM.Errno=0 Then Close #10
  Option error abort
End Function


Function FileExists N$
Local TRUE,FALSE
  TRUE=1:FALSE=0
  Option error continue
  Open N$ For input As #10
  If MM.Errno=0 Then
    FileExists=TRUE
    Close #10
  Else
    FileExists=FALSE
  EndIf
  Option error abort
End Function


