'***************************************************
'**************************************************
'* MMBasic 4.5 for Maximite/Duinomite
'* and MicroMites
'* twofingers @ TBS 09-2015
'* No warranty, provided at your own risk.
'*
'*    Monty Hall problem (automatic)
'*
'*   a code example/simulation
'* ---------------------------------------------------
'*  Description:
'* Suppose you're on a game show, 
'* and you're given the choice of three doors:
'* Behind one door is a car; 
'* behind the others, goats.
'* You pick a door, say No. 1, 
'* and the host, who knows what's behind 
'* the doors, opens another door, say No. 3,
'* which has a goat. He then says to you, 
'* "Do you want to pick door No. 2?" 
'* Is it to your advantage to switch your choice?
'* 
'* https://en.wikipedia.org/wiki/Monty_Hall_problem
'**************************************************
'***************************************************

Dim doors(3)
Dim first_choice      'your part
Dim open_a_goats_door 'montys part
Dim goat, car, selected, switch,i,tries
goat =0
car  =1
tries=1

Dim switchstr$(2)
switchstr$(0)="Keep  "
switchstr$(1)="Switch"

Randomize Timer

Cls
Print "Monty Hall problem (automatic mode)"
Print

Do
  For i = 1 To 3
    doors(i)=goat
  Next i
  doors(Int(3*Rnd(0)+1))=car
  Print "_____________________"
  For i = 1 To 3
    Print doors(i);
  Next i
  Print

  'Input "Pick a door (1,2,3 or 0 to exit) ",a$
  'first_choice=Val(a$)
  first_choice=Int(Rnd()*3)+1
  Print "Your first choice: "first_choice

  open_a_goats_door=select_goat()
  Print "Open a goats door: "open_a_goats_door

  'Input "Want to switch your choice (y/n or 0 to exit) ",a$
  'If a$="0" Then End

  'switch = (LCase$(a$)="y")

  switch=1'0 or Int(Rnd()+0.5)
  Print switchstr$(switch)

  If Not switch Then
    selected=first_choice
  Else
    For i = 1 To 3 ' find the door to switch to
      If i <> first_choice And i <> open_a_goats_door Then
        selected=i
        Exit For
      EndIf
    Next i
  EndIf

  Print
  Print "Your door:" selected
  If doors(selected)=car Then
     Print "#"tries": You won a CAR!"
     cars=cars+1
  Else
     Print "#"tries": You won a goat!"
     goats=goats+1
  EndIf
  tries=tries+1
'  Do:Loop While Inkey$=""
Loop While tries=<100

Print "____________________"
Print "Total"tries
Print "Goats      Cars"
Print goats,cars
End


Function select_goat()
Local a(2),i,z
z=0:i=1
   Do
    If doors(i)=goat And i<>first_choice Then
       z=z+1 'z can be 2, or 1 if doors(first_choice)=Car
       a(z)=i
    EndIf
    i=i+1
  Loop While i<=3 And z<=2
  select_goat = a(Int(Rnd()*z+1))
End Function


Function select_goat2() 'UNUSED alternative function
  Do
    select_goat=Int(Rnd()*3)+1
  Loop While doors(select_goat)=car Or select_goat =first_choice
End Function
