Dim ProgVer$:ProgVer$="099"
'************************************************************
' FS, FileSelector v.099 (beta) released 17.9.2015
'
' System: MMBasic 4.5 / Maximite / Duinomite / B/W
' by twofingers 11-2014 at TBS
' Credit:
' Contains factus10@TBS "CombSort" code (modified)
'------------------------------------------------------------
' still to do:
'
' replace CombSort() with cfunction (some day ...)
' Find file?
' Date$ valid? (in Help)
'-------------------------------------------------
' Purpose:
' This file selector can
' 1. Navigate on your SD.
' 2. Replaces "Files" command
' 3. Run (execute) ".BAS" files
' 4. Show the content of ".TXT" and ".BMP" files
'    to get a impression i.e. before you decide to delete
'    or to view a help.txt (for MMBasic syntax?) ...
'    Save snippets (from view mode)
' 5. Delete selected file/dir
' 6. Rename selected file/dir
' 7. Multi select, copy (for files) und delete (files & dirs)
' 8. Multi move (files) - Note: normaly (on PCs) move means
'    just a rename. For FS we must use copy&kill to move files.
' 9. From "Help" you can easily setup Time & Date of your RTC
' ------------------------------
' Limits:
'        This program handles only 210 (or less) items/directorys
'        If there are more than 210, then a white bar
'        appears on the right.
'        If no files on SD the program quits. That's because
'        I don't know what to display ...
'        Normaly this "fs.bas" program should be in the main dir
'        (and ds3231.LIB too if you are using a DS3231/2 or
'        DS1307 RTC)
'        ----------------------
'        Only files can be selected (for copy, delete or move).
'        Directorys can't be copied or moved, but created and renamed.
'        Only empty directorys can be killed.
'
'*************************************************************
' This code may be freely distributed and changed.
' Provided AS IS without any warranty.
' Use it at your own risk. All information is provided for
' educational purposes only!
' ---------------------------------------------
'    ++++++ Credit to Geoff for his great MMBasic ++++++
'*************************************************************

'*************************************************************
' Operation keys:
' 4 arrow keys, Home, End (for positioning the cursor)
' Ascii keys find the resp. files (positioning)"
' Del (deletes files and remove (empty!) directorys)
' Enter (execute BAS file, show text and BMP files)
' Insert (copies single files)
' Space (selects files), TAB moves to root dir
' Alt F-Key help
'
' F1  Show a help page
'     you can set Time, Date and "auto DeSelect" and "risk mode"
' F2  Rename (Esc,Home,End,Ins,Del,BSp,Enter,Left,Right)
' F3  ViewFile (Page Up/Dn, [s]=save snippet, Esc)
' F4  Sort
' F5  Copy selected files/dirs  - <ESC> exits Copy (any time)
     ' for overwrite:
     ' <y>     overwrite current file
     ' <n>     do not overwrite current file
     ' <ENTER> overwrite all existing files (don't ask again)
     ' <BSp>   continue copy but never overwrite
' F6  Make directory (Esc)
' F7  Move files (copy + kill), see F5 for overwrite options
' F8  MULTI Kill/Delete - <Esc> exits Kill (any time)
' F9  select   (alternatively:"+")
' F10 deselect (alternatively:"-")
' F11 Invert the selection (alternatively:"*")
' F12 runs B:\FS (there should be this program)
' CTRL+x quits this program
'**************************************************************
Mode 1
Option base 0

If MM.Drive$<>"B:" Then Drive "B:"



'Option F1 "LOAD "+Chr$(34)
'Option F2 "EDIT"+Chr$(13)
'Option F3 "SAVE"
'Option F4 "FILES"
'Option F5 "COPY "+Chr$(34)
'Option F6 "MKDIR "+Chr$(34)
'Option F9 "CHDIR .."+Chr$(13)
Option F12 "RUN "+Chr$(34)+"B:\FS"+Chr$(34)+Chr$(13) 'launch this program


Dim i,iDir,max_i

max_i=(MM.VRes-12)\12*((MM.HRes/6)\13) '210 for MaxiMites

Dim f$(max_i+2) length 13,fExt$,msg$,newF$
Dim tag(max_i+2),tagC,fSort
Dim errText$(17) length 42
Dim c,c0,r,r0,p,p0
Dim keyval, NewFNError, RenameError
Dim changedFN,riskMode  'Flags
Dim TRUE,FALSE 'Const
Dim escPressed 'early exit from MaskEdit()
Dim overflow   'there are more files/dirs then max_i
Dim sLine,dummy
Dim deSelectFlag
Dim FM$,TM$,DM$,FT$
Dim snp$,snippCreated, snippExists
Dim temp, ds3231_avail, hpos, fs_Flag

FM$="        .   " 'masks for maskedit
TM$="##.##.##"
DM$="##.##.####"

TRUE =1
FALSE=0

ds3231_avail=FALSE
I2C open 100,1000 ' check for ds3231 module
I2C read &H68,0,1,TEMP
If Not MM.I2C And FileExists("b:\ds3231.LIB") Then 'module at H68 available
  Library Load "b:\ds3231.LIB"
'  readtime
  ds3231_avail=TRUE
EndIf

snp$="snippet.txt"
sLine=MM.VRes-12   'status line, bottom of screen

' progressbar const
st1=sLine+5
st2=MM.VRes-6
lh=(MM.HRes/2)

deSelectFlag=TRUE   ' copy will remove tags
'preSortLimit =90 '
preSortLimit=max_i  ' number of auto sorted files

fSort=FALSE  ' file names are not yet sortet
If MM.CmdLine$ = "/NO" Then riskMode = TRUE  ' delete and run without confirm

'"No error"
errText$(1) ="No SD card found"
errText$(2) ="SD card is write protected"
errText$(3) ="Not enough space"
errText$(4) ="All root directory entries are taken"
errText$(5) ="Invalid filename"
errText$(6) ="Cannot find file"
errText$(7) ="Cannot find directory"
errText$(8) ="File is read only"
errText$(9) ="Cannot open file"
errText$(10)="Error reading from file"
errText$(11)="Error writing to file"
errText$(12)="Not a file"
errText$(13)="Not a directory"
errText$(14)="Directory not empty"
errText$(15)="Hardware error accessing the storage media"
errText$(16)="Flash memory write failure"
errText$(17)="Source and destination are the same!" 'MMBasic bug
'#0
ReadDir

'**************************************************************
Do While i ' Main loop, do until SD is empty or CTRL+x pressed
           ' "i" is the number of all files/dirs
'**************************************************************
   fExt$=LCase$(Right$(f$(p),4))
   Print @(0,sLine) ShortPath$(Cwd$)"\";FNFormat$(f$(p),TRUE);
   If p>iDir Then
      Print "            ";
   Else
      Print " DIR        ";
   EndIf
   If overflow Then
     Line(MM.HRes-6,0)-(MM.HRes-2,MM.VRes-13),1,B
     Font#1,,1
     Print @(334,sLine) " Overflow >"
   EndIf

   Print @(400,sLine)i " Items ";
   If fSort Then Print "! ";
   Font#1

  Timer=0
   fs_Flag=1
	 ' get a key and print file size only if cursor stands still (since 099)
   Do  
     keyval=KeyDown
     Pause 30
     If Timer >50 And fs_Flag And p>iDir Then
        Print @(hpos,sLine) "  ["+Str$(FileSize(f$(p)))+"]        ";
        fs_Flag=0
     EndIf
   Loop While keyval=0
   
	 Timer=0 ' for waitstates
   r0=r:c0=c:p0=p            ' store old values

   If keyval=131 Then p = p+1          ' >
   If keyval=130 Then p = p-1          ' <
   If keyval=128 Then p = p-6          ' up
   If keyval=129 Then p = p+6          ' down
   If keyval=134 Then p = 1            ' Home
   If keyval=135 Then p = i            ' End
   If keyval=9   Then Chdir "\":ReadDir' Tab = root dir

   If keyval=139 Then                  ' F-key help
       msg$="F1:Help F2:Ren F3:View F4:Sort F5:Copy "
       msg$=msg$+"F6:MkDir F7:Move F8:Del F9:Sel F10:UnSel"
       StatusMsg msg$
   EndIf
   If keyval=024 Then Exit             ' CTRL+x (exits this program)

   If keyval=032 And p>iDir Then       ' space, Mark current file
     If tag(p)=FALSE Then
       tag(p)=TRUE
     Else
       tag(p)=FALSE
     EndIf
     r=(p+5)\6:c=(p+5) Mod 6+1
     Mark c,r
     p=p+1
   EndIf

   If keyval=132 Then
     If p>iDir Then       ' insert, single file copy
       changedFN=FALSE
       Print @(0,sLine)"  Copy file: "f$(p)" to ";
       FT$=FNFormat$(f$(p))
       newF$=LCase$(InTrim$(MaskEdit$(FT$,1,FM$)))
       If Not escPressed Then
          If Not FileExists(newF$) Then
             FileCopy
          Else
             Clr(sLine)
             Print @(0,sLine);"Error: File exists!!";
             msg$="Okay to overwite existing file: "+f$(c)+"? <y/n>"
             opt=Choice(msg$)
             If opt=1 Then FileCopy TRUE  'overwrite = TRUE
          EndIf
       EndIf
       Clr(sLine)
     Else
       StatusMsg("Sorry! Can not copy a directory!",1)
     EndIf
   EndIf

   If keyval=145 Then Help:p=p0        ' Help   F1

   If keyval=146 Then                  ' Rename F2
     If f$(p)<>".." Then               '
       changedFN=FALSE
       Print @(Len(ShortPath$(Cwd$)+"\")*6,sLine); '+ path length (cwd$)
       fT$=FNFormat$(f$(p))
       newF$=LCase$(InTrim$(MaskEdit$(FT$,1,FM$)))
       If Not escPressed Then
         ' 1. Check if there is already a file with that name (ERR=6).
         ' 2. Is that new name "valid"? (ERR=5)
         NewFNError=GetFNError(newF$)
         If Not FileExists(newF$) Then
           If NewFNError=6 Then        ' New file name is not yet on SD, thats good
              Option Error Continue
              Name f$(p) As newF$
              RenameError = MM.Errno
              Option Error Abort
              If RenameError Then      ' we could not rename
                 StatusMsg ("Rename Error (1): "+errText$(RenameError),3)
              Else
                 changedFN=TRUE
              EndIf
           Else
              StatusMsg ("Rename Error (2): "+errText$(NewFNError),3)
           EndIf
         Else
           StatusMsg("Rename Error: File exists already!",3)
         EndIf
         If changedFN Then
            If fSort Then
              If p<=iDir Then newf$=UCase$(newf$)
              f$(p)=newF$
              CombSort  ' sort a nearly sorted array
            Else
              ReadDir
              p=p0
            EndIf
         EndIf
       EndIf
     Else                       ' rename for .. Directory
       StatusMsg ("Can't rename: "+f$(p),1)
     EndIf
   EndIf

   If keyval=147 Then ViewFile         ' View   F3

   If keyval=148 Then CombSort          ' Sort   F4

   If keyval=153 Or keyval=43 Then   ' Mark w. wildcard  F9 or +
      Clr sLine
      Print @(0,sLine) "Select:";
      mask$=LCase$(InTrim$(MaskEdit$("       *.*  ",1,FM$)))
      If Len(mask$)>0 And Not escPressed Then
        Print @(8*6+6*(9-Instr(mask$,".")),sLine) mask$;
        GetWildNames mask$,TRUE
      Else
        Clr sLine
     EndIf
   EndIf

   If keyval=154 Or keyval=45 Then         ' Mark w. wildcard  F10
      Clr sLine
      Print @(0,sLine) "DeSelect:";
      mask$=LCase$(InTrim$(MaskEdit$("       *.*  ",1,FM$)))
      If Len(mask$)>0 And Not escPressed Then
        Print @(8*6+6*(9-Instr(mask$,".")),sLine) mask$;
        GetWildNames mask$,FALSE
      Else
        Clr sLine
     EndIf
   EndIf

   If keyval=155 Or keyval=42 Then         ' Invert the selection  F11,*
      Clr sLine
      Print @(0,sLine) "Invert the selection";
      For c = iDir+1 To i
         tag(c)=Not tag(c)
      Next c
      Pause 1000
      ReNewScreen
      Clr sLine
   EndIf

   If keyval=149 Then                ' Multicopy   F5
     If p<=iDir Then
       TagC=FALSE
       For c=1To i
         If tag(c) Then TagC=TRUE:Exit For
       Next c
       If TagC=FALSE Then
         StatusMsg ("No items for filecopy selected!",1)
       Else
         ProgressBar(FALSE,TRUE)
         Print @(0,sLine)" copying ...    ";
         opt=0
         For c=iDir+1 To i
           If tag(c) Then
              If Not FileExists(f$(p)+"\"+f$(c)) Then
                Print @(0,sLine)" copying: ... " FNFormat$(f$(c))
                Copy f$(c) To f$(p)+"\"+f$(c)
                If FileSize(f$(c))<>FileSize(f$(p)+"\"+f$(c)) Then
                  msg$="Verify error, press any key!"
                  StatusMsg msg$
                ElseIf deSelectFlag Then 'deSelectFlag = deSelect OPTION
                  tag(c)=FALSE
                  col=(c+5) Mod 6+1:row=(c+5)\6
                  mark col,row    ' deselect
                EndIf
              Else
                If opt<>3 And opt<>4 Then  ' Enter or Esc
                  msg$="Overwite existing file: "+f$(c)
                  msg$=msg$+"? <y/n> or ENTER/BSp/ESC for all files"
                  ' <y>     overwrite one file
                  ' <n>     do not overwrite this file
                  ' <ENTER> overwrite all existing files, don't ask again
                  ' <BSp>   continue copy but never overwrite (Backspace)
                  ' <Esc> exits copy
                  opt=Choice(msg$,"yn"+Chr$(13)+Chr$(8)+Chr$(27))
                  ProgressBar(FALSE,TRUE)
                EndIf
                If opt=1 Or opt = 3 Then '"y" or Enter (overwrite once or all)
                   Print @(0,sLine)" overwriting: " FNFormat$(f$(c));
                   Copy f$(c) To f$(p)+"\"+f$(c)
                   If FileSize(f$(c))<>FileSize(f$(p)+"\"+f$(c)) Then
                     StatusMsg ("Verify error, press any key! "+f$(c))
                   ElseIf deSelectFlag Then
                     tag(c)=FALSE
                     col=(c+5) Mod 6+1:row=(c+5)\6
                     mark col,row    ' deselect
                   EndIf
                ElseIf opt=5 Then ' Esc
                   Exit For
                EndIf
              EndIf
              If Inkey$=Chr$(27) Then
                msg$="Abort copying? <y/n>"
                If Choice(msg$)=1 Then Exit For
                ProgressBar(FALSE,TRUE)
              EndIf
          EndIf
          ProgressBar(c)
         Next c
       EndIf
     Else
       StatusMsg ("Please select a directory to copy to!",2)
     EndIf
     Clr sLine
   EndIf

   If keyval=150 Then                  ' Make Dir  F6
     Clr sLine
     Print @(0,sLine) "Make Dir:";
     DirName$=UCase$(InTrim$(MaskEdit$("        .   ",1,FM$)))
     If Len(DirName$)>0 And Not escPressed Then
       If DirExists(DirName$) Then
         StatusMsg("Directory "+DirName$+" exists already? Press any key!")  ' or SD error
       Else
         Option Error Continue
         Print @(9*6,sLine)DirName$;
         Mkdir DirName$
         MkDirError = MM.Errno
         Option Error Abort
         If MkDirError = 0 Then
            StatusMsg(DirName$+" created!",2)
            ReadDir
         Else
            StatusMsg(errText$(MkDirError)+". Press any key!")
         EndIf
       EndIf
     EndIf
   EndIf

'#6
   If keyval=151 Then                ' Multimove   F7
     If p<=iDir Then
       TagC=FALSE
       For c=1To i
         If tag(c) Then TagC=TRUE:Exit For
       Next c
       If TagC=FALSE Then
         StatusMsg ("No files selected for move!",1)
       Else
         msg$="Okay to MOVE selected files? <y/n>"
         If Choice(msg$)=1 Then
           fileKilled=FALSE
           Print @(0,sLine)" moving: ... ";
           ProgressBar(FALSE,TRUE)
           opt=0
           For c=iDir+1 To i
             If tag(c) Then
                If Not FileExists(f$(p)+"\"+f$(c)) Then
                  Print @(0,sLine)" moving: ... "FNFormat$(f$(c));
                  Copy f$(c) To f$(p)+"\"+f$(c)
                  If FileSize(f$(c))<>FileSize(f$(p)+"\"+f$(c)) Then
                    StatusMsg "Verify error, press any key!"
                  Else
                    tag(c)=FALSE
                    col=(c+5) Mod 6+1:row=(c+5)\6
                    ClearFN col,row    ' deselect
                    dummy=KillMFile(f$(c))
                    fileKilled=TRUE
                  EndIf
                Else
                  If opt<>3 And opt<>4 Then  ' Enter or Esc
                    msg$="Overwite existing file: "+f$(c)
                    msg$=msg$+"? <y/n> or ENTER/BSp/ESC for all files"
                    ' <y>     overwrite one file
                    ' <n>     do not overwrite for one file
                    ' <ENTER> overwrite all existing files, don't ask again
                    ' <BSp>   continue copy but never overwrite (Backspace)
                    ' <Esc>   exits move
                    opt=Choice(msg$,"yn"+Chr$(13)+Chr$(8)+Chr$(27))
                    ProgressBar(FALSE,TRUE)
                  EndIf
                  If opt=1 Or opt = 3 Then '"y" or Enter (overwrite once or all)
                     Print @(0,sLine)" overwriting: " FNFormat$(f$(c));
                     Copy f$(c) To f$(p)+"\"+f$(c)
                     If FileSize(f$(c))<>FileSize(f$(p)+"\"+f$(c)) Then
                       StatusMsg "Verify error, press any key!"
                     Else
                       tag(c)=FALSE
                       col=(c+5) Mod 6+1:row=(c+5)\6
                       ClearFN col,row    ' deselect
                       dummy=KillMFile(f$(c))
                       fileKilled=TRUE
                     EndIf
                  ElseIf opt=5 Then ' Esc
                     Exit For
                  EndIf
                EndIf
                If Inkey$=Chr$(27) Then
                  msg$="Abort moving? <y/n>"
                  If Choice(msg$)=1 Then Exit For
                  ProgressBar(FALSE,TRUE)
                EndIf
            EndIf
            ProgressBar(c)
           Next c
           If fileKilled Then ReadDir
         EndIf
       EndIf
     Else
       StatusMsg ("Please select a directory to MOVE to!",1)
     EndIf
     Clr sLine
   EndIf

   If keyval=152 Then                  ' Multi delete  F8
     TagC=FALSE
     For c=1To i
       If tag(c) Then TagC=TRUE:Exit For
     Next c
     If TagC=FALSE Then
        StatusMsg ("No items selected!",1)
     Else
       msg$="Okay to delete ALL TAGGED files? <y/n>"
       If Choice(msg$)=1 And i>0 Then
         ProgressBar(FALSE,TRUE)
         Print @(0,sLine)"  deleting ...  <Esc> aborts";
         For c=1 To i
           If tag(c) Then
              If Not KillMFile(f$(c)) Then ' here we delete this file .. or
                If FileExists(f$(c)) Then ' read only?
                  StatusMsg "Error: File exits! Press any key!"
                Else
                  If deselectFlag Then
                    tag(c)=FALSE
                    CrossFN ((c+5) Mod 6+1,(c+5)\6)    ' deselect
                  EndIf
                EndIf
              EndIf
           EndIf
           ProgressBar(c)
           If Inkey$=Chr$(27) Then
              msg$="Abort deleting? <y/n>"
              If Choice(msg$)=1 Then Exit For
           EndIf
         Next c
         ReadDir
       EndIf
     EndIf
   EndIf

   If keyval=127 Then       ' Del - delete files and dirs
     If p>iDir Then         ' must be a file to delete
       msg$="Okay to delete file: "+f$(p)+ "? <y/n>"
       If i>0 Then
         If riskMode Then
           DelFile
         ElseIf Choice(msg$)=1 Then
           DelFile
         EndIf
       EndIf
     ElseIf iDir>0 And p<=iDir Then   ' remove dir
       If DirEmpty(f$(p)) Then
          msg$="Okay to delete this directory: "+f$(p)+ "? <y/n>"
          If riskMode Then
            Rmdir f$(p)
            ReadDir
            p=p0
          ElseIf Choice(msg$)=1 Then
            Rmdir f$(p)
            ReadDir
            p=p0
          EndIf
        Else
          StatusMsg ("Directory not empty!",1)
        EndIf
     EndIf
   EndIf ' end delete

   If p<1 Then p=1
   If p>i Then p=i

   If keyval=013 Then                  ' Enter
      If fExt$ =".bmp" Then
         LoadBMP f$(p)
         waitkey
         Pause 200
         keyval=KeyDown
         ReNewScreen
         p=p0
      ElseIf fExt$ =".txt" Or fExt$ =".csv" Then
         ViewFile
      ElseIf p<=iDir Then
         Timer=0
         Chdir f$(p)
         ReadDir
         Do:Loop While Timer<200  'some waitstates for small dirs
      ElseIf fExt$ =".bas" Then
        If Not riskMode Then
          msg$="Okay to execute file "+f$(p)+"? <y/n>"
          If Choice(msg$)=1 Then Run f$(p)
        Else
          Run f$(p)
        EndIf
      EndIf
   EndIf
'#11
   If keyval>32 And keyval<127 Then   ' move cursor to the F$ with first letter
     For c=p+1 To i                   ' equal keyval
       If Asc(f$(c)) = keyval Then p=c: Exit For
     Next c
   EndIf

   r=(p+5)\6:c=(p+5)Mod 6+1
   invert c,r
   invert c0,r0
   Do:Loop While Timer<70  'some waitstates
   Pause 10
Loop        ' to escape this loop press "Esc"
Clr(sLine)
Print @(0,sLine)MM.Device$
Print "MMBasic v"MM.Ver
Print "FS:"MM.Fname$
Print "Bye!"
End '----------------------------------------------------------
'**************************************************************


Sub ProgressBar prog,init
  If init Then
    Line(MM.HRes/2,MM.VRes-11)-(MM.HRes,MM.VRes-2),1,bf  ' init progressbar
  Else
    Line(MM.HRes-prog*lh/(i+1),st1)-(MM.HRes-2,st2),0,bf ' display progress
  EndIf                ' (i+1) actually only "i", to prevent divide by zero
End Sub


Sub GetWildNames pattern$,select
Local w$(max_i+2) length 12,w,n,wDir

  Clr sLine
  ProgressBar(FALSE,TRUE)
  Print @(0,sLine)"  tagging ...    ("pattern$")";

  w=1
  w$(w) = Dir$(pattern$, DIR)
  If w$(w)="." Then w$(w) = Dir$() ' we don't need the "."
  Do While w$(w) <> "" And w<=max_i
    w=w+1
    w$(w) = Dir$()
  Loop
  wDir=w-1

  w$(w) = LCase$(Dir$(pattern$, FILE))
  Do While w$(w) <> "" And w<=max_i
    For n = 1 To i
      If w$(w)=f$(n) Then
        tag(n)= select  'TRUE or FALSE
        Exit For
      EndIf
    Next n
    w=w+1
    w$(w) = LCase$(Dir$())
    ProgressBar(w)
  Loop
  w=w-1

  ReNewScreen        ' write screen
  p=p0
End Sub


Function DirEmpty dirname$
Local dummy$

  If dirname$<>".." Then
    Chdir dirname$        ' dirname$ must be a valid dir (i>0 & p <iDir)
                          ' and <> ".."

    If Dir$("*.*", DIR)="." Then ' we don't need the "."
       dummy$ = Dir$()           ' we don't need the ".." also
       If Dir$() <> "" Then
          dirEmpty=FALSE  ' we found the first DIR valid entry
       Else               ' if not, are there any files?
          dirEmpty=Dir$("*.*", FILE)="" ' we found the first FILE entry
       EndIf
    EndIf
    Chdir ".."       ' back to the starting dir
  Else
    DirEmpty=FALSE
  EndIf
End Function  ' ----- DirEmpty return: TRUE or FALSE

'#1
Sub ReadDir

  i=1
  overflow=FALSE

  f$(i) = Dir$("*.*", DIR)
  If f$(i)="." Then f$(i) = Dir$() ' we don't need the "."
  Do While f$(i) <> "" And i<=max_i+1
    i=i+1
    f$(i) = Dir$()
    tag(i)= FALSE
  Loop
  iDir=i-1
  If iDir >max_i Then 'check for overflow
    iDir=max_i
    i=iDir
    overflow=TRUE 'too many dirs!
  EndIf

  If iDir Then CombSort(iDir)

  f$(i) = LCase$(Dir$("*.*", FILE))
  Do While f$(i) <> "" And i<=max_i+1
    i=i+1
    f$(i) = LCase$(Dir$())
    tag(i)= FALSE
  Loop

  tagC=FALSE  ' currently no tagged files
  i=i-1

  If i >max_i Then 'check for overflow
    i=max_i
    overflow=TRUE
  EndIf

  fSort=FALSE        ' flag for sorted f$
  If i>0 And i<preSortLimit Then
    CombSort 'incl. ReNewScreen
  Else
    ReNewScreen        ' write screen
  EndIf
End Sub ' ReadDir ------------------------


' graphical mark tagged file names: border
Sub Mark x,y ' hor, vert
  Local h,v
  h=(x*13-13)*6+4:v=y*12-12
  Line(h,v)-(h+12*6+1,v+10),-1,b
End Sub


' cursor for file names
Sub Invert x,y ' hor, vert
  Local h,v
  h=(x*13-13)*6+5:v=y*12-12
  Line(h,v)-(h+12*6,v+10),-1,bf
End Sub


' mark deleted file names
Sub ClearFN x,y ' hor, vert
  Local h,v
  h=(x*13-13)*6+4:v=y*12-12
  Line(h,v)-(h+12*6+1,v+10),0,bf
End Sub


' mark deleted file names
Sub CrossFN x,y ' hor, vert
  Local h,v
  h=(x*13-13)*6+4:v=y*12-12
  Line(h,v)-(h+12*6+1,v+10),-1,b
  Line(h,v)-(h+12*6+1,v+10),1
End Sub


' clear row
Sub Clr vert
  Line(0,vert)-(MM.HRes,vert+12),0,bf
End Sub


Sub WaitKey
  Do:Loop While Inkey$=""
End Sub


' prompt for a choice
Function Choice msg$,answer$
  Local k$
  If answer$="" Then answer$="yn"+Chr$(27)
  Pause 200
  Clr sLine
  Font#1,,1
  Print @(0,sLine)" "msg$;
  Font#1
  Do:k$=LCase$(Inkey$):Loop While Instr(answer$,k$)=0
  Choice=Instr(answer$,k$)
  Clr sLine
  Pause 200 ' to empty keyboard input buffer
End Function


Sub StatusMsg msg$,hold
  Clr sline
  Print @(6,sLine)msg$;
  If hold Then
     Pause hold*1000
  Else
     WaitKey
  EndIf
  Clr sline
End Sub


Sub ViewFile   ' very simple file viewer, Keys: page up/dn, Esc, [s]
Local a$, kp, crPos, fPos
Local pageTop(100),C
' 100 pages to go back

  fPos=1
  C=1
  pageTop(C)=1
  snippCreated=FALSE
  snippExists=FileExists(snp$)

  If p<=iDir Then Exit Sub
  Cls

  Open f$(p) For random As 1
  Seek #1,1
  StatusView pageTop(C),Lof(#1),C

Do
  Do
    a$=Input$(1,#1)

    'If Asc(a$)>=10 And Asc(a$)<127 Then
    Print a$;

    fPos=fPos+1

    ' do we need a new page?
    crPos=MM.HPos =>MM.HRes-1        ' max current cursor pos right

    If MM.VPos >MM.VRes-24 Or (MM.VPos >MM.VRes-36 And crPos) And fPos<Lof(#1) Then
      Do
        Do:kp= KeyDown:Loop While kp=0 Or (C=1 And kp=136)

        If kp=Asc("s") Then
          snippet(f$(p),pageTop(C),fPos)
          StatusView pageTop(C),Lof(#1),C
        EndIf
      Loop While kp=Asc("s")
      If C<=100 Then
        If kp=136 And C>1Then   'page up
          C=C-(C>1)
          fPos=pageTop(C)
          Seek #1,fPos
        Else
          C=C+1
        EndIf
        pageTop(C)=fPos ' just store the old page position
      EndIf
      StatusView fPos,Lof(#1),C
      Line(0,0)-(MM.HRes,MM.VRes-13),0,bf   ' clear screen
    EndIf

  Loop While Not Eof(1) And kp<>27

  If kp=Asc("s") Then
     snippet(f$(p),pageTop(C),fPos)
     StatusView fPos,Lof(#1),C
  EndIf
  If kp<>27 Then ' issue: do loop mit if in einer zeile
     Do:kp= KeyDown:Loop While kp=0
  EndIf
  If kp=136 And C>1 Then  ' we are on last page
     C=C-(C>1)    ' one page back

     fPos=pageTop(C)
     Seek #1,fPos
     Line(0,0)-(MM.HRes,MM.VRes-13),0,bf   ' clear screen
     StatusView fPos,Lof(#1),C
  EndIf
Loop While kp<>27   ' ESC

  Close 1
  Font 1

  If snippCreated Then
    If fSort Then
       ShiftDn p
       f$(p) = snp$
       CombSort
    Else
       readdir
    EndIf
  Else
    ReNewScreen
  EndIf
  p=p0
End Sub


Sub snippet(fN$,top,bottom)
Local c

   If fN$<>"snippet.txt" Then
     snippCreated = Not(snippExists And FileExists("snippet.txt"))

     Open snp$ For append As #3
     Open fN$  For random As #2
     Seek #2,top
     size=bottom-top

     For c=1 To size\250
       Print #3,Input$(250,#2);
     Next c
     If size Mod 250 Then Print #3,Input$(size Mod 250,#2);
     Close #2, #3

     msg$=Str$(size)+" Bytes saved to snippet.txt! Press any key!"
   Else
     msg$="Error: Can't save snippet.txt to itself! Press any key!"
   EndIf
   Clr sLine
   Line(0,sLine)-(MM.HRes,MM.VRes),1,bf   ' inverted status line
   Font #1,,1:Print @(Hcenter(msg$),sLine)msg$;
   Font #1:Print @(0,0);
   WaitKey
   Pause 200
   Clr sLine
End Sub


Sub StatusView fPos,Lof1,C     ' used by ViewFile
   Line(0,sLine)-(MM.HRes,MM.VRes),1,bf   ' inverted status line
   msg$="<Pg Up> & <Pg Dn> and <s> - Exit with <ESC>"
   Font #1,,1:Print @(Hcenter(msg$),sLine)msg$;
   msg$="("+Str$(fPos)+"/"+Str$(Lof1)+")"
   msg$=msg$+Space$(18-Len(msg$))
   Print @(0,sLine)msg$;
   Print @(MM.HRes-66,sLine)"Page: "Str$(C)"   ";
   Font #1:Print @(0,0);
End Sub


Function Hcenter(s$)
  Hcenter=(MM.HRes-Len(s$)*6)/2
End Function

'#2
Sub ReNewScreen ' redraw screen
Local n

  Cls

  If i>0 Then
    Print " ";
    For n=1 To i
      Print Right$("            "+f$(n),12)+" ";
      If tag(n)=TRUE Then Mark((n+5) Mod 6+1,(n+5)\6)
      If n Mod 6 = 0 Then Print:Print " ";
    Next n

    p=1
    r=1 'row
    c=1 'col
    r0=r
    c0=c

    invert c,r
  Else
    msg$="Nothing to display! SD empty? Press any key to abort!"
    Print @(Hcenter(msg$),sLine)msg$;
    WaitKey
  EndIf
  Line(0,MM.VRes-13)-(MM.HRes,MM.VRes-13),1,bf
End Sub

Sub CombSort dirSort
Local n
Local b, e ' begin, end
Local G,S,sw 'Gap,Shrink,Swapped
Local z, z$ length 12 ' for swapping

  Clr sLine
  Print @(0,sLine)"  sorting ...";

  b=iDir+1:e=i
  If dirSort Then
    b=1:e=dirSort
  EndIf
  ProgressBar(FALSE,TRUE)
'#22
  G=e
  S=1.3
Timer=0
Do While (G>1 Or Sw)
 G=Int(G/S)
 If G<1 Then G=1
 n=b
 sw=0
 Do While n+G <=e
  If f$(n)>f$(n+G) Then
   Z$=f$(n):z=tag(n)
   f$(n)=f$(n+G):tag(n)=tag(n+G)
   f$(n+G)=Z$:tag(n+G)=z
   Sw=1
  EndIf
  n=n+1
 Loop
 ProgressBar(i-G^2)
Loop
  fSort=TRUE

  ' End Combsort --------------------------
  ' re-display sorted array of file names
tx= Timer

  ReNewScreen
End Sub



Sub Help
Local riskModeText$(2)
Local deSelectText$(2)
Local key$, T0$,T1$

If ds3231_avail Then readtime

 riskModeText$(1)=" OFF"
 riskModeText$(2)=" ON " ' TRUE +1
 deSelectText$(1)=" OFF"
 deSelectText$(2)=" ON " ' TRUE +1
 Cls
 Do
  Print @(0,0);
  Print "-----------------------------------------------------------------"
  Print " File selector " Left$(ProgVer$+"  ",5)+"(by twofingers@TBS) [D]"Date$" [T]"Time$
  Print "-----------------------------------------------------------------"
  Print " Operation keys:"
  Print " 4 arrow keys, <Home>, <End> - cursor positioning"
  Print " Ascii keys find the resp. files: positioning"
  Print " <Del> deletes files and remove (empty!) directorys"
  Print " <Enter> execute BAS file, show text and BMP files"
  Print " - <ESC> returns immediately from view text mode. ->F3"
  Print " <Insert> copies single files"
  Print " <Space> selects files, <TAB> moves to root dir"
  Print " F1  This help page (Setup [T]ime & [D]ate)"
  Print " F2  Rename (single files or directorys)"
  Print " F3  ViewFile (page up/dn to navigate) [s]=save snippet"
  Print " F4  Sort files"
  Print " F5  MULTI Copy (selected files to specific dir). <Esc> aborts"
  Print " F6  Make dir (create a new directory)"
  Print " F7  MULTI Move files (copy + kill). <Esc> aborts"
  Print " F8  MULTI Kill/Delete for selected files. <Esc> aborts"
  Print " F9  & [+] Select (for files, use wildcards)"
  Print " F10 & [-] Deselect (dito), F11 & [*] Reverses selection"
  Print " F12 runs B:\FS (hopefully this program) to restart."
  Print " <CTRL>+<x> quits this program"
  Print "-----------------------------------------------------------------"
  Print " Auto DeSelect is " deSelectText$(deSelectFlag+1)" (toggle with [*])"
  Print " Risk mode is     " riskModeText$(riskMode+1) " (toggle with [+])"
  Print
  Print " If risk mode is turned ON then it does not need"
  Print " a confirmation before the delete and execute."
  Print "-----------------------------------------------------------------"
  Print " Limit: This program handles only"max_i" items/directorys."
  Print "        If there are more than"max_i", then a bar appears on"
  Print "        the right. If there are no files on SD the program quits."
  Print "        Presort limit:"preSortLimit" files."
  Print "-----------------------------------------------------------------";

  Pause 200
  key$=Inkey$
  If key$="+" Then riskMode=Not riskMode:key$=""
  If UCase$(key$)="D" Then ' set date
     Print @(258,12);
     Date$=MaskEdit$(Date$,1,DM$)
     'RTC settime ...,...,...
     If ds3231_avail Then SetTime '  for DS3231
     key$=""
  EndIf
  If UCase$(key$)="T" Then ' set time
     Do
       Print @(342,12);
       t0$=Time$
       t1$=t0$
       T1$=MaskEdit$(T0$,1,TM$)
     Loop While Not ValidTime(t1$)
     If t0$<>t1$ Then
       Time$=t1$ 'not escaped from MaskEdit$
       'RTC settime ...,...,...
       If ds3231_avail Then SetTime '  for DS3231
     EndIf
     key$=""
  EndIf
  If key$="*" Then ' autoDeSelect
     deSelectFlag=Not deSelectFlag
     key$=""
  EndIf

 Loop While key$=""
 ReNewScreen ' back to the main screen

End Sub ' --- end help ----


Function ValidTime tm$
  Local legal(3),i
  legal(1)=23
  legal(2)=59
  legal(3)=59
  ValidTime=TRUE
  For i = 1 To 7 Step 3 '1,4,7
    If Val(Mid$(tm$,i,2))>legal(i\3+1) Then ValidTime=FALSE: Exit For
  Next i
End Function


'*************************************************
'*
'*             MASKEdit$ V.95
'*           mod of LineEdit()
'*         MMBasic 4.5/Maximite
'*
'* line editor for small strings (e.g. file names
'* time$, date$ ...)
'* MASKEdit$("12:45:56",1,"##.##.##")
'* MASKEdit$("    TEST.BAS",1,"        .   ")
'* Special mask characters:
'* " " any ascii character
'* "#" any number(0-9)
'* "." skip char will be ignored/skipped
'* "@" numbers & letters (not yet implemented!)
'* Used functions: FindLeft,FindRight,IsNum
'* Limit:
'* The string must not exceed the width of screen
'*------------------------------------------------
Function MaskEdit$ edText$, cursorp, edMask$
Local hpos, vpos, p, ep, keyvalue, enterPressed
Local text$,ltext$,mtext$,rtext$,C$,M$,Mask$
Local TRUE, FALSE

  TRUE=1
  FALSE=0
  hpos=MM.HPos:vpos=MM.VPos ' save print position
  text$=edText$             ' use local copy of text$ string
  MaskEdit$=edText$         ' backup edText$ for Esc
  enterPressed=FALSE        ' Flag to EXIT the loop
  escPressed=FALSE          ' a Global var
  ep=Len(text$)             ' end pointer
  C$="."                    ' prohibited/skipped char
  p=cursorp:If Not p Then p=1 ' cursor pointer
  Mask$=edMask$             ' local copy

  If ep<>Len(Mask$) Then Mask$=Space$(ep)
  Pause 200 ' es gibt einen Zeitfaktor fuer keyboard input buffer ~140ms

  ltext$=Mid$(text$,1,p-1)
  mtext$=Mid$(text$,p,1)
  rtext$=Mid$(text$,p+1,ep-p)

  Print @(hpos,vpos)ltext$;
  Font#1,,1
  Print mtext$;
  Font#1
  Print rtext$;

  Do
    Do:keyvalue=KeyDown:Pause 50:Loop While keyvalue=0

    If keyvalue=130 And p>1 Then
      p=FindLeft(Mask$,C$,p)      'p=p-1  'left arrow
    EndIf
    If keyvalue=131 And p<ep Then 'p=p+1  'right arrow
      p=FindRight(Mask$,C$,p)
    EndIf
    If keyvalue=13 Then
       enterPressed=TRUE                  'Enter
    EndIf
    If keyvalue=27 Then                   'Esc
       Print @(hpos,vpos)MaskEdit$;
       escPressed=TRUE
    EndIf
    If keyvalue=134 Then                  'Home
       p=1
       If Mid$(text$,p,1)=C$ Then
          p=FindLeft(Mask$,C$,p)
       EndIf
    EndIf
    If keyvalue=135 Then                  'End
       p=ep
       If Mid$(text$,p,1)=C$ Then
          p=FindRight(Mask$,C$,p)
       EndIf
    EndIf

    If keyvalue>=32 And keyvalue<127 Then 'all ASCII chars
        M$= Mid$(Mask$,p,1)

        If m$=" " Or (m$="#" And IsNum(Chr$(keyvalue))) Then    ' num mask, only numbers
          If p<ep Then
            ltext$=ltext$+Chr$(keyvalue)
            If Mid$(Mask$,p+1,1)=C$ Then ltext$=ltext$+Mid$(Text$,p+1,1)
            p=FindRight(Mask$,C$,p)
            mtext$=Mid$(text$,p,1)
            rtext$=Mid$(text$,p+1)
          Else
            ltext$=Left$(text$,p-1)
            mtext$=Chr$(keyvalue)
            rtext$=""
          EndIf
        EndIf

    ElseIf keyvalue=132 Then       'insert, when dot is on the right _and_
      If mask$="        .   " And p<9 Then ' mask$="        .   "
        mtext$=" "
        ltext$=Mid$(text$,2,p-1)
      EndIf
    ElseIf keyvalue=127 Then              'Del
      If mask$="        .   " And p<9 Then ' mask$="        .   "
        If p>1 Then
          mtext$=Mid$(text$,p-1,1)
          ltext$=" "+Mid$(text$,1,p-2)
        Else
          mtext$=" "
        EndIf
      EndIf
    ElseIf keyvalue=8 And p>1 Then         'Bsp, delete left space
      p=FindLeft(Mask$,C$,p)
      mtext$=" "
      ltext$=Mid$(text$,1,p-1)
      rtext$=Mid$(text$,p+1)
    Else
      If p>=ep Then p=ep
      ltext$=Mid$(text$,1,p-1)          'move cursor / over write
      mtext$=Mid$(text$,p,1)
      rtext$=Mid$(text$,p+1,ep-p)
    EndIf

    Print @(hpos,vpos)ltext$;
    Font#1,,1
    Print mtext$;
    Font#1
    Print rtext$;

    text$=Left$(ltext$+mtext$+rtext$,ep)

    Pause 125 ' some wait states to slow down key input
  Loop While Not enterPressed And Not escPressed
  If Not escPressed Then
    MaskEdit$=ltext$+mtext$+rtext$
    Print @(hpos,vpos)MaskEdit$;
  EndIf
End Function
'*****************************************************


Function IsNum(Num$)
  IsNum=(Asc(Num$)>=48) And (Asc(Num$)<58)
End Function


Function FindRight(S$,C$,p)
Local i
 If p<=Len(S$) Then
   For i = p+1 To Len(S$)
    If Mid$(s$,i,1)<>C$ Then Exit For
   Next i
 EndIf
 If i=0 Then i=p
 FindRight=i
End Function


Function FindLeft(S$,C$,p)
Local i
 If p>1 Then
   For i = p-1 To 1 Step-1
    If Mid$(s$,i,1)<>C$ Then Exit For
   Next i
 EndIf
 If i=0 Then i=p
 FindLeft=i
End Function
'--^^^^^^^ used by MaskEdit ^^^^^^--



'
' Remove any spaces from string
' and trailing dot (for legal mm.filenames)
'
Function InTrim$(X$)
Local I
  For I=1 To Len(X$)
    If Mid$(X$,I,1)<>" " Then
      InTrim$=InTrim$+Mid$(X$,I,1)
    EndIf
  Next I
  ' some extra treatment for file names
  If Right$(InTrim$,1)="." Then InTrim$=Left$(InTrim$,Len(InTrim$)-1)
End Function


Function GetFNError N$ 'used by rename
  Option Error Continue
  Open N$ For Input As #10
  GetFNError = MM.Errno
  If MM.Errno=0 Then Close #10
  Option Error Abort
End Function


Function FileExists N$
  Option error continue
  Open N$ For input As #10
  If MM.Errno=0 Then
    FileExists=TRUE
    Close #10
  Else
    FileExists=FALSE
  EndIf
  Option error abort
End Function


Function DirExists N$
Local Temp$
  Option error continue
  Temp$=Dir$(N$, DIR)
  If Temp$<>"" And MM.Errno=0 Then
    DirExists=TRUE
  Else
    DirExists=FALSE
  EndIf
  Option error abort
End Function


Function FileSize N$
  Local OpenError
  If n$<>".." Then
    Option Error Continue
    Open N$ For input As #10
    OpenError = MM.Errno
    Option Error Abort
    If OpenError Then
      StatusMsg ("OpenError: "+errText$(OpenError))
      FileSize=0
    Else
      FileSize=Lof(10)
      Close 10
    EndIf
  Else
    FileSize=0
  EndIf
End Function


' shifts array elements for insert a new one
Sub ShiftUp fPos  '5=6,6=7,7=8,...
  Local c
  If i>0 Then
    i=i-1
    For c = fPos To i
      f$(c)=f$(c+1)
      tag(c)=tag(c+1)
    Next c
  EndIf
End Sub


' shifts array elements down
Sub ShiftDn fPos  '6=5,7=6,8=7,...
  Local c
  If i<max_i Then
    i=i+1
    For c = i To fPos Step-1
      f$(c+1)=f$(c)
      tag(c+1)=tag(c)
    Next c
  EndIf
End Sub

'#3
Sub FileCopy overwrite
Local CopyError

  If f$(p) = newF$ Then ' MMBasic v4.5 bug?
     CopyError=17       ' there is no Error 17 in MMBasic
  Else
    Option Error Continue
    Copy f$(p) To newF$
    CopyError = MM.Errno
    Option Error Abort
  EndIf
  If CopyError Then
    Clr(sLine)
    StatusMsg("Copy Error: "+errText$(CopyError))+". Press any key!"
  ElseIf FileSize(f$(p))<>FileSize(newF$) Then
    StatusMsg("Verify Error! Press any key!")
  Else
    If Not overwrite Then
      If fSort Then       'fSort = flag for sorted f$() array
         ShiftDn p
         f$(p) = newF$
         CombSort
         p=p0
      Else
         readdir
         p=p0
      EndIf
    EndIf
  EndIf
End Sub


Function KillMFile(file2kill$) 'used by multi delete and DelFile
  Option Error Continue
  Kill file2kill$
  KillMFile = MM.Errno
  Option Error Abort
  If KillMFile Then
     StatusMsg "Kill Error: "+errText$(KillMFile)
  EndIf
End Function


Sub DelFile ' del
  If fSort And Not KillMFile(f$(p)) Then 'fSort = flag for sorted f$() array
     ShiftUp p
     CombSort
  Else
     ReadDir
  EndIf
  p=p0
End Sub


Function FNFormat$ fTemp$,noDot    ' File name format
Local fT$,ip,Ext$(2)               ' maskedit needs the dot
ext$(1)=".   "
ext$(2)="    "
   fT$="        "+fTemp$
   ip=Instr(fT$,".")
   If ip Then
      fT$=Mid$(fT$+"   ",ip-8,12)
   Else
      fT$=Right$(fT$+Ext$(1+noDot),12)
   EndIf
   FNFormat$=fT$
End Function ' returns a formated file name 8+3


Function ShortPath$ path$
ShortPath$=path$
  If Len(ShortPath$)>35 Then
    tl$=Left$(ShortPath$,Instr(18,ShortPath$,"\"))+"^?^\"
    tr$=Mid$(ShortPath$,Instr(Len(ShortPath$)-15,ShortPath$,"\")+1)
    ShortPath$=tl$+tr$
  Else
    If ShortPath$="B:\" Then ShortPath$="B:"
  EndIf
End Function
